/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.cal.app.AbstractBillTransferFacadeControllerBean;
import com.kingdee.eas.ma.cal.app.transferbill.BillTransfer;
import com.kingdee.eas.ma.cal.app.transferbill.TransferBillSQLBuilder;
import com.kingdee.eas.ma.cal.app.transferbill.TransferRuleSqlBuilder;
import com.kingdee.eas.ma.cal.app.utils.CalUtils;
import com.kingdee.eas.ma.scmcommon.TaskProgressFacadeFactory;
import com.kingdee.eas.ma.scmcommon.tools.SQLUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BillTransferFacadeControllerBean
extends AbstractBillTransferFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.cal.app.BillTransferFacadeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _transferBill(Context ctx, Map params) throws BOSException, EASBizException {
        String parentTaskid = (String)params.get("parentTaskid");
        try {
            BillTransfer billTransfer = new BillTransfer(ctx);
            billTransfer.execute(params);
        }
        finally {
            HashMap<String, Object> updateMap = new HashMap<String, Object>();
            updateMap.put("TaskID", parentTaskid);
            updateMap.put("Status", 9);
            updateMap.put("Complete", 100);
            TaskProgressFacadeFactory.getLocalInstance((Context)ctx).updateProgress(updateMap);
        }
    }

    @Override
    protected void _cancel(Context ctx, String taskid) throws BOSException, EASBizException {
        List tasks = TaskProgressFacadeFactory.getLocalInstance((Context)ctx).getSubTaskProgress(taskid);
        String[] taskids = new String[tasks.size()];
        Map task = null;
        int size = tasks.size();
        for (int i = 0; i < size; ++i) {
            task = (Map)tasks.get(i);
            taskids[i] = (String)task.get("ID");
        }
        TaskProgressFacadeFactory.getLocalInstance((Context)ctx).abortTask(taskid);
    }

    @Override
    protected Map _extendQuery(Context ctx, Map params) throws BOSException, EASBizException {
        return params;
    }

    @Override
    protected void _transfer(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> updateMap = null;
        String profitCenterid = null;
        String sourcebilltypeid = null;
        profitCenterid = params.get("profitCenterid").toString();
        sourcebilltypeid = params.get("sourceBillTypeid").toString();
        TransferRuleSqlBuilder ruleSql = (TransferRuleSqlBuilder)params.get("ruleSql");
        PeriodInfo periodInfo = (PeriodInfo)params.get("periodInfo");
        Set storageOrgUnitidset = (Set)params.get("storageOrgUnitidset");
        String taskId = (String)params.get("taskId");
        String transferType = (String)params.get("transferType");
        ProfitCenterOrgUnitInfo profitCenter = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterid));
        String cuid = profitCenter.getCU().getId().toString();
        CompanyOrgUnitInfo company = CalUtils.getCompanyOrgUnit(ctx, profitCenterid, 6);
        String baseCurrencyID = "";
        if (company != null) {
            baseCurrencyID = company.getBaseCurrency().getId().toString();
        }
        updateMap = new HashMap<String, Object>();
        updateMap.put("TaskID", taskId);
        updateMap.put("Remark", profitCenterid + sourcebilltypeid);
        boolean issucess = this.checkData(ctx, ruleSql, periodInfo, updateMap, storageOrgUnitidset);
        if (!issucess) {
            return;
        }
        updateMap.put("Complete", 10);
        TaskProgressFacadeFactory.getLocalInstance((Context)ctx).updateProgress(updateMap);
        Date beginData = periodInfo.getBeginDate();
        Date endData = CalUtils.getDate(periodInfo.getEndDate(), 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String storageOrgIds = CalUtils.arrayToString(storageOrgUnitidset.toArray());
        HashMap<String, Object> sqlBuilderParams = new HashMap<String, Object>();
        sqlBuilderParams.put("ruleSql", ruleSql);
        sqlBuilderParams.put("sourcebilltypeid", sourcebilltypeid);
        sqlBuilderParams.put("profitCenterid", profitCenterid);
        sqlBuilderParams.put("cuid", cuid);
        sqlBuilderParams.put("baseCurrencyID", baseCurrencyID);
        sqlBuilderParams.put("storageOrgIds", storageOrgIds);
        sqlBuilderParams.put("beginData", sdf.format(beginData));
        sqlBuilderParams.put("endData", sdf.format(endData));
        sqlBuilderParams.put("periodID", periodInfo.getId().toString());
        sqlBuilderParams.put("transferType", transferType);
        TransferBillSQLBuilder sqlBuilder = new TransferBillSQLBuilder(ctx, sqlBuilderParams);
        if ("remove".equals(transferType)) {
            SQLUtils.execute((Context)ctx, (String)sqlBuilder.getDeleteSQL(), (Object[])new Object[]{profitCenterid, sourcebilltypeid, sdf.format(beginData), sdf.format(endData)});
        } else if ("increment".equals(transferType)) {
            SQLUtils.execute((Context)ctx, (String)sqlBuilder.getDeleteNotIncludeSQL(), (Object[])new Object[]{profitCenterid, sourcebilltypeid, sdf.format(beginData), sdf.format(endData)});
            SQLUtils.execute((Context)ctx, (String)sqlBuilder.getDeleteIncludeSQL(), (Object[])new Object[]{profitCenterid, sourcebilltypeid, sdf.format(beginData), sdf.format(endData)});
        } else if ("update".equals(transferType)) {
            SQLUtils.execute((Context)ctx, (String)sqlBuilder.getDeleteIncludeSQL(), (Object[])new Object[]{profitCenterid, sourcebilltypeid, sdf.format(beginData), sdf.format(endData)});
        }
        updateMap.put("Complete", 30);
        TaskProgressFacadeFactory.getLocalInstance((Context)ctx).updateProgress(updateMap);
        String sql = sqlBuilder.getImportIssueBillSQL();
        int issueBillCount = SQLUtils.execute((Context)ctx, (String)sql);
        updateMap.put("Complete", 70);
        TaskProgressFacadeFactory.getLocalInstance((Context)ctx).updateProgress(updateMap);
        sql = sqlBuilder.getImportInWarehsBillSQL();
        int inWarehsCount = SQLUtils.execute((Context)ctx, (String)sql);
        if ("update".equals(transferType)) {
            SQLUtils.execute((Context)ctx, (String)sqlBuilder.getUpdateCostSQL(), (Object[])new Object[]{profitCenterid, sourcebilltypeid, sdf.format(beginData), sdf.format(endData)});
            SQLUtils.execute((Context)ctx, (String)sqlBuilder.getUpdateFlagSQL());
        }
        updateMap.put("Status", 9);
        updateMap.put("Complete", 100);
        updateMap.put("Description", issueBillCount + inWarehsCount);
        TaskProgressFacadeFactory.getLocalInstance((Context)ctx).updateProgress(updateMap);
    }

    private boolean checkData(Context ctx, TransferRuleSqlBuilder rulesql, PeriodInfo periodInfo, Map<String, Object> updateMap, Set storageOrgUnitidset) throws BOSException, EASBizException {
        if (periodInfo == null) {
            updateMap.put("Status", -1);
            updateMap.put("Complete", 0);
            updateMap.put("Description", EASResource.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"periodInfo_is_null", (Locale)ctx.getOriginLocale()));
            TaskProgressFacadeFactory.getLocalInstance((Context)ctx).updateProgress(updateMap);
            return false;
        }
        if (rulesql == null) {
            updateMap.put("Status", -1);
            updateMap.put("Complete", 0);
            updateMap.put("Description", EASResource.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"rulesql_is_null", (Locale)ctx.getOriginLocale()));
            TaskProgressFacadeFactory.getLocalInstance((Context)ctx).updateProgress(updateMap);
            return false;
        }
        if (storageOrgUnitidset == null || storageOrgUnitidset.size() == 0) {
            updateMap.put("Complete", 100);
            updateMap.put("Status", 3);
            updateMap.put("Description", EASResource.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"storageOrgUnitid_is_null", (Locale)ctx.getOriginLocale()));
            TaskProgressFacadeFactory.getLocalInstance((Context)ctx).updateProgress(updateMap);
            return false;
        }
        return true;
    }
}

