/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.cal.app.AbstractDispatchSubLedgerControllerBean;
import com.kingdee.eas.ma.scmcommon.tools.SQLUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DispatchSubLedgerControllerBean
extends AbstractDispatchSubLedgerControllerBean {
    private static final long serialVersionUID = 6758053501494841447L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.cal.app.DispatchSubLedgerControllerBean");

    @Override
    protected Map _query(Context ctx, Map queryParam) throws BOSException, EASBizException {
        String tempTable = null;
        try {
            HashMap<String, Object> filterParam;
            HashMap<String, Object> result = new HashMap<String, Object>();
            Boolean isNewQuery = (Boolean)queryParam.get("isNewQuery");
            result.put("isNewQuery", isNewQuery);
            Object temp = queryParam.get("tempTable");
            if (temp != null) {
                tempTable = temp.toString();
            }
            if ((filterParam = (HashMap<String, Object>)queryParam.get("filterParam")) == null) {
                filterParam = new HashMap<String, Object>();
            }
            boolean isQueryMaterial = Boolean.valueOf(queryParam.get("isQueryMaterial").toString());
            Map currentMaterial = new HashMap();
            if (isNewQuery.booleanValue()) {
                if (tempTable != null && tempTable.length() != 0) {
                    this.releaseTempTable(ctx, tempTable);
                }
                String tableSql = this.getTempleTableSql(ctx);
                tempTable = this.createTempTable(ctx, tableSql);
                filterParam.put("tempTable", tempTable);
                this.insertTempTable(ctx, tempTable, filterParam);
                List materialCol = this.getMaterialCol(ctx, tempTable);
                result.put("materialCol", materialCol);
                if (materialCol == null || materialCol.size() == 0) {
                    this.releaseTempTable(ctx, tempTable);
                    result.put("rows", null);
                    result.put("page", 0);
                    result.put("records", 0);
                    result.put("total", 0);
                    return result;
                }
                currentMaterial = (Map)materialCol.get(0);
                filterParam.put("currentMaterial", currentMaterial);
            } else {
                currentMaterial = (Map)queryParam.get("currentMaterial");
                filterParam.put("currentMaterial", currentMaterial);
                if (!isQueryMaterial) {
                    String profitCenterId = queryParam.get("profitCenterId").toString();
                    int periodFrom = Integer.valueOf(queryParam.get("periodFrom").toString());
                    int periodTo = Integer.valueOf(queryParam.get("periodTo").toString());
                    filterParam.put("profitCenterId", profitCenterId);
                    filterParam.put("periodFrom", periodFrom);
                    filterParam.put("periodTo", periodTo);
                }
            }
            if (!isQueryMaterial) {
                this.setDataToTable(ctx, tempTable, filterParam);
                this.countRemain(ctx, tempTable, filterParam);
            }
            int page = Integer.valueOf(queryParam.get("page").toString());
            int rows = Integer.valueOf(queryParam.get("rows").toString());
            filterParam.put("start", rows * (page - 1));
            filterParam.put("rows", rows);
            List<Map<String, String>> data = this.doBizQuery(ctx, tempTable, filterParam, false);
            int totalRowCount = this.getTotalRowCount(ctx, tempTable, filterParam);
            int total = totalRowCount / rows;
            if (total * rows < totalRowCount) {
                ++total;
            }
            result.put("tempTable", tempTable);
            result.put("currentMaterial", currentMaterial);
            result.put("rows", data);
            result.put("page", page);
            result.put("records", totalRowCount);
            result.put("total", total);
            return result;
        }
        catch (Exception e) {
            if (tempTable != null) {
                this.releaseTempTable(ctx, tempTable);
            }
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _queryAllData(Context ctx, Map queryParam) throws BOSException, EASBizException {
        HashMap filterParam;
        HashMap<String, List<Map<String, String>>> result = new HashMap<String, List<Map<String, String>>>();
        String tempTable = null;
        Object temp = queryParam.get("tempTable");
        if (temp != null) {
            tempTable = temp.toString();
        }
        if ((filterParam = (HashMap)queryParam.get("filterParam")) == null) {
            filterParam = new HashMap();
        }
        Map currentMaterial = new HashMap();
        List materialCol = this.getMaterialCol(ctx, tempTable);
        currentMaterial = (Map)materialCol.get(0);
        filterParam.put("currentMaterial", currentMaterial);
        List<Map<String, String>> data = this.doBizQuery(ctx, tempTable, filterParam, true);
        result.put("rows", data);
        return result;
    }

    @Override
    protected void _releaseTempTable(Context ctx, String tempTable) throws BOSException, EASBizException {
        if (tempTable == null || tempTable.trim().length() == 0) {
            return;
        }
        TempTablePool tmpTblPool = TempTablePool.getInstance((Context)ctx);
        try {
            tmpTblPool.releaseTable(tempTable);
        }
        catch (Exception e) {
            throw new BOSException("cannot release tempTable", (Throwable)e);
        }
    }

    @Override
    protected List<String> _getMaterialFilterByOrgId(Context ctx, String profitCenterId) throws BOSException, EASBizException {
        String companyUnitId = this.getRelatedCompanyIds(ctx, profitCenterId);
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select c.FMaterialID from T_BD_MaterialCompanyInfo as c");
        sql.append(" where c.FCompanyID = '").append(companyUnitId).append("'");
        sql.append(" and c.FStatus = 1");
        sql.append(" and c.FID in (select distinct a.FMaterialID from T_CAL_InvAccountBill as a)");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String materialID = rs.getString("FMaterialID");
                list.add(materialID);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    @Override
    protected List _getMaterialCol(Context ctx, String tempTable) throws BOSException, EASBizException {
        String locale = ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct m.FID as id,m.FNumber as number,m.FName_").append(locale);
        sql.append(" as name,m.FModel as model,m.FShortName as shortName,u.FName_").append(locale);
        sql.append(" as baseUnit from T_BD_Material as m left join T_BD_Measureunit as u ");
        sql.append(" on m.FBaseUnit = u.FID where m.FID in ");
        sql.append(" (select distinct FMaterialID from " + tempTable);
        sql.append(" ) order by number");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            ArrayList material = new ArrayList();
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", rs.getString("id"));
                map.put("number", rs.getString("number") == null ? "" : rs.getString("number"));
                map.put("name", rs.getString("name") == null ? "" : rs.getString("name"));
                map.put("model", rs.getString("model") == null ? "" : rs.getString("model"));
                map.put("shortName", rs.getString("shortName") == null ? "" : rs.getString("shortName"));
                map.put("baseUnit", rs.getString("baseUnit") == null ? "" : rs.getString("baseUnit"));
                material.add(map);
            }
            return material;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static List<String> getStorageOrgUnitIds(Context ctx, String profitCenterId) throws BOSException, EASBizException {
        ArrayList<String> list = new ArrayList<String>();
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection orgCol = iUnitRel.getFromUnit(profitCenterId, 4, 6);
        int size = orgCol.size();
        for (int i = 0; i < size; ++i) {
            list.add(orgCol.get(i).toString());
        }
        return list;
    }

    public String getRelatedCompanyIds(Context ctx, String profitCenterId) throws BOSException, EASBizException {
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iUnitRel.getToUnit(profitCenterId, 6, 1);
        String companyUnitId = null;
        if (orgCol.size() > 0) {
            companyUnitId = orgCol.get(0).getId().toString();
        }
        return companyUnitId;
    }

    private StringBuffer structureIDCol(List<String> params) {
        StringBuffer ids = new StringBuffer();
        if (params == null || params.size() == 0) {
            ids.append("('')");
        } else {
            int size = params.size();
            for (int i = 0; i < size; ++i) {
                if (i == 0) {
                    ids.append("('").append(params.get(i)).append("'");
                    continue;
                }
                ids.append(",'").append(params.get(i)).append("'");
            }
            ids.append(")");
        }
        return ids;
    }

    private String createTempTable(Context ctx, String sql) throws BOSException {
        String tblName = null;
        TempTablePool tmpTblPool = TempTablePool.getInstance((Context)ctx);
        try {
            tblName = tmpTblPool.createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException("cannot create tempTable", (Throwable)e);
        }
        return tblName;
    }

    protected String getTempleTableSql(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" CREATE TABLE TEMP_TABLE_0 ");
        sql.append("(FID VARCHAR(44) NOT NULL,");
        sql.append("FIndex INT DEFAULT 0,");
        sql.append("FYear INT,");
        sql.append("FPeriod INT,");
        sql.append("FBizDate DATETIME,");
        sql.append("FBillType VARCHAR(44) NOT NULL,");
        sql.append("FBillTypeName VARCHAR(255),");
        sql.append("FSourceBillID VARCHAR(44),");
        sql.append("FBillNumber VARCHAR(80),");
        sql.append("FTransactionTypeName VARCHAR(255),");
        sql.append("FLot VARCHAR(255),");
        sql.append("FAssistantAttrName VARCHAR(255),");
        sql.append("FProjectNumber NVARCHAR(80),");
        sql.append("FProjectName NVARCHAR(255),");
        sql.append("FTrackNumber NVARCHAR(80),");
        sql.append("FTrackName NVARCHAR(255), ");
        sql.append("FInQty NUMERIC(21,8) default 0,");
        sql.append("FInUnitPrice NUMERIC(21,8) default 0,");
        sql.append("FInAmount NUMERIC(17,4) default 0,");
        sql.append("FOutQty NUMERIC(21,8) default 0,");
        sql.append("FOutUnitPrice NUMERIC(21,8) default 0,");
        sql.append("FOutAmount NUMERIC(17,4) default 0,");
        sql.append("FRemainQty NUMERIC(21,8) default 0,");
        sql.append("FRemainUnitPrice NUMERIC(21,8) default 0,");
        sql.append("FRemainAmount NUMERIC(17,4) default 0,");
        sql.append("FRemark NVARCHAR(400),");
        sql.append("FMaterialID VARCHAR(44), ");
        sql.append("FStorageOrgUnitID NVARCHAR(44), ");
        sql.append("FWarehouseID NVARCHAR(44), ");
        sql.append("FQtyPrecision INT, ");
        sql.append("FAmtPrecision INT,");
        sql.append("FPricePrecision INT");
        sql.append(")");
        return sql.toString();
    }

    public void insertTempTable(Context ctx, String tempTable, Map filterParam) throws BOSException, EASBizException {
        Object combo_billType;
        List warehouseCol;
        List storageOrgUnitCol;
        String locale = ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(tempTable);
        sql.append(" (FID,FIndex,FYear,FPeriod,FBizDate,FBillType,FBillTypeName,FSourceBillID,FBillNumber, ");
        sql.append(" FTransactionTypeName,FLot,FAssistantAttrName,FProjectNumber,FProjectName,");
        sql.append(" FTrackNumber,FTrackName,FInQty,FInUnitPrice,FInAmount,FOutQty,FOutUnitPrice,");
        sql.append(" FOutAmount,FRemainQty,FRemainUnitPrice,FRemainAmount,FRemark,FMaterialID, ");
        sql.append(" FStorageOrgUnitID,FWarehouseID,FQtyPrecision,FAmtPrecision,FPricePrecision)");
        sql.append(" (select newbosid('DISPATCH') as FID,");
        sql.append("  0 as FIndex,");
        sql.append(" per.FPeriodYear as FYear,");
        sql.append(" per.FPeriodNumber as FPeriod,");
        sql.append(" inv.FBizDate as FBizDate,");
        sql.append(" inv.FSourceBillTypeID as FBillType,");
        sql.append(" billtype.FName_").append(locale).append(" as FBillTypeName,");
        sql.append(" inv.FSourceBillID as FSourceBillID,");
        sql.append(" inv.FSourceBillNumber as FBillNumber,");
        sql.append(" tra.FName_").append(locale).append(" as FTransactionTypeName,");
        sql.append(" inv.FLot as FLot,");
        sql.append(" a.FName_").append(locale).append(" as FAssistantAttrName,");
        sql.append(" project.FNumber as FProjectNumber,");
        sql.append(" project.FName_").append(locale).append(" as FProjectName,");
        sql.append(" track.FNumber as FTrackNumber,");
        sql.append(" track.FName_").append(locale).append(" as FTrackName,");
        sql.append(" (case when inv.FOutOrInWareHouse = 20 then round(inv.FBaseQty,unit.FQtyPrecision) else 0 end) as FInQty,");
        sql.append(" (case when (inv.FOutOrInWareHouse != 20 or isNull(inv.FBaseQty,0) = 0) then 0 else round(decimal(inv.FCost,17,4)/decimal(inv.FBaseQty,21,8),m.FPricePrecision) end) as FInUnitPrice,");
        sql.append(" (case when inv.FOutOrInWareHouse = 20 then round(inv.FCost,cur.FPrecision) else 0 end) as FInAmount,");
        sql.append(" (case when inv.FOutOrInWareHouse = 10 then round(inv.FBaseQty,unit.FQtyPrecision) else 0 end) as FOutQty,");
        sql.append(" (case when (inv.FOutOrInWareHouse != 10 or isNull(inv.FBaseQty,0) = 0) then 0 else round(decimal(inv.FCost,17,4)/decimal(inv.FBaseQty,21,8),m.FPricePrecision) end) as FOutUnitPrice,");
        sql.append(" (case when inv.FOutOrInWareHouse = 10 then round(inv.FCost,cur.FPrecision) else 0 end) as FOutAmount,");
        sql.append(" 0 as FRemainQty,");
        sql.append(" 0 as FRemainUnitPrice,");
        sql.append(" 0 as FRemainAmount,");
        sql.append(" inv.FDescription as FRemark,");
        sql.append(" inv.FMaterialID as FMaterialID,");
        sql.append(" inv.FStorageOrgUnitID as FStorageOrgUnitID,");
        sql.append(" inv.FWarehouseID as FWarehouseID, ");
        sql.append(" unit.FQtyPrecision as FQtyPrecision,");
        sql.append(" cur.FPrecision as FAmtPrecision,");
        sql.append(" m.FPricePrecision as FPricePrecision");
        sql.append(" from T_CAL_InvAccountBill inv ");
        sql.append(" inner join T_BD_Period per on inv.FPeriodID = per.FID ");
        sql.append(" left join T_SCM_TransactionType tra on inv.FTransactionTypeID = tra.FID ");
        sql.append(" left join T_BD_Material m on m.fid = inv.FMaterialId");
        sql.append(" left join T_BD_AsstAttrValue a on inv.FAssistPropertyID = a.FID ");
        sql.append(" left join T_MM_Project project on inv.FProjectID = project.FID ");
        sql.append(" left join T_MM_TrackNumber track on inv.FTrackNumberID = track.FID ");
        sql.append(" left join T_BD_Currency cur on inv.FCurrencyID = cur.FID ");
        sql.append(" left join T_BD_MeasureUnit unit on inv.FBaseUnitID = unit.FID ");
        sql.append(" left join T_SCM_BILLTYPE billtype on  inv.FSourceBillTypeID = billtype.FID ");
        sql.append(" ");
        String profitCenterId = filterParam.get("profitCenterId").toString();
        sql.append(" where inv.FProfitCenterID = '").append(profitCenterId).append("'");
        List materialIds = (List)filterParam.get("materialIds");
        if (materialIds != null && materialIds.size() > 0) {
            StringBuffer materialIdSql = this.structureIDCol(materialIds);
            sql.append(" and inv.FMaterialID in").append(materialIdSql);
        }
        if ((storageOrgUnitCol = (List)filterParam.get("storageOrgUnitCol")) != null && storageOrgUnitCol.size() > 0) {
            StringBuffer storageOrgUnitSql = this.structureIDCol(storageOrgUnitCol);
            sql.append(" and inv.FStorageOrgUnitID in ").append(storageOrgUnitSql);
        }
        if ((warehouseCol = (List)filterParam.get("warehouseCol")) != null && warehouseCol.size() > 0) {
            StringBuffer warehouseSql = this.structureIDCol(warehouseCol);
            sql.append(" and inv.FWarehouseID in ").append(warehouseSql);
        }
        if ((combo_billType = filterParam.get("billTypeCol")) != null) {
            String billTypeId = ((Map)combo_billType).get("id").toString();
            sql.append(" and inv.FSourceBillTypeID in ('").append(billTypeId).append("')");
        }
        int periodFrom = Integer.valueOf(filterParam.get("periodFrom").toString());
        int periodTo = Integer.valueOf(filterParam.get("periodTo").toString());
        sql.append(" and per.FNumber between ").append(periodFrom).append(" and ").append(periodTo);
        sql.append(" )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void setDataToTable(Context ctx, String tempTable, Map filterParam) throws BOSException {
        String[] sqls = new String[]{this.getPeriodBegin(ctx, tempTable, filterParam), this.getPeriodTotal(ctx, tempTable, filterParam), this.getPeriodYearTotal(ctx, tempTable, filterParam)};
        SQLUtils.executeBatch((Context)ctx, (String[])sqls);
    }

    private String getPeriodBegin(Context ctx, String tempTable, Map filterParam) {
        Map currentMaterial = (Map)filterParam.get("currentMaterial");
        String currentMaterialId = (String)currentMaterial.get("id");
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(tempTable);
        sql.append(" (FID,FIndex,FYear,FPeriod,FBillType,FTransactionTypeName,FRemainQty,FRemainUnitPrice,FRemainAmount,FMaterialID,FQtyPrecision,FAmtPrecision)");
        sql.append(" (select newbosid('DISPATCH') as FID,");
        sql.append(" -1 as FIndex,");
        sql.append(" itb.FYear as FYear,");
        sql.append(" itb.FPeriod as FPeriod,");
        sql.append(" -1 as FBillType,");
        sql.append(" '");
        sql.append(EASResource.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"DISPATCH", (Locale)ctx.getOriginLocale()));
        sql.append("' as FTransactionTypeName,");
        sql.append(" sum(itb.FPeriodBeginQty) as FRemainQty,");
        sql.append(" (case when isNUll(sum(itb.FPeriodBeginQty),0) = 0 then 0 else ");
        sql.append(" round(sum(itb.FPeriodBeginBalance)/sum(itb.FPeriodBeginQty),6) end) ");
        sql.append(" as FRemainUnitPrice,");
        sql.append(" sum(itb.FPeriodBeginBalance) as FRemainAmount,");
        sql.append(" '" + currentMaterialId + "' as FMaterialID, ");
        sql.append(" isnull(max(mm.FQtyPrecision),8) as FQtyPrecision,isnull(max(c.FPrecision),6) as FAmtPrecision");
        sql.append(" from T_CAL_InventoryBalance as itb ");
        sql.append(" left join t_bd_material m on m.fid = itb.FMaterialID");
        sql.append(" left join T_BD_MultiMeasureUnit mm on mm.FMaterialID = m.fid and mm.FMeasureUnitID = m.FBaseUnit");
        sql.append(" left join t_org_company com on com.Fid = itb.FCompanyOrgUnitID");
        sql.append(" left join t_bd_currency c on c.fid = com.FBaseCurrencyID");
        sql.append(" where itb.FMaterialID = '" + currentMaterialId + "' ");
        sql.append(" and itb.FYear is not null and itb.FPeriod is not null ");
        String profitCenterId = filterParam.get("profitCenterId").toString();
        sql.append(" and itb.FProfitCenterID = '").append(profitCenterId).append("' ");
        int periodFrom = Integer.valueOf(filterParam.get("periodFrom").toString());
        int periodTo = Integer.valueOf(filterParam.get("periodTo").toString());
        sql.append(" and (itb.FYear*100+itb.FPeriod) between ").append(periodFrom).append(" and ").append(periodTo);
        sql.append(" group by itb.FYear,itb.FPeriod) ");
        return sql.toString();
    }

    private String getPeriodTotal(Context ctx, String tempTable, Map filterParam) throws BOSException {
        Map currentMaterial = (Map)filterParam.get("currentMaterial");
        String currentMaterialId = (String)currentMaterial.get("id");
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(tempTable);
        sql.append(" (FID,FIndex,FYear,FPeriod,FBillType,FTransactionTypeName,FInQty,FInUnitPrice,FInAmount,");
        sql.append(" FOutQty,FOutUnitPrice,FOutAmount,FMaterialID,FQtyPrecision,FAmtPrecision)");
        sql.append(" (select newbosid('DISPATCH') as FID,");
        sql.append(" 1 as FIndex,");
        sql.append(" p.FYear as FYear,");
        sql.append(" p.FPeriod as FPeriod,");
        sql.append(" -1 as FBillType,");
        sql.append(" '");
        sql.append(EASResource.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"Period_count", (Locale)ctx.getOriginLocale()));
        sql.append("' as FTransactionTypeName,");
        sql.append(" sum(p.FInQty) as FInQty,");
        sql.append(" (case when isNull(sum(p.FInQty),0) = 0 then 0 else ");
        sql.append(" round(sum(p.FInAmount)/sum(p.FInQty),6) end) as FInUnitPrice,");
        sql.append(" sum(p.FInAmount) as FInAmount,");
        sql.append(" sum(p.FOutQty) as FOutQty,");
        sql.append(" (case when isNull(sum(p.FOutQty),0) = 0 then 0 else ");
        sql.append(" round(sum(p.FOutAmount)/sum(p.FOutQty),6) end) as FOutUnitPrice,");
        sql.append(" sum(p.FOutAmount) as FOutAmount,");
        sql.append(" '" + currentMaterialId + "' as FMaterialID,");
        sql.append(" max(p.FQtyPrecision),max(FAmtPrecision)");
        sql.append(" from " + tempTable + " as p where ( (p.FIndex = 0 or p.FIndex = -1) ");
        int periodFrom = Integer.valueOf(filterParam.get("periodFrom").toString());
        int periodTo = Integer.valueOf(filterParam.get("periodTo").toString());
        sql.append(" and (p.FMaterialID ='").append(currentMaterialId).append("' and (p.FYear*100+p.FPeriod) between ");
        sql.append(periodFrom).append(" and ").append(periodTo).append(" ) ");
        sql.append(" ) group by p.FYear,p.FPeriod) ");
        return sql.toString();
    }

    private String getPeriodYearTotal(Context ctx, String tempTable, Map filterParam) {
        Map currentMaterial = (Map)filterParam.get("currentMaterial");
        String currentMaterialId = (String)currentMaterial.get("id");
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(tempTable);
        sql.append(" (FID,FIndex,FYear,FBillType,FTransactionTypeName,FInQty,FInUnitPrice,FInAmount, ");
        sql.append(" FOutQty,FOutUnitPrice,FOutAmount,FMaterialID,FQtyPrecision,FAmtPrecision)");
        sql.append(" (select newbosid('DISPATCH') as FID,");
        sql.append(" 2 as FIndex,");
        sql.append(" p.FYear as FYear,");
        sql.append(" -1 as FBillType,");
        sql.append(" '");
        sql.append(EASResource.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"year_count", (Locale)ctx.getOriginLocale()));
        sql.append("' as FTransactionTypeName,");
        sql.append(" sum(p.FInQty) as FInQty,");
        sql.append(" (case when isNull(sum(p.FInQty),0) = 0 then 0 else ");
        sql.append(" round(sum(p.FInAmount)/sum(p.FInQty),6) end) as FInUnitPrice,");
        sql.append(" sum(p.FInAmount) as FInAmount,");
        sql.append(" sum(p.FOutQty) as FOutQty,");
        sql.append(" (case when isNull(sum(p.FOutQty),0) = 0 then 0 else ");
        sql.append(" round(sum(p.FOutAmount)/sum(p.FOutQty),6) end) as FOutUnitPrice,");
        sql.append(" sum(p.FOutAmount) as FOutAmount,");
        sql.append(" '" + currentMaterialId + "' as FMaterialID,");
        sql.append(" max(p.FQtyPrecision) as FQtyPrecision,");
        sql.append(" max(p.FAmtPrecision) as FAmtPrecision ");
        sql.append(" from " + tempTable + " as p ");
        sql.append(" where p.FIndex=1 ");
        sql.append(" and p.FMaterialID = '" + currentMaterialId + "' ");
        int periodFrom = Integer.valueOf(filterParam.get("periodFrom").toString());
        int periodTo = Integer.valueOf(filterParam.get("periodTo").toString());
        sql.append(" and (p.FYear*100+p.FPeriod) between ").append(periodFrom).append(" and ").append(periodTo);
        sql.append(" group by p.FYear)");
        return sql.toString();
    }

    private void countRemain(Context ctx, String tempTable, Map filterParam) throws BOSException, EASBizException {
        Map currentMaterial = (Map)filterParam.get("currentMaterial");
        String currentMaterialId = (String)currentMaterial.get("id");
        MaterialInfo materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(currentMaterialId));
        int prcPrecision = materialInfo.getPricePrecision();
        StringBuffer sql = new StringBuffer();
        sql.append(" select bill.FID,bill.FIndex,bill.FYear,FPeriod,bill.FBizDate, ");
        sql.append(" bill.FBillTypeName,bill.FBillNumber,bill.FTransactionTypeName,bill.FLot,");
        sql.append(" bill.FAssistantAttrName, bill.FProjectName,bill.FTrackName,bill.FRemark, ");
        sql.append(" round(bill.FInQty,bill.FQtyPrecision) as FInQty,");
        sql.append(" round(bill.FInUnitPrice,").append(prcPrecision).append(") as FInUnitPrice,");
        sql.append(" round(bill.FInAmount,bill.FAmtPrecision) as FInAmount,");
        sql.append(" round(bill.FOutQty,bill.FQtyPrecision) as FOutQty,");
        sql.append(" round(bill.FOutUnitPrice,").append(prcPrecision).append(") as FOutUnitPrice,");
        sql.append(" round(bill.FOutAmount,bill.FAmtPrecision) as FOutAmount,");
        sql.append(" round(bill.FRemainQty,bill.FQtyPrecision) as FRemainQty,");
        sql.append(" round(bill.FRemainUnitPrice,").append(prcPrecision).append(") as FRemainUnitPrice,");
        sql.append(" round(bill.FRemainAmount,bill.FAmtPrecision) as FRemainAmount");
        sql.append(" from ").append(tempTable).append(" as bill ");
        sql.append(" where bill.FMaterialID = '").append(currentMaterialId).append("'");
        sql.append(" order by bill.FYear,bill.FPeriod,bill.FIndex, ");
        sql.append(" bill.FBizDate,bill.FBillNumber,bill.FID ");
        HashMap<String, BigDecimal> upRowData = new HashMap<String, BigDecimal>();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        BigDecimal zero = new BigDecimal("0");
        int flag = 3;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                BigDecimal upRemainQty;
                Object[] param;
                String id = rs.getString("FID");
                int index = rs.getInt("FIndex");
                if (index == -1) {
                    BigDecimal remainQty = rs.getBigDecimal("FRemainQty");
                    BigDecimal remainUnitPrice = rs.getBigDecimal("FRemainUnitPrice");
                    BigDecimal remainAmount = rs.getBigDecimal("FRemainAmount");
                    upRowData.put("upRemainQty", rs.getBigDecimal("FRemainQty") == null ? zero : rs.getBigDecimal("FRemainQty"));
                    upRowData.put("upRemainUnitPrice", rs.getBigDecimal("FRemainUnitPrice") == null ? zero : rs.getBigDecimal("FRemainUnitPrice"));
                    upRowData.put("upRemainAmount", rs.getBigDecimal("FRemainAmount") == null ? zero : rs.getBigDecimal("FRemainAmount"));
                    param = new Object[]{remainQty == null || remainQty.compareTo(zero) == 0 ? null : remainQty, remainUnitPrice == null || remainUnitPrice.compareTo(zero) == 0 ? null : remainUnitPrice, remainAmount == null || remainAmount.compareTo(zero) == 0 ? null : remainAmount, id};
                    paramsList.add(param);
                    flag = -1;
                    continue;
                }
                if (index == 0) {
                    if (flag == 1 || flag == 3) {
                        upRowData.put("upRemainQty", zero);
                        upRowData.put("upRemainUnitPrice", zero);
                        upRowData.put("upRemainAmount", zero);
                    }
                    if ((upRemainQty = (BigDecimal)upRowData.get("upRemainQty")) == null) {
                        upRemainQty = zero;
                    }
                    BigDecimal inQty = rs.getBigDecimal("FInQty") == null ? zero : rs.getBigDecimal("FInQty");
                    BigDecimal outQty = rs.getBigDecimal("FOutQty") == null ? zero : rs.getBigDecimal("FOutQty");
                    BigDecimal remainQty = upRemainQty.add(inQty).subtract(outQty);
                    upRowData.put("upRemainQty", remainQty);
                    BigDecimal upRemainAmount = (BigDecimal)upRowData.get("upRemainAmount");
                    BigDecimal inAmount = rs.getBigDecimal("FInAmount");
                    BigDecimal outAmount = rs.getBigDecimal("FOutAmount");
                    BigDecimal remainAmount = upRemainAmount.add(inAmount).subtract(outAmount);
                    upRowData.put("upRemainAmount", remainAmount);
                    BigDecimal remainUnitPrice = remainQty.compareTo(zero) == 0 ? zero : remainAmount.divide(remainQty, prcPrecision, 4);
                    upRowData.put("upRemainUnitPrice", remainUnitPrice);
                    param = new Object[]{remainQty.compareTo(zero) == 0 ? null : remainQty, remainUnitPrice.compareTo(zero) == 0 ? null : remainUnitPrice, remainAmount.compareTo(zero) == 0 ? null : remainAmount, id};
                    paramsList.add(param);
                    flag = 0;
                    continue;
                }
                if (index != 1 && index != 2) continue;
                upRemainQty = (BigDecimal)upRowData.get("upRemainQty");
                BigDecimal upRemainUnitPrice = (BigDecimal)upRowData.get("upRemainUnitPrice");
                BigDecimal upRemainAmount = (BigDecimal)upRowData.get("upRemainAmount");
                param = new Object[]{upRemainQty.compareTo(zero) == 0 ? null : upRemainQty, upRemainUnitPrice.compareTo(zero) == 0 ? null : upRemainUnitPrice, upRemainAmount.compareTo(zero) == 0 ? null : upRemainAmount, id};
                paramsList.add(param);
                flag = 1;
            }
            String batchsql = "update " + tempTable + " set FRemainQty=?,FRemainUnitPrice=?,FRemainAmount=? where FID = ? ";
            SQLUtils.executeBatch((Context)ctx, (String)batchsql, paramsList);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private List<Map<String, String>> doBizQuery(Context ctx, String tempTable, Map filterParam, boolean isQueryAll) throws EASBizException, BOSException {
        Map currentMaterial = (Map)filterParam.get("currentMaterial");
        String currentMaterialId = (String)currentMaterial.get("id");
        MaterialInfo materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(currentMaterialId));
        int prcPrecision = materialInfo.getPricePrecision();
        StringBuffer sql = new StringBuffer();
        sql.append(" select bill.FID,bill.FIndex,bill.FYear,FPeriod,TO_CHAR(bill.FBizDate, 'YYYY-MM-DD') as FBizDate, ");
        sql.append(" bill.FBillTypeName,bill.FBillNumber,bill.FTransactionTypeName,bill.FLot,");
        sql.append(" bill.FAssistantAttrName, bill.FProjectName,bill.FTrackName,bill.FProjectNumber,bill.FTrackNumber,bill.FRemark, ");
        sql.append(" round(bill.FInQty,bill.FQtyPrecision) as FInQty,");
        sql.append(" round(bill.FInUnitPrice,").append(prcPrecision).append(") as FInUnitPrice,");
        sql.append(" round(bill.FInAmount,bill.FAmtPrecision) as FInAmount,");
        sql.append(" round(bill.FOutQty,bill.FQtyPrecision) as FOutQty,");
        sql.append(" round(bill.FOutUnitPrice,").append(prcPrecision).append(") as FOutUnitPrice,");
        sql.append(" round(bill.FOutAmount,bill.FAmtPrecision) as FOutAmount,");
        sql.append(" round(bill.FRemainQty,bill.FQtyPrecision) as FRemainQty,");
        sql.append(" round(bill.FRemainUnitPrice,").append(prcPrecision).append(") as FRemainUnitPrice,");
        sql.append(" round(bill.FRemainAmount,bill.FAmtPrecision) as FRemainAmount,");
        sql.append(" bill.FAmtPrecision as FAmtPrecision,");
        sql.append(" bill.FQtyPrecision as FQtyPrecision,");
        sql.append(prcPrecision + " as FPricePrecision");
        sql.append(" from ").append(tempTable).append(" as bill ");
        sql.append(" where bill.FMaterialID = '").append(currentMaterialId).append("'");
        sql.append(" order by bill.FYear,isnull(bill.FPeriod,99),bill.FIndex, ");
        sql.append(" bill.FBizDate,bill.FBillNumber,bill.FID ");
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        IRowSet rs = null;
        if (!isQueryAll) {
            int start = Integer.parseInt(filterParam.get("start").toString());
            int rows = Integer.parseInt(filterParam.get("rows").toString());
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (int)start, (int)rows);
        } else {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        try {
            while (rs.next()) {
                HashMap<String, String> rowData = new HashMap<String, String>();
                String id = rs.getString("FID");
                rowData.put("id", id);
                rowData.put("index", rs.getString("FIndex"));
                rowData.put("year", rs.getString("FYear"));
                rowData.put("period", rs.getString("FPeriod"));
                rowData.put("bizDate", rs.getString("FBizDate"));
                rowData.put("billTypeName", rs.getString("FBillTypeName"));
                rowData.put("billNumber", rs.getString("FBillNumber"));
                rowData.put("transactionType", rs.getString("FTransactionTypeName"));
                rowData.put("lot", rs.getString("FLot"));
                rowData.put("assistProperty", rs.getString("FAssistantAttrName"));
                rowData.put("project", rs.getString("FProjectNumber"));
                rowData.put("track", rs.getString("FTrackNumber"));
                rowData.put("inQty", rs.getString("FInQty"));
                rowData.put("inUnitPrice", rs.getString("FInUnitPrice"));
                rowData.put("inAmount", rs.getString("FInAmount"));
                rowData.put("outQty", rs.getString("FOutQty"));
                rowData.put("outUnitPrice", rs.getString("FOutUnitPrice"));
                rowData.put("outAmount", rs.getString("FOutAmount"));
                rowData.put("remainQty", rs.getString("FRemainQty"));
                rowData.put("remainUnitPrice", rs.getString("FRemainUnitPrice"));
                rowData.put("remainAmount", rs.getString("FRemainAmount"));
                rowData.put("remark", rs.getString("FRemark"));
                rowData.put("amtPrecision", rs.getString("FAmtPrecision"));
                rowData.put("qtyPrecision", rs.getString("FQtyPrecision"));
                rowData.put("pricePrecision", rs.getString("FPricePrecision"));
                data.add(rowData);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return data;
    }

    private int getTotalRowCount(Context ctx, String tempTable, Map filterParam) throws BOSException {
        Map currentMaterial = (Map)filterParam.get("currentMaterial");
        String currentMaterialId = (String)currentMaterial.get("id");
        String sql = "select count(*) as count from " + tempTable + " where FMaterialID = '" + currentMaterialId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        int totalRowCount = 0;
        try {
            while (rs.next()) {
                totalRowCount = rs.getInt("count");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return totalRowCount;
    }
}

