/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.cal.app.calImport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.cal.IInventoryBalance;
import com.kingdee.eas.ma.cal.InventoryBalanceFactory;
import com.kingdee.eas.ma.cal.InventoryBalanceInfo;
import com.kingdee.eas.ma.cal.app.calImport.CalInitImportBase;
import com.kingdee.eas.ma.cal.app.utils.CalUtils;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class InventoryBalanceImport
extends CalInitImportBase {
    private static final Logger logger = Logger.getLogger(InventoryBalanceImport.class);

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return InventoryBalanceFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(this.getType(), (Throwable)e);
        }
    }

    public AccountViewInfo getAccount(Context ctx, Hashtable hsData) throws Exception, SQLException {
        AccountViewInfo account = null;
        String accountID = ((DataToken)hsData.get((Object)"FAccountID")).data.toString();
        if (accountID == null || "".equals(accountID.trim())) {
            return account;
        }
        String sqlToGetAccount = "select top 1 fid,fnumber,fLongNumber from T_BD_ACCOUNTVIEW where fnumber=?";
        IRowSet rsToGetAccount = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAccount, (Object[])new Object[]{accountID});
        if (rsToGetAccount == null || !rsToGetAccount.next()) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"1011_InventoryBalanceImport", (Locale)ctx.getLocale()));
        }
        account = new AccountViewInfo();
        account.setId(BOSUuid.read((String)rsToGetAccount.getString("fid")));
        account.setLongNumber(rsToGetAccount.getString("flongnumber"));
        account.setNumber(accountID);
        return account;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        InventoryBalanceInfo infos = new InventoryBalanceInfo();
        infos.setFromExcel(true);
        Map pageParam = super.getContextMap();
        try {
            AccountViewInfo account;
            StoreTypeInfo storeTypeInfo;
            TrackNumberInfo trackNumberInfo;
            ProjectInfo projectInfo;
            AsstAttrValueInfo asstAttrValueInfo;
            String lot;
            MaterialInfo materialInfo;
            LocationInfo locationInfo;
            WarehouseInfo warehouseInfo;
            ProfitCenterOrgUnitInfo profitCenterInfo = this.getProfitCenter(ctx, hsData);
            if (profitCenterInfo != null) {
                infos.setProfitCenter(profitCenterInfo);
            }
            CtrlUnitInfo ctrlUnit = this.getCU(ctx, profitCenterInfo);
            infos.setCU(ctrlUnit);
            CompanyOrgUnitInfo company = this.getCompany(ctx, hsData, profitCenterInfo.getId().toString());
            infos.setCompanyOrgUnit(company);
            StorageOrgUnitInfo storageInfo = this.getStorageOrgUnit(ctx, hsData, profitCenterInfo.getId().toString());
            if (storageInfo != null) {
                infos.setStorageOrgUnit(storageInfo);
            }
            if ((warehouseInfo = this.getWarehouse(ctx, hsData, storageInfo.getId().toString())) != null) {
                infos.setWarehouse(warehouseInfo);
            }
            if ((locationInfo = this.getLocation(ctx, hsData)) != null) {
                infos.setLocation(locationInfo);
            }
            if ((materialInfo = this.getMaterial(ctx, hsData)) != null) {
                infos.setMaterial(materialInfo);
                if (materialInfo.getBaseUnit() != null) {
                    infos.setBaseUnit(materialInfo.getBaseUnit());
                }
            }
            if ((lot = ((DataToken)hsData.get((Object)"FLot")).data.toString()) != null && !"".equals(lot)) {
                infos.setLot(lot);
            }
            if ((asstAttrValueInfo = this.getAssistProperty(ctx, hsData)) != null) {
                infos.setAssistProperty(asstAttrValueInfo);
            }
            if ((projectInfo = this.getProject(ctx, hsData)) != null) {
                infos.setProject(projectInfo);
            }
            if ((trackNumberInfo = this.getTrackNumber(ctx, hsData)) != null) {
                infos.setTrackNumber(trackNumberInfo);
            }
            if ((storeTypeInfo = this.getStoreType(ctx, hsData)) != null) {
                infos.setStoreType(storeTypeInfo);
            }
            if ((account = this.getAccount(ctx, hsData)) != null) {
                infos.setAccount(account);
            }
            int qtyPrecision = 8;
            int amountPrecision = 4;
            if (materialInfo != null && materialInfo.getBaseUnit() != null) {
                MultiMeasureUnitInfo mmUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiUnit(materialInfo.getId().toString(), materialInfo.getBaseUnit().getId().toString());
                qtyPrecision = mmUnit.getQtyPrecision();
            }
            if (company != null && company.getBaseCurrency() != null) {
                amountPrecision = company.getBaseCurrency().getPrecision();
            }
            if (this.CheckString(((DataToken)hsData.get((Object)"FPeriodBeginQty")).data)) {
                infos.setPeriodBeginQty(this.getValue(hsData.get("FPeriodBeginQty")).setScale(qtyPrecision, 4));
            }
            if (this.CheckString(((DataToken)hsData.get((Object)"FPeriodBeginBalance")).data)) {
                infos.setPeriodBeginBalance(this.getValue(hsData.get("FPeriodBeginBalance")).setScale(amountPrecision, 4));
            }
            if (this.CheckString(((DataToken)hsData.get((Object)"FYearReceiptQty")).data)) {
                infos.setYearReceiptQty(this.getValue(hsData.get("FYearReceiptQty")).setScale(qtyPrecision, 4));
            }
            if (this.CheckString(((DataToken)hsData.get((Object)"FYearPeriodReceiptAmount")).data)) {
                infos.setYearPeriodReceiptAmount(this.getValue(hsData.get("FYearPeriodReceiptAmount")).setScale(amountPrecision, 4));
            }
            if (this.CheckString(((DataToken)hsData.get((Object)"FYearPeriodIssueQty")).data)) {
                infos.setYearPeriodIssueQty(this.getValue(hsData.get("FYearPeriodIssueQty")).setScale(qtyPrecision, 4));
            }
            if (this.CheckString(((DataToken)hsData.get((Object)"FYearPeriodIssueAmount")).data)) {
                infos.setYearPeriodIssueAmount(this.getValue(hsData.get("FYearPeriodIssueAmount")).setScale(amountPrecision, 4));
            }
            PeriodInfo startPeriod = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getProfitStartPeriod(SystemEnum.PROFIT_CENTER_STORAGE.getValue(), profitCenterInfo.getId().toString());
            infos.setYear(startPeriod.getPeriodYear());
            infos.setPeriod(startPeriod.getPeriodNumber());
            IInventoryBalance iInventoryBalnce = InventoryBalanceFactory.getLocalInstance(ctx);
            String tempId = iInventoryBalnce.verifyDataUnique(infos);
            if (!"".equals(tempId)) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"1012_InventoryBalanceImport", (Locale)ctx.getLocale()));
            }
            return infos;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public ProfitCenterOrgUnitInfo getProfitCenter(Context ctx, Hashtable hsData) throws Exception, BOSException {
        HashMap<String, String> profitMap = new HashMap<String, String>();
        HashMap<String, String> profitIsStartMap = new HashMap<String, String>();
        SelectorItemCollection sic = CalUtils.getProfitCenterSic();
        List list = InventoryBalanceFactory.getLocalInstance(ctx).getProfitCenterList();
        Map map = null;
        for (int i = 0; i < list.size(); ++i) {
            map = (Map)list.get(i);
            profitMap.put((String)map.get("profitCenterNumber"), (String)map.get("profitCenterID"));
            profitIsStartMap.put((String)map.get("profitCenterNumber"), (String)map.get("isStart"));
        }
        String profitCenterID = ((DataToken)hsData.get((Object)"FProfitCenterID")).data.toString();
        if (profitMap.get(profitCenterID) == null) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"1001_InventoryBalanceImport", (Locale)ctx.getLocale()));
        }
        if (((String)profitIsStartMap.get(profitCenterID)).equals("1")) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"1013_InventoryBalanceImport", (Locale)ctx.getLocale()));
        }
        return ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK((String)profitMap.get(profitCenterID)), sic);
    }

    private CtrlUnitInfo getCU(Context ctx, ProfitCenterOrgUnitInfo profitCenter) throws Exception {
        String cuid = CalUtils.getCUID(ctx, profitCenter);
        CtrlUnitInfo ctrlUnit = new CtrlUnitInfo();
        ctrlUnit.setId(BOSUuid.read((String)cuid));
        return ctrlUnit;
    }

    public CompanyOrgUnitInfo getCompany(Context ctx, Hashtable hsData, String profitCenterId) throws UuidException, SQLException, Exception {
        ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        String orgUnitID = ((DataToken)hsData.get((Object)"FCompanyOrgUnitID")).data.toString();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)CalUtils.getProfitCenterSic());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)orgUnitID));
        view.setFilter(filter);
        view.setSelector(sic);
        CompanyOrgUnitCollection coll = companyOrgUnit.getCompanyOrgUnitCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"1002_InventoryBalanceImport", (Locale)ctx.getLocale()));
        }
        return coll.get(0);
    }

    public StorageOrgUnitInfo getStorageOrgUnit(Context ctx, Hashtable hsData, String profitCenterId) throws UuidException, SQLException, Exception {
        StorageOrgUnitInfo storageInfo = null;
        String sqlToGetStorage = "select rel.ffromunitid fstorageid from T_ORG_UnitRelation rel inner join t_org_typerelation typeRel on typeRel.fid = rel.ftyperelationid inner join t_org_baseunit baseunit on baseunit.fid=rel.ffromunitid where rel.ftounitid in (?) and typeRel.ftotype = 6 and typeRel.ffromtype = 4 and baseunit.fnumber = ?";
        String storageID = ((DataToken)hsData.get((Object)"FStorageOrgUnitID")).data.toString();
        IRowSet rsToGetStorage = DbUtil.executeQuery((Context)ctx, (String)sqlToGetStorage, (Object[])new Object[]{profitCenterId, storageID});
        if (rsToGetStorage == null || !rsToGetStorage.next()) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"1003_InventoryBalanceImport", (Locale)ctx.getLocale()));
        }
        storageInfo = new StorageOrgUnitInfo();
        storageInfo.setId(BOSUuid.read((String)rsToGetStorage.getString("fstorageid")));
        storageInfo.setNumber(storageID);
        return storageInfo;
    }

    public WarehouseInfo getWarehouse(Context ctx, Hashtable hsData, String storageId) throws UuidException, SQLException, Exception {
        WarehouseInfo warehouseInfo = null;
        String sqlToGetWarehouse = "select fid,fnumber from T_DB_WAREHOUSE where fnumber = ?  and (FstorageOrgID = ? or fid in (select FWarehouseID from T_DB_SOAccreditWH where FStorageOrgID = ? and fstatus=1)) and FWhState=1";
        String warehouseId = ((DataToken)hsData.get((Object)"FWarehouseID")).data.toString();
        IRowSet rsToGetWarehouse = DbUtil.executeQuery((Context)ctx, (String)sqlToGetWarehouse, (Object[])new Object[]{warehouseId, storageId, storageId});
        if (rsToGetWarehouse == null || !rsToGetWarehouse.next()) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"1004_InventoryBalanceImport", (Locale)ctx.getLocale()));
        }
        warehouseInfo = new WarehouseInfo();
        warehouseInfo.setId(BOSUuid.read((String)rsToGetWarehouse.getString("fid")));
        warehouseInfo.setNumber(warehouseId);
        return warehouseInfo;
    }

    public LocationInfo getLocation(Context ctx, Hashtable hsData) throws UuidException, SQLException, Exception {
        LocationInfo warehouseInfo = null;
        String locationId = ((DataToken)hsData.get((Object)"FLocationID")).data.toString();
        if (locationId == null || "".equals(locationId)) {
            return warehouseInfo;
        }
        String sqlToGetLOCATION = "select fid,fnumber from T_DB_LOCATION where fnumber = ?";
        IRowSet rsToGetLOCATION = DbUtil.executeQuery((Context)ctx, (String)sqlToGetLOCATION, (Object[])new Object[]{locationId});
        if (rsToGetLOCATION == null || !rsToGetLOCATION.next()) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"1005_InventoryBalanceImport", (Locale)ctx.getLocale()));
        }
        warehouseInfo = new LocationInfo();
        warehouseInfo.setId(BOSUuid.read((String)rsToGetLOCATION.getString("fid")));
        warehouseInfo.setNumber(locationId);
        return warehouseInfo;
    }

    public MaterialInfo getMaterial(Context ctx, Hashtable hsData) throws UuidException, SQLException, Exception {
        MaterialInfo materialInfo = null;
        String materialId = ((DataToken)hsData.get((Object)"FMaterialID")).data.toString();
        if (materialId == null || "".equals(materialId)) {
            return materialInfo;
        }
        String sqlToGetLOCATION = "select material.fid fid,material.fnumber fnumber,baseUnit.fid baseUnitId,baseUnit.fnumber baseUnitNumber from T_BD_Material material  inner join T_BD_MeasureUnit baseUnit on material.FBaseUnit = baseUnit.fid where material.fnumber = ?";
        IRowSet rsToGetLOCATION = DbUtil.executeQuery((Context)ctx, (String)sqlToGetLOCATION, (Object[])new Object[]{materialId});
        if (rsToGetLOCATION == null || !rsToGetLOCATION.next()) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"1006_InventoryBalanceImport", (Locale)ctx.getLocale()));
        }
        materialInfo = new MaterialInfo();
        materialInfo.setId(BOSUuid.read((String)rsToGetLOCATION.getString("fid")));
        materialInfo.setNumber(materialId);
        MeasureUnitInfo baseUnit = new MeasureUnitInfo();
        baseUnit.setId(BOSUuid.read((String)rsToGetLOCATION.getString("baseUnitId")));
        baseUnit.setNumber(rsToGetLOCATION.getString("baseUnitNumber"));
        materialInfo.setBaseUnit(baseUnit);
        return materialInfo;
    }

    public AsstAttrValueInfo getAssistProperty(Context ctx, Hashtable hsData) throws UuidException, SQLException, Exception {
        AsstAttrValueInfo assistPropertyInfo = null;
        String assistPropertyID = ((DataToken)hsData.get((Object)"FAssistPropertyID")).data.toString();
        if (assistPropertyID == null || "".equals(assistPropertyID)) {
            return assistPropertyInfo;
        }
        String sqlToGetAssistProperty = "select fid,fnumber from T_BD_AsstAttrValue where fnumber = ?";
        IRowSet rsToGetAssistProperty = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAssistProperty, (Object[])new Object[]{assistPropertyID});
        if (rsToGetAssistProperty == null || !rsToGetAssistProperty.next()) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"1007_InventoryBalanceImport", (Locale)ctx.getLocale()));
        }
        assistPropertyInfo = new AsstAttrValueInfo();
        assistPropertyInfo.setId(BOSUuid.read((String)rsToGetAssistProperty.getString("fid")));
        assistPropertyInfo.setNumber(assistPropertyID);
        return assistPropertyInfo;
    }

    public TrackNumberInfo getTrackNumber(Context ctx, Hashtable hsData) throws UuidException, SQLException, Exception {
        TrackNumberInfo trackNumberInfo = null;
        String trackNumberId = ((DataToken)hsData.get((Object)"FTrackNumberID")).data.toString();
        if (trackNumberId == null || "".equals(trackNumberId)) {
            return trackNumberInfo;
        }
        String sqlToGetAssistProperty = "select fid,fnumber from T_MM_TrackNumber where fnumber = ?";
        IRowSet rsToGetAssistProperty = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAssistProperty, (Object[])new Object[]{trackNumberId});
        if (rsToGetAssistProperty == null || !rsToGetAssistProperty.next()) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"1008_InventoryBalanceImport", (Locale)ctx.getLocale()));
        }
        trackNumberInfo = new TrackNumberInfo();
        trackNumberInfo.setId(BOSUuid.read((String)rsToGetAssistProperty.getString("fid")));
        trackNumberInfo.setNumber(trackNumberId);
        return trackNumberInfo;
    }

    public StoreTypeInfo getStoreType(Context ctx, Hashtable hsData) throws UuidException, SQLException, Exception {
        StoreTypeInfo storeTypeInfo = null;
        String storeTypeID = ((DataToken)hsData.get((Object)"FStoreTypeID")).data.toString();
        if (storeTypeID == null || "".equals(storeTypeID)) {
            return storeTypeInfo;
        }
        String sqlToGetStoreType = "select fid,fnumber from T_IM_STORETYPE where fnumber = ? and fisForwardAmt>0";
        IRowSet rsToGetStoreType = DbUtil.executeQuery((Context)ctx, (String)sqlToGetStoreType, (Object[])new Object[]{storeTypeID});
        if (rsToGetStoreType == null || !rsToGetStoreType.next()) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"1009_InventoryBalanceImport", (Locale)ctx.getLocale()));
        }
        storeTypeInfo = new StoreTypeInfo();
        storeTypeInfo.setId(BOSUuid.read((String)rsToGetStoreType.getString("fid")));
        storeTypeInfo.setNumber(storeTypeID);
        return storeTypeInfo;
    }

    public ProjectInfo getProject(Context ctx, Hashtable hsData) throws UuidException, SQLException, Exception {
        ProjectInfo projectInfo = null;
        String projectId = ((DataToken)hsData.get((Object)"FProjectID")).data.toString();
        if (projectId == null || "".equals(projectId)) {
            return projectInfo;
        }
        String sqlToGetAssistProperty = "select fid,fnumber from T_MM_Project where fnumber = ?";
        IRowSet rsToGetAssistProperty = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAssistProperty, (Object[])new Object[]{projectId});
        if (rsToGetAssistProperty == null || !rsToGetAssistProperty.next()) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"1010_InventoryBalanceImport", (Locale)ctx.getLocale()));
        }
        projectInfo = new ProjectInfo();
        projectInfo.setId(BOSUuid.read((String)rsToGetAssistProperty.getString("fid")));
        projectInfo.setNumber(projectId);
        return projectInfo;
    }

    @Override
    protected String getType() {
        return "InitAssistBalance";
    }
}

