/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.cal.app.closeAccount;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.cal.ClosePeriodFacadeFactory;
import com.kingdee.eas.ma.cal.app.closeAccount.CloseAccountService;
import com.kingdee.eas.ma.cal.app.closeAccount.ReCloseAccountService;
import com.kingdee.eas.ma.cal.app.issueCalculate.ProfitCenterData;
import com.kingdee.eas.ma.cal.app.utils.CalUtils;
import com.kingdee.eas.ma.scmcommon.ITaskProgressFacade;
import com.kingdee.eas.ma.scmcommon.TaskProgressFacadeFactory;
import com.kingdee.eas.ma.scmcommon.tools.SQLUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CalClosePeriodService {
    private Context ctx;

    public CalClosePeriodService(Context context) {
        this.ctx = context;
    }

    public Map getData(Map condition) throws BOSException, EASBizException {
        ProfitCenterData data = new ProfitCenterData(this.ctx, condition);
        return data.getProfitCenterData();
    }

    public Map closePeriod(Map condition) throws EASBizException, BOSException {
        ITaskProgressFacade progressFacade = TaskProgressFacadeFactory.getLocalInstance((Context)this.ctx);
        HashMap<String, Object> progressMap = new HashMap<String, Object>();
        String rowid = (String)condition.get("rowid");
        String taskid = (String)condition.get("taskid");
        progressMap.put("TaskID", taskid);
        progressMap.put("Remark", rowid);
        HashMap<String, Object> result = new HashMap<String, Object>();
        List errors = new ArrayList();
        result.put("status", "error");
        result.put("errors", errors);
        String profitCenterid = condition.get("orgId").toString();
        String currPeriodid = condition.get("periodId").toString();
        ProfitCenterOrgUnitInfo profitCenterInfo = ProfitCenterOrgUnitFactory.getLocalInstance((Context)this.ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterid));
        PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(currPeriodid));
        boolean ischeck = Boolean.parseBoolean(condition.get("ischeck").toString());
        try {
            errors = this.checkcanClose(profitCenterInfo, periodInfo, condition);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        List errors2 = ClosePeriodFacadeFactory.getLocalInstance(this.ctx).extendCheckClosePeriod(condition);
        if (errors2 != null && errors2.size() > 0) {
            errors.addAll(errors2);
        }
        if (errors.size() > 0) {
            result.put("errors", errors);
            return result;
        }
        if (!ischeck) {
            progressMap.put("Complete", 30);
            progressFacade.updateProgress(progressMap);
            CloseAccountService closeAccount = new CloseAccountService(this.ctx);
            closeAccount.doing(profitCenterid);
            PeriodInfo currentPeriod = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx).getProfitCurrentPeriod(1007, profitCenterid);
            String periodYear = String.valueOf(currentPeriod.getPeriodYear());
            String periodMonth = String.valueOf(currentPeriod.getPeriodNumber());
            if (periodMonth != null && periodMonth.toString().length() == 1) {
                periodMonth = "0" + periodMonth;
            }
            String periodName = this.getStrResource("periodName", new String[]{periodYear, periodMonth}, this.ctx.getOriginLocale());
            result.put("periodId", currentPeriod.getId().toString());
            result.put("periodName", periodName);
        }
        result.put("status", "success");
        return result;
    }

    private List checkcanClose(ProfitCenterOrgUnitInfo profitCenter, PeriodInfo currPeriod, Map condition) throws EASBizException, BOSException, SQLException {
        HashMap<String, Object> error;
        IRowSet rs;
        String id = (String)condition.get("rowid");
        ArrayList errors = new ArrayList();
        int errorIndex = 0;
        String profitCenterid = condition.get("orgId").toString();
        String periodid = condition.get("periodId").toString();
        PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)this.ctx, (PeriodInfo)currPeriod);
        if (nextPeriod == null) {
            HashMap<String, Object> error2 = new HashMap<String, Object>();
            error2.put("id", id + "_" + ++errorIndex);
            error2.put("isError", true);
            error2.put("orgName", this.getStrResource("next_period_error", this.ctx.getOriginLocale()));
            errors.add(error2);
        }
        boolean checkInwarehsIsZero = Boolean.parseBoolean(condition.get("checkInwarehsIsZero").toString());
        boolean checkIssueIsZero = Boolean.parseBoolean(condition.get("checkIssueIsZero").toString());
        boolean checkIsVoucher = Boolean.parseBoolean(condition.get("checkIsVoucher").toString());
        StringBuffer sql = new StringBuffer();
        Date beginData = currPeriod.getBeginDate();
        Date endData = CalUtils.getDate(currPeriod.getEndDate(), 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sql.append(" select count(*) as count from T_CAL_InvAccountBill ");
        sql.append(" where FProfitCenterID = ?");
        sql.append(" and fbizDate >= to_date(?)");
        sql.append(" and fbizDate < to_date(?)");
        StringBuffer countsql = new StringBuffer();
        if (checkInwarehsIsZero) {
            countsql.append(sql.toString());
            countsql.append(" and FOutOrInWareHouse =").append(20);
            countsql.append(" and FCost = 0 ");
            countsql.append(" and FSourceBillTypeID != '").append("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552").append("'");
            countsql.append(" and fisPresent !=1");
            rs = DbUtil.executeQuery((Context)this.ctx, (String)countsql.toString(), (Object[])new Object[]{profitCenterid, sdf.format(beginData), sdf.format(endData)});
            if (rs.next() && rs.getInt("count") > 0) {
                error = new HashMap();
                error.put("id", id + "_" + ++errorIndex);
                error.put("orgName", this.getStrResource("InWare_count_is_zero", this.ctx.getOriginLocale()));
                error.put("operation", this.getStrResource("operation", this.ctx.getOriginLocale()));
                error.put("isError", true);
                error.put("operatfunction", "checkInWarehsCost");
                error.put("periodId", periodid);
                error.put("orgId", profitCenterid);
                errors.add(error);
            }
        }
        if (checkIssueIsZero) {
            countsql.setLength(0);
            countsql.append(sql.toString());
            countsql.append(" and FOutOrInWareHouse =").append(10);
            countsql.append(" and FCost = 0 ");
            countsql.append(" and FSourceBillTypeID != '").append("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552").append("'");
            rs = DbUtil.executeQuery((Context)this.ctx, (String)countsql.toString(), (Object[])new Object[]{profitCenterid, sdf.format(beginData), sdf.format(endData)});
            if (rs.next() && rs.getInt("count") > 0) {
                error = new HashMap();
                error.put("id", id + "_" + ++errorIndex);
                error.put("orgName", this.getStrResource("OutWare_count_is_zero", this.ctx.getOriginLocale()));
                error.put("operation", this.getStrResource("operation", this.ctx.getOriginLocale()));
                error.put("isError", true);
                error.put("operatfunction", "checkIssueCost");
                error.put("periodId", periodid);
                error.put("orgId", profitCenterid);
                errors.add(error);
            }
        }
        if (checkIsVoucher) {
            countsql.setLength(0);
            countsql.append(sql.toString());
            countsql.append(" and FFiVouchered = 0 ");
            rs = DbUtil.executeQuery((Context)this.ctx, (String)countsql.toString(), (Object[])new Object[]{profitCenterid, sdf.format(beginData), sdf.format(endData)});
            if (rs.next() && rs.getInt("count") > 0) {
                error = new HashMap<String, Object>();
                error.put("id", id + "_" + ++errorIndex);
                error.put("orgName", this.getStrResource("FiVouchere_count_is_zero", this.ctx.getOriginLocale()));
                error.put("operation", this.getStrResource("operation", this.ctx.getOriginLocale()));
                error.put("isError", true);
                error.put("operatfunction", "checkVoucher");
                error.put("periodId", periodid);
                error.put("orgId", profitCenterid);
                errors.add(error);
            }
        }
        return errors;
    }

    public Map unClosePeriod(Map condition) throws EASBizException, BOSException {
        ITaskProgressFacade progressFacade = TaskProgressFacadeFactory.getLocalInstance((Context)this.ctx);
        HashMap<String, Object> progressMap = new HashMap<String, Object>();
        String rowid = condition.get("rowid").toString();
        String taskid = condition.get("taskid").toString();
        progressMap.put("TaskID", taskid);
        progressMap.put("Remark", rowid);
        HashMap<String, Object> result = new HashMap<String, Object>();
        List errors = new ArrayList();
        result.put("status", "error");
        result.put("errors", errors);
        String profitCenterid = condition.get("orgId").toString();
        String currPeriodid = condition.get("periodId").toString();
        ProfitCenterOrgUnitInfo profitCenterInfo = ProfitCenterOrgUnitFactory.getLocalInstance((Context)this.ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterid));
        PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(currPeriodid));
        errors = this.checkcanUnClose(profitCenterInfo, periodInfo, condition);
        if (errors.size() > 0) {
            result.put("errors", errors);
            return result;
        }
        progressMap.put("Complete", 30);
        progressFacade.updateProgress(progressMap);
        ReCloseAccountService reCloseAccountService = new ReCloseAccountService(this.ctx);
        HashMap<String, Object> inParam = new HashMap<String, Object>();
        inParam.put("profitCenter", profitCenterInfo);
        inParam.put("currPeriod", periodInfo);
        reCloseAccountService.doing(inParam);
        int system = 1007;
        PeriodInfo currentPeriod = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx).getProfitCurrentPeriod(system, profitCenterid);
        String periodYear = String.valueOf(currentPeriod.getPeriodYear());
        String periodMonth = String.valueOf(currentPeriod.getPeriodNumber());
        if (periodMonth != null && periodMonth.toString().length() == 1) {
            periodMonth = "0" + periodMonth;
        }
        String periodName = this.getStrResource("periodName", new String[]{periodYear, periodMonth}, this.ctx.getOriginLocale());
        result.put("periodId", currentPeriod.getId().toString());
        result.put("periodName", periodName);
        result.put("status", "success");
        return result;
    }

    private List checkcanUnClose(ProfitCenterOrgUnitInfo profitCenter, PeriodInfo currPeriod, Map condition) throws BOSException, EASBizException {
        String rowid = (String)condition.get("rowid");
        ArrayList errors = new ArrayList();
        int errorIndex = 0;
        ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx);
        PeriodInfo startPeriod = iSystemStatusCtrol.getProfitStartPeriod(1007, profitCenter.getId().toString());
        if (currPeriod.equals((Object)startPeriod)) {
            HashMap<String, Object> error = new HashMap<String, Object>();
            error.put("id", rowid + "_" + ++errorIndex);
            error.put("isError", true);
            error.put("orgName", this.getStrResource("startPeriod_equals_currPeriod", this.ctx.getOriginLocale()));
            errors.add(error);
            return errors;
        }
        return errors;
    }

    protected Map extendCheckClosePeriod(Context ctx, Map map) throws BOSException, EASBizException {
        return null;
    }

    private void updateCheckData() throws BOSException, EASBizException {
        String userId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid from T_CAL_ClosePeriodCheck where FUserID = ?");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{userId});
        sql.setLength(0);
        sql.append(" select fid from T_CAL_ClosePeriodCheck where FUserID is null");
        IRowSet rowSet2 = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        if (rowSet.size() < rowSet2.size()) {
            sql.setLength(0);
            sql.append(" insert into T_CAL_ClosePeriodCheck (fid, fname, FDescription_l1,FDescription_l2,FDescription_l3, FIscheck, FUserID) ");
            sql.append(" (select newbosid('B049A0F1') , t1.fname,t1.FDescription_l1,t1.FDescription_l2,t1.FDescription_l3,t1.FIscheck,'").append(userId).append("'");
            sql.append("  FROM  T_CAL_ClosePeriodCheck as t1 where FUserID is null and fname not in (");
            sql.append(" SELECT fname FROM  T_CAL_ClosePeriodCheck  where FUserID = 'ZpH5+kO6Se+ty7o0bOgBjRO33n8=' )");
            sql.append(")");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
        }
    }

    public List<Map> getCheckData() throws BOSException, EASBizException {
        String loc = this.ctx.getLocale().toString();
        String userId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from T_CAL_ClosePeriodCheck where FUserID = ?");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{userId});
        ArrayList<Map> rows = new ArrayList<Map>();
        HashMap<String, Object> row = null;
        try {
            while (rs.next()) {
                row = new HashMap<String, Object>();
                row.put("id", rs.getString("fid"));
                row.put("name", rs.getString("fname"));
                row.put("description", rs.getString("FDescription_" + loc));
                row.put("ischeck", rs.getInt("FIscheck"));
                row.put("userid", rs.getString("FUserID"));
                rows.add(row);
            }
        }
        catch (SQLException e) {
            throw new BOSException();
        }
        return rows;
    }

    protected List<String> getNeedCheckData() throws BOSException, EASBizException {
        String userId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from T_CAL_ClosePeriodCheck where FUserID = ? and FIscheck = 1");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{userId});
        ArrayList<String> checkedList = new ArrayList<String>();
        try {
            while (rs.next()) {
                checkedList.add(rs.getString("fname"));
            }
        }
        catch (SQLException e) {
            throw new BOSException();
        }
        return checkedList;
    }

    protected void setCheck(String ids) throws BOSException, EASBizException {
        Object[] idarray = ids.split(",");
        String userId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" update  T_CAL_ClosePeriodCheck  set FIscheck =1 where FUserID = ? ");
        sql.append(" and fid in (").append(CalUtils.arrayToString(idarray)).append(")");
        DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{userId});
    }

    public void saveCheckItems(List params) throws BOSException, EASBizException {
        String[] sqls = new String[params.size()];
        Map row = new HashMap();
        StringBuffer sql = new StringBuffer();
        int size = params.size();
        for (int i = 0; i < size; ++i) {
            row = (Map)params.get(i);
            sql.setLength(0);
            sql.append(" update  T_CAL_ClosePeriodCheck  set FIscheck = ").append(Integer.parseInt(row.get("ischeck").toString()));
            sql.append("  where fid = '").append(row.get("billid")).append("'");
            sqls[i] = sql.toString();
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString();
        SQLUtils.executeBatch((Context)this.ctx, (String[])sqls);
    }

    private String getStrResource(String resKey, Locale local) {
        return EASResource.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)resKey);
    }

    private String getStrResource(String resKey, String[] params, Locale local) {
        String s = this.getStrResource(resKey, local);
        MessageFormat mf = new MessageFormat(s);
        String result = mf.format(params);
        return result;
    }
}

