/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.cal.app.closeAccount;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.scmcommon.tools.BizCommand;
import com.kingdee.eas.ma.scmcommon.tools.SQLUtils;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceModelCache;
import com.kingdee.eas.scm.framework.balance.app.engine.ProfitCenterBalanceCalculator;
import java.util.Map;

public class ReCloseAccountService
extends BizCommand {
    public ReCloseAccountService(Context ctx) {
        super(ctx);
    }

    public String getTaskID() {
        return null;
    }

    protected Object doing(Object inParam) throws BOSException, EASBizException {
        ProfitCenterOrgUnitInfo profitCenter = (ProfitCenterOrgUnitInfo)((Map)inParam).get("profitCenter");
        PeriodInfo currPeriod = (PeriodInfo)((Map)inParam).get("currPeriod");
        this.unClosePeriod(this.ctx, profitCenter, currPeriod);
        return null;
    }

    private void unClosePeriod(ProfitCenterOrgUnitInfo profitCenter, PeriodInfo currPeriod) throws EASBizException, BOSException {
        String profitCenterId = profitCenter.getId().toString();
        PeriodInfo prePeriodInfo = PeriodUtils.getPrePeriodInfo((Context)this.ctx, (PeriodInfo)currPeriod);
        boolean isAdjustPeriod = prePeriodInfo.isIsAdjustPeriod();
        if (isAdjustPeriod) {
            prePeriodInfo = PeriodUtils.getPrePeriodInfo((Context)this.ctx, (PeriodInfo)currPeriod);
        }
        PeriodInfo startPeriod = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx).getProfitStartPeriod(1007, profitCenterId);
        if (prePeriodInfo.getId().equals((Object)startPeriod.getId())) {
            this.deleteBalanceData4Start(profitCenterId);
            this.updateBalanceData4Start(prePeriodInfo, profitCenterId);
        } else {
            this.deleteBalanceData(currPeriod, profitCenterId);
            this.updateBalanceData(prePeriodInfo, profitCenterId);
        }
        this.updatePeriod((OrgUnitInfo)profitCenter, isAdjustPeriod);
    }

    private void unClosePeriod(Context ctx, ProfitCenterOrgUnitInfo profitCenter, PeriodInfo currPeriod) throws BOSException, EASBizException {
        PeriodInfo prePeriodInfo = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)currPeriod);
        ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodInfo startPeriodInfo = iSystemStatusCtrol.getProfitStartPeriod(1007, profitCenter.getId().toString());
        boolean isAdjustPeriod = prePeriodInfo.isIsAdjustPeriod();
        if (isAdjustPeriod) {
            prePeriodInfo = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)currPeriod);
        }
        ProfitCenterBalanceCalculator calculator = null;
        BalanceModelInfo balanceModelInfo = BalanceModelCache.getBalanceModelInfo((Context)ctx, (String)"c6oAAABdahQj1GIy");
        calculator = new ProfitCenterBalanceCalculator(ctx, balanceModelInfo);
        calculator.calculate(profitCenter.getId().toString(), currPeriod, OperationTypeEnum.Reverse, startPeriodInfo);
        this.updatePeriod((OrgUnitInfo)profitCenter, isAdjustPeriod);
    }

    private void deleteBalanceData4Start(String profitCenterId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete T_CAL_InventoryBalance ");
        sql.append(" where FProfitCenterID = ? and FInitFlag = 0");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{profitCenterId});
    }

    private void deleteBalanceData(PeriodInfo nextPeriodInfo, String profitCenterId) throws BOSException {
        int year = nextPeriodInfo.getPeriodYear();
        int periodNumber = nextPeriodInfo.getPeriodNumber();
        StringBuffer sql = new StringBuffer();
        sql.append(" delete T_CAL_InventoryBalance ");
        sql.append(" where FYear = ? and FPeriod = ? ");
        sql.append(" and FProfitCenterID = ? and FInitFlag = 0");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{year, periodNumber, profitCenterId});
    }

    private void updateBalanceData(PeriodInfo currPeriod, String profitCenterId) throws BOSException {
        int year = currPeriod.getPeriodYear();
        int periodNumber = currPeriod.getPeriodNumber();
        StringBuffer sql = new StringBuffer();
        sql.append(" update  T_CAL_InventoryBalance ");
        sql.append(" set ");
        sql.append(" FPeriodEndQty = 0 ,FPeriodReceiptQty = 0,FPeriodIssueQty=0,FPeriodEndBalance=0,");
        sql.append(" FPeriodReceiptAmount=0,FPeriodIssueAmount=0,FYearPeriodIssueAmount=0,FYearPeriodReceiptAmount=0,FYearReceiptQty=0,FYearPeriodIssueQty=0 ");
        sql.append(" where FYear = ? and FPeriod = ? ");
        sql.append(" and FProfitCenterID = ? and FInitFlag = 0");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{year, periodNumber, profitCenterId});
    }

    private void updateBalanceData4Start(PeriodInfo currPeriod, String profitCenterId) throws BOSException {
        int year = currPeriod.getPeriodYear();
        int periodNumber = currPeriod.getPeriodNumber();
        StringBuffer sql = new StringBuffer();
        sql.append(" update  T_CAL_InventoryBalance ");
        sql.append(" set ");
        sql.append(" FPeriodEndQty = 0 ,FPeriodReceiptQty = 0,FPeriodIssueQty=0,FPeriodEndBalance=0,");
        sql.append(" FPeriodReceiptAmount=0,FPeriodIssueAmount=0,FYearPeriodIssueAmount = FYearPeriodIssueAmount-FPeriodIssueAmount,");
        sql.append(" FYearPeriodReceiptAmount = FYearPeriodReceiptAmount-FPeriodReceiptAmount ,");
        sql.append("  FYearReceiptQty = FYearReceiptQty-FPeriodReceiptQty ,FYearPeriodIssueQty= FYearPeriodIssueQty- FPeriodIssueQty ");
        sql.append(" where FYear = ? and FPeriod = ? ");
        sql.append(" and FProfitCenterID = ? and FInitFlag = 1");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{year, periodNumber, profitCenterId});
    }

    private void updatePeriod(OrgUnitInfo orgInfo, boolean isAdjustPeriod) throws EASBizException, BOSException {
        ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx);
        iSystemStatusCtrol.prePeriod(SystemEnum.PROFIT_CENTER_STORAGE, orgInfo);
        if (isAdjustPeriod) {
            iSystemStatusCtrol.prePeriod(SystemEnum.PROFIT_CENTER_STORAGE, orgInfo);
        }
    }
}

