/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.cal.app.issueCalculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.ma.cal.app.issueCalculate.Calculater;
import com.kingdee.eas.ma.cal.app.issueCalculate.MaterialDimension;
import com.kingdee.eas.ma.scmcommon.tools.SQLUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class CalculateCommon {
    private Calculater pCmd = null;
    private MaterialDimension dim = null;
    private AccountType accountType = null;
    private String materialId = null;

    public CalculateCommon(Calculater pCmd, String materialId, MaterialDimension dim, AccountType accountType) {
        this.pCmd = pCmd;
        this.dim = dim;
        this.accountType = accountType;
        this.materialId = materialId;
    }

    public Map<String, BigDecimal[]> sumBalance() throws Exception {
        HashMap<String, BigDecimal[]> calMap = new HashMap<String, BigDecimal[]>();
        StringBuffer sbSql = new StringBuffer();
        String groupCols = this.dim.getSelect(null, 0);
        sbSql.append("select ").append(groupCols).append(" ,sum(FPeriodBeginQty) sumQty, ").append(" sum(FPeriodBeginBalance) sumCost ").append(" from T_CAL_InventoryBalance ").append(" where FProfitCenterID = ? ").append(" and FYear = ? ").append(" and FPeriod = ? ").append(" and FMaterialID = ? ").append(" group by ").append(groupCols);
        String key = null;
        PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)this.pCmd.getContext()).getPeriodInfo((IObjectPK)new ObjectUuidPK(this.pCmd.periodId));
        Object[] sqlParams = new Object[]{this.pCmd.profitCenterOrgId, periodInfo.getPeriodYear(), periodInfo.getPeriodNumber(), this.materialId};
        IRowSet rsBal = this.pCmd.executeQuery(sbSql.toString(), sqlParams);
        while (rsBal.next()) {
            key = this.dim.buildKey(rsBal, 0);
            if (calMap.containsKey(key)) {
                throw new Exception("balance data error! val:" + key);
            }
            BigDecimal[] data = new BigDecimal[5];
            data[0] = rsBal.getBigDecimal("sumQty");
            data[1] = rsBal.getBigDecimal("sumCost");
            calMap.put(key, data);
        }
        return calMap;
    }

    public String reportHead(String key, boolean isSuccess, String remark) throws Exception {
        if (!this.pCmd.isReport()) {
            return null;
        }
        Map<String, String> retMap = this.dim.keyToInsert(key, 2);
        int status = isSuccess ? 10 : 20;
        String reportId = BOSUuid.create((String)"7555A043").toString();
        StringBuffer sbReport = new StringBuffer();
        sbReport.append("insert into T_CAL_IssueCalculateReport (").append("FID,FProfitCenterOrgID,FPeriodID,FAccountType,FMaterialDemension,FStatus,FRemark ").append(retMap.get("insertField")).append(") ").append("values ('").append(reportId).append("','").append(this.pCmd.profitCenterOrgId).append("','").append(this.pCmd.periodId).append("',").append(this.accountType.getValue()).append(",'").append(this.dim.getStr()).append("',").append(status).append(",'").append(remark).append("' ").append(retMap.get("insertVal")).append(") ");
        this.pCmd.execute(sbReport.toString());
        return reportId;
    }

    public void reportEnd(String reportId, String result) throws Exception {
        if (reportId == null) {
            return;
        }
        String periodEnd = EASResource.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"periodEnd");
        StringBuffer sbReport = new StringBuffer();
        String entryId = BOSUuid.create((String)"98AE2674").toString();
        sbReport.append("insert T_CAL_IssueCalRepDetail (").append("FID,FSEQ,FBillNumber,FProfitCenOrgId,FPeriodId,FParentID,FBalance) ").append("values ('").append(entryId).append("',9,'").append(periodEnd).append("','").append(this.pCmd.profitCenterOrgId).append("','").append(this.pCmd.periodId).append("','").append(reportId).append("','").append(result).append("') ");
        this.pCmd.execute(sbReport.toString());
    }

    public static String createTempTable(Context ctx, String sql) throws BOSException {
        String tblName = null;
        try {
            tblName = SQLUtils.createTempTableWithNewTx((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            throw new BOSException("cannot create tempTable", (Throwable)e);
        }
        return tblName;
    }

    public static void releaseTemptable(Context ctx, String tableName) {
        TempTablePool tmpTblPool = TempTablePool.getInstance((Context)ctx);
        if (tableName != null) {
            tmpTblPool.releaseTable(tableName);
        }
    }
}

