/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.cal.app.issueCalculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.cal.CalculateException;
import com.kingdee.eas.ma.cal.app.issueCalculate.AverageCalculater;
import com.kingdee.eas.ma.cal.app.issueCalculate.CalculateCommon;
import com.kingdee.eas.ma.cal.app.issueCalculate.IAccountTypeCalculate;
import com.kingdee.eas.ma.cal.app.issueCalculate.MaterialDimension;
import com.kingdee.eas.ma.cal.app.issueCalculate.MoveAverageCalculater;
import com.kingdee.eas.ma.scmcommon.ITaskProgressFacade;
import com.kingdee.eas.ma.scmcommon.TaskProgressFacadeFactory;
import com.kingdee.eas.ma.scmcommon.tools.BizCommand;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class Calculater
extends BizCommand {
    private String taskID = null;
    private Map<String, Object> params = null;
    public static final String BILL_BOSTYPE = "7555A043";
    public static final String ENTRY_BOSTYPE = "98AE2674";
    public static final int MAX_PRECISION = 8;
    public String profitCenterOrgId = null;
    public String periodId = null;
    public boolean isWriteReport = true;
    public boolean onlyReportError = false;
    AccountType[] accoutTypes = null;
    public int currencyPrecision = 4;
    String mainTempTable = null;
    int totalOfMaterial = 0;

    public Calculater(Context ctx) {
        super(ctx);
    }

    public void setTaskID(String taskID) {
        this.taskID = taskID;
    }

    public String getTaskID() {
        return this.taskID;
    }

    protected Object doing(Object inParam) throws BOSException, EASBizException {
        this.params = (Map)inParam;
        if (this.params == null) {
            throw new BOSException("params type error,type is Map<String,Object> ");
        }
        try {
            this.profitCenterOrgId = (String)this.params.get("profitCenterOrgId");
            this.periodId = (String)this.params.get("periodId");
            this.isWriteReport = (Boolean)this.params.get("isWriteReport");
            this.onlyReportError = (Boolean)this.params.get("onlyReportError");
            this.accoutTypes = (AccountType[])this.params.get("accountType");
            if (this.accoutTypes == null) {
                throw new CalculateException(CalculateException.NULLACCOUTTYPE);
            }
            this.deleteOldData();
            this.prepare();
            this.calculate();
        }
        finally {
            CalculateCommon.releaseTemptable(this.ctx, this.mainTempTable);
        }
        return null;
    }

    private void deleteOldData() throws EASBizException, BOSException {
        Object[] sqlParams = new Object[]{this.profitCenterOrgId};
        String sql = "delete from T_CAL_IssueCalRepDetail where FProfitCenOrgId = ? ";
        this.execute(sql, sqlParams);
        sql = "delete from T_CAL_IssueCalculateReport where FProfitCenterOrgID = ? ";
        this.execute(sql, sqlParams);
    }

    private int getBaseCurrencyPrecision(String profitCentrerId) throws EASBizException, BOSException {
        int precision = 8;
        String sql = "select t0.fid,t0.fprecision from T_BD_Currency t0 inner join T_ORG_Company t1 on t0.FID = t1.FBaseCurrencyID inner join T_ORG_UnitRelation t2 on t2.FToUnitID = t1.FID inner join T_ORG_TypeRelation t3 on t2.FTypeRelationID = t3.FID where t2.FFromUnitID = ? and t3.FFromType = ? and t3.FToType = ? ";
        IRowSet rs = this.executeQuery(sql, new Object[]{profitCentrerId, 6, 1});
        try {
            if (rs.next()) {
                precision = rs.getInt("fprecision");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return precision;
    }

    protected void prepare() throws BOSException, EASBizException {
        this.currencyPrecision = this.getBaseCurrencyPrecision(this.profitCenterOrgId);
        StringBuffer sbSql = new StringBuffer(200);
        sbSql.append("Create Table vtkkkkaaa ( ").append("KSQL_SEQ INT IDENTITY (1, 1) NOT NULL primary key,").append("FMaterialID VARCHAR(44),").append("FAccountType INT DEFAULT 0 NOT NULL ,").append("FIsLot INT DEFAULT 0 NULL, ").append("FIsAssistProperty INT DEFAULT 0  NULL, ").append("FIsProject INT DEFAULT 0  NULL, ").append("FIsTrackNumber INT DEFAULT 0 NULL, ").append("FPricePrecision INT DEFAULT 8 NOT NULL, ").append("FQtyPrecision INT DEFAULT 8 NOT NULL ").append(")");
        this.mainTempTable = CalculateCommon.createTempTable(this.ctx, sbSql.toString());
        StringBuffer accoutTypesFilter = new StringBuffer();
        int size = this.accoutTypes.length;
        for (int i = 0; i < size; ++i) {
            accoutTypesFilter.append(this.accoutTypes[i].getValue());
            if (i >= size - 1) continue;
            accoutTypesFilter.append(",");
        }
        sbSql.setLength(0);
        sbSql.append("insert into ").append(this.mainTempTable);
        sbSql.append(" (KSQL_SEQ,FMaterialID,FAccountType,FIsLot,FIsAssistProperty,FIsProject,FIsTrackNumber,FPricePrecision,FQtyPrecision) ");
        sbSql.append(" select materialProfit.FMaterialId,materialProfit.FAccountType,materialProfit.FIsLot,materialProfit.FIsAssistProperty,materialProfit.FIsProject,materialProfit.FIsTrackNumber");
        sbSql.append(" ,material.FPricePrecision,baseUnit.FQtyPrecision");
        sbSql.append(" from T_BD_MATERIALPROFITCENTERINFO materialProfit");
        sbSql.append(" inner join T_BD_Material material on materialProfit.FMaterialID = material.FID");
        sbSql.append(" inner join T_BD_MeasureUnit  baseUnit on  material.FBaseUnit = baseUnit.FID");
        sbSql.append(" where materialProfit.FAccountType in (").append(accoutTypesFilter).append(" )");
        sbSql.append(" and materialProfit.FStatus = 1 ");
        sbSql.append(" and materialProfit.FPROFITCENTERID ='").append(this.profitCenterOrgId).append("'");
        String materialFilter = (String)this.params.get("materialFilter");
        if (materialFilter != null) {
            sbSql.append("and materialProfit.FmaterialId in (").append(materialFilter).append(")");
        }
        sbSql.append(" and ( exists( select 1 from T_CAL_InvAccountBill invbill ");
        sbSql.append("   where  invbill.fprofitCenterId = materialProfit.FPROFITCENTERID");
        sbSql.append("   and invbill.fmaterialid = materialProfit.fmaterialID");
        sbSql.append("   and invbill.fperiodid = '").append(this.periodId).append("'");
        sbSql.append("   )");
        sbSql.append("  or exists(select 1 from T_CAL_InventoryBalance balance");
        sbSql.append("  inner join t_bd_period period on  balance.Fyear = period.FPeriodYear  and balance.FPeriod = period.FPeriodNumber");
        sbSql.append("  where balance.fprofitCenterId = materialProfit.FPROFITCENTERID");
        sbSql.append("  and balance.fmaterialid = materialProfit.fmaterialID");
        sbSql.append("  and period.fid = '").append(this.periodId).append("'");
        sbSql.append("  )");
        sbSql.append(")");
        sbSql.append("group by materialProfit.FMaterialId,materialProfit.FAccountType,materialProfit.FIsLot,materialProfit.FIsAssistProperty,materialProfit.FIsProject,materialProfit.FIsTrackNumber,material.FPricePrecision,baseUnit.FQtyPrecision");
        this.totalOfMaterial = this.execute(sbSql.toString());
    }

    protected void calculate() throws EASBizException, BOSException {
        String materialId = null;
        int[] materialDimension = new int[4];
        AccountType accountType = null;
        ITaskProgressFacade progressFacade = TaskProgressFacadeFactory.getLocalInstance((Context)this.ctx);
        int fromRow = 1;
        int toRow = 100;
        int index = 1;
        int pecent = 0;
        HashMap<String, Object> progressMap = new HashMap<String, Object>();
        progressMap.put("TaskID", this.getTaskID());
        IAccountTypeCalculate calculater = null;
        StringBuffer sbSql = new StringBuffer(200);
        sbSql.append("select FMaterialID,FAccountType,FIsLot,FIsAssistProperty,FIsProject,FIsTrackNumber,FPricePrecision,FQtyPrecision from ").append(this.mainTempTable).append(" where KSQL_SEQ between ? and ? ");
        IRowSet rs = this.executeQuery(sbSql.toString(), new Object[]{fromRow, toRow});
        try {
            while (rs.size() > 0) {
                while (rs.next()) {
                    materialId = rs.getString("FMaterialID");
                    int FIsLot = rs.getInt("FIsLot");
                    int FIsAssistProperty = rs.getInt("FIsAssistProperty");
                    int FIsProject = rs.getInt("FIsProject");
                    int FIsTrackNumber = rs.getInt("FIsTrackNumber");
                    accountType = AccountType.getEnum((int)rs.getInt("FAccountType"));
                    int pricePrecision = rs.getInt("FPricePrecision");
                    int qtyPrecision = rs.getInt("FQtyPrecision");
                    materialDimension[0] = FIsLot;
                    materialDimension[1] = FIsAssistProperty;
                    materialDimension[2] = FIsProject;
                    materialDimension[3] = FIsTrackNumber;
                    MaterialDimension dim = new MaterialDimension(this.ctx, materialDimension);
                    calculater = this.getCalculater(accountType, materialId, dim, pricePrecision, qtyPrecision, null);
                    if (calculater != null) {
                        calculater.calculate();
                    }
                    pecent = index * 100 / this.totalOfMaterial;
                    progressMap.put("Complete", pecent);
                    progressFacade.updateProgress(progressMap);
                    ++index;
                }
                fromRow = toRow + 1;
                rs = this.executeQuery(sbSql.toString(), new Object[]{fromRow, toRow += 100});
            }
            progressMap.put("Status", 9);
            progressMap.put("Complete", 100);
            progressFacade.updateProgress(progressMap);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private IAccountTypeCalculate getCalculater(AccountType accountType, String materialId, MaterialDimension materialDemension, int pricePrecision, int qtyPrecision, Map<String, Object> retMap) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("bizCommand", (Object)this);
        params.put("materialId", materialId);
        params.put("accountType", accountType);
        params.put("materialDemension", materialDemension);
        params.put("pricePrecision", pricePrecision);
        params.put("qtyPrecision", qtyPrecision);
        params.put("retMap", retMap);
        if (accountType.getValue() == 3 || accountType.getValue() == 5) {
            return new AverageCalculater(params);
        }
        if (accountType.getValue() == 6) {
            return new MoveAverageCalculater(params);
        }
        return null;
    }

    public boolean isReport() {
        return this.isWriteReport && !this.onlyReportError;
    }

    public boolean isReportError() {
        return this.isWriteReport && this.onlyReportError;
    }
}

