/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.cal.app.issueCalculate;

import com.kingdee.bos.Context;
import com.kingdee.eas.ma.cal.IIssueCalculateFacade;
import com.kingdee.eas.ma.cal.IssueCalculateFacadeFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MaterialDimension {
    public static final int BALA = 0;
    public static final int BILL = 1;
    public static final int REPORT = 2;
    private static final String MATERIALDIMKEY = "9999";
    private static final String LOTDIMKEY = "0";
    private static final String ASSTPROPERTYKEY = "1";
    private static final String PROJECTKEY = "2";
    private static final String TRACKNUMKEY = "3";
    private static final String SP = ";";
    private static final String NULL_STR = "null";
    private Map<String, String> balaFieldMap = new HashMap<String, String>();
    private Map<String, String> billFieldMap = new HashMap<String, String>();
    private Map<String, String> reportFieldMap = new HashMap<String, String>();
    private Map<String, String> dimNameMap = new HashMap<String, String>();
    private String[] dims = null;
    private String balaSelect = null;
    private String billSelect = null;
    private String dimNameStr = null;
    private Context ctx = null;

    public MaterialDimension(Context ctx, int[] dim) {
        this.ctx = ctx;
        this.balaFieldMap.put(MATERIALDIMKEY, "FMaterialID");
        this.balaFieldMap.put(LOTDIMKEY, "FLot");
        this.balaFieldMap.put(ASSTPROPERTYKEY, "FAssistPropertyID");
        this.balaFieldMap.put(PROJECTKEY, "FProjectID");
        this.balaFieldMap.put(TRACKNUMKEY, "FTrackNumberID");
        this.billFieldMap.put(MATERIALDIMKEY, "FMaterialID");
        this.billFieldMap.put(LOTDIMKEY, "FLot");
        this.billFieldMap.put(ASSTPROPERTYKEY, "FAssistPropertyID");
        this.billFieldMap.put(PROJECTKEY, "FProjectID");
        this.billFieldMap.put(TRACKNUMKEY, "FTrackNumberID");
        this.reportFieldMap.put(MATERIALDIMKEY, "FMaterialID");
        this.reportFieldMap.put(LOTDIMKEY, "FLot");
        this.reportFieldMap.put(ASSTPROPERTYKEY, "FAssistPropertyID");
        this.reportFieldMap.put(PROJECTKEY, "FProjectID");
        this.reportFieldMap.put(TRACKNUMKEY, "FTrackNumID");
        this.dimNameMap.put(MATERIALDIMKEY, this.getResString(MATERIALDIMKEY));
        this.dimNameMap.put(LOTDIMKEY, this.getResString(LOTDIMKEY));
        this.dimNameMap.put(ASSTPROPERTYKEY, this.getResString(ASSTPROPERTYKEY));
        this.dimNameMap.put(PROJECTKEY, this.getResString(PROJECTKEY));
        this.dimNameMap.put(TRACKNUMKEY, this.getResString(TRACKNUMKEY));
        try {
            IIssueCalculateFacade icf = IssueCalculateFacadeFactory.getLocalInstance(ctx);
            List custDimList = icf.getCustMaterialDims();
            if (custDimList != null && custDimList.size() > 0) {
                int size = custDimList.size();
                for (int i = 0; i < size; ++i) {
                    Map materialdim = (Map)custDimList.get(i);
                    String key = (String)materialdim.get("value");
                    String fieldname = (String)materialdim.get("fieldname");
                    String name = (String)materialdim.get("name");
                    if (key == MATERIALDIMKEY || key == LOTDIMKEY || key == ASSTPROPERTYKEY || key == PROJECTKEY || key == TRACKNUMKEY) continue;
                    this.balaFieldMap.put(key, fieldname);
                    this.billFieldMap.put(key, fieldname);
                    this.reportFieldMap.put(key, fieldname);
                    this.dimNameMap.put(key, name);
                }
            }
        }
        catch (Exception icf) {
            // empty catch block
        }
        this.dimNameStr = null;
        if (dim != null) {
            ArrayList<String> dimsList = new ArrayList<String>();
            dimsList.add(MATERIALDIMKEY);
            int size = dim.length;
            for (int i = 0; i < size; ++i) {
                if (dim[i] == 0) continue;
                dimsList.add(i + "");
                this.dimNameStr = this.dimNameStr == null ? this.dimNameMap.get(i + "") : this.dimNameStr + "+" + this.dimNameMap.get(i + "");
            }
            this.dims = new String[dimsList.size()];
            dimsList.toArray(this.dims);
        } else {
            this.dimNameStr = "";
            this.dims = new String[]{MATERIALDIMKEY};
        }
        if (this.dimNameStr == null) {
            this.dimNameStr = "";
        }
    }

    private String getResString(String resourceName) {
        String RESOURCE_PATH = "com.kingdee.eas.ma.cal.MaterialDimResource";
        String strTemp = ResourceBase.getString((String)RESOURCE_PATH, (String)resourceName, (Locale)this.ctx.getLocale());
        if (strTemp.equals("Missing Resource")) {
            return "Missing Resource{" + resourceName + "}";
        }
        return strTemp;
    }

    public String getStr() {
        return this.dimNameStr;
    }

    private Map<String, String> getFieldMap(int type) {
        if (0 == type) {
            return this.balaFieldMap;
        }
        if (1 == type) {
            return this.billFieldMap;
        }
        if (2 == type) {
            return this.reportFieldMap;
        }
        return null;
    }

    public String getTableFields(int type) {
        Map<String, String> fieldMap = this.getFieldMap(type);
        StringBuffer fields = new StringBuffer();
        String fieldtype = null;
        String key = null;
        for (int i = 0; i < this.dims.length; ++i) {
            key = this.dims[i];
            fieldtype = key == MATERIALDIMKEY || key == ASSTPROPERTYKEY || key == PROJECTKEY || key == TRACKNUMKEY ? "varchar(44)" : (key == LOTDIMKEY ? "varchar(255)" : "varchar(100)");
            fields.append(fieldMap.get(key)).append(" ").append(fieldtype).append(",");
        }
        return fields.toString();
    }

    public String getSelect(String alias, int type) {
        if (type == 0) {
            if (this.balaSelect == null) {
                this.balaSelect = this.getSelect_p(alias, 1);
            }
            return this.balaSelect;
        }
        if (this.billSelect == null) {
            this.billSelect = this.getSelect_p(alias, 0);
        }
        return this.billSelect;
    }

    private String getSelect_p(String alias, int type) {
        Map<String, String> fieldMap = this.getFieldMap(type);
        alias = alias == null ? "" : alias + ".";
        String select = alias + fieldMap.get(this.dims[0]);
        for (int i = 1; i < this.dims.length; ++i) {
            select = select + "," + alias + fieldMap.get(this.dims[i]);
        }
        return select;
    }

    public String buildKey(IRowSet rs, int type) throws Exception {
        Map<String, String> fieldMap = this.getFieldMap(type);
        String key = "";
        int size = this.dims.length;
        for (int i = 0; i < size; ++i) {
            key = key + this.nullIsnull(rs.getString(fieldMap.get(this.dims[i]))) + SP;
        }
        return key;
    }

    public Map<String, Object> keyToWhere(String key, int type, String alias) {
        Map<String, String> fieldMap = this.getFieldMap(type);
        alias = alias == null ? "" : alias + ".";
        String where = "";
        String[] vals = key.split(SP);
        String val = null;
        ArrayList<String> params = new ArrayList<String>();
        int size = vals.length;
        for (int i = 0; i < size; ++i) {
            val = vals[i];
            if (val.length() != 0) {
                where = where + " and " + alias + fieldMap.get(this.dims[i]) + " = ? ";
                params.add(val);
                continue;
            }
            if (!val.equals(NULL_STR)) continue;
            where = where + " and " + alias + fieldMap.get(this.dims[i]) + " is null ";
            params.add(val);
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put("where", where);
        retMap.put("params", params);
        return retMap;
    }

    public Map<String, String> keyToInsert(String key, int type) {
        Map<String, String> fieldMap = this.getFieldMap(type);
        String insertField = "";
        String insertVal = "";
        String[] vals = key.split(SP);
        String val = null;
        int size = vals.length;
        for (int i = 0; i < size; ++i) {
            val = vals[i];
            if (val.length() == 0 || val.equals(NULL_STR)) continue;
            insertField = insertField + "," + fieldMap.get(this.dims[i]);
            insertVal = insertVal + ",'" + val + "'";
        }
        HashMap<String, String> retMap = new HashMap<String, String>();
        retMap.put("insertField", insertField);
        retMap.put("insertVal", insertVal);
        return retMap;
    }

    private String nullIsnull(String s) {
        return s == null ? NULL_STR : s;
    }
}

