/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.ma.control.AbstractBgControlExpendRuleInfo;
import com.kingdee.eas.ma.control.BgControlExpendEntryInfo;
import com.kingdee.eas.ma.control.utils.BizDataObject;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BgControlExpendRuleInfo
extends AbstractBgControlExpendRuleInfo
implements Serializable {
    private List<MatchInfo> matchInfos = null;

    public BgControlExpendRuleInfo() {
    }

    protected BgControlExpendRuleInfo(String pkField) {
        super(pkField);
    }

    public MatchInfo matchExecuteValue(BigDecimal executeValue) throws BOSException {
        if (this.getEntry().isEmpty()) {
            throw new BOSException("no select entry");
        }
        this.initMatchInfos();
        MatchInfo matchInfo = this.search(executeValue, 0, this.matchInfos.size() / 2, this.matchInfos.size() - 1);
        return matchInfo;
    }

    private MatchInfo search(BigDecimal executeValue, int startIndex, int curIndex, int endIndex) {
        for (MatchInfo matchInfo : this.matchInfos) {
            if (!matchInfo.match(executeValue)) continue;
            return matchInfo;
        }
        return null;
    }

    private void initMatchInfos() {
        if (this.matchInfos != null) {
            return;
        }
        this.matchInfos = new ArrayList<MatchInfo>();
        if (this.getEntry().isEmpty()) {
            return;
        }
        FilterInfo filter = null;
        BgControlExpendEntryInfo entry = null;
        StringBuffer maskString = new StringBuffer();
        MatchInfo[] infos = null;
        MatchInfo[] filterInfos = null;
        BizDataObject bizData = null;
        for (int i = 0; i < this.getEntry().size(); ++i) {
            int f;
            entry = this.getEntry().get(i);
            bizData = entry.getBizData();
            filter = this.getFilterInfo(bizData);
            if (filter == null || filter.getFilterItems().isEmpty()) {
                return;
            }
            maskString.setLength(0);
            if (StringUtils.isEmpty((String)filter.getMaskString())) {
                for (f = 0; f < filter.getFilterItems().size(); ++f) {
                    if (f > 0) {
                        maskString.append(" and ");
                    }
                    maskString.append("#").append(f);
                }
            } else {
                maskString.append(filter.getMaskString().toLowerCase());
            }
            filterInfos = new MatchInfo[filter.getFilterItems().size()];
            for (f = 0; f < filter.getFilterItems().size(); ++f) {
                filterInfos[f] = new MatchInfo();
                if (CompareType.EQUALS.equals((Object)filter.getFilterItems().get(f).getCompareType())) {
                    filterInfos[f].minValue = new BigDecimal((String)filter.getFilterItems().get(f).getCompareValue());
                    filterInfos[f].maxValue = new BigDecimal((String)filter.getFilterItems().get(f).getCompareValue());
                    filterInfos[f].isMaxEquals = true;
                    filterInfos[f].isMinEquals = true;
                    continue;
                }
                if (CompareType.GREATER.equals((Object)filter.getFilterItems().get(f).getCompareType())) {
                    filterInfos[f].minValue = new BigDecimal((String)filter.getFilterItems().get(f).getCompareValue());
                    filterInfos[f].isMinEquals = false;
                    continue;
                }
                if (CompareType.GREATER_EQUALS.equals((Object)filter.getFilterItems().get(f).getCompareType())) {
                    filterInfos[f].minValue = new BigDecimal((String)filter.getFilterItems().get(f).getCompareValue());
                    filterInfos[f].isMinEquals = true;
                    continue;
                }
                if (CompareType.LESS.equals((Object)filter.getFilterItems().get(f).getCompareType())) {
                    filterInfos[f].maxValue = new BigDecimal((String)filter.getFilterItems().get(f).getCompareValue());
                    filterInfos[f].isMaxEquals = false;
                    continue;
                }
                if (CompareType.LESS_EQUALS.equals((Object)filter.getFilterItems().get(f).getCompareType())) {
                    filterInfos[f].maxValue = new BigDecimal((String)filter.getFilterItems().get(f).getCompareValue());
                    filterInfos[f].isMaxEquals = true;
                    continue;
                }
                throw new RuntimeException("No Support Compare Type:" + filter.getFilterItems().get(f).getCompareType());
            }
            infos = this.buildMatchs(filterInfos, maskString.toString().replaceAll(" ", ""));
            if (infos == null) continue;
            for (int m = 0; m < infos.length; ++m) {
                infos[m].value = entry.getBgCtrlParam();
                infos[m].displayValue = bizData.getDisplay();
                this.matchInfos.add(infos[m]);
            }
        }
        Collections.sort(this.matchInfos);
    }

    private MatchInfo[] buildMatchs(MatchInfo[] filterInfos, String maskString) {
        MatchInfo result = null;
        for (int i = 0; i < filterInfos.length; ++i) {
            if (result == null) {
                result = filterInfos[i].clone();
                continue;
            }
            result.and(filterInfos[i]);
        }
        return new MatchInfo[]{result};
    }

    private FilterInfo getFilterInfo(BizDataObject bizData) {
        try {
            FilterInfo info = new FilterInfo(bizData.getValue());
            if (!StringUtils.isEmpty((String)bizData.getMaskString())) {
                info.setMaskString(bizData.getMaskString());
            }
            return info;
        }
        catch (ParserException e) {
            throw new RuntimeException(e);
        }
    }

    public static class MatchInfo
    implements Comparable<MatchInfo>,
    Cloneable {
        private BigDecimal minValue = null;
        private boolean isMinEquals = false;
        private BigDecimal maxValue = null;
        private boolean isMaxEquals = false;
        private BigDecimal value = null;
        boolean isSearch = false;
        private String displayValue = null;

        public BigDecimal getValue() {
            return this.value;
        }

        public String getDisplayValue() {
            return this.displayValue;
        }

        public void and(MatchInfo matchInfo) {
            if (matchInfo.minValue != null) {
                if (this.minValue == null) {
                    this.minValue = matchInfo.minValue;
                    this.isMinEquals = matchInfo.isMinEquals;
                } else if (this.minValue.compareTo(matchInfo.minValue) == 0) {
                    if (!matchInfo.isMinEquals) {
                        this.isMinEquals = false;
                    }
                } else if (this.minValue.compareTo(matchInfo.minValue) < 0) {
                    this.minValue = matchInfo.minValue;
                    this.isMinEquals = matchInfo.isMinEquals;
                }
            }
            if (matchInfo.maxValue != null) {
                if (this.maxValue == null) {
                    this.maxValue = matchInfo.maxValue;
                    this.isMaxEquals = matchInfo.isMaxEquals;
                } else if (this.maxValue.compareTo(matchInfo.maxValue) == 0) {
                    if (!matchInfo.isMaxEquals) {
                        this.isMaxEquals = false;
                    }
                } else if (this.maxValue.compareTo(matchInfo.maxValue) > 0) {
                    this.maxValue = matchInfo.maxValue;
                    this.isMaxEquals = matchInfo.isMaxEquals;
                }
            }
        }

        @Override
        public int compareTo(MatchInfo o) {
            if (o.minValue != null && this.match(o.minValue)) {
                if (o.isSearch) {
                    return 0;
                }
                if (o.maxValue == null && this.maxValue != null) {
                    return -1;
                }
                if (this.minValue == null && o.minValue != null) {
                    return -1;
                }
                if (this.maxValue == null && o.maxValue != null) {
                    return 1;
                }
                if (o.minValue == null && this.minValue != null) {
                    return 1;
                }
                return 0;
            }
            if (this.minValue == null) {
                return -1;
            }
            if (o.minValue == null) {
                return 1;
            }
            int value = this.minValue.compareTo(o.minValue);
            if (!this.isMinEquals && value == 0) {
                return -1;
            }
            return value;
        }

        public boolean match(BigDecimal executeValue) {
            int compareValue = 0;
            if (this.minValue != null) {
                compareValue = executeValue.compareTo(this.minValue);
                if (this.isMinEquals && compareValue < 0) {
                    return false;
                }
                if (!this.isMinEquals && compareValue <= 0) {
                    return false;
                }
            }
            if (this.maxValue != null) {
                compareValue = executeValue.compareTo(this.maxValue);
                if (this.isMaxEquals && compareValue > 0) {
                    return false;
                }
                if (!this.isMaxEquals && compareValue >= 0) {
                    return false;
                }
            }
            return true;
        }

        public MatchInfo clone() {
            try {
                return (MatchInfo)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

