/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control;

import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.eas.ma.control.AbstractBgControlSettingInfo;
import com.kingdee.eas.ma.control.BgCtrlPeriodTypeEnum;
import com.kingdee.eas.ma.control.BgCtrlTypeEnum;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;

public class BgControlSettingInfo
extends AbstractBgControlSettingInfo
implements Serializable {
    public static int INDEX_SETTING = 1;
    public static int SCEN_INDEX_SETTING = 2;
    public static int DIM_SETTING = 3;
    public static int MEMBER_SETTING = 4;
    public static int SCEN_DIM_SETTING = 5;
    public static int SCEN_MEMBER_SETTING = 6;
    private transient int priority = 0;
    private transient Set<String> dimMembers = new HashSet<String>();
    private transient Set<String> dimSrcs = new HashSet<String>();

    public BgControlSettingInfo() {
    }

    protected BgControlSettingInfo(String pkField) {
        super(pkField);
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public void parsePriority() {
        if (this.getBgDimNumber() != null) {
            String[] tmpStrs = this.getBgDimNumber().split(":");
            if (StringUtils.isEmpty((String)this.getBgScenNumber())) {
                if (tmpStrs != null && tmpStrs.length > 1) {
                    this.setPriority(MEMBER_SETTING);
                } else {
                    this.setPriority(DIM_SETTING);
                }
            } else if (tmpStrs != null && tmpStrs.length > 1) {
                this.setPriority(SCEN_MEMBER_SETTING);
            } else {
                this.setPriority(SCEN_DIM_SETTING);
            }
        } else if (StringUtils.isEmpty((String)this.getBgScenNumber())) {
            this.setPriority(INDEX_SETTING);
        } else {
            this.setPriority(SCEN_INDEX_SETTING);
        }
    }

    public Set<String> getDimMembers() {
        return this.dimMembers;
    }

    public Set<String> getDimSrcs() {
        return this.dimSrcs;
    }

    public void parseBgDimNumber() {
        this.getDimMembers().clear();
        this.getDimMembers().add(this.getBgIndexNumber());
        this.getDimSrcs().clear();
        this.getDimSrcs().add(this.getBgIndexNumber().substring(0, 3));
        if (this.getBgDimNumber() != null) {
            String dimNum2 = null;
            String[] srcNums = null;
            String[] dimNums = this.getBgDimNumber().split("\\,");
            if (dimNums != null) {
                for (String dimNum2 : dimNums) {
                    srcNums = dimNum2.split(":");
                    if (srcNums == null) continue;
                    this.getDimSrcs().add(srcNums[0]);
                    if (srcNums.length <= 1) continue;
                    this.getDimMembers().add(dimNum2);
                }
            }
        }
    }

    public static BgControlSettingInfo getDefaultSet() {
        BgControlSettingInfo set = new BgControlSettingInfo();
        set.setCtrlType(BgCtrlTypeEnum.PeriodCtrl);
        set.setIsAllowAccess(true);
        set.setPeriodType(BgCtrlPeriodTypeEnum.Scheme);
        set.setFlexParam(BgControlConstants.ONE);
        set.setIsGroupCtrl(false);
        return set;
    }

    public static BgControlSettingInfo getNoCtrlSet() {
        BgControlSettingInfo set = new BgControlSettingInfo();
        set.setCtrlType(BgCtrlTypeEnum.NoCtrl);
        set.setIsAllowAccess(true);
        set.setPeriodType(BgCtrlPeriodTypeEnum.Scheme);
        set.setFlexParam(BgControlConstants.ONE);
        set.setIsGroupCtrl(false);
        return set;
    }

    public static boolean checkHasChange(BgControlSettingInfo source, BgControlSettingInfo change) {
        if (source == null && change == null || source == change) {
            return false;
        }
        StringBuffer skey = new StringBuffer();
        if (source != null) {
            skey.append(source.getId() + "_");
            skey.append(source.getBgIndexNumber() + "_");
            skey.append(source.getBgIndexName() + "_");
            skey.append(source.getBgDimNumber() + "_");
            skey.append(source.getBgScenNumber() + "_");
            skey.append(source.getCtrlType().getValue() + "_");
            skey.append(source.getPeriodType().getValue() + "_");
            skey.append(source.isIsAllowAccess() + "_");
            skey.append(source.getGroupNo() + "_");
            skey.append(source.getCtrlSetRule().getValue() + "_");
            skey.append(CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)source.getFlexParam()));
        }
        StringBuffer ckey = new StringBuffer();
        if (change != null) {
            ckey.append(change.getId() + "_");
            ckey.append(change.getBgIndexNumber() + "_");
            ckey.append(change.getBgIndexName() + "_");
            ckey.append(change.getBgDimNumber() + "_");
            skey.append(change.getBgScenNumber() + "_");
            ckey.append(change.getCtrlType().getValue() + "_");
            ckey.append(change.getPeriodType().getValue() + "_");
            ckey.append(change.isIsAllowAccess() + "_");
            ckey.append(change.getGroupNo() + "_");
            ckey.append(change.getCtrlSetRule().getValue() + "_");
            ckey.append(CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)change.getFlexParam()));
        }
        return !skey.toString().equals(ckey.toString());
    }
}

