/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgRuleCondition;
import com.kingdee.eas.ma.control.app.AbstractBgBaseFacadeControllerBean;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgBaseFacadeControllerBean
extends AbstractBgBaseFacadeControllerBean {
    private static final long serialVersionUID = -1752939926901632112L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.control.app.BgBaseFacadeControllerBean");
    private static final int DEFAULT_LEVEL = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _lockTransaction(Context ctx, BOSUuid orgViewId, Set orgUnitID) throws BOSException, EASBizException {
        if (ctx == null) return;
        if (orgUnitID == null) return;
        if (orgUnitID.isEmpty()) {
            return;
        }
        logger.debug((Object)("start lockTransaction: viewId(" + orgViewId + ") orgIds: (" + orgUnitID + ")"));
        Set<String> querySet = null;
        ArrayList<String> params = null;
        StringBuilder query = new StringBuilder(512);
        query.append("select FOUID from T_MBG_BgTransaction where FOUID IN (");
        for (int i = 1; i < 50; ++i) {
            query.append("?,");
        }
        query.append("?)");
        StringBuilder update = new StringBuilder(512);
        update.append("update T_MBG_BgTransaction set FCount = FCount + 1 where FOUID = ?");
        StringBuilder insert = new StringBuilder();
        insert.append("Insert Into T_MBG_BgTransaction(FOUID, FCount) values (?, 0)");
        Connection conn = null;
        Statement querySta = null;
        PreparedStatement insertSta = null;
        PreparedStatement updateSta = null;
        try {
            conn = this.getConnection(ctx);
            querySet = this.getConcurrentOrgUnitId(conn, orgViewId, orgUnitID);
            params = new ArrayList<String>();
            params.addAll(querySet);
            List rst = BgDBUtils.executeBatchQuery((Connection)conn, (String)query.toString(), params);
            if (rst.isEmpty()) {
                ArrayList<String> sqlParams = new ArrayList<String>();
                sqlParams.addAll(querySet);
                BgDBUtils.insertKey((Connection)conn, (String)insert.toString(), sqlParams);
            } else {
                try {
                    insertSta = conn.prepareStatement(insert.toString());
                    for (Object[] obj : rst) {
                        if (obj == null || obj.length <= 0 || querySet.contains(obj[0])) continue;
                        insertSta.setString(1, (String)obj[0]);
                        insertSta.addBatch();
                    }
                    insertSta.executeBatch();
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(insertSta);
                    throw throwable;
                }
                SQLUtils.cleanup((Statement)insertSta);
            }
            updateSta = conn.prepareStatement(update.toString());
            for (String OUID : querySet) {
                updateSta.setString(1, OUID);
                updateSta.addBatch();
            }
            updateSta.executeBatch();
            logger.debug((Object)("end lockTransaction: viewId(" + orgViewId + ") orgIds: (" + orgUnitID + ")"));
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"lockTransaction Error:", (Throwable)ex);
                throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex.getMessage()});
                catch (SQLDataException ex2) {
                    logger.error((Object)"lockTransaction Error:", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(querySta);
                SQLUtils.cleanup(insertSta);
                SQLUtils.cleanup(updateSta);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(querySta);
        SQLUtils.cleanup((Statement)insertSta);
        SQLUtils.cleanup((Statement)updateSta);
        SQLUtils.cleanup((Connection)conn);
    }

    protected Set<String> getConcurrentOrgUnitId(Connection conn, BOSUuid orgViewId, Set<String> orgUnitIds) throws BOSException, EASBizException {
        HashSet<String> querySet = new HashSet<String>();
        if (conn == null || orgViewId == null || orgUnitIds == null || orgUnitIds.isEmpty()) {
            querySet.add(this.getGlobalLockId());
        } else {
            int level = this.getControlLevel(conn);
            if (level < 1 || orgViewId == null) {
                querySet.add(this.getGlobalLockId());
            } else {
                Set<String> tmpSet = this.getConcurrentOrgUnitId(conn, orgViewId, orgUnitIds, level);
                if (tmpSet != null) {
                    querySet.addAll(tmpSet);
                }
                if (querySet.isEmpty()) {
                    querySet.add(this.getGlobalLockId());
                }
            }
        }
        return querySet;
    }

    protected String getGlobalLockId() {
        return "00000000-0000-0000-0000-000000000000CCE7AED4";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getControlLevel(Connection conn) {
        int level = 1;
        if (conn == null) {
            return level;
        }
        IRowSet rst = null;
        try {
            String tmpStr;
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FValue from T_MBG_BgParam where FKey = ?", (Object[])new Object[]{"C0001"});
            if (rst != null && rst.next() && (tmpStr = rst.getString("FValue")) != null) {
                level = new Integer(tmpStr.trim());
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        catch (Exception ex) {
            logger.error((Object)"query Control Level Error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst);
        }
        return level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getConcurrentOrgUnitId(Connection conn, BOSUuid orgViewId, Set<String> orgUnitIds, int level) throws BOSException, EASBizException {
        if (conn == null || orgViewId == null || orgUnitIds == null) {
            return null;
        }
        HashSet<String> idSet = new HashSet<String>();
        ArrayList<String> tmpList = new ArrayList<String>();
        tmpList.addAll(orgUnitIds);
        int size = tmpList.size();
        int count = (size - 1) / 50 + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select FLongNumber from T_MBG_BgOrgUnit where FViewId = ? and FOrgUnitID IN (");
        for (int i = 1; i < 50; ++i) {
            sql.append("?,");
        }
        sql.append("?) and FIsVirtual = 0");
        StringBuffer query = new StringBuffer();
        query.append("select FID from T_MBG_BgOrgUnit where FViewId = ? and FNumber IN (");
        for (int i = 1; i < 50; ++i) {
            query.append("?,");
        }
        query.append("?) and FLevel = ? and FIsVirtual = 0");
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String longnumber = null;
        String[] numbers = null;
        HashSet<String> numberSet = new HashSet<String>();
        try {
            int x;
            int index;
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                pstmt.setString(1, orgViewId.toString());
                x = 1;
                while (x <= 50) {
                    if (pos < size) {
                        pstmt.setString(x + 1, (String)tmpList.get(pos));
                    } else {
                        pstmt.setString(x + 1, BgBaseConstants.noFindStr);
                    }
                    ++x;
                    ++pos;
                }
                try {
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        longnumber = rst.getString(1);
                        numbers = longnumber.split("!");
                        if (numbers == null) continue;
                        int zn = numbers.length;
                        for (int z = 0; z < zn; ++z) {
                            numberSet.add(numbers[z]);
                        }
                    }
                    continue;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            SQLUtils.cleanup(rst, (Statement)pstmt);
            if (!numberSet.isEmpty()) {
                tmpList.clear();
                tmpList.addAll(numberSet);
                size = tmpList.size();
                count = (size - 1) / 50 + 1;
                pos = 0;
                pstmt = conn.prepareStatement(query.toString());
                for (index = 0; index < count; ++index) {
                    pstmt.setString(1, orgViewId.toString());
                    x = 1;
                    while (x <= 50) {
                        if (pos < size) {
                            pstmt.setString(x + 1, (String)tmpList.get(pos));
                        } else {
                            pstmt.setString(x + 1, BgBaseConstants.noFindStr);
                        }
                        ++x;
                        ++pos;
                    }
                    pstmt.setInt(52, level);
                    try {
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            idSet.add(rst.getString("FID"));
                        }
                        continue;
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)sql.toString());
            logger.error((Object)"Budget Control Sql Error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return idSet;
    }

    @Override
    protected Object _getRuleCondition(Context ctx, String bizBill) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bizBill)) {
            return null;
        }
        String sql = "SELECT FBizAlias_" + ctx.getLocale() + " AS name,FBiz AS number ,FBizUnit AS bizBill FROM T_MBG_BgControlData WHERE FBizUnit=? AND FBizType=? ";
        Connection conn = null;
        PreparedStatement pmst = null;
        ResultSet rs = null;
        BgRuleCondition row = null;
        ArrayList<BgRuleCondition> colls = new ArrayList<BgRuleCondition>();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pmst = conn.prepareStatement(sql);
            pmst.setString(1, bizBill);
            pmst.setInt(2, 6);
            rs = pmst.executeQuery();
            while (rs.next()) {
                row = new BgRuleCondition();
                row.setName(rs.getString("name"));
                row.setNumber(rs.getString("number"));
                row.setBizBill(rs.getString("bizBill"));
                colls.add(row);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
        return colls;
    }

    @Override
    protected void _updateControlLevel(Context ctx, String bgControlLevel) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgControlLevel)) {
            return;
        }
        try {
            BgDBUtils.executeUpdate((Context)ctx, (String)"update T_MBG_BgParam set FValue = ? where FKey = ?", (Object[])new Object[]{bgControlLevel, "C0001"});
        }
        catch (SQLException ex) {
            throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex.getMessage()});
        }
    }

    @Override
    protected void _updateControlDetail(Context ctx, String bgControlDetail) throws BOSException, EASBizException {
        if (!"0".equals(bgControlDetail) && !"1".equals(bgControlDetail)) {
            return;
        }
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FKey from T_MBG_BgParam where FKey = ?", (Object[])new Object[]{"C0002"});
            if (!rst.next()) {
                BgDBUtils.executeUpdate((Connection)conn, (String)("Insert into T_MBG_BgParam (FID, FKey, FValue, FDescription) values ('Kti0JgwtODfgU6hCqMC5kx9mVmo=', 'C0002', '0', '" + ResourceBase.getString((String)BgControlConstants.CONTROL_RES, (String)"bgControlLogType", (Locale)ctx.getLocale()) + "')"));
            }
            BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBG_BgParam set FValue = ? where FKey = ?", (Object[])new Object[]{bgControlDetail, "C0002"});
        }
        catch (Exception ex) {
            try {
                throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
    }
}

