/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlSchemeInfo;
import com.kingdee.eas.ma.control.app.AbstractBgControlFacadeControllerBean;
import com.kingdee.eas.ma.control.face.IBudgetBalance;
import com.kingdee.eas.ma.control.face.IControlParameter;
import com.kingdee.eas.ma.control.face.IControlResult;
import com.kingdee.eas.ma.control.impl.BgControlLogThread;
import com.kingdee.eas.ma.control.impl.ControlParameter;
import com.kingdee.eas.ma.control.impl.QueryBalanceImpl;
import com.kingdee.eas.ma.control.impl.RequestControlImpl;
import com.kingdee.eas.ma.control.impl.ReturnControlImpl;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.control.utils.BgControlUtils;
import com.kingdee.eas.ma.control.utils.BizUnitCheckUtils;
import com.kingdee.eas.ma.control.utils.ControlSchemeUtils;
import com.kingdee.eas.ma.mbg.dimension.utils.MetaUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgControlFacadeControllerBean
extends AbstractBgControlFacadeControllerBean {
    private static final long serialVersionUID = -2689561393040586252L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.control.app.BgControlFacadeControllerBean");

    @Override
    protected IControlResult _requestBudget(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ControlParameter parameter = new ControlParameter();
        return this.requestBudget(ctx, billID, (IControlParameter)parameter);
    }

    @Override
    protected IControlResult _requestBudgetHasWX(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ControlParameter parameter = new ControlParameter();
        return this.requestBudget(ctx, billID, (IControlParameter)parameter);
    }

    @Override
    protected IControlResult _requestBudget(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ControlParameter parameter = new ControlParameter();
        return this.requestBudget(ctx, model, (IControlParameter)parameter);
    }

    @Override
    protected IControlResult _requestBudgetWF(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ControlParameter parameter = new ControlParameter();
        return this.requestBudget(ctx, billID, (IControlParameter)parameter);
    }

    @Override
    protected IControlResult _requestBudgetWF(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ControlParameter parameter = new ControlParameter();
        return this.requestBudget(ctx, model, (IControlParameter)parameter);
    }

    @Override
    protected IControlResult _specialBudget(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        ControlParameter parameter = new ControlParameter();
        parameter.getLogicParameter().setCheckBalance(false);
        return this.requestBudget(ctx, billId, (IControlParameter)parameter);
    }

    @Override
    protected IControlResult _specialBudgetHasWx(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        ControlParameter parameter = new ControlParameter();
        parameter.getLogicParameter().setCheckBalance(false);
        return this.requestBudget(ctx, billId, (IControlParameter)parameter);
    }

    @Override
    protected IControlResult _specialBudget(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ControlParameter parameter = new ControlParameter();
        parameter.getLogicParameter().setCheckBalance(false);
        return this.requestBudget(ctx, model, (IControlParameter)parameter);
    }

    @Override
    protected IControlResult _specialBudgetWF(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ControlParameter parameter = new ControlParameter();
        parameter.getLogicParameter().setCheckBalance(false);
        return this.requestBudget(ctx, billID, (IControlParameter)parameter);
    }

    @Override
    protected IControlResult _specialBudgetWF(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ControlParameter parameter = new ControlParameter();
        parameter.getLogicParameter().setCheckBalance(false);
        return this.requestBudget(ctx, model, (IControlParameter)parameter);
    }

    private IControlResult requestBudget(Context ctx, BOSUuid billID, IControlParameter parameter) throws BOSException, EASBizException {
        if (ctx == null || billID == null || parameter == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        long startTime = System.currentTimeMillis();
        logger.debug((Object)"invoke begin requestBudget!");
        parameter.setBillId(billID.toString());
        IControlResult result = null;
        RequestControlImpl reqFacade = new RequestControlImpl();
        ReturnControlImpl reFacade = new ReturnControlImpl();
        try {
            if (!reqFacade.isSupportRepeatControl(ctx, billID, parameter)) {
                reFacade.returnBudget(ctx, billID, parameter);
            }
            result = reqFacade.requestBudget(ctx, billID, parameter);
            if (parameter.getLogicParameter().isCheckBalance()) {
                this.writeLog(ctx, parameter.getBillId(), 1, result.getResult(), reqFacade.getParams(), reqFacade.getConditions());
            } else {
                this.writeLog(ctx, parameter.getBillId(), 2, result.getResult(), reqFacade.getParams(), reqFacade.getConditions());
            }
        }
        catch (BOSException ex) {
            logger.error((Object)"requestBudget Error:", (Throwable)ex);
            throw ex;
        }
        catch (EASBizException ex) {
            logger.error((Object)"requestBudget Error:", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"requestBudget Error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        logger.debug((Object)"invoke end requestBudget!");
        logger.debug((Object)this.outTime(startTime));
        return result;
    }

    private IControlResult requestBudget(Context ctx, IObjectValue model, IControlParameter parameter) throws BOSException, EASBizException {
        if (ctx == null || model == null || model.getString(model.getPKField()) == null || parameter == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        long startTime = System.currentTimeMillis();
        logger.debug((Object)"invoke begin requestBudget!");
        parameter.setBillId(model.getString(model.getPKField()));
        IControlResult result = null;
        RequestControlImpl reqFacade = new RequestControlImpl();
        ReturnControlImpl reFacade = new ReturnControlImpl();
        try {
            if (!reqFacade.isSupportRepeatControl(ctx, model, parameter)) {
                reFacade.returnBudget(ctx, BOSUuid.read((String)parameter.getBillId()), parameter);
            }
            result = reqFacade.requestBudget(ctx, model, parameter);
            if (parameter.getLogicParameter().isCheckBalance()) {
                this.writeLog(ctx, parameter.getBillId(), 1, result.getResult(), reqFacade.getParams(), reqFacade.getConditions());
            } else {
                this.writeLog(ctx, parameter.getBillId(), 2, result.getResult(), reqFacade.getParams(), reqFacade.getConditions());
            }
        }
        catch (BOSException ex) {
            logger.error((Object)"requestBudget Error:", (Throwable)ex);
            throw ex;
        }
        catch (EASBizException ex) {
            logger.error((Object)"requestBudget Error:", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"requestBudget Error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        logger.debug((Object)"invoke end requestBudget!");
        logger.debug((Object)this.outTime(startTime));
        return result;
    }

    @Override
    protected IControlResult _returnBudget(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ControlParameter parameter = new ControlParameter();
        return this.returnBudget(ctx, billID, parameter);
    }

    @Override
    protected IControlResult _returnBudgetWF(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ControlParameter parameter = new ControlParameter();
        return this.returnBudget(ctx, billID, parameter);
    }

    private IControlResult returnBudget(Context ctx, BOSUuid billID, IControlParameter parameter) throws BOSException, EASBizException {
        if (ctx == null || billID == null || parameter == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        long startTime = System.currentTimeMillis();
        logger.debug((Object)"invoke begin returnBudget!");
        IControlResult result = null;
        ReturnControlImpl facade = new ReturnControlImpl();
        parameter.setBillId(billID.toString());
        try {
            result = facade.returnBudget(ctx, billID, parameter);
            this.writeLog(ctx, parameter.getBillId(), 3, result.getResult(), null, null);
        }
        catch (BOSException ex) {
            logger.error((Object)"returnBudget Error:", (Throwable)ex);
            throw ex;
        }
        catch (EASBizException ex) {
            logger.error((Object)"returnBudget Error:", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"returnBudget Error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        logger.debug((Object)"invoke end returnBudget!");
        logger.debug((Object)this.outTime(startTime));
        return result;
    }

    @Override
    protected IBudgetBalance _queryBalance(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ControlParameter parameter = new ControlParameter();
        long startTime = System.currentTimeMillis();
        logger.debug((Object)"invoke begin queryBalance!");
        IBudgetBalance balance = null;
        QueryBalanceImpl facade = new QueryBalanceImpl();
        try {
            this._checkBizUnitInfo(ctx, billID, null);
            balance = facade.queryBalance(ctx, billID, (IControlParameter)parameter);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        logger.debug((Object)"invoke end queryBalance!");
        logger.debug((Object)this.outTime(startTime));
        return balance;
    }

    @Override
    protected IBudgetBalance _queryBalance(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ControlParameter parameter = new ControlParameter();
        long startTime = System.currentTimeMillis();
        logger.debug((Object)"invoke begin queryBalance!");
        IBudgetBalance balance = null;
        QueryBalanceImpl facade = new QueryBalanceImpl();
        try {
            this._checkBizUnitInfo(ctx, model, null);
            balance = facade.queryBalance(ctx, model, (IControlParameter)parameter);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (ex instanceof IllegalArgumentException && ((IllegalArgumentException)ex).getMessage().equals("value can not has a collection link property")) {
                throw new BgControlException(BgControlException.NOTHASACOLLECTION);
            }
            throw new BOSException((Throwable)ex);
        }
        logger.debug((Object)"invoke end queryBalance!");
        logger.debug((Object)this.outTime(startTime));
        return balance;
    }

    @Override
    protected IBudgetBalance _queryBalance(Context ctx, BOSUuid bgSchemeId, BOSUuid orgUnitId, List formulas, boolean isBgExcuteAnaly) throws BOSException, EASBizException {
        ControlParameter parameter = new ControlParameter();
        long startTime = System.currentTimeMillis();
        logger.debug((Object)"invoke begin queryBalance!");
        IBudgetBalance balance = null;
        QueryBalanceImpl facade = new QueryBalanceImpl();
        try {
            balance = facade.queryBalance(ctx, bgSchemeId, orgUnitId, formulas, parameter, isBgExcuteAnaly);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        logger.debug((Object)"invoke end queryBalance!");
        logger.debug((Object)this.outTime(startTime));
        return balance;
    }

    @Override
    protected IBudgetBalance _queryBalance(Context ctx, BOSUuid bgSchemeId, Set orgUnitIdSet, List formulas, boolean isBgExcuteAnaly, boolean isAudit) throws BOSException, EASBizException {
        ControlParameter parameter = new ControlParameter();
        long startTime = System.currentTimeMillis();
        logger.debug((Object)"invoke begin queryBalance!");
        IBudgetBalance balance = null;
        QueryBalanceImpl facade = new QueryBalanceImpl();
        try {
            balance = facade.queryBalance(ctx, bgSchemeId, orgUnitIdSet, formulas, parameter, isBgExcuteAnaly, isAudit);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        logger.debug((Object)"invoke end queryBalance!");
        logger.debug((Object)this.outTime(startTime));
        return balance;
    }

    @Override
    protected IBudgetBalance _queryBalance(Context ctx, BOSUuid bgSchemeId, Set orgUnitIdSet, List formulas, boolean isBgExcuteAnaly, boolean isAudit, boolean isALarm) throws BOSException, EASBizException {
        ControlParameter parameter = new ControlParameter();
        long startTime = System.currentTimeMillis();
        logger.debug((Object)"invoke begin queryBalance!");
        IBudgetBalance balance = null;
        QueryBalanceImpl facade = new QueryBalanceImpl();
        try {
            balance = facade.queryBalance(ctx, bgSchemeId, orgUnitIdSet, formulas, parameter, isBgExcuteAnaly, isAudit, isALarm);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        logger.debug((Object)"invoke end queryBalance!");
        logger.debug((Object)this.outTime(startTime));
        return balance;
    }

    @Override
    protected void _checkBizUnitInfo(Context ctx, BOSUuid billId, String extCheckClassName) throws BOSException, EASBizException {
        if (ctx == null || billId == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        ControlParameter parameter = new ControlParameter();
        parameter.setBillId(billId.toString());
        parameter.setBizUnit(BgControlUtils.getBizUnit(ctx, billId));
        parameter.setOUID(BgControlUtils.getBillOUID(ctx, parameter.getBizUnit(), billId));
        BgControlUtils.fillOUInfo(ctx, parameter);
        BgControlSchemeInfo schemeInfo = ControlSchemeUtils.getInstance().queryControlScheme(ctx, billId, parameter.getBizUnit(), parameter.getOUID(), parameter.getOUInfo().getName(), false, false);
        BizUnitCheckUtils.getInterace().checkBizUnitInfo(ctx, billId, schemeInfo, (IControlParameter)parameter, extCheckClassName);
    }

    @Override
    protected void _checkBizUnitInfo(Context ctx, IObjectValue model, String extCheckClassName) throws BOSException, EASBizException {
        if (ctx == null || model == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        ControlParameter parameter = new ControlParameter();
        parameter.setBizUnit(BgControlUtils.getBizUnit(ctx, model));
        parameter.setOUID(BgControlUtils.getBillOUID(ctx, parameter.getBizUnit(), model));
        BgControlUtils.fillOUInfo(ctx, parameter);
        BgControlSchemeInfo schemeInfo = ControlSchemeUtils.getInstance().queryControlScheme(ctx, model, parameter.getBizUnit(), parameter.getOUID(), parameter.getOUInfo().getName(), false, false);
        BizUnitCheckUtils.getInterace().checkBizUnitInfo(ctx, model, schemeInfo, (IControlParameter)parameter, extCheckClassName);
    }

    protected String outTime(long startTime) {
        return "invoke process use = " + (System.currentTimeMillis() - startTime) + " ms;";
    }

    @Override
    protected List _getRequestFields(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ArrayList<String> fields = new ArrayList<String>();
        if (ctx == null || model == null) {
            return fields;
        }
        String bizUnit = BgControlUtils.getBizUnit(ctx, model);
        String OUID = BgControlUtils.getBillOUID(ctx, bizUnit, model);
        BgControlSchemeInfo schemeInfo = ControlSchemeUtils.getInstance().queryControlScheme(ctx, model, bizUnit, OUID, "", false, false);
        Map<String, String> props = BizUnitCheckUtils.getInterace().getBizUnitProps(ctx, MetaUtils.getEntity((Context)ctx, (BOSObjectType)model.getBOSType()), schemeInfo);
        if (props != null) {
            fields.addAll(props.keySet());
        }
        return fields;
    }

    @Override
    protected List _getRequestFields(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        ArrayList<String> fields = new ArrayList<String>();
        if (ctx == null || billId == null) {
            return fields;
        }
        String bizUnit = BgControlUtils.getBizUnit(ctx, billId);
        String OUID = BgControlUtils.getBillOUID(ctx, bizUnit, billId);
        BgControlSchemeInfo schemeInfo = ControlSchemeUtils.getInstance().queryControlScheme(ctx, billId, bizUnit, OUID, "", false, false);
        Map<String, String> props = BizUnitCheckUtils.getInterace().getBizUnitProps(ctx, MetaUtils.getEntity((Context)ctx, (BOSObjectType)billId.getType()), schemeInfo);
        if (props != null) {
            fields.addAll(props.keySet());
        }
        return fields;
    }

    private void writeLog(Context ctx, String billId, int operType, int result, List<BgControlParam> params, List<String> conditions) {
        StackTraceElement[] stacks;
        BgControlLogThread thread = new BgControlLogThread();
        thread.setCtx(ctx);
        thread.setBillId(billId);
        thread.setOperType(operType);
        thread.setOperResult(result);
        thread.setParams(params);
        thread.setConditions(conditions);
        StringBuffer threadStack = new StringBuffer();
        for (StackTraceElement stack : stacks = Thread.currentThread().getStackTrace()) {
            if (threadStack.length() > 0) {
                threadStack.append("\r\n");
            }
            threadStack.append(stack);
        }
        thread.setThreadStack(threadStack.toString());
        thread.start();
    }
}

