/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgLocaleHelper;
import com.kingdee.eas.ma.control.BgControlIsomerInfo;
import com.kingdee.eas.ma.control.BgControlIsomerMapCollection;
import com.kingdee.eas.ma.control.BgControlIsomerMapFactory;
import com.kingdee.eas.ma.control.BgControlIsomerSetCollection;
import com.kingdee.eas.ma.control.BgControlIsomerSetFactory;
import com.kingdee.eas.ma.control.app.AbstractBgControlIsomerControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class BgControlIsomerControllerBean
extends AbstractBgControlIsomerControllerBean {
    private static final long serialVersionUID = 6434530074866253515L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.control.app.BgControlIsomerControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return null;
        }
        BgControlIsomerInfo info = (BgControlIsomerInfo)model;
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        for (int i = 0; i < info.getSets().size(); ++i) {
            info.getSets().get(i).setIsomer(info);
        }
        CoreBaseCollection colls = new CoreBaseCollection();
        colls.addObjectCollection((IObjectCollection)info.getSets());
        BgControlIsomerSetFactory.getLocalInstance(ctx).save(colls);
        return pk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return null;
        }
        BgControlIsomerInfo info = (BgControlIsomerInfo)model;
        ObjectUuidPK pk = new ObjectUuidPK(info.getId());
        info.setDisplayName(info.getName());
        this.update(ctx, (IObjectPK)pk, info);
        this.updateBgControlData(ctx, info);
        BgControlIsomerSetCollection editcoll = new BgControlIsomerSetCollection();
        BgControlIsomerSetCollection addcoll = new BgControlIsomerSetCollection();
        BgControlIsomerSetCollection deletecoll = new BgControlIsomerSetCollection();
        for (int i = 0; i < info.getSets().size(); ++i) {
            if (info.getSets().get(i).getString("state").equals("edit")) {
                info.getSets().get(i).setIsomer(info);
                editcoll.add(info.getSets().get(i));
                continue;
            }
            if (info.getSets().get(i).getString("state").equals("add")) {
                info.getSets().get(i).setIsomer(info);
                addcoll.add(info.getSets().get(i));
                continue;
            }
            if (!info.getSets().get(i).getString("state").equals("delete")) continue;
            deletecoll.add(info.getSets().get(i));
        }
        CoreBaseCollection colls = new CoreBaseCollection();
        if (!editcoll.isEmpty()) {
            colls.addObjectCollection((IObjectCollection)editcoll);
            BgControlIsomerSetFactory.getLocalInstance(ctx).update(colls);
        }
        if (!addcoll.isEmpty()) {
            colls = new CoreBaseCollection();
            colls.addObjectCollection((IObjectCollection)addcoll);
            BgControlIsomerSetFactory.getLocalInstance(ctx).addnew(colls);
        }
        if (!deletecoll.isEmpty()) {
            IObjectPK[] pks = new IObjectPK[deletecoll.size()];
            for (int i = 0; i < deletecoll.size(); ++i) {
                pks[i] = new ObjectUuidPK(deletecoll.get(i).getId());
            }
            BgControlIsomerSetFactory.getLocalInstance(ctx).delete(pks);
        }
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBgControlData(Context ctx, BgControlIsomerInfo info) throws BOSException, EASBizException {
        Connection conn = null;
        String name = "";
        for (int i = 0; i < BgLocaleHelper.locales.length; ++i) {
            name = "FBizUnitAlias_" + BgLocaleHelper.locales[i].getLanguage() + " = '" + info.getName(BgLocaleHelper.locales[i]) + "' ," + name;
        }
        name = name.substring(0, name.length() - 1);
        String bizFieldSql = "UPDATE T_MBG_BGCONTROLDATA set " + name + " where FBIZUNIT = '" + info.getId() + "' and FISOMER = 1 ";
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            BgDBUtils.executeUpdate((Connection)conn, (String)bizFieldSql);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected boolean _checkHasEntries(Context ctx, String id) throws BOSException, EASBizException {
        if (id == null) {
            return true;
        }
        boolean flag = BgControlIsomerMapFactory.getLocalInstance(ctx).exists("select id where isomer.id='" + id + "'");
        return flag;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException, TreeBaseException {
        BgControlIsomerInfo treeModel = (BgControlIsomerInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        if (treeModel.innerGetParent() == null) {
            filterItem = new FilterItemInfo("number", (Object)treeModel.getNumber(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            filter.getFilterItems().add(new FilterItemInfo("parent", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("connection.id", (Object)treeModel.getConnection().getId().toString(), CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2");
            if (treeModel.getId() != null) {
                filterItem = new FilterItemInfo("id", (Object)treeModel.getId().toString(), CompareType.NOTEQUALS);
                filter.getFilterItems().add(filterItem);
                filter.setMaskString("#0 and #1 and #2 and #3");
            }
        } else {
            filterItem = new FilterItemInfo("number", (Object)treeModel.getNumber(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            filter.getFilterItems().add(new FilterItemInfo("connection.id", (Object)treeModel.getConnection().getId().toString(), CompareType.EQUALS));
            if (treeModel.innerGetParent().getId() != null) {
                filterItem = new FilterItemInfo("parent", (Object)treeModel.innerGetParent().getId().toString(), CompareType.EQUALS);
                filter.getFilterItems().add(filterItem);
                filter.setMaskString("#0 and #1 and #2");
            }
            if (treeModel.getId() != null) {
                filterItem = new FilterItemInfo("id", (Object)treeModel.getId().toString(), CompareType.NOTEQUALS);
                filter.getFilterItems().add(filterItem);
                if (treeModel.innerGetParent().getId() != null) {
                    filter.setMaskString("#0 and #1 and #2 and #3");
                } else {
                    filter.setMaskString("#0 and #1 and #2");
                }
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeModel);
        if (FilterUtility.hasFilterItem((FilterInfo)filterCU)) {
            if (FilterUtility.hasFilterItem((FilterInfo)filter)) {
                filter.mergeFilter(filterCU, "AND");
            } else {
                filter = filterCU;
            }
        }
        view.setFilter(filter);
        TreeBaseCollection results = this.getTreeBaseCollection(ctx, view);
        if (results != null && results.size() > 0) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{treeModel.getNumber()});
        }
    }

    protected void checkLNForTree(Context ctx, TreeBaseInfo treeBaseInfo) throws BOSException, EASBizException, TreeBaseException {
        BgControlIsomerInfo info = (BgControlIsomerInfo)treeBaseInfo;
        FilterInfo lNfilter = new FilterInfo();
        lNfilter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)treeBaseInfo.getLongNumber()));
        lNfilter.getFilterItems().add(new FilterItemInfo("id", (Object)treeBaseInfo.getId().toString(), CompareType.NOTEQUALS));
        lNfilter.getFilterItems().add(new FilterItemInfo("connection.id", (Object)info.getConnection().getId().toString(), CompareType.EQUALS));
        lNfilter.setMaskString("#0 AND #1 AND #2");
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
        if (FilterUtility.hasFilterItem((FilterInfo)filterCU)) {
            lNfilter.mergeFilter(filterCU, "AND");
        }
        if (this.exists(ctx, lNfilter)) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{treeBaseInfo.getNumber()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _isGroupRef(Context ctx, String id) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        boolean isGroupRef;
        block6: {
            if (id == null) {
                return false;
            }
            isGroupRef = false;
            conn = null;
            pstmt = null;
            rst = null;
            String bizFieldSql = "select FBIZUNIT from T_MBG_BGCONTROLDATA where FBIZUNIT = ? and FISOMER = 1 ";
            try {
                conn = BgDBUtils.getConnection((Context)ctx);
                pstmt = conn.prepareStatement(bizFieldSql);
                pstmt.setString(1, id);
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    isGroupRef = true;
                }
                if (isGroupRef) break block6;
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                String recordDetailSql = "select FCubeName from T_MBG_BgControlRecordDetail where FIsomer = 1  and FIsomerID = ?";
                pstmt = conn.prepareStatement(recordDetailSql);
                pstmt.setString(1, id);
                rst = pstmt.executeQuery();
                if (!rst.next()) break block6;
                isGroupRef = true;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
                SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return isGroupRef;
    }

    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super.delete(ctx, pk);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("isomer.id", (Object)pk.toString(), CompareType.EQUALS));
        BgControlIsomerMapCollection colls = BgControlIsomerMapFactory.getLocalInstance(ctx).getBgControlIsomerMapCollection(view);
        ArrayList<ObjectUuidPK> listPK = new ArrayList<ObjectUuidPK>();
        for (int i = 0; i < colls.size(); ++i) {
            listPK.add(new ObjectUuidPK(colls.get(i).getId()));
        }
        if (listPK.size() > 0) {
            BgControlIsomerMapFactory.getLocalInstance(ctx).deleteBatchData(listPK.toArray(new IObjectPK[listPK.size()]));
        }
    }
}

