/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.openapi.third.OpenApi;
import com.kingdee.bos.openapi.third.OpenApiContextFactory;
import com.kingdee.bos.openapi.third.OpenApiFactory;
import com.kingdee.bos.openapi.third.OpenApiInfo;
import com.kingdee.bos.openapi.third.invoker.AbstractLoginContext;
import com.kingdee.bos.openapi.third.login.LoginContext;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.utils.BgParamCHelper;
import com.kingdee.eas.ma.base.utils.BgParamNHelper;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlFacadeFactory;
import com.kingdee.eas.ma.control.BgControlIsomerConnectionCollection;
import com.kingdee.eas.ma.control.BgControlIsomerConnectionFactory;
import com.kingdee.eas.ma.control.BgControlIsomerConnectionInfo;
import com.kingdee.eas.ma.control.BgControlIsomerException;
import com.kingdee.eas.ma.control.BgControlIsomerFactory;
import com.kingdee.eas.ma.control.BgControlIsomerInfo;
import com.kingdee.eas.ma.control.BgControlNotNullBudgetEnum;
import com.kingdee.eas.ma.control.BgControlNullBudgetEnum;
import com.kingdee.eas.ma.control.BgCtrlIsomerTypeEnum;
import com.kingdee.eas.ma.control.app.AbstractBgControlIsomerFacadeControllerBean;
import com.kingdee.eas.ma.control.face.IBudgetBalance;
import com.kingdee.eas.ma.control.face.IControlParameter;
import com.kingdee.eas.ma.control.face.IControlResult;
import com.kingdee.eas.ma.control.impl.BgControlLogThread;
import com.kingdee.eas.ma.control.impl.ControlParameter;
import com.kingdee.eas.ma.control.impl.ControlResult;
import com.kingdee.eas.ma.control.impl.QueryBalanceImpl;
import com.kingdee.eas.ma.control.impl.RequestControlImpl;
import com.kingdee.eas.ma.control.impl.ReturnControlImpl;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.ma.control.utils.BgControlUtils;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgControlIsomerFacadeControllerBean
extends AbstractBgControlIsomerFacadeControllerBean {
    private static final long serialVersionUID = 2321908007687702135L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.control.app.BgControlIsomerFacadeControllerBean");
    private static String DATAJSON = "dataJson";
    private static String TYPE = "type";
    private static String BILLNUMBER = "billNumber";
    private static String TABLENUMBER = "tableNumber";
    private static String CONNECTNUMBER = "connectNubmer";
    private static String CONNECTINFO = "connectInfo";
    private static String IP = "IP";
    private static String PORT = "port";
    private static String INSTANCE = "instance";
    private static String USERNAME = "userName";
    private static String BILLID = "billID";

    @Override
    protected String _bgControlHandle(Context ctx, String dataJson, String type) throws BOSException, EASBizException {
        Map<String, String> map = this.parseJson(dataJson, type);
        BgControlIsomerInfo info = this.prepareBgHandle(ctx, map);
        if (BgCtrlIsomerTypeEnum.request.getValue().equals(map.get(TYPE))) {
            return this.requestBudget(ctx, map.get(BILLNUMBER), info);
        }
        if (BgCtrlIsomerTypeEnum.returnBudget.getValue().equals(map.get(TYPE))) {
            return this.returnBudget(ctx, map.get(BILLNUMBER), info);
        }
        if (BgCtrlIsomerTypeEnum.query.getValue().equals(map.get(TYPE))) {
            return this.queryBalance(ctx, map.get(BILLNUMBER), info);
        }
        if (BgCtrlIsomerTypeEnum.specialBudget.getValue().equals(map.get(TYPE))) {
            return this.specialBudget(ctx, map.get(BILLNUMBER), info);
        }
        throw new BgControlIsomerException(BgControlIsomerException.TYPEFAIL);
    }

    private String requestBudget(Context ctx, String billNumber, BgControlIsomerInfo info) throws BOSException, EASBizException {
        ControlParameter parameter = new ControlParameter();
        IControlResult result = this.requestBudget(ctx, billNumber, info, parameter);
        return this.transResult(ctx, result);
    }

    private IControlResult requestBudgetGUI(Context ctx, String billNumber, BgControlIsomerInfo info) throws BOSException, EASBizException {
        ControlParameter parameter = new ControlParameter();
        return this.requestBudget(ctx, billNumber, info, parameter);
    }

    private IControlResult requestBudget(Context ctx, String billNumber, BgControlIsomerInfo info, IControlParameter parameter) throws BOSException, EASBizException {
        if (ctx == null || billNumber == null || parameter == null || info == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        parameter.setBgControlIsomer(info);
        long startTime = System.currentTimeMillis();
        logger.debug((Object)"invoke begin requestBudget!");
        parameter.setBillId(billNumber);
        IControlResult result = null;
        RequestControlImpl reqFacade = new RequestControlImpl();
        ReturnControlImpl reFacade = new ReturnControlImpl();
        try {
            reFacade.returnBudget(ctx, info.getId(), parameter);
            result = reqFacade.requestBudget(ctx, info.getId(), parameter);
            if (parameter.getLogicParameter().isCheckBalance()) {
                this.writeLog(ctx, parameter.getBillId(), 1, result.getResult(), reqFacade.getParams(), reqFacade.getConditions());
            } else {
                this.writeLog(ctx, parameter.getBillId(), 2, result.getResult(), reqFacade.getParams(), reqFacade.getConditions());
            }
        }
        catch (BOSException ex) {
            logger.error((Object)"requestBudget Error:", (Throwable)ex);
            throw ex;
        }
        catch (EASBizException ex) {
            logger.error((Object)"requestBudget Error:", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"requestBudget Error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        logger.debug((Object)"invoke end requestBudget!");
        logger.debug((Object)this.outTime(startTime));
        return result;
    }

    private IControlResult returnBudgetGUI(Context ctx, String billNumber, BgControlIsomerInfo info) throws BOSException, EASBizException {
        if (ctx == null || billNumber == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        ControlParameter parameter = new ControlParameter();
        parameter.setBgControlIsomer(info);
        IControlResult result = null;
        ReturnControlImpl facade = new ReturnControlImpl();
        parameter.setBillId(billNumber);
        try {
            result = facade.returnBudget(ctx, info.getId(), parameter);
            this.writeLog(ctx, parameter.getBillId(), 3, result.getResult(), null, null);
        }
        catch (BOSException ex) {
            logger.error((Object)"requestBudget Error:", (Throwable)ex);
            throw ex;
        }
        catch (EASBizException ex) {
            logger.error((Object)"requestBudget Error:", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"requestBudget Error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        return result;
    }

    private String returnBudget(Context ctx, String billNumber, BgControlIsomerInfo info) throws BOSException, EASBizException {
        IControlResult result = this.returnBudgetGUI(ctx, billNumber, info);
        return this.transResult(ctx, result);
    }

    private String queryBalance(Context ctx, String billNumber, BgControlIsomerInfo info) throws BOSException, EASBizException {
        ControlParameter parameter = new ControlParameter();
        IBudgetBalance balance = this.queryBalance(ctx, billNumber, info, parameter);
        if (balance == null) {
            return null;
        }
        return this.transBalance(ctx, balance);
    }

    private String transBalance(Context ctx, IBudgetBalance balance) {
        BgControlParam param = null;
        JSONArray budgetdata = new JSONArray();
        for (int i = 0; i < balance.getBalance().size(); ++i) {
            param = balance.getBalance().get(i);
            JSONObject budgetList = new JSONObject();
            if (!param.getNoMembers().isEmpty() || param.getOrgUnit() == null) continue;
            budgetList.put("orgUnit", (Object)param.getOrgUnit().getName());
            budgetList.put("scheme", (Object)param.getBgSchemeInfo().getName());
            budgetList.put("bgScenario", (Object)param.getBgScenario().getName());
            budgetList.put("acScenario", (Object)param.getAcScenario().getName());
            budgetList.put("bgPeriodType", (Object)param.getBgPeriodGroup().getName());
            budgetList.put("bgPeriod", (Object)param.getBgPeriodName());
            budgetList.put("bgElement", (Object)param.getBgElement().getName());
            budgetList.put("type", (Object)param.getControlSetting().getCtrlType().getAlias());
            budgetList.put("bgIndexNumber", (Object)param.getBgIndexNumber());
            budgetList.put("dimItemName", (Object)param.getDimItemName());
            budgetList.put("dimItemNumber", (Object)param.getDimItemNumber());
            BigDecimal budget = BgControlUtils.getBudgetValue(param);
            budgetList.put("budget", (Object)budget);
            budgetList.put("actual", (Object)BgControlUtils.getActualValue(param));
            budgetList.put("apply", (Object)BgControlUtils.getRequestValue(param));
            BigDecimal nbalance = param.getExtBalance() != null ? param.getExtBalance() : param.getBalance();
            budgetList.put("balance", (Object)nbalance);
            budgetList.put("flexParam", (Object)param.getControlSetting().getFlexParam());
            boolean isOverBudget = param.isOverBudget();
            boolean isAllowAccess = param.isAllowAccess();
            boolean isNotBudget = param.isNotBudget();
            boolean isZero = false;
            isZero = ctx != null ? BgParamNHelper.isZeroIsNull((Context)ctx) : BgParamCHelper.isZeroIsNull();
            this.dealWithBudgetState(isOverBudget, isAllowAccess, isNotBudget, budget, nbalance, param, isZero, budgetList);
            budgetdata.add((Object)budgetList);
        }
        return budgetdata.toString();
    }

    private void dealWithBudgetState(boolean isOverBudget, boolean isAllowAccess, boolean isNotBudget, BigDecimal budget, BigDecimal nbalance, BgControlParam param, boolean isZero, JSONObject budgetList) {
        if (budget == null || budget != null && budget.compareTo(BigDecimal.ZERO) == 0 && isZero) {
            if (param.getNullBudget().equals((Object)BgControlNullBudgetEnum.PassWithNoCtrlSet)) {
                if (param.getControlSetting().getCtrlType().getValue() == -1) {
                    isNotBudget = false;
                    isOverBudget = false;
                } else if (param.getControlSetting().getCtrlType().getValue() != -1 && param.getControlSetting().isIsAllowAccess() && param.isAllowAccessOfBgScheme()) {
                    isNotBudget = false;
                    isOverBudget = false;
                } else if (!(param.getControlSetting().getCtrlType().getValue() == -1 || param.getControlSetting().isIsAllowAccess() && param.isAllowAccessOfBgScheme())) {
                    isNotBudget = true;
                    isOverBudget = true;
                }
            } else if (param.getNullBudget().equals((Object)BgControlNullBudgetEnum.NoPass)) {
                isNotBudget = true;
                isOverBudget = true;
            } else if (param.getNullBudget().equals((Object)BgControlNullBudgetEnum.Pass)) {
                isNotBudget = false;
                isOverBudget = false;
            } else if (param.getNullBudget().equals((Object)BgControlNullBudgetEnum.NoPassWithNoCtrlSet)) {
                if (param.getControlSetting().getCtrlType().getValue() == -1) {
                    isNotBudget = true;
                    isOverBudget = true;
                } else if (param.getControlSetting().getCtrlType().getValue() != -1 && param.getControlSetting().isIsAllowAccess() && param.isAllowAccessOfBgScheme()) {
                    isNotBudget = false;
                    isOverBudget = false;
                } else if (!(param.getControlSetting().getCtrlType().getValue() == -1 || param.getControlSetting().isIsAllowAccess() && param.isAllowAccessOfBgScheme())) {
                    isNotBudget = true;
                    isOverBudget = true;
                }
            }
        } else if (param.getControlSetting().getCtrlType().getValue() == -1) {
            if (param.getNotNullBudget().equals((Object)BgControlNotNullBudgetEnum.AsCurrentPeriod)) {
                if (nbalance.subtract(param.getReqAmount()).compareTo(BigDecimal.ZERO) < 0) {
                    isNotBudget = true;
                    isOverBudget = true;
                }
            } else if (param.getNotNullBudget().equals((Object)BgControlNotNullBudgetEnum.Pass)) {
                isNotBudget = false;
                isOverBudget = false;
            } else if (param.getNotNullBudget().equals((Object)BgControlNotNullBudgetEnum.NoPassWithNoCtrlSet)) {
                isNotBudget = true;
                isOverBudget = true;
            }
        }
        budgetList.put("isNotBudget", (Object)isNotBudget);
        budgetList.put("isOverBudget", (Object)isOverBudget);
    }

    private String specialBudget(Context ctx, String billNumber, BgControlIsomerInfo info) throws BOSException, EASBizException {
        ControlParameter parameter = new ControlParameter();
        parameter.getLogicParameter().setCheckBalance(false);
        IControlResult result = this.requestBudget(ctx, billNumber, info, parameter);
        return this.transResult(ctx, result);
    }

    private IControlResult specialBudgetGUI(Context ctx, String billNumber, BgControlIsomerInfo info) throws BOSException, EASBizException {
        ControlParameter parameter = new ControlParameter();
        parameter.getLogicParameter().setCheckBalance(false);
        return this.requestBudget(ctx, billNumber, info, parameter);
    }

    private IBudgetBalance queryBalance(Context ctx, String billNumber, BgControlIsomerInfo info, IControlParameter parameter) throws BOSException, EASBizException {
        parameter.setBgControlIsomer(info);
        long startTime = System.currentTimeMillis();
        logger.debug((Object)"invoke begin queryBalance!");
        parameter.setBillId(billNumber);
        IBudgetBalance balance = null;
        QueryBalanceImpl facade = new QueryBalanceImpl();
        try {
            balance = facade.queryBalance(ctx, info.getId(), parameter);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        logger.debug((Object)"invoke end queryBalance!");
        logger.debug((Object)this.outTime(startTime));
        return balance;
    }

    protected String outTime(long startTime) {
        return "invoke process use = " + (System.currentTimeMillis() - startTime) + " ms;";
    }

    private Map<String, String> parseJson(String dataJson, String type) throws BOSException, EASBizException {
        logger.debug((Object)"parse json");
        if (dataJson == null) {
            throw new BgControlIsomerException(BgControlIsomerException.PARSEJSON, new Object[]{DATAJSON});
        }
        if (type == null) {
            throw new BgControlIsomerException(BgControlIsomerException.PARSEJSON, new Object[]{TYPE});
        }
        HashMap<String, String> map = new HashMap<String, String>();
        JSONObject jdata = JSONObject.parseObject((String)dataJson);
        if (jdata == null || StringUtils.isEmpty((String)jdata.getString(DATAJSON))) {
            throw new BgControlIsomerException(BgControlIsomerException.PARSEJSON, new Object[]{DATAJSON});
        }
        if (JSONObject.parseObject((String)jdata.getString(DATAJSON)) == null) {
            throw new BgControlIsomerException(BgControlIsomerException.PARSEJSON, new Object[]{DATAJSON});
        }
        String billnumber = JSONObject.parseObject((String)jdata.getString(DATAJSON)).getString(BILLNUMBER);
        if (StringUtils.isEmpty((String)billnumber)) {
            throw new BgControlIsomerException(BgControlIsomerException.PARSEJSON, new Object[]{BILLNUMBER});
        }
        String tablenumber = JSONObject.parseObject((String)jdata.getString(DATAJSON)).getString(TABLENUMBER);
        if (StringUtils.isEmpty((String)tablenumber)) {
            throw new BgControlIsomerException(BgControlIsomerException.PARSEJSON, new Object[]{TABLENUMBER});
        }
        map.put(BILLNUMBER, billnumber);
        map.put(TABLENUMBER, tablenumber);
        String connectnumber = JSONObject.parseObject((String)jdata.getString(DATAJSON)).getString(CONNECTNUMBER);
        String connectInfo = JSONObject.parseObject((String)jdata.getString(DATAJSON)).getString(CONNECTINFO);
        if (StringUtils.isEmpty((String)connectnumber) && StringUtils.isEmpty((String)connectInfo)) {
            throw new BgControlIsomerException(BgControlIsomerException.PARSEJSON, new Object[]{CONNECTNUMBER + "-" + CONNECTINFO});
        }
        if (StringUtils.isEmpty((String)connectnumber)) {
            JSONObject connectObject = JSONObject.parseObject((String)connectInfo);
            if (connectObject == null) {
                throw new BgControlIsomerException(BgControlIsomerException.PARSEJSON, new Object[]{CONNECTINFO});
            }
            if (StringUtils.isEmpty((String)connectObject.getString(IP)) || StringUtils.isEmpty((String)connectObject.getString(PORT)) || StringUtils.isEmpty((String)connectObject.getString(INSTANCE)) || StringUtils.isEmpty((String)connectObject.getString(USERNAME))) {
                throw new BgControlIsomerException(BgControlIsomerException.PARSEJSON, new Object[]{CONNECTINFO});
            }
            map.put(CONNECTINFO, connectObject.getString(IP) + "_" + connectObject.getString(PORT) + "_" + connectObject.getString(INSTANCE) + "_" + connectObject.getString(USERNAME));
        } else if (StringUtils.isEmpty((String)connectInfo)) {
            map.put(CONNECTNUMBER, connectnumber);
        }
        JSONObject jtype = JSONObject.parseObject((String)type);
        if (jtype == null || StringUtils.isEmpty((String)jtype.getString(TYPE))) {
            throw new BgControlIsomerException(BgControlIsomerException.PARSEJSON, new Object[]{TYPE});
        }
        map.put(TYPE, jtype.getString(TYPE));
        return map;
    }

    private BgControlIsomerInfo prepareBgHandle(Context ctx, Map<String, String> map) throws BOSException, EASBizException {
        logger.debug((Object)"prepareBgHandle");
        BgControlIsomerConnectionInfo cinfo = this.verifyConnect(ctx, map);
        BgControlIsomerInfo isomerInfo = this.verifyTable(ctx, map, cinfo);
        return isomerInfo;
    }

    private BgControlIsomerInfo verifyTable(Context ctx, Map<String, String> map, BgControlIsomerConnectionInfo cinfo) throws BOSException, EASBizException {
        BgControlIsomerInfo isomerInfo = null;
        if (map.containsKey(TABLENUMBER)) {
            try {
                isomerInfo = BgControlIsomerFactory.getLocalInstance(ctx).getBgControlIsomerInfo("Select id,number,sets.*,maps.*,connection.*,name,pfiled where number='" + map.get(TABLENUMBER).toUpperCase() + "' and connection.id='" + cinfo.getId() + "'");
            }
            catch (Exception e) {
                throw new BgControlIsomerException(BgControlIsomerException.TABLEFAIL);
            }
            if (isomerInfo == null) {
                throw new BgControlIsomerException(BgControlIsomerException.TABLEFAIL);
            }
            return isomerInfo;
        }
        throw new BgControlIsomerException(BgControlIsomerException.TABLEFAIL);
    }

    private BgControlIsomerConnectionInfo verifyConnect(Context ctx, Map<String, String> map) throws BOSException, EASBizException {
        BgControlIsomerConnectionInfo cinfo = null;
        if (map.containsKey(CONNECTNUMBER)) {
            String number = map.get(CONNECTNUMBER);
            try {
                cinfo = BgControlIsomerConnectionFactory.getLocalInstance(ctx).getBgControlIsomerConnectionInfo("select id where number='" + number + "'");
            }
            catch (Exception e) {
                throw new BgControlIsomerException(BgControlIsomerException.CONNECTFAIL);
            }
            if (cinfo == null) {
                throw new BgControlIsomerException(BgControlIsomerException.CONNECTFAIL);
            }
            return cinfo;
        }
        if (map.containsKey(CONNECTINFO)) {
            String connectKey = map.get(CONNECTINFO);
            String key = null;
            BgControlIsomerConnectionCollection colls = BgControlIsomerConnectionFactory.getLocalInstance(ctx).getBgControlIsomerConnectionCollection();
            boolean exist = false;
            for (int i = 0; i < colls.size(); ++i) {
                key = colls.get(i).getIP() + "_" + colls.get(i).getPort() + "_" + colls.get(i).getInstance() + "_" + colls.get(i).getUsername();
                if (!key.equals(connectKey)) continue;
                exist = true;
                cinfo = colls.get(i);
                break;
            }
            if (exist) {
                return cinfo;
            }
            throw new BgControlIsomerException(BgControlIsomerException.CONNECTFAIL);
        }
        throw new BgControlIsomerException(BgControlIsomerException.CONNECTFAIL);
    }

    private void writeLog(Context ctx, String billId, int operType, int result, List<BgControlParam> params, List<String> conditions) {
        BgControlLogThread thread = new BgControlLogThread();
        thread.setCtx(ctx);
        thread.setBillId(billId);
        thread.setOperType(operType);
        thread.setOperResult(result);
        thread.setParams(params);
        thread.setConditions(conditions);
        thread.setIsomer(1);
        thread.start();
    }

    protected String transResult(Context ctx, IControlResult result) {
        JSONObject budget = new JSONObject();
        JSONArray budgetdata = new JSONArray();
        ControlResult _result = new ControlResult();
        _result.setResult(result.getResult());
        if (result.getCause() != null && !result.getCause().isEmpty()) {
            budget.put("code", (Object)"1");
            String msg = null;
            String[] causes = null;
            String[] tmpStr = null;
            MessageFormat mf = null;
            Locale locale = ctx != null ? ctx.getLocale() : SysContext.getSysContext().getLocale();
            String param = ctx != null ? BgParamNHelper.getBgOrgShowStyle((Context)ctx) : BgParamCHelper.getBgOrgShowStyle();
            int in = result.getCause().size();
            for (int i = 0; i < in; ++i) {
                causes = result.getCause().get(i);
                if (causes == null) continue;
                msg = EASCommonResource.getString((String)BgControlConstants.CONTROL_RES, (String)causes[11], (Locale)locale);
                tmpStr = new String[]{param != null && param.equals("0") ? causes[0] + "(" + causes[1] + ")" : (param != null && param.equals("1") ? causes[1] : (param != null && param.equals("2") ? causes[13] : causes[1])), causes[3]};
                mf = new MessageFormat(msg);
                budgetdata.add((Object)mf.format(tmpStr));
            }
            budget.put("causeList", (Object)budgetdata);
        } else {
            budget.put("code", (Object)"0");
        }
        return budget.toJSONString();
    }

    @Override
    protected Object _bgControlToGuiHandle(Context ctx, String billNumber, String isomerID, int type) throws BOSException, EASBizException {
        if (billNumber == null || isomerID == null) {
            return null;
        }
        BgControlIsomerInfo isomerInfo = BgControlIsomerFactory.getLocalInstance(ctx).getBgControlIsomerInfo("Select id,number,sets.*,maps.*,connection.*,name,pfiled where id='" + isomerID + "'");
        if (BgCtrlIsomerTypeEnum.request.getValue().equals(type + "")) {
            return this.requestBudgetGUI(ctx, billNumber, isomerInfo);
        }
        if (BgCtrlIsomerTypeEnum.returnBudget.getValue().equals(type + "")) {
            return this.returnBudgetGUI(ctx, billNumber, isomerInfo);
        }
        if (BgCtrlIsomerTypeEnum.specialBudget.getValue().equals(type + "")) {
            return this.specialBudgetGUI(ctx, billNumber, isomerInfo);
        }
        if (BgCtrlIsomerTypeEnum.query.getValue().equals(type + "")) {
            ControlParameter parameter = new ControlParameter();
            return this.queryBalance(ctx, billNumber, isomerInfo, parameter);
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            LoginContext loginCtx = OpenApiContextFactory.createHttpContext((String)"127.0.0.1", (int)6888, (String)"user", (String)"", (String)"JINGAO850", (String)"l2");
            OpenApiInfo info = new OpenApiInfo();
            info.setApi("BgControlIsomerFacade-bgControlHandle");
            info.setData("[{\"dataJson\":{\"billNumber\":\"qMjYlF1KSpeLW+XQvcqYxEpE9J8=\",\"tableNumber\":\"T_BC_BIZACCOUNTBILL\",\"connectInfo\":{\"IP\":\"172.17.7.90\",\"port\":\"1521\",\"instance\":\"orcl\",\"userName\":\"ORA0702TST\"}}},{\"type\":\"2\"}]");
            OpenApi openApi = OpenApiFactory.getService((AbstractLoginContext)loginCtx);
            String result = openApi.invoke(info);
            System.out.println("----------result:" + result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String _bgControlHandle(Context ctx, String dataJson) throws BOSException, EASBizException {
        Map<String, String> map = this.parseJson(dataJson);
        BOSUuid billID = BOSUuid.read((String)map.get(BILLID));
        if (BgCtrlIsomerTypeEnum.request.getValue().equals(map.get(TYPE))) {
            IControlResult result = BgControlFacadeFactory.getLocalInstance(ctx).requestBudget(billID);
            return this.transResult(ctx, result);
        }
        if (BgCtrlIsomerTypeEnum.returnBudget.getValue().equals(map.get(TYPE))) {
            IControlResult result = BgControlFacadeFactory.getLocalInstance(ctx).returnBudget(billID);
            return this.transResult(ctx, result);
        }
        if (BgCtrlIsomerTypeEnum.query.getValue().equals(map.get(TYPE))) {
            IBudgetBalance balance = BgControlFacadeFactory.getLocalInstance(ctx).queryBalance(billID);
            return this.transBalance(ctx, balance);
        }
        if (BgCtrlIsomerTypeEnum.specialBudget.getValue().equals(map.get(TYPE))) {
            IControlResult result = BgControlFacadeFactory.getLocalInstance(ctx).specialBudget(billID);
            return this.transResult(ctx, result);
        }
        throw new BgControlIsomerException(BgControlIsomerException.TYPEFAIL);
    }

    private Map<String, String> parseJson(String dataJson) throws BOSException, EASBizException {
        logger.debug((Object)"parse json");
        if (dataJson == null) {
            throw new BgControlIsomerException(BgControlIsomerException.PARSEJSON, new Object[]{DATAJSON});
        }
        HashMap<String, String> map = new HashMap<String, String>();
        JSONObject jdata = JSONObject.parseObject((String)dataJson);
        if (jdata == null || StringUtils.isEmpty((String)jdata.getString(DATAJSON))) {
            throw new BgControlIsomerException(BgControlIsomerException.PARSEJSON, new Object[]{DATAJSON});
        }
        if (JSONObject.parseObject((String)jdata.getString(DATAJSON)) == null) {
            throw new BgControlIsomerException(BgControlIsomerException.PARSEJSON, new Object[]{DATAJSON});
        }
        String billID = JSONObject.parseObject((String)jdata.getString(DATAJSON)).getString(BILLID);
        if (StringUtils.isEmpty((String)billID)) {
            throw new BgControlIsomerException(BgControlIsomerException.PARSEJSON, new Object[]{BILLID});
        }
        String type = JSONObject.parseObject((String)jdata.getString(DATAJSON)).getString(TYPE);
        if (StringUtils.isEmpty((String)type)) {
            throw new BgControlIsomerException(BgControlIsomerException.PARSEJSON, new Object[]{TYPE});
        }
        map.put(BILLID, billID);
        map.put(TYPE, type);
        return map;
    }
}

