/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgElementCollection;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.control.BgControlBaseInfo;
import com.kingdee.eas.ma.control.BgControlSchemeInfo;
import com.kingdee.eas.ma.control.face.IBudgetBalance;
import com.kingdee.eas.ma.control.face.IControlParameter;
import com.kingdee.eas.ma.control.impl.BgAdjustBalanceOverCalcBalance;
import com.kingdee.eas.ma.control.impl.BudgetBalance;
import com.kingdee.eas.ma.control.impl.CalcBalance;
import com.kingdee.eas.ma.control.impl.ControlParameter;
import com.kingdee.eas.ma.control.impl.QueryBalanceImpl;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.common.BgAdjustBillBalanceOverParameter;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BgAdjustBanaceOverImpl
extends QueryBalanceImpl {
    public IBudgetBalance queryBalance(Context ctx, BgAdjustBillBalanceOverParameter parameter) throws Exception {
        List<BgControlParam> params = this.buildParam(ctx, parameter);
        IControlParameter controlParam = this.buildDefaultControlParam(ctx);
        this.queryBalance(ctx, params, controlParam);
        return this.transBudgetBalance(ctx, controlParam, params);
    }

    @Override
    protected void queryBalance(Context ctx, List<BgControlParam> params, IControlParameter parameter) throws Exception {
        CalcBalance calc = BgAdjustBalanceOverCalcBalance.getIntance();
        calc.calcBalance(ctx, parameter, params);
    }

    private IControlParameter buildDefaultControlParam(Context ctx) {
        ControlParameter controlParameter = new ControlParameter();
        controlParameter.setControlScheme(new BgControlSchemeInfo());
        controlParameter.getControlScheme().setBase(new BgControlBaseInfo());
        controlParameter.getControlScheme().getBase().setIsAllowAccess(true);
        return controlParameter;
    }

    protected List<BgControlParam> buildParam(Context ctx, BgAdjustBillBalanceOverParameter parameter) throws BOSException, EASBizException {
        int i;
        Object refMember;
        BgDimensionMember indexMember;
        BgDimensionMember[] members;
        parameter.setBgScheme(BgSchemeFactory.getLocalInstance((Context)ctx).getBgSchemeInfo("select id, number, name, dateFrom, dateTo, orgUnit.id, orgUnit.number, orgUnit.name, orgUnit.longNumber, period, refCube where id = '" + parameter.getBgScheme().getId().toString() + "'"));
        ArrayList<BgControlParam> parameters = new ArrayList<BgControlParam>();
        BgSchemeInfo rootBgScheme = BgViewServerHelper.getBgSchemeCubeInfo((Context)ctx, (BgSchemeInfo)parameter.getBgScheme());
        String oql = "select id, number, name, scenarioId where id = '" + parameter.getBgScenario().getId().toString() + "'";
        BgScenarioInfo scenarioInfo = BgScenarioFactory.getLocalInstance((Context)ctx).getBgScenarioInfo(oql);
        oql = "select id, number, name, versionId where id = '" + parameter.getBgVersion().getId().toString() + "'";
        BgVersionInfo versionInfo = BgVersionFactory.getLocalInstance((Context)ctx).getBgVersionInfo(oql);
        int scenarioID = scenarioInfo.getScenarioId();
        int versionID = versionInfo.getVersionId();
        LinkedHashMap<String, OrgUnitInfo> orgUnitMap = new LinkedHashMap<String, OrgUnitInfo>();
        final LinkedHashMap<String, BgElementInfo> bgElementMap = new LinkedHashMap<String, BgElementInfo>();
        final LinkedHashMap<String, CurrencyInfo> currencyMap = new LinkedHashMap<String, CurrencyInfo>();
        final HashMap hasDataMap = new HashMap();
        final HashSet bgIndexCombins = new HashSet();
        final HashSet refCombins = new HashSet();
        for (int o = 0; o < parameter.getOrgunit().length; ++o) {
            orgUnitMap.put(parameter.getOrgunit()[o].getId().toString(), parameter.getOrgunit()[o]);
        }
        HashSet<String> likeString = new HashSet<String>();
        HashSet<String> innerString = new HashSet<String>();
        for (int p = 0; p < parameter.getMembers().size(); ++p) {
            members = (BgDimensionMember[])parameter.getMembers().get(p);
            indexMember = members[0];
            refMember = members.length > 1 ? members[1] : null;
            if (indexMember.getNumber() == null) {
                likeString.add((indexMember.getSrcNumber() + ":%" + (refMember == null ? "" : "," + this.getMemberCombination((BgDimensionMember)refMember))).replaceAll(",", "_"));
                continue;
            }
            if (refMember == null) {
                likeString.add((DimensionFormulaHelper.getCombination((String)indexMember.getSrcNumber(), (String)indexMember.getNumber()) + "%").replaceAll(",", "_"));
                continue;
            }
            innerString.add((DimensionFormulaHelper.getCombination((String)indexMember.getSrcNumber(), (String)indexMember.getNumber()) + (refMember == null ? "" : "," + this.getMemberCombination((BgDimensionMember)refMember))).replaceAll(",", "_"));
        }
        int orgCount = 10;
        int dimCount = 20;
        int bgElementCount = parameter.getBgElement() == null ? 0 : 1;
        int currencyCount = parameter.getCurrency() == null ? 0 : 1;
        StringBuffer sqlLike = new StringBuffer();
        sqlLike.append("Select bgData.FOrgUnitId, bgData.FBgElementId, bgData.FCurrencyId, comb.FKey, comb.FDimKey From ").append(rootBgScheme.getRefCube()).append(" bgData, T_Mbg_BgItemCombination comb Where bgData.FBgItemCombinid = comb.FID ");
        sqlLike.append(" AND bgData.FOrgUnitId IN (");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sqlLike, (int)10).append(")");
        StringBuffer sqlInner = new StringBuffer(sqlLike);
        sqlLike.append(" AND (");
        sqlInner.append(" AND comb.FKey IN (");
        for (int i2 = 0; i2 < 20; ++i2) {
            if (i2 > 0) {
                sqlLike.append(" OR ");
                sqlInner.append(",");
            }
            sqlLike.append("comb.FKey LIKE ?");
            sqlInner.append("?");
        }
        sqlLike.append(")");
        sqlInner.append(")");
        if (bgElementCount > 0) {
            sqlLike.append(" And bgData.FBgElementId = ?");
            sqlInner.append(" And bgData.FBgElementId = ?");
        }
        if (currencyCount > 0) {
            sqlLike.append(" And bgData.FCurrencyId = ?");
            sqlInner.append(" And bgData.FCurrencyId = ?");
        }
        sqlLike.append(" And bgData.FSCENARIO = ? ");
        sqlInner.append(" And bgData.FSCENARIO = ? ");
        sqlLike.append(" And bgData.FVERSION = ? ");
        sqlInner.append(" And bgData.FVERSION = ? ");
        sqlLike.append("GROUP BY bgData.FOrgUnitId, bgData.FBgElementId, bgData.FCurrencyId, comb.FKey, comb.FDimKey");
        sqlInner.append(" GROUP BY bgData.FOrgUnitId, bgData.FBgElementId, bgData.FCurrencyId, comb.FKey, comb.FDimKey");
        ArrayList<Object[]> likeParams = new ArrayList<Object[]>();
        ArrayList<Object[]> innerParams = new ArrayList<Object[]>();
        IResultReader reader = new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String orgId = res.getString("FOrgUnitId");
                String bgElementId = res.getString("FBgElementId");
                String currencyId = res.getString("FCurrencyId");
                String comb = res.getString("FKey").replaceAll("_", ",");
                String index = comb.split(",")[0];
                bgIndexCombins.add(index);
                if (!comb.equals(index)) {
                    refCombins.add(comb.substring(index.length() + 1));
                }
                String indexSrcNumber = DimensionFormulaHelper.getSrcNumber((String)index);
                Map temMap = BgViewHelper.getSubMap((Map)BgViewHelper.getSubMap((Map)BgViewHelper.getSubMap((Map)hasDataMap, (String)orgId, (boolean)true), (String)bgElementId, (boolean)true), (String)currencyId, (boolean)true);
                if (!temMap.containsKey(indexSrcNumber)) {
                    temMap.put(indexSrcNumber, new HashMap());
                }
                ((Map)temMap.get(indexSrcNumber)).put(comb, res.getString("FDimKey").replaceAll("_", ","));
                bgElementMap.put(bgElementId, null);
                currencyMap.put(currencyId, null);
            }
        };
        Object[] orgIds = orgUnitMap.keySet().toArray();
        Object[] likes = likeString.isEmpty() ? null : likeString.toArray();
        Object[] inners = innerString.isEmpty() ? null : innerString.toArray();
        int orgBatch = MbgSqlHelper.getBatchCount((Object[])orgIds, (int)10);
        int likeBatch = MbgSqlHelper.getBatchCount((Object[])likes, (int)20);
        int innerBatch = MbgSqlHelper.getBatchCount((Object[])inners, (int)20);
        int count = 30 + bgElementCount + currencyCount;
        for (int o = 0; o < orgBatch; ++o) {
            Object[] params;
            for (int l = 0; l < likeBatch; ++l) {
                params = new Object[count + 2];
                MbgSqlHelper.setBatchParams((Object[])orgIds, (Object[])params, (int)0, (int)o, (int)10);
                MbgSqlHelper.setBatchParams((Object[])likes, (Object[])params, (int)10, (int)l, (int)20);
                if (bgElementCount > 0) {
                    params[30 + bgElementCount - 1] = parameter.getBgElement().getId().toString();
                }
                if (currencyCount > 0) {
                    params[count - 1] = parameter.getCurrency().getId().toString();
                }
                params[count] = scenarioID;
                params[count + 1] = versionID;
                likeParams.add(params);
            }
            for (int i3 = 0; i3 < innerBatch; ++i3) {
                params = new Object[count + 2];
                MbgSqlHelper.setBatchParams((Object[])orgIds, (Object[])params, (int)0, (int)o, (int)10);
                MbgSqlHelper.setBatchParams((Object[])inners, (Object[])params, (int)10, (int)i3, (int)20);
                if (bgElementCount > 0) {
                    params[30 + bgElementCount - 1] = parameter.getBgElement().getId().toString();
                }
                if (currencyCount > 0) {
                    params[count - 1] = parameter.getCurrency().getId().toString();
                }
                params[count] = scenarioID;
                params[count + 1] = versionID;
                innerParams.add(params);
            }
        }
        if (!likeParams.isEmpty()) {
            MbgSqlHelper.executeBatchQuery((Context)ctx, (String)sqlLike.toString(), likeParams, (IResultReader)reader);
        }
        if (!innerParams.isEmpty()) {
            MbgSqlHelper.executeBatchQuery((Context)ctx, (String)sqlInner.toString(), innerParams, (IResultReader)reader);
        }
        if (hasDataMap.isEmpty()) {
            return parameters;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        if (parameter.getBgElement() != null) {
            bgElementMap.put(parameter.getBgElement().getId().toString(), parameter.getBgElement());
        } else {
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(bgElementMap.keySet()), CompareType.INCLUDE));
            evi.setSorter(new SorterItemCollection());
            evi.getSelector().add("number");
            BgElementCollection col = BgElementFactory.getLocalInstance((Context)ctx).getBgElementCollection(evi);
            bgElementMap.clear();
            if (col != null) {
                for (i = 0; i < col.size(); ++i) {
                    bgElementMap.put(col.get(i).getId().toString(), col.get(i));
                }
            }
        }
        if (parameter.getCurrency() != null) {
            currencyMap.put(parameter.getCurrency().getId().toString(), parameter.getCurrency());
        } else {
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(currencyMap.keySet()), CompareType.INCLUDE));
            evi.setSorter(new SorterItemCollection());
            evi.getSelector().add("number");
            CurrencyCollection col = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(evi);
            currencyMap.clear();
            if (col != null) {
                for (i = 0; i < col.size(); ++i) {
                    currencyMap.put(col.get(i).getId().toString(), col.get(i));
                }
            }
        }
        Map bgIndexNames = DimensionFormulaFacadeFactory.getLocalInstance((Context)ctx).getDimensionCombName(parameter.getBgScheme().getId().toString(), bgIndexCombins, ContextUtil.getCurrentCostUnit((Context)ctx).getId().toString());
        Map refNames = DimensionFormulaFacadeFactory.getLocalInstance((Context)ctx).getDimensionCombName(parameter.getBgScheme().getId().toString(), refCombins, ContextUtil.getCurrentCostUnit((Context)ctx).getId().toString());
        ArrayList<Object> itemCombs = new ArrayList<Object>();
        HashSet<String> paramDimNumbers = new HashSet<String>();
        for (String orgId : orgUnitMap.keySet()) {
            if (!hasDataMap.containsKey(orgId)) continue;
            Map orgDataMap = (Map)hasDataMap.get(orgId);
            for (String bgElementId : bgElementMap.keySet()) {
                if (!orgDataMap.containsKey(bgElementId)) continue;
                Map bgElementDataMap = (Map)orgDataMap.get(bgElementId);
                for (String currencyId : currencyMap.keySet()) {
                    if (!bgElementDataMap.containsKey(currencyId)) continue;
                    Map currencyDataMap = (Map)bgElementDataMap.get(currencyId);
                    paramDimNumbers.clear();
                    for (int p = 0; p < parameter.getMembers().size(); ++p) {
                        members = (BgDimensionMember[])parameter.getMembers().get(p);
                        indexMember = members[0];
                        if (!currencyDataMap.containsKey(indexMember.getSrcNumber())) continue;
                        refMember = members.length > 1 ? members[1] : null;
                        String refItem = this.getMemberCombination((BgDimensionMember)refMember);
                        itemCombs.clear();
                        if (indexMember.getNumber() == null || refMember == null) {
                            if (currencyDataMap.get(indexMember.getSrcNumber()) != null) {
                                itemCombs.addAll(((Map)currencyDataMap.get(indexMember.getSrcNumber())).keySet());
                            }
                        } else {
                            itemCombs.add("");
                        }
                        Collections.sort(itemCombs);
                        Iterator itItem = itemCombs.iterator();
                        while (itItem.hasNext()) {
                            int ii;
                            BgControlParam param = new BgControlParam();
                            param.setDimItemNumber((String)itItem.next());
                            param.setDimNumber((String)((Map)currencyDataMap.get(indexMember.getSrcNumber())).get(param.getDimItemNumber()));
                            if (indexMember.getNumber() == null || refMember == null) {
                                ii = param.getDimItemNumber().indexOf(",");
                                if (ii > 0) {
                                    param.setBgIndexNumber(param.getDimItemNumber().substring(0, ii));
                                    if (refMember != null && !refItem.equals(param.getDimItemNumber().substring(ii + 1))) {
                                        continue;
                                    }
                                } else {
                                    param.setBgIndexNumber(param.getDimItemNumber());
                                    if (refMember != null) {
                                        continue;
                                    }
                                }
                            } else {
                                param.setBgIndexNumber(DimensionFormulaHelper.getCombination((String)indexMember.getSrcNumber(), (String)indexMember.getNumber()));
                                param.setDimItemNumber(this.getMemberCombination(new String[]{DimensionFormulaHelper.getCombination((String)indexMember.getSrcNumber(), (String)indexMember.getNumber()), refItem}));
                                param.setDimNumber("F2," + refMember.getRefField());
                                if (!((Map)currencyDataMap.get(indexMember.getSrcNumber())).containsKey(param.getDimItemNumber())) continue;
                            }
                            param.setBizDate(new Timestamp(BgNPeriodHelper.getPeriodDate((String)parameter.getSourcePeriod().getNumber()).getTime()));
                            param.setBgElement((BgElementInfo)bgElementMap.get(bgElementId));
                            param.setBgPeriodId(parameter.getSourcePeriod().getId().toString());
                            param.setBgPeriodNumber(parameter.getSourcePeriod().getNumber());
                            param.setBgPeriodName(parameter.getSourcePeriod().getName());
                            param.setBgPeriodType(parameter.getSourcePeriod().getPeriodType().getValue());
                            param.setBgSchemeInfo(parameter.getBgScheme());
                            param.setBgScenario(scenarioInfo);
                            param.setVersion(versionInfo);
                            param.setCurrency((CurrencyInfo)currencyMap.get(currencyId));
                            ii = param.getDimItemNumber().indexOf(",");
                            if (ii < 0) {
                                param.setDimItemName((String)bgIndexNames.get(param.getDimItemNumber()));
                            } else {
                                param.setDimItemName((String)bgIndexNames.get(param.getDimItemNumber().substring(0, ii)) + "_" + (String)refNames.get(param.getDimItemNumber().substring(ii + 1)));
                            }
                            param.setNotBudget(true);
                            param.setOrgUnit((OrgUnitInfo)orgUnitMap.get(orgId));
                            param.setReqOrgUnit((OrgUnitInfo)orgUnitMap.get(orgId));
                            param.setBgSchemeInfo(parameter.getBgScheme());
                            if (paramDimNumbers.contains(param.getDimItemNumber())) continue;
                            parameters.add(param);
                            paramDimNumbers.add(param.getDimItemNumber());
                        }
                    }
                }
            }
        }
        return parameters;
    }

    protected String getMemberCombination(String[] numbers) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < numbers.length; ++i) {
            if (StringUtils.isEmpty((String)numbers[i])) continue;
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(numbers[i]);
        }
        return result.toString();
    }

    protected String getMemberCombination(BgDimensionMember member) {
        if (member == null) {
            return null;
        }
        ArrayList srcNumbers = new ArrayList();
        ArrayList numbers = new ArrayList();
        StringBuffer itemComb = new StringBuffer();
        srcNumbers.addAll(Arrays.asList((Object[])member.getSrcNumber().split(",")));
        numbers.addAll(Arrays.asList((Object[])member.getNumber().split(",")));
        for (int s = 0; s < srcNumbers.size(); ++s) {
            if (itemComb.length() > 0) {
                itemComb.append(",");
            }
            itemComb.append(DimensionFormulaHelper.getCombination((String)((String)srcNumbers.get(s)), (String)((String)numbers.get(s))));
        }
        return itemComb.toString();
    }

    @Override
    public IBudgetBalance transBudgetBalance(Context ctx, IControlParameter parameter, List<BgControlParam> params) throws BOSException {
        if (ctx == null || params == null || params.isEmpty()) {
            return null;
        }
        BudgetBalance balance = new BudgetBalance();
        for (int i = 0; i < params.size(); ++i) {
            BgControlParam param = params.get(i);
            if (param.getBudgetValue() == null) continue;
            if (param.getBudgetValue() == null) {
                param.setBalance(BgNConstants.ZERO.subtract(param.getActualValue()));
            } else if (param.getActualValue() == null) {
                param.setBalance(param.getBudgetValue());
            } else {
                param.setBalance(param.getBudgetValue().subtract(param.getActualValue()));
            }
            balance.getBalance().add(param);
        }
        return balance;
    }
}

