/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlRecordObj;
import com.kingdee.eas.ma.control.face.IControlData;
import com.kingdee.eas.ma.control.face.IControlParameter;
import com.kingdee.eas.ma.control.face.IControlRecord;
import com.kingdee.eas.ma.control.impl.BgControlDataFacade;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.control.impl.models.ControlData;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeConvertToAccIntUtils;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class ControlRecord
implements IControlRecord {
    private static Logger logger = Logger.getLogger(ControlRecord.class);
    public static final String BGACTUALID = "BGACTUALID";
    private Map<String, String> allMemberMap = new TreeMap<String, String>(new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            String str1 = o1.substring(1);
            String str2 = o2.substring(1);
            return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
        }
    });

    public static synchronized IControlRecord getIntance() {
        return new ControlRecord();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writeControlRecord(Context ctx, IControlParameter parameter, List<BgControlParam> params) throws Exception {
        if (ctx == null) throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        if (parameter == null) throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        if (params == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        boolean isomer = parameter.getBgControlIsomer() != null;
        String tableName2222222 = null;
        String cubeControl = null;
        String cubeActual = null;
        HashSet<String> tableSet = new HashSet<String>();
        BgControlParam param = null;
        IControlData conData = null;
        HashMap<String, BgSchemeAccIntHelper> accIntMap = new HashMap<String, BgSchemeAccIntHelper>();
        HashMap<String, BgSchemeAccIntHelper> cubeAccIntMap = new HashMap<String, BgSchemeAccIntHelper>();
        BgSchemeAccIntHelper accIntHelper = null;
        HashMap<String, BgControlParam> calcMap = new HashMap<String, BgControlParam>();
        Map splitMap = null;
        HashSet hasFormulaSet = new HashSet();
        BgControlDataFacade facade = new BgControlDataFacade(parameter, accIntMap);
        HashMap batchMap = new HashMap();
        List<BgControlParam> tmpList = null;
        HashMap<String, Map> batchNotDistMemberMap = new HashMap<String, Map>();
        Map notDistMemberMap = null;
        int batchIndex = 0;
        StringBuffer sql = null;
        BgControlRecordObj recordInfo = new BgControlRecordObj();
        String recordId = null;
        String bosType = null;
        String assistRecordId = null;
        String billEntryId = null;
        bosType = isomer ? parameter.getBgControlIsomer().getId().getType().toString() : BOSUuid.read((String)parameter.getBillId()).getType().toString();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            Map<String, MbgDimInfo> srcMap = null;
            if (parameter.getDataManager().getSrcDimMap() == null) {
                srcMap = DimUtils.getDimInfoMap((Context)ctx);
                parameter.getDataManager().setSrcDimMap(srcMap);
            } else {
                srcMap = parameter.getDataManager().getSrcDimMap();
            }
            String bgSchemeId = null;
            String[] tableNames = new String[1];
            int in = params.size();
            for (int i = 0; i < in; ++i) {
                param = params.get(i);
                tableName2222222 = param.getBgSchemeInfo().getRefCube();
                tableSet.add(tableName2222222);
                bgSchemeId = param.getBgSchemeInfo().getId().toString();
                accIntHelper = (BgSchemeAccIntHelper)accIntMap.get(bgSchemeId);
                if (accIntHelper == null) {
                    accIntHelper = new BgSchemeAccIntHelper(ctx, bgSchemeId, tableName2222222);
                    accIntMap.put(bgSchemeId, accIntHelper);
                }
                if (accIntHelper.isUseAccInt()) {
                    calcMap.clear();
                    calcMap.put(param.getControlParamKey(), param);
                    splitMap = accIntHelper.splitBgDatas(conn, calcMap, hasFormulaSet);
                    tableName2222222 = splitMap.keySet().toArray(tableNames)[0];
                    if (tableName2222222 == null) continue;
                }
                cubeAccIntMap.put(tableName2222222, accIntHelper);
                if (batchMap.containsKey(tableName2222222)) {
                    tmpList = (List)batchMap.get(tableName2222222);
                } else {
                    tmpList = new ArrayList();
                    batchMap.put(tableName2222222, tmpList);
                }
                tmpList.add(param);
                if (batchNotDistMemberMap.containsKey(tableName2222222)) {
                    notDistMemberMap = (Map)batchNotDistMemberMap.get(tableName2222222);
                } else {
                    notDistMemberMap = param.getBgSchemeInfo().getNotDistMember(conn);
                    batchNotDistMemberMap.put(tableName2222222, notDistMemberMap);
                }
                this.transControlParam(parameter, param, notDistMemberMap);
                conData = ControlData.transControlParam(param);
                if (conData == null) continue;
                facade.addControlData(tableName2222222, conData);
            }
            HashMap controlRecordMap = new HashMap();
            ArrayList<Object[]> recordList = null;
            Object[] reocrd = null;
            for (Map.Entry entry : batchMap.entrySet()) {
                tableName2222222 = (String)entry.getKey();
                tmpList = (ArrayList)entry.getValue();
                accIntHelper = (BgSchemeAccIntHelper)accIntMap.get(bgSchemeId);
                if (accIntHelper == null) {
                    accIntHelper = new BgSchemeAccIntHelper(ctx, bgSchemeId, tableName2222222);
                    accIntMap.put(bgSchemeId, accIntHelper);
                }
                cubeControl = accIntHelper.isUseAccInt() ? BgCubeUtils.getControlCubeName((String)accIntHelper.getBgDataTable()) : BgCubeUtils.getControlCubeName((String)tableName2222222);
                sql = new StringBuffer();
                if (isomer) {
                    sql.append("Insert Into " + cubeControl + " (FID, FCreateTime, FBillID, FBillNumber, FBillType, FActaulAmount, FBizDate, FActualID, FBizOrgUnitID, FReqOrgUnitID, FControlType, FFormula, FBgIndexNum, FItemExtNumber, FBgPeriodID, FCurrencyID, FBgElementID, FScenario, FVersion, FBgSettingID,FBillEntryID,FAssistRecordID,FConnectionID,FIsomerID) Values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                } else {
                    sql.append("Insert Into " + cubeControl + " (FID, FCreateTime, FBillID, FBillNumber, FBillType, FActaulAmount, FBizDate, FActualID, FBizOrgUnitID, FReqOrgUnitID, FControlType, FFormula, FBgIndexNum, FItemExtNumber, FBgPeriodID, FCurrencyID, FBgElementID, FScenario, FVersion, FBgSettingID,FBillEntryID,FAssistRecordID) Values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                }
                recordList = new ArrayList<Object[]>();
                controlRecordMap.put(tableName2222222, recordList);
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    int xn = tmpList.size();
                    for (int x = 0; x < xn; ++x) {
                        param = (BgControlParam)tmpList.get(x);
                        accIntHelper = (BgSchemeAccIntHelper)accIntMap.get(param.getBgSchemeInfo().getId().toString());
                        reocrd = new Object[]{param.getOrgUnit().getId().toString(), accIntHelper.convertOrgObject(param.getOrgUnit().getId().toString()), param.getFormula(), param.getAcScenario().getScenarioId()};
                        recordList.add(reocrd);
                        if (param.getReqAmounts().isEmpty()) {
                            recordId = BOSUuid.create((BOSObjectType)recordInfo.getBOSType()).toString();
                            this.updateStatementParameter(pstmt, recordId, time, bosType, param.getReqAmount(), param.getAssistRecordsId(), param.getBillEntryId(), param);
                            if (isomer) {
                                pstmt.setString(23, parameter.getBgControlIsomer().getConnection().getId().toString());
                                pstmt.setString(24, parameter.getBgControlIsomer().getId().toString());
                            }
                            pstmt.addBatch();
                            if (++batchIndex < 50) continue;
                            pstmt.executeBatch();
                            batchIndex = 0;
                            continue;
                        }
                        int yn = param.getReqAmounts().size();
                        for (int y = 0; y < yn; ++y) {
                            recordId = BOSUuid.create((BOSObjectType)recordInfo.getBOSType()).toString();
                            assistRecordId = param.getAssistRecordsId();
                            if (!param.getAssistRecords().isEmpty() && param.getAssistRecords().size() >= y) {
                                assistRecordId = param.getAssistRecords().get(y);
                            }
                            billEntryId = param.getBillEntryId();
                            if (!param.getBillEntryIds().isEmpty() && param.getBillEntryIds().size() >= y) {
                                billEntryId = param.getBillEntryIds().get(y);
                            }
                            this.updateStatementParameter(pstmt, recordId, time, bosType, param.getReqAmounts().get(y), assistRecordId, billEntryId, param);
                            if (isomer) {
                                pstmt.setString(23, parameter.getBgControlIsomer().getConnection().getId().toString());
                                pstmt.setString(24, parameter.getBgControlIsomer().getId().toString());
                            }
                            pstmt.addBatch();
                            if (++batchIndex < 50) continue;
                            pstmt.executeBatch();
                            batchIndex = 0;
                        }
                    }
                    if (batchIndex <= 0) continue;
                    pstmt.executeBatch();
                }
                catch (SQLException ex) {
                    throw ex;
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
            facade.saveControlData(ctx, conn);
            if (controlRecordMap != null && !controlRecordMap.isEmpty()) {
                String actualTableName2222222 = null;
                List redList = null;
                for (String actualTableName2222222 : controlRecordMap.keySet()) {
                    cubeControl = BgCubeUtils.getControlCubeName((String)("T_MBG_BGDATA" + BgSchemeConvertToAccIntUtils.getCodeNumber((String)actualTableName2222222)));
                    redList = (List)controlRecordMap.get(actualTableName2222222);
                    StringBuffer update = new StringBuffer();
                    update.append("update " + actualTableName2222222 + " t1 set fvalue = ");
                    update.append("(select sum(t3.factaulamount) from ").append(cubeControl);
                    update.append(" t3 where t3.fbizorgunitid = ? and t1.fformula = t3.fformula)");
                    update.append(" where forgunitid = ? and fformula = ? and fscenario = ? and fversion = 1");
                    BgDBUtils.executeBatch((Connection)conn, (String)update.toString(), (List)redList);
                }
            }
            for (String tableName2222222 : batchMap.keySet()) {
                if (batchMap.get(tableName2222222) == null || ((List)batchMap.get(tableName2222222)).isEmpty()) continue;
                bgSchemeId = ((BgControlParam)((List)batchMap.get(tableName2222222)).get(0)).getBgSchemeInfo().getId().toString();
                accIntHelper = (BgSchemeAccIntHelper)accIntMap.get(bgSchemeId);
                cubeActual = BgCubeUtils.getActualCubeName((String)tableName2222222);
                cubeControl = BgCubeUtils.getControlCubeName((String)("T_MBG_BGDATA" + BgSchemeConvertToAccIntUtils.getCodeNumber((String)cubeActual)));
                sql = new StringBuffer();
                if (accIntHelper.isUseAccInt()) {
                    sql.append("Update " + cubeControl + " set FActualID = (Select FID from " + cubeActual + " where FOrgUnitId = (Select FIntId FROM T_MBG_BgOrgUnit Where FIsVirtual = 0 AND FViewID = ? AND FOrgUnitId = " + cubeControl + ".FBizOrgUnitID) and FFormula = " + cubeControl + ".FFormula and FVersion = " + cubeControl + ".FVersion) where FBillID = ?");
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{((BgSchemeAccIntHelper)cubeAccIntMap.get(cubeActual)).getSchemeHelper().getBgOrgViewId(), parameter.getBillId()});
                    continue;
                }
                sql.append("Update " + cubeControl + " set FActualID = (Select FID from " + cubeActual + " where FOrgUnitId = " + cubeControl + ".FBizOrgUnitID and FFormula = " + cubeControl + ".FFormula and FVersion = " + cubeControl + ".FVersion) where FBillID = ?");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{parameter.getBillId()});
            }
            pstmt = isomer ? conn.prepareStatement("Insert Into T_MBG_BgControlRecordDetail (FBillID, FCubeName, FIsomer, FConnectionID, FIsomerID) values (?,?,?,?,?)") : conn.prepareStatement("Insert Into T_MBG_BgControlRecordDetail (FBillID, FCubeName, FIsomer) values (?,?,?)");
            try {
                Iterator iter = tableSet.iterator();
                while (iter.hasNext()) {
                    if (isomer) {
                        pstmt.setString(1, parameter.getBillId());
                        pstmt.setString(2, (String)((Object)iter.next()));
                        pstmt.setInt(3, 1);
                        pstmt.setString(4, parameter.getBgControlIsomer().getConnection().getId().toString());
                        pstmt.setString(5, parameter.getBgControlIsomer().getId().toString());
                    } else {
                        pstmt.setString(1, parameter.getBillId());
                        pstmt.setString(2, (String)((Object)iter.next()));
                        pstmt.setInt(3, 0);
                    }
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
            finally {
                SQLUtils.cleanup((Statement)pstmt);
            }
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    logger.error((Object)"writeControlRecord Error:", (Throwable)ex2);
                    throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void transControlParam(IControlParameter parameter, BgControlParam param, Map<String, String> memberMap) {
        if (parameter == null || param == null || memberMap == null || memberMap.isEmpty()) {
            return;
        }
        String dimNumber2 = null;
        String srcNumber = null;
        String field = null;
        this.allMemberMap.clear();
        String[] tmpStrs = param.getDimItemNumber().split(",");
        if (tmpStrs != null) {
            for (String dimNumber2 : tmpStrs) {
                srcNumber = DimUtils.getSrcNumber((String)dimNumber2);
                field = parameter.getDataManager().getSrcDimMap().get(srcNumber).getRefField();
                this.allMemberMap.put(field, dimNumber2);
            }
        }
        Map.Entry<String, String> entry2 = null;
        for (Map.Entry<String, String> entry2 : memberMap.entrySet()) {
            field = entry2.getKey();
            dimNumber2 = entry2.getValue();
            if (this.allMemberMap.containsKey(field)) continue;
            this.allMemberMap.put(field, dimNumber2);
        }
        param.setDimItemNumber(DimUtils.getDimNumber(this.allMemberMap));
        param.setDimNumber(DimUtils.getFields(this.allMemberMap.keySet()));
    }

    private void updateStatementParameter(PreparedStatement pstmt, String recordId, Timestamp time, String bosType, BigDecimal reqAmount, String assistRecordId, String billEntryId, BgControlParam param) throws SQLException {
        pstmt.setString(1, recordId.toString());
        pstmt.setTimestamp(2, time);
        pstmt.setString(3, param.getBillId());
        pstmt.setString(4, param.getBillNumber());
        pstmt.setString(5, bosType);
        pstmt.setBigDecimal(6, reqAmount);
        pstmt.setTimestamp(7, param.getBizDate());
        pstmt.setString(8, BGACTUALID);
        pstmt.setString(9, param.getOrgUnit().getId().toString());
        pstmt.setString(10, param.getReqOrgUnit().getId().toString());
        pstmt.setInt(11, 0);
        pstmt.setString(12, param.getFormula());
        pstmt.setString(13, param.getBgIndexNumber());
        pstmt.setString(14, param.getDimItemNumber());
        pstmt.setString(15, param.getBgRealPeriodId());
        pstmt.setString(16, param.getCurrency().getId().toString());
        pstmt.setString(17, param.getBgElement().getId().toString());
        pstmt.setInt(18, param.getAcScenario().getScenarioId());
        pstmt.setInt(19, BgVersionHelper.DEF_VERSION_VALUE);
        if (param.getControlSetting() != null && param.getControlSetting().getId() != null) {
            pstmt.setString(20, param.getControlSetting().getId().toString());
        } else {
            pstmt.setString(20, null);
        }
        pstmt.setString(21, billEntryId);
        pstmt.setString(22, assistRecordId);
    }
}

