/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlSetFacadeFactory;
import com.kingdee.eas.ma.control.BgControlSettingInfo;
import com.kingdee.eas.ma.control.IBgControlSetFacade;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class BgControlSetUtils {
    public static String mbg_control_setting_update = "mbg_control_setting_update";
    public static String mbg_control_setting_delete = "mbg_control_setting_delete";
    public static String mbg_control_setting_distribute = "mbg_control_setting_distribute";
    public static String mbg_control_setting_antiDistribute = "mbg_control_setting_antiDistribute";
    public static String mbg_control_setting_export = "mbg_control_setting_export";
    public static String mbg_control_setting_import = "mbg_control_setting_import";

    public static void addLog(Context ctx, String logItem) {
        String logName = " ";
        IObjectPK tempPK = LogUtil.beginLog((Context)ctx, (String)"updateInfo", (BOSObjectType)new BgControlSettingInfo().getBOSType(), null, (String)logName, (String)logItem);
        LogUtil.afterLog((Context)ctx, (IObjectPK)tempPK);
    }

    public static void checkHasChange(Context ctx, String setSchemeId, List<String> setIds) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)setSchemeId) || setIds == null || setIds.isEmpty()) {
            return;
        }
        IObjectCollection colls = BgControlSetFacadeFactory.getLocalInstance(ctx).checkIsUse(setSchemeId, setIds);
        BgControlSetUtils.showChangeException(ctx, colls);
    }

    public static void checkHasChange(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        if (ctx == null || colls == null || colls.isEmpty()) {
            return;
        }
        HashMap dataMap = new HashMap();
        BgControlSettingInfo setting = null;
        List<String> dataList = null;
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            setting = (BgControlSettingInfo)colls.getObject(i);
            if (setting.getId() == null) {
                setting.setId(BOSUuid.create((BOSObjectType)setting.getBOSType()));
            }
            if (dataMap.containsKey(setting.getScheme().getId())) {
                dataList = (List)dataMap.get(setting.getScheme().getId());
            } else {
                dataList = new ArrayList();
                dataMap.put(setting.getScheme().getId(), dataList);
            }
            dataList.add(setting.getId().toString());
        }
        Map.Entry entry2 = null;
        IObjectCollection checkColls = null;
        IBgControlSetFacade facade = BgControlSetFacadeFactory.getLocalInstance(ctx);
        for (Map.Entry entry2 : dataMap.entrySet()) {
            checkColls = facade.checkIsUse(((BOSUuid)entry2.getKey()).toString(), (List)entry2.getValue());
            BgControlSetUtils.showChangeException(ctx, checkColls);
        }
    }

    private static void showChangeException(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        if (colls != null && !colls.isEmpty()) {
            String tmpStr = null;
            StringBuffer str = new StringBuffer();
            MessageFormat mf = null;
            BgControlSettingInfo setting = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                setting = (BgControlSettingInfo)colls.getObject(i);
                if (StringUtils.isEmpty((String)setting.getBgDimNumber())) {
                    tmpStr = EASCommonResource.getString((String)BgControlConstants.CONTROL_RES, (String)"bgIndex", (Locale)ctx.getLocale());
                    mf = new MessageFormat(tmpStr);
                    str.append(mf.format(new String[]{setting.getBgIndexName()}) + ",");
                    continue;
                }
                if (setting.getBgDimNumber() != null && setting.getBgDimNumber().indexOf(":") > 0) {
                    tmpStr = EASCommonResource.getString((String)BgControlConstants.CONTROL_RES, (String)"bgIndexAndDim", (Locale)ctx.getLocale());
                    mf = new MessageFormat(tmpStr);
                    str.append(mf.format(new String[]{setting.getBgIndexName(), setting.getBgDimName()}) + ",");
                    continue;
                }
                tmpStr = EASCommonResource.getString((String)BgControlConstants.CONTROL_RES, (String)"bgIndexAndMember", (Locale)ctx.getLocale());
                mf = new MessageFormat(tmpStr);
                str.append(mf.format(new String[]{setting.getBgIndexName(), setting.getBgDimName()}) + ",");
            }
            str = str.delete(str.length() - 1, str.length());
            str.append(EASCommonResource.getString((String)BgControlConstants.CONTROL_RES, (String)"bgControlSetDeleteError", (Locale)ctx.getLocale()));
            throw new BgControlException(BgControlException.SHOWMESSAGE, new String[]{str.toString()});
        }
    }
}

