/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.IBgAccount;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgDimCacheUtils;
import com.kingdee.eas.ma.base.utils.BgParamNHelper;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.control.BgControlSettingInfo;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.control.utils.BgControlUtils;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.common.BgDimDataInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimData;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.RefFieldComparator;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class BgControlTransitUtils {
    private final Logger logger = Logger.getLogger((String)BgControlTransitUtils.class.getName());
    private final Context ctx;
    private final BgSchemeDimensionHelper schemeHelper;
    private BgVersionInfo bgVersionInfo;
    public static final int INDEX_BGITEMCOMBINATION = 0;
    public static final int INDEX_BGELEMENT = 1;
    public static final int INDEX_CURRENCY = 2;
    public static final int INDEX_BGSCENARIO = 3;
    private final Map<String, List<String>> bgPeriodCacheMap = new HashMap<String, List<String>>();
    private static final Set<String> filterNonLeaf = new HashSet<String>();

    public BgControlTransitUtils(Context ctx, String bgSchemeId) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
    }

    public static BgControlTransitUtils newInstance(Context ctx, String schemeId) throws EASBizException, BOSException {
        return new BgControlTransitUtils(ctx, schemeId);
    }

    public void addNullToDataMap(Map<String, Map<String, Map<String, IBgDimData>>> bgDataMap, List<BgControlParam> controlParams, Map<String, Map<BOSUuid, BgControlSettingInfo>> groupSetMap, Map<String, Map<String, Set<String>>> allLeafMap) throws EASBizException, BOSException {
        if (controlParams == null || controlParams.isEmpty()) {
            return;
        }
        TreeMap<String, Set<String>> dimItemMap = new TreeMap<String, Set<String>>((Comparator<String>)new RefFieldComparator());
        long beginTime = System.currentTimeMillis();
        for (BgControlParam controlParam : controlParams) {
            Map<BOSUuid, BgControlSettingInfo> tmpSetMap2;
            Object groupKey;
            String tmpItem;
            int n;
            String[] tmpItems;
            String orgNumber = controlParam.getOrgUnit().getNumber();
            String elementNum = controlParam.getBgElement().getNumber();
            String currencyNum = controlParam.getCurrency().getNumber();
            String bgScenarioNum = controlParam.getBgScenario().getNumber();
            HashSet<String> refPeriods = new HashSet<String>();
            refPeriods.addAll(controlParam.getRefBgPeriods(this.ctx, this.bgPeriodCacheMap));
            refPeriods.addAll(controlParam.getRefAcPeriods(this.ctx, this.bgPeriodCacheMap));
            String[] stringArray = tmpItems = controlParam.getDimItemNumber().split(",");
            int n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                tmpItem = stringArray[n];
                this.fillMemberToDimItemMap(tmpItem, dimItemMap);
            }
            BgControlSettingInfo setting = controlParam.getControlSetting();
            if (setting.isIsGroupCtrl() && !StringUtils.isEmpty((String)setting.getGroupNo()) && groupSetMap.containsKey(groupKey = setting.getScheme().getId() + "_" + controlParam.getOrgUnit().getId() + "_" + setting.getGroupNo()) && !(tmpSetMap2 = groupSetMap.get(groupKey)).isEmpty()) {
                for (BgControlSettingInfo bgControlSettingInfo : tmpSetMap2.values()) {
                    String bgDimNumber;
                    String bgIndexNumber = bgControlSettingInfo.getBgIndexNumber();
                    Set numbers = (Set)dimItemMap.get(DimensionConstants.DEF_BGINDEX_FIELD);
                    if (!numbers.contains(bgIndexNumber)) {
                        numbers.add(bgIndexNumber);
                    }
                    if (StringUtils.isEmpty((String)(bgDimNumber = bgControlSettingInfo.getBgDimNumber())) || (tmpItems = bgDimNumber.split(",")) == null) continue;
                    for (String tmpItem2 : tmpItems) {
                        this.fillMemberToDimItemMap(tmpItem2, dimItemMap);
                    }
                }
            }
            if (1 == setting.getCtrlSetRule().getValue()) {
                if (!StringUtils.isEmpty((String)setting.getBgDimNumber())) {
                    tmpItems = setting.getBgDimNumber().split(",");
                    if (tmpItems != null) {
                        groupKey = tmpItems;
                        int tmpSetMap2 = ((String[])groupKey).length;
                        for (n = 0; n < tmpSetMap2; ++n) {
                            tmpItem = groupKey[n];
                            String[] srcNums = tmpItem.split(":");
                            if (srcNums == null || srcNums.length > 1) continue;
                            ((Set)dimItemMap.get(this.schemeHelper.getRefFieldBySrcNumber(srcNums[0]))).clear();
                        }
                    }
                } else {
                    groupKey = dimItemMap.keySet().iterator();
                    while (groupKey.hasNext()) {
                        String field = (String)groupKey.next();
                        if (DimensionConstants.DEF_BGINDEX_FIELD.equals(field)) continue;
                        ((Set)dimItemMap.get(field)).clear();
                    }
                }
            }
            HashSet<String> itemCombins = new HashSet<String>();
            for (Map.Entry entry : dimItemMap.entrySet()) {
                Set dimNumbers = (Set)entry.getValue();
                if (dimNumbers.isEmpty()) {
                    String key = (String)entry.getKey();
                    if (DimensionConstants.DEF_BGINDEX_FIELD.equals(key) || allLeafMap.get(key) == null || allLeafMap.get(key).isEmpty()) continue;
                    Collection<Set<String>> values = allLeafMap.get(key).values();
                    for (Set<String> tmp : values) {
                        dimNumbers.addAll(tmp);
                    }
                    String srcNumber = this.schemeHelper.getSrcNumberByRefField(key);
                    HashSet<String> tmpSet = new HashSet<String>();
                    for (String number : dimNumbers) {
                        tmpSet.add(srcNumber.concat(":").concat(number));
                    }
                    dimNumbers.clear();
                    dimNumbers.addAll(tmpSet);
                }
                BgControlTransitUtils.joinItemCombin(dimNumbers, itemCombins);
            }
            if (!allLeafMap.containsKey(DimensionConstants.DEF_PERIOD_FIELD) || allLeafMap.get(DimensionConstants.DEF_PERIOD_FIELD) == null || allLeafMap.get(DimensionConstants.DEF_PERIOD_FIELD).isEmpty()) {
                return;
            }
            Set<String> exists = allLeafMap.get(DimensionConstants.DEF_PERIOD_FIELD).keySet();
            HashSet<String> formulas = new HashSet<String>();
            for (String itemCombin : itemCombins) {
                for (String periodNum : refPeriods) {
                    if (!exists.contains(periodNum)) continue;
                    formulas.add(BgNFSHelper.getFormulaFromParam((String)itemCombin, (String)periodNum, (String)elementNum, (String)currencyNum, (String)bgScenarioNum));
                }
            }
            for (String formula : formulas) {
                this.add(bgDataMap, orgNumber, formula);
            }
            dimItemMap.clear();
        }
        this.logger.info((Object)("addNullToDataMap use time :" + (System.currentTimeMillis() - beginTime) + ".ms"));
    }

    private void fillMemberToDimItemMap(String item, Map<String, Set<String>> dimItemMap) {
        String[] srcNums = item.split(":");
        if (srcNums != null) {
            String srcNum = srcNums[0];
            String refField = this.schemeHelper.getRefFieldBySrcNumber(srcNum);
            if (srcNums.length > 1) {
                if (!dimItemMap.containsKey(refField)) {
                    HashSet<String> numbers = new HashSet<String>();
                    numbers.add(item);
                    dimItemMap.put(refField, numbers);
                } else {
                    dimItemMap.get(refField).add(item);
                }
            } else {
                dimItemMap.get(refField).clear();
            }
        }
    }

    private void add(Map<String, Map<String, Map<String, IBgDimData>>> bgDataMap, String orgNumber, String formula) {
        Map<String, IBgDimData> periodDataMap;
        Map<Object, Object> dimDataMap;
        String[] params = BgNFSHelper.parseFormulaPara((String)formula);
        String periodNum = params[1];
        String dimItemNumber = params[0];
        String elementNum = params[2];
        String currencyNum = params[5];
        String bgScenarioNum = params[3];
        String controlKey = BgControlUtils.getControlKey(dimItemNumber, elementNum, currencyNum, bgScenarioNum);
        if (!bgDataMap.containsKey(orgNumber)) {
            dimDataMap = new HashMap();
            bgDataMap.put(orgNumber, dimDataMap);
        }
        if (!(dimDataMap = bgDataMap.get(orgNumber)).containsKey(controlKey)) {
            periodDataMap = new HashMap();
            dimDataMap.put(controlKey, periodDataMap);
        }
        if (!(periodDataMap = (Map)dimDataMap.get(controlKey)).containsKey(periodNum)) {
            periodDataMap.put(periodNum, this.newBgDimData(periodNum, bgScenarioNum, dimItemNumber, currencyNum, elementNum));
        }
    }

    private IBgDimData newBgDimData(String periodNumber, String bgScenarioNumber, String dimItemNumber, String currencyNumber, String bgElementNumber) {
        BgDimDataInfo bgDimData = new BgDimDataInfo();
        bgDimData.setBgPeriodNumber(periodNumber);
        bgDimData.setBgScenarioNumber(bgScenarioNumber);
        bgDimData.setDimItemNumber(dimItemNumber);
        bgDimData.setCurrencyNumber(currencyNumber);
        bgDimData.setBgElementNumber(bgElementNumber);
        return bgDimData;
    }

    public void convertTransitCalc(Map<String, Map<String, IBgNData>> dataMap) throws BOSException, EASBizException {
        if (dataMap == null || dataMap.isEmpty()) {
            return;
        }
        Map<String, String> refNumbers = this.getBgOrgUnit(dataMap.keySet());
        Map<String, Map<String, Map<String, IBgDimData>>> bgDataMap = this.covertDataMap(dataMap, refNumbers);
        this.calcTransitBudgetValue(bgDataMap, null, null);
        this.fillTransitData(bgDataMap, dataMap, refNumbers);
    }

    private void fillTransitData(Map<String, Map<String, Map<String, IBgDimData>>> sourceDataMap, Map<String, Map<String, IBgNData>> targetDataMap, Map<String, String> refNumbers) {
        for (Map.Entry<String, Map<String, IBgNData>> entry : targetDataMap.entrySet()) {
            String orgUnitId = entry.getKey();
            Map<String, IBgNData> value = entry.getValue();
            Map<String, Map<String, IBgDimData>> dimDataMap = sourceDataMap.get(refNumbers.get(orgUnitId));
            for (Map<String, IBgDimData> bgDimDataMap : dimDataMap.values()) {
                for (IBgDimData data : bgDimDataMap.values()) {
                    String formula = BgNFSHelper.getFormulaFromParam((String)data.getDimItemNumber(), (String)data.getBgPeriodNumber(), (String)data.getBgElementNumber(), (String)data.getCurrencyNumber(), (String)data.getBgScenarioNumber()).concat("_").concat("Ve");
                    if (!value.containsKey(formula)) continue;
                    value.get(formula).setTransitBudget(data.getTransitBudgetValue());
                }
            }
        }
    }

    private Map<String, Map<String, Map<String, IBgDimData>>> covertDataMap(Map<String, Map<String, IBgNData>> dataMap, Map<String, String> refNumbers) {
        HashMap<String, Map<String, Map<String, IBgDimData>>> bgDataMap = new HashMap<String, Map<String, Map<String, IBgDimData>>>();
        for (Map.Entry<String, Map<String, IBgNData>> entry : dataMap.entrySet()) {
            Map dimDataMap;
            String orgUnitNumber = refNumbers.get(entry.getKey());
            if (bgDataMap.containsKey(orgUnitNumber)) {
                dimDataMap = (Map)bgDataMap.get(orgUnitNumber);
            } else {
                dimDataMap = new HashMap();
                bgDataMap.put(orgUnitNumber, dimDataMap);
            }
            Map<String, IBgNData> formulas = entry.getValue();
            for (Map.Entry<String, IBgNData> formulaEntry : formulas.entrySet()) {
                Map<String, IBgDimData> periodDataMap;
                String formula = formulaEntry.getKey();
                String[] params = BgNFSHelper.parseFormulaPara((String)(formula = formula.substring(0, formula.indexOf("_"))));
                String concatDimKey = this.getConcatDimKey(params);
                if (dimDataMap.containsKey(concatDimKey)) {
                    periodDataMap = (Map)dimDataMap.get(concatDimKey);
                } else {
                    periodDataMap = new HashMap();
                    dimDataMap.put(concatDimKey, periodDataMap);
                }
                String periodNumber = params[1];
                IBgNData value = formulaEntry.getValue();
                periodDataMap.put(periodNumber, this.toBgDimDataInfo(value));
            }
        }
        return bgDataMap;
    }

    private IBgDimData toBgDimDataInfo(IBgNData source) {
        BgDimDataInfo data = new BgDimDataInfo();
        data.setDimItemNumber(source.getDimItemNumber());
        data.setBgElementNumber(source.getBgElementNumber());
        data.setCurrencyNumber(source.getCurrencyNumber());
        data.setBgScenarioNumber(source.getBgScenario());
        data.setBgPeriodNumber(source.getBgPeriodNumber());
        data.setBudgetValue(source.getBudgetValue());
        data.setActualValue(source.getActualValue());
        return data;
    }

    private String getConcatDimKey(String[] params) {
        return params[0] + "_" + params[2] + "_" + params[5] + "_" + params[3];
    }

    private Map<String, String> getBgOrgUnit(Set<String> orgUnitIds) throws BOSException {
        HashMap<String, String> ref = new HashMap<String, String>();
        List orgUnits = null;
        try {
            orgUnits = MbgDataHelper.getOrgUnits((Context)this.ctx, new ArrayList<String>(orgUnitIds));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        for (OrgUnitInfo info : orgUnits) {
            ref.put(info.getId().toString(), info.getNumber());
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calcTransitBudgetValue(Map<String, Map<String, Map<String, IBgDimData>>> bgDataMap, List<BgControlParam> controlParams, Map<String, Map<BOSUuid, BgControlSettingInfo>> groupSetMap) throws BOSException, EASBizException {
        if (!BgParamNHelper.isLoadTransitBudget((Context)this.ctx)) {
            return;
        }
        long time = System.currentTimeMillis();
        this.bgVersionInfo = BgVersionHelper.getVersion((Context)this.ctx, (String)"Ve");
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)this.ctx);
            TreeMap<String, Map<String, Set<String>>> allLeafMap = new TreeMap<String, Map<String, Set<String>>>((Comparator<String>)new RefFieldComparator());
            Map<String, String> leafOrgUnitIds = this.getLeafOrgUnitIds(conn, this.getOrgNumbers(bgDataMap, controlParams), allLeafMap);
            HashMap<String, Set<String>> existsMembers = new HashMap<String, Set<String>>();
            Map<String, Map<String, BigDecimal>> transitValues = this.queryTransitValue(this.ctx, conn, this.schemeHelper, this.bgVersionInfo, leafOrgUnitIds, existsMembers);
            this.queryLeafMap(this.ctx, this.schemeHelper, existsMembers, allLeafMap);
            this.addNullToDataMap(bgDataMap, controlParams, groupSetMap, allLeafMap);
            this.aggregate(bgDataMap, allLeafMap, transitValues);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        this.logger.info((Object)("calcTransitBudgetValue use time :" + (System.currentTimeMillis() - time) + ".ms"));
    }

    public Map<String, String> getLeafOrgUnitIds(Connection conn, Set<String> orgNumbers, Map<String, Map<String, Set<String>>> allLeafMap) throws BOSException, EASBizException {
        HashMap<String, String> idRefNums = new HashMap<String, String>();
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        HashMap<String, Set<String>> tmpLeafMap = new HashMap<String, Set<String>>();
        HashMap<String, Set> subLeafMap = new HashMap<String, Set>();
        List bgOrgUnits = MbgDataHelper.getBgOrgUnitsByNumber((Context)this.ctx, (Connection)conn, (Locale)this.ctx.getLocale(), (BOSUuid)BOSUuid.read((String)this.schemeHelper.getBgOrgViewId()), (boolean)false, orgNumbers);
        IRowSet rs = null;
        try {
            rs = BgDBUtils.executeQuery((Connection)conn, (String)"select FOrgUnitID,FNumber,FLongNumber from T_MBG_BgOrgUnit where FViewId = ? and FIsVirtual = ? and FIsLeaf = ?", (Object[])new Object[]{this.schemeHelper.getBgOrgViewId(), 0, 1});
            while (rs.next()) {
                String orgUnitID = rs.getString("FOrgUnitID");
                String number = rs.getString("FNumber");
                String longNumber = rs.getString("FLongNumber");
                BgControlTransitUtils.addLeafToMap(number, longNumber, tmpLeafMap);
                tmp.put(number, orgUnitID);
            }
            for (BgOrgUnitInfo info : bgOrgUnits) {
                Set childNumbers = (Set)tmpLeafMap.get(info.getNumber());
                subLeafMap.put(info.getNumber(), childNumbers);
                for (String number : childNumbers) {
                    if (!tmp.containsKey(number)) continue;
                    idRefNums.put((String)tmp.get(number), number);
                }
            }
            allLeafMap.put(DimensionBaseConstants.DEF_ORGUNIT_FIELD, subLeafMap);
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return idRefNums;
    }

    private Set<String> getOrgNumbers(Map<String, Map<String, Map<String, IBgDimData>>> bgDataMap, List<BgControlParam> controlParams) {
        HashSet<String> orgNumbers = new HashSet<String>();
        if (null != bgDataMap.keySet()) {
            orgNumbers.addAll(bgDataMap.keySet());
        }
        if (null != controlParams) {
            for (BgControlParam param : controlParams) {
                orgNumbers.add(param.getOrgUnit().getNumber());
            }
        }
        return orgNumbers;
    }

    private void aggregate(Map<String, Map<String, Map<String, IBgDimData>>> bgDataMap, Map<String, Map<String, Set<String>>> allLeafMap, Map<String, Map<String, BigDecimal>> queryTransitData) throws BOSException {
        for (Map.Entry<String, Map<String, Map<String, IBgDimData>>> orgEntry : bgDataMap.entrySet()) {
            String orgNumber = orgEntry.getKey();
            Set<String> childOrgs = allLeafMap.get(DimensionConstants.DEF_ORGUNIT_FIELD).get(orgNumber);
            if (childOrgs == null || childOrgs.isEmpty()) continue;
            for (String child : childOrgs) {
                if (!queryTransitData.containsKey(child)) continue;
                Map<String, BigDecimal> transitValueMap = queryTransitData.get(child);
                this.aggregate1(orgEntry.getValue(), allLeafMap, transitValueMap);
            }
        }
    }

    private void aggregate1(Map<String, Map<String, IBgDimData>> orgDataMap, Map<String, Map<String, Set<String>>> allLeafMap, Map<String, BigDecimal> transitValueMap) throws BOSException {
        for (Map.Entry<String, Map<String, IBgDimData>> dimEntry : orgDataMap.entrySet()) {
            Set<String> leafBgItemCombin;
            String dimEntryKey = dimEntry.getKey();
            String[] keys = dimEntryKey.split("_");
            String scenarioNumber = keys[3];
            if (this.checkIsActScenario(this.ctx, scenarioNumber) || (leafBgItemCombin = BgControlTransitUtils.doJoinBgItemCombin(this.schemeHelper, allLeafMap, keys[0])) == null || leafBgItemCombin.isEmpty()) continue;
            Map<String, IBgDimData> periodDataMap = dimEntry.getValue();
            for (Map.Entry<String, IBgDimData> periodEntry : periodDataMap.entrySet()) {
                String periodNumber = periodEntry.getKey();
                IBgDimData dimData = periodEntry.getValue();
                BigDecimal sum = dimData.getTransitBudgetValue();
                Set<String> leafBgPeriods = allLeafMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD).get(periodNumber);
                if (leafBgPeriods == null || leafBgPeriods.isEmpty()) continue;
                for (String itemCombin : leafBgItemCombin) {
                    for (String period : leafBgPeriods) {
                        String formula = BgNFSHelper.getFormulaFromParam((String)itemCombin, (String)period, (String)keys[1], (String)keys[2], (String)scenarioNumber);
                        if (!transitValueMap.containsKey(formula)) continue;
                        sum = sum.add(transitValueMap.get(formula));
                    }
                }
                dimData.setTransitBudgetValue(sum);
            }
        }
    }

    private Map<String, Map<String, Map<String, Set<String>>>> createLeafFormulas(Map<String, Map<String, Map<String, IBgDimData>>> bgDataMap, Map<String, Map<String, Set<String>>> allLeafMap, Set<String> allOrgNumbers, Set<String> allFormulas) throws BOSException {
        HashMap<String, Map<String, Map<String, Set<String>>>> leafFormulas = new HashMap<String, Map<String, Map<String, Set<String>>>>();
        for (Map.Entry<String, Map<String, Map<String, IBgDimData>>> orgEntry : bgDataMap.entrySet()) {
            Map map;
            String orgNumber = orgEntry.getKey();
            if (!leafFormulas.containsKey(orgNumber)) {
                map = new HashMap();
                leafFormulas.put(orgNumber, map);
            } else {
                map = (Map)leafFormulas.get(orgNumber);
            }
            allOrgNumbers.addAll((Collection<String>)allLeafMap.get(DimensionBaseConstants.DEF_ORGUNIT_FIELD).get(orgNumber));
            Map<String, Map<String, IBgDimData>> orgDataMap = orgEntry.getValue();
            for (Map.Entry<String, Map<String, IBgDimData>> dimEntry : orgDataMap.entrySet()) {
                Map map1;
                String dimEntryKey = dimEntry.getKey();
                if (!map.containsKey(dimEntryKey)) {
                    map1 = new HashMap();
                    map.put(dimEntryKey, map1);
                } else {
                    map1 = (Map)map.get(dimEntryKey);
                }
                String[] keys = dimEntryKey.split("_");
                String scenarioNumber = keys[3];
                if (this.checkIsActScenario(this.ctx, scenarioNumber)) continue;
                Set<String> leafBgItemCombin = BgControlTransitUtils.doJoinBgItemCombin(this.schemeHelper, allLeafMap, keys[0]);
                Map<String, IBgDimData> periodDataMap = dimEntry.getValue();
                for (String periodNumber : periodDataMap.keySet()) {
                    Set<String> set;
                    if (!map1.containsKey(periodNumber)) {
                        set = new HashSet();
                        map1.put(periodNumber, set);
                    } else {
                        set = (Set)map1.get(periodNumber);
                    }
                    Set<String> leafBgPeriods = allLeafMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD).get(periodNumber);
                    for (String itemCombin : leafBgItemCombin) {
                        for (String period : leafBgPeriods) {
                            String formula = BgNFSHelper.getFormulaFromParam((String)itemCombin, (String)period, (String)keys[1], (String)keys[2], (String)scenarioNumber);
                            set.add(formula);
                            allFormulas.add(formula);
                        }
                    }
                }
            }
        }
        return leafFormulas;
    }

    private BigDecimal transitValue(BigDecimal odlValue, BigDecimal adjustValue) {
        if (odlValue != null && adjustValue != null) {
            if (odlValue.compareTo(adjustValue) <= 0) {
                return BigDecimal.ZERO;
            }
            return odlValue.subtract(adjustValue);
        }
        return BigDecimal.ZERO;
    }

    public static Set<String> doJoinBgItemCombin(BgSchemeDimensionHelper schemeHelper, Map<String, Map<String, Set<String>>> allLeafMap, String bgItemCombin) {
        Map<String, String> srcNumMap = BgControlTransitUtils.splitBgItemCombin(bgItemCombin);
        HashSet<String> itemCombins = new HashSet<String>();
        for (Map.Entry<String, Map<String, Set<String>>> entry : allLeafMap.entrySet()) {
            Set<Object> leafNumbers;
            String key = entry.getKey();
            Map<String, Set<String>> numberMaps = entry.getValue();
            if (DimensionBaseConstants.DEF_ORGUNIT_FIELD.equals(key) || DimensionBaseConstants.DEF_PERIOD_FIELD.equals(key)) continue;
            String srcNumber = schemeHelper.getSrcNumberByRefField(key);
            HashSet<String> dimNumbers = new HashSet<String>();
            if (!srcNumMap.containsKey(srcNumber)) {
                leafNumbers = new HashSet();
                for (Set<String> set : numberMaps.values()) {
                    leafNumbers.addAll(set);
                }
            } else {
                leafNumbers = numberMaps.get(srcNumMap.get(srcNumber));
            }
            if (leafNumbers == null || leafNumbers.isEmpty()) continue;
            for (String string : leafNumbers) {
                dimNumbers.add(srcNumber.concat(":").concat(string));
            }
            BgControlTransitUtils.joinItemCombin(dimNumbers, itemCombins);
        }
        return itemCombins;
    }

    private static Map<String, String> splitBgItemCombin(String bgItemCombin) {
        String[] itemCombins;
        HashMap<String, String> srcNumMap = new HashMap<String, String>();
        for (String item : itemCombins = bgItemCombin.split(",")) {
            if (!item.contains(":")) continue;
            String[] srcNumbers = item.split(":");
            srcNumMap.put(srcNumbers[0], srcNumbers[1]);
        }
        return srcNumMap;
    }

    private static void joinItemCombin(Set<String> dimNumbers, Set<String> itemCombins) {
        HashSet<String> join = new HashSet<String>();
        if (itemCombins.isEmpty()) {
            join.addAll(dimNumbers);
        } else {
            HashSet<String> tmpItemCombins = new HashSet<String>();
            for (String dimNumber : dimNumbers) {
                for (String tmpItemCombin : itemCombins) {
                    tmpItemCombins.add(tmpItemCombin.concat(",").concat(dimNumber));
                }
                join.addAll(tmpItemCombins);
            }
        }
        itemCombins.clear();
        itemCombins.addAll(join);
    }

    public Map<String, Map<String, BigDecimal>> queryTransitValue(Context ctx, Connection conn, BgSchemeDimensionHelper schemeHelper, BgVersionInfo versionInfo, Map<String, String> leafOrgUnitIds, Map<String, Set<String>> fieldNumbers) throws BOSException, EASBizException {
        TempTablePool pool = null;
        String tmpOrgTable = null;
        IRowSet rs = null;
        HashMap<String, Map<String, BigDecimal>> tBValues = new HashMap<String, Map<String, BigDecimal>>();
        try {
            pool = TempTablePool.getInstance((Context)ctx);
            tmpOrgTable = BgDBUtils.createTmpTable((TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpOrgTable + " (FID) values (?)"), leafOrgUnitIds.keySet());
            String sql = "select  FID,FOrgUnitId,FFormula,FBgItemCombination,FoldValue,FValue from T_MBG_bgtmpData where ForgUnitId in (select FID from " + tmpOrgTable + ")  and  Fversion = ? and FbgSchemerootId = ? and FprocessType = ?";
            rs = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{versionInfo.getVersionId(), schemeHelper.getBgSchemeId(), 1});
            while (rs.next()) {
                String orgUnitNumber = leafOrgUnitIds.get(rs.getString("FOrgUnitId"));
                String formula = rs.getString("FFormula");
                BigDecimal oldValue = rs.getBigDecimal("FoldValue");
                BigDecimal value = rs.getBigDecimal("FValue");
                if (!tBValues.containsKey(orgUnitNumber)) {
                    HashMap values = new HashMap();
                    tBValues.put(orgUnitNumber, values);
                }
                if (BigDecimal.ZERO.compareTo(this.transitValue(oldValue, value)) != 0) {
                    ((Map)tBValues.get(orgUnitNumber)).put(formula, this.transitValue(oldValue, value));
                }
                this.addRefFieldMembers(schemeHelper, fieldNumbers, rs.getString("FBgItemCombination"));
                if (!fieldNumbers.containsKey(DimensionConstants.DEF_PERIOD_FIELD)) {
                    fieldNumbers.put(DimensionConstants.DEF_PERIOD_FIELD, new HashSet());
                }
                fieldNumbers.get(DimensionConstants.DEF_PERIOD_FIELD).add(BgNFSHelper.parseFormulaPara((String)formula)[1]);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException();
            }
            catch (Throwable throwable) {
                BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpOrgTable);
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpOrgTable);
        SQLUtils.cleanup((ResultSet)rs);
        return tBValues;
    }

    private void addRefFieldMembers(BgSchemeDimensionHelper schemeHelper, Map<String, Set<String>> fieldNumbers, String itemCombin) {
        String[] splits;
        for (String str : splits = itemCombin.split(",")) {
            String[] srcNumbers = str.split(":");
            String field = schemeHelper.getRefFieldBySrcNumber(srcNumbers[0]);
            if (!fieldNumbers.containsKey(field)) {
                HashSet s = new HashSet();
                fieldNumbers.put(field, s);
            }
            fieldNumbers.get(field).add(srcNumbers[1]);
        }
    }

    public void queryLeafMap(Context ctx, BgSchemeDimensionHelper schemeHelper, Map<String, Set<String>> existsMembers, Map<String, Map<String, Set<String>>> allLeafMap) throws BOSException {
        long time = System.currentTimeMillis();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("number");
        evi.getSelector().add("longNumber");
        Map refFieldMap = schemeHelper.getRefFieldMap();
        for (String field : refFieldMap.values()) {
            IBgAccount treeBase;
            if (filterNonLeaf.contains(field)) continue;
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("isLeaf", (Object)true, CompareType.EQUALS));
            Set<String> strings = existsMembers.get(field);
            if (null == strings || strings.isEmpty()) continue;
            if (DimensionBaseConstants.DEF_BGINDEX_FIELD.equals(field)) {
                treeBase = BgAccountFactory.getLocalInstance((Context)ctx);
                evi.getFilter().getFilterItems().add(new FilterItemInfo("bgAccountView.id", (Object)schemeHelper.getDimension(DimensionConstants.DEF_ACCOUNT_NUMBER).getViewId()));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("number", strings, CompareType.INCLUDE));
            } else if (DimensionBaseConstants.DEF_PERIOD_FIELD.equals(field)) {
                treeBase = BgPeriodDispFactory.getLocalInstance((Context)ctx);
                evi.getFilter().getFilterItems().add(new FilterItemInfo("type.id", (Object)schemeHelper.getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, false), CompareType.INCLUDE));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("number", strings, CompareType.INCLUDE));
            } else {
                treeBase = MbgMemberFactory.getLocalInstance((Context)ctx);
                evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)((BgDimensionInfo)schemeHelper.getDimensionByRefField().get(field)).getViewId()));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("number", strings, CompareType.INCLUDE));
            }
            TreeBaseCollection col = treeBase.getTreeBaseCollection(evi);
            HashMap<String, Set<String>> subLeafMap = new HashMap<String, Set<String>>();
            if (col != null && !col.isEmpty()) {
                for (int i = 0; i < col.size(); ++i) {
                    BgControlTransitUtils.addLeafToMap(col.get(i).getNumber(), col.get(i).getLongNumber(), subLeafMap);
                }
            }
            allLeafMap.put(field, subLeafMap);
        }
        this.logger.info((Object)("query leafMemberMap use:" + (System.currentTimeMillis() - time) + ".ms"));
    }

    private static void addLeafToMap(String number, String longNumber, Map<String, Set<String>> subLeafMap) {
        String[] lns;
        for (String ln : lns = longNumber.split("!")) {
            if (!subLeafMap.containsKey(ln)) {
                subLeafMap.put(ln, new HashSet());
            }
            subLeafMap.get(ln).add(number);
        }
    }

    public boolean checkIsActScenario(Context ctx, String scenarioNumber) throws BOSException {
        Map scenarioCache = BgDimCacheUtils.getScenarioCache((Context)ctx);
        if (scenarioCache.containsKey(scenarioNumber)) {
            return BgScenarioType.ActualData.equals(((IObjectValue)scenarioCache.get(scenarioNumber)).get("type"));
        }
        return false;
    }

    public static Date[] getYearTime(Timestamp bizDate) {
        if (bizDate == null) {
            return null;
        }
        CalendarHelper helper = new CalendarHelper();
        int year = helper.getCurrentlyYear((Date)bizDate);
        Date[] dates = new Date[]{helper.getFirstDayOfYear(year), helper.getLastDayOfYear(year)};
        return dates;
    }

    public static Date[] getHalfYearTime(Timestamp bizDate) {
        if (bizDate == null) {
            return null;
        }
        CalendarHelper helper = new CalendarHelper();
        int year = helper.getCurrentlyYear((Date)bizDate);
        int halfyear = helper.getCurrentlyHalfYear((Date)bizDate);
        Date[] dates = new Date[]{helper.getFirstDayOfHalfYear(year, halfyear), helper.getLastDayOfHalfYear(year, halfyear)};
        return dates;
    }

    public static Date[] getQuarterTime(Timestamp bizDate) {
        if (bizDate == null) {
            return null;
        }
        CalendarHelper helper = new CalendarHelper();
        int year = helper.getCurrentlyYear((Date)bizDate);
        int quarter = helper.getCurrentlyQuarter((Date)bizDate);
        Date[] dates = new Date[]{helper.getFirstDayOfQuarter(year, quarter), helper.getLastDayOfQuarter(year, quarter)};
        return dates;
    }

    public static Date[] getMonthTime(Timestamp bizDate) {
        if (bizDate == null) {
            return null;
        }
        CalendarHelper helper = new CalendarHelper();
        int year = helper.getCurrentlyYear((Date)bizDate);
        int month = helper.getCurrentlyMonth((Date)bizDate);
        Date[] dates = new Date[]{helper.getFirstDayOfMonth(year, month), helper.getLastDayOfMonth(year, month)};
        return dates;
    }

    static {
        Collections.addAll(filterNonLeaf, DimensionBaseConstants.DEF_ELEMENT_FIELD, DimensionBaseConstants.DEF_SCENARIO_FIELD, DimensionBaseConstants.DEF_CURRENCY_FIELD, DimensionBaseConstants.DEF_VERSION_FIELD, DimensionBaseConstants.DEF_ORGUNIT_FIELD);
    }
}

