/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.control.AbstractBgControlIsomerSetInfo;
import com.kingdee.eas.ma.control.BgControlIsomerConnectionInfo;
import com.kingdee.eas.ma.control.BgControlIsomerFactory;
import com.kingdee.eas.ma.control.BgControlIsomerInfo;
import com.kingdee.eas.ma.control.BgControlIsomerMapCollection;
import com.kingdee.eas.ma.control.BgControlIsomerSetCollection;
import com.kingdee.eas.ma.control.BgControlIsomerSetInfo;
import com.kingdee.eas.ma.control.client.utils.BgControlIsomerCHelper;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.ma.control.utils.BgControlIsomerKSQLUtils;
import com.kingdee.eas.ma.control.utils.VirtualIsomerInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.MutableTreeNode;

public class BgIsomerTreeUtils {
    private static BgControlIsomerKSQLUtils ksqlClient = null;
    private static BgControlIsomerInfo info = null;
    private Map<String, Map<String, String>> tableMap = new HashMap<String, Map<String, String>>();

    public DefaultKingdeeTreeNode createRootTree(BgControlIsomerInfo entity) throws EASBizException, BOSException {
        if (entity == null) {
            return null;
        }
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText(entity.getName());
        VirtualIsomerInfo dataObject = new VirtualIsomerInfo();
        dataObject.setEntity(entity);
        dataObject.setName("");
        dataObject.setAlias("");
        dataObject.setRoot(true);
        root.setUserObject((Object)dataObject);
        this.initData(entity);
        this.addDefaultChildNode(root);
        return root;
    }

    private void initData(BgControlIsomerInfo entity) throws EASBizException, BOSException {
        info = BgControlIsomerFactory.getRemoteInstance().getBgControlIsomerInfo((IObjectPK)new ObjectUuidPK(entity.getId()), this.getSelectors());
        BgControlIsomerSetCollection colls = info.getSets();
        HashSet<String> tableName = new HashSet<String>();
        if (!this.tableMap.containsKey(info.getNumber().toUpperCase())) {
            tableName.add(info.getNumber().toUpperCase());
        }
        if (colls != null && colls.size() > 0) {
            for (int i = 0; i < colls.size(); ++i) {
                if (!this.tableMap.containsKey(colls.get(i).getNumber().toUpperCase())) {
                    tableName.add(colls.get(i).getNumber().toUpperCase());
                }
                if (this.tableMap.containsKey(colls.get(i).getCnumber().toUpperCase())) continue;
                tableName.add(colls.get(i).getCnumber().toUpperCase());
            }
        }
        this.getTableColMap(tableName);
    }

    private void getTableColMap(Set<String> tableName) throws EASBizException, BOSException {
        if (BgIsomerTreeUtils.getKSQLCilent() != null) {
            String table = null;
            Iterator<String> iterator = tableName.iterator();
            while (iterator.hasNext()) {
                table = iterator.next();
                if (!this.tableMap.containsKey(table.toUpperCase())) continue;
                iterator.remove();
            }
            if (!tableName.isEmpty()) {
                try {
                    String newsql = BgControlIsomerCHelper.queryColumnSQL(tableName, (BgControlIsomerConnectionInfo)info.getConnection());
                    IRowSet rowset = BgIsomerTreeUtils.getKSQLCilent().getTargetRowset(newsql);
                    while (rowset.next()) {
                        if (this.tableMap.containsKey(rowset.getString(2).toUpperCase())) {
                            this.tableMap.get(rowset.getString(2).toUpperCase()).put(rowset.getString(1), rowset.getString(3));
                            continue;
                        }
                        HashMap<String, String> col = new HashMap<String, String>();
                        col.put(rowset.getString(1), rowset.getString(3));
                        this.tableMap.put(rowset.getString(2).toUpperCase(), col);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"connectFail"));
            SysUtil.abort();
        }
    }

    public void addDefaultChildNode(DefaultKingdeeTreeNode parentNode) throws EASBizException, BOSException {
        Serializable entity;
        VirtualIsomerInfo dataObject = (VirtualIsomerInfo)((Object)parentNode.getUserObject());
        Map<Object, Object> set = new HashMap();
        if (dataObject.isRoot()) {
            entity = dataObject.getEntity();
            if (entity == null || dataObject.isExpanded()) {
                return;
            }
            if (parentNode.getChildCount() > 0) {
                parentNode.removeAllChildren();
            }
            set = this.tableMap.get(info.getNumber().toUpperCase());
        } else {
            entity = dataObject.getEntitySet();
            if (entity == null || dataObject.isExpanded()) {
                return;
            }
            if (parentNode.getChildCount() > 0) {
                parentNode.removeAllChildren();
            }
            set = this.tableMap.get(((AbstractBgControlIsomerSetInfo)entity).getNumber().toUpperCase());
        }
        BgControlIsomerMapCollection collsMap = info.getMaps();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < collsMap.size(); ++i) {
            map.put(collsMap.get(i).getNumber().toUpperCase() + collsMap.get(i).getIsomerField().toUpperCase(), collsMap.get(i).getEasField());
        }
        BgControlIsomerSetCollection colls = info.getSets();
        int size = colls.size();
        Object var8_9 = null;
        BgControlIsomerSetInfo propertyInfo = null;
        if (!set.isEmpty()) {
            for (String string : set.keySet()) {
                VirtualIsomerInfo childDataObject = new VirtualIsomerInfo();
                childDataObject.setNodeLevel(dataObject.getNodeLevel() + 1);
                childDataObject.setName(this.getValue(dataObject, string));
                childDataObject.setDataType((String)set.get(string));
                DefaultKingdeeTreeNode childNode = new DefaultKingdeeTreeNode((Object)childDataObject);
                if (dataObject.isRoot()) {
                    if (map.containsKey(info.getNumber().toUpperCase() + string)) {
                        childNode.setText((String)map.get(info.getNumber().toUpperCase() + string));
                    } else {
                        childNode.setText(string);
                    }
                } else {
                    BgControlIsomerSetInfo entity2 = dataObject.getEntitySet();
                    if (map.containsKey(entity2.getNumber().toUpperCase() + string)) {
                        childNode.setText((String)map.get(entity2.getNumber().toUpperCase() + string));
                    } else {
                        childNode.setText(string);
                    }
                }
                boolean isProperty = false;
                for (int i = 0; i < size; ++i) {
                    propertyInfo = colls.get(i);
                    if (!(this.tableMap.containsKey(propertyInfo.getCnumber().toUpperCase()) && dataObject.isRoot() ? propertyInfo.getCnumber().equals(info.getNumber()) : propertyInfo.getCnumber().equals(dataObject.getEntitySet().getNumber())) || !string.equals(propertyInfo.getCField())) continue;
                    childDataObject.setEntitySet(propertyInfo);
                    childNode.setText(propertyInfo.getName());
                    childNode.setAllowsChildren(true);
                    parentNode.add((MutableTreeNode)childNode);
                    childNode.add((MutableTreeNode)new DefaultKingdeeTreeNode());
                    isProperty = true;
                    break;
                }
                if (isProperty) continue;
                childDataObject.setMultilingual(false);
                childDataObject.setTableField(string);
                childNode.setAllowsChildren(false);
                parentNode.add((MutableTreeNode)childNode);
            }
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("maps.*"));
        sic.add(new SelectorItemInfo("connection.*"));
        sic.add(new SelectorItemInfo("sets.*"));
        return sic;
    }

    private static BgControlIsomerKSQLUtils getKSQLCilent() throws EASBizException, BOSException {
        ksqlClient = BgControlIsomerCHelper.getKSQLClient((BgControlIsomerConnectionInfo)info.getConnection());
        return ksqlClient;
    }

    private String getValue(VirtualIsomerInfo parent, String propertyName) {
        String value = "";
        String parentValue = parent.getName();
        value = parentValue.length() == 0 ? propertyName : parentValue + "." + propertyName;
        return value;
    }
}

