/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgParamNHelper;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlExpendRuleInfo;
import com.kingdee.eas.ma.control.BgControlSchemeInfo;
import com.kingdee.eas.ma.control.BgControlSettingInfo;
import com.kingdee.eas.ma.control.BgCtrlValueEnum;
import com.kingdee.eas.ma.control.face.IControlParameter;
import com.kingdee.eas.ma.control.impl.CalcBalance;
import com.kingdee.eas.ma.control.impl.ControlCheck;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.control.impl.models.BgGroupData;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizExpandUtils {
    private static Logger logger = Logger.getLogger((String)BizExpandUtils.class.getName());
    public static final int CTRL_VALUE = 0;
    public static final int CTRL_PARAM = 1;
    public static final int CTRL_FROMULA = 2;
    public static final int CTRL_MAX = 3;
    private BgControlSchemeInfo controlScheme = null;
    private Map<String, BgControlExpendRuleInfo> expandRuleMap = new HashMap<String, BgControlExpendRuleInfo>();
    private Map<String, Set<String>> expandGroupAccs = new HashMap<String, Set<String>>();

    public void setControlScheme(BgControlSchemeInfo controlScheme) {
        this.controlScheme = controlScheme;
    }

    public BgControlSchemeInfo getControlScheme() {
        return this.controlScheme;
    }

    public BizExpandUtils(BgControlSchemeInfo controlScheme) {
        this.setControlScheme(controlScheme);
        this.initData();
    }

    private void initData() {
        if (this.getControlScheme() == null || this.getControlScheme().getBgCtrlExpendRule() == null || this.getControlScheme().getBgCtrlExpendRule().isEmpty()) {
            return;
        }
        BgControlExpendRuleInfo expandRuleInfo = null;
        for (int i = 0; i < this.getControlScheme().getBgCtrlExpendRule().size(); ++i) {
            expandRuleInfo = this.getControlScheme().getBgCtrlExpendRule().get(i);
            this.expandRuleMap.put(expandRuleInfo.getBgReqAccNum(), expandRuleInfo);
            if (!expandRuleInfo.isIsGroup()) continue;
            if (!this.expandGroupAccs.containsKey(expandRuleInfo.getBgCtrlAccNum())) {
                this.expandGroupAccs.put(expandRuleInfo.getBgCtrlAccNum(), new HashSet());
            }
            this.expandGroupAccs.get(expandRuleInfo.getBgCtrlAccNum()).add(expandRuleInfo.getBgReqAccNum());
        }
    }

    public void matchExandControl(List<BgControlParam> controlParams) throws BOSException {
        if (controlParams == null || controlParams.isEmpty() || this.expandRuleMap.isEmpty()) {
            return;
        }
        HashMap<String, BgControlParam> controlParamMap = new HashMap<String, BgControlParam>();
        BgControlParam param = null;
        BgControlParam expandParam = null;
        String controlKey = null;
        HashMap<String, BigDecimal> reqAmountMapping = new HashMap<String, BigDecimal>();
        for (int i = 0; i < controlParams.size(); ++i) {
            param = controlParams.get(i);
            controlKey = param.getControlParamKey();
            controlParamMap.put(controlKey, param);
            reqAmountMapping.put(param.getBgIndexNumber(), param.getReqAmount());
        }
        ArrayList<BgControlParam> expandParams = new ArrayList<BgControlParam>();
        for (int i = 0; i < controlParams.size(); ++i) {
            param = controlParams.get(i);
            param.setExpandInfo(this.expandRuleMap.get(DimensionFormulaHelper.getMemberNumber((String)param.getBgIndexNumber())));
            if (param.getExpandInfo() != null) {
                String accountNumber = DimensionFormulaHelper.getCombination((String)DimensionConstants.DEF_INDEX_SRCNUMBER, (String)param.getExpandInfo().getBgCtrlAccNum());
                expandParam = this.replaceAccount(param, accountNumber, controlParamMap, expandParams);
                expandParam.setReqAmount((BigDecimal)reqAmountMapping.get(expandParam.getBgIndexNumber()));
                expandParam.setIsExpandCtrlParam(true);
                param.setExpandCtrlParam(expandParam);
            }
            if (param.getExpandInfo() == null || !param.getExpandInfo().isIsGroup() || !this.expandGroupAccs.containsKey(param.getExpandInfo().getBgCtrlAccNum())) continue;
            for (String accountNumber : this.expandGroupAccs.get(param.getExpandInfo().getBgCtrlAccNum())) {
                expandParam = this.replaceAccount(param, accountNumber, controlParamMap, expandParams);
                expandParam.setReqAmount((BigDecimal)reqAmountMapping.get(expandParam.getBgIndexNumber()));
                expandParam.setExpandInfo(this.expandRuleMap.get(accountNumber));
                expandParam.setIsExpandCtrlParam(false);
                param.getExpandGroupAccs().put(accountNumber, expandParam);
            }
        }
        controlParams.addAll(expandParams);
    }

    private BgControlParam replaceAccount(BgControlParam param, String accountNumber, Map<String, BgControlParam> controlParamMap, List<BgControlParam> expandParams) throws BOSException {
        try {
            BgControlParam expandParam = param.clone();
            if (!this.expandRuleMap.containsKey(accountNumber)) {
                expandParam.setReqAmount(null);
            }
            if (!accountNumber.startsWith(DimensionConstants.DEF_INDEX_SRCNUMBER + ":")) {
                expandParam.setBgIndexNumber(DimensionFormulaHelper.getCombination((String)DimensionConstants.DEF_INDEX_SRCNUMBER, (String)accountNumber));
            } else {
                expandParam.setBgIndexNumber(accountNumber);
            }
            expandParam.setOnlyExpandControl(true);
            if (!StringUtils.isEmpty((String)expandParam.getDimItemNumber()) && expandParam.getDimItemNumber().indexOf(",") > 0) {
                expandParam.setDimItemNumber(expandParam.getBgIndexNumber() + expandParam.getDimItemNumber().substring(expandParam.getDimItemNumber().indexOf(",")));
            } else {
                expandParam.setDimItemNumber(expandParam.getBgIndexNumber());
            }
            String controlKey = expandParam.getControlParamKey();
            expandParams.add(expandParam);
            return expandParam;
        }
        catch (CloneNotSupportedException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void removeExpandControl(List<BgControlParam> params) {
        if (params == null || params.isEmpty()) {
            return;
        }
        Iterator<BgControlParam> it = params.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyExpandControl()) continue;
            it.remove();
        }
    }

    public void expandControl(Context ctx, IControlParameter parameter, List<BgControlParam> params) throws BOSException {
        if (params == null || params.isEmpty()) {
            return;
        }
        BgControlParam param = null;
        BgControlParam expandParam = null;
        StringBuffer budgetValue = new StringBuffer();
        StringBuffer ctrlValue = new StringBuffer();
        StringBuffer actualValue = new StringBuffer();
        int precision = -1;
        HashMap<String, BigDecimal> budgetDetail = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> transitBudgetDetail = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> actualDetail = new HashMap<String, BigDecimal>();
        HashSet dimNumberSet = new HashSet();
        ArrayList dimNumbers = new ArrayList();
        boolean loadTransitBudget = BgParamNHelper.isLoadTransitBudget((Context)ctx);
        ControlCheck.getInstance().calcBalance(ctx, parameter, params);
        ArrayList<BgControlParam> expendParams = new ArrayList<BgControlParam>();
        for (int i = 0; i < params.size(); ++i) {
            param = params.get(i);
            param.setOverBudget(false);
            if (param.isOnlyExpandControl() || param.getExpandInfo() == null) continue;
            expandParam = param.getExpandCtrlParam();
            precision = param.getCurrency().getPrecision();
            param.setCalculateFormula(new Object[3]);
            budgetValue.setLength(0);
            ctrlValue.setLength(0);
            actualValue.setLength(0);
            BigDecimal ctrlBudget = BizExpandUtils.getCtrlBudget(expandParam);
            BigDecimal ctrlTransitBudget = BizExpandUtils.getCtrlTransitBudget(expandParam);
            BigDecimal ctrlActual = BizExpandUtils.getCtrlActual(expandParam);
            if (ctrlBudget == null) {
                ctrlBudget = BigDecimal.ZERO;
            }
            if (ctrlTransitBudget == null) {
                ctrlTransitBudget = BigDecimal.ZERO;
            }
            if (ctrlActual == null) {
                ctrlActual = BgNConstants.ZERO;
            }
            logger.error((Object)("ctrlBudget:" + ctrlBudget + " ctrlActual:" + ctrlActual + " ctrlTransitBudget :" + ctrlTransitBudget));
            BigDecimal executeValue = BgNConstants.ZERO.compareTo(ctrlBudget.subtract(ctrlTransitBudget)) == 0 || BgNConstants.ZERO.compareTo(ctrlActual) == 0 ? BgNConstants.ZERO : ctrlActual.divide(ctrlBudget.subtract(ctrlTransitBudget), 8, 4);
            ctrlActual = this.setPrecision(ctrlActual, precision);
            ctrlBudget = this.setPrecision(ctrlBudget, precision);
            ctrlTransitBudget = this.setPrecision(ctrlTransitBudget, precision);
            if (BgCtrlValueEnum.EXERATIO.equals((Object)param.getExpandInfo().getBgCtrlValue())) {
                if (param.getExpandCtrlParam() != null && param.getExpandCtrlParam().getControlSetting().isIsGroupCtrl()) {
                    BgControlParam expandCtrlParam = param.getExpandCtrlParam();
                    Iterator<BOSUuid> sumBudget = BigDecimal.ZERO;
                    BigDecimal sumTransit = BigDecimal.ZERO;
                    for (BgGroupData groupData : expandCtrlParam.getBudgetDetail().values()) {
                        sumBudget = ((BigDecimal)((Object)sumBudget)).add(groupData.getBudgetValue());
                        sumTransit = sumTransit.add(groupData.getTransitBudgetValue());
                    }
                    if (BigDecimal.ZERO.compareTo(expandCtrlParam.getBudgetValue() == null ? BigDecimal.ZERO : expandCtrlParam.getBudgetValue()) == 0) {
                        expandCtrlParam.setBudgetValue((BigDecimal)((Object)sumBudget));
                    }
                    if (BigDecimal.ZERO.compareTo(expandCtrlParam.getTransitBudgetValue() == null ? BigDecimal.ZERO : expandCtrlParam.getTransitBudgetValue()) == 0) {
                        expandCtrlParam.setTransitBudgetValue(sumTransit);
                    }
                    this.dealCtrlValueFormula(param.getExpandCtrlParam(), ctrlValue, loadTransitBudget);
                } else if (loadTransitBudget) {
                    ctrlValue.append("(").append(ctrlActual).append("/").append("(").append(ctrlBudget).append("-").append(ctrlTransitBudget).append(")").append(")");
                } else {
                    ctrlValue.append("(").append(ctrlActual).append("/").append(ctrlBudget).append(")");
                }
            }
            expendParams.clear();
            if (!param.getExpandGroupAccs().isEmpty()) {
                expendParams.addAll(param.getExpandGroupAccs().values());
            } else {
                expendParams.add(param);
            }
            ctrlBudget = null;
            ctrlTransitBudget = null;
            ctrlActual = null;
            budgetDetail.clear();
            transitBudgetDetail.clear();
            actualDetail.clear();
            for (int e = 0; e < expendParams.size(); ++e) {
                expandParam = (BgControlParam)expendParams.get(e);
                budgetDetail.put(expandParam.getDimItemNumber(), BgNFSHelper.addBigDecimal((BigDecimal)((BigDecimal)budgetDetail.get(expandParam.getBgIndexNumber())), (BigDecimal)BgNFSHelper.calFlexParam((BigDecimal)expandParam.getBudgetValue(), (BigDecimal)expandParam.getControlSetting().getFlexParam())));
                transitBudgetDetail.put(expandParam.getDimItemNumber(), BgNFSHelper.addBigDecimal((BigDecimal)((BigDecimal)transitBudgetDetail.get(expandParam.getBgIndexNumber())), (BigDecimal)BgNFSHelper.calFlexParam((BigDecimal)expandParam.getTransitBudgetValue(), (BigDecimal)expandParam.getControlSetting().getFlexParam())));
                for (BgGroupData groupData : expandParam.getActualDetail().values()) {
                    if (param.isAddupCtrl() && (param.getAddupActualPeriod() == null || !param.checkIsInPeriodForAddCtrl(groupData.getBgPeriodNumber(), param.getAddupActualPeriod()))) continue;
                    actualDetail.put(groupData.getBgDimNumber(), BgNFSHelper.addBigDecimal((BigDecimal)((BigDecimal)actualDetail.get(groupData.getBgDimNumber())), (BigDecimal)groupData.getActualValue()));
                }
                if (expandParam.getBgGroupMap() == null || expandParam.getBgGroupMap().isEmpty()) continue;
                for (BOSUuid groupId : expandParam.getBgGroupMap().keySet()) {
                    List<BgGroupData> groupDatas = expandParam.getBgGroupMap().get(groupId);
                    for (BgGroupData groupData : groupDatas) {
                        if (param.isAddupCtrl()) {
                            if (param.getAddupActualPeriod() == null) {
                                throw new NullPointerException("param.getAddupActualPeriod is null");
                            }
                            if (!param.checkIsInPeriodForAddCtrl(groupData.getBgPeriodNumber(), param.getAddupActualPeriod())) continue;
                        }
                        budgetDetail.put(groupData.getBgDimNumber(), BgNFSHelper.addBigDecimal((BigDecimal)((BigDecimal)budgetDetail.get(groupData.getBgDimNumber())), (BigDecimal)BgNFSHelper.calFlexParam((BigDecimal)groupData.getBudgetValue(), (BigDecimal)groupData.getSetting().getFlexParam())));
                        transitBudgetDetail.put(groupData.getBgDimNumber(), BgNFSHelper.addBigDecimal((BigDecimal)((BigDecimal)transitBudgetDetail.get(groupData.getBgDimNumber())), (BigDecimal)BgNFSHelper.calFlexParam((BigDecimal)groupData.getTransitBudgetValue(), (BigDecimal)groupData.getSetting().getFlexParam())));
                        actualDetail.put(groupData.getBgDimNumber(), BgNFSHelper.addBigDecimal((BigDecimal)((BigDecimal)actualDetail.get(groupData.getBgDimNumber())), (BigDecimal)groupData.getActualValue()));
                    }
                }
            }
            dimNumbers.clear();
            dimNumberSet.clear();
            dimNumberSet.addAll(budgetDetail.keySet());
            dimNumberSet.addAll(transitBudgetDetail.keySet());
            dimNumberSet.addAll(actualDetail.keySet());
            dimNumbers.addAll(dimNumberSet);
            Collections.sort(dimNumbers);
            if (BgCtrlValueEnum.ControlActual.equals((Object)param.getExpandInfo().getBgCtrlValue())) {
                ctrlBudget = BizExpandUtils.getCtrlActual(expandParam.getExpandCtrlParam());
                this.addToFormula(budgetValue, ctrlBudget, precision);
            }
            for (String dimNumber : dimNumbers) {
                if (!BgCtrlValueEnum.ControlActual.equals((Object)param.getExpandInfo().getBgCtrlValue())) {
                    ctrlBudget = BgNFSHelper.addBigDecimal((BigDecimal)ctrlBudget, (BigDecimal)((BigDecimal)budgetDetail.get(dimNumber)));
                    ctrlTransitBudget = BgNFSHelper.addBigDecimal((BigDecimal)ctrlTransitBudget, (BigDecimal)((BigDecimal)transitBudgetDetail.get(dimNumber)));
                    this.addToFormula(budgetValue, (BigDecimal)budgetDetail.get(dimNumber), (BigDecimal)transitBudgetDetail.get(dimNumber), precision, loadTransitBudget);
                }
                ctrlActual = BgNFSHelper.addBigDecimal((BigDecimal)ctrlActual, (BigDecimal)((BigDecimal)actualDetail.get(dimNumber)));
                this.addToFormula(actualValue, (BigDecimal)actualDetail.get(dimNumber), precision);
            }
            this.finishFormula(budgetValue);
            this.finishFormula(actualValue);
            if (BgCtrlValueEnum.EXERATIO.equals((Object)param.getExpandInfo().getBgCtrlValue())) {
                executeValue = executeValue.multiply(param.getExpandInfo().getBgCtrlParam());
                param.getCalculateFormula()[1] = this.setPrecision(param.getExpandInfo().getBgCtrlParam(), 4);
                ctrlValue.append("*").append(this.setPrecision(param.getExpandInfo().getBgCtrlParam(), 4));
            } else if (BgCtrlValueEnum.ControlBudget.equals((Object)param.getExpandInfo().getBgCtrlValue())) {
                BgControlExpendRuleInfo.MatchInfo matchInfo = param.getExpandInfo().matchExecuteValue(executeValue);
                executeValue = matchInfo.getValue();
                param.getCalculateFormula()[1] = this.setPrecision(executeValue, 4);
                param.getCalculateFormula()[0] = matchInfo.getDisplayValue();
                ctrlValue.append(this.setPrecision(executeValue, 4));
            } else if (BgCtrlValueEnum.ControlActual.equals((Object)param.getExpandInfo().getBgCtrlValue())) {
                executeValue = param.getExpandInfo().getBgCtrlParam();
                param.getCalculateFormula()[1] = this.setPrecision(param.getExpandInfo().getBgCtrlParam(), 4);
                ctrlValue.append(this.setPrecision(param.getExpandInfo().getBgCtrlParam(), 4));
            }
            if (ctrlBudget != null || ctrlActual != null || ctrlTransitBudget != null) {
                if (ctrlBudget == null) {
                    ctrlBudget = BgNConstants.ZERO;
                }
                if (ctrlTransitBudget == null) {
                    ctrlTransitBudget = BgNConstants.ZERO;
                }
                if (ctrlActual == null) {
                    ctrlActual = BgNConstants.ZERO;
                }
                param.setExpandBalance(ctrlBudget.subtract(ctrlTransitBudget).multiply(executeValue).subtract(ctrlActual));
            }
            param.getCalculateFormula()[2] = ctrlValue + "*" + budgetValue + "-" + actualValue;
        }
    }

    private void dealCtrlValueFormula(BgControlParam param, StringBuffer ctrlValue, boolean loadTransitBudget) {
        if (param != null && param.getControlSetting().isIsGroupCtrl()) {
            StringBuffer ctrltmpActual = new StringBuffer();
            StringBuffer ctrltmpBudget = new StringBuffer();
            StringBuffer ctrltmpTransitBudget = new StringBuffer();
            BgControlSettingInfo controlSetting = param.getControlSetting();
            if (param.getActualValue() != null) {
                ctrltmpActual.append(param.getActualValue());
            }
            if (param.getBudgetValue() != null) {
                ctrltmpBudget.append(param.getBudgetValue().multiply(controlSetting.getFlexParam()));
            }
            if (param.getTransitBudgetValue() != null) {
                ctrltmpTransitBudget.append(param.getTransitBudgetValue().multiply(controlSetting.getFlexParam()));
            }
            BgGroupData bgGroupData = null;
            Map<BOSUuid, List<BgGroupData>> bgGroupMap = param.getBgGroupMap();
            for (BOSUuid next : bgGroupMap.keySet()) {
                BigDecimal tmpActual = BgNConstants.ZERO;
                BigDecimal tmpBudget = BgNConstants.ZERO;
                BigDecimal tmpTransitBudget = BgNConstants.ZERO;
                List<BgGroupData> list = bgGroupMap.get(next);
                for (int m = 0; m < list.size(); ++m) {
                    bgGroupData = list.get(m);
                    if (bgGroupData.getBgDimNumber().equals(param.getDimItemNumber()) || (controlSetting.getCtrlType().getValue() != 10 ? controlSetting.getCtrlType().getValue() == 11 && bgGroupData.getBgPeriodNumber().compareTo(param.getBgPeriodNumber()) > 0 : !bgGroupData.getBgPeriodNumber().equals(param.getBgPeriodNumber()))) continue;
                    if (bgGroupData.getBudgetValue() == null && bgGroupData.getActualValue() == null) continue;
                    if (bgGroupData.getActualValue() != null) {
                        tmpActual = tmpActual.add(bgGroupData.getActualValue());
                    }
                    if (bgGroupData.getBudgetValue() != null) {
                        tmpBudget = tmpBudget.add(bgGroupData.getBudgetValue().multiply(bgGroupData.getSetting().getFlexParam()));
                    }
                    if (bgGroupData.getTransitBudgetValue() == null) continue;
                    tmpTransitBudget = tmpTransitBudget.add(bgGroupData.getTransitBudgetValue().multiply(bgGroupData.getSetting().getFlexParam()));
                }
                if (tmpActual.compareTo(BgNConstants.ZERO) != 0) {
                    if (ctrltmpActual.length() != 0) {
                        ctrltmpActual.append("+");
                    }
                    ctrltmpActual.append(tmpActual);
                }
                if (tmpBudget.compareTo(BgNConstants.ZERO) != 0) {
                    if (ctrltmpBudget.length() != 0) {
                        ctrltmpBudget.append("+");
                    }
                    ctrltmpBudget.append(tmpBudget);
                }
                if (tmpTransitBudget.compareTo(BgNConstants.ZERO) == 0) continue;
                if (ctrltmpTransitBudget.length() != 0) {
                    ctrltmpTransitBudget.append("+");
                }
                ctrltmpTransitBudget.append(tmpTransitBudget);
            }
            if (loadTransitBudget) {
                ctrlValue.append("(").append(ctrltmpActual).append(")").append("/").append("(").append("(").append(ctrltmpBudget).append(")").append("-").append("(").append(ctrltmpTransitBudget).append(")").append(")");
            } else {
                ctrlValue.append("(").append(ctrltmpActual).append(")").append("/").append("(").append(ctrltmpBudget).append(")");
            }
        }
    }

    public static BigDecimal getCtrlBudget(BgControlParam expandParam) {
        BigDecimal flexParam = new BigDecimal(1);
        if (expandParam.getControlSetting() != null) {
            flexParam = expandParam.getControlSetting().getFlexParam();
        }
        BigDecimal ctrlBudget = BigDecimal.ZERO;
        BgControlSettingInfo setting = expandParam.getControlSetting();
        if (setting != null && setting.isIsGroupCtrl() && !StringUtils.isEmpty((String)setting.getGroupNo())) {
            if (expandParam.getExtBudget() != null) {
                ctrlBudget = expandParam.getExtBudget();
            }
        } else if (expandParam.getBudgetValue() != null) {
            ctrlBudget = expandParam.getBudgetValue().multiply(flexParam);
        }
        return ctrlBudget;
    }

    public static BigDecimal getCtrlTransitBudget(BgControlParam expandParam) {
        BigDecimal flexParam = new BigDecimal(1);
        if (expandParam.getControlSetting() != null) {
            flexParam = expandParam.getControlSetting().getFlexParam();
        }
        BigDecimal ctrlTransitBudget = BigDecimal.ZERO;
        BgControlSettingInfo setting = expandParam.getControlSetting();
        if (setting != null && setting.isIsGroupCtrl() && !StringUtils.isEmpty((String)setting.getGroupNo())) {
            if (expandParam.getExtTransitBudget() != null) {
                ctrlTransitBudget = expandParam.getExtTransitBudget();
            }
        } else if (expandParam.getTransitBudgetValue() != null) {
            ctrlTransitBudget = expandParam.getTransitBudgetValue().multiply(flexParam);
        }
        return ctrlTransitBudget;
    }

    public static BigDecimal getCtrlActual(BgControlParam expandParam) {
        BigDecimal ctrlActual = BigDecimal.ZERO;
        BgControlSettingInfo setting = expandParam.getControlSetting();
        if (setting != null && setting.isIsGroupCtrl() && !StringUtils.isEmpty((String)setting.getGroupNo())) {
            if (expandParam.getExtActual() != null) {
                ctrlActual = expandParam.getExtActual();
            }
        } else if (expandParam.getActualValue() != null) {
            ctrlActual = expandParam.getActualValue();
        }
        return ctrlActual;
    }

    private BigDecimal setPrecision(BigDecimal ctrlActual, int precision) {
        if (ctrlActual != null && ctrlActual.scale() > precision) {
            return ctrlActual.setScale(precision, RoundingMode.HALF_UP);
        }
        return ctrlActual;
    }

    private void finishFormula(StringBuffer budgetValue) {
        if (budgetValue.length() == 0) {
            budgetValue.append(BgNConstants.ZERO);
        } else {
            budgetValue.append(")");
        }
    }

    private void addToFormula(StringBuffer budgetValue, BigDecimal ctrlBudget, int precision) {
        this.addToFormula(budgetValue, ctrlBudget, BgNConstants.ZERO, precision, false);
    }

    private void addToFormula(StringBuffer budgetValue, BigDecimal ctrlBudget, BigDecimal ctrlTransitBudget, int precision, boolean isLoadTransitBudget) {
        if (ctrlBudget != null && ctrlBudget.compareTo(BgNConstants.ZERO) != 0) {
            ctrlBudget = this.setPrecision(ctrlBudget, precision);
            if (budgetValue.length() == 0) {
                budgetValue.append("(");
            } else if (ctrlBudget.compareTo(BgNConstants.ZERO) >= 0) {
                budgetValue.append("+");
            }
            budgetValue.append(ctrlBudget);
            if (ctrlTransitBudget.compareTo(BgNConstants.ZERO) >= 0 && isLoadTransitBudget) {
                budgetValue.append("-").append(ctrlTransitBudget);
            }
        }
    }

    public void checkExpandGroup(Context ctx, Connection conn, IControlParameter parameter, List<BgControlParam> params) throws BOSException, EASBizException {
        if (params == null || params.isEmpty()) {
            return;
        }
        BgControlParam param = null;
        String controlSetKey = null;
        for (int i = 0; i < params.size(); ++i) {
            param = params.get(i);
            if (param.isOnlyExpandControl() || param.getExpandInfo() == null) continue;
            if (param.getExpandInfo().isIsGroup() && param.getControlSetting().isIsGroupCtrl()) {
                throw new BgControlException(BgControlException.SHOWMESSAGE, new Object[]{ResourceBase.getString((String)BgControlConstants.CONTROL_RES, (String)"checkExpandNoGroup", (Locale)ctx.getLocale(), (Object[])new Object[]{this.getExpandIndexName(ctx, conn, param)})});
            }
            if (param.getExpandGroupAccs() == null || param.getExpandGroupAccs().isEmpty()) continue;
            controlSetKey = CalcBalance.getControlSetKey(param.getControlSetting());
            for (BgControlParam expandParam : param.getExpandGroupAccs().values()) {
                if (expandParam.getControlSetting().isIsGroupCtrl()) {
                    throw new BgControlException(BgControlException.SHOWMESSAGE, new Object[]{ResourceBase.getString((String)BgControlConstants.CONTROL_RES, (String)"checkExpandGroupNo", (Locale)ctx.getLocale(), (Object[])new Object[]{this.getExpandIndexName(ctx, conn, param), this.getExpandIndexName(ctx, conn, expandParam)})});
                }
                if (controlSetKey.equals(CalcBalance.getControlSetKey(expandParam.getControlSetting()))) continue;
                throw new BgControlException(BgControlException.SHOWMESSAGE, new Object[]{ResourceBase.getString((String)BgControlConstants.CONTROL_RES, (String)"checkExpandGroupSet", (Locale)ctx.getLocale(), (Object[])new Object[]{this.getExpandIndexName(ctx, conn, param), this.getExpandIndexName(ctx, conn, expandParam)})});
            }
        }
    }

    private String getExpandIndexName(Context ctx, Connection conn, BgControlParam param) {
        return param.getExpandInfo().getBgReqAccNum() + "(" + param.getExpandInfo().getBgReqAccName() + ")";
    }
}

