/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.utils;

import com.kingdee.eas.ma.control.BgControlItemMapCollection;
import com.kingdee.eas.ma.control.BgControlItemMapEntryCollection;
import com.kingdee.eas.ma.control.BgControlItemMapEntryInfo;
import com.kingdee.eas.ma.control.BgControlItemMapInfo;
import com.kingdee.eas.ma.control.BgControlSchemeInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BizItemMapUtils {
    private BgControlSchemeInfo controlScheme = null;
    private Map<String, Map<String, List<String[]>>> bizItemMap = new HashMap<String, Map<String, List<String[]>>>();
    private Map<String, Map<String, List<String[]>>> matchMap = new HashMap<String, Map<String, List<String[]>>>();
    private Map<String, Map<String, String[]>> bizItemsMap = new HashMap<String, Map<String, String[]>>();
    private Map<String, Map<String, String[]>> bizMatchMap = new HashMap<String, Map<String, String[]>>();

    public void setControlScheme(BgControlSchemeInfo controlScheme) {
        this.controlScheme = controlScheme;
    }

    public BgControlSchemeInfo getControlScheme() {
        return this.controlScheme;
    }

    public Map<String, Map<String, List<String[]>>> getBizItemMap() {
        return this.bizItemMap;
    }

    public Map<String, Map<String, List<String[]>>> getMatchMap() {
        return this.matchMap;
    }

    public BizItemMapUtils(BgControlSchemeInfo controlScheme) {
        this.setControlScheme(controlScheme);
        this.initData();
    }

    private void initData() {
        if (this.getControlScheme() == null || this.getControlScheme().getItemMaps() == null) {
            return;
        }
        BgControlItemMapInfo _bizMap = null;
        BgControlItemMapCollection _bizMaps = null;
        BgControlItemMapEntryInfo _bizData = null;
        BgControlItemMapEntryCollection _bizDatas = null;
        Map<Object, Object> _tmpBizDataMap = null;
        Map<Object, Object> _tmpMatDataMap = null;
        ArrayList<String[]> bizNumList = new ArrayList<String[]>();
        ArrayList<String[]> bizNumMat = new ArrayList<String[]>();
        ArrayList<String[]> mbgNumList = new ArrayList<String[]>();
        ArrayList<String[]> mbgNumMat = new ArrayList<String[]>();
        ArrayList<String[]> mbgAliList = new ArrayList<String[]>();
        ArrayList<String[]> mbgAliMat = new ArrayList<String[]>();
        String[] bizNums = null;
        String[] mbgNums = null;
        String[] mbgAlias = null;
        String[] itemObj = null;
        _bizMaps = this.getControlScheme().getItemMaps();
        if (_bizMaps == null) {
            return;
        }
        int in = _bizMaps.size();
        for (int i = 0; i < in; ++i) {
            int k;
            int x;
            int xn;
            _bizMap = _bizMaps.get(i);
            if (this.getBizItemMap().containsKey(_bizMap.getBizPropKey())) {
                _tmpBizDataMap = this.getBizItemMap().get(_bizMap.getBizPropKey());
            } else {
                _tmpBizDataMap = new HashMap();
                this.getBizItemMap().put(_bizMap.getBizPropKey(), _tmpBizDataMap);
            }
            if (this.getMatchMap().containsKey(_bizMap.getBizPropKey())) {
                _tmpMatDataMap = this.getMatchMap().get(_bizMap.getBizPropKey());
            } else {
                _tmpMatDataMap = new HashMap();
                this.getMatchMap().put(_bizMap.getBizPropKey(), _tmpMatDataMap);
            }
            bizNumList.clear();
            mbgNumList.clear();
            mbgAliList.clear();
            bizNumMat.clear();
            mbgNumMat.clear();
            mbgAliMat.clear();
            _bizDatas = _bizMap.getEntry();
            int jn = _bizDatas.size();
            for (int j = 0; j < jn; ++j) {
                _bizData = _bizDatas.get(j);
                bizNums = _bizData.getBizItemValue().split("\\|");
                mbgNums = _bizData.getMbgItemValue().split("\\|");
                mbgAlias = _bizData.getMbgItemAlias().split("\\|");
                if (_bizData.isMatching()) {
                    bizNumMat.add(bizNums);
                    mbgNumMat.add(mbgNums);
                    mbgAliMat.add(mbgAlias);
                    continue;
                }
                bizNumList.add(bizNums);
                mbgNumList.add(mbgNums);
                mbgAliList.add(mbgAlias);
            }
            StringBuffer bizKey = null;
            StringBuffer matKey = null;
            ArrayList<String[]> bizList = null;
            ArrayList<String[]> matList = null;
            if (!bizNumList.isEmpty()) {
                xn = bizNumList.size();
                for (x = 0; x < xn; ++x) {
                    bizKey = new StringBuffer();
                    bizList = new ArrayList<String[]>();
                    bizNums = (String[])bizNumList.get(x);
                    mbgNums = (String[])mbgNumList.get(x);
                    mbgAlias = (String[])mbgAliList.get(x);
                    for (k = 0; k < bizNums.length; ++k) {
                        if (k == bizNums.length - 1) {
                            bizKey.append(bizNums[k]);
                            continue;
                        }
                        bizKey.append(bizNums[k]).append("|");
                    }
                    for (k = 0; k < mbgNums.length; ++k) {
                        itemObj = new String[]{mbgNums[k], mbgAlias[k]};
                        bizList.add(itemObj);
                    }
                    _tmpBizDataMap.put(bizKey.toString(), bizList);
                }
            }
            if (!bizNumMat.isEmpty()) {
                xn = bizNumMat.size();
                for (x = 0; x < xn; ++x) {
                    matKey = new StringBuffer();
                    matList = new ArrayList<String[]>();
                    bizNums = (String[])bizNumMat.get(x);
                    mbgNums = (String[])mbgNumMat.get(x);
                    mbgAlias = (String[])mbgAliMat.get(x);
                    for (k = 0; k < bizNums.length; ++k) {
                        if (k == bizNums.length - 1) {
                            matKey.append(bizNums[k]);
                            continue;
                        }
                        matKey.append(bizNums[k]).append("|");
                    }
                    for (k = 0; k < mbgNums.length; ++k) {
                        itemObj = new String[]{mbgNums[k], mbgAlias[k]};
                        matList.add(itemObj);
                    }
                    _tmpMatDataMap.put(matKey.toString(), matList);
                }
            }
            if (_tmpBizDataMap.isEmpty()) {
                this.getBizItemMap().remove(_bizMap.getBizPropKey());
            }
            if (!_tmpMatDataMap.isEmpty()) continue;
            this.getMatchMap().remove(_bizMap.getBizPropKey());
        }
    }

    public String[] matching(String ruleProp, String bizProp, int dimensionGroup, String bizNumber, int index) {
        if (StringUtils.isEmpty((String)ruleProp) || StringUtils.isEmpty((String)bizProp) || StringUtils.isEmpty((String)bizNumber)) {
            return null;
        }
        String[] _mbgItem = this.exactMatch(ruleProp, bizProp, dimensionGroup, bizNumber, index);
        if (_mbgItem == null) {
            _mbgItem = this.fuzzyMatch(ruleProp, bizProp, dimensionGroup, bizNumber, index);
        }
        return _mbgItem;
    }

    private String[] exactMatch(String ruleProp, String bizProp, int dimensionGroup, String bizNumber, int index) {
        if (ruleProp == null || bizProp == null || bizNumber == null) {
            return null;
        }
        String[] _mbgItem = null;
        String bizPropKey = BgControlItemMapInfo.getBizPropKey(ruleProp, dimensionGroup);
        if (this.getBizItemMap().containsKey(bizPropKey)) {
            List<String[]> _tmpBizList;
            Map<String, List<String[]>> _tmpBizMap = this.getBizItemMap().get(bizPropKey);
            if (_tmpBizMap != null) {
                bizProp = this.buildNewKey(_tmpBizMap, bizProp);
            }
            if (_tmpBizMap != null && _tmpBizMap.containsKey(bizProp) && (_tmpBizList = _tmpBizMap.get(bizProp)) != null) {
                boolean isMatch = false;
                String[] _tmpVal = bizProp.split("\\|");
                if (_tmpVal != null && _tmpVal.length >= index && bizNumber.equals(_tmpVal[index])) {
                    isMatch = true;
                }
                if (isMatch && _tmpBizList.size() > index) {
                    _mbgItem = _tmpBizList.get(index);
                }
            }
        }
        return _mbgItem;
    }

    private String[] fuzzyMatch(String ruleProp, String bizProp, int dimensionGroup, String bizNumber, int index) {
        Map<String, List<String[]>> _tmpBizMap;
        if (ruleProp == null || bizProp == null || bizNumber == null) {
            return null;
        }
        String[] _mbgItem = null;
        String tmpMatValue = null;
        String k = " ";
        ArrayList<String> bizKeyList = new ArrayList<String>();
        String bizPropKey = BgControlItemMapInfo.getBizPropKey(ruleProp, dimensionGroup);
        if (this.getMatchMap().containsKey(bizPropKey) && (_tmpBizMap = this.getMatchMap().get(bizPropKey)) != null) {
            bizProp = this.buildNewKey(_tmpBizMap, bizProp);
            Map.Entry<String, List<String[]>> entry2 = null;
            for (Map.Entry<String, List<String[]>> entry2 : _tmpBizMap.entrySet()) {
                String key = entry2.getKey();
                String[] _tmpVal = bizProp.split("\\|");
                String[] _matVal = key.split("\\|");
                List<String[]> _tmpBizList = null;
                if (_tmpVal.length != _matVal.length) continue;
                boolean isMat = true;
                for (int i = 0; i < _tmpVal.length; ++i) {
                    tmpMatValue = _matVal[i].endsWith("%") ? _matVal[i].substring(0, _matVal[i].length() - 1) : _matVal[i];
                    if (!_tmpVal[i].startsWith(tmpMatValue) && !tmpMatValue.equals(k)) {
                        bizKeyList.add(_tmpVal[i]);
                    }
                    if (_tmpVal[i].startsWith(_matVal[i].substring(0, _matVal[i].length() - 1))) continue;
                    isMat = false;
                }
                if (!bizKeyList.isEmpty()) {
                    bizKeyList.clear();
                    continue;
                }
                if (!isMat) continue;
                _tmpBizList = entry2.getValue();
                if (_matVal.length <= index) continue;
                if (_matVal[index].endsWith("%")) {
                    String tmpStr = _matVal[index].substring(0, _matVal[index].length() - 1);
                    if (StringUtils.isEmpty((String)tmpStr) || !bizNumber.startsWith(tmpStr)) continue;
                    _mbgItem = _tmpBizList.get(index);
                    continue;
                }
                String tmpStr = _matVal[index];
                if (StringUtils.isEmpty((String)tmpStr) || !bizNumber.equals(tmpStr)) continue;
                _mbgItem = _tmpBizList.get(index);
            }
        }
        return _mbgItem;
    }

    private String buildNewKey(Map<String, List<String[]>> _tmpBizMap, String bizProp) {
        ArrayList<Integer> nullList = new ArrayList<Integer>();
        Iterator<String> it = _tmpBizMap.keySet().iterator();
        int bizRuleKeyLen = 0;
        if (_tmpBizMap.containsKey(bizProp)) {
            return bizProp;
        }
        block0: while (it.hasNext()) {
            int i;
            String[] strs;
            int bizPropLen;
            nullList.clear();
            String key = it.next();
            String[] keyStrs = key.split("\\|");
            bizRuleKeyLen = keyStrs.length;
            for (int i2 = 0; i2 < keyStrs.length; ++i2) {
                if (!StringUtils.isEmpty((String)keyStrs[i2])) continue;
                nullList.add(i2);
            }
            if (nullList.isEmpty() || (bizPropLen = (strs = bizProp.split("\\|")).length) != bizRuleKeyLen) continue;
            for (i = 0; i < strs.length; ++i) {
                if (!StringUtils.isEmpty((String)keyStrs[i]) && !keyStrs[i].equals(strs[i])) continue block0;
            }
            for (i = 0; i < nullList.size(); ++i) {
                int nullVal = (Integer)nullList.get(i);
                strs[nullVal] = " ";
            }
            StringBuffer sb = new StringBuffer();
            for (int k = 0; k < strs.length; ++k) {
                if (k == strs.length - 1) {
                    sb.append(strs[k]);
                    continue;
                }
                sb.append(strs[k]).append("|");
            }
            return sb.toString();
        }
        return bizProp;
    }
}

