/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlRuleInfo;
import com.kingdee.eas.ma.control.BgControlSchemeInfo;
import com.kingdee.eas.ma.control.face.IControlParameter;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.ma.control.utils.BgControlParamUtils;
import com.kingdee.eas.ma.control.utils.BgControlUtils;
import com.kingdee.eas.ma.control.utils.ObjectValueToMap;
import com.kingdee.eas.ma.mbg.dimension.utils.MetaUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BizUnitCheckUtils {
    private static Logger logger = Logger.getLogger(BizUnitCheckUtils.class);

    public static BizUnitCheckUtils getInterace() {
        return new BizUnitCheckUtils();
    }

    public void checkBizUnitInfo(Context ctx, BOSUuid billId, BgControlSchemeInfo controlScheme, IControlParameter parameter, String extCheckClassName) throws BOSException, EASBizException {
        if (ctx == null || billId == null || controlScheme == null || parameter == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        EntityObjectInfo entity = MetaUtils.getEntity((Context)ctx, (BOSObjectType)billId.getType());
        Map<String, String> props = this.getBizUnitProps(ctx, entity, controlScheme);
        IObjectValue model = this.queryBizUnitInfo(ctx, billId.toString(), props);
        this.checkBizUnitInfo(ctx, controlScheme, model, true);
        this.extCheckBizUnitInfo(ctx, extCheckClassName, model, props);
    }

    public void checkBizUnitInfo(Context ctx, IObjectValue model, BgControlSchemeInfo controlScheme, IControlParameter parameter, String extCheckClassName) throws BOSException, EASBizException {
        if (ctx == null || model == null || controlScheme == null || parameter == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        EntityObjectInfo entity = MetaUtils.getEntity((Context)ctx, (BOSObjectType)model.getBOSType());
        Map<String, String> props = this.getBizUnitProps(ctx, entity, controlScheme);
        this.checkBizUnitInfo(ctx, controlScheme, model, false);
        this.extCheckBizUnitInfo(ctx, extCheckClassName, model, props);
    }

    public Map<String, String> getBizUnitProps(Context ctx, EntityObjectInfo entity, BgControlSchemeInfo controlScheme) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (ctx == null || entity == null || controlScheme == null) {
            return props;
        }
        String[] tmpStrs = null;
        String[] tmpAlias = null;
        BgControlRuleInfo rule = null;
        int in = controlScheme.getRule().size();
        for (int i = 0; i < in; ++i) {
            rule = controlScheme.getRule().get(i);
            props.put(rule.getOrgUnit(), rule.getOrgUnitAlias());
            String[] dims = rule.getDimItem().split("\\@");
            String[] dimAlias = rule.getDimItemAlias().split("\\@");
            int jn = dims.length;
            for (int j = 0; j < jn; ++j) {
                tmpStrs = dims[j].split("\\|");
                tmpAlias = dimAlias[j].split("\\|");
                props.put(tmpStrs[0], tmpAlias[0]);
                String fieldName = BgControlUtils.getFieldName(tmpStrs[0]);
                props.put(fieldName, tmpAlias[0]);
            }
            props.put(rule.getCurrency(), rule.getCurrencyAlias());
            props.put(rule.getBizDate(), rule.getBizDateAlias());
            props.put(rule.getRequestAmount(), rule.getRequestAmountAlias());
            if (StringUtils.isEmpty((String)rule.getRuleCondition())) continue;
            try {
                FilterInfo filter = new FilterInfo(rule.getRuleCondition());
                int jn2 = filter.getFilterItems().size();
                for (int j = 0; j < jn2; ++j) {
                    FilterItemInfo item = filter.getFilterItems().get(j);
                    String prop = item.getPropertyName();
                    String propAlias = MetaUtils.getPropertyAlias((EntityObjectInfo)entity, (String)prop);
                    props.put(prop, propAlias);
                }
                continue;
            }
            catch (ParserException parserException) {
                // empty catch block
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectValue queryBizUnitInfo(Context ctx, String billId, Map<String, String> props) throws BOSException {
        if (ctx == null || StringUtils.isEmpty((String)billId) || props == null || props.isEmpty()) {
            return null;
        }
        IObjectValue value = null;
        Connection conn = null;
        ObjectStringPK pk = new ObjectStringPK(billId);
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)BOSUuid.getBOSObjectType((String)billId, (boolean)false), (Context)ctx, (Connection)conn);
            if (dao.exists((IObjectPK)pk)) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(BgControlConstants.PROP_ID);
                sic.add(BgControlConstants.PROP_NUMBER);
                Iterator<String> iter = props.keySet().iterator();
                while (iter.hasNext()) {
                    sic.add(iter.next());
                }
                value = dao.getValue((IObjectPK)pk, sic);
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return value;
    }

    private void checkBizUnitInfo(Context ctx, BgControlSchemeInfo controlScheme, IObjectValue model, boolean checkBaseProps) throws EASBizException {
        if (controlScheme == null || model == null) {
            return;
        }
        IObjectValue filter = null;
        BgControlRuleInfo rule = null;
        String proptxt = null;
        String[] tmpStrs = null;
        String[] tmpAlias = null;
        Vector<String> props = new Vector<String>();
        Vector<String> propAlias = new Vector<String>();
        HashSet<String> checkProps = new HashSet<String>();
        ArrayList checkPropAlias = new ArrayList();
        int in = controlScheme.getRule().size();
        for (int i = 0; i < in; ++i) {
            rule = controlScheme.getRule().get(i);
            if (!StringUtils.isEmpty((String)rule.getRuleCondition())) {
                try {
                    EntityViewInfo fi = new EntityViewInfo("where " + rule.getRuleCondition());
                    for (int f = 0; f < fi.getFilter().getFilterItems().size(); ++f) {
                        Object date = fi.getFilter().getFilterItems().get(f).getCompareValue();
                        if (!(date instanceof Date) || date.getClass().equals(Date.class)) continue;
                        fi.getFilter().getFilterItems().get(f).setCompareValue((Object)new Date(((Date)date).getTime()));
                    }
                    filter = BgControlParamUtils.filteObjectValue(model, fi.getFilter(), true);
                }
                catch (Exception ex) {
                    if (ex instanceof BgControlException) {
                        throw (BgControlException)((Object)ex);
                    }
                    logger.error((Object)"filter ObjectValue Error:", (Throwable)ex);
                }
            } else {
                filter = model;
            }
            if (filter == null) continue;
            props.clear();
            propAlias.clear();
            if (checkBaseProps) {
                props.add(BgControlConstants.PROP_ID);
                props.add(BgControlConstants.PROP_NUMBER);
            }
            propAlias.addAll(props);
            props.add(rule.getOrgUnit());
            propAlias.add(rule.getOrgUnitAlias());
            String[] dims = rule.getDimItem().split("\\@");
            String[] dimAlias = rule.getDimItemAlias().split("\\@");
            int jn = dims.length;
            for (int j = 0; j < jn; ++j) {
                tmpStrs = dims[j].split("\\|");
                tmpAlias = dimAlias[j].split("\\|");
                props.add(tmpStrs[0]);
                propAlias.add(tmpAlias[0]);
            }
            props.add(rule.getCurrency());
            propAlias.add(rule.getCurrencyAlias());
            props.add(rule.getBizDate());
            propAlias.add(rule.getBizDateAlias());
            props.add(rule.getRequestAmount());
            propAlias.add(rule.getRequestAmountAlias());
            List values = new ObjectValueToMap().execute(filter, props.toArray(new String[props.size()]));
            if (values == null) continue;
            Map valueMap = null;
            int jn2 = values.size();
            for (int j = 0; j < jn2; ++j) {
                valueMap = (Map)values.get(j);
                if (valueMap == null) continue;
                int xn = props.size();
                for (int x = 0; x < xn; ++x) {
                    proptxt = (String)props.get(x);
                    if (valueMap.get(proptxt) != null || checkProps.contains(proptxt)) continue;
                    checkProps.add(proptxt);
                    checkPropAlias.add(propAlias.get(x));
                }
            }
        }
        if (!checkPropAlias.isEmpty()) {
            StringBuffer str = new StringBuffer();
            int in2 = checkPropAlias.size();
            for (int i = 0; i < in2; ++i) {
                str.append((String)checkPropAlias.get(i) + ",");
            }
            str = str.delete(str.length() - 1, str.length());
            String msg = str.toString();
            throw new BgControlException(BgControlException.MUSTINPUT, new String[]{msg, msg});
        }
    }

    public void checkBizUnitInfo(BgControlRuleInfo rule, Map<String, Object> values, boolean checkBaseProps) throws EASBizException {
        if (rule == null || values == null || values.isEmpty()) {
            return;
        }
        String proptxt = null;
        String[] _tmpStrs = null;
        String[] tmpAlias = null;
        Vector<String> props = new Vector<String>();
        Vector<String> propAlias = new Vector<String>();
        HashSet<String> checkProps = new HashSet<String>();
        ArrayList checkPropAlias = new ArrayList();
        props.clear();
        propAlias.clear();
        if (checkBaseProps) {
            props.add(BgControlConstants.PROP_ID);
            props.add(BgControlConstants.PROP_NUMBER);
        }
        propAlias.addAll(props);
        props.add(rule.getOrgUnit());
        propAlias.add(rule.getOrgUnitAlias());
        String[] dims = rule.getDimItem().split("\\@");
        String[] dimAlias = rule.getDimItemAlias().split("\\@");
        int jn = dims.length;
        for (int j = 0; j < jn; ++j) {
            _tmpStrs = dims[j].split("\\|");
            tmpAlias = dimAlias[j].split("\\|");
            String dimItemStr = _tmpStrs[0];
            if (dimItemStr.indexOf("entries.assistRecords.assGrp.generalAssActType") != -1 && dimItemStr.indexOf("entries.assistRecords.assGrp.generalAssActType") != -1) {
                dimItemStr = dimItemStr.replaceAll(".number", ".longNumber");
            }
            props.add(dimItemStr);
            propAlias.add(tmpAlias[0]);
        }
        props.add(rule.getCurrency());
        propAlias.add(rule.getCurrencyAlias());
        props.add(rule.getBizDate());
        propAlias.add(rule.getBizDateAlias());
        props.add(rule.getRequestAmount());
        propAlias.add(rule.getRequestAmountAlias());
        int xn = props.size();
        for (int x = 0; x < xn; ++x) {
            proptxt = (String)props.get(x);
            if (values.get(proptxt) != null || checkProps.contains(proptxt)) continue;
            checkProps.add(proptxt);
            checkPropAlias.add(propAlias.get(x));
        }
        if (!checkPropAlias.isEmpty()) {
            StringBuffer str = new StringBuffer();
            int in = checkPropAlias.size();
            for (int i = 0; i < in; ++i) {
                str.append((String)checkPropAlias.get(i) + ",");
            }
            str = str.delete(str.length() - 1, str.length());
            String msg = str.toString();
            throw new BgControlException(BgControlException.MUSTINPUT, new String[]{msg, msg});
        }
    }

    private void extCheckBizUnitInfo(Context ctx, String extCheckClassName, IObjectValue model, Map<String, String> props) throws EASBizException {
        if (!StringUtils.isEmpty((String)extCheckClassName)) {
            Class<?> _class = null;
            Object _obj = null;
            Method _method = null;
            try {
                _class = Class.forName(extCheckClassName);
                _obj = _class.newInstance();
                _method = _class.getMethod("check", Context.class, IObjectValue.class, Map.class);
                if (_method != null) {
                    _method.invoke(_obj, ctx, model, props);
                }
            }
            catch (ClassNotFoundException ex) {
                logger.error((Object)"extCheckBizUnitInfo Error:", (Throwable)ex);
            }
            catch (InstantiationException ex) {
                logger.error((Object)"extCheckBizUnitInfo Error:", (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                logger.error((Object)"extCheckBizUnitInfo Error:", (Throwable)ex);
            }
            catch (NoSuchMethodException ex) {
                logger.error((Object)"extCheckBizUnitInfo Error:", (Throwable)ex);
            }
            catch (SecurityException ex) {
                logger.error((Object)"extCheckBizUnitInfo Error:", (Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                logger.error((Object)"extCheckBizUnitInfo Error:", (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                logger.error((Object)"extCheckBizUnitInfo Error:", (Throwable)ex);
            }
        }
    }
}

