/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.crbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgFillHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.CalendarHelper;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisFilterParam;
import com.kingdee.eas.ma.crbg.BgFundCompareAndAnalysisObj;
import com.kingdee.eas.ma.crbg.app.AbstractBgFundCompareAndAnalysisFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class BgFundCompareAndAnalysisFacadeControllerBean
extends AbstractBgFundCompareAndAnalysisFacadeControllerBean {
    private static final long serialVersionUID = -2856667638874101325L;

    private List getAllFormulaByBgFormID(Context ctx, String bgFormID) throws BOSException {
        String sql = "select fformula from t_bg_bgdata where FBgFormId = '" + bgFormID + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashSet<String> filter = new HashSet<String>(rs.size());
        try {
            while (rs.next()) {
                String formula = rs.getString("fformula");
                String[] formulaParamArray = BgFillHelper.parseStrFormulaToArray((String)formula);
                filter.add(formulaParamArray[0]);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        ArrayList list = new ArrayList(filter);
        return list;
    }

    @Override
    protected Map _getData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException {
        String bgFormID = filterParam.getBgFormID();
        List projectList = this.getAllFormulaByBgFormID(ctx, bgFormID);
        BgPeriodInfo beginPeriod = filterParam.getBeginPeriod();
        Date beginDate = beginPeriod.getBeginDate();
        BgPeriodInfo endPeriod = filterParam.getEndPeriod();
        Date endDate = endPeriod.getEndDate();
        CostCenterOrgUnitInfo[] lazyLoadDataOrgUnitInfoAry = filterParam.getLazyLoadDataCostCenterOrgUnitInfoAry();
        String[] sqlForOrgUnit = this.getOrgUnitSql(lazyLoadDataOrgUnitInfoAry);
        HashMap map = new HashMap();
        int num = projectList.size();
        for (int i = 0; i < num; ++i) {
            String strItemCombi = (String)projectList.get(i);
            this.getPayedAmt(ctx, beginDate, endDate, strItemCombi, sqlForOrgUnit, map);
        }
        return map;
    }

    private String[] getOrgUnitSql(CostCenterOrgUnitInfo[] ary) {
        int size = ary.length;
        String[] rtnAry = new String[size];
        for (int i = 0; i < size; ++i) {
            rtnAry[i] = ary[i].getId().toString();
        }
        return rtnAry;
    }

    private Map getPayedAmt(Context ctx, Date startTime, Date endTime, String project, String[] orgSql, Map map) throws BOSException {
        String number = null;
        String pjNum = null;
        if (project.indexOf(",") != -1) {
            number = project.substring(project.indexOf(",") + 1);
            pjNum = project.substring(0, project.indexOf(","));
        } else {
            pjNum = project;
        }
        for (String orgUnitID : orgSql) {
            String sql = "select sum(b.FCurApplyAmt) sumAmt FROM T_CR_BgUsefund a  inner join T_CR_BgUsefundEntry b  on a.FID = b.FParentID  left outer join T_CR_BgContract c ON b.FContNumID = c.FID  where a.FBillState = 15 and a.FApplyTime >= TO_DATE('" + this.getSqlDate(startTime) + "') and a.FApplyTime <= TO_DATE('" + this.getSqlDate(endTime) + "')  and a.forgUnitID = '" + orgUnitID + "'";
            sql = number != null && pjNum != null ? sql + " and b.FPjNum  in ('" + pjNum + "','" + number + "')   and c.Fnumber  in ('" + pjNum + "','" + number + "')" : sql + " and b.FPjNum  = '" + pjNum + "'";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (!rs.next()) continue;
                BigDecimal val = rs.getBigDecimal("sumAmt");
                if (map.keySet().contains(project)) {
                    BgFundCompareAndAnalysisObj info = (BgFundCompareAndAnalysisObj)map.get(project);
                    info.addActualFund(orgUnitID, val);
                    continue;
                }
                map.put(project, new BgFundCompareAndAnalysisObj(orgUnitID, val, new HashMap()));
            }
            catch (SQLException e) {
                throw new BOSException(e.toString());
            }
        }
        return map;
    }

    public String getSqlDate(Date time) {
        CalendarHelper Helper = new CalendarHelper();
        Date a = Helper.getStartDate(time);
        String b = a.getYear() + 1900 + "-" + (a.getMonth() + 1) + "-" + a.getDate();
        Object ps = null;
        return b;
    }

    @Override
    protected Map _getBaseData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException {
        BgPeriodInfo beginInfo = filterParam.getBeginPeriod();
        BgPeriodInfo endInfo = filterParam.getEndPeriod();
        BgPeriodCollection bgPC = null;
        try {
            bgPC = BgPeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(beginInfo.getId(), endInfo.getId());
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        String periodIdSql = this.constructPeriodSql(bgPC);
        String sql = this.sqlFactoryForGetData(ctx, filterParam);
        sql = sql + " and fbgperiodid in " + periodIdSql;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap map = new HashMap();
        try {
            while (rs.next()) {
                BigDecimal pastVal = rs.getBigDecimal("sumPastVal");
                String formula = rs.getString("fformula");
                BigDecimal budget = rs.getBigDecimal("fbgvalue");
                BigDecimal actual = rs.getBigDecimal("sumActualVal");
                String orgUnitId = rs.getString("forgunitid");
                String[] formulaParamArray = BgFillHelper.parseStrFormulaToArray((String)formula);
                formula = this.rebuildFormula(formulaParamArray);
                if (!map.keySet().contains(formula)) continue;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }

    private String getBgTemplateRootIdByBgFormId(Context ctx, String bgFormId) throws BOSException, SQLException {
        String sql = "select frootid from t_bg_bgtemplate where fid in (select fbgtemplateid from t_bg_bgform where fid = '" + bgFormId + "')";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String frootid = "";
        while (rs.next()) {
            frootid = rs.getString("frootid");
        }
        return frootid;
    }

    private String constructOrgUnitSql(CostCenterOrgUnitInfo[] orgAry) {
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        int num = orgAry.length;
        for (int i = 0; i < num; ++i) {
            String tempOrgId = orgAry[i].getId().toString();
            sb.append(tempOrgId);
            if (i == num - 1) break;
            sb.append("','");
        }
        sb.append("')");
        return sb.toString();
    }

    private String getBgTemplateIdByOrgIdsAndTemplateId(Context ctx, String bgFormId, CostCenterOrgUnitInfo[] orgAry) throws BOSException, SQLException {
        String sql = "select fid from t_bg_bgtemplate where frootid = '" + this.getBgTemplateRootIdByBgFormId(ctx, bgFormId) + "' and forgunitid in " + this.constructOrgUnitSql(orgAry) + "";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        int index = 0;
        int size = rs.size();
        String[] array = new String[size];
        while (rs.next()) {
            array[index++] = rs.getString("fid");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        for (int i = 0; i < size; ++i) {
            sb.append(array[i]);
            if (i == size - 1) break;
            sb.append("','");
        }
        sb.append("')");
        return sb.toString();
    }

    private String sqlFactoryForGetData(Context ctx, NewBgCompareAndAnalysisFilterParam filterParam) throws BOSException {
        String bgFormId = filterParam.getBgFormID();
        String bgSchemeId = filterParam.getBgSchemeInfo().getId().toString();
        CostCenterOrgUnitInfo[] orgUnitInfoAry = filterParam.getCostCenterOrgUnitInfoAry();
        CostCenterOrgUnitInfo[] lazyLoadDataOrgUnitInfoAry = filterParam.getLazyLoadDataCostCenterOrgUnitInfoAry();
        String currencyId = filterParam.getCurrencyInfo().getId().toString();
        String templateIdSql = "";
        try {
            templateIdSql = this.getBgTemplateIdByOrgIdsAndTemplateId(ctx, bgFormId, orgUnitInfoAry);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String schemeIdSql = "";
        try {
            schemeIdSql = this.getAllBgSchemeIdsSql(ctx, bgSchemeId, orgUnitInfoAry);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String sql = "select fid ,fbgvalue ,forgunitid, fformula ,sumActualVal , sumPastVal from T_BG_bgdata " + this.getSumActualValSql() + this.getSumPastValSql() + " where fbgtemplateid in " + templateIdSql + " and fbgschemeid in " + schemeIdSql + " and forgunitid in " + this.constructOrgUnitSql(lazyLoadDataOrgUnitInfoAry) + " and fcurrencyid ='" + currencyId + "'";
        return sql;
    }

    private String getSumActualValSql() {
        String sql = "a left join (select fbgdataid ,  sum(factualamount) sumActualVal from t_bg_bgctrlrecord where fbillid not like '%9mVmo=' and fbillid not like '%OqYyU=' group by fbgdataid) b on a.fid = b.fbgdataid";
        return sql;
    }

    private String getSumPastValSql() {
        String sql = " left join (select fbgdataid , sum(FPASTVALUE) sumPastVal from T_BG_bgpastdata group by fbgdataid) c on a.fid = c.fbgdataid";
        return sql;
    }

    private String getAllBgSchemeIdsSql(Context ctx, String bgSchemeId, CostCenterOrgUnitInfo[] orgAry) throws BOSException, SQLException {
        String sql = "select fid from t_bg_bgscheme where frootid = (select frootid from t_bg_bgscheme where fid = '" + bgSchemeId + "') and forgunitid in " + this.constructOrgUnitSql(orgAry) + "";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        int index = 0;
        int size = rs.size();
        String[] array = new String[size];
        while (rs.next()) {
            array[index++] = rs.getString("fid");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        for (int i = 0; i < size; ++i) {
            sb.append(array[i]);
            if (i == size - 1) break;
            sb.append("','");
        }
        sb.append("')");
        return sb.toString();
    }

    private String rebuildFormula(String[] formulaParamArray) {
        return "=BgItem(\"" + formulaParamArray[0] + "\",\"\",\"" + formulaParamArray[2] + "\",\"" + formulaParamArray[3] + "\",true,\"" + formulaParamArray[5] + "\")";
    }

    private String constructPeriodSql(BgPeriodCollection bgPC) {
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        int num = bgPC.size();
        for (int i = 0; i < num; ++i) {
            String periodID = bgPC.get(i).getId().toString();
            sb.append(periodID);
            if (i == num - 1) break;
            sb.append("','");
        }
        sb.append("')");
        return sb.toString();
    }
}

