/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.crbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.OtherBillBizException;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.ICheque;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.CalendarHelper;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.crbg.BgContractFactory;
import com.kingdee.eas.ma.crbg.BgUsefundFactory;
import com.kingdee.eas.ma.crbg.BgUsefundInfo;
import com.kingdee.eas.ma.crbg.BillstateEnum;
import com.kingdee.eas.ma.crbg.CREasBizException;
import com.kingdee.eas.ma.crbg.IBgUsefund;
import com.kingdee.eas.ma.crbg.RecPayTypeEnum;
import com.kingdee.eas.ma.crbg.app.AbstractBgUsefundControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgUsefundControllerBean
extends AbstractBgUsefundControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.crbg.app.BgUsefundControllerBean");
    private static HashMap map = new HashMap();

    @Override
    protected void _submitWF(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected void _auditing(Context ctx, String billid) throws BOSException, EASBizException {
        SelectorItemCollection itemsic = new SelectorItemCollection();
        itemsic.add(new SelectorItemInfo("id"));
        itemsic.add(new SelectorItemInfo("billstate"));
        try {
            IBgUsefund bizApply = BgUsefundFactory.getLocalInstance(ctx);
            ObjectUuidPK pk = new ObjectUuidPK(billid);
            if (!this._exists(ctx, (IObjectPK)pk)) {
                throw new OtherBillBizException(OtherBillBizException.BILL_NOTEXIST);
            }
            BgUsefundInfo info = this.getBgUsefundInfo(ctx, (IObjectPK)new ObjectUuidPK(billid), itemsic);
            if (info != null) {
                info.setBillstate(BillstateEnum.AUDITING);
                bizApply.update((IObjectPK)pk, (CoreBaseInfo)info);
            }
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
    }

    public void delete(Context arg0, IObjectPK arg1) throws BOSException, EASBizException {
        BgUsefundInfo bgUseFundInfo = BgUsefundFactory.getLocalInstance(arg0).getBgUsefundInfo(arg1);
        if (bgUseFundInfo.getBillstate() != null && !bgUseFundInfo.getBillstate().equals((Object)BillstateEnum.EDITING) && !bgUseFundInfo.getBillstate().equals((Object)BillstateEnum.NOPASS)) {
            throw new CREasBizException(CREasBizException.NODELETE);
        }
        super.delete(arg0, arg1);
    }

    protected void _audited(Context ctx, String billid) throws BOSException {
        try {
            IBgUsefund bizApply = BgUsefundFactory.getLocalInstance(ctx);
            ObjectUuidPK pk = new ObjectUuidPK(billid);
            boolean exist = this.exists(ctx, (IObjectPK)pk);
            if (!exist) {
                throw new OtherBillBizException(OtherBillBizException.BILL_NOTEXIST);
            }
            BgUsefundInfo info = this.getBgUsefundInfo(ctx, (IObjectPK)new ObjectUuidPK(billid));
            if (info != null) {
                info.setBillstate(BillstateEnum.AUDITED);
                info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
                bizApply.update((IObjectPK)pk, (CoreBaseInfo)info);
            }
        }
        catch (OtherBillBizException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _pay(Context ctx, String billid) throws BOSException {
    }

    @Override
    protected void _submitCashier(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected void _pass(Context ctx, String billid) throws BOSException {
        try {
            IBgUsefund bizApply = BgUsefundFactory.getLocalInstance(ctx);
            ObjectUuidPK pk = new ObjectUuidPK(billid);
            boolean exist = this.exists(ctx, (IObjectPK)pk);
            if (!exist) {
                throw new OtherBillBizException(OtherBillBizException.BILL_NOTEXIST);
            }
            BgUsefundInfo info = this.getBgUsefundInfo(ctx, (IObjectPK)new ObjectUuidPK(billid));
            if (info != null) {
                info.setBillstate(BillstateEnum.END);
                bizApply.update((IObjectPK)pk, (CoreBaseInfo)info);
            }
        }
        catch (OtherBillBizException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _noPass(Context ctx, String billid) throws BOSException {
        try {
            IBgUsefund bizApply = BgUsefundFactory.getLocalInstance(ctx);
            ObjectUuidPK pk = new ObjectUuidPK(billid);
            boolean exist = this.exists(ctx, (IObjectPK)pk);
            if (!exist) {
                throw new OtherBillBizException(OtherBillBizException.BILL_NOTEXIST);
            }
            BgUsefundInfo info = this.getBgUsefundInfo(ctx, (IObjectPK)new ObjectUuidPK(billid));
            if (info != null) {
                info.setBillstate(BillstateEnum.NOPASS);
                bizApply.update((IObjectPK)pk, (CoreBaseInfo)info);
            }
        }
        catch (OtherBillBizException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _getBackAmt(Context ctx, String billid) throws BOSException {
        try {
            BgUsefundInfo billInfo = this.getBgUsefundInfo(ctx, (IObjectPK)new ObjectUuidPK(billid));
            IBgItem bgItem = BgItemFactory.getLocalInstance((Context)ctx);
            Object itemInfo = null;
            int count = billInfo.getEntrys().size();
            for (int i = 0; i < count; ++i) {
                if (billInfo.getEntrys().get(i).getPjName() == null || billInfo.getEntrys().get(i).getContNum() == null || billInfo.getEntrys().get(i).getCurApplyAmt() == null) continue;
                BgContractFactory.getLocalInstance(ctx).writebackAmount(billInfo.getEntrys().get(i).getContNum().getId().toString(), RecPayTypeEnum.pay, billInfo.getEntrys().get(i).getPjName().getId().toString(), new BigDecimal("0").subtract(billInfo.getEntrys().get(i).getCurApplyAmt()));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _substractAmt(Context ctx, String billid) throws BOSException {
        try {
            BgUsefundInfo billInfo = BgUsefundFactory.getLocalInstance(ctx).getBgUsefundInfo((IObjectPK)new ObjectUuidPK(billid));
            IBgItem bgItem = BgItemFactory.getLocalInstance((Context)ctx);
            Object itemInfo = null;
            int count = billInfo.getEntrys().size();
            for (int i = 0; i < count; ++i) {
                if (billInfo.getEntrys().get(i).getPjName() == null || billInfo.getEntrys().get(i).getContNum() == null || billInfo.getEntrys().get(i).getCurApplyAmt() == null) continue;
                BgContractFactory.getLocalInstance(ctx).writebackAmount(billInfo.getEntrys().get(i).getContNum().getId().toString(), RecPayTypeEnum.pay, billInfo.getEntrys().get(i).getPjName().getId().toString(), billInfo.getEntrys().get(i).getCurApplyAmt());
            }
            this._update(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()), (IObjectValue)billInfo);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String _writeNote(Context ctx, String id) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        BgUsefundInfo billInfo = null;
        try {
            boolean exist = this.exists(ctx, (IObjectPK)pk);
            if (!exist) {
                throw new CREasBizException(CREasBizException.BILL_NOTEXIST);
            }
            billInfo = this.getBgUsefundInfo(ctx, (IObjectPK)pk);
            if (billInfo == null) {
                throw new CREasBizException(CREasBizException.BILL_NOTEXIST);
            }
            if (billInfo.isIsNoted()) {
                throw new CREasBizException(CREasBizException.BILL_NOTED);
            }
            billInfo.setIsNoted(true);
            this._update(ctx, (IObjectPK)pk, (IObjectValue)billInfo);
        }
        catch (UuidException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected int _cancelNote(Context ctx, String id) throws BOSException, EASBizException {
        ICheque chequeCtl = ChequeFactory.getLocalInstance((Context)ctx);
        BgUsefundInfo billInfo = null;
        ChequeInfo cheque = null;
        ObjectUuidPK pk = new ObjectUuidPK(id);
        ObjectUuidPK pkCheque = null;
        String chequeNum = null;
        try {
            boolean exist = this.exists(ctx, (IObjectPK)pk);
            if (!exist) {
                throw new CREasBizException(CREasBizException.BILL_NOTEXIST);
            }
            billInfo = this.getBgUsefundInfo(ctx, (IObjectPK)pk);
            if (billInfo == null) {
                throw new CREasBizException(CREasBizException.BILL_NOTEXIST);
            }
            if (!billInfo.isIsNoted()) {
                throw new CREasBizException(CREasBizException.BILL_NOTNOTED);
            }
            if (billInfo.getChequeNum() == null) {
                throw new CREasBizException(CREasBizException.CHEQUENUMISNULL);
            }
            chequeNum = billInfo.getChequeNum().getId().toString();
            pkCheque = new ObjectUuidPK(chequeNum);
            exist = chequeCtl.exists((IObjectPK)pkCheque);
            if (!exist) {
                throw new CREasBizException(CREasBizException.CHEQUENUMISNULL);
            }
            cheque = chequeCtl.getChequeInfo((IObjectPK)pkCheque);
            if (cheque == null) {
                throw new CREasBizException(CREasBizException.CHEQUENUMISNULL);
            }
            cheque.setIsAbandon(true);
            chequeCtl.abandon((IObjectPK)pkCheque, cheque);
            billInfo.setChequeNum(null);
            billInfo.setIsNoted(false);
            this._update(ctx, (IObjectPK)pk, (IObjectValue)billInfo);
        }
        catch (UuidException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return 0;
    }

    @Override
    protected void _audited(Context ctx, String billid, String auditId) throws BOSException {
        try {
            IBgUsefund bizApply = BgUsefundFactory.getLocalInstance(ctx);
            ObjectUuidPK pk = new ObjectUuidPK(billid);
            boolean exist = this.exists(ctx, (IObjectPK)pk);
            if (!exist) {
                throw new OtherBillBizException(OtherBillBizException.BILL_NOTEXIST);
            }
            BgUsefundInfo info = this.getBgUsefundInfo(ctx, (IObjectPK)new ObjectUuidPK(billid));
            if (info != null) {
                info.setBillstate(BillstateEnum.AUDITED);
                IUser iuser = UserFactory.getLocalInstance((Context)ctx);
                if (auditId != null) {
                    info.setAuditor(iuser.getUserInfo((IObjectPK)new ObjectUuidPK(auditId)));
                }
                bizApply.update((IObjectPK)pk, (CoreBaseInfo)info);
            }
        }
        catch (OtherBillBizException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected List _getPayedAmt(Context ctx, Date startTime, Date endTime, String pjNum, String number, String org) throws BOSException {
        ArrayList<Serializable> list = new ArrayList<Serializable>();
        BigDecimal sum = new BigDecimal("0");
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        String sql = null;
        if (number != null) {
            sql = "SELECT A.fid, A.FApplyTime, B.FCurApplyAmt, A.fNumber,   C.FContractNum, B.FPjNum , A.FBillState  FROM T_CR_BgUsefund A   INNER JOIN T_CR_BgUsefundEntry B   ON A.FID = B.FParentID  LEFT OUTER JOIN T_CR_BgContract C   ON B.FContNumID = C.FID  where B.FPjNum  in ('" + pjNum + "','" + number + "')   AND C.Fnumber  in ('" + pjNum + "','" + number + "')   AND A.FBillState = " + 15 + "  and A.FApplyTime >= TO_DATE('" + this.getSqlDate(startTime) + "') and A.FApplyTime <= TO_DATE('" + this.getSqlDate(endTime) + "')";
            if (org != null) {
                sql = sql + " AND A.forgUnitID = '" + org + "'";
            }
        } else {
            sql = "SELECT A.fid, A.FApplyTime, B.FCurApplyAmt, A.fNumber,   C.FContractNum, B.FPjNum , A.FBillState  FROM T_CR_BgUsefund A   INNER JOIN T_CR_BgUsefundEntry B   ON A.FID = B.FParentID  LEFT OUTER JOIN T_CR_BgContract C   ON B.FContNumID = C.FID  where B.FPjNum  = '" + pjNum + "'  AND A.FBillState <> " + 22 + " and A.FBillState <> " + 12 + " and A.FBillState <> " + 11 + "  and A.FApplyTime >= TO_DATE('" + this.getSqlDate(startTime) + "') and A.FApplyTime <= TO_DATE('" + this.getSqlDate(endTime) + "')";
            if (org != null) {
                sql = sql + " AND A.forgUnitID = '" + org + "'";
            }
        }
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                Vector<Object> vec = new Vector<Object>();
                vec.add(rs.getString("Fid").toString());
                vec.add(rs.getString("FApplyTime"));
                vec.add(rs.getBigDecimal("FCurApplyAmt"));
                if (rs.getBigDecimal("FCurApplyAmt") != null) {
                    sum = sum.add(rs.getBigDecimal("FCurApplyAmt"));
                }
                vec.add(rs.getString("fNumber"));
                vec.add(rs.getString("FBillState"));
                list.add(vec);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        list.add(sum);
        return list;
    }

    public String getSqlDate(Date time) {
        CalendarHelper Helper = new CalendarHelper();
        Date a = Helper.getStartDate(time);
        String b = a.getYear() + 1900 + "-" + (a.getMonth() + 1) + "-" + a.getDate();
        Object ps = null;
        return b;
    }

    @Override
    protected List _getApplyedAmt(Context ctx, Date startTime, Date endTime, String pjNum, String contractNum, String orgUnitID) throws BOSException {
        return null;
    }
}

