/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.BizScopeCollection;
import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcExpreUtils;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.MbgExprParseHelper;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.MbgScriptParseHelper;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.ScriptFormater;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.face.IExprCheck;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.face.IScriptFormater;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.biz.utils.BizMemberQuery;
import com.kingdee.eas.ma.biz.utils.BizPtoUtils;
import com.kingdee.eas.ma.mbg.AbstractBgExamineSubsetInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgScopeInfo;
import com.kingdee.eas.ma.mbg.MbgFunctionFacadeFactory;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgExamineSubsetInfo
extends AbstractBgExamineSubsetInfo
implements Serializable {
    private static final Logger logger = CoreUIObject.getLogger(BgExamineSubsetInfo.class);
    public boolean hasFormula = false;
    private List<IExpress> expres = null;
    private Map<String, Set<String>> scopeMap = null;
    Map<String, List<String>> allPeriodMap = null;

    public BgExamineSubsetInfo() {
    }

    protected BgExamineSubsetInfo(String pkField) {
        super(pkField);
    }

    public String getBizFormula() {
        String _bizFormula = null;
        byte[] _bytes = this.getFormula();
        if (_bytes != null && _bytes.length > 0) {
            _bizFormula = (String)BgAnalyseHelper.getObject(_bytes);
        }
        return _bizFormula;
    }

    public void setBizFormula(String bizFormula) {
        byte[] _bytes = null;
        if (!StringUtils.isEmpty((String)bizFormula)) {
            _bytes = BgAnalyseHelper.getBytes(bizFormula);
        }
        this.setFormula(_bytes);
    }

    public List<IExpress> getExpres() throws ParseException {
        return this.getExpres(null, false);
    }

    public List<IExpress> getExpres(boolean refresh) throws ParseException {
        return this.getExpres(null, refresh);
    }

    public List<IExpress> getExpres(IExprCheck check, boolean refresh) throws ParseException {
        if (refresh && this.expres != null) {
            this.expres.clear();
        }
        if (this.expres != null && !this.expres.isEmpty()) {
            return this.expres;
        }
        return this.getParseExpres(check);
    }

    protected List<IExpress> getParseExpres(IExprCheck check) throws ParseException {
        if (this.expres == null) {
            this.expres = new ArrayList<IExpress>(50);
        } else {
            this.expres.clear();
        }
        String formulaStr = this.getBizFormula();
        if (StringUtils.isEmpty((String)formulaStr)) {
            return this.expres;
        }
        List scripts = MbgScriptParseHelper.parse((String)formulaStr, (IScriptFormater)new ScriptFormater());
        if (scripts != null) {
            String script = null;
            IExpress expre = null;
            int jn = scripts.size();
            for (int j = 0; j < jn; ++j) {
                script = (String)scripts.get(j);
                expre = MbgExprParseHelper.parse((String)script, (IExprCheck)check);
                if (expre == null) continue;
                this.expres.add(expre);
            }
        }
        return this.expres;
    }

    public Map<String, Set<String>> getScopeData(Context ctx, BgSchemeInfo bgScheme, BOSUuid bgOrgViewId, BOSUuid unionId, MbgDimCollection mbgDims, Map<String, String> variateMap) throws Exception {
        if (this.scopeMap == null) {
            this.scopeMap = new HashMap<String, Set<String>>();
            BgScopeInfo scope = null;
            String field = null;
            Set<Object> numbers = null;
            BizMemberQuery query = BizMemberQuery.getInstance((Context)ctx, (String)bgScheme.getId().toString());
            query.setSchemeInfo(bgScheme);
            query.setMbgColls(mbgDims);
            int in = this.getBgScope().size();
            for (int i = 0; i < in; ++i) {
                scope = this.getBgScope().get(i);
                if (scope.getBgMemberType() == BizConstants.BIZ_BGORGUNIT_TYPE_VALUE) {
                    field = DimensionBaseConstants.DEF_ORGUNIT_FIELD;
                } else if (scope.getBgMemberType() == BizConstants.BIZ_BGINDEX_TYPE_VALUE) {
                    field = DimensionBaseConstants.DEF_BGINDEX_FIELD;
                } else if (scope.getBgMemberType() == BizConstants.BIZ_CURRENCY_TYPE_VALUE) {
                    field = DimensionBaseConstants.DEF_CURRENCY_FIELD;
                } else if (scope.getBgMemberType() == BizConstants.BIZ_BGVERSION_TYPE_VALUE) {
                    field = DimensionBaseConstants.DEF_VERSION_FIELD;
                } else if (scope.getBgMemberType() == BizConstants.BIZ_BGSCENARIO_TYPE_VALUE) {
                    field = DimensionBaseConstants.DEF_SCENARIO_FIELD;
                } else if (scope.getBgMemberType() == BizConstants.BIZ_BGPERIOD_TYPE_VALUE) {
                    field = DimensionBaseConstants.DEF_PERIOD_FIELD;
                } else if (scope.getBgMemberType() == BizConstants.BIZ_BGELEMENT_TYPE_VALUE) {
                    field = DimensionBaseConstants.DEF_ELEMENT_FIELD;
                } else if (scope.getBgMemberType() == BizConstants.BIZ_PROCESS_TYPE_VALUE) {
                    field = DimensionBaseConstants.DEF_PROCESS_FIELD;
                } else if (scope.getBgMemberType() == BizConstants.BIZ_EXTDIM_TYPE_VALUE) {
                    field = scope.getRefField();
                }
                if (this.scopeMap.containsKey(field)) {
                    numbers = this.scopeMap.get(field);
                } else {
                    numbers = new HashSet();
                    this.scopeMap.put(field, numbers);
                }
                int valueType = scope.getBizDataType().getValue();
                if (valueType == 1) {
                    if (0 == scope.getFillType().getValue()) {
                        if (StringUtils.isEmpty((String)scope.getBgMemberNum())) continue;
                        numbers.add(scope.getBgMemberNum());
                        continue;
                    }
                    query.addQueryMember(scope.getRefField(), DimUtils.getNumber(scope.getBgMemberNum()), scope.getFillType().getValue(), BizMemberQuery.QUERY_ALL);
                    continue;
                }
                if (valueType == 2) {
                    if (variateMap == null || !variateMap.containsKey(scope.getBgMemberNum())) continue;
                    if (DimUtils.checkBaseDimensionByField(field)) {
                        numbers.add(DimUtils.getNumber(variateMap.get(scope.getBgMemberNum())));
                        continue;
                    }
                    numbers.add(variateMap.get(scope.getBgMemberNum()));
                    continue;
                }
                if (valueType == 4) {
                    if (StringUtils.isEmpty((String)scope.getBgMemberNum())) continue;
                    query.addQueryFunction(scope.getRefField(), scope.getBgMemberNum(), variateMap);
                    continue;
                }
                if (valueType != 3 || bgScheme == null) continue;
                if (query == null) {
                    query = BizMemberQuery.getInstance((Context)ctx, (String)bgScheme.getId().toString());
                    query.setSchemeInfo(bgScheme);
                    query.setMbgColls(mbgDims);
                }
                query.addQueryProp(scope.getRefField(), scope.getBgMemberNum());
            }
            Map queryMap = query.queryMember();
            if (queryMap != null) {
                List members = null;
                int in2 = this.getBgScope().size();
                for (int i = 0; i < in2; ++i) {
                    scope = this.getBgScope().get(i);
                    if (!queryMap.containsKey(scope.getRefField())) continue;
                    members = (List)queryMap.get(scope.getRefField());
                    numbers = this.scopeMap.get(scope.getRefField());
                    if (DimUtils.checkBaseDimensionByField(scope.getRefField())) {
                        for (IMember member : members) {
                            numbers.add(member.getNumber());
                        }
                        continue;
                    }
                    for (IMember member : members) {
                        numbers.add(member.getDimNumber());
                    }
                }
            }
            if (this.scopeMap.containsKey(DimensionBaseConstants.DEF_ORGUNIT_FIELD)) {
                BizScopeCollection bizScopeColls = BizCalcExpreUtils.transNumToScopeColls(this.scopeMap.get(DimensionBaseConstants.DEF_ORGUNIT_FIELD));
                Set orgScopeSet = null;
                if (bizScopeColls != null && !bizScopeColls.isEmpty() && (orgScopeSet = MbgFunctionFacadeFactory.getLocalInstance(ctx).getOrgScopeByBizScope((IObjectCollection)bizScopeColls, bgOrgViewId.toString(), bgScheme.getId().toString(), unionId)) != null) {
                    this.scopeMap.put(DimensionBaseConstants.DEF_ORGUNIT_FIELD, orgScopeSet);
                }
            }
        }
        return this.scopeMap;
    }

    public Set<String> getProcessScope() {
        HashSet<String> result = new HashSet<String>();
        BgScopeInfo scope = null;
        for (int s = 0; s < this.getBgScope().size(); ++s) {
            scope = this.getBgScope().get(s);
            if (scope.getBgMemberType() != BizConstants.BIZ_PROCESS_TYPE_VALUE) continue;
            result.add(scope.getBgMemberNum());
        }
        return result;
    }

    public List<IExpress> processPtoExpress(IExpress express) {
        ArrayList<IExpress> lst = new ArrayList<IExpress>();
        lst.add(express);
        try {
            if (express.toString().indexOf("PTO") >= 0 && this.get(BizPtoUtils.REF_PERIODS) != null) {
                List newExpress;
                if (this.allPeriodMap == null) {
                    this.allPeriodMap = BizPtoUtils.queryBgPeriodInfo();
                }
                if ((newExpress = BizPtoUtils.transPtoExpress(lst, (List)((List)this.get(BizPtoUtils.REF_PERIODS)), this.allPeriodMap)) != null && !newExpress.isEmpty()) {
                    return newExpress;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            return lst;
        }
        return lst;
    }

    public Map<String, String> getComments() throws ParseException {
        String formulaStr = this.getBizFormula();
        List exprs = MbgScriptParseHelper.parse((String)formulaStr, (IScriptFormater)new ScriptFormater());
        return this.getComments(formulaStr, exprs);
    }

    protected Map<String, String> getComments(String formula, List<String> exprs) throws ParseException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)formula) || exprs.isEmpty()) {
            return map;
        }
        String expr = null;
        List<IExpress> express = this.getExpres();
        for (int index = 0; index < exprs.size(); ++index) {
            expr = exprs.get(index);
            if (expr.indexOf("PTO") >= 0) {
                List<IExpress> newExpress = this.processPtoExpress(express.get(index));
                for (int j = 0; j < newExpress.size(); ++j) {
                    map.put(newExpress.get(j).toPlanString(), this.getComment(formula, expr));
                }
                continue;
            }
            map.put(express.get(index).toPlanString(), this.getComment(formula, expr));
        }
        return map;
    }

    protected String getComment(String formulaStr, String expr) throws ParseException {
        if (StringUtils.isEmpty((String)formulaStr)) {
            return formulaStr;
        }
        int start = formulaStr.replace("\r\n", "").indexOf(expr.replace("\r\n", ""));
        StringBuffer tStr = new StringBuffer();
        boolean isStart = false;
        for (int index = start - 1; index >= 0; --index) {
            char ch = formulaStr.charAt(index);
            if (index - 1 >= 0 && ch == '/' && formulaStr.charAt(index - 1) == '*') {
                isStart = true;
                index -= 2;
            }
            if (index - 1 >= 0 && ch == '*' && formulaStr.charAt(index - 1) == '/') {
                isStart = false;
                break;
            }
            if (!isStart) continue;
            ch = formulaStr.charAt(index);
            tStr.append(ch);
        }
        StringBuffer str = new StringBuffer();
        if (tStr.length() > 0) {
            for (int i = tStr.length() - 1; i >= 0; --i) {
                str.append(tStr.charAt(i));
            }
        }
        if (str.length() == 0) {
            return this.reGetComment(formulaStr, expr);
        }
        return str.toString();
    }

    protected String reGetComment(String formulaStr, String expr) throws ParseException {
        if (StringUtils.isEmpty((String)formulaStr)) {
            return formulaStr;
        }
        int start = formulaStr.indexOf(expr);
        StringBuffer tStr = new StringBuffer();
        boolean isStart = false;
        for (int index = start - 1; index >= 0; --index) {
            char ch = formulaStr.charAt(index);
            if (index - 1 >= 0 && ch == '/' && formulaStr.charAt(index - 1) == '*') {
                isStart = true;
                index -= 2;
            }
            if (index - 1 >= 0 && ch == '*' && formulaStr.charAt(index - 1) == '/') {
                isStart = false;
                break;
            }
            if (!isStart) continue;
            ch = formulaStr.charAt(index);
            tStr.append(ch);
        }
        StringBuffer str = new StringBuffer();
        if (tStr.length() > 0) {
            for (int i = tStr.length() - 1; i >= 0; --i) {
                str.append(tStr.charAt(i));
            }
        }
        return str.toString();
    }
}

