/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.ma.mbg.AbstractBgSpecialItemsInfo;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgSpecialItemsInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgSpecialBudgetHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class BgSpecialItemsInfo
extends AbstractBgSpecialItemsInfo
implements Serializable,
IBgSpecialItemsInfo {
    private Map<String, MbgViewListDimensionInfo> specialDimensions = null;

    public BgSpecialItemsInfo() {
    }

    protected BgSpecialItemsInfo(String pkField) {
        super(pkField);
    }

    public Map<String, MbgViewListDimensionInfo> getSpecialDimensions(BgSchemeDimensionHelper schemeHelper) throws BOSException {
        if (this.specialDimensions == null) {
            this.parseDimensions(schemeHelper);
        }
        return this.specialDimensions;
    }

    public void setSpecialDimensions(Map<String, MbgViewListDimensionInfo> specialDimensions) {
        this.specialDimensions = specialDimensions;
    }

    @Override
    public String getDimensionNameAsAlias() {
        if (StringUtils.isEmpty((String)this.getDimensionAlias()) || StringUtils.isEmpty((String)this.getDimensionNumber())) {
            return this.getDimensionName();
        }
        Map<String, String> alias = this.parseAlias();
        String[] dimNumbers = this.getDimensionNumber().split(DimensionConstants.COMMA_SEPARATOR);
        Object[] dimNames = this.getDimensionName().split(",");
        String srcNumber = null;
        for (int i = 0; i < dimNumbers.length; ++i) {
            srcNumber = DimensionFormulaHelper.getSrcNumber(dimNumbers[i]);
            if (alias.get(srcNumber) == null) continue;
            dimNames[i] = alias.get(srcNumber);
        }
        return BgSpecialItemsInfo.arrayToString(dimNames, ",");
    }

    private void parseDimensions(BgSchemeDimensionHelper schemeHelper) throws BOSException {
        this.specialDimensions = new LinkedHashMap<String, MbgViewListDimensionInfo>();
        if (this.getCanAddMember() == null || this.getCanAddMember().length == 0) {
            String dimensionNumber = this.getDimensionNumber();
            String membeName = this.getMemberName();
            String hide = this.getHide();
            if (StringUtils.isEmpty((String)dimensionNumber)) {
                return;
            }
            Map<String, BgDimensionInfo> srcNumAndDimensonMap = schemeHelper.getDimensionBySrcNumber();
            String[] numbers = dimensionNumber.split(DimensionConstants.COMMA_SEPARATOR);
            String[] names = null;
            names = membeName.contains(DimensionConstants.COMMA_SEPARATOR) ? BgSpecialBudgetHelper.splitName(membeName, DimensionConstants.COMMA_SEPARATOR) : BgSpecialBudgetHelper.splitName(membeName, DimensionConstants.TICK_SEPARATOR);
            String[] hides = BgSpecialBudgetHelper.splitName(hide, DimensionConstants.COMMA_SEPARATOR);
            if (hides == null) {
                hides = new String[numbers.length];
                for (int i = 0; i < hides.length; ++i) {
                    hides[i] = String.valueOf(false);
                }
            }
            MbgViewListDimensionInfo bgDimensionInfo = null;
            BgDimensionMember bgDimensionMember = null;
            String memberNumber = null;
            String memberName = null;
            String srcNum = null;
            int length = numbers.length;
            for (int index = 0; index < length; ++index) {
                srcNum = numbers[index].split(":")[0];
                memberNumber = numbers[index].split(":")[1];
                memberName = names[index];
                String isHide = hides[index];
                if (!srcNumAndDimensonMap.containsKey(srcNum)) continue;
                bgDimensionInfo = new MbgViewListDimensionInfo(null);
                srcNumAndDimensonMap.get(srcNum).cloneValue(bgDimensionInfo);
                bgDimensionInfo.setShow(Boolean.valueOf(isHide) == false);
                this.specialDimensions.put(bgDimensionInfo.getNumber(), bgDimensionInfo);
                if ("#".equals(memberNumber)) continue;
                bgDimensionMember = new BgDimensionMember(bgDimensionInfo.getNumber(), bgDimensionInfo.getRefField(), memberName, memberNumber);
                bgDimensionInfo.getCanAddMember().add(bgDimensionMember);
            }
        } else {
            this.specialDimensions = new MbgViewListXMLParser().parseSpecialDimensions(this.getCanAddMember());
        }
        Map<String, String> alias = this.parseAlias();
        for (MbgViewListDimensionInfo dimension : this.specialDimensions.values()) {
            dimension.setName(schemeHelper.getDimension(dimension.getNumber()).getAlias());
            dimension.setAlias(alias.get(schemeHelper.getSrcNumber(dimension.getNumber())));
        }
    }

    private Map<String, String> parseAlias() {
        HashMap<String, String> alias = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)this.getDimensionAlias())) {
            String[] aliasies;
            for (String a : aliasies = this.getDimensionAlias().split(DimensionConstants.TICK_SEPARATOR)) {
                alias.put(DimensionFormulaHelper.getSrcNumber(a), DimensionFormulaHelper.getMemberNumber(a));
            }
        }
        return alias;
    }

    public void unParseDimensions(Map<String, MbgViewListDimensionInfo> specialDimensions, BgSchemeDimensionHelper schemeHelper, boolean isTemplate) {
        this.specialDimensions = specialDimensions;
        if (specialDimensions == null || specialDimensions.isEmpty()) {
            this.setDimensionNumber(null);
            this.setMemberName(null);
            this.setDimensionName(null);
            this.setMemberDisplayName(null);
            this.setHide(null);
            this.setCanAddMember(null);
            this.setDimensionAlias(null);
            return;
        }
        if (isTemplate) {
            try {
                this.unParseDimensionsFormBgTemplate(schemeHelper);
            }
            catch (DimensionException e) {
                e.printStackTrace();
            }
        } else {
            this.unParseDimensionsFormBgForm(schemeHelper);
        }
        StringBuffer alias = new StringBuffer();
        for (MbgViewListDimensionInfo dimension : specialDimensions.values()) {
            if (StringUtils.isEmpty((String)dimension.getAlias())) continue;
            if (alias.length() > 0) {
                alias.append(DimensionConstants.TICK_SEPARATOR);
            }
            alias.append(DimensionFormulaHelper.getCombination(schemeHelper.getSrcNumber(dimension.getNumber()), dimension.getAlias()));
        }
        if (alias.length() > 0) {
            this.setDimensionAlias(alias.toString());
        } else {
            this.setDimensionAlias(null);
        }
    }

    private void unParseDimensionsFormBgForm(BgSchemeDimensionHelper schemeHelper) {
        int count = this.specialDimensions.size();
        Object[] numberCol = new String[count];
        Object[] nameCol = new String[count];
        Object[] hideCol = new String[count];
        BgDimensionMember member = null;
        String srcNumber = null;
        String memNumber = null;
        String memName = null;
        String dName = null;
        StringBuffer dimName = new StringBuffer();
        StringBuffer memDisName = new StringBuffer();
        int index = 0;
        for (MbgViewListDimensionInfo dimension : this.specialDimensions.values()) {
            if (dimName.length() > 0) {
                dimName.append(DimensionConstants.COMMA_SEPARATOR);
            }
            dName = dimension.getAlias() != null ? dimension.getAlias() : dimension.getName();
            dimName.append(dName);
            if (memDisName.length() > 0) {
                memDisName.append(DimensionConstants.COMMA_SEPARATOR);
            }
            memDisName = memDisName.append(dName).append(":");
            srcNumber = schemeHelper.getSrcNumber(dimension.getNumber());
            if (!dimension.getCanAddMember().isEmpty()) {
                member = (BgDimensionMember)dimension.getCanAddMember().get(0);
                memNumber = member.getNumber();
                memName = member.getName();
            } else {
                memNumber = "#";
                memName = "#";
            }
            memDisName.append(memName);
            numberCol[index] = DimensionFormulaHelper.getCombination(srcNumber, memNumber);
            nameCol[index] = memName;
            hideCol[index] = String.valueOf(!dimension.isShow());
            ++index;
        }
        this.setDimensionNumber(BgSpecialItemsInfo.arrayToString(numberCol, DimensionConstants.COMMA_SEPARATOR));
        this.setMemberName(BgSpecialItemsInfo.arrayToString(nameCol, DimensionConstants.TICK_SEPARATOR));
        this.setHide(BgSpecialItemsInfo.arrayToString(hideCol, DimensionConstants.COMMA_SEPARATOR));
        this.setMemberDisplayName(memDisName.toString());
        this.setDimensionName(dimName.toString());
        this.setCanAddMember(null);
    }

    private void unParseDimensionsFormBgTemplate(BgSchemeDimensionHelper schemeHelper) throws DimensionException {
        int count = this.specialDimensions.size();
        Object[] numberCol = new String[count];
        String[] nameCol = new String[count];
        Object[] hideCol = new String[count];
        StringBuffer dimensionName = new StringBuffer();
        int index = 0;
        for (MbgViewListDimensionInfo dimension : this.specialDimensions.values()) {
            numberCol[index] = DimensionFormulaHelper.getCombination(schemeHelper.getSrcNumber(dimension.getNumber()), "#");
            try {
                nameCol[index] = dimension.upParseCanAddMember();
            }
            catch (DimensionException dimensionException) {
                // empty catch block
            }
            hideCol[index] = String.valueOf(!dimension.isShow());
            if (dimensionName.length() > 0) {
                dimensionName.append(DimensionConstants.COMMA_SEPARATOR);
            }
            if (dimension.getAlias() != null) {
                dimensionName.append(dimension.getAlias());
            } else {
                dimensionName.append(dimension.getName());
            }
            ++index;
        }
        this.setDimensionNumber(BgSpecialItemsInfo.arrayToString(numberCol, DimensionConstants.COMMA_SEPARATOR));
        this.setMemberName(BgSpecialItemsInfo.arrayToString(numberCol, DimensionConstants.COMMA_SEPARATOR));
        if (this.getMemberName() != null && this.getMemberName().length() > 256) {
            this.setMemberName(this.getMemberName().substring(0, 255));
        }
        this.setDimensionName(dimensionName.toString());
        this.setMemberDisplayName(this.getMemberName());
        this.setHide(BgSpecialItemsInfo.arrayToString(hideCol, DimensionConstants.COMMA_SEPARATOR));
        this.setCanAddMember(new MbgViewListXMLParser().unParseSpecialDimension(this.specialDimensions));
    }

    public static String arrayToString(Object[] obj, String split) {
        StringBuffer name = new StringBuffer();
        for (int j = 0; j < obj.length; ++j) {
            name.append(obj[j] == null ? "" : obj[j].toString());
            if (j == obj.length - 1) continue;
            name.append(split);
        }
        return name.toString();
    }

    public static String getSpecialItemDimNumberForBgForm(Map<String, MbgViewListDimensionInfo> specialDimensions, BgSchemeDimensionHelper schemeHelper) {
        BgSpecialItemsInfo info = new BgSpecialItemsInfo();
        info.unParseDimensions(specialDimensions, schemeHelper, false);
        return info.getDimensionNumber();
    }
}

