/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.mbg.BgDetailMemberEnum;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class MbgFunctionHelper {
    private static final Logger logger = Logger.getLogger(MbgFunctionHelper.class);
    public static final String RES = "com.kingdee.eas.ma.mbg.MbgFunctionResource";
    public static final String CHILDREN = "@Children";
    public static final String ANCESTORS = "@Ancestors";
    public static final String DESCENDANTS = "@Descendants";
    public static final String SIBLINGS = "@Siblings";
    public static final String IANCESTORS = "@IAncestors";
    public static final String ICHILDRENS = "@IChildrens";
    public static final String ISIBLINGS = "@ISiblings";
    public static final String IDESCENDANTS = "@IDescendants";
    public static final String REMOVE = "@Remove";
    public static final String SIMCHILDREN = "Children";
    public static final String SIMANCESTORS = "Ancestors";
    public static final String SIMDESCENDANTS = "Descendants";
    public static final String SIMSIBLINGS = "Siblings";
    public static final String SIMIANCESTORS = "IAncestors";
    public static final String SIMICHILDRENS = "IChildrens";
    public static final String SIMISIBLINGS = "ISiblings";
    public static final String SIMIDESCENDANTS = "IDescendants";
    public static final String SIMREMOVE = "Remove";
    public static final String MAX = "@MAX";
    public static final String MIN = "@MIN";
    public static final String ABS = "@ABS";
    public static final String AVG = "@AVG";
    public static final String LEAD = "@Lead";
    public static final String PARALLELPERIOD = "@ParallelPeriod";
    public static final String PARENT = "@Parent";
    public static final String LEFT_BRACKET = "(";
    public static final String RIGHT_BRACKET = ")";
    public static final String SPLITTER_ONE = "_";
    public static final String SPLITTER_TWO = ":";
    public static final String BACKFILLMEMBER = "backfillMember";
    public static final String DIMENSION = "dimension";
    public static final String MEMBER = "MEMBER";
    public static final String BOOLEAN = "BOOLEAN";
    public static final String BGDETAILMEMEBER = "bgDetailMember";
    public static final String ISOPENBYEXIST = "isOpenByExist";
    public static final String ISSHOWREMOVE = "isShowRemove";
    public static final String EXISTMEMBER = "existMember";
    public static final String DIMENSIONMEMBER = "dimensionMember";
    public static final String DIMENSIONMEMBEROTHER = "dimensionMemberOther";
    public static final String EXISTLISTONE = "ExistListOne";
    public static final String EXISTLISTTWO = "ExistListTwo";
    public static final String LANGUAGE_ZH = "zh_CN";
    public static Set<String> nativeFunction = new HashSet<String>(){
        {
            this.add(MbgFunctionHelper.SIMCHILDREN);
            this.add(MbgFunctionHelper.SIMANCESTORS);
            this.add(MbgFunctionHelper.SIMDESCENDANTS);
            this.add(MbgFunctionHelper.SIMSIBLINGS);
            this.add(MbgFunctionHelper.SIMIANCESTORS);
            this.add(MbgFunctionHelper.SIMICHILDRENS);
            this.add(MbgFunctionHelper.SIMISIBLINGS);
            this.add(MbgFunctionHelper.SIMIDESCENDANTS);
            this.add(MbgFunctionHelper.SIMREMOVE);
        }
    };
    private static MbgDimCollection dimColls = null;
    private static HashMap<String, String> srcNumMap = new HashMap();
    private static HashMap<String, String> srcFieldMap = new HashMap();

    public static void checkNumRepeat(HashSet<String> repeatNumSet) {
        MsgBox.showInfo((String)EASResource.getString((String)""));
        SysUtil.abort();
    }

    public static String buildFunctionStr(String functionName, BgDimensionMember member, BgDetailMemberEnum memberEnum) {
        MbgFunctionHelper.checkFunctionParam(functionName);
        String srcNum = MbgFunctionHelper.getSrcNumber(member.getType());
        String functionNameStr = MbgFunctionHelper.buildFunctionStr(functionName, srcNum, member.getNumber(), memberEnum);
        return functionNameStr;
    }

    public static String buildFunctionStr(String functionName, BgDimensionMember member, String memberEnum) {
        MbgFunctionHelper.checkFunctionParam(functionName);
        String srcNum = MbgFunctionHelper.getSrcNumber(member.getType());
        String functionNameStr = MbgFunctionHelper.buildFunctionStr(functionName, srcNum, member.getNumber(), memberEnum);
        return functionNameStr;
    }

    public static String buildFunctionStr(String functionName, String srcNumber, String memberNumber, BgDetailMemberEnum memberEnum) {
        String detailMember = "";
        if (memberEnum != null) {
            detailMember = memberEnum.getValue();
        }
        String functionNameStr = functionName + LEFT_BRACKET + "\"" + srcNumber + SPLITTER_TWO + memberNumber + "\",\"" + detailMember + "\"" + RIGHT_BRACKET;
        return functionNameStr;
    }

    public static String buildFunctionStr(String functionName, String srcNumber, String memberNumber, String memberEnum) {
        String functionNameStr = functionName + LEFT_BRACKET + "\"" + srcNumber + SPLITTER_TWO + memberNumber + "\",\"" + memberEnum + "\"" + RIGHT_BRACKET;
        return functionNameStr;
    }

    public static String buildFunctionStr(String functionName, String srcNumber, String memberNumber) {
        String functionNameStr = functionName + LEFT_BRACKET + "\"" + srcNumber + SPLITTER_TWO + memberNumber + "\"" + RIGHT_BRACKET;
        return functionNameStr;
    }

    public static BgDetailMemberEnum getDetailMemberByFuncParam(String function) {
        String[] detailMemArr = function.substring(function.indexOf(LEFT_BRACKET) + 1, function.indexOf(RIGHT_BRACKET)).split(",");
        String detailMem = null;
        if (detailMemArr.length == 2) {
            detailMem = detailMemArr[1].replace("\"", "");
            for (int i = 0; i < BgDetailMemberEnum.getEnumList().size(); ++i) {
                if (!detailMem.equals(((BgDetailMemberEnum)((Object)BgDetailMemberEnum.getEnumList().get(i))).getValue())) continue;
                return (BgDetailMemberEnum)((Object)BgDetailMemberEnum.getEnumList().get(i));
            }
        }
        return null;
    }

    public static String buildFunctionStr(String functionName, BgDimensionMember member) {
        if (StringUtils.isEmpty((String)functionName) || member == null) {
            return null;
        }
        MbgFunctionHelper.checkFunctionParam(functionName);
        String functionNameStr = null;
        String srcNum = MbgFunctionHelper.getSrcNumber(member.getType());
        functionNameStr = MbgFunctionHelper.buildFunctionStr(functionName, srcNum, member.getNumber());
        return functionNameStr;
    }

    public static String buildPeriodFunctionStr(String functionName, BgDimensionMember member, String interval, String periodTypeEnum) {
        if (StringUtils.isEmpty((String)functionName)) {
            return null;
        }
        String functionNameStr = null;
        if (member == null) {
            functionNameStr = periodTypeEnum == null ? "FX:[" + functionName + LEFT_BRACKET + "\"" + interval + "\",\"\"" + RIGHT_BRACKET + "]" : "FX:[" + functionName + LEFT_BRACKET + "\"" + periodTypeEnum.toString() + "\",\"" + interval + "\",\"\"" + RIGHT_BRACKET + "]";
        } else {
            String srcNum = MbgFunctionHelper.getSrcNumber(member.getType());
            functionNameStr = periodTypeEnum == null ? "FX:[" + functionName + LEFT_BRACKET + "\"" + interval + "\",\"" + srcNum + SPLITTER_TWO + member.getNumber() + "\"" + RIGHT_BRACKET + "]" : "FX:[" + functionName + LEFT_BRACKET + "\"" + periodTypeEnum.toString() + "\",\"" + interval + "\",\"" + srcNum + SPLITTER_TWO + member.getNumber() + "\"" + RIGHT_BRACKET + "]";
        }
        return functionNameStr;
    }

    public static String buildOrgParentStr(String functionName, String expression) {
        if (StringUtils.isEmpty((String)functionName)) {
            return null;
        }
        MbgFunctionHelper.checkFunctionParam(functionName);
        StringBuffer functionNameStr = new StringBuffer();
        functionNameStr.append("FX").append(SPLITTER_TWO).append("[");
        functionNameStr.append(functionName).append(LEFT_BRACKET);
        functionNameStr.append("\"");
        if (StringUtils.isEmpty((String)expression)) {
            functionNameStr.append("");
        } else {
            functionNameStr.append(expression);
        }
        functionNameStr.append("\"");
        functionNameStr.append(RIGHT_BRACKET);
        functionNameStr.append("]");
        return functionNameStr.toString();
    }

    public static String buildFunctionTextStr(String functionName, String expression) {
        if (StringUtils.isEmpty((String)functionName)) {
            return null;
        }
        MbgFunctionHelper.checkFunctionParam(functionName);
        StringBuffer functionNameStr = new StringBuffer();
        functionNameStr.append(functionName).append(LEFT_BRACKET);
        if (StringUtils.isEmpty((String)expression)) {
            functionNameStr.append("");
        } else {
            functionNameStr.append(expression);
        }
        functionNameStr.append(RIGHT_BRACKET);
        return functionNameStr.toString();
    }

    public static String buildFunctionMultiStr(String functionName, List<BgDimensionMember> memberList) {
        if (StringUtils.isEmpty((String)functionName) || memberList == null || memberList.size() == 0) {
            return null;
        }
        MbgFunctionHelper.checkFunctionParam(functionName);
        StringBuffer functionNameStr = new StringBuffer();
        functionNameStr.append(functionName).append(LEFT_BRACKET);
        BgDimensionMember curMember = null;
        for (int i = 0; i < memberList.size(); ++i) {
            curMember = memberList.get(i);
            functionNameStr.append("\"");
            functionNameStr.append(curMember.getSrcNumber()).append(SPLITTER_TWO).append(curMember.getNumber());
            functionNameStr.append("\"");
            functionNameStr.append(",");
        }
        if (functionNameStr.length() > 0) {
            functionNameStr = functionNameStr.delete(functionNameStr.length() - 1, functionNameStr.length());
        }
        functionNameStr.append(RIGHT_BRACKET);
        return functionNameStr.toString();
    }

    public static String buildFunctionMultiSimpleStr(String functionName, List<BgDimensionMember> memberList, BgMemberSelectTypeEnum selectType, String srcNum) {
        if (StringUtils.isEmpty((String)functionName) || memberList == null || memberList.size() == 0 || selectType == null) {
            return null;
        }
        MbgFunctionHelper.checkFunctionParam(functionName);
        StringBuffer functionNameStr = new StringBuffer();
        functionNameStr.append(functionName).append(LEFT_BRACKET);
        BgDimensionMember curMember = null;
        String srcNumber = null;
        if (BgMemberSelectTypeEnum.Member.equals((Object)selectType)) {
            functionNameStr.append("MBR").append(SPLITTER_TWO).append("[").append("\"");
        } else if (BgMemberSelectTypeEnum.Variate.equals((Object)selectType)) {
            functionNameStr.append("VAR").append(SPLITTER_TWO).append("[").append("\"");
        } else if (BgMemberSelectTypeEnum.Function.equals((Object)selectType)) {
            // empty if block
        }
        for (int i = 0; i < memberList.size(); ++i) {
            curMember = memberList.get(i);
            if (i == 0) {
                if (BgMemberSelectTypeEnum.Member.equals((Object)selectType)) {
                    srcNumber = curMember.getSrcNumber();
                    functionNameStr.append(srcNumber).append(SPLITTER_TWO);
                } else if (BgMemberSelectTypeEnum.Variate.equals((Object)selectType)) {
                    // empty if block
                }
            }
            functionNameStr.append(curMember.getNumber());
            functionNameStr.append(",");
        }
        if (functionNameStr.length() > 0) {
            functionNameStr = functionNameStr.delete(functionNameStr.length() - 1, functionNameStr.length());
        }
        if (BgMemberSelectTypeEnum.Member.equals((Object)selectType) || BgMemberSelectTypeEnum.Variate.equals((Object)selectType)) {
            functionNameStr.append("\"").append("]");
        }
        functionNameStr.append(RIGHT_BRACKET);
        return functionNameStr.toString();
    }

    public static String transExprSimpleToFormat(String script) {
        if (StringUtils.isEmpty((String)script)) {
            return null;
        }
        String simpleStr = script;
        String simpleFunFormatReg = "(FX:\\[@(:?MAX|MIN|AVG|IsMember)\\((:?MBR|VAR):\\[[\\S\\s]+\\]\\)\\])";
        Pattern pattern = Pattern.compile(simpleFunFormatReg);
        Matcher matcher = pattern.matcher(script);
        String matcherStr = null;
        String funName = null;
        String funParam = null;
        StringBuffer buff = null;
        while (matcher.find()) {
            matcherStr = matcher.group();
            funName = matcherStr.substring(matcherStr.indexOf("@") + 1, matcherStr.indexOf(LEFT_BRACKET));
            funParam = matcherStr.substring(matcherStr.indexOf(funName) + 4, matcherStr.lastIndexOf(RIGHT_BRACKET));
            if (funName.equals("IsMember")) {
                funParam = matcherStr.substring(matcherStr.indexOf(funName) + 9, matcherStr.lastIndexOf(RIGHT_BRACKET));
            }
            String selectType = null;
            String srcNumber = null;
            String numbers = null;
            String[] srcNums = null;
            String[] nums = null;
            if (!"MAX".equals(funName) && !"MIN".equals(funName) && !"AVG".equals(funName) && !"IsMember".equals(funName) || funParam.indexOf("@") != -1) continue;
            selectType = funParam.substring(0, funParam.indexOf(SPLITTER_TWO));
            numbers = funParam.substring(funParam.indexOf("\"") + 1, funParam.lastIndexOf("\""));
            srcNums = numbers.split(SPLITTER_TWO);
            if (srcNums.length == 2) {
                buff = new StringBuffer();
                srcNumber = srcNums[0];
                nums = srcNums[1].split(",");
                for (int i = 0; i < nums.length; ++i) {
                    buff.append(selectType).append(SPLITTER_TWO).append("[").append("\"").append(srcNumber).append(SPLITTER_TWO).append(nums[i]).append("\"").append("]").append(",");
                }
                if (buff.length() > 0) {
                    buff.delete(buff.length() - 1, buff.length());
                }
            }
            if (buff == null) continue;
            simpleStr = simpleStr.replace(funParam, buff.toString());
        }
        return simpleStr;
    }

    public static String transExprFormatToSimple(String script) {
        if (StringUtils.isEmpty((String)script)) {
            return null;
        }
        String simpleStr = script;
        String simpleFunFormatReg = "FX:\\[@(:?MAX|MIN|AVG|IsMember)\\((:?MBR|VAR|IsMember):\\[[\\S\\s]+\\]\\)\\]";
        Pattern pattern = Pattern.compile(simpleFunFormatReg);
        Matcher matcher = pattern.matcher(script);
        String matcherStr = null;
        String funName = null;
        String funParam = null;
        StringBuffer buff = null;
        while (matcher.find()) {
            matcherStr = matcher.group();
            funName = matcherStr.substring(matcherStr.indexOf("@") + 1, matcherStr.indexOf(LEFT_BRACKET));
            funParam = matcherStr.substring(matcherStr.indexOf(funName) + 4, matcherStr.lastIndexOf(RIGHT_BRACKET));
            if (funName.equals("IsMember")) {
                funParam = matcherStr.substring(matcherStr.indexOf(funName) + 9, matcherStr.lastIndexOf(RIGHT_BRACKET));
            }
            String selectType = null;
            String srcNumber = null;
            String number = null;
            String src = null;
            String num = null;
            String[] srcNums = null;
            String[] nums = null;
            if (!"MAX".equals(funName) && !"MIN".equals(funName) && !"AVG".equals(funName) && !"IsMember".equals(funName) || funParam.indexOf("@") != -1) continue;
            buff = new StringBuffer();
            selectType = funParam.substring(0, funParam.indexOf(SPLITTER_TWO));
            nums = funParam.split(",");
            if (nums.length > 1 && nums[0].trim().startsWith("MBR:[") && !nums[1].trim().startsWith("MBR:[")) {
                nums = new String[]{funParam};
            }
            buff.append(selectType).append(SPLITTER_TWO).append("[").append("\"");
            for (int i = 0; i < nums.length; ++i) {
                srcNumber = nums[i];
                number = srcNumber.substring(srcNumber.indexOf("\"") + 1, srcNumber.lastIndexOf("\""));
                srcNums = number.split(SPLITTER_TWO);
                if (srcNums.length < 2) {
                    return simpleStr;
                }
                src = srcNums[0];
                num = srcNums[1];
                if (i == 0) {
                    buff.append(src).append(SPLITTER_TWO);
                }
                buff.append(num).append(",");
            }
            if (buff.length() > 0) {
                buff.delete(buff.length() - 1, buff.length());
            }
            buff.append("\"").append("]");
            simpleStr = simpleStr.replace(funParam, buff.toString());
        }
        return simpleStr;
    }

    public static String getFunctionKey(Map<String, BgDimensionMember> functionMember) {
        String functionNameStr = null;
        return functionNameStr;
    }

    private static void checkFunctionParam(String functionName) {
    }

    public static String getSrcNumber(String number) {
        HashMap<String, String> srcNumMap = new HashMap<String, String>();
        if (dimColls == null) {
            try {
                dimColls = DimUtils.getDimensionColls(null);
            }
            catch (BOSException e) {
                logger.error((Object)"load dim error");
            }
        }
        for (int i = 0; i < dimColls.size(); ++i) {
            srcNumMap.put(dimColls.get(i).getNumber(), dimColls.get(i).getSrcNumber());
            srcFieldMap.put(dimColls.get(i).getSrcNumber(), dimColls.get(i).getRefField());
        }
        return (String)srcNumMap.get(number);
    }

    public static String getSrcFieldNumber(String srcNumber) {
        if (srcFieldMap.isEmpty()) {
            try {
                dimColls = DimUtils.getDimensionColls(null);
            }
            catch (BOSException e) {
                logger.error((Object)"load dim error");
            }
        }
        for (int i = 0; i < dimColls.size(); ++i) {
            srcFieldMap.put(dimColls.get(i).getSrcNumber(), dimColls.get(i).getRefField());
        }
        return srcFieldMap.get(srcNumber);
    }

    public static String getFunctionNameByFunParam(String functionParam) {
        String functionName = null;
        if (StringUtils.isEmpty((String)functionParam) || functionParam.indexOf(LEFT_BRACKET) == -1) {
            return functionName;
        }
        functionName = functionParam.substring(0, functionParam.indexOf(LEFT_BRACKET));
        if (functionName.startsWith("FX")) {
            functionName = functionName.substring(4);
        }
        return functionName;
    }

    public static String getRefNumByFunction(String functionStr) {
        String refNum = null;
        if (StringUtils.isEmpty((String)functionStr)) {
            return refNum;
        }
        String param = functionStr.substring(functionStr.indexOf(LEFT_BRACKET) + 1, functionStr.indexOf(RIGHT_BRACKET));
        String srcNum = param.split(SPLITTER_TWO)[0].replace("\"", "");
        refNum = MbgFunctionHelper.getSrcFieldNumber(srcNum);
        return refNum;
    }

    public static boolean IsNativeFunction(String functionName) {
        boolean isLocalFunction = false;
        if (StringUtils.isEmpty((String)functionName)) {
            return isLocalFunction;
        }
        if (nativeFunction.contains(functionName)) {
            isLocalFunction = true;
        }
        return isLocalFunction;
    }

    public static String getOtherFunctionName(String condition) {
        if (StringUtil.isEmpty((String)condition)) {
            return null;
        }
        String funName = null;
        if (condition.indexOf("IsAncest") != -1) {
            funName = SIMANCESTORS;
        } else if (condition.indexOf("IsChild") != -1) {
            funName = SIMCHILDREN;
        } else if (condition.indexOf("IsIAncest") != -1) {
            funName = SIMIANCESTORS;
        } else if (condition.indexOf("IsDescendants") != -1) {
            funName = SIMDESCENDANTS;
        } else if (condition.indexOf("IsParent") != -1) {
            funName = "Parent";
        } else if (condition.indexOf("IsSibling") != -1) {
            funName = SIMSIBLINGS;
        } else if (condition.indexOf("IsIChild") != -1) {
            funName = SIMICHILDRENS;
        } else if (condition.indexOf("IsIDesc") != -1) {
            funName = SIMIDESCENDANTS;
        } else if (condition.indexOf("IsIParent") != -1) {
            funName = "IParent";
        } else if (condition.indexOf("IsISibling") != -1) {
            funName = SIMISIBLINGS;
        } else if (condition.indexOf("IsMember") != -1) {
            funName = "Member";
        }
        return funName;
    }

    public static String buildFunctionRemoveStr(String funtionName, MbgViewListResultData resultMembersOne, MbgViewListResultData resultMembersTwo) {
        int i;
        if (resultMembersOne == null || resultMembersTwo == null || StringUtils.isEmpty((String)funtionName)) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        List tmpMems = resultMembersOne.getMembers();
        BgDimensionMember tmpDimMem = null;
        boolean isFun = false;
        buffer.append(funtionName);
        buffer.append(LEFT_BRACKET);
        buffer.append("L1:");
        for (i = 0; i < tmpMems.size(); ++i) {
            if (tmpMems.get(i) instanceof BgDimensionMember) {
                tmpDimMem = (BgDimensionMember)tmpMems.get(i);
                boolean bl = isFun = tmpDimMem.getNumber().indexOf("@") != -1;
                if (i == 0 && !isFun && tmpDimMem.getSrcNumber() != null || i == 0 && BgMemberSelectTypeEnum.Member.equals((Object)resultMembersOne.getMemberType())) {
                    buffer.append("MBR:[").append(tmpDimMem.getSrcNumber()).append(SPLITTER_TWO);
                } else if (i == 0 && isFun || BgMemberSelectTypeEnum.Function.equals((Object)resultMembersOne.getMemberType())) {
                    buffer.append("FX:[");
                } else if (i == 0) {
                    buffer.append("VAR:[");
                }
                buffer.append(tmpDimMem.getNumber());
                if (BgMemberSelectTypeEnum.Member.equals((Object)resultMembersOne.getMemberType()) && tmpDimMem.getFillType() != 0) {
                    buffer.append("!").append(tmpDimMem.getFillType());
                }
            }
            buffer.append(",");
        }
        if (buffer.length() > 0) {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
        buffer.append("]");
        buffer.append(",");
        buffer.append("L2:");
        tmpMems = resultMembersTwo.getMembers();
        for (i = 0; i < resultMembersTwo.getMembers().size(); ++i) {
            if (tmpMems.get(i) instanceof BgDimensionMember) {
                tmpDimMem = (BgDimensionMember)tmpMems.get(i);
                boolean bl = isFun = tmpDimMem.getNumber().indexOf("@") != -1;
                if (i == 0 && !isFun && tmpDimMem.getSrcNumber() != null) {
                    buffer.append("MBR:[").append(tmpDimMem.getSrcNumber()).append(SPLITTER_TWO);
                } else if (i == 0 && isFun || BgMemberSelectTypeEnum.Function.equals((Object)resultMembersOne.getMemberType())) {
                    buffer.append("FX:[");
                } else if (i == 0) {
                    buffer.append("VAR:[");
                }
                buffer.append(tmpDimMem.getNumber());
                if (BgMemberSelectTypeEnum.Member.equals((Object)resultMembersOne.getMemberType()) && tmpDimMem.getFillType() != 0) {
                    buffer.append("!").append(tmpDimMem.getFillType());
                }
            }
            buffer.append(",");
        }
        if (buffer.length() > 0) {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
        buffer.append("]");
        buffer.append(RIGHT_BRACKET);
        return buffer.toString();
    }

    public static String getMemberNumber(String number) {
        if (number.indexOf("!") >= 0 && number.indexOf("!") == number.length() - 2) {
            return number.substring(0, number.indexOf("!"));
        }
        return number;
    }

    public static int getFillType(String number) {
        if (number.indexOf("!") >= 0 && number.indexOf("!") == number.length() - 2) {
            return Integer.parseInt(number.substring(number.indexOf("!") + 1));
        }
        return 0;
    }

    public static String buildFucntionIsMemberStr(String funcName, MbgViewListResultData resultMembers) {
        if (StringUtils.isEmpty((String)funcName) || resultMembers == null || resultMembers.isEmpty()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        List tmpMems = resultMembers.getMembers();
        BgDimensionMember tmpDimMem = null;
        boolean isFun = false;
        buffer.append(funcName);
        buffer.append(LEFT_BRACKET);
        for (int i = 0; i < tmpMems.size(); ++i) {
            if (tmpMems.get(i) instanceof BgDimensionMember) {
                tmpDimMem = (BgDimensionMember)tmpMems.get(i);
                boolean bl = isFun = tmpDimMem.getNumber().indexOf("@") != -1;
                if (!isFun && tmpDimMem.getSrcNumber() != null) {
                    buffer.append("MBR:[");
                    buffer.append("\"");
                    buffer.append(tmpDimMem.getSrcNumber()).append(SPLITTER_TWO);
                    buffer.append(tmpDimMem.getNumber());
                    buffer.append("\"");
                    buffer.append("]");
                } else if (i == 0 && isFun) {
                    buffer.append("FX:[");
                    buffer.append(tmpDimMem.getNumber());
                } else if (i == 0) {
                    buffer.append("VAR:[");
                    buffer.append(tmpDimMem.getNumber());
                }
            }
            buffer.append(",");
        }
        if (buffer.length() > 0) {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
        buffer.append("]");
        buffer.append(RIGHT_BRACKET);
        return buffer.toString();
    }

    public static Set<String> getMemNumByScopeMemFunction(String function) {
        HashSet<String> srcNumSets = new HashSet<String>();
        if (StringUtils.isEmpty((String)function) || function.indexOf("@") == -1) {
            return srcNumSets;
        }
        if (function.indexOf(REMOVE) == -1) {
            String member = function.substring(function.indexOf(LEFT_BRACKET) + 1, function.indexOf(RIGHT_BRACKET) - 1).split(",")[0];
            if (member.startsWith("\"")) {
                member = member.substring(1);
            }
            if (member.endsWith("\"")) {
                member = member.substring(0, member.length() - 1);
            }
            srcNumSets.add(member);
        } else {
            String param = function.substring(function.indexOf(LEFT_BRACKET), function.lastIndexOf(RIGHT_BRACKET));
            String listOne = param.substring(param.indexOf("[") + 1, param.indexOf("L2") - 2);
            String listTwoTmp = param.substring(param.indexOf("L2"), param.lastIndexOf("]"));
            String listTwo = listTwoTmp.substring(listTwoTmp.indexOf("[") + 1);
            srcNumSets.addAll(MbgFunctionHelper.getMemNumByListStr(listOne));
            srcNumSets.addAll(MbgFunctionHelper.getMemNumByListStr(listTwo));
        }
        return srcNumSets;
    }

    private static Set<String> getMemNumByListStr(String listStr) {
        HashSet<String> srcNumSets = new HashSet<String>();
        if (StringUtils.isEmpty((String)listStr)) {
            return srcNumSets;
        }
        if (listStr.indexOf("@") != -1) {
            String[] functions = listStr.split(", ");
            for (int i = 0; i < functions.length; ++i) {
                String member = functions[i].substring(functions[i].indexOf(LEFT_BRACKET) + 1, functions[i].indexOf(RIGHT_BRACKET)).split(",")[0];
                srcNumSets.add(member.replace("\"", ""));
            }
        } else if (listStr.indexOf(SPLITTER_TWO) != -1) {
            String[] funParam = listStr.split(SPLITTER_TWO);
            String srcType = funParam[0];
            String[] numbers = funParam[1].split(",");
            for (int i = 0; i < numbers.length; ++i) {
                srcNumSets.add(srcType + SPLITTER_TWO + MbgFunctionHelper.getMemberNumber(numbers[i]));
            }
        } else {
            String[] funParam = listStr.split(",");
            for (int i = 0; i < funParam.length; ++i) {
                srcNumSets.add(funParam[i]);
            }
        }
        return srcNumSets;
    }

    public static boolean verifyFormula(String formulaName, String formula) {
        Pattern pattern = null;
        Pattern memPattern = null;
        Matcher matcher = null;
        Matcher memMatcher = null;
        String reg = null;
        String regMemFun = null;
        if (formulaName.equals("FX")) {
            String functionName = MbgFunctionHelper.getFunctionNameByFunParam(formula);
            if (functionName == null) {
                return false;
            }
            if (functionName.equals(ABS)) {
                reg = "^FX:\\[@ABS\\([\\S\\s]*\\)\\]";
            } else if (functionName.indexOf(MAX) != -1 || functionName.indexOf(MIN) != -1 || functionName.indexOf(AVG) != -1) {
                reg = "^FX:\\[@(?:MAX|MIN|AVG)\\((:?(:?MBR|VAR):\\[[\\s\\S]+\\],)*(MBR|VAR):\\[[\\s\\S]+\\]\\)\\]";
                regMemFun = "^FX:\\[@(?:MAX|MIN|AVG)\\([\\S\\s]*\\)\\]";
            } else if (functionName.indexOf("@IsMember") != -1) {
                reg = "^FX:\\[@(?:IsMember)\\((:?(:?MBR|VAR|@.*):\\[[\\s\\S]+\\],)*(MBR|VAR|@.*):\\[[\\s\\S]+\\]\\)\\]";
                regMemFun = "^FX:\\[@(?:IsMember)\\([\\S\\s]*\\)\\]";
            } else {
                reg = "^FX:\\[@\\w+\\((,?\"?\\w{3}:[\\w|.|-]+\"?|,?\"(true|false)?\")+\\)\\]";
            }
        }
        pattern = Pattern.compile(reg);
        matcher = pattern.matcher(formula);
        if (!StringUtils.isEmpty(regMemFun)) {
            memPattern = Pattern.compile(regMemFun);
            memMatcher = memPattern.matcher(formula);
        }
        if (matcher.matches()) {
            return true;
        }
        return memMatcher != null && memMatcher.matches();
    }

    public static boolean isExprSimple(String script) {
        if (StringUtils.isEmpty((String)script)) {
            return false;
        }
        String simpleFunFormatReg = "(FX:\\[@(MAX|MIN|AVG|IsMember)\\(MBR:\\[\"[\\w]+:(([\\w-]+\\.)*[\\w-]+,)*([\\w-]+\\.)*[\\w-]+\"\\]\\)\\])";
        Pattern pattern = Pattern.compile(simpleFunFormatReg);
        Matcher matcher = pattern.matcher(script);
        if (matcher.find()) {
            return true;
        }
        simpleFunFormatReg = "(FX:\\[@(MAX|MIN|AVG)\\(VAR:\\[\"(([\\w-]+\\.)*[\\w-]+,)*([\\w-]+\\.)*[\\w-]+\"\\]\\)\\])";
        pattern = Pattern.compile(simpleFunFormatReg);
        matcher = pattern.matcher(script);
        return matcher.find();
    }
}

