/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.utils.BgCodeNumberHelper;
import com.kingdee.eas.ma.base.utils.BgCodeNumberNHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.mbg.BgActualRecordCollection;
import com.kingdee.eas.ma.mbg.BgActualRecordException;
import com.kingdee.eas.ma.mbg.BgActualRecordFacadeFactory;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgActualRecordStateEnum;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.IBgActualRecordFacade;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.app.AbstractBgActualRecordControllerBean;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNExpressionHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgActualRecordControllerBean
extends AbstractBgActualRecordControllerBean {
    private static final long serialVersionUID = -15990543019848274L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgActualRecordControllerBean");

    private void deleteBgActualData(Context ctx, BgActualRecordInfo model) throws BOSException, EASBizException {
        if (ctx == null || model == null) {
            return;
        }
        String billId = model.getId().toString();
        String orgUnitId = model.getBgForm().getOrgUnit().getId().toString();
        BgSchemeInfo root = BgViewServerHelper.getBgSchemeCubeInfo(ctx, model.getBgForm().getBgScheme());
        if (root == null) {
            return;
        }
        String cubeName = root.getRefCube();
        String actualName = BgCubeUtils.getDailyActualCubeName(cubeName);
        String entryName = BgCubeUtils.getDailyActualEntryCubeName(cubeName);
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            StringBuffer query = new StringBuffer();
            query.append("select TOP 1 FID From " + actualName + " Where FID IN (Select FDataID From " + entryName + " Where FFormID = ?) and FState <> " + 1 + " AND FORGUNITID = '" + orgUnitId + "'");
            rst = BgDBUtils.executeQuery((Connection)conn, (String)query.toString(), (Object[])new Object[]{billId});
            if (rst.next()) {
                throw new BgActualRecordException(BgActualRecordException.CANTDELETEOFDATA, new String[]{model.getNumber()});
            }
            SQLUtils.cleanup((ResultSet)rst);
            BgDBUtils.executeUpdate((Connection)conn, (String)("delete from " + entryName + " where FFormID = ?"), (Object[])new Object[]{billId});
            StringBuffer sql = new StringBuffer();
            sql.append("delete from " + actualName + " where FOrgUnitId = ? and not exists (Select FDataID From " + entryName + " Where FDataID = " + actualName + ".FID)");
            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{orgUnitId});
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("state");
        sic.add("bgForm.orgUnit.id");
        sic.add("bgForm.bgScheme.id");
        sic.add("bgForm.bgScheme.number");
        BgActualRecordInfo model = this.getBgActualRecordInfo(ctx, pk, sic);
        String _billId = pk.toString();
        IMutexServiceControl imc = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            if (!imc.requestObjIDForUpdate(_billId)) {
                throw new BgActualRecordException(BgActualRecordException.CANTDELETEOFNOTCTRL, new String[]{model.getNumber()});
            }
        }
        finally {
            imc.releaseObjIDForUpdate(_billId);
        }
        if (model.getState().getValue() != 1) {
            throw new BgActualRecordException(BgActualRecordException.CANTDELETEOFSTATE, new String[]{model.getNumber()});
        }
        this.deleteBgActualData(ctx, model);
        String OUID = model.getBgForm().getOrgUnit().getId().toString();
        BgCodeNumberNHelper.recycleNumber((Context)ctx, (IObjectValue)model, (String)OUID, (String)model.getNumber());
        super._delete(ctx, pk);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this._save(ctx, model, null);
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model, Map actualData) throws BOSException, EASBizException {
        IRowSet rst;
        Connection conn;
        IObjectPK pk;
        block14: {
            if (ctx == null || model == null || !(model instanceof BgActualRecordInfo)) {
                return null;
            }
            BgActualRecordInfo recordInfo = (BgActualRecordInfo)model;
            byte[] bookData = recordInfo.getData();
            BgViewServerHelper.removeStateLock((BgActualRecordInfo)model);
            String OUID = recordInfo.getBgForm().getOrgUnit().getId().toString();
            if (StringUtils.isEmpty((String)recordInfo.getName())) {
                BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)model, (String)OUID, (String)"sourceType", (String)"name");
                if (StringUtils.isEmpty((String)recordInfo.getName())) {
                    recordInfo.setName("BgActual-" + System.currentTimeMillis());
                }
            }
            if (StringUtils.isEmpty((String)recordInfo.getNumber())) {
                BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)model, (String)OUID, (String)"sourceType", (String)"number");
                if (StringUtils.isEmpty((String)recordInfo.getNumber())) {
                    recordInfo.setNumber("BgActual-" + System.currentTimeMillis());
                }
            }
            pk = super._save(ctx, model);
            recordInfo.setData(bookData);
            BgFormInfo bgFormInfo = recordInfo.getBgForm();
            BgSchemeInfo schemeInfo = bgFormInfo.getBgScheme();
            BgTemplateInfo templateInfo = bgFormInfo.getBgTemplate();
            BgPeriodInfo bgPeriodInfo = bgFormInfo.getBgPeriod();
            CurrencyInfo currencyInfo = bgFormInfo.getCurrency();
            BgPeriodInfo actualPeriod = recordInfo.getBgPeriod();
            String bgSchemeId = schemeInfo.getId().toString();
            String rootTemplateId = templateInfo.getRootId().toString();
            String currencyId = currencyInfo.getId().toString();
            String bgPeriodId = bgPeriodInfo.getId().toString();
            String acPeriodId = actualPeriod.getId().toString();
            Map bgActualMap = actualData;
            Map.Entry entry2 = null;
            Map.Entry dEntry2 = null;
            Map dataMap = null;
            HashMap actualDataMap = new HashMap();
            String bgActualRecordId = null;
            String orgUnitId = null;
            StringBuffer sql = new StringBuffer();
            sql.append("select t.FID, t.FState, f.FState from T_MBG_BgActualRecord t join T_MBG_BgForm f on t.FBgFormID = f.FID join T_MBG_BgTemplate te on f.FBgTemplateID = te.FID where f.FOrgUnitID = ? and f.FBgSchemeId = ? and te.FRootID = ? and f.FCurrencyID = ? and f.FBgPeriodID = ? and t.FBgPeriodID = ?");
            int bgState = 1;
            int acState = 1;
            BgActualRecordInfo tmpInfo = null;
            IBgActualRecordFacade facade = null;
            conn = null;
            rst = null;
            try {
                facade = BgActualRecordFacadeFactory.getLocalInstance(ctx);
                if (bgActualMap != null && !bgActualMap.isEmpty()) {
                    conn = this.getConnection(ctx);
                    for (Map.Entry entry2 : bgActualMap.entrySet()) {
                        orgUnitId = (String)entry2.getKey();
                        dataMap = (Map)entry2.getValue();
                        if (dataMap == null || dataMap.isEmpty()) continue;
                        rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{orgUnitId, bgSchemeId, rootTemplateId, currencyId, bgPeriodId, acPeriodId});
                        if (rst.next()) {
                            bgActualRecordId = rst.getString(1);
                            acState = rst.getInt(2);
                            bgState = rst.getInt(3);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                        if (StringUtils.isEmpty((String)bgActualRecordId)) continue;
                        tmpInfo = (BgActualRecordInfo)this._getValue(ctx, (IObjectPK)new ObjectStringPK(bgActualRecordId), BgActualRecordControllerBean.getSelectors());
                        actualDataMap.clear();
                        for (Map.Entry dEntry2 : dataMap.entrySet()) {
                            if (dEntry2.getValue() == null) {
                                actualDataMap.put(dEntry2.getKey(), null);
                                continue;
                            }
                            if (!((BgNViewDataInfo)dEntry2.getValue()).isCanSave()) continue;
                            actualDataMap.put(dEntry2.getKey(), ((BgNViewDataInfo)dEntry2.getValue()).getAddActualNoDef());
                        }
                        facade.writeBgActual(tmpInfo, actualDataMap);
                    }
                    break block14;
                }
                facade.writeBgActual(recordInfo, null);
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"save BgAcrualRecord Error:", (Throwable)ex);
                    throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, null, conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup(rst, null, (Connection)conn);
        return pk;
    }

    public static SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("createTime");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("lastUpdateTime");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("bgForm.orgUnit.id");
        sic.add("bgForm.orgUnit.name");
        sic.add("bgForm.orgUnit.number");
        sic.add("bgForm.bgScheme.id");
        sic.add("bgForm.bgScheme.name");
        sic.add("bgForm.bgScheme.number");
        sic.add("bgForm.bgTemplate.id");
        sic.add("bgForm.bgTemplate.name");
        sic.add("bgForm.bgTemplate.number");
        sic.add("bgForm.bgTemplate.root.id");
        sic.add("bgForm.bgPeriod.id");
        sic.add("bgForm.bgPeriod.name");
        sic.add("bgForm.bgPeriod.number");
        sic.add("bgForm.currency.id");
        sic.add("bgForm.currency.name");
        sic.add("bgForm.currency.number");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        return sic;
    }

    @Override
    protected void _addNewInNewTx(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._addnew(ctx, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgActualRecordInfo actual = (BgActualRecordInfo)model;
        if (actual.getCU() == null) {
            actual.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        String id = actual.getId() == null ? "xxx" : actual.getId().toString();
        String bgFormId = actual.getBgForm().getId().toString();
        String periodId = actual.getBgPeriod().getId().toString();
        this._checkBgPeriodAcross(ctx, id, bgFormId, periodId);
        String OUID = actual.getBgForm().getOrgUnit().getId().toString();
        if (StringUtils.isEmpty((String)actual.getName())) {
            BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)model, (String)OUID, (String)"sourceType", (String)"name");
            if (StringUtils.isEmpty((String)actual.getName())) {
                actual.setName("BgActual-" + System.currentTimeMillis());
            }
        }
        if (StringUtils.isEmpty((String)actual.getNumber())) {
            BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)model, (String)OUID, (String)"sourceType", (String)"number");
            if (StringUtils.isEmpty((String)actual.getNumber())) {
                actual.setNumber("BgActual-" + System.currentTimeMillis());
            }
        }
        if (actual.getBgForm() != null && actual.getBgForm().getOrgUnit() != null && actual.getBgForm().getBgScheme() != null && this._exists(ctx, "where bgForm.bgScheme.id = '" + actual.getBgForm().getBgScheme().getId() + "' AND bgForm.orgUnit.id = '" + actual.getBgForm().getOrgUnit().getId() + "' and number = '" + actual.getNumber() + "'")) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{actual.getNumber()});
        }
        return super._addnew(ctx, model);
    }

    @Override
    protected void _checkBgPeriodAcross(Context ctx, String id, String bgFormId, String bgPeriodId) throws BOSException, EASBizException {
        String sql = "select a.FId from T_MBG_BgActualRecord a  where a.FBgPeriodId = ?  and a.FId <> ? and a.fbgformid = ?";
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, bgPeriodId);
            ps.setString(2, id);
            ps.setString(3, bgFormId);
            rs = ps.executeQuery();
            if (rs.next()) {
                throw new BgActualRecordException(BgActualRecordException.EXISTACROSSBGPERIOD);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
    }

    @Override
    protected Map _queryActualData(Context ctx, IObjectValue bgActualRecordInfo, BOSUuid bgOrgViewId) throws BOSException, EASBizException {
        Map bgDataMap = new HashMap();
        if (bgActualRecordInfo == null) {
            return bgDataMap;
        }
        long _startTime = System.currentTimeMillis();
        logger.info((Object)"invoke begin load bgData!");
        BgActualRecordInfo actualRecord = (BgActualRecordInfo)bgActualRecordInfo;
        byte[] bytes = null;
        if (actualRecord.getDimensionData() != null) {
            bytes = actualRecord.getDimensionData();
        } else {
            BgActualRecordCollection col = this.getBgActualRecordCollection(ctx, "select dimensionData where id = '" + actualRecord.getId() + "'");
            if (col != null && !col.isEmpty()) {
                bytes = col.get(0).getDimensionData();
            }
        }
        IMbgViewManager view = null;
        if (bytes != null) {
            try {
                view = new MbgXMLParser(ctx).parse(bytes);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                throw e;
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        if (view == null || view.getSheetManagers() == null || view.getSheetManagers().isEmpty()) {
            return this.getActualValue(ctx, actualRecord);
        }
        BgPeriodInfo bgPeriod = null;
        bgPeriod = actualRecord.isIsEditByPeriod() ? actualRecord.getBgPeriod() : actualRecord.getBgForm().getBgPeriod();
        DimensionCommonHelper.fillDefaultMembers(actualRecord.getBgForm().getCurrency(), bgPeriod, BgVersionHelper.getSysVersionInfo((Context)ctx), view);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("longnumber");
        CostCenterOrgUnitInfo ccOrgUnitInfo = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(actualRecord.getBgForm().getOrgUnit().getId()), sic);
        DimensionCommonHelper.convertPeriodNParam(bgPeriod, view);
        actualRecord.getBgForm().getOrgUnit().setNumber(ccOrgUnitInfo.getNumber());
        actualRecord.getBgForm().getOrgUnit().setLongNumber(ccOrgUnitInfo.getLongNumber());
        if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)actualRecord.getBgForm().getBgTemplate().getFormType())) {
            DimensionCommonHelper.putSpecialDimsToPageView(ctx, actualRecord.getBgForm(), view);
        }
        ArrayList<IBgDimensionManager> dimensionManagers = new ArrayList<IBgDimensionManager>();
        for (int i = 0; i < view.getSheetManagers().size(); ++i) {
            IBgDimensionManager dimM = view.getSheetManagers().get(i).getDimensionManager();
            dimensionManagers.add(dimM);
            BgDimensionInfo dimension = dimM.searchDimension(DimensionConstants.DEF_VERSION_NUMBER);
            if (dimension == null || !dimension.getMember().isEmpty()) continue;
            dimension.getMember().add(new BgDimensionMember(dimension.getNumber(), dimension.getAttribute(), "Ve", "Ve"));
        }
        bgDataMap = MBGFormFacadeFactory.getLocalInstance(ctx).queryBgData(null, bgActualRecordInfo, dimensionManagers, 16, false, bgOrgViewId, false, null);
        logger.info((Object)"invoke end load bgData!");
        logger.info((Object)this.outTime(_startTime));
        return bgDataMap;
    }

    private Map getActualValue(Context ctx, BgActualRecordInfo bgActualRecordInfo) throws BOSException, EASBizException {
        HashMap<String, BgNDataInfo> bgDataMap = new HashMap<String, BgNDataInfo>();
        if (bgActualRecordInfo == null) {
            return bgDataMap;
        }
        long _startTime = System.currentTimeMillis();
        logger.info((Object)"invoke begin load bgData!");
        BgSchemeInfo root = BgViewServerHelper.getBgSchemeCubeInfo(ctx, bgActualRecordInfo.getBgForm().getBgScheme());
        if (root == null) {
            return bgDataMap;
        }
        String cubeName = root.getRefCube();
        String actualName = BgCubeUtils.getActualCubeName(cubeName);
        String entryName = BgCubeUtils.getBudgetEntryCubeName(cubeName);
        BgNDataInfo dataInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FValue, FFormula, FState from " + actualName + " where FID IN (select FDataId from " + entryName + " where FFormId = ?)");
            pstmt.setString(1, bgActualRecordInfo.getId().toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                dataInfo = new BgNDataInfo();
                dataInfo.setFormula(rst.getString("FFormula"));
                dataInfo.setActualValue(rst.getBigDecimal("FValue"));
                dataInfo.setState(rst.getInt("FState"));
                bgDataMap.put(dataInfo.getFormula(), dataInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"load bgdata:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        logger.info((Object)"invoke end load bgData!");
        logger.info((Object)this.outTime(_startTime));
        return bgDataMap;
    }

    private String outTime(long startTime) {
        return new StringBuffer("invoke process use = ").append(System.currentTimeMillis() - startTime).append(" ms;").toString();
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean _batchAddnew(Context ctx, List orgUnitIds, IObjectValue model) throws BOSException, EASBizException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Set<Integer> getDefaultStates() {
        HashSet<Integer> states = new HashSet<Integer>();
        states.add(new Integer(2));
        states.add(new Integer(51));
        states.add(new Integer(50));
        states.add(new Integer(6));
        states.add(new Integer(12));
        return states;
    }

    private BgActualRecordInfo createNewRecordInfo(Context ctx, BgFormInfo bgFormInfo, BgActualRecordInfo model, Map<String, BgCodeNumberHelper> codeHelpers) throws BOSException, EASBizException {
        if (ctx == null || bgFormInfo == null || model == null) {
            return null;
        }
        BgActualRecordInfo actualRecord = new BgActualRecordInfo();
        actualRecord.setCreateTime(new Timestamp(System.currentTimeMillis()));
        actualRecord.setCreator(model.getCreator());
        actualRecord.setLastUpdateTime(actualRecord.getCreateTime());
        actualRecord.setLastUpdateUser(model.getCreator());
        actualRecord.setBgForm(bgFormInfo);
        actualRecord.setName(model.getName());
        actualRecord.setBgPeriod(model.getBgPeriod());
        actualRecord.setMeasureUnit(model.getMeasureUnit());
        actualRecord.setDescription(model.getDescription());
        actualRecord.setCompany(bgFormInfo.getCompany());
        actualRecord.setCU(model.getCU());
        actualRecord.setSourceType(model.getSourceType());
        actualRecord.setState(BgActualRecordStateEnum.Edited);
        actualRecord.setIsEditByPeriod(model.isIsEditByPeriod());
        actualRecord.setIsFormulaFromTem(model.isIsFormulaFromTem());
        if (!bgFormInfo.getEntries().isEmpty()) {
            actualRecord.setDimensionData(bgFormInfo.getEntries().get(0).getDimensionData());
            actualRecord.setDimensionStyle(bgFormInfo.getEntries().get(0).getDimensionStyle());
        }
        if (StringUtils.isEmpty((String)model.getNumber())) {
            String orgId = bgFormInfo.getOrgUnit().getId().toString();
            BgCodeNumberHelper codeHelper = null;
            if (codeHelpers == null || !codeHelpers.containsKey(orgId)) {
                codeHelper = new BgCodeNumberHelper(ctx, "number", "sourceType");
                codeHelper.init((IObjectValue)model, orgId);
                if (codeHelpers != null) {
                    codeHelpers.put(orgId, codeHelper);
                }
            } else {
                codeHelper = codeHelpers.get(orgId);
            }
            codeHelper.applyNumber((IObjectValue)actualRecord, orgId, "Bg");
        } else {
            actualRecord.setNumber(model.getNumber());
        }
        if (bgFormInfo.getData() != null) {
            Book book = null;
            try {
                book = IOHelper.unpackBook((byte[])bgFormInfo.getData());
                BgNFSHelper.disableCal(book);
                BgNFSHelper.disableUndo(book);
                BgNExpressionHelper.dealAcctExpressionAtAddNew(ctx, book, (IObjectValue)actualRecord, 2);
                actualRecord.setData(IOHelper.packBook((Book)book));
            }
            catch (Exception ex) {
                logger.error((Object)"batchAddnew ActualRecord deal Expression Error:", (Throwable)ex);
            }
        }
        return actualRecord;
    }

    @Override
    protected IObjectPK _saveView(Context ctx, IObjectValue model, Map actualDataMap, Map orgDataMap) throws BOSException, EASBizException {
        return null;
    }
}

