/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.mbg.BgActualRecordCollection;
import com.kingdee.eas.ma.mbg.BgActualRecordException;
import com.kingdee.eas.ma.mbg.BgActualRecordFactory;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgActualRecordStateEnum;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgActualRecord;
import com.kingdee.eas.ma.mbg.app.AbstractBgActualRecordFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.utils.ActualRecordControlUtils;
import com.kingdee.eas.ma.mbg.app.utils.BgActualDataFacadeImpl;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgActualRecordHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgUnAuditCheckResult;
import com.kingdee.eas.ma.mbg.utils.MBgCheckHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgActualRecordFacadeControllerBean
extends AbstractBgActualRecordFacadeControllerBean {
    private static final long serialVersionUID = 3161731527723382064L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgActualRecordFacadeControllerBean");
    private List<String> mutexSucceed = new ArrayList<String>();

    @Override
    protected void _writeBgActual(Context ctx, BgActualRecordInfo bgActualRecord) throws BOSException, EASBizException {
        this._writeBgActual(ctx, bgActualRecord, null);
    }

    @Override
    protected void _writeBgActual(Context ctx, BgActualRecordInfo bgActualRecord, Map actualData) throws BOSException, EASBizException {
        if (bgActualRecord == null || (bgActualRecord.getZipData() == null || bgActualRecord.getZipData().length == 0) && actualData == null) {
            return;
        }
        Map periodMap = null;
        if (bgActualRecord.isIsEditByPeriod()) {
            periodMap = BgActualRecordHelper.getBgPeriodColl(ctx, bgActualRecord.getBgPeriod());
        }
        BgNDataInfo data = null;
        BgActualDataFacadeImpl facade = new BgActualDataFacadeImpl(ctx, (IObjectValue)bgActualRecord);
        HashSet<String> acScenarioNums = new HashSet<String>();
        List acScenario = BgScenarioHelper.getAcScenario((Context)ctx);
        for (BgScenarioInfo scenario : acScenario) {
            acScenarioNums.add(scenario.getNumber());
        }
        String formulaStr = null;
        String bgVersionNum = null;
        String[] params = null;
        if (actualData == null) {
            Book _book = null;
            Sheet _sheet = null;
            Cell _cell = null;
            bgVersionNum = bgActualRecord.getBgForm().getBgVersion().getNumber();
            BigDecimal actualValue = null;
            try {
                _book = bgActualRecord.getBook();
            }
            catch (Exception e1) {
                throw new BOSException((Throwable)e1);
            }
            BgNFSHelper.disableCal(_book);
            BgNFSHelper.disableUndo(_book);
            HashMap<String, BgNDataInfo> bgDataMap = new HashMap<String, BgNDataInfo>();
            int _sheetSize = _book.getSheetCount();
            for (int _sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
                _sheet = _book.getSheet(_sheetIndex);
                int rowCount = _sheet.getMaxRowIndex();
                int colCount = _sheet.getMaxColIndex();
                for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                    for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                        _cell = _sheet.getCell(rowIndex, colIndex, false);
                        if (!BgNFSHelper.checkHasFormulaOfCell(_cell) || !acScenarioNums.contains((params = BgNFSHelper.parseFormulaPara(formulaStr = BgNFSHelper.getFormulaOfCell(_cell)))[3]) || _cell.isLocked() && !BgNFSHelper.checkHasExpression(_cell)) continue;
                        data = new BgNDataInfo();
                        data.setFormula(formulaStr);
                        data.splitFormula();
                        data.setBgVersion(bgVersionNum);
                        String periodNum = data.getBgPeriodNumber();
                        if (bgActualRecord.isIsEditByPeriod() && (periodMap == null || !periodMap.containsKey(periodNum))) continue;
                        Object obj = BgNFSHelper.getValue(_cell);
                        try {
                            actualValue = obj == null ? null : (obj instanceof BigDecimal ? (BigDecimal)obj : (obj instanceof String ? new BigDecimal(obj.toString()) : new BigDecimal(obj.toString())));
                        }
                        catch (NumberFormatException e) {
                            actualValue = null;
                        }
                        if (bgDataMap.containsKey(formulaStr)) {
                            data = (BgNDataInfo)bgDataMap.get(formulaStr);
                            if (!BgNFSHelper.checkUpdataValueByTime(_cell, data).booleanValue()) continue;
                            data.setActualValue(actualValue);
                            continue;
                        }
                        bgDataMap.put(formulaStr, data);
                        data.setActualValue(actualValue);
                        BgNFSHelper.checkUpdataValueByTime(_cell, data);
                        facade.addData(data);
                    }
                }
            }
        } else {
            String tmpStr = null;
            String[] tmpStrs = null;
            Map.Entry entry2 = null;
            for (Map.Entry entry2 : actualData.entrySet()) {
                tmpStr = (String)entry2.getKey();
                tmpStrs = tmpStr.split("_");
                formulaStr = tmpStrs[0];
                bgVersionNum = tmpStrs[1];
                params = BgNFSHelper.parseFormulaPara(formulaStr);
                if (!acScenarioNums.contains(params[3])) continue;
                data = new BgNDataInfo();
                data.setFormula(formulaStr);
                data.setBgVersion(bgVersionNum);
                data.setActualValue((BigDecimal)entry2.getValue());
                facade.addData(data);
            }
        }
        facade.save();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _auditBgActual(Context ctx, BOSUuid bgActualRecordId, BOSUuid userId) throws BOSException, EASBizException {
        if (bgActualRecordId == null) return;
        if (userId == null) {
            return;
        }
        IBgActualRecord iface = BgActualRecordFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("state");
        sic.add("bgForm.orgUnit.id");
        sic.add("bgForm.bgScheme.id");
        sic.add("bgForm.bgScheme.number");
        BgActualRecordInfo bgActualRecordInfo = iface.getBgActualRecordInfo((IObjectPK)new ObjectUuidPK(bgActualRecordId), sic);
        if (bgActualRecordInfo == null) {
            return;
        }
        if (1 != bgActualRecordInfo.getState().getValue()) {
            throw new BgActualRecordException(BgActualRecordException.CANTAUDIT, new String[]{bgActualRecordInfo.getNumber()});
        }
        BgSchemeInfo schemeInfo = BgViewServerHelper.getBgSchemeCubeInfo(ctx, bgActualRecordInfo.getBgForm().getBgScheme());
        if (schemeInfo == null) {
            return;
        }
        String _billId = bgActualRecordId.toString();
        String _orgUnitId = bgActualRecordInfo.getBgForm().getOrgUnit().getId().toString();
        String actualCube = BgCubeUtils.getActualCubeName(schemeInfo.getRefCube());
        String dailyTable = BgCubeUtils.getDailyActualCubeName(schemeInfo.getRefCube());
        String dailyEntry = BgCubeUtils.getDailyActualEntryCubeName(schemeInfo.getRefCube());
        List<String> refFields = BgCubeUtils.getRefDims(ctx, schemeInfo, false);
        String refFieldStr = DimUtils.getDimField(refFields);
        String tmpTableName = null;
        ArrayList<BgNViewDataInfo> datas = new ArrayList<BgNViewDataInfo>();
        BgNViewDataInfo dataInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        IRowSet rst = null;
        TempTablePool pool = null;
        IMutexServiceControl imc = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            if (!imc.requestObjIDForUpdate(_billId)) {
                throw new BgActualRecordException(BgActualRecordException.CANTDELETEOFNOTCTRL, new String[]{bgActualRecordInfo.getNumber()});
            }
            conn = this.getConnection(ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("Update " + dailyTable + " set FState = " + 9 + " where FID IN (select FDataID from " + dailyEntry + " where FFormID = ?)");
            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{_billId});
            pool = TempTablePool.getInstance((Context)ctx);
            sql = new StringBuffer();
            sql.append("CREATE TABLE TEMPTABLE (FFormula NVARCHAR(300), FVersion INT DEFAULT 0 NOT NULL)");
            tmpTableName = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)sql.toString());
            sql = new StringBuffer();
            sql.append("Insert Into " + tmpTableName + "(FFormula, FVersion) Select FFormula, FVersion from " + actualCube + " where FOrgUnitId = ?");
            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new String[]{_orgUnitId});
            sql = new StringBuffer();
            sql.append("Insert Into " + actualCube + "(FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitID, FFormula, FValue, FTmpValue, " + refFieldStr + ",FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FIsUpdate)  Select FID, FCreatorID, FCreateTime, FLastUpdateUserID,  FLastUpdateTime, FOrgUnitID, FFormula, FValue, FValue, " + refFieldStr + ", FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, 1  from " + dailyTable + " where FID IN (select FDataID from " + dailyEntry + " where FFormID = ?) AND NOT EXISTS (Select * from " + tmpTableName + " where " + dailyTable + ".FFormula = FFormula and " + dailyTable + ".FVersion = FVersion)");
            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new String[]{_billId});
            sql = new StringBuffer();
            sql.append("Select FOrgUnitId, FFormula, FValue, FVersion from " + dailyTable + " where FID IN (select FDataID from " + dailyEntry + " where FFormID = ?) AND EXISTS (Select * from " + tmpTableName + " where " + dailyTable + ".FFormula = FFormula and " + dailyTable + ".FVersion = FVersion)");
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{_billId});
            while (rst.next()) {
                dataInfo = new BgNViewDataInfo();
                dataInfo.setOrgUnitId(rst.getString("FOrgUnitId"));
                dataInfo.setFormula(rst.getString("FFormula"));
                dataInfo.setActualValue(rst.getBigDecimal("FValue"));
                dataInfo.setBgVersionValue(rst.getInt("FVersion"));
                datas.add(dataInfo);
            }
            SQLUtils.cleanup((ResultSet)rst);
            if (!datas.isEmpty()) {
                int batchIndex = 0;
                int batchSize = 50;
                pstmt = conn.prepareStatement("Update " + actualCube + " Set FValue = FValue + ?, FTmpValue = FTmpValue + ? where FOrgUnitId = ? and FFormula = ? and FVersion = ?");
                int in = datas.size();
                for (int i = 0; i < in; ++i) {
                    dataInfo = (BgNViewDataInfo)datas.get(i);
                    pstmt.setBigDecimal(1, dataInfo.getActualValue());
                    pstmt.setBigDecimal(2, dataInfo.getActualValue());
                    pstmt.setString(3, dataInfo.getOrgUnitId());
                    pstmt.setString(4, dataInfo.getFormula());
                    pstmt.setInt(5, dataInfo.getBgVersionValue());
                    pstmt.addBatch();
                    if (++batchIndex < batchSize) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                }
                if (batchIndex > 0) {
                    pstmt.executeBatch();
                }
            }
            String[] cubeName = new String[]{dailyTable, dailyEntry, BgCubeUtils.getControlCubeName(schemeInfo.getRefCube())};
            this.writeBgCtrlRecord(ctx, bgActualRecordInfo, cubeName);
            bgActualRecordInfo.setState(BgActualRecordStateEnum.Approved);
            bgActualRecordInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
            bgActualRecordInfo.setAuditTime(new Timestamp(System.currentTimeMillis()));
            sic = new SelectorItemCollection();
            sic.add("state");
            sic.add("auditTime");
            sic.add("auditor");
            iface.updatePartial((CoreBaseInfo)bgActualRecordInfo, sic);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"auditBgActual Error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
                catch (Exception ex2) {
                    logger.error((Object)"auditBgActual Error:", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                try {
                    BgDBUtils.releaseTmpTable(pool, tmpTableName);
                }
                catch (Exception ex3) {
                    logger.error((Object)"auditBgActual Error:", (Throwable)ex3);
                }
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                imc.releaseObjIDForUpdate(_billId);
                throw throwable;
            }
        }
        try {
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTableName);
        }
        catch (Exception ex) {
            logger.error((Object)"auditBgActual Error:", (Throwable)ex);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        imc.releaseObjIDForUpdate(_billId);
    }

    @Override
    protected void _unAuditBgActual(Context ctx, BOSUuid bgActualRecordId, BOSUuid userId) throws BOSException, EASBizException {
        if (bgActualRecordId == null || userId == null) {
            return;
        }
        IBgActualRecord iface = BgActualRecordFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("state");
        sic.add("bgForm.orgUnit.id");
        sic.add("bgForm.bgScheme.id");
        sic.add("bgForm.bgScheme.number");
        BgActualRecordInfo bgActualRecordInfo = iface.getBgActualRecordInfo((IObjectPK)new ObjectUuidPK(bgActualRecordId), sic);
        if (bgActualRecordInfo == null) {
            return;
        }
        if (2 != bgActualRecordInfo.getState().getValue()) {
            throw new BgActualRecordException(BgActualRecordException.CANTUNAUDIT, new String[]{bgActualRecordInfo.getNumber()});
        }
        BgSchemeInfo schemeInfo = BgViewServerHelper.getBgSchemeCubeInfo(ctx, bgActualRecordInfo.getBgForm().getBgScheme());
        if (schemeInfo == null) {
            return;
        }
        String _billId = bgActualRecordId.toString();
        String actualCube = BgCubeUtils.getActualCubeName(schemeInfo.getRefCube());
        String dailyTable = BgCubeUtils.getDailyActualCubeName(schemeInfo.getRefCube());
        String dailyEntry = BgCubeUtils.getDailyActualEntryCubeName(schemeInfo.getRefCube());
        String conCube = BgCubeUtils.getControlCubeName(schemeInfo.getRefCube());
        ArrayList<BgNViewDataInfo> datas = new ArrayList<BgNViewDataInfo>();
        BgNViewDataInfo dataInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        IRowSet rst = null;
        String tmpTableName = null;
        TempTablePool pool = null;
        IMutexServiceControl imc = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            if (!imc.requestObjIDForUpdate(_billId)) {
                throw new BgActualRecordException(BgActualRecordException.CANTDELETEOFNOTCTRL, new String[]{bgActualRecordInfo.getNumber()});
            }
            conn = this.getConnection(ctx);
            pool = TempTablePool.getInstance((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("Select FOrgUnitId, FFormula, FValue, FVersion from " + dailyTable + " where FID IN (select FDataID from " + dailyEntry + " where FFormID = ?)");
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{_billId});
            while (rst.next()) {
                dataInfo = new BgNViewDataInfo();
                dataInfo.setOrgUnitId(rst.getString("FOrgUnitId"));
                dataInfo.setFormula(rst.getString("FFormula"));
                dataInfo.setActualValue(rst.getBigDecimal("FValue"));
                dataInfo.setBgVersionValue(rst.getInt("FVersion"));
                datas.add(dataInfo);
            }
            SQLUtils.cleanup((ResultSet)rst);
            if (!datas.isEmpty()) {
                int batchIndex = 0;
                int batchSize = 50;
                pstmt = conn.prepareStatement("Update " + actualCube + " Set FValue = FValue - ?, FTmpValue = FTmpValue - ?  where FOrgUnitId = ? and FFormula = ? and FVersion = ?");
                int in = datas.size();
                for (int i = 0; i < in; ++i) {
                    dataInfo = (BgNViewDataInfo)datas.get(i);
                    pstmt.setBigDecimal(1, dataInfo.getActualValue());
                    pstmt.setBigDecimal(2, dataInfo.getActualValue());
                    pstmt.setString(3, dataInfo.getOrgUnitId());
                    pstmt.setString(4, dataInfo.getFormula());
                    pstmt.setInt(5, dataInfo.getBgVersionValue());
                    pstmt.addBatch();
                    if (++batchIndex < batchSize) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                }
                if (batchIndex > 0) {
                    pstmt.executeBatch();
                }
            }
            sql = new StringBuffer();
            sql.append("Update " + dailyTable + " set FState = " + 1 + " where FID IN (select FDataID from " + dailyEntry + " where FFormID = ?)");
            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{_billId});
            tmpTableName = BgDBUtils.createTmpTable((TempTablePool)pool, (String)"CREATE TABLE TEMPTABLE (FFormula NVARCHAR(200), FVersion INT DEFAULT 0 NOT NULL)");
            BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + tmpTableName + "(FFormula, FVersion) Select FFormula, FVersion from " + actualCube + " where FOrgUnitId = ?"), (Object[])new String[]{bgActualRecordInfo.getBgForm().getOrgUnit().getId().toString()});
            BgDBUtils.executeUpdate((Connection)conn, (String)("Delete from " + conCube + " where FBillID = ? or (exists (select * from " + tmpTableName + " t where " + conCube + ".FFormula = t.FFormula and " + conCube + ".FVERSION = t.FVersion) and " + conCube + ".FBIZORGUNITID = ? and " + conCube + ".FBILLTYPE ='87500EF6' )"), (Object[])new Object[]{bgActualRecordId, bgActualRecordInfo.getBgForm().getOrgUnit().getId().toString()});
            bgActualRecordInfo.setState(BgActualRecordStateEnum.Edited);
            sic = new SelectorItemCollection();
            sic.add("state");
            iface.updatePartial((CoreBaseInfo)bgActualRecordInfo, sic);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"auditBgActual Error:", (Throwable)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                if (tmpTableName != null) {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpTableName);
                }
                imc.releaseObjIDForUpdate(_billId);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        if (tmpTableName != null) {
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTableName);
        }
        imc.releaseObjIDForUpdate(_billId);
    }

    @Override
    protected void _writeBgCtrlRecord(Context ctx, String bgActualRecordId) throws BOSException, EASBizException {
        if (bgActualRecordId == null) {
            throw new BgActualRecordException(BgActualRecordException.WRITECONTROLRECORDERROR);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("state");
        sic.add("bgForm.orgUnit.id");
        sic.add("bgForm.bgScheme.id");
        sic.add("bgForm.bgScheme.number");
        BgActualRecordInfo bgActualRecordInfo = BgActualRecordFactory.getLocalInstance(ctx).getBgActualRecordInfo((IObjectPK)new ObjectUuidPK(bgActualRecordId), sic);
        if (bgActualRecordInfo == null) {
            throw new BgActualRecordException(BgActualRecordException.WRITECONTROLRECORDERROR);
        }
        BgSchemeInfo schemeInfo = BgViewServerHelper.getBgSchemeCubeInfo(ctx, bgActualRecordInfo.getBgForm().getBgScheme());
        if (schemeInfo == null) {
            throw new BgActualRecordException(BgActualRecordException.WRITECONTROLRECORDERROR);
        }
        String[] cubeName = new String[]{BgCubeUtils.getDailyActualCubeName(schemeInfo.getRefCube()), BgCubeUtils.getDailyActualEntryCubeName(schemeInfo.getRefCube()), BgCubeUtils.getControlCubeName(schemeInfo.getRefCube())};
        this.writeBgCtrlRecord(ctx, bgActualRecordInfo, cubeName);
    }

    protected void writeBgCtrlRecord(Context ctx, BgActualRecordInfo bgActualRecord, String[] cubeName) throws BOSException, EASBizException {
        if (ctx == null || bgActualRecord == null || cubeName == null || cubeName.length != 3) {
            throw new BgActualRecordException(BgActualRecordException.WRITECONTROLRECORDERROR);
        }
        String dailyCube = cubeName[0];
        String dailyEntry = cubeName[1];
        String conCube = cubeName[2];
        String billId = bgActualRecord.getId().toString();
        Class<?> _class = null;
        Object _obj = null;
        Object _bosType = null;
        Method _method = null;
        try {
            _class = Class.forName("com.kingdee.eas.ma.control.BgControlRecordObj");
            if (_class != null) {
                _obj = _class.newInstance();
                _method = _class.getMethod("getBOSType", null);
                _bosType = _method.invoke(_obj, null);
            }
        }
        catch (Exception ex) {
            throw new BgActualRecordException(BgActualRecordException.WRITECONTROLRECORDERROR);
        }
        if (_bosType == null) {
            throw new BgActualRecordException(BgActualRecordException.WRITECONTROLRECORDERROR);
        }
        String bosType = _bosType.toString();
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + conCube + " (FID, FCreateTime, FBillID, FBillNumber, FBillType, FActaulAmount, FBizDate, FActualID, FBizOrgUnitID, FReqOrgUnitID, FControlType, FFormula, FBgIndexNum, FItemExtNumber, FBgPeriodID, FCurrencyID, FBgElementID, FScenario, FVersion) Select newbosid('" + bosType + "'), ?, ?, ?, ?, t.FValue, ?, ?, t.FOrgUnitId, t.FOrgUnitId, ?, FFormula, t.F2, case when t.F2 <> t.FBgItemCombination then REPLACE(t.FBgItemCombination, CONCAT(t.F2, ','), '') else t.F2 end, t.FBgPeriodId, t.FCurrencyID, t.FBgElementID, t.FScenario, t.FVersion from " + dailyCube + " t where t.FID IN (Select FDataID from " + dailyEntry + " where FFormID = ?)");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setTimestamp(1, timestamp);
            pstmt.setString(2, billId);
            pstmt.setString(3, bgActualRecord.getNumber());
            pstmt.setString(4, bosType);
            pstmt.setTimestamp(5, timestamp);
            pstmt.setString(6, bosType);
            pstmt.setInt(7, 0);
            pstmt.setString(8, billId);
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"writeBgCtrlRecord Error:", (Throwable)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected boolean _checkDupNumber(Context ctx, String bgActualRecordId, String number) throws BOSException, EASBizException {
        boolean result = false;
        if (StringUtils.isEmpty((String)bgActualRecordId)) {
            bgActualRecordId = "xxx";
        }
        if (StringUtils.isEmpty((String)number)) {
            return false;
        }
        String sql = "select count(fid) cnt from T_MBG_BgActualRecord where fid != ? and fnumber = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{bgActualRecordId, number});
        try {
            int cnt;
            if (rs.next() && (cnt = rs.getInt(1)) > 0) {
                result = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected boolean _checkCanInputActual(Context ctx, String bgActualRecordId, String bgFormId, String bgPeriodId) throws BOSException, EASBizException {
        boolean result = true;
        if (bgActualRecordId != null && bgActualRecordId.equals("")) {
            bgActualRecordId = "xxx";
        }
        String sql = "select count(fid) cnt from T_MBG_BgActualRecord where fid != ? and fbgformid = ? and fbgperiodId = ? ";
        IRowSet rs = null;
        try {
            int cnt;
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{bgActualRecordId, bgFormId, bgPeriodId});
            if (rs.next() && (cnt = rs.getInt(1)) > 0) {
                result = false;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _auditSubOrgActual(Context ctx, BOSUuid actualRecordIds, BOSUuid auditBgOrgId, BOSUuid userId, String permissionItem) throws BOSException, EASBizException {
        HashMap<String, List<String[]>> result = new HashMap<String, List<String[]>>();
        ActualRecordControlUtils actualRecordUtils = new ActualRecordControlUtils(ctx);
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(actualRecordIds.toString());
        this.mutexSucceed.addAll(ids);
        Set<String> mutexErrs = MBgCheckHelper.requestMutex(ctx, ids, false);
        if (mutexErrs == null || mutexErrs.isEmpty()) {
            try {
                result.put("auditUnAuditSuccess", actualRecordUtils.auditSubOrgActualRecord(actualRecordIds, auditBgOrgId, userId, 16, 9, permissionItem, null));
                actualRecordUtils.sysActDataWithControlRecord();
            }
            finally {
                MBgCheckHelper.releaseMutex(ctx, this.mutexSucceed);
            }
        } else {
            BgActualRecordCollection col = this.getActualRecord(ctx, new ArrayList<String>(mutexErrs));
            ArrayList<String[]> mutexErrsList = new ArrayList<String[]>();
            for (int i = 0; i < col.size(); ++i) {
                BgActualRecordInfo bgActualRecordInfo = col.get(i);
                ActualRecordControlUtils.addResult(mutexErrsList, bgActualRecordInfo);
            }
            result.put("auditMux", mutexErrsList);
        }
        return result;
    }

    @Override
    protected Map _unAuditSubOrgActual(Context ctx, BOSUuid actualRecordIds, BOSUuid auditBgOrgId, BOSUuid userId, String permissionItem) throws BOSException, EASBizException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(actualRecordIds.toString());
        return this._batchUnAuditSubOrgActual(ctx, ids, auditBgOrgId, userId, permissionItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchAuditSubOrgActual(Context ctx, List actualRecordIds, BOSUuid auditBgOrgId, BOSUuid userId, String permissionItem) throws BOSException, EASBizException {
        this.mutexSucceed.addAll(actualRecordIds);
        Map result = null;
        try {
            ArrayList<BgActualRecordStateEnum> stateEnums = new ArrayList<BgActualRecordStateEnum>();
            stateEnums.add(BgActualRecordStateEnum.Approved);
            stateEnums.add(BgActualRecordStateEnum.Approving);
            stateEnums.add(BgActualRecordStateEnum.REFERRING);
            result = this.checkActualRecord(ctx, auditBgOrgId, actualRecordIds, stateEnums);
            if (actualRecordIds.isEmpty()) {
                Map map = result;
                return map;
            }
            ArrayList<String[]> successList = new ArrayList<String[]>();
            List<String[]> tempList = null;
            result.put("auditUnAuditSuccess", successList);
            ActualRecordControlUtils actualRecordUtils = new ActualRecordControlUtils(ctx);
            HashSet<String> successIds = new HashSet<String>();
            for (int i = 0; i < actualRecordIds.size(); ++i) {
                tempList = actualRecordUtils.auditSubOrgActualRecord(BOSUuid.read((String)actualRecordIds.get(i).toString()), auditBgOrgId, userId, 16, 9, permissionItem, successIds);
                if (tempList == null) continue;
                successList.addAll(tempList);
            }
            actualRecordUtils.sysActDataWithControlRecord();
        }
        finally {
            MBgCheckHelper.releaseMutex(ctx, this.mutexSucceed);
        }
        return result;
    }

    @Override
    protected Map _batchUnAuditSubOrgActual(Context ctx, List actualRecordIds, BOSUuid auditBgOrgId, BOSUuid userId, String permissionItem) throws BOSException, EASBizException {
        ArrayList<BgActualRecordStateEnum> stateEnums = new ArrayList<BgActualRecordStateEnum>();
        stateEnums.add(BgActualRecordStateEnum.Edited);
        stateEnums.add(BgActualRecordStateEnum.Approving);
        stateEnums.add(BgActualRecordStateEnum.REFERRING);
        Map result = this.checkActualRecord(ctx, auditBgOrgId, actualRecordIds, stateEnums);
        if (actualRecordIds.isEmpty()) {
            return result;
        }
        return this.batchAntiAuditSubOrgActual(ctx, actualRecordIds, auditBgOrgId, userId, permissionItem, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Map batchAntiAuditSubOrgActual(Context ctx, List actualRecordIds, BOSUuid auditBgOrgId, BOSUuid userId, String permissionItem, Map result) throws BOSException, EASBizException {
        this.mutexSucceed.addAll(actualRecordIds);
        try {
            void var32_42;
            ActualRecordControlUtils actualRecordUtils = new ActualRecordControlUtils(ctx);
            IBgActualRecord iface = BgActualRecordFactory.getLocalInstance(ctx);
            EntityViewInfo entity = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", new HashSet(actualRecordIds), CompareType.INCLUDE));
            entity.setSelector(actualRecordUtils.getSelectorItemColls());
            entity.setFilter(filterInfo);
            BgActualRecordCollection bgActualRecordCollection = iface.getBgActualRecordCollection(entity);
            actualRecordIds.clear();
            ArrayList<String> formIds = new ArrayList<String>();
            for (int i = 0; i < bgActualRecordCollection.size(); ++i) {
                actualRecordIds.add(bgActualRecordCollection.get(i).getId().toString());
                formIds.add(bgActualRecordCollection.get(i).getBgForm().getId().toString());
            }
            BgSchemeInfo schemeInfo = BgViewServerHelper.getBgSchemeCubeInfo(ctx, bgActualRecordCollection.get(0).getBgForm().getBgScheme());
            if (schemeInfo == null) {
                Map map = result;
                return map;
            }
            String bgOrgViewId = schemeInfo.getEditOrgViewId().toString();
            Object temp = null;
            HashMap<String, BgOrgUnitInfo> orgMap = new HashMap<String, BgOrgUnitInfo>();
            BgOrgUnitCollection bgOrgUnitCollection = this.getBgOrgUnitCollectionByViewID(ctx, bgOrgViewId);
            for (int i = 0; i < bgOrgUnitCollection.size(); ++i) {
                orgMap.put(bgOrgUnitCollection.get(i).getOrgUnitID(), bgOrgUnitCollection.get(i));
            }
            Map<String, List<String>> parentOrgNumbers = this.getParentOrgNumbers(ctx, bgOrgViewId);
            Map<String, Map<String, String[]>> dealActualRecords = this.dealActualRecords(ctx, actualRecordIds, formIds, bgOrgViewId);
            Map<String, String[]> subMap = null;
            String[] orgNumbers = null;
            String[] bgFormInfos = null;
            boolean isCanUnAudit = true;
            List<String> parentNumbers = null;
            ArrayList tempParentNumbers = new ArrayList();
            HashSet<String> removedOrgNumbers = new HashSet<String>();
            for (String key : dealActualRecords.keySet()) {
                subMap = dealActualRecords.get(key);
                for (String string : orgNumbers = subMap.keySet().toArray(new String[0])) {
                    bgFormInfos = subMap.get(string);
                    if (bgFormInfos == null) continue;
                    isCanUnAudit = true;
                    if (!actualRecordIds.contains(bgFormInfos[0])) continue;
                    parentNumbers = parentOrgNumbers.get(bgFormInfos[2]);
                    if (parentNumbers != null) {
                        for (String pN : parentNumbers) {
                            if (!subMap.containsKey(pN)) continue;
                            isCanUnAudit = false;
                            break;
                        }
                    }
                    if (!isCanUnAudit) continue;
                    subMap.remove(string);
                    removedOrgNumbers.add(string);
                }
                this.deleCanUnAuditActualRecord(removedOrgNumbers, dealActualRecords, parentOrgNumbers);
            }
            ArrayList<String[]> noEditParentRecord = new ArrayList<String[]>();
            BgActualRecordInfo bgActualRecordInfo = null;
            result.put("noEditParentRecord", noEditParentRecord);
            StringBuffer resultOrgId = new StringBuffer();
            for (int i = 0; i < bgActualRecordCollection.size(); ++i) {
                resultOrgId.setLength(0);
                bgActualRecordCollection.get(i).getBgForm().setOrgUnit(((BgOrgUnitInfo)orgMap.get(bgActualRecordCollection.get(i).getBgForm().getOrgUnit().getId().toString())).castToFullOrgUnitInfo());
                if (!ActualRecordControlUtils.checkParentNoEdit(bgActualRecordCollection.get(i), dealActualRecords, parentOrgNumbers, resultOrgId)) continue;
                bgActualRecordInfo = bgActualRecordCollection.get(i);
                BgOrgUnitInfo parentOrg = ActualRecordControlUtils.getBgOrgUnitInfoByorgUnitIdAndViewID(ctx, resultOrgId.toString(), bgOrgViewId, false);
                noEditParentRecord.add(new String[]{bgActualRecordInfo.getBgForm().getOrgUnit().getName(), bgActualRecordInfo.getNumber(), bgActualRecordInfo.getName(), parentOrg.getNumber() + "(" + parentOrg.getName() + ")"});
                actualRecordIds.remove(bgActualRecordInfo.getId().toString());
            }
            ArrayList<String[]> successList = new ArrayList<String[]>();
            List<String[]> tempList = null;
            result.put("auditUnAuditSuccess", successList);
            result.put("noEditParentRecord", noEditParentRecord);
            if (actualRecordIds.isEmpty()) {
                Map map = result;
                return map;
            }
            boolean bl = false;
            while (var32_42 < actualRecordIds.size()) {
                tempList = actualRecordUtils.unAuditSubOrgActualRecord(BOSUuid.read((String)actualRecordIds.get((int)var32_42).toString()), auditBgOrgId, userId, 16, 1, permissionItem, new ArrayList<String>(), dealActualRecords, parentOrgNumbers);
                if (tempList != null) {
                    successList.addAll(tempList);
                }
                ++var32_42;
            }
            actualRecordUtils.sysActDataWithControlRecord();
        }
        finally {
            MBgCheckHelper.releaseMutex(ctx, this.mutexSucceed);
        }
        return result;
    }

    private void deleCanUnAuditActualRecord(Set removedOrgNumbers, Map<String, Map<String, String[]>> dealActualRecords, Map<String, List<String>> parentOrgNumbers) {
        if (removedOrgNumbers == null || removedOrgNumbers.isEmpty()) {
            return;
        }
        Map<String, String[]> subMap = null;
        Object[] orgNumbers = null;
        String[] bgFormInfos = null;
        boolean isCanUnAudit = true;
        List<String> parentNumbers = null;
        HashSet temOrgNumbers = new HashSet();
        for (String key : dealActualRecords.keySet()) {
            subMap = dealActualRecords.get(key);
            for (String string : orgNumbers = subMap.keySet().toArray(new String[0])) {
                bgFormInfos = subMap.get(string);
                if (bgFormInfos == null) continue;
                isCanUnAudit = false;
                parentNumbers = parentOrgNumbers.get(bgFormInfos[2]);
                if (parentNumbers != null && !parentNumbers.isEmpty()) {
                    int i;
                    int j = parentNumbers.size();
                    for (i = 0; i < parentNumbers.size() && !removedOrgNumbers.contains(parentNumbers.get(i)); ++i) {
                    }
                    if (i == j) continue;
                }
                if (parentNumbers != null) {
                    parentNumbers.retainAll(Arrays.asList((Object[])orgNumbers));
                    if (removedOrgNumbers.containsAll(parentNumbers)) {
                        isCanUnAudit = true;
                    }
                }
                if (!isCanUnAudit) continue;
                subMap.remove(string);
                removedOrgNumbers.add(string);
                this.deleCanUnAuditActualRecord(removedOrgNumbers, dealActualRecords, parentOrgNumbers);
            }
        }
    }

    private Map<String, List<String>> getParentOrgNumbers(Context ctx, String bgOrgViewId) throws BOSException {
        HashMap<String, List<String>> parentOrgNumbers = new HashMap<String, List<String>>();
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        ArrayList paramList = new ArrayList();
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            sql.append("Select FOrgUnitID, FLongNumber FROM T_MBG_BgOrgUnit Where FViewId = '").append(bgOrgViewId).append("'");
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            while (rst.next()) {
                String orgUnitId = rst.getString("FOrgUnitId");
                String longNumber = rst.getString("FLongNumber");
                String[] lns = longNumber.split("!");
                if (lns.length <= 1) continue;
                if (!parentOrgNumbers.containsKey(orgUnitId)) {
                    parentOrgNumbers.put(orgUnitId, new ArrayList());
                }
                for (int i = 0; i < lns.length - 1; ++i) {
                    ((List)parentOrgNumbers.get(orgUnitId)).add(lns[i]);
                }
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return parentOrgNumbers;
    }

    private BgOrgUnitCollection getBgOrgUnitCollectionByViewID(Context ctx, String viewID) throws EASBizException, BOSException {
        return BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection("select id, name,orgUnitId, longNumber,number where  viewId = '" + viewID + "' and isVirtual = 0");
    }

    private Map<String, Map<String, String[]>> dealActualRecords(Context ctx, List actualRecordIds, List formIds, String bgOrgViewId) throws BOSException, EASBizException {
        final HashMap<String, Map<String, String[]>> dealedActualReords = new HashMap<String, Map<String, String[]>>();
        if (actualRecordIds == null || actualRecordIds.isEmpty()) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select a.fid,a.fstate,a.FBgPeriodId,bgForm.FBgSchemeId, bgForm.FBgTemplateId, bgForm.FCurrencyId,bgForm.FBgVersionId,bgForm.FOrgUnitId, org.FNumber FOrgUnitNumber, org.FName_").append(ctx.getLocale()).append(" FOrgName ").append(" from t_mbg_bgactualrecord a left join t_mbg_bgform bgForm on a.fbgFormID = bgForm.fid left join T_MBG_BgOrgUnit org ON org.FOrgUnitID = bgForm.FOrgUnitId where ").append(" a.fstate <> ").append(1);
        sql.append(" AND a.FBgPeriodId IN(Select FBgPeriodId FROM t_mbg_bgactualrecord Where FID IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append("))");
        sql.append("and a.fbgformid in ( select bgForm.FID FROM T_MBG_BgForm bgForm ").append(" Inner Join T_MBG_BgOrgUnit org1 ON org1.FOrgUnitID = bgForm.FOrgUnitId where org1.FViewId = '").append(bgOrgViewId);
        sql.append("' AND bgForm.FBgSchemeId IN(Select FBgSchemeId FROM T_MBG_BgForm Where FID IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append("))");
        sql.append(" AND bgForm.FBgTemplateId IN(Select FBgTemplateId FROM T_MBG_BgForm Where FID IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append("))");
        sql.append(" AND bgForm.FCurrencyId IN(Select FCurrencyId FROM T_MBG_BgForm Where FID IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append("))");
        sql.append(" AND bgForm.FBgVersionId IN(Select FBgVersionId FROM T_MBG_BgForm Where FID IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append("))");
        sql.append(")");
        int paramCount = 5;
        List oneParams = MbgSqlHelper.getBatchParams(null, (Object[])actualRecordIds.toArray(), (int)50);
        List twoParams = MbgSqlHelper.getBatchParams(null, (Object[])formIds.toArray(), (int)50);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] newParams = null;
        for (int index = 0; index < oneParams.size(); ++index) {
            Object[] p = (Object[])oneParams.get(index);
            Object[] formIdCount = (Object[])twoParams.get(index);
            newParams = new Object[p.length * paramCount];
            paramList.add(newParams);
            System.arraycopy(p, index * paramCount * 50, newParams, index * paramCount * 50, p.length);
            for (int i = 1; i < paramCount; ++i) {
                System.arraycopy(formIdCount, 0, newParams, index * paramCount * 50 + 50 * i, p.length);
            }
        }
        MbgSqlHelper.executeBatchQuery((Context)ctx, (String)sql.toString(), paramList, (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String id = res.getString("fid");
                String bgSchemeid = res.getString("FBgSchemeId");
                String bgTemplateId = res.getString("FBgTemplateId");
                String currencyId = res.getString("FCurrencyId");
                String bgPeriodId = res.getString("FBgPeriodId");
                String versionId = res.getString("FBgVersionId");
                String orgUnitNumber = res.getString("FOrgUnitNumber");
                String orgName = res.getString("FOrgName");
                String orgId = res.getString("FOrgUnitID");
                String key = bgSchemeid + "_" + bgTemplateId + "_" + currencyId + "_" + bgPeriodId + "_" + versionId;
                if (!dealedActualReords.containsKey(key)) {
                    dealedActualReords.put(key, new LinkedHashMap());
                }
                ((Map)dealedActualReords.get(key)).put(orgUnitNumber, new String[]{id, orgName, orgId});
            }
        });
        return dealedActualReords;
    }

    private Map checkActualRecord(Context ctx, BOSUuid auditBgOrgId, List actualRecordIds, List<BgActualRecordStateEnum> stateEnums) throws BOSException, EASBizException {
        HashMap<String, ArrayList<String[]>> result = new HashMap<String, ArrayList<String[]>>();
        if (actualRecordIds == null || actualRecordIds.isEmpty()) {
            return result;
        }
        Set<String> mutexErrs = MBgCheckHelper.requestMutex(ctx, actualRecordIds, false);
        ArrayList<String[]> mutexErrsList = new ArrayList<String[]>();
        if (mutexErrs != null && !mutexErrs.isEmpty()) {
            this.mutexSucceed.removeAll(mutexErrs);
            actualRecordIds.removeAll(mutexErrs);
            BgActualRecordCollection col = this.getActualRecord(ctx, new ArrayList<String>(mutexErrs));
            for (int i = 0; i < col.size(); ++i) {
                BgActualRecordInfo bgActualRecordInfo = col.get(i);
                ActualRecordControlUtils.addResult(mutexErrsList, bgActualRecordInfo);
            }
            result.put("auditMux", mutexErrsList);
        }
        ArrayList<String[]> stateList = new ArrayList<String[]>();
        ArrayList<String[]> virtualList = new ArrayList<String[]>();
        result.put("auditUnAuditState", stateList);
        result.put("auditUnAuditVirtual", virtualList);
        BgActualRecordCollection col = this.getActualRecord(ctx, actualRecordIds);
        BgActualRecordInfo info = null;
        HashSet<String> orgUnitIds = new HashSet<String>();
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            orgUnitIds.add(info.getBgForm().getOrgUnit().getId().toString());
        }
        Map virtualInfo = BgOrgUnitFactory.getLocalInstance(ctx).getOrgVirtualInfo(auditBgOrgId.toString(), orgUnitIds);
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            if (Boolean.TRUE.equals(virtualInfo.get(info.getBgForm().getOrgUnit().getId().toString()))) {
                ActualRecordControlUtils.addResult(virtualList, info);
                actualRecordIds.remove(info.getId().toString());
                continue;
            }
            if (!stateEnums.contains((Object)info.getState())) continue;
            ActualRecordControlUtils.addResult(stateList, info);
            actualRecordIds.remove(info.getId().toString());
        }
        return result;
    }

    private BgActualRecordCollection getActualRecord(Context ctx, List actualRecordIds) throws BOSException {
        HashSet actualrecordId = new HashSet(actualRecordIds);
        IBgActualRecord iface = BgActualRecordFactory.getLocalInstance(ctx);
        try {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("bgForm.orgUnit.name"));
            sic.add(new SelectorItemInfo("bgForm.orgUnit.id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("state"));
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("bgScheme.id"));
            view.setSelector(sic);
            view.setSorter(new SorterItemCollection());
            view.getSorter().add(new SorterItemInfo("bgForm.orgUnit.name"));
            view.getSorter().add(new SorterItemInfo("number"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", actualrecordId, CompareType.INCLUDE));
            view.setFilter(filter);
            return iface.getBgActualRecordCollection(view);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected BgUnAuditCheckResult _checkCanUnAudit(Context ctx, BOSUuid actualRecordIds, BOSUuid auditBgOrgId, BOSUuid userId) throws BOSException, EASBizException {
        BgUnAuditCheckResult bgUnAuditresult = new BgUnAuditCheckResult();
        ActualRecordControlUtils actualRecordUtils = new ActualRecordControlUtils(ctx);
        bgUnAuditresult = actualRecordUtils.checkCanUnAudit(actualRecordIds.toString(), auditBgOrgId.toString(), userId.toString());
        return bgUnAuditresult;
    }

    @Override
    protected List _checkBatchUnAudit(Context ctx, List actualRecordIds, BOSUuid auditBgOrgId, BOSUuid userId) throws BOSException, EASBizException {
        ActualRecordControlUtils actualRecordUtils = new ActualRecordControlUtils(ctx);
        return actualRecordUtils.checkBatchUnAudit(actualRecordIds, userId, auditBgOrgId);
    }

    @Override
    protected boolean _submitBgActualWork(Context ctx, IObjectValue editData) throws BOSException, EASBizException {
        return true;
    }

    @Override
    protected boolean _submitBgActualWorkEdit(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        return true;
    }

    @Override
    protected boolean _auditBgActualRecordApproving(Context ctx, BOSUuid id, BOSUuid auditorId) throws BOSException, EASBizException {
        String sql = "update T_MBG_BgActualRecord set FState=?, FAuditorID=?, FAuditedTime=? where FID=?";
        Object[] params = new Object[]{14, auditorId != null ? auditorId.toString() : ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), new Timestamp(System.currentTimeMillis()), id.toString()};
        try {
            BgDBUtils.executeUpdate((Context)ctx, (String)sql, (Object[])params);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    @Override
    protected boolean _auditBgActualRecordReferring(Context ctx, BOSUuid id, BOSUuid auditorId) throws BOSException, EASBizException {
        try {
            BgDBUtils.executeUpdate((Context)ctx, (String)"update T_MBG_BgActualRecord set FState = ? where FID = ?", (Object[])new Object[]{25, id.toString()});
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    @Override
    protected boolean _auditBgActualRecord(Context ctx, BOSUuid id, BOSUuid auditorId, String idea) throws BOSException, EASBizException {
        BgActualRecordInfo bgActualRecordInfo = this.findBgActualRecordInfoById(ctx, id);
        String auditBgOrgId = this.findBgOrgUnitIdByInfo(ctx, bgActualRecordInfo);
        BOSUuid userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        String permissionItem = "mbg_actual01_list";
        ActualRecordControlUtils actualRecordUtils = new ActualRecordControlUtils(ctx);
        List<String[]> re = actualRecordUtils.auditSubOrgActualRecord(id, BOSUuid.read((String)auditBgOrgId), userId, 16, 9, permissionItem, null);
        actualRecordUtils.sysActDataWithControlRecord();
        return null != re && !re.isEmpty();
    }

    private String findBgOrgUnitIdByInfo(Context ctx, BgActualRecordInfo bgActualRecordInfo) throws BOSException, EASBizException {
        BgSchemeInfo schemeInfo = BgViewServerHelper.getBgSchemeCubeInfo(ctx, bgActualRecordInfo.getBizBgScheme().getId());
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)bgActualRecordInfo.getBgForm().getOrgUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)schemeInfo.getEditOrgViewId().toString()));
        evi.setFilter(filter);
        evi.getSelector().add("id");
        BgOrgUnitCollection colls = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(evi);
        String id = null;
        if (!colls.isEmpty()) {
            for (int i = 0; i < colls.size(); ++i) {
                if (colls.get(i).getId() == null) continue;
                id = colls.get(i).getId().toString();
            }
        }
        return id;
    }

    private BgActualRecordInfo findBgActualRecordInfoById(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("bgForm.orgUnit.id");
        selector.add("bgForm.bgScheme.id");
        BgActualRecordInfo bgActualRecordInfo = BgActualRecordFactory.getLocalInstance(ctx).getBgActualRecordInfo((IObjectPK)new ObjectUuidPK(id), selector);
        return bgActualRecordInfo;
    }

    @Override
    protected boolean _auditCancelBgActualRecord(Context ctx, BOSUuid id, BOSUuid auditorId, String idea) throws BOSException, EASBizException {
        String sql = "update T_MBG_BgActualRecord set FState=?, FAuditorId = null , FAuditedTime = null where FID=?";
        Object[] params = new Object[]{1, id.toString()};
        try {
            BgDBUtils.executeUpdate((Context)ctx, (String)sql, (Object[])params);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return true;
    }
}

