/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.codingrule.BindingPropertyInfo;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgCodeNumberNHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgParamNHelper;
import com.kingdee.eas.ma.control.BgControlSettingInfo;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.control.impl.models.BgGroupData;
import com.kingdee.eas.ma.mbg.BgAdjustBillCollection;
import com.kingdee.eas.ma.mbg.BgAdjustBillEntryCollection;
import com.kingdee.eas.ma.mbg.BgAdjustBillEntryInfo;
import com.kingdee.eas.ma.mbg.BgAdjustBillFactory;
import com.kingdee.eas.ma.mbg.BgAdjustBillInfo;
import com.kingdee.eas.ma.mbg.BgAdjustBillStateEnum;
import com.kingdee.eas.ma.mbg.BgAdjustBillTypeEnum;
import com.kingdee.eas.ma.mbg.BgAdjustException;
import com.kingdee.eas.ma.mbg.BgAdjustFacadaFactory;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgPastDataInfo;
import com.kingdee.eas.ma.mbg.BgPastRecordInfo;
import com.kingdee.eas.ma.mbg.BgPastSourceEnum;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgAdjustBill;
import com.kingdee.eas.ma.mbg.app.AbstractBgAdjustBillControllerBean;
import com.kingdee.eas.ma.mbg.app.data.IMbgDataFacade;
import com.kingdee.eas.ma.mbg.app.data.MbgDataFacade;
import com.kingdee.eas.ma.mbg.app.data.MbgTmpDataUtils;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.common.BgAdjustBillBalanceOverParameter;
import com.kingdee.eas.ma.mbg.common.BgAdjustBillParameter;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.BgTmpDataImpUtil;
import com.kingdee.eas.ma.mbg.common.BgTmpDataInfo;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.IMbgData;
import com.kingdee.eas.ma.mbg.cube.query.IDimData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgAdjustBillControllerBean
extends AbstractBgAdjustBillControllerBean {
    private static final long serialVersionUID = -1561837588738347148L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgAdjustBillControllerBean");

    @Override
    protected void _verifyDataBeforeSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgAdjustBillInfo info = (BgAdjustBillInfo)model;
        List<IDimData> dataList = MbgTmpDataUtils.queryTmpDataByBillInfo(info);
        BgTmpDataImpUtil.checkAdjustData(ctx, info, dataList);
    }

    @Override
    public void _checkTmpData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgAdjustBillInfo info = (BgAdjustBillInfo)model;
        List<IDimData> dimDatas = MbgTmpDataUtils.queryTmpDataByBillInfo(info);
        if (dimDatas != null && !dimDatas.isEmpty()) {
            MbgTmpDataUtils.checkTmpData(ctx, info, dimDatas);
        }
    }

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._addnew(ctx, pk, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgAdjustBillInfo info = (BgAdjustBillInfo)model;
        if (StringUtils.isEmpty((String)info.getNumber())) {
            try {
                String OUID = info.getOrgUnit().getId().toString();
                BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)model, (String)OUID, (String)"sourceType", (String)"number");
            }
            catch (Exception e) {
                info.setNumber(this.createDefaultNumber());
            }
        }
        this._checkNumberDup(ctx, null, model);
        return super._addnew(ctx, (IObjectValue)info);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("state");
        sic.add("orgUnit.id");
        sic.add("bgScheme.id");
        sic.add("bgScheme.number");
        sic.add("sourceType");
        sic.add("type");
        BgAdjustBillInfo model = (BgAdjustBillInfo)this._getValue(ctx, pk, sic);
        String logName = model.getNumber();
        boolean flag = model.getType().equals((Object)BgAdjustBillTypeEnum.betweenOrg) || model.getType().equals((Object)BgAdjustBillTypeEnum.inOrg);
        String itemName = flag ? "mbg_adjustBill_delete" : "mbg_adjustBillExp_delete";
        IObjectPK Loginpk = LogUtil.beginLog((Context)ctx, (String)"_delete", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)itemName);
        this.recycleNumberByOrg(ctx, model);
        super._delete(ctx, pk);
        LogUtil.afterLog((Context)ctx, (IObjectPK)Loginpk);
    }

    protected void recycleNumberByOrg(Context ctx, BgAdjustBillInfo model) throws EASBizException, BOSException {
        boolean useIntermitNumber;
        if (StringUtils.isEmpty((String)model.getNumber())) {
            return;
        }
        String companyId = model.getOrgUnit().getId().toString();
        CodingRuleInfo codingRule = null;
        String orgUnitId = null;
        BindingPropertyInfo bindingProperty = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean isCodingRule = iCodingRuleManager.isExist((IObjectValue)model, companyId, "sourceType");
        if (!isCodingRule) {
            isCodingRule = iCodingRuleManager.isExist((IObjectValue)model, companyId);
        }
        if (isCodingRule && (codingRule = iCodingRuleManager.getCodingRule((IObjectValue)model, companyId, "sourceType")) == null) {
            codingRule = iCodingRuleManager.getCodingRule((IObjectValue)model, companyId);
        }
        if (codingRule != null) {
            orgUnitId = codingRule.getAppOrgUnit().getId().toString();
            bindingProperty = codingRule.getBindingProperty();
        }
        if (StringUtils.isEmpty(orgUnitId)) {
            orgUnitId = companyId;
        }
        if (!(useIntermitNumber = iCodingRuleManager.isUseIntermitNumber((IObjectValue)model, companyId, "sourceType"))) {
            useIntermitNumber = iCodingRuleManager.isUseIntermitNumber((IObjectValue)model, companyId);
        }
        if (isCodingRule && useIntermitNumber) {
            if (bindingProperty != null && bindingProperty.getPropertyName() != null) {
                iCodingRuleManager.recycleNumber((IObjectValue)model, orgUnitId, bindingProperty.getPropertyName(), "", model.getNumber());
            } else {
                iCodingRuleManager.recycleNumber((IObjectValue)model, orgUnitId, model.getNumber());
            }
        }
    }

    private String createDefaultNumber() {
        String str = String.valueOf(new Date().getTime());
        if (str.length() > 6) {
            str = str.substring(str.length() - 7, str.length() - 1);
        }
        return "TZ" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + "_" + str;
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._save(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgAdjustBillInfo bgAdjustBill = (BgAdjustBillInfo)model;
        if (bgAdjustBill.getId() == null) {
            bgAdjustBill.setId(BOSUuid.create((BOSObjectType)bgAdjustBill.getBOSType()));
        }
        HashMap<String, IDimData> mbgDataMap = new HashMap<String, IDimData>();
        List<IDimData> dimDatas = MbgTmpDataUtils.queryTmpDataByBillInfo(bgAdjustBill);
        this._verifyDataBeforeSave(ctx, model);
        List<IMbgData> mbgDatas = MbgTmpDataUtils.queryTmpData(ctx, bgAdjustBill.getBgScheme().getId(), bgAdjustBill.getId());
        IObjectPK pk = super._save(ctx, model);
        try {
            if (dimDatas != null && mbgDatas != null) {
                IMbgDataFacade facade = MbgDataFacade.getInstance(ctx, bgAdjustBill.getLastUpdateUser().getId().toString(), bgAdjustBill.getBgScheme().getId().toString(), DimensionConstants.ADJUST_DATA_TYPE);
                facade.setBillId(pk.toString());
                facade.setProcessType(bgAdjustBill.getProcessType());
                for (IDimData iDimData : dimDatas) {
                    facade.addMbgData(iDimData);
                    mbgDataMap.put(iDimData.getOrgDimKey(), iDimData);
                }
                for (IMbgData iMbgData : mbgDatas) {
                    if (mbgDataMap.containsKey(iMbgData.getOrgDimKey())) continue;
                    iMbgData.setValue(null);
                    iMbgData.setOldValue(null);
                    facade.addMbgData(iMbgData);
                }
                facade.submit();
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return pk;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object _queryDataByParameter(Context ctx, BgAdjustBillParameter parameter) throws BOSException, EASBizException {
        HashMap orgDataMap;
        ResultSet rs;
        PreparedStatement pmst;
        Connection conn;
        block28: {
            if (parameter == null) {
                return null;
            }
            BgSchemeInfo bgScheme = parameter.getBgScheme();
            List<BgOrgUnitInfo> orgUnits = parameter.getOrgUnits();
            BgElementInfo element = parameter.getBgElement();
            CurrencyInfo currency = parameter.getCurrency();
            BgPeriodCollection periods = parameter.getPeriods();
            BgProcessEnum processType = parameter.getProcessType();
            if (bgScheme == null) return null;
            if (orgUnits.isEmpty()) return null;
            if (currency == null) return null;
            if (periods == null) return null;
            if (periods.isEmpty()) return null;
            if (processType == null) {
                return null;
            }
            String cubTableName = BgCubeUtils.getCubeName(bgScheme.getRefCube(), processType);
            if (StringUtils.isEmpty((String)cubTableName)) {
                return null;
            }
            List<String> formulas = parameter.getFormula();
            if (formulas == null) return null;
            if (formulas.isEmpty()) {
                return null;
            }
            ArrayList<String> orgUnitIds = new ArrayList<String>();
            for (BgOrgUnitInfo bgOrgUnit : parameter.getOrgUnits()) {
                orgUnitIds.add(bgOrgUnit.getOrgUnitID());
            }
            HashSet<String> formulaSet = new HashSet<String>();
            formulaSet.addAll(formulas);
            if (!periods.isEmpty()) {
                String[] params = null;
                for (String formulaStr : formulas) {
                    params = BgNFSHelper.parseFormulaPara(formulaStr);
                    int in = periods.size();
                    for (int i = 0; i < in; ++i) {
                        params[1] = periods.get(i).getNumber();
                        formulaSet.add(BgNFSHelper.getFormulaFromParam(params));
                    }
                }
            }
            BgSchemeAccIntHelper accIntHelper = new BgSchemeAccIntHelper(ctx, bgScheme.getId().toString(), cubTableName);
            Set<String> cubeNames = accIntHelper.getSplitTablesByFormula(formulaSet);
            conn = null;
            pmst = null;
            rs = null;
            TempTablePool pool = null;
            String tmpTableName = null;
            String tmpOrgUnitName = null;
            orgDataMap = new HashMap();
            Map<String, BgNDataInfo> dataMap = null;
            BgNDataInfo _dataInfo = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                pool = TempTablePool.getInstance((Context)ctx);
                tmpOrgUnitName = pool.createDBSystemTempTable("CREATE TABLE TMPTABLENAME (FKey VARCHAR(44))", conn);
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpOrgUnitName + " (FKey) Values (?)"), orgUnitIds);
                tmpTableName = pool.createDBSystemTempTable("CREATE TABLE TMPTABLENAME (FKey NVARCHAR(300))", conn);
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTableName + " (FKey) Values (?)"), formulaSet);
                for (String cubeName : cubeNames) {
                    StringBuffer sql = new StringBuffer();
                    if (accIntHelper.isUseAccInt()) {
                        sql.append("SELECT FID, FORGUNITID, FFORMULA, FVALUE, FSTATE FROM " + cubeName + " WHERE FORGUNITID IN (Select FIntId FROM T_MBG_BgOrgUnit Where FViewId = ? AND FIsVirtual = 0 AND FOrgUnitId IN(SELECT FKey from " + tmpOrgUnitName + ")) AND FFORMULA IN (SELECT FKey from " + tmpTableName + ") and FVersion = ?");
                        pmst = conn.prepareStatement(sql.toString());
                        pmst.setString(1, accIntHelper.getSchemeHelper().getBgOrgViewId());
                        pmst.setInt(2, parameter.getVersion().getVersionId());
                    } else {
                        sql.append("SELECT FID, FORGUNITID, FFORMULA, FVALUE, FSTATE FROM " + cubeName + " WHERE FORGUNITID IN (SELECT FKey from " + tmpOrgUnitName + ") AND FFORMULA IN (SELECT FKey from " + tmpTableName + ") and FVersion = ?");
                        pmst = conn.prepareStatement(sql.toString());
                        pmst.setInt(1, parameter.getVersion().getVersionId());
                    }
                    rs = pmst.executeQuery();
                    while (rs.next()) {
                        _dataInfo = new BgNDataInfo();
                        _dataInfo.setBgDataId(rs.getString("FID"));
                        _dataInfo.setOrgUnitId(accIntHelper.convertStringForOrg(rs.getString("FORGUNITID")));
                        _dataInfo.setFormula(rs.getString("FFORMULA"));
                        _dataInfo.setBudgetValue(rs.getBigDecimal("FVALUE"));
                        _dataInfo.setState(rs.getInt("FSTATE"));
                        String[] params = BgNFSHelper.parseFormulaPara(rs.getString("FFORMULA"));
                        _dataInfo.setBgElementNumber(params[2]);
                        _dataInfo.setCurrencyNumber(currency.getNumber());
                        if (orgDataMap.containsKey(_dataInfo.getOrgUnitId())) {
                            dataMap = (Map)orgDataMap.get(_dataInfo.getOrgUnitId());
                        } else {
                            dataMap = new HashMap();
                            orgDataMap.put(_dataInfo.getOrgUnitId(), dataMap);
                        }
                        dataMap.put(_dataInfo.getFormula(), _dataInfo);
                    }
                    SQLUtils.cleanup((ResultSet)rs, (Statement)pmst);
                }
                if (pool == null) break block28;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                    catch (Exception ex) {
                        throw new BOSException((Throwable)ex);
                    }
                }
                catch (Throwable throwable) {
                    if (pool != null) {
                        try {
                            pool.releaseDBSystemTempTable(tmpOrgUnitName, conn);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            pool.releaseDBSystemTempTable(tmpTableName, conn);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    SQLUtils.cleanup(rs, pmst, (Connection)conn);
                    throw throwable;
                }
            }
            try {
                pool.releaseDBSystemTempTable(tmpOrgUnitName, conn);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                pool.releaseDBSystemTempTable(tmpTableName, conn);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SQLUtils.cleanup(rs, pmst, (Connection)conn);
        return orgDataMap;
    }

    @Override
    protected boolean _checkRepeat(Context ctx, BgAdjustBillParameter[] params) throws BOSException, EASBizException {
        if (params == null || params.length == 0) {
            return false;
        }
        boolean check = false;
        int in = params.length;
        for (int i = 0; i < in; ++i) {
            Map map = this._checkRepeat(ctx, params[i]);
            if (map == null || map.isEmpty()) continue;
            check = true;
            break;
        }
        return check;
    }

    @Override
    protected Map _checkRepeat(Context ctx, BgAdjustBillParameter parameter) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pmst;
        Connection conn;
        HashMap<String, String> resultMap;
        block11: {
            Map map;
            if (parameter == null) {
                return null;
            }
            BgSchemeInfo bgScheme = parameter.getBgScheme();
            BgElementInfo element = parameter.getBgElement();
            BgVersionInfo versionInfo = parameter.getVersion();
            CurrencyInfo currency = parameter.getCurrency();
            BgPeriodCollection periods = parameter.getPeriods();
            BgProcessEnum processType = parameter.getProcessType();
            if (bgScheme == null || parameter.getOrgUnits().isEmpty() || element == null || currency == null || periods == null || periods.isEmpty() || processType == null) {
                return null;
            }
            String cubTableName = BgCubeUtils.getCubeName(bgScheme.getRefCube(), processType);
            if (StringUtils.isEmpty((String)cubTableName)) {
                return null;
            }
            List<String> formulas = parameter.getFormula();
            if (formulas == null || formulas.isEmpty()) {
                return null;
            }
            resultMap = new HashMap<String, String>();
            StringBuffer sql = new StringBuffer();
            sql.append("select t.FNumber, t.FType, e.FIndexMemberName, e.FMEMBERCOMBINNAME, p.FName_" + ctx.getLocale() + ", o.fnumber orgNumber, o.fname_" + ctx.getLocale() + " orgName, e.FFORMULA, u.FNumber eorgNumber,u.fname_" + ctx.getLocale() + " eorgName from T_MBG_BgAdjustBill t join T_MBG_BgAdjustBillEntry e on t.FID = e.FBGADJUSTBILL join T_MBG_BgPeriod p on e.FPERIOD = p.FID join T_MBG_BgOrgUnit u on e.FORGUNIT = u.FID join T_ORG_BaseUnit o on t.FOrgUnit = o.FID where t.FSTATE not in(4,5)  AND t.FBGSCHEME = ? AND t.FBGVERSIONID = ?  AND t.FPROCESSTYPE = ? ");
            if (parameter.getBillId() != null) {
                sql.append(" and t.fid <> '" + parameter.getBillId() + "'");
            }
            sql.append("  AND e.FORGUNIT = ? AND e.FFORMULA IN (");
            for (int index = 0; index < formulas.size(); ++index) {
                sql.append("'").append(formulas.get(index)).append("',");
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(")");
            conn = null;
            pmst = null;
            rst = null;
            int type = 0;
            String number = null;
            String keyStr = null;
            String formula = null;
            HashSet<String> keySet = new HashSet<String>();
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                pmst = conn.prepareStatement(sql.toString());
                pmst.setString(1, bgScheme.getId().toString());
                pmst.setString(2, versionInfo.getId().toString());
                pmst.setInt(3, processType.getValue());
                pmst.setString(4, parameter.getOrgUnits().get(0).getId().toString());
                rst = pmst.executeQuery();
                while (rst.next()) {
                    type = rst.getInt("FType");
                    number = rst.getString("FNumber");
                    formula = rst.getString("FFORMULA");
                    Object[] objs = new Object[7];
                    objs[3] = rst.getString("eorgNumber");
                    objs[4] = rst.getString("eorgName");
                    objs[0] = rst.getString(5);
                    objs[1] = StringUtils.isEmpty((String)rst.getString("FMEMBERCOMBINNAME")) ? rst.getString("FIndexMemberName") : rst.getString("FIndexMemberName") + "," + rst.getString("FMEMBERCOMBINNAME");
                    objs[5] = rst.getString("orgNumber");
                    objs[6] = rst.getString("orgName");
                    objs[2] = number;
                    keyStr = objs[0] + "_" + objs[1] + "_" + objs[2];
                    if (keySet.contains(keyStr)) continue;
                    keySet.add(keyStr);
                    String tmpStr = null;
                    tmpStr = type == 0 || type == 1 ? ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAdjustBillResource", (String)"checkInnAdjustDataExists", (Locale)ctx.getLocale(), (Object[])objs) : ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAdjustBillResource", (String)"checkAdjustDataExists", (Locale)ctx.getLocale(), (Object[])objs);
                    if (resultMap.containsKey(formula)) continue;
                    resultMap.put(formula, tmpStr);
                }
                BgTmpDataImpUtil.queryTmpData(ctx, conn, parameter, bgScheme.getId().toString(), versionInfo.getVersionId(), resultMap);
                List<String> formulaList = parameter.getFormula();
                if (formulaList != null && !formulaList.isEmpty()) break block11;
                map = null;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pmst, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pmst, (Connection)conn);
            return map;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pmst, (Connection)conn);
        return resultMap;
    }

    @Override
    protected IObjectPK _audit(Context ctx, BOSUuid id, BgPastSourceEnum bgPastSource) throws BOSException, EASBizException {
        return this._audit(ctx, id, bgPastSource, null);
    }

    @Override
    protected IObjectPK _audit(Context ctx, BOSUuid id, BgPastSourceEnum bgPastSource, Map auditParams) throws BOSException, EASBizException {
        if (id == null) {
            return null;
        }
        BgAdjustBillInfo bgAdjustBill = (BgAdjustBillInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(id), this.getSelectorForAudit());
        int state = bgAdjustBill.getState().getValue();
        this._verifyDataBeforeSave(ctx, (IObjectValue)bgAdjustBill);
        List<IDimData> dimDatas = MbgTmpDataUtils.queryTmpDataByBillInfo(bgAdjustBill);
        BgTmpDataImpUtil.checkAdjustData(ctx, bgAdjustBill, dimDatas);
        if (state != BgAdjustBillStateEnum.adjusting.getValue() && state != BgAdjustBillStateEnum.auditing.getValue() && state != BgAdjustBillStateEnum.submit.getValue()) {
            return null;
        }
        String logName = bgAdjustBill.getNumber();
        boolean flag = bgAdjustBill.getType().equals((Object)BgAdjustBillTypeEnum.betweenOrg) || bgAdjustBill.getType().equals((Object)BgAdjustBillTypeEnum.inOrg);
        String itemName = flag ? "mbg_adjustBill_audit" : "mbg_adjustBillExp_audit";
        IObjectPK Loginpk = LogUtil.beginLog((Context)ctx, (String)"_audit", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)itemName);
        BgAdjustBillEntryInfo entry = null;
        BgAdjustBillEntryCollection colls = bgAdjustBill.getEntity();
        if (colls.isEmpty()) {
            return new ObjectUuidPK(id);
        }
        Timestamp auditTime = new Timestamp(new Date().getTime());
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = userInfo.getId().toString();
        String bgPastRecordId = null;
        String _audOrgUnitId = null;
        String _audUserId = null;
        String tableName = BgCubeUtils.getCubeName(bgAdjustBill.getBgScheme().getRefCube(), bgAdjustBill.getProcessType());
        IDimData dimData2 = null;
        int count = 0;
        Connection conn = null;
        PreparedStatement pmst = null;
        ResultSet rs = null;
        if (auditParams == null) {
            auditParams = new HashMap<String, String>();
        }
        if (!auditParams.containsKey("ORGUNIT_AUDIT_ID")) {
            auditParams.put("ORGUNIT_AUDIT_ID", bgAdjustBill.getOrgUnit().getId().toString());
        }
        _audOrgUnitId = (String)auditParams.get("ORGUNIT_AUDIT_ID");
        if (!auditParams.containsKey("USER_ID")) {
            auditParams.put("USER_ID", userInfo.getId().toString());
        }
        _audUserId = (String)auditParams.get("USER_ID");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            List<IDimData> mbgDatas = MbgTmpDataUtils.queryTmpDataByBillInfo(bgAdjustBill);
            if (!mbgDatas.isEmpty()) {
                BgSchemeAccIntHelper accIntHelper = new BgSchemeAccIntHelper(ctx, bgAdjustBill.getBgScheme().getId().toString(), tableName);
                HashMap<String, IDimData> dataMap = new HashMap<String, IDimData>();
                int size = mbgDatas.size();
                for (int index = 0; index < size; ++index) {
                    dimData2 = mbgDatas.get(index);
                    dataMap.put(dimData2.getOrgDimKey(), dimData2);
                }
                Map splitDatas = accIntHelper.splitBgDatas(conn, dataMap, new HashSet<String>());
                for (String cubeName : splitDatas.keySet()) {
                    pmst = conn.prepareStatement("UPDATE " + cubeName + " SET FVALUE = FTMPVALUE, FAudOrgUnitID = ?, FAudUserID = ?, FState = " + 9 + ",FAudFormId = ? where FID = ? and FOrgUnitId = ? and FFormula = ? and FVersion = ? and (FState = " + 5 + " OR FState = " + 9 + ")");
                    count = 0;
                    for (IDimData dimData2 : splitDatas.get(cubeName).values()) {
                        pmst.setString(1, _audOrgUnitId);
                        pmst.setString(2, _audUserId);
                        pmst.setString(3, id.toString());
                        pmst.setString(4, dimData2.getMbgDataId());
                        accIntHelper.setParam(pmst, 5, dimData2.getOrgUnitId(), DimensionConstants.DEF_ORGUNIT_FIELD);
                        pmst.setString(6, dimData2.getFormula());
                        pmst.setInt(7, dimData2.getVersionInnId());
                        pmst.addBatch();
                        pmst.executeBatch();
                        if (++count < 50) continue;
                        count = 0;
                    }
                    if (count > 0) {
                        pmst.executeBatch();
                    }
                    SQLUtils.cleanup((Statement)pmst);
                }
                bgPastRecordId = BOSUuid.create((BOSObjectType)new BgPastRecordInfo().getBOSType()).toString();
                StringBuffer sql = new StringBuffer();
                sql.append("INSERT INTO T_MBG_BGPASTRECORD (FID,FCREATORID,FCREATETIME,FLASTUPDATEUSERID,FLASTUPDATETIME,FCONTROLUNITID,FSEQ,FPASTSOURCE,FVERSIONNO, FBGFORMID) VALUES (?,?,?,?,?,?,?,?,?,?)");
                pmst = conn.prepareStatement(sql.toString());
                pmst.setString(1, bgPastRecordId);
                pmst.setString(2, userId);
                pmst.setTimestamp(3, auditTime);
                pmst.setString(4, userId);
                pmst.setTimestamp(5, auditTime);
                pmst.setString(6, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                pmst.setBigDecimal(7, BigDecimal.ZERO);
                int bgAdjustBillType = bgAdjustBill.getType().getValue();
                if (2 == bgAdjustBillType || 3 == bgAdjustBillType) {
                    pmst.setInt(8, 3);
                } else {
                    pmst.setInt(8, 13);
                }
                pmst.setBigDecimal(9, BigDecimal.ZERO);
                pmst.setString(10, id.toString());
                pmst.executeUpdate();
                SQLUtils.cleanup((Statement)pmst);
                sql.setLength(0);
                sql.append("INSERT INTO T_MBG_BGPASTDATA(FID,FPASTVALUE,FBALANCE,FADJVALUE,FPASTRECORDID,FFORMULA,FBGDATAID,FADJUSTORID,FADJUSTTIME,FADJREASON) VALUES (?,?,?,?,?,?,?,?,?,?)");
                BOSObjectType type = new BgPastDataInfo().getBOSType();
                count = 0;
                pmst = conn.prepareStatement(sql.toString());
                int size2 = colls.size();
                for (int index = 0; index < size2; ++index) {
                    entry = colls.get(index);
                    pmst.setString(1, BOSUuid.create((BOSObjectType)type).toString());
                    pmst.setBigDecimal(2, entry.getOldValue() == null ? entry.getAdjustValue() : entry.getAdjustValue().subtract(entry.getOldValue()));
                    pmst.setBigDecimal(3, entry.getOldValue() == null ? BgNConstants.ZERO : entry.getOldValue());
                    pmst.setBigDecimal(4, entry.getAdjustValue());
                    pmst.setString(5, bgPastRecordId);
                    pmst.setString(6, entry.getFormula());
                    pmst.setString(7, entry.getBgDataId() == null ? "" : entry.getBgDataId().toString());
                    pmst.setString(8, bgAdjustBill.getLastUpdateUser().getId().toString());
                    pmst.setTimestamp(9, auditTime);
                    pmst.setString(10, entry.getReason());
                    pmst.addBatch();
                    if (++count < 50) continue;
                    pmst.executeBatch();
                    count = 0;
                }
                if (count > 0) {
                    pmst.executeBatch();
                }
                SQLUtils.cleanup((Statement)pmst);
            }
            pmst = conn.prepareStatement("Update T_Mbg_BgAdjustBill Set FState = ?, FAuditorID = ?, FAuditTime = ? Where FID = ?");
            pmst.setInt(1, 4);
            pmst.setString(2, userInfo.getId().toString());
            pmst.setTimestamp(3, auditTime);
            pmst.setString(4, id.toString());
            pmst.execute();
            SQLUtils.cleanup((Statement)pmst);
            ArrayList<String> billId = new ArrayList<String>();
            billId.add(id.toString());
            MbgTmpDataUtils.afterAudit(ctx, billId);
            LogUtil.afterLog((Context)ctx, (IObjectPK)Loginpk);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pmst, (Connection)conn);
        return null;
    }

    @Override
    protected Object _balanceOver(Context ctx, BgAdjustBillBalanceOverParameter parameter) throws BOSException, EASBizException {
        BgSchemeInfo rootSchemeInfo;
        Iterator<Object> it;
        BgControlParam param;
        List<BgControlParam> dataList;
        List<BgControlParam> list = dataList = parameter == null ? null : parameter.getOverDataList();
        if (dataList == null || dataList.isEmpty()) {
            return null;
        }
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, parameter.getBgScheme().getId().toString());
        HashMap<String, BgPeriodInfo> bgPeriodMap = new HashMap<String, BgPeriodInfo>();
        Map<Object, Object> dimSrc2NameMap = new HashMap();
        HashSet<String> srcNumberSet = new HashSet<String>();
        HashMap<String, BgControlParam> periodCheckParams = new HashMap<String, BgControlParam>();
        LinkedHashMap periodCheckRows = new LinkedHashMap();
        for (int index = 0; index < dataList.size(); ++index) {
            param = dataList.get(index);
            this.getDimSrcNumber2Set(param, srcNumberSet);
            it = param.getBudgetDetail().keySet().iterator();
            while (it.hasNext()) {
                bgPeriodMap.put((String)it.next(), null);
            }
            String periodKey = this.getControlPeriodKey(param);
            if (!periodCheckParams.containsKey(periodKey)) {
                periodCheckParams.put(periodKey, (BgControlParam)BgAnalyseHelper.clone(param));
            }
            if (!periodCheckRows.containsKey(periodKey)) {
                periodCheckRows.put(periodKey, new ArrayList());
            }
            ((List)periodCheckRows.get(periodKey)).add(index + 1);
        }
        dimSrc2NameMap = this.getdimSrc2NameMap(ctx, srcNumberSet, schemeHelper);
        if (dimSrc2NameMap.isEmpty()) {
            return null;
        }
        for (String periodKey : periodCheckParams.keySet()) {
            param = (BgControlParam)periodCheckParams.get(periodKey);
            param.setBgPeriodNumber(parameter.getTargetPeriod().getNumber());
            param.setBizDate(new Timestamp(parameter.getTargetPeriod().getBeginDate().getTime()));
            List periods = param.getRefBgPeriods(ctx, null);
            if (periods.contains(parameter.getSourcePeriod().getNumber())) continue;
            periodCheckRows.remove(periodKey);
        }
        if (!periodCheckRows.isEmpty()) {
            ArrayList rows = new ArrayList();
            it = periodCheckRows.values().iterator();
            while (it.hasNext()) {
                rows.addAll((List)it.next());
            }
            Collections.sort(rows);
            String msg = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAdjustBillResource", (String)"overBalanceCheckPeriod", (Locale)ctx.getLocale()), MbgSqlHelper.convertArray((Object[])rows.toArray(), null));
            throw new BgFormException(BgFormException.SHOWEXCEPTION, new Object[]{msg});
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("periodType");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", new HashSet(bgPeriodMap.keySet()), CompareType.INCLUDE));
        BgPeriodCollection bgPeriodCol = BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodCollection(evi);
        bgPeriodMap.clear();
        for (int i = 0; i < bgPeriodCol.size(); ++i) {
            bgPeriodMap.put(bgPeriodCol.get(i).getNumber(), bgPeriodCol.get(i));
        }
        OrgUnitInfo[] orgUnitInfo = parameter.getOrgunit();
        BgSchemeInfo schemeInfo = parameter.getBgScheme();
        BgScenarioInfo scenarioInfo = parameter.getBgScenario();
        BgVersionInfo versionInfo = parameter.getBgVersion();
        String tableName = null;
        try {
            rootSchemeInfo = this.getRootSchemeInfo(ctx, schemeInfo.getId().toString());
            tableName = rootSchemeInfo.getRefCube();
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        String schemeID = rootSchemeInfo == null ? null : rootSchemeInfo.getId().toString();
        Map<String, BgOrgUnitInfo> bgOrgMap = this.getBgOrgUnitInfo(ctx, schemeID, orgUnitInfo);
        HashMap<String, BgAdjustBillInfo> dataMap = new HashMap<String, BgAdjustBillInfo>();
        ArrayList<String> formulaList = new ArrayList<String>();
        ArrayList<String[]> msg = new ArrayList<String[]>();
        HashSet<String> formulaSet = new HashSet<String>();
        BgOrgUnitInfo bgOrgUnitInfo = null;
        for (int o = 0; o < orgUnitInfo.length; ++o) {
            BgAdjustBillEntryCollection entryColls;
            BgAdjustBillInfo billInfo;
            CostCenterOrgUnitInfo oInfo = new CostCenterOrgUnitInfo();
            oInfo.setId(orgUnitInfo[o].getId());
            oInfo.setName(orgUnitInfo[o].getName());
            oInfo.setNumber(orgUnitInfo[o].getNumber());
            dataMap.clear();
            formulaSet.clear();
            bgOrgUnitInfo = bgOrgMap.get(orgUnitInfo[o].getId().toString());
            if (bgOrgUnitInfo == null) continue;
            for (int index = 0; index < dataList.size(); ++index) {
                param = dataList.get(index);
                if (!param.getOrgUnit().getId().equals((Object)oInfo.getId())) continue;
                BgElementInfo elementInfo = param.getBgElement();
                CurrencyInfo currencyInfo = param.getCurrency();
                String key = elementInfo.getNumber() + "!" + currencyInfo.getNumber();
                if (dataMap.containsKey(key)) {
                    billInfo = (BgAdjustBillInfo)dataMap.get(key);
                    entryColls = billInfo.getEntity();
                } else {
                    schemeInfo = rootSchemeInfo;
                    if (schemeInfo == null) continue;
                    billInfo = new BgAdjustBillInfo();
                    billInfo.setId(BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
                    billInfo.setIsCarryover(true);
                    billInfo.setOrgUnit(oInfo);
                    billInfo.setBgScheme(schemeInfo);
                    billInfo.setElement(elementInfo);
                    billInfo.setCurrency(currencyInfo);
                    billInfo.setBgScenario(scenarioInfo);
                    billInfo.setBgVersion(versionInfo);
                    billInfo.setType(BgAdjustBillTypeEnum.inOrg);
                    billInfo.setState(BgAdjustBillStateEnum.adjusting);
                    if (StringUtils.isEmpty((String)billInfo.getNumber())) {
                        try {
                            BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)billInfo, (String)billInfo.getOrgUnit().getId().toString());
                        }
                        catch (Exception e) {
                            billInfo.setNumber(this.createDefaultNumber());
                        }
                    }
                    if (StringUtils.isEmpty((String)billInfo.getNumber())) {
                        billInfo.setNumber(this.createDefaultNumber());
                    }
                    billInfo.setAdjustReason(EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgAdjustBillResource", (String)"balanceAdjustReason", (Locale)ctx.getLocale()));
                    entryColls = new BgAdjustBillEntryCollection();
                    billInfo.put("entity", (Object)entryColls);
                    dataMap.put(key, billInfo);
                    String[] msgStr = new String[]{oInfo.getName(), billInfo.getNumber()};
                    msg.add(msgStr);
                }
                BgAdjustBillEntryInfo targetEntryInfo = new BgAdjustBillEntryInfo();
                String memberCombinNumber = null;
                String memberCombinName = null;
                String memberRef = null;
                String srcNumber = null;
                if (param.getDimItemNumber().split(",").length > 1) {
                    int beginIndex = param.getDimItemNumber().indexOf(",") + 1;
                    memberCombinNumber = param.getDimItemNumber().substring(beginIndex);
                    int beginIndex2 = param.getDimItemName().indexOf("_") + 1;
                    memberCombinName = param.getDimItemName().substring(beginIndex2);
                    StringBuffer ref = new StringBuffer();
                    for (int i = 1; i < param.getDimItemNumber().split(",").length; ++i) {
                        ref.append("F").append(i + 2).append(",");
                    }
                    ref.deleteCharAt(ref.length() - 1);
                    memberRef = ref.toString();
                    srcNumber = memberCombinNumber.split(":")[0];
                    targetEntryInfo.setMemberCombinName((String)dimSrc2NameMap.get(srcNumber) + ":" + memberCombinName);
                    targetEntryInfo.setMemberCombinNumber(memberCombinNumber);
                    targetEntryInfo.setMemberCombinRef(memberRef);
                }
                this.createSourceEntry(param, billInfo, formulaList, bgOrgUnitInfo, bgPeriodMap, formulaSet, memberCombinName, memberCombinNumber, memberRef, dimSrc2NameMap);
                String formula = BgNFSHelper.getFormulaFromParam(param.getDimItemNumber(), parameter.getTargetPeriod().getNumber(), param.getBgElement().getNumber(), param.getCurrency().getNumber(), param.getBgScenario().getNumber());
                formulaList.add(formula);
                formulaSet.add(formula);
                String dimItemNumber = param.getDimItemNumber().split(",")[0];
                String dimItemName = param.getDimItemName().split("_")[0];
                srcNumber = dimItemNumber.split(":")[0];
                targetEntryInfo.setId(BOSUuid.create((BOSObjectType)targetEntryInfo.getBOSType()));
                targetEntryInfo.setFormula(formula);
                targetEntryInfo.setOrgUnit(bgOrgUnitInfo);
                targetEntryInfo.setPeriod(parameter.getTargetPeriod());
                targetEntryInfo.setAdjustValue(param.getOverBalance());
                targetEntryInfo.setIndexMemberNumber(dimItemNumber);
                targetEntryInfo.setIndexMemberName((String)dimSrc2NameMap.get(srcNumber) + ":" + dimItemName);
                targetEntryInfo.setIndexMemberRef("F2");
                targetEntryInfo.setBgAdjustBill(billInfo);
                entryColls.add(targetEntryInfo);
            }
            if (formulaList.isEmpty()) continue;
            Connection conn = null;
            PreparedStatement pmst = null;
            ResultSet rs = null;
            HashMap<String, BgNDataInfo> bgDataMap = new HashMap<String, BgNDataInfo>();
            try {
                BgNDataInfo _dataInfo;
                conn = EJBFactory.getConnection((Context)ctx);
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT FID,FORGUNITID,FFORMULA,FVALUE,FSTATE FROM ");
                sql.append(tableName);
                sql.append(" WHERE FORGUNITID=?");
                sql.append(" AND FFORMULA IN (");
                for (int index = 0; index < formulaList.size(); ++index) {
                    sql.append("'").append((String)formulaList.get(index)).append("',");
                }
                sql.deleteCharAt(sql.length() - 1);
                sql.append(")");
                pmst = conn.prepareStatement(sql.toString());
                pmst.setString(1, oInfo.getId().toString());
                rs = pmst.executeQuery();
                while (rs.next()) {
                    _dataInfo = new BgNDataInfo();
                    _dataInfo.setBgDataId(rs.getString("FID"));
                    _dataInfo.setFormula(rs.getString("FFORMULA"));
                    _dataInfo.setBudgetValue(rs.getBigDecimal("FVALUE"));
                    _dataInfo.setState(rs.getInt("FSTATE"));
                    bgDataMap.put(_dataInfo.getFormula(), _dataInfo);
                }
                for (String key : dataMap.keySet()) {
                    List<BgTmpDataInfo> tmpDataList;
                    billInfo = (BgAdjustBillInfo)dataMap.get(key);
                    if (!bgDataMap.isEmpty()) {
                        entryColls = billInfo.getEntity();
                        if (entryColls == null || entryColls.isEmpty()) continue;
                        for (int index = 0; index < entryColls.size(); ++index) {
                            BgAdjustBillEntryInfo entryInfo = entryColls.get(index);
                            if (!bgDataMap.containsKey(entryInfo.getFormula())) continue;
                            _dataInfo = (BgNDataInfo)bgDataMap.get(entryInfo.getFormula());
                            entryInfo.setBgDataId(BOSUuid.read((String)_dataInfo.getBgDataId()));
                            if (entryInfo.getOldValue() != null) continue;
                            entryInfo.setOldValue(_dataInfo.getBudgetValue());
                            entryInfo.setAdjustValue(_dataInfo.getBudgetValue().add(entryInfo.getAdjustValue()));
                        }
                    }
                    if ((tmpDataList = BgTmpDataImpUtil.queryTmpData(conn, oInfo.getId().toString(), rootSchemeInfo.getId().toString(), versionInfo.getVersionId())) != null && !tmpDataList.isEmpty()) {
                        for (int f = 0; f < tmpDataList.size(); ++f) {
                            if (!formulaSet.contains(tmpDataList.get(f).getFormula())) continue;
                            throw new BgAdjustException(BgAdjustException.BALANCEOVERERROR);
                        }
                    }
                    this._save(ctx, (IObjectValue)billInfo);
                }
            }
            catch (Exception e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pmst, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
            continue;
        }
        return msg;
    }

    private Map<String, String> getdimSrc2NameMap(Context ctx, Set<String> srcNumberSet, BgSchemeDimensionHelper schemeHelper) throws BOSException, EASBizException {
        HashMap<String, String> dimSrc2NameMap = new HashMap<String, String>();
        if (srcNumberSet == null || srcNumberSet.isEmpty()) {
            return dimSrc2NameMap;
        }
        for (String srcNumber : srcNumberSet) {
            dimSrc2NameMap.put(srcNumber, schemeHelper.getDimensionBySrcNumber().get(srcNumber).getAlias());
        }
        return dimSrc2NameMap;
    }

    private void getDimSrcNumber2Set(BgControlParam param, Set<String> srcNumberSet) {
        if (param == null || srcNumberSet == null || StringUtils.isEmpty((String)param.getBgIndexNumber()) || StringUtils.isEmpty((String)param.getDimItemNumber())) {
            return;
        }
        String indexMemberSrc = param.getBgIndexNumber().split(":")[0];
        srcNumberSet.add(indexMemberSrc);
        String MemberCombinNumber = param.getDimItemNumber();
        String[] MemberNumberArr = MemberCombinNumber.split(",");
        String memberSrc = null;
        for (int i = 0; i < MemberNumberArr.length; ++i) {
            memberSrc = MemberNumberArr[i].split(":")[0];
            srcNumberSet.add(memberSrc);
        }
    }

    protected void createSourceEntry(BgControlParam param, BgAdjustBillInfo billInfo, List<String> formulaList, BgOrgUnitInfo oInfo, Map<String, BgPeriodInfo> bgPeriodMap, Set<String> formulaSet, String memberCombinName, String memberCombinNumber, String memberRef, Map<String, String> dimSrc2NameMap) {
        BigDecimal adjustValue = param.getOverBalance();
        ArrayList periodKey = new ArrayList(param.getBudgetDetail().keySet());
        Collections.sort(periodKey);
        String key = null;
        BgGroupData bgGroupData = null;
        for (int i = periodKey.size() - 1; i >= 0; --i) {
            String bgPeriodNumber = (String)periodKey.get(i);
            key = param.getDimItemNumber() + "!" + bgPeriodNumber;
            bgGroupData = (BgGroupData)param.getBudgetDetail().get(key);
            if (bgGroupData == null || bgGroupData.getBudgetValue() == null || BgNConstants.ZERO.compareTo(bgGroupData.getBudgetValue()) == 0) continue;
            String formula = BgNFSHelper.getFormulaFromParam(param.getDimItemNumber(), bgPeriodNumber, param.getBgElement().getNumber(), param.getCurrency().getNumber(), param.getBgScenario().getNumber());
            formulaList.add(formula);
            formulaSet.add(formula);
            String dimItemNumber = param.getDimItemNumber().split(",")[0];
            String dimItemName = param.getDimItemName().split("_")[0];
            String srcNumber = dimItemNumber.split(":")[0];
            BgAdjustBillEntryInfo sourceEntryInfo = new BgAdjustBillEntryInfo();
            sourceEntryInfo.setId(BOSUuid.create((BOSObjectType)sourceEntryInfo.getBOSType()));
            sourceEntryInfo.setFormula(formula);
            sourceEntryInfo.setOrgUnit(oInfo);
            sourceEntryInfo.setPeriod(bgPeriodMap.get(bgPeriodNumber));
            sourceEntryInfo.setIndexMemberNumber(dimItemNumber);
            sourceEntryInfo.setIndexMemberName(dimSrc2NameMap.get(srcNumber) + ":" + dimItemName);
            sourceEntryInfo.setIndexMemberRef("F2");
            if (!StringUtils.isEmpty((String)memberCombinNumber)) {
                sourceEntryInfo.setMemberCombinNumber(memberCombinNumber);
            }
            if (!StringUtils.isEmpty((String)memberCombinName)) {
                srcNumber = memberCombinNumber.split(":")[0];
                sourceEntryInfo.setMemberCombinName(dimSrc2NameMap.get(srcNumber) + ":" + memberCombinName);
            }
            if (!StringUtils.isEmpty((String)memberRef)) {
                sourceEntryInfo.setMemberCombinRef(memberRef);
            }
            sourceEntryInfo.setBgAdjustBill(billInfo);
            billInfo.getEntity().add(sourceEntryInfo);
            if (adjustValue.compareTo(bgGroupData.getBudgetValue()) > 0) {
                sourceEntryInfo.setOldValue(bgGroupData.getBudgetValue());
                sourceEntryInfo.setAdjustValue(BgNConstants.ZERO);
                adjustValue = adjustValue.subtract(bgGroupData.getBudgetValue());
                continue;
            }
            sourceEntryInfo.setOldValue(bgGroupData.getBudgetValue());
            sourceEntryInfo.setAdjustValue(bgGroupData.getBudgetValue().subtract(adjustValue));
            break;
        }
    }

    private String getControlPeriodKey(BgControlParam param) {
        if (param == null) {
            return null;
        }
        BgControlSettingInfo controlSetting = param.getControlSetting();
        if (controlSetting == null) {
            controlSetting = BgControlSettingInfo.getDefaultSet();
        }
        return controlSetting.getCtrlType().getValue() + "_" + controlSetting.getPeriodType().getValue();
    }

    @Override
    protected Map _queryDataByParameters(Context ctx, Map parameters) throws BOSException, EASBizException {
        if (parameters == null || parameters.isEmpty()) {
            return null;
        }
        HashMap<Integer, Object> returnValue = new HashMap<Integer, Object>();
        Iterator iterator = parameters.keySet().iterator();
        while (iterator.hasNext()) {
            int rowIndex = (Integer)iterator.next();
            Object value = this._queryDataByParameter(ctx, (BgAdjustBillParameter)parameters.get(rowIndex));
            returnValue.put(rowIndex, value);
        }
        return returnValue;
    }

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BgAdjustBillInfo info = (BgAdjustBillInfo)model;
        this.checkNumberRepeat(ctx, info);
        return false;
    }

    protected void checkNumberRepeat(Context ctx, BgAdjustBillInfo info) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)info.getNumber()) || info.getOrgUnit() == null || info.getBgScheme() == null) {
            return;
        }
        String id = "000000000000000000000000000=";
        if (info.getId() != null) {
            id = info.getId().toString();
        }
        Connection conn = null;
        PreparedStatement pmst = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pmst = conn.prepareStatement("SELECT FNUMBER FROM T_MBG_BGADJUSTBILL WHERE FNUMBER=? AND FORGUNIT=? AND FID<>? AND FBgScheme=?");
            pmst.setString(1, info.getNumber());
            pmst.setString(2, info.getOrgUnit().getId().toString());
            pmst.setString(3, id);
            pmst.setString(4, info.getBgScheme().getId().toString());
            rs = pmst.executeQuery();
            if (rs.next()) {
                throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{info.getNumber(), ""});
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
    }

    @Override
    @Deprecated
    protected void _checkNumberRepeat(Context ctx, String number, String orgunitId, String id) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)number) || StringUtils.isEmpty((String)orgunitId) || StringUtils.isEmpty((String)id)) {
            return;
        }
        Connection conn = null;
        PreparedStatement pmst = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pmst = conn.prepareStatement("SELECT FNUMBER FROM T_MBG_BGADJUSTBILL WHERE FNUMBER=? AND FORGUNIT=? AND FID<>?");
            pmst.setString(1, number);
            pmst.setString(2, orgunitId);
            pmst.setString(3, id);
            rs = pmst.executeQuery();
            if (rs.next()) {
                throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{number, ""});
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
    }

    @Override
    protected Object _batchDelete(Context ctx, Object ids) throws BOSException, EASBizException {
        if (!(ids instanceof List)) {
            return null;
        }
        List idList = (List)ids;
        MbgTmpDataUtils.deleteTmpData(ctx, idList);
        MbgTmpDataUtils.deleteTmpEntryData(ctx, idList);
        int size = idList.size();
        for (int index = 0; index < size; ++index) {
            this._delete(ctx, (IObjectPK)new ObjectUuidPK((String)idList.get(index)));
        }
        return null;
    }

    @Override
    protected Object _batchAudit(Context ctx, Object ids, BgPastSourceEnum bgPastSource) throws BOSException, EASBizException {
        return this._batchAudit(ctx, ids, bgPastSource, null);
    }

    @Override
    protected Object _batchAudit(Context ctx, Object ids, BgPastSourceEnum bgPastSource, Map auditParams) throws BOSException, EASBizException {
        if (!(ids instanceof List)) {
            return null;
        }
        List idList = (List)ids;
        if (idList.isEmpty()) {
            return null;
        }
        int size = idList.size();
        for (int index = 0; index < size; ++index) {
            this._audit(ctx, BOSUuid.read((String)((String)idList.get(index))), bgPastSource);
        }
        return null;
    }

    protected boolean _submitWorkflow(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        BgAdjustBillInfo info = (BgAdjustBillInfo)this._getValue(ctx, "select state where id = '" + id + "'");
        if (BgAdjustBillStateEnum.audit.equals((Object)info.getState())) {
            throw new BgAdjustException(BgAdjustException.CHECKREFER);
        }
        return true;
    }

    @Override
    protected void _auditSubmit(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        BgAdjustBillInfo adjustBillInfo;
        if (id == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IBgAdjustBill iAdjustBill = BgAdjustBillFactory.getLocalInstance(ctx);
        if (iAdjustBill.exists((IObjectPK)pk)) {
            adjustBillInfo = iAdjustBill.getBgAdjustBillInfo((IObjectPK)pk, this.getStateSelectors());
            if (!BgAdjustBillStateEnum.adjusting.equals((Object)adjustBillInfo.getState())) {
                throw new BgAdjustException(BgAdjustException.SUBMITWORKERROR);
            }
        } else {
            throw new BgAdjustException(BgAdjustException.NOMODEL);
        }
        adjustBillInfo.setState(BgAdjustBillStateEnum.submit);
        adjustBillInfo.setBizDate(new Date());
        super._updatePartial(ctx, (IObjectValue)adjustBillInfo, this.getStateSelectors());
    }

    @Override
    protected void _auditAdjust(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IBgAdjustBill iAdjustBill = BgAdjustBillFactory.getLocalInstance(ctx);
        if (!iAdjustBill.exists((IObjectPK)pk)) {
            throw new BgAdjustException(BgAdjustException.NOMODEL);
        }
        BgAdjustBillInfo adjustBillInfo = iAdjustBill.getBgAdjustBillInfo((IObjectPK)pk, this.getStateSelectors());
        adjustBillInfo.setState(BgAdjustBillStateEnum.adjusting);
        adjustBillInfo.setBizDate(new Date());
        super._updatePartial(ctx, (IObjectValue)adjustBillInfo, this.getStateSelectors());
    }

    @Override
    protected void _auditApproving(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        BgAdjustBillInfo adjustBillInfo;
        if (id == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IBgAdjustBill iAdjustBill = BgAdjustBillFactory.getLocalInstance(ctx);
        if (iAdjustBill.exists((IObjectPK)pk)) {
            adjustBillInfo = iAdjustBill.getBgAdjustBillInfo((IObjectPK)pk, this.getStateSelectors());
            if (!BgAdjustBillStateEnum.submit.equals((Object)adjustBillInfo.getState())) {
                throw new BgAdjustException(BgAdjustException.AUDITAPPROVINGNOSUBMIT);
            }
        } else {
            throw new BgAdjustException(BgAdjustException.NOMODEL);
        }
        adjustBillInfo.setState(BgAdjustBillStateEnum.auditing);
        super._updatePartial(ctx, (IObjectValue)adjustBillInfo, this.getStateSelectors());
    }

    @Override
    protected void _auditApproved(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IBgAdjustBill iAdjustBill = BgAdjustBillFactory.getLocalInstance(ctx);
        if (iAdjustBill.exists((IObjectPK)pk)) {
            BgAdjustBillInfo adjustBillInfo = iAdjustBill.getBgAdjustBillInfo((IObjectPK)pk, this.getStateSelectors());
            if (!BgAdjustBillStateEnum.submit.equals((Object)adjustBillInfo.getState()) && !BgAdjustBillStateEnum.auditing.equals((Object)adjustBillInfo.getState())) {
                throw new BgAdjustException(BgAdjustException.AUDITAPPROVINGNOSUBMIT);
            }
            List list = BgAdjustBillFactory.getLocalInstance(ctx).adjustCheck(id);
            if (null != list && !list.isEmpty()) {
                throw new BgAdjustException(BgAdjustException.CHECKADJUSTNOPASS);
            }
            if (adjustBillInfo.getType().getValue() <= 1) {
                this._audit(ctx, id, BgPastSourceEnum.REGULATEBILL);
            } else {
                this._audit(ctx, id, BgPastSourceEnum.ADJUSTBILL);
            }
        } else {
            throw new BgAdjustException(BgAdjustException.NOMODEL);
        }
    }

    protected SelectorItemCollection getStateSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("type"));
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BgSchemeInfo getRootSchemeInfo(Context ctx, String schemeId) throws SQLException {
        ResultSet rs;
        PreparedStatement pmst;
        Connection conn;
        block3: {
            BgSchemeInfo bgSchemeInfo;
            if (ctx == null || StringUtils.isEmpty((String)schemeId)) {
                return null;
            }
            conn = null;
            pmst = null;
            rs = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                pmst = conn.prepareStatement("SELECT FID,FNUMBER,FNAME_" + ctx.getLocale() + ",FREFCUBE FROM T_MBG_BGSCHEME WHERE FID=?");
                pmst.setString(1, schemeId);
                rs = pmst.executeQuery();
                if (!rs.next()) break block3;
                BgSchemeInfo info = new BgSchemeInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                info.setNumber(rs.getString("FNUMBER"));
                info.setName(rs.getString("FNAME_" + ctx.getLocale()));
                info.setRefCube(rs.getString("FREFCUBE"));
                bgSchemeInfo = info;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
            return bgSchemeInfo;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
        return null;
    }

    @Override
    protected List _batchDelete(Context ctx, Set ids) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Object _getOrgSchemeDispLeaf(Context ctx, Object parameter) throws BOSException, EASBizException {
        HashSet<String> hashSet;
        BgSchemeInfo info;
        ResultSet rs;
        PreparedStatement pmst;
        Connection conn;
        HashMap<String, BgSchemeInfo> dataMap;
        HashSet parantIds;
        block8: {
            if (ctx == null || parameter == null) {
                return null;
            }
            String id = (String)parameter;
            String sql = "SELECT FID,FORGUNITID FROM T_MBG_BGSCHEME WHERE FID = ?";
            parantIds = new HashSet();
            dataMap = new HashMap<String, BgSchemeInfo>();
            conn = null;
            pmst = null;
            rs = null;
            conn = EJBFactory.getConnection((Context)ctx);
            pmst = conn.prepareStatement(sql);
            pmst.setString(1, id);
            rs = pmst.executeQuery();
            while (rs.next()) {
                info = new BgSchemeInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                FullOrgUnitInfo org = new FullOrgUnitInfo();
                org.setId(BOSUuid.read((String)rs.getString("FORGUNITID")));
                info.setOrgUnit(org);
                dataMap.put(rs.getString("FID"), info);
            }
            if (!dataMap.isEmpty()) break block8;
            Object var12_12 = null;
            SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
            return var12_12;
        }
        try {
            HashSet<String> orgId = new HashSet<String>();
            for (String key : dataMap.keySet()) {
                info = (BgSchemeInfo)dataMap.get(key);
                if (parantIds.contains(info.getId().toString())) continue;
                orgId.add(info.getOrgUnit().getId().toString());
            }
            hashSet = orgId;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
        return hashSet;
    }

    public Map<String, BgOrgUnitInfo> getBgOrgUnitInfo(Context ctx, String bgSchemeID, OrgUnitInfo[] orgUnitInfos) throws EASBizException, BOSException {
        HashMap<String, BgOrgUnitInfo> revMap = new HashMap<String, BgOrgUnitInfo>();
        if (StringUtils.isEmpty((String)bgSchemeID) || EmptyUtil.isEmpty((Object[])orgUnitInfos)) {
            return revMap;
        }
        String bgOrgViewID = this.getBgOrgViewID(ctx, bgSchemeID);
        if (StringUtils.isEmpty((String)bgOrgViewID)) {
            return revMap;
        }
        HashSet<String> ids = new HashSet<String>();
        for (OrgUnitInfo info : orgUnitInfos) {
            if (info == null || info.getId() == null) continue;
            ids.add(info.getId().toString());
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("orgUnitID"));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnitID", ids, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)bgOrgViewID, CompareType.EQUALS));
        evi.setFilter(filter);
        evi.getSelector().addObjectCollection((IObjectCollection)sic);
        BgOrgUnitCollection bgOrgUnitCol = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(evi);
        BgOrgUnitInfo info = null;
        int size = bgOrgUnitCol.size();
        for (int i = 0; i < size; ++i) {
            info = bgOrgUnitCol.get(i);
            if (info == null || info.getId() == null) continue;
            revMap.put(info.getOrgUnitID(), info);
        }
        return revMap;
    }

    public String getBgOrgViewID(Context ctx, String schemeID) throws EASBizException, BOSException {
        return null;
    }

    private SelectorItemCollection getSelectorForAudit() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("lastUpdateUser.id");
        sic.add("auditor.id");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("bgScheme.id");
        sic.add("bgScheme.number");
        sic.add("bgScheme.name");
        sic.add("bgScheme.dateFrom");
        sic.add("bgScheme.dateTo");
        sic.add("bgScheme.period");
        sic.add("bgScheme.refCube");
        sic.add("bgScheme.refDims.*");
        sic.add("bgScheme.refDims.indexSource.*");
        sic.add("bgScheme.refDims.dimension.*");
        sic.add("bgScheme.refDims.members.*");
        sic.add("bgScenario.id");
        sic.add("bgScenario.number");
        sic.add("bgScenario.name");
        sic.add("bgScenario.scenarioId");
        sic.add("bgVersion.id");
        sic.add("bgVersion.number");
        sic.add("bgVersion.name");
        sic.add("bgVersion.versionId");
        sic.add("element.id");
        sic.add("element.number");
        sic.add("element.name");
        sic.add("entity.*");
        sic.add("entity.orgUnit.id");
        sic.add("entity.orgUnit.number");
        sic.add("entity.orgUnit.orgUnitID");
        sic.add("entity.orgUnit.name");
        sic.add("entity.period.id");
        sic.add("entity.period.number");
        sic.add("entity.period.name");
        sic.add("state");
        sic.add("type");
        return sic;
    }

    @Override
    protected List _adjustCheck(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (billId == null) {
            return null;
        }
        if (!BgParamNHelper.isAdjustCheck((Context)ctx)) {
            return null;
        }
        HashSet<String> ids = new HashSet<String>();
        ids.add(billId.toString());
        return this._adjustCheck(ctx, ids);
    }

    @Override
    protected List _adjustCheck(Context ctx, Set billIds) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("bgVersion.number");
        evi.getSelector().add("bgVersion.id");
        evi.getSelector().add("bgScheme.id");
        evi.getSelector().add("entity.orgUnit.id");
        evi.getSelector().add("entity.orgUnit.orgUnitId");
        evi.getSelector().add("entity.adjustValue");
        evi.getSelector().add("entity.oldValue");
        evi.getSelector().add("entity.formula");
        evi.getSelector().add("processType");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)billIds, CompareType.INCLUDE));
        BgAdjustBillCollection col = this.getBgAdjustBillCollection(ctx, evi);
        return this._adjustCheck(ctx, (IObjectCollection)col);
    }

    @Override
    protected List _adjustCheck(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        if (info == null) {
            return null;
        }
        BgAdjustBillCollection col = new BgAdjustBillCollection();
        col.addObject(info);
        return this._adjustCheck(ctx, (IObjectCollection)col);
    }

    protected List _adjustCheck(Context ctx, IObjectCollection infos) throws BOSException, EASBizException {
        BgAdjustBillCollection col = (BgAdjustBillCollection)infos;
        if (col == null || col.isEmpty()) {
            return null;
        }
        HashMap adjustMap = new HashMap();
        BgAdjustBillInfo info = null;
        BgAdjustBillEntryInfo entryInfo = null;
        Map subAdjustMap = null;
        String bgSchemeId2 = null;
        String orgUnitId = null;
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            if (!info.getBgVersion().getId().toString().equals("fTNjgVF9TXy80oY2shobskGwJT4=") || !BgProcessEnum.C01.equals((Object)info.getProcessType())) continue;
            bgSchemeId2 = info.getBgScheme().getId().toString();
            if (!adjustMap.containsKey(bgSchemeId2)) {
                adjustMap.put(bgSchemeId2, new HashMap());
            }
            subAdjustMap = (Map)adjustMap.get(bgSchemeId2);
            for (int e = 0; e < info.getEntity().size(); ++e) {
                entryInfo = info.getEntity().get(e);
                orgUnitId = entryInfo.getOrgUnit().getOrgUnitID();
                if (!subAdjustMap.containsKey(orgUnitId)) {
                    subAdjustMap.put(orgUnitId, new HashMap());
                }
                ((Map)subAdjustMap.get(orgUnitId)).put(entryInfo.getFormula(), entryInfo.getAdjustValue().subtract(entryInfo.getOldValue()));
            }
        }
        ArrayList list = new ArrayList();
        List subList = null;
        for (String bgSchemeId2 : adjustMap.keySet()) {
            subList = BgAdjustFacadaFactory.getLocalInstance(ctx).adjustCheck(bgSchemeId2, (Map)adjustMap.get(bgSchemeId2));
            if (subList == null) continue;
            list.addAll(subList);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    @Override
    protected BgPeriodCollection _getBgPeriodCol(Context ctx, String billId) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        BgPeriodCollection colls;
        block9: {
            if (billId == null) {
                return null;
            }
            colls = null;
            conn = null;
            pstmt = null;
            rs = null;
            String sql = "select fperiodId ,fseq from T_mbg_adjustBillPeriods where fbillid = ? order by fseq";
            String periodId = null;
            LinkedHashSet<String> periodSet = new LinkedHashSet<String>();
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, billId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    periodId = rs.getString("fperiodId");
                    periodSet.add(periodId);
                }
                if (periodSet.size() <= 0) break block9;
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(periodSet), CompareType.INCLUDE));
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add("id");
                evi.getSelector().add("number");
                evi.getSelector().add("name");
                evi.getSelector().add("longNumber");
                colls = BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodCollection(evi);
                if (colls != null && !colls.isEmpty()) {
                    HashMap<String, BgPeriodInfo> bgPeriodMap = new HashMap<String, BgPeriodInfo>();
                    for (int i = 0; i < colls.size(); ++i) {
                        bgPeriodMap.put(colls.get(i).getId().toString(), colls.get(i));
                    }
                    colls = new BgPeriodCollection();
                    for (String id : periodSet) {
                        if (!bgPeriodMap.containsKey(id)) continue;
                        colls.add((BgPeriodInfo)bgPeriodMap.get(id));
                    }
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"data Query:", (Throwable)ex);
                    throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return colls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _getPeriodNames(Context ctx, Set bgAdjustIds) throws BOSException, EASBizException {
        if (bgAdjustIds == null || bgAdjustIds.isEmpty()) {
            return null;
        }
        final HashMap idNames = new HashMap();
        StringBuffer sql = new StringBuffer();
        sql.append("select billPeriods.FBillId, period.FName_" + ctx.getLocale() + " FROM T_mbg_adjustBillPeriods billPeriods, T_MBG_BgPeriod period Where billPeriods.FPeriodId = period.FID AND billPeriods.FBillId IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(") order By billPeriods.FBillId, period.FNumber");
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])bgAdjustIds.toArray(), (int)50), (IResultReader)new IResultReader(){

                public void read(ResultSet res) throws SQLException {
                    String id = res.getString(1);
                    StringBuffer name = null;
                    if (idNames.containsKey(id)) {
                        name = (StringBuffer)idNames.get(id);
                    } else {
                        name = new StringBuffer();
                        idNames.put(id, name);
                    }
                    if (name.length() > 0) {
                        name.append(", ");
                    }
                    name.append(res.getString(2));
                }
            });
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return idNames;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    @Override
    protected void _updatePartial(Context ctx, IObjectValue model, SelectorItemCollection selector) throws BOSException, EASBizException {
        super._updatePartial(ctx, model, selector);
    }

    @Override
    protected void _storePeriodCol(Context ctx, Map periodIdSeqMap, String billId) throws BOSException, EASBizException {
        if (billId == null || billId == null || billId.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pst = null;
        String period2 = null;
        String tableName = "T_mbg_adjustBillPeriods";
        String sqlDel = "delete from T_mbg_adjustBillPeriods where fbillid = ?";
        StringBuffer sql = new StringBuffer();
        int batchIndex = 0;
        sql.append(" Insert Into " + tableName + " (FbillID, fperiodId,fseq) Values (?,?,?)");
        try {
            conn = this.getConnection(ctx);
            pst = conn.prepareStatement(sqlDel);
            pst.setString(1, billId);
            pst.execute();
            pstmt = conn.prepareStatement(sql.toString());
            for (String period2 : periodIdSeqMap.keySet()) {
                pstmt.setString(1, billId);
                pstmt.setString(2, period2);
                pstmt.setInt(3, (Integer)periodIdSeqMap.get(period2));
                pstmt.addBatch();
                if (++batchIndex < 50) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"data addNew:", (Throwable)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst);
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pst);
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected Map _queryDataByParameters(Context ctx, BgAdjustBillParameter parameters, String orgId) throws BOSException, EASBizException {
        throw new BOSException("not support");
    }

    @Override
    protected boolean _submitWorkflow(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model != null && model instanceof BgAdjustBillInfo) {
            BgAdjustBillInfo info = (BgAdjustBillInfo)model;
            info = (BgAdjustBillInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), this.getSelectorForAudit());
            this._verifyDataBeforeSave(ctx, (IObjectValue)info);
            if (BgAdjustBillStateEnum.audit.equals((Object)info.getState())) {
                throw new BgAdjustException(BgAdjustException.CHECKREFER);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void _discard(Context ctx, List ids) throws BOSException, EASBizException {
        if (!(ids instanceof List)) {
            return;
        }
        List idList = ids;
        for (int i = 0; i < idList.size(); ++i) {
            this._discard(ctx, BOSUuid.read((String)((String)idList.get(i))));
            this._updateDiscardState(ctx, BOSUuid.read((String)((String)idList.get(i))));
        }
    }

    @Override
    protected void _discard(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(id.toString());
        MbgTmpDataUtils.deleteTmpData(ctx, idList);
    }

    @Override
    protected void _updateDiscardState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        MbgSqlHelper.execute((Context)ctx, (String)"update T_MBG_BgAdjustBill set fstate = 5  where FId = ?", (String)id.toString());
    }

    @Override
    protected void _checkNeedUpdatePeriodNames(Context ctx, String billID) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement pst;
        PreparedStatement pstmt;
        Connection conn;
        block9: {
            conn = null;
            pstmt = null;
            pst = null;
            rs = null;
            StringBuffer sql = new StringBuffer();
            StringBuffer sql1 = new StringBuffer();
            int batchIndex = 0;
            sql.append(" update t_mbg_bgadjustbill set fperiodNames =?  where fid = ?");
            sql1.append(" SELECT fid FROM t_mbg_bgadjustbill where FPERIODNames is null");
            try {
                HashSet<String> idSet = new HashSet<String>();
                String billId2 = null;
                conn = this.getConnection(ctx);
                if (billID == null) {
                    pst = conn.prepareStatement(sql1.toString());
                    rs = pst.executeQuery();
                    while (rs.next()) {
                        billId2 = rs.getString("fid");
                        idSet.add(billId2);
                    }
                } else {
                    idSet.add(billID);
                }
                if (idSet == null || idSet.size() <= 0) break block9;
                Map map = this.getPeriodNames(ctx, idSet);
                pstmt = conn.prepareStatement(sql.toString());
                for (String billId2 : map.keySet()) {
                    pstmt.setString(1, ((StringBuffer)map.get(billId2)).toString());
                    pstmt.setString(2, billId2);
                    pstmt.addBatch();
                    if (++batchIndex < 50) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                }
                if (batchIndex != 0) {
                    pstmt.executeBatch();
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"data addNew:", (Throwable)ex);
                    throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pst);
                    SQLUtils.cleanup(rs, pstmt, conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)pst);
        SQLUtils.cleanup((ResultSet)rs, pstmt, (Connection)conn);
    }
}

