/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectSingleKey;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgItemGroupFactory;
import com.kingdee.eas.ma.base.BgItemGroupInfo;
import com.kingdee.eas.ma.base.IBgItemGroup;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.control.face.IBudgetBalance;
import com.kingdee.eas.ma.control.impl.BgAdjustBanaceOverImpl;
import com.kingdee.eas.ma.mbg.BgAdjustFacadaFactory;
import com.kingdee.eas.ma.mbg.DimSrcTypeEnum;
import com.kingdee.eas.ma.mbg.DimensionFactory;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.DimensionInfo;
import com.kingdee.eas.ma.mbg.DimensionSourceCollection;
import com.kingdee.eas.ma.mbg.DimensionSourceInfo;
import com.kingdee.eas.ma.mbg.IDimension;
import com.kingdee.eas.ma.mbg.IDimensionFormulaFacade;
import com.kingdee.eas.ma.mbg.MbgAdjustBillConstant;
import com.kingdee.eas.ma.mbg.app.AbstractBgAdjustBillFacadeControllerBean;
import com.kingdee.eas.ma.mbg.common.BgAdjustBillBalanceOverParameter;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.MBGAdjustBillHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgAdjustBillFacadeControllerBean
extends AbstractBgAdjustBillFacadeControllerBean {
    private static final long serialVersionUID = 2297889836446462547L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgAdjustBillFacadeControllerBean");

    @Override
    protected Map _getDimSrcGroupName(Context ctx, Map parameterMap) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        Set set = (Set)parameterMap.get("MBG_ADJUST_PARAMETER_KEY_REFFIELD");
        IDimension dimension = DimensionFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("refField", (Object)set, CompareType.INCLUDE));
        view.setFilter(filter);
        CoreBaseCollection collection = dimension.getCollection(view);
        if (collection != null && !collection.isEmpty()) {
            int count = collection.size();
            for (int i = 0; i < count; ++i) {
                DimensionInfo coreBaseInfo = (DimensionInfo)collection.get(i);
                DimensionSourceCollection srcs = coreBaseInfo.getSrcs();
                for (int j = 0; j < srcs.size(); ++j) {
                    DimensionSourceInfo dimensionSourceInfo = srcs.get(j);
                    DimSrcTypeEnum srcType = dimensionSourceInfo.getSrcType();
                    if (DimSrcTypeEnum.BaseData.equals((Object)srcType)) {
                        String srcID = dimensionSourceInfo.getSrcID();
                        IBgItemGroup localInstance = BgItemGroupFactory.getLocalInstance((Context)ctx);
                        BgItemGroupInfo value = localInstance.getBgItemGroupInfo((IObjectPK)new ObjectSingleKey((Object)srcID));
                        String name = value.getName();
                        String key = coreBaseInfo.getRefField() + ":" + value.getNumber();
                        map.put(key, name);
                        continue;
                    }
                    map.put(coreBaseInfo.getRefField(), coreBaseInfo.getName());
                }
            }
        }
        return map;
    }

    @Override
    protected Map _importBgAdjustBillService(Context ctx, Map dataMap, Map paramMap, Map errorData) throws BOSException, EASBizException {
        HashMap<String, Map> result;
        block7: {
            result = new HashMap<String, Map>();
            this.checkParamters(dataMap, paramMap, errorData);
            HashMap<Integer, HashMap> returnData = new HashMap<Integer, HashMap>();
            result.put("passedData", returnData);
            try {
                String orgID = (String)paramMap.get("MBG_ADJUST_PARAMETER_KEY_ORGUNIT_ID");
                Set<String> notSealUpDetailOrgSet = null;
                Set<String> detailMemeberKeySet = null;
                HashMap<String, String> orgUnitMap = new HashMap<String, String>();
                String bgSchemeId = paramMap.get("MBG_ADJUST_PARAMETER_KEY_SCHEME_ID").toString();
                BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
                notSealUpDetailOrgSet = this.getNotSealUpDetailOrgSet(ctx, schemeHelper);
                ArrayList<String> combin = new ArrayList<String>();
                Object headkeyData = dataMap.get(0);
                if (headkeyData != null && headkeyData instanceof HashMap) {
                    HashMap headKeyData = (HashMap)headkeyData;
                    for (String str : ((Map)headkeyData).keySet()) {
                        if (!str.startsWith("F") || str.startsWith("F2_") || str.endsWith("_SUFFIX")) continue;
                        combin.add(str);
                    }
                    detailMemeberKeySet = this.getDetailMemeberKeySet(ctx, orgID, combin, dataMap, schemeHelper);
                    Integer key = -1;
                    HashMap rowValue = null;
                    Iterator it = dataMap.keySet().iterator();
                    while (it.hasNext()) {
                        key = Integer.parseInt(it.next().toString());
                        rowValue = (HashMap)dataMap.get(key);
                        if (key.equals(MbgAdjustBillConstant.MBG_HEADKEY_LINE)) {
                            returnData.put(Integer.parseInt(key.toString()), rowValue);
                            continue;
                        }
                        boolean checkResult = this.validateOrgUnit(ctx, orgUnitMap, key, rowValue, errorData, paramMap, notSealUpDetailOrgSet);
                        checkResult = checkResult ? this.validate1(detailMemeberKeySet, key, rowValue, errorData) : false;
                        String combinNumber = null;
                        for (int i = 0; checkResult && i < combin.size(); ++i) {
                            combinNumber = (String)combin.get(i);
                            checkResult = checkResult ? this.validate2(headKeyData, key, rowValue, detailMemeberKeySet, combinNumber, errorData) : false;
                        }
                        if (!checkResult) continue;
                        returnData.put(Integer.parseInt(key.toString()), rowValue);
                    }
                    break block7;
                }
                logger.error((Object)"get index list failed!");
                throw new EASBizException(EASBizException.CHECKINT);
            }
            catch (Exception e) {
                logger.error((Object)"get index list failed!");
                throw new BOSException((Throwable)e);
            }
        }
        result.put("errorData", errorData);
        return result;
    }

    private Set<String> getDetailMemeberKeySet(Context ctx, String orgID, List<String> combin, Map dataMap, BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        HashSet<String> detailMemeberKeySet = new HashSet<String>();
        HashMap<String, Set<String>> srcNum2MemberNumMap = new HashMap<String, Set<String>>();
        String indexSrcNumber = null;
        String indexNumber = null;
        String combinSrcNumber = null;
        String combinNumber = null;
        String combinSrcKey = null;
        Iterator it = dataMap.keySet().iterator();
        while (it.hasNext()) {
            Integer key = Integer.parseInt(it.next().toString());
            HashMap value = (HashMap)dataMap.get(key);
            if (key.equals(MbgAdjustBillConstant.MBG_HEADKEY_LINE)) continue;
            indexSrcNumber = (String)value.get("MBG_HEADKEY_INDEX_GROUP_NUMBER");
            indexNumber = (String)value.get("MBG_HEADKEY_INDEX_MEMBER_NUMBER");
            this.addSrcNum2MemberNumMapEle(srcNum2MemberNumMap, indexSrcNumber, indexNumber);
            for (int i = 0; i < combin.size(); ++i) {
                combinSrcKey = combin.get(i);
                combinSrcNumber = combinSrcKey.split("_")[1];
                combinNumber = (String)value.get(combinSrcKey);
                this.addSrcNum2MemberNumMapEle(srcNum2MemberNumMap, combinSrcNumber, combinNumber);
            }
        }
        IDimensionFormulaFacade formulaFacade = DimensionFormulaFacadeFactory.getLocalInstance(ctx);
        Map revMap = formulaFacade.getLeafMember(orgID, schemeHelper.getBgSchemeId(), srcNum2MemberNumMap, schemeHelper.getDimensionBySrcNumber(), false);
        String srcNum = null;
        String key = null;
        Set memberNumSet = null;
        for (Object object : revMap.keySet()) {
            srcNum = (String)object;
            memberNumSet = (Set)revMap.get(srcNum);
            if (memberNumSet.isEmpty()) continue;
            for (String memberNum : memberNumSet) {
                if (StringUtils.isEmpty((String)memberNum) || detailMemeberKeySet.contains(key = srcNum + "_" + memberNum)) continue;
                detailMemeberKeySet.add(key);
            }
        }
        return detailMemeberKeySet;
    }

    private void addSrcNum2MemberNumMapEle(Map<String, Set<String>> srcNum2MemberNumMap, String srcNumber, String number) {
        if (srcNum2MemberNumMap == null || StringUtils.isEmpty((String)srcNumber) || StringUtils.isEmpty((String)number)) {
            return;
        }
        Set<Object> memeberNumSet = null;
        if (srcNum2MemberNumMap.containsKey(srcNumber)) {
            memeberNumSet = srcNum2MemberNumMap.get(srcNumber);
            if (!memeberNumSet.contains(number)) {
                memeberNumSet.add(number);
            }
        } else {
            memeberNumSet = new HashSet();
            memeberNumSet.add(number);
            srcNum2MemberNumMap.put(srcNumber, memeberNumSet);
        }
    }

    private Set<String> getNotSealUpDetailOrgSet(Context ctx, BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        Set<String> notSealUpDetailOrgSet = new HashSet<String>();
        if (schemeHelper == null) {
            return notSealUpDetailOrgSet;
        }
        String orgViewID = null;
        if (schemeHelper.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER) != null) {
            orgViewID = schemeHelper.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId();
            notSealUpDetailOrgSet = this.getBgOrgNumberSet(ctx, orgViewID);
        }
        return notSealUpDetailOrgSet;
    }

    private Set<String> getBgOrgNumberSet(Context ctx, String orgViewID) throws BOSException {
        HashSet<String> notSealUpDetailOrgSet = new HashSet<String>();
        if (StringUtils.isEmpty((String)orgViewID)) {
            return notSealUpDetailOrgSet;
        }
        StringBuffer sql = new StringBuffer("SELECT FNUMBER FROM T_MBG_BGORGUNIT WHERE FVIEWID = '" + orgViewID + "'");
        sql.append(" AND FISOUSEALUP = '0'");
        sql.append(" AND FISLEAF = '1'");
        ISQLExecutor sqlExecutor = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString());
        IRowSet rs = null;
        try {
            rs = sqlExecutor.executeSQL();
            String fNumber = null;
            while (rs.next()) {
                fNumber = rs.getString(1);
                if (fNumber == null) continue;
                notSealUpDetailOrgSet.add(fNumber);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return notSealUpDetailOrgSet;
    }

    private void checkParamters(Map dataMap, Map paramMap, Map errorData) {
        if (dataMap == null || !(dataMap instanceof Map)) {
            new BgException(BgException.ILLEGALARGUMENT);
        }
        if (paramMap == null || !(paramMap instanceof Map)) {
            new BgException(BgException.ILLEGALARGUMENT);
        }
        if (!paramMap.containsKey("MBG_ADJUST_PARAMETER_KEY_WAY")) {
            new BgException(BgException.ILLEGALARGUMENT);
        }
        if (errorData == null) {
            errorData = new HashMap();
        }
    }

    private boolean validateOrgUnit(Context ctx, Map<String, String> orgUnitMap, Integer key, HashMap<String, String> value, Map errorDataMap, Map paramMap, Set<String> notSealUpDetailOrgSet) throws BOSException, EASBizException {
        String orgNumber = value.get("MBG_HEADKEY_COSTCENTER_ORG_NUMBER");
        boolean isAdjustRangOrgUnit = (Boolean)paramMap.get("MBG_ADJUST_PARAMETER_KEY_WAY");
        if (isAdjustRangOrgUnit) {
            if (orgUnitMap.containsKey(orgNumber)) {
                return true;
            }
            if (StringUtils.isEmpty((String)orgNumber)) {
                String errorInfo = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"MBG_ERROR_ORGUNIT_NUMBER_IS_NULL", (Object[])new Object[]{key + 1});
                this.addErrorDataInfo(errorDataMap, key, value, errorInfo);
                return false;
            }
            if (!notSealUpDetailOrgSet.contains(orgNumber)) {
                String messageStr = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"MBG_ERROR_IS_NOT_DETAILED_ORGUNIT", (Object[])new Object[]{key + 1});
                this.addErrorDataInfo(errorDataMap, key, value, messageStr);
                return false;
            }
            orgUnitMap.put(orgNumber, "");
            return true;
        }
        return true;
    }

    private String checkOrgUnitIsExist(Context ctx, Integer key, HashMap<String, String> value, Map errorDataMap, String orgNumber) throws BOSException, EASBizException {
        ICostCenterOrgUnit localInstance = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)orgNumber, CompareType.EQUALS));
        if (!localInstance.exists(filter)) {
            String messageStr = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"MBG_ERROR_ORGUNIT_NOT_EXIST", (Object[])new Object[]{key + 1, value.get("MBG_HEADKEY_COSTCENTER_ORG_NAME")});
            this.addErrorDataInfo(errorDataMap, key, value, messageStr);
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        CostCenterOrgUnitCollection costCenterOrgUnitCollection = localInstance.getCostCenterOrgUnitCollection(view);
        String orgUnitId = costCenterOrgUnitCollection.get(0).getId().toString();
        return orgUnitId;
    }

    private boolean isDetailedOrgUnitUnderScheme(Context ctx, String orgUnitId, String bgSchemeId) throws EASBizException, BOSException {
        return BgAdjustFacadaFactory.getLocalInstance(ctx).isLeafOrgUnit(orgUnitId, bgSchemeId);
    }

    private boolean validate1(Set<String> detailMemeberKeySet, int key, HashMap<String, String> value, Map errorDataInfo) {
        if (detailMemeberKeySet == null || value == null || value.isEmpty()) {
            return false;
        }
        String srcNumber = value.get("MBG_HEADKEY_INDEX_GROUP_NUMBER");
        String number = value.get("MBG_HEADKEY_INDEX_MEMBER_NUMBER");
        String detailMemeberKey = srcNumber + "_" + number;
        if (!detailMemeberKeySet.contains(detailMemeberKey)) {
            String messageStr = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"MBG_ERROR_INDEX_MEMBER_NOT_EXIST", (Object[])new Object[]{key + 1, value.get("MBG_HEADKEY_INDEX_MEMBER_NAME")});
            this.addErrorDataInfo(errorDataInfo, key, value, messageStr);
            return false;
        }
        return true;
    }

    private boolean validate2(Map headKeyData, int key, HashMap<String, String> value, Set<String> detailMemeberKeySet, String combinNumber, Map errorDataInfo) {
        String combinNum = value.get(combinNumber);
        if (StringUtils.isEmpty((String)combinNum)) {
            return true;
        }
        String combinSrcNumber = combinNumber.split("_")[1];
        String detailMemeberKey = combinSrcNumber + "_" + combinNum;
        if (!detailMemeberKeySet.contains(detailMemeberKey)) {
            String string = value.get(combinNumber + "_SUFFIX");
            String messageStr = null;
            String object = StringUtils.isEmpty((String)string) ? headKeyData.get(combinNumber) : string;
            messageStr = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.AdjustBillResource", (String)"MBG_ERROR_COMBINDIM_NUMBER_NOT_EXIST", (Object[])new Object[]{key + 1, object.toString()});
            this.addErrorDataInfo(errorDataInfo, key, value, messageStr);
            return false;
        }
        return true;
    }

    private void addErrorDataInfo(Map<Integer, Map<String, String>> errorDataInfo, Integer key, Map<String, String> value, String errorInfo) {
        MBGAdjustBillHelper.addErrorDataInfo(errorDataInfo, key, value, errorInfo);
    }

    private Map<String, Set<String>> combinMenberNumber(Context ctx, List<String> combin) throws BOSException, SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select freffield,fsrctable,fsrcnumber from T_MBG_DimSrc left join T_MBG_Dim on T_MBG_Dim.fid = T_MBG_DimSrc.fdimid where freffield in(");
        if (combin != null && combin.size() > 0) {
            for (int i = 0; i < combin.size(); ++i) {
                String srcnumber = combin.get(i);
                if (srcnumber.indexOf("_") < 0) {
                    throw new BOSException("data error");
                }
                sql.append("'").append(combin.get(i).split("_")[0]).append("'");
                if (i == combin.size() - 1) {
                    sql.append(")");
                    continue;
                }
                sql.append(",");
            }
        } else {
            return null;
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        ISQLExecutor sqlExecutor = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString());
        IRowSet rs = null;
        try {
            rs = sqlExecutor.executeSQL();
            String freffield = null;
            String fsrctable = null;
            String srcnumber = null;
            while (rs.next()) {
                freffield = rs.getString(1) + "_" + rs.getString(3);
                fsrctable = rs.getString(2);
                srcnumber = rs.getString(3);
                if (freffield == null) continue;
                map.put(freffield, this.getMenmberbySrcTableName(ctx, srcnumber, fsrctable));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return map;
    }

    private Map<String, Set<String>> menberNumber(Context ctx, Set srcnumbers) throws BOSException, SQLException {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (Object index : srcnumbers) {
            String srcnumber = index.toString();
            String sql = "select fsrctable from T_MBG_DimSrc where fsrcnumber = '" + srcnumber + "'";
            ISQLExecutor sqlExecutor = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
            IRowSet rs = null;
            try {
                rs = sqlExecutor.executeSQL();
                String fsrctable = null;
                while (rs.next()) {
                    fsrctable = rs.getString(1);
                    if (fsrctable == null) continue;
                    map.put(srcnumber, this.getMenmberbySrcTableName(ctx, srcnumber, fsrctable));
                }
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                throw e;
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                throw e;
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        return map;
    }

    private Set<String> getMenmberbySrcTableName(Context ctx, String srcnumber, String fsrctable) throws BOSException, SQLException {
        HashSet<String> nunberSet = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select fnumber from ").append(fsrctable);
        ISQLExecutor sqlExecutor = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString());
        IRowSet rs = null;
        try {
            rs = sqlExecutor.executeSQL();
            while (rs.next()) {
                String fnumber = rs.getString(1);
                if (fsrctable == null) continue;
                nunberSet.add(fnumber);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return nunberSet;
    }

    @Override
    protected Object _queryCtrlBgDataByParameter(Context ctx, BgAdjustBillBalanceOverParameter parameter) throws BOSException, EASBizException {
        BgAdjustBanaceOverImpl impl = new BgAdjustBanaceOverImpl();
        try {
            IBudgetBalance balance = impl.queryBalance(ctx, parameter);
            return balance;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }
}

