/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgElementCollection;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.IBgPeriodDisp;
import com.kingdee.eas.ma.base.MbgMemberCollection;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgAdjustPastDataInfo;
import com.kingdee.eas.ma.base.utils.BgCodeNumberHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgDimCacheUtils;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgParamNHelper;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.api.BizCalcCaller;
import com.kingdee.eas.ma.biz.api.IBizCalc;
import com.kingdee.eas.ma.control.BgControlFacadeFactory;
import com.kingdee.eas.ma.control.BgControlSettingInfo;
import com.kingdee.eas.ma.control.BgCtrlTypeEnum;
import com.kingdee.eas.ma.control.face.IBudgetBalance;
import com.kingdee.eas.ma.control.impl.BudgetBalance;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.control.impl.models.BgGroupData;
import com.kingdee.eas.ma.control.utils.BgControlTransitUtils;
import com.kingdee.eas.ma.mbg.BgAdjustBillCollection;
import com.kingdee.eas.ma.mbg.BgAdjustBillFactory;
import com.kingdee.eas.ma.mbg.BgAdjustBillInfo;
import com.kingdee.eas.ma.mbg.BgAdjustException;
import com.kingdee.eas.ma.mbg.BgAuditIdeaEnum;
import com.kingdee.eas.ma.mbg.BgDecomposeFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormDataSourceEnum;
import com.kingdee.eas.ma.mbg.BgFormEntryFactory;
import com.kingdee.eas.ma.mbg.BgFormEntryInfo;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgPastData;
import com.kingdee.eas.ma.mbg.BgPastRecord;
import com.kingdee.eas.ma.mbg.BgPastSourceEnum;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgRollRuleCollection;
import com.kingdee.eas.ma.mbg.BgRollRuleFactory;
import com.kingdee.eas.ma.mbg.BgRollRuleInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.MbgPermissionFactory;
import com.kingdee.eas.ma.mbg.app.AbstractBgAdjustFacadaControllerBean;
import com.kingdee.eas.ma.mbg.app.data.IMbgDataFacade;
import com.kingdee.eas.ma.mbg.app.data.MbgDataFacade;
import com.kingdee.eas.ma.mbg.app.data.MbgTmpDataUtils;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.app.utils.BgAdjustAuditDataImpl;
import com.kingdee.eas.ma.mbg.app.utils.BgAdjustDataFacadeImpl;
import com.kingdee.eas.ma.mbg.app.utils.BgAdjustHelper;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.app.utils.MbgViewListFormServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.BgSheetRange;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.query.AdjustData;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.mbg.utils.BgFormDiversityHelper;
import com.kingdee.eas.ma.mbg.utils.BgFormHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.MBgCheckHelper;
import com.kingdee.eas.ma.mbg.utils.MbgViewListDescriptionHelper;
import com.kingdee.eas.ma.mbg.utils.RefFieldComparator;
import com.kingdee.eas.ma.mbg.utils.data.BizMbgDataControlUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class BgAdjustFacadaControllerBean
extends AbstractBgAdjustFacadaControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgAdjustFacadaControllerBean");
    private BgAdjustBillCollection bgAdjustBillCollection;

    protected Boolean checkCanEditOtherBgForm(BgFormInfo formInfo, BgFormInfo otherForm) {
        Boolean canEditOtherAddedBgForm = true;
        if (formInfo.get("canEditOtherAddedBgForm") != null && formInfo.get("canEditOtherAddedBgForm") instanceof Boolean) {
            canEditOtherAddedBgForm = (Boolean)formInfo.get("canEditOtherAddedBgForm");
            if (canEditOtherAddedBgForm.booleanValue() || otherForm.getOrgUnit().getId().equals((Object)formInfo.getOrgUnit().getId())) {
                return true;
            }
            if (!canEditOtherAddedBgForm.booleanValue() && !otherForm.getOrgUnit().getId().equals((Object)formInfo.getOrgUnit().getId())) {
                canEditOtherAddedBgForm = false;
            }
        }
        return canEditOtherAddedBgForm;
    }

    @Override
    protected Map _getViewFormAdjust(Context ctx, BgFormInfo formInfo, Set queryBgFormByOrgUnitId, boolean isRoll) throws BOSException, EASBizException {
        HashMap<String, BgFormInfo> resultMap = new HashMap<String, BgFormInfo>();
        Map bgFormMap = this.queryBgFormByOrgUnitId(ctx, formInfo, queryBgFormByOrgUnitId.toArray(), this.getSicForView());
        Object orgId2 = null;
        ObjectUuidPK pk = null;
        BgFormStateEnum checkState = isRoll ? BgFormStateEnum.RollEdited : BgFormStateEnum.Adjusted;
        BgFormDataSourceEnum dataSource = isRoll ? BgFormDataSourceEnum.ROLLBGFORM : BgFormDataSourceEnum.ADJUST;
        HashSet<Integer> states = new HashSet<Integer>();
        states.add(checkState.getValue());
        states.add(isRoll ? 12 : 35);
        for (Object orgId2 : bgFormMap.keySet()) {
            BgFormInfo info = (BgFormInfo)bgFormMap.get(orgId2);
            String approveFormId = info.getId().toString();
            BgFormStateEnum state = info.getState();
            if (info.isIsRolled() && !isRoll) continue;
            if (states.contains(state.getValue())) {
                pk = new ObjectUuidPK(info.getId());
                BgFormFactory.getLocalInstance(ctx).save((CoreBaseInfo)formInfo);
            }
            if (approveFormId != null && isRoll) {
                pk = new ObjectUuidPK(approveFormId);
            }
            if (pk == null && state.equals((Object)BgFormStateEnum.Approved) && this.checkCanEditOtherBgForm(formInfo, info).booleanValue()) {
                pk = this.cloneAdjust(ctx, info.getId(), dataSource, checkState, formInfo.getOrgUnit().getId().toString().equals(orgId2), formInfo.getEntries().get(0).getDimensionData(), formInfo.getEntries().get(0).getDimensionStyle());
            }
            if (pk != null) {
                resultMap.put(orgId2.toString(), BgFormFactory.getLocalInstance(ctx).getBgFormInfo((IObjectPK)pk, this.getSicForView()));
            }
            pk = null;
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBg_bgForm set FLastUpdateTime=?,FLastUpdateUserID =? where fid =?", (Object[])new Object[]{formInfo.getLastUpdateTime(), formInfo.getLastUpdateUser().getId().toString(), formInfo.getId().toString()});
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return resultMap;
    }

    protected IObjectPK cloneAdjust(Context ctx, BOSUuid bgFormId, BgFormDataSourceEnum dataSource, BgFormStateEnum state, boolean isReplaceData, byte[] dimensionData, byte[] dimensionStyle) throws BOSException, EASBizException {
        if (bgFormId == null || dataSource == null || state == null) {
            return null;
        }
        IBgForm ibgForm = null;
        ObjectUuidPK pk = null;
        IObjectPK npk = null;
        BgFormInfo bgFormInfo = null;
        BgFormInfo cloneInfo = null;
        Timestamp lastUpdateTime = new Timestamp(new Date().getTime());
        ibgForm = BgFormFactory.getLocalInstance(ctx);
        if (ibgForm == null) {
            throw new BgFormException(BgFormException.NOINSTANCE);
        }
        pk = new ObjectUuidPK(bgFormId);
        if (ibgForm.exists((IObjectPK)pk)) {
            SelectorItemCollection sic = BgNFSHelper.getSelectors();
            sic.add("templateLastUpdateTime");
            sic.add("templateData");
            sic.add("entries.dimensionData");
            sic.add("entries.dimensionStyle");
            bgFormInfo = ibgForm.getBgFormInfo((IObjectPK)pk, sic);
            cloneInfo = bgFormInfo.deepcloneForAdjust();
            cloneInfo.setDataSource(dataSource);
            cloneInfo.setState(state);
            cloneInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            cloneInfo.setLastUpdateTime(lastUpdateTime);
            cloneInfo.setStartDate(new Date());
            cloneInfo.setEndDate(bgFormInfo.getStartDate());
            cloneInfo.setAdjust(bgFormInfo);
            cloneInfo.setAdjustMapData(null);
            cloneInfo.setVersionNo(bgFormInfo.getVersionNo().add(BgNConstants.NextVer));
            cloneInfo.setTemplateLastUpdateTime(bgFormInfo.getTemplateLastUpdateTime());
            cloneInfo.setTemplateData(bgFormInfo.getTemplateData());
            if (cloneInfo.getEntries() != null && cloneInfo.getEntries().size() > 0) {
                if (isReplaceData) {
                    cloneInfo.getEntries().get(0).setDimensionData(dimensionData);
                    cloneInfo.getEntries().get(0).setDimensionStyle(dimensionStyle);
                } else {
                    cloneInfo.getEntries().get(0).setDimensionData(bgFormInfo.getEntries().get(0).getDimensionData());
                    cloneInfo.getEntries().get(0).setDimensionStyle(bgFormInfo.getEntries().get(0).getDimensionStyle());
                }
            }
        } else {
            throw new BgFormException(BgFormException.NOBGFORMINFO);
        }
        npk = ibgForm.addnew((CoreBaseInfo)cloneInfo);
        return npk;
    }

    protected Map queryBgFormByOrgUnitId(Context ctx, BgFormInfo bgFormInfo, Object[] orgIds, SelectorItemCollection selector) throws BOSException, EASBizException {
        HashMap<String, BgFormInfo> bgFormMap = new HashMap<String, BgFormInfo>();
        IBgForm ibgForm = BgFormFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.root.id", (Object)bgFormInfo.getBgTemplate().getRootId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgFormInfo.getBgScheme().getId().toString(), CompareType.EQUALS));
        HashSet<Object> orgIdSet = new HashSet<Object>();
        for (int i = 0; i < orgIds.length; ++i) {
            orgIdSet.add(orgIds[i]);
        }
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", orgIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bgPeriod.id", (Object)bgFormInfo.getBgPeriod().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)bgFormInfo.getCurrency().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgVersion.id", (Object)bgFormInfo.getBgVersion().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("processType", (Object)bgFormInfo.getProcessType(), CompareType.EQUALS));
        HashSet<Integer> stateSet = new HashSet<Integer>();
        stateSet.add(new Integer(5));
        stateSet.add(new Integer(15));
        filter.getFilterItems().add(new FilterItemInfo("state", stateSet, CompareType.NOTINCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"select fadjustId from T_MBG_BGFORM where fstate in ( 4 , 35 , 6 , 101 ) and fid <> fadjustid", CompareType.NOTINNER));
        viewInfo.setFilter(filter);
        viewInfo.setSelector(selector);
        BgFormCollection bgFormCol = ibgForm.getBgFormCollection(viewInfo);
        for (int i = 0; i < bgFormCol.size(); ++i) {
            bgFormMap.put(bgFormCol.get(i).getOrgUnit().getId().toString(), bgFormCol.get(i));
        }
        return bgFormMap;
    }

    private SelectorItemCollection getSicForView() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("adjustMapData");
        sic.add("dataSource");
        sic.add("bgScheme.id");
        sic.add("bgScheme.number");
        sic.add("bgScheme.name");
        sic.add("bgScheme.refCube");
        sic.add("bgScheme.period");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.root.id");
        sic.add("bgTemplate.number");
        sic.add("bgTemplate.bgScenario.id");
        sic.add("bgTemplate.bgScenario.number");
        sic.add("bgTemplate.bgScenario.name");
        sic.add("bgTemplate.bgScenario.scenarioId");
        sic.add("bgTemplate.formType");
        sic.add("orgUnit.id");
        sic.add("orgUnit.number");
        sic.add("orgUnit.name");
        sic.add("orgUnit.longnumber");
        sic.add("bgRollPeriod.id");
        sic.add("bgRollPeriod.name");
        sic.add("bgRollPeriod.number");
        sic.add("state");
        sic.add("adjust.id");
        sic.add("adjust.versionNo");
        sic.add("number");
        sic.add("name");
        sic.add("data");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.periodType");
        sic.add("bgVersion.id");
        sic.add("bgVersion.number");
        sic.add("bgVersion.name");
        sic.add("bgVersion.versionId");
        sic.add("measureUnit.coefficient");
        sic.add("bgTemplate.formType");
        sic.add("entries.dimensionData");
        sic.add("entries.dimensionStyle");
        sic.add("entries.rollMethod");
        sic.add("versionNo");
        sic.add("processType");
        sic.add("lastUpdateTime");
        sic.add("lastUpdateUser.id");
        sic.add("isRolled");
        return sic;
    }

    @Override
    protected Map _saveAndGetViewSheet(Context ctx, IObjectValue model, String curOrgId, Map adjustDataMap) throws BOSException, EASBizException {
        if (model == null || adjustDataMap == null || adjustDataMap.isEmpty()) {
            return null;
        }
        BgFormInfo bgFormInfo = (BgFormInfo)model;
        if (bgFormInfo.getAdjust() == null || bgFormInfo.getAdjust().getId() == null) {
            return null;
        }
        String billId = bgFormInfo.getAdjust().getId().toString();
        Map<String, String> orgFormIdMap = BgAdjustHelper.getOrgFormIdMap(this.getConnection(ctx), ctx, bgFormInfo, adjustDataMap.keySet());
        if (orgFormIdMap == null || orgFormIdMap.isEmpty()) {
            return null;
        }
        HashSet<String> formIdSet = new HashSet<String>(orgFormIdMap.values());
        MbgTmpDataUtils.checkTmpData(ctx, bgFormInfo, adjustDataMap, formIdSet);
        UserInfo user = bgFormInfo.getLastUpdateUser() != null ? bgFormInfo.getLastUpdateUser() : ContextUtil.getCurrentUserInfo((Context)ctx);
        String versionNum = bgFormInfo.getBgVersion().getNumber();
        Object entry = null;
        Map dataMapOfOrg = null;
        BgAdjustFormDiversityData divData2 = null;
        try {
            IMbgDataFacade facade = MbgDataFacade.getInstance(ctx, user.getId().toString(), bgFormInfo.getBgScheme().getId().toString(), DimensionConstants.ADJUST_DATA_TYPE);
            facade.setProcessType(bgFormInfo.getProcessType());
            String formIdItem = null;
            Map.Entry<String, String> entryItem2 = null;
            AdjustData adjustData = null;
            for (Map.Entry<String, String> entryItem2 : orgFormIdMap.entrySet()) {
                formIdItem = entryItem2.getValue();
                if (facade.getDataManager() != null) {
                    facade.getDataManager().getMbgDataMap().clear();
                }
                if (StringUtils.isEmpty((String)formIdItem)) continue;
                facade.setBillId(formIdItem);
                dataMapOfOrg = (Map)adjustDataMap.get(entryItem2.getKey());
                for (BgAdjustFormDiversityData divData2 : dataMapOfOrg.values()) {
                    adjustData = new AdjustData();
                    adjustData.setOrgUnitId(entryItem2.getKey());
                    adjustData.setFormula(divData2.getFormula());
                    adjustData.setVersionNum(versionNum);
                    adjustData.setValue(divData2.getNewValue());
                    adjustData.setOldValue(divData2.getOldValue());
                    adjustData.setAdjustReason(divData2.getAdjustReson());
                    facade.addMbgData(adjustData);
                }
                facade.submit();
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return null;
    }

    @Override
    protected Map _getAdjustData(Context ctx, String billId, Set orgIdSet) throws BOSException, EASBizException {
        SelectorItemCollection sic = BgNFSHelper.getSelectors();
        BgFormInfo info = BgFormFactory.getLocalInstance(ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(billId), sic);
        BgAdjustDataFacadeImpl dataImpl = new BgAdjustDataFacadeImpl(ctx, (IObjectValue)info);
        dataImpl.getDataHelper().setBgSchemeInfo(info.getBgScheme());
        dataImpl.getDataHelper().setCubeName("T_MBG_BgTmpData");
        dataImpl.getDataHelper().setCubeEntryName("T_MBG_BgTmpDataEntry");
        HashSet<String> formIdSet = new HashSet<String>(BgAdjustHelper.getOrgFormIdMap(this.getConnection(ctx), ctx, info, orgIdSet).values());
        return dataImpl.getNewAdjustData(orgIdSet, formIdSet);
    }

    @Override
    protected Map _batchAudit(Context ctx, List billIds) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (billIds == null || billIds.isEmpty()) {
            return result;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            List<BgFormInfo> bgForms = MbgDataHelper.getBgFormInfo(ctx, conn, billIds);
            Map bgFormColl = this.convertColl(bgForms);
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            this.checkMutex(ctx, billIds, result, bgFormColl);
            int in = 0;
            for (int i = billIds.size() - 1; i >= in; --i) {
                String billId = (String)billIds.get(i);
                if (!this.checkBillState((BgFormInfo)bgFormColl.get(billId), result) || !this.checkWorkFlow(ctx, (BgFormInfo)bgFormColl.get(billId), result)) continue;
                this._audit(ctx, billId);
                BizMbgDataControlUtils.syncMessage(result, "CHECK_RESULT_SUCCEED", (IDimDataQuery)bgFormColl.get(billId));
                BgFormInfo oldInfo = (BgFormInfo)bgFormColl.get(billId);
                BgFormFacadeFactory.getLocalInstance(ctx).submitAuditIdea(oldInfo.getAdjust().getId(), user.getId(), oldInfo.getState().getValue() == 6 ? BgAuditIdeaEnum.ROLLPASS : BgAuditIdeaEnum.ADJUSTPASS, null);
            }
        }
        catch (Exception e) {
            logger.error((Object)"_batchAudit error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return result;
    }

    @Override
    protected Map _batchUnAudit(Context ctx, List billIds) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (billIds == null || billIds.isEmpty()) {
            return result;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            List<BgFormInfo> bgForms = MbgDataHelper.getBgFormInfo(ctx, conn, billIds);
            HashSet<String> rollIds = new HashSet<String>();
            for (BgFormInfo info : bgForms) {
                if (info.getBgRollRule() == null) continue;
                rollIds.add(info.getBgRollRule().getId().toString());
            }
            if (!rollIds.isEmpty()) {
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(new FilterInfo());
                view.getFilter().getFilterItems().add(new FilterItemInfo("id", rollIds, CompareType.INCLUDE));
                BgRollRuleCollection col = BgRollRuleFactory.getLocalInstance(ctx).getBgRollRuleCollection(view);
                Map rollMap = BgCommHelper.transeToMap((IObjectCollection)col);
                for (BgFormInfo info : bgForms) {
                    if (info.getBgRollRule() == null) continue;
                    info.setBgRollRule((BgRollRuleInfo)rollMap.get(info.getBgRollRule().getId().toString()));
                }
            }
            Map bgFormColl = this.convertColl(bgForms);
            int in = 0;
            for (int i = billIds.size() - 1; i >= in; --i) {
                String billId = (String)billIds.get(i);
                if (!this.checkBillStateByUnAudit(ctx, (BgFormInfo)bgFormColl.get(billId), result)) continue;
                this._unAudit(ctx, billId);
                BizMbgDataControlUtils.syncMessage(result, "CHECK_RESULT_SUCCEED", (IDimDataQuery)bgFormColl.get(billId));
            }
        }
        catch (Exception e) {
            logger.error((Object)"_batchAudit error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return result;
    }

    private boolean checkWorkFlow(Context ctx, BgFormInfo bgFormInfo, Map<String, Object> result) throws BOSException {
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        ProcessInstInfo[] procInsts = service.getProcessInstanceByHoldedObjectId(bgFormInfo.getId().toString());
        if (procInsts != null) {
            int jn = procInsts.length;
            for (int j = 0; j < jn; ++j) {
                if (!procInsts[j].getState().startsWith("open")) continue;
                BizMbgDataControlUtils.syncMessage(result, "CHECK_RESULT_WORKFLOW", bgFormInfo);
                return false;
            }
        }
        return true;
    }

    private boolean checkBillStateByUnAudit(Context ctx, BgFormInfo bgFormInfo, Map<String, Object> result) throws EASBizException, BOSException {
        if (bgFormInfo.getBgRollRule() == null || !BgFormStateEnum.Approved.equals((Object)bgFormInfo.getState()) || bgFormInfo.getBgVersion().isIsRollVersion()) {
            BizMbgDataControlUtils.syncMessage(result, "CHECK_RESULT_STATE", bgFormInfo);
            return false;
        }
        return true;
    }

    private boolean checkBillState(BgFormInfo bgFormInfo, Map<String, Object> result) {
        if (!BgFormStateEnum.Adjusted.equals((Object)bgFormInfo.getState()) && !BgFormStateEnum.RollEdited.equals((Object)bgFormInfo.getState())) {
            BizMbgDataControlUtils.syncMessage(result, "CHECK_RESULT_STATE", bgFormInfo);
            return false;
        }
        return true;
    }

    private Map convertColl(List<BgFormInfo> bgForms) {
        HashMap<String, BgFormInfo> result = new HashMap<String, BgFormInfo>();
        for (BgFormInfo info : bgForms) {
            result.put(info.getId().toString(), info);
        }
        return result;
    }

    private void checkMutex(Context ctx, List billIds, Map<String, Object> result, Map<String, BgFormInfo> bgFormColl) throws BOSException {
        Set<String> mutexErrs = MBgCheckHelper.requestMutex(ctx, billIds, true);
        if (mutexErrs != null && !mutexErrs.isEmpty()) {
            billIds.removeAll(mutexErrs);
            for (String bgFormId : mutexErrs) {
                BgFormInfo bgForm = bgFormColl.get(bgFormId);
                BizMbgDataControlUtils.syncMessage(result, "CHECK_RESULT_MUTEX", bgForm);
            }
        }
    }

    @Override
    protected Map _audit(Context ctx, String id) throws BOSException, EASBizException {
        return this._audit(ctx, id, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _audit(Context ctx, String id, Map auditParams) throws BOSException, EASBizException {
        int pastType;
        if (ctx == null || StringUtils.isEmpty((String)id)) {
            return null;
        }
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        BgNDataInfo dataInfo = null;
        Connection conn = null;
        PreparedStatement pmst = null;
        ResultSet rs = null;
        BgFormInfo adjustInfo = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(id), this.getSicForView());
        BgFormInfo oldInfo = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(adjustInfo.getAdjust().getId()), this.getSicForView());
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        BgProcessEnum processType = adjustInfo.getProcessType();
        if (auditParams == null) {
            auditParams = new HashMap();
        }
        if (!auditParams.containsKey("ORGUNIT_AUDIT_ID")) {
            auditParams.put("ORGUNIT_AUDIT_ID", adjustInfo.getOrgUnit().getId().toString());
        }
        if (!auditParams.containsKey("USER_ID")) {
            auditParams.put("USER_ID", user.getId().toString());
        }
        int n = pastType = BgFormStateEnum.RollEdited.equals((Object)adjustInfo.getState()) || BgFormStateEnum.RollApproving.equals((Object)adjustInfo.getState()) ? 10 : 1;
        if (auditParams.containsKey("BgPastSource") && auditParams.get("BgPastSource") instanceof BgPastSourceEnum) {
            pastType = ((BgPastSourceEnum)((Object)auditParams.get("BgPastSource"))).getValue();
        }
        String oldBillId = oldInfo.getId().toString();
        String orgUnitId = oldInfo.getOrgUnit().getId().toString();
        BgAdjustAuditDataImpl dataImpl = new BgAdjustAuditDataImpl(ctx, (IObjectValue)oldInfo);
        dataImpl.getDataHelper().setBgSchemeInfo(oldInfo.getBgScheme());
        IObjectPK Loginpk = this.writerLogin(ctx, id, "mbg_rollForm_audit");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pmst = conn.prepareStatement("SELECT FID, FFORMULA,FVALUE,FOLDVALUE,FSTATE,FAdjustReason,fcreatorid,FCreateTime, FLASTUPDATEUSERID FROM T_MBG_BGTMPDATA WHERE FORGUNITID=? AND FID IN (SELECT FDATAID FROM T_MBG_BGTMPDATAENTRY WHERE FFORMID = ?)");
            pmst.setString(1, orgUnitId);
            pmst.setString(2, oldBillId);
            rs = pmst.executeQuery();
            while (rs.next()) {
                dataInfo = new BgNDataInfo();
                dataInfo.setBgDataId(rs.getString("FID"));
                dataInfo.setBudgetValue(rs.getBigDecimal("FVALUE"));
                dataInfo.setAdjustValue(rs.getBigDecimal("FOLDVALUE"));
                dataInfo.setFormula(rs.getString("FFORMULA"));
                dataInfo.setState(rs.getInt("FSTATE"));
                dataInfo.setAdjustor(rs.getString("FLASTUPDATEUSERID"));
                dataInfo.setAdjustDate(rs.getTimestamp("FCreateTime"));
                dataInfo.setAdjustReason(rs.getString("FAdjustReason"));
                dataInfo.setBgVersion(adjustInfo.getBgVersion().getNumber());
                dataInfo.setTmpValue(dataInfo.getBudgetValue());
                dataImpl.addData(dataInfo);
            }
            dataImpl.audit(auditParams);
            SQLUtils.cleanup((Statement)pmst);
            Book newbook = adjustInfo.getBook();
            Book oldbook = oldInfo.getBook();
            BgNFSHelper.disableCal(newbook);
            BgNFSHelper.disableUndo(newbook);
            int formType = adjustInfo.getBgTemplate().getFormType().getValue();
            if (0 == formType || 8 == formType) {
                this.processAdjustColor(ctx, newbook, orgUnitId, oldInfo.getBgScheme().getId().toString(), oldInfo.getBgVersion().getNumber(), processType, oldbook);
            }
            pmst = conn.prepareStatement("DELETE FROM T_MBG_BGTMPDATA WHERE FID IN (SELECT FDATAID FROM T_MBG_BGTMPDATAENTRY WHERE FFORMID=?)");
            pmst.setString(1, oldBillId);
            pmst.executeUpdate();
            SQLUtils.cleanup((Statement)pmst);
            pmst = conn.prepareStatement("DELETE FROM T_MBG_BGTMPDATAENTRY WHERE FFORMID=?");
            pmst.setString(1, oldBillId);
            pmst.executeUpdate();
            SQLUtils.cleanup((Statement)pmst);
            pmst = conn.prepareStatement("update T_MBg_bgForm set FAuditedTime=?,FAuditorID =? where fid=? or fid =?");
            pmst.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            pmst.setString(2, user.getId().toString());
            pmst.setString(3, id.toString());
            pmst.setString(4, oldBillId.toString());
            pmst.executeUpdate();
            SQLUtils.cleanup((Statement)pmst);
            BigDecimal adjustVerNo = adjustInfo.getVersionNo();
            BigDecimal formVerNo = oldInfo.getVersionNo();
            byte[] adData = adjustInfo.getEntries().get(0).getDimensionData();
            byte[] adStyle = adjustInfo.getEntries().get(0).getDimensionStyle();
            Timestamp adjustlastUpdateTime = adjustInfo.getLastUpdateTime();
            String adjustInfoLastUpdateUserID = adjustInfo.getLastUpdateUser().getId().toString();
            if (pastType == 10) {
                adjustInfo.setState(BgFormStateEnum.Approved);
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                fullOrgUnitInfo.setId(adjustInfo.getOrgUnit().getId());
                adjustInfo.setAuditOrgUnit(fullOrgUnitInfo);
                if (newbook != null) {
                    adjustInfo.setBook(newbook);
                }
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("state");
                sic.add("auditOrgUnit");
                sic.add("book");
                iBgForm.updatePartial((CoreBaseInfo)adjustInfo, sic);
                this.updateFormTimeAndUserID(ctx, conn, adjustlastUpdateTime, adjustInfoLastUpdateUserID, adjustInfo.getId().toString());
            } else {
                adjustInfo.setState(BgFormStateEnum.History);
                adjustInfo.setVersionNo(formVerNo);
                adjustInfo.getEntries().get(0).setDimensionData(oldInfo.getEntries().get(0).getDimensionData());
                adjustInfo.getEntries().get(0).setDimensionStyle(oldInfo.getEntries().get(0).getDimensionStyle());
                if (oldbook != null) {
                    adjustInfo.setBook(oldbook);
                }
                iBgForm.save((CoreBaseInfo)adjustInfo);
                this.updateFormTimeAndUserID(ctx, conn, adjustlastUpdateTime, adjustInfoLastUpdateUserID, adjustInfo.getId().toString());
                oldInfo.setVersionNo(adjustVerNo);
                oldInfo.setBgRollPeriod(adjustInfo.getBgRollPeriod());
                oldInfo.setCertificateUserId(null);
                oldInfo.setIsConfirm(false);
                oldInfo.getEntries().get(0).setDimensionData(adData);
                oldInfo.getEntries().get(0).setDimensionStyle(adStyle);
                if (0 == formType || 8 == formType) {
                    oldInfo.setBook(newbook);
                }
                iBgForm.save((CoreBaseInfo)oldInfo);
                this.updateFormTimeAndUserID(ctx, conn, adjustlastUpdateTime, adjustInfoLastUpdateUserID, oldInfo.getId().toString());
                this.updateAttachment(ctx, oldInfo, adjustInfo);
            }
            BOSUuid pastRecordID = BOSUuid.create((BOSObjectType)new BgPastRecord().getType());
            Timestamp time = new Timestamp(new Date().getTime());
            CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            StringBuffer pastRecordSql = new StringBuffer();
            pastRecordSql.append("INSERT INTO T_MBG_BGPASTRECORD (");
            pastRecordSql.append("FID,FCREATORID,FCREATETIME,FLASTUPDATEUSERID,FLASTUPDATETIME,FCONTROLUNITID,FSEQ,FPASTSOURCE,FBGFORMID,FVERSIONNO");
            pastRecordSql.append(") VALUES (?,?,?,?,?,?,?,?,?,?)");
            pmst = conn.prepareStatement(pastRecordSql.toString());
            pmst.setString(1, pastRecordID.toString());
            pmst.setString(2, user.getId().toString());
            pmst.setTimestamp(3, time);
            pmst.setString(4, user.getId().toString());
            pmst.setTimestamp(5, time);
            pmst.setString(6, cu.getId().toString());
            pmst.setInt(7, 0);
            pmst.setInt(8, pastType);
            pmst.setString(9, adjustInfo.getId().toString());
            pmst.setBigDecimal(10, adjustVerNo);
            pmst.executeUpdate();
            SQLUtils.cleanup((Statement)pmst);
            StringBuffer pastDataSql = new StringBuffer();
            pastDataSql.append("INSERT INTO T_MBG_BGPASTDATA(");
            pastDataSql.append("FID,FPASTVALUE,FBALANCE,FADJVALUE,FPASTRECORDID,FFORMULA,FBGDATAID,FADJUSTORID,FADJUSTTIME,FADJREASON");
            pastDataSql.append(") VALUES (?,?,?,?,?,?,?,?,?,?)");
            pmst = conn.prepareStatement(pastDataSql.toString());
            List<IBgNData> dataList = dataImpl.getDataHelper().getDatas();
            Set actScen = BgScenarioHelper.getAcScenarioNumbers((Context)ctx);
            int batch = 50;
            int size = 0;
            for (int index = 0; index < dataList.size(); ++index) {
                dataInfo = (BgNDataInfo)dataList.get(index);
                dataInfo.splitFormula();
                if (actScen.contains(dataInfo.getBgScenario()) || dataInfo.getBudgetValue().compareTo(dataInfo.getAdjustValue()) == 0) continue;
                pmst.setString(1, BOSUuid.create((BOSObjectType)new BgPastData().getType()).toString());
                pmst.setBigDecimal(2, dataInfo.getBudgetValue().subtract(dataInfo.getAdjustValue()));
                pmst.setBigDecimal(3, dataInfo.getAdjustValue());
                pmst.setBigDecimal(4, dataInfo.getBudgetValue());
                pmst.setString(5, pastRecordID.toString());
                pmst.setString(6, dataInfo.getFormula());
                pmst.setString(7, dataInfo.getBgDataId());
                pmst.setString(8, StringUtils.isEmpty((String)dataInfo.getAdjustor()) ? user.getId().toString() : dataInfo.getAdjustor());
                pmst.setTimestamp(9, dataInfo.getAdjustDate() == null ? time : new Timestamp(dataInfo.getAdjustDate().getTime()));
                pmst.setString(10, dataInfo.getAdjustReason());
                pmst.addBatch();
                if (++size < batch) continue;
                pmst.executeBatch();
                size = 0;
            }
            if (size != 0) {
                pmst.executeBatch();
            }
        }
        catch (BOSException e) {
            try {
                throw e;
                catch (EASBizException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new BOSException((Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
        LogUtil.afterLog((Context)ctx, (IObjectPK)Loginpk);
        IBizCalc calc = BizCalcCaller.getInstance();
        calc.runBackUpdate(ctx, oldInfo.getBgScheme().getId(), oldInfo.getOrgUnit().getId(), oldInfo.getId());
        return null;
    }

    private void updateAttachment(Context ctx, BgFormInfo oldInfo, BgFormInfo adjustInfo) throws BOSException {
        if (oldInfo == null || adjustInfo == null) {
            return;
        }
        try {
            BgDBUtils.executeUpdate((Context)ctx, (String)"update T_BAS_BoAttchAsso set FBoID = ?  where FBoID = ?", (Object[])new Object[]{oldInfo.getId().toString(), adjustInfo.getId().toString()});
        }
        catch (SQLDataException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException var1) {
            logger.error((Object)"", (Throwable)var1);
            throw new BOSException((Throwable)var1);
        }
    }

    @Override
    protected Map _unAudit(Context ctx, String billId) throws BOSException, EASBizException {
        IObjectPK Loginpk = this.writerLogin(ctx, billId, "mbg_rollForm_unAudit");
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        BgFormInfo adjustInfo = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(billId), this.getSicForView());
        BgFormInfo oldInfo = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(adjustInfo.getAdjust().getId()), this.getSicForView());
        boolean isRollForm = billId.equals(adjustInfo.getAdjust().getId().toString());
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        DbUtil.execute((Context)ctx, (String)"update T_MBg_bgForm set FState = ?, FAuditedTime = null, FAuditorID = null,FauditOrgUnitId = null, FLastUpdateTime = ?, FlastUpdateUserID = ? where fid = ?", (Object[])new Object[]{6, new Timestamp(System.currentTimeMillis()), ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), billId});
        BgFormFacadeFactory.getLocalInstance(ctx).submitAuditIdea(oldInfo.getAdjust().getId(), user.getId(), isRollForm ? BgAuditIdeaEnum.ROLLUNAUDIT : BgAuditIdeaEnum.UNAUDIT, null);
        LogUtil.afterLog((Context)ctx, (IObjectPK)Loginpk);
        return null;
    }

    private void updateFormTimeAndUserID(Context ctx, Connection conn, Timestamp time, String userId, String formID) throws Exception {
        PreparedStatement pmst = conn.prepareStatement("update T_MBg_bgForm set FLastUpdateTime=?,FlastUpdateUserID =? where fid=?");
        pmst.setTimestamp(1, time);
        pmst.setString(2, userId);
        pmst.setString(3, formID);
        pmst.executeUpdate();
        SQLUtils.cleanup((Statement)pmst);
    }

    private void processAdjustColor(Context ctx, Book book, String orgUnitId, String bgSchemeId, String versionNum, BgProcessEnum processType, Book oldBook) throws EASBizException, BOSException {
        String orgId;
        ItemFormula itemFormula;
        Cell cell;
        Sheet sheet;
        Map<String, Set<String>> formulas = new HashMap();
        for (int s = 0; s < book.getSheetCount(); ++s) {
            sheet = book.getSheet(s);
            for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                    cell = sheet.getCell(r, c, false);
                    itemFormula = BgNFSHelper.getItemFormula(cell);
                    if (itemFormula == null) continue;
                    orgId = itemFormula.getExt("ORGUNITID");
                    if (orgId == null) {
                        orgId = orgUnitId;
                    }
                    if (!formulas.containsKey(orgId)) {
                        formulas.put(orgId, new HashSet());
                    }
                    ((Set)formulas.get(orgId)).add(itemFormula.getFormula());
                }
            }
        }
        formulas = this._checkHasAdjust(ctx, bgSchemeId, formulas, versionNum, processType);
        StyleAttributes base = Styles.getEmptySA();
        Map<String, Color> oldColorMap = BgFormDiversityHelper.getOldFormCellColor(oldBook);
        HashMap<String, BgSheetRange> colorMap = new HashMap<String, BgSheetRange>();
        Color adjustBefore = null;
        String colorStr = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            sheet = book.getSheet(s);
            colorMap.clear();
            for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                    cell = sheet.getCell(r, c, false);
                    itemFormula = BgNFSHelper.getItemFormula(cell);
                    if (itemFormula == null) continue;
                    orgId = itemFormula.getExt("ORGUNITID");
                    if (orgId == null) {
                        orgId = orgUnitId;
                    }
                    if ((adjustBefore = BgNFSHelper.getAdjustBeforeColor(cell)) == null) {
                        adjustBefore = oldColorMap.containsKey(cell.getName(false, true)) ? oldColorMap.get(cell.getName(false, true)) : BgNConstants.BASE_COLOR;
                    }
                    if (adjustBefore == null) continue;
                    if (BgNConstants.EDIT_COLOR.equals(BgNFSHelper.getBackGroup(cell)) && BgAdjustFacadaControllerBean.checkHasAdjust(formulas, orgId, itemFormula.getFormula())) {
                        colorStr = adjustBefore.getRed() + "_" + adjustBefore.getGreen() + "_" + adjustBefore.getBlue() + "_" + adjustBefore.getAlpha();
                        BgSheetRange sheetRange = (BgSheetRange)colorMap.get(colorStr);
                        if (sheetRange == null) {
                            sheetRange = new BgSheetRange(sheet);
                            colorMap.put(colorStr, sheetRange);
                        }
                        sheetRange.addCell(r, c);
                        continue;
                    }
                    if (BgNFSHelper.getBackGroup(cell) != null || adjustBefore.equals(BgNConstants.BASE_COLOR)) continue;
                    BgNFSHelper.setBackGroup(cell, adjustBefore);
                }
            }
            for (String cs : colorMap.keySet()) {
                BgSheetRange sheetRange = (BgSheetRange)colorMap.get(cs);
                String[] rgba = cs.split("_");
                Range rg = sheetRange.getRange();
                adjustBefore = new Color(Integer.parseInt(rgba[0]), Integer.parseInt(rgba[1]), Integer.parseInt(rgba[2]), Integer.parseInt(rgba[3]));
                base.setBackground(adjustBefore);
                if (rg == null) continue;
                rg.setIgnoreProtected(true);
                rg.setStyle(base, Styles.getEmptySA());
            }
        }
    }

    private static boolean checkHasAdjust(Map<String, Set<String>> formulas, String orgId, String formula) {
        if (formulas == null || StringUtils.isEmpty((String)orgId) || StringUtils.isEmpty((String)formula) || !formulas.containsKey(orgId)) {
            return false;
        }
        return formulas.get(orgId).contains(formula);
    }

    @Override
    protected Map _delete(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        HashSet idSet = new HashSet();
        idSet.addAll(ids);
        HashSet<Integer> states = new HashSet<Integer>();
        states.add(4);
        states.add(6);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.getFilter().getFilterItems().add(new FilterItemInfo("state", states, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("adjust.id");
        sic.add("number");
        sic.add("name");
        sic.add("bgscheme.id");
        sic.add("state");
        sic.add("versionNo");
        sic.add("rollSourceId");
        view.setSelector(sic);
        BgFormCollection formColls = iBgForm.getBgFormCollection(view);
        if (formColls == null || formColls.isEmpty()) {
            return null;
        }
        ids.clear();
        BOSUuid id = formColls.get(0).getBgScheme().getId();
        BgSchemeInfo rootBgScheme = BgViewServerHelper.getBgSchemeCubeInfo(ctx, id);
        if (rootBgScheme == null) {
            return null;
        }
        String bgDataTable = rootBgScheme.getRefCube();
        String cubeEntryName = BgCubeUtils.getCubeEntryName(bgDataTable, 1);
        HashMap<String, BgFormInfo> rollFormIds = new HashMap<String, BgFormInfo>();
        HashSet<String> adjustId = new HashSet<String>();
        for (int index = 0; index < formColls.size(); ++index) {
            ids.add(formColls.get(index).getId().toString());
            if (formColls.get(index).getState().getValue() == 6) {
                rollFormIds.put(formColls.get(index).getId().toString(), formColls.get(index));
            }
            adjustId.add(formColls.get(index).getAdjust().getId().toString());
            IObjectPK Loginpk = this.writerLogin(ctx, formColls.get(index), "mbg_rollForm_delete");
            LogUtil.afterLog((Context)ctx, (IObjectPK)Loginpk);
        }
        this.deleteAdjustUpdataBgDataTmpValue(ctx, adjustId);
        AttachmentServerManager iAsm = AttachmentManagerFactory.getServerManager((Context)ctx);
        int in = ids.size();
        for (int i = 0; i < in; ++i) {
            String _bgFormId = (String)ids.get(i);
            iAsm.deleteAttachemtsByBoID(_bgFormId);
        }
        StringBuilder sqlTmpData = new StringBuilder();
        StringBuilder sqlTmpDataEntry = new StringBuilder();
        StringBuilder sqlBgForm = new StringBuilder();
        sqlTmpData.append("DELETE FROM T_MBG_BGTMPDATA WHERE FID IN (SELECT FDATAID FROM T_MBG_BGTMPDATAENTRY WHERE FFORMID in (SELECT FADJUSTID FROM T_MBG_BGFORM WHERE FID IN(");
        sqlTmpDataEntry.append("DELETE FROM T_MBG_BGTMPDATAENTRY WHERE FFORMID in (SELECT FADJUSTID FROM T_MBG_BGFORM WHERE FID IN(");
        sqlBgForm.append("DELETE FROM T_MBG_BGFORM WHERE FID IN(");
        for (int index = 0; index < ids.size(); ++index) {
            sqlTmpData.append("'").append(ids.get(index)).append("',");
            sqlTmpDataEntry.append("'").append(ids.get(index)).append("',");
            sqlBgForm.append("'").append(ids.get(index)).append("',");
        }
        sqlTmpData.deleteCharAt(sqlTmpData.length() - 1);
        sqlTmpData.append(")))");
        sqlTmpDataEntry.deleteCharAt(sqlTmpDataEntry.length() - 1);
        sqlTmpDataEntry.append("))");
        sqlBgForm.deleteCharAt(sqlBgForm.length() - 1);
        sqlBgForm.append(")");
        Connection conn = null;
        PreparedStatement pmst = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pmst = conn.prepareStatement(sqlTmpData.toString());
            pmst.executeUpdate();
            pmst = conn.prepareStatement(sqlTmpDataEntry.toString());
            pmst.executeUpdate();
            pmst = conn.prepareStatement(sqlBgForm.toString());
            pmst.executeUpdate();
            this.deleRollDataRef(conn, cubeEntryName, new ArrayList<String>(rollFormIds.keySet()));
            this.revertStateByTraceRollForms(ctx, new ArrayList<String>(rollFormIds.keySet()));
            MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBG_BgFormExcuteAnalysis where FBGFORMID = ?", (List)ids);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pmst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pmst, (Connection)conn);
        return null;
    }

    protected void deleteUploadRefAttachmentFile(Context ctx, BgFormCollection formColls) throws EASBizException, BOSException {
        if (BgParamNHelper.isUploadRefAttachmentFile((Context)ctx)) {
            for (int index = 0; index < formColls.size(); ++index) {
                BgFormInfo info = formColls.get(index);
                if (!BgFormStateEnum.Adjusted.equals((Object)info.getState())) continue;
                BigDecimal versionNo = info.getVersionNo();
                BigDecimal count = versionNo.subtract(BigDecimal.ONE).multiply(new BigDecimal(10)).setScale(0);
                String attachemtName = info.getName() + "(\u7b2c" + count + "\u6b21\u8c03\u6574)";
                AttachmentServerManager iAsm = AttachmentManagerFactory.getServerManager((Context)ctx);
                IBoAttchAsso instance = BoAttchAssoFactory.getLocalInstance((Context)ctx);
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("boID");
                selector.add("attachment.id");
                selector.add("attachment.name");
                view.setSelector(selector);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("attachment.name", (Object)attachemtName, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("attachment.attachTypeEnum", (Object)"1", CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("boID", (Object)info.getId().toString(), CompareType.EQUALS));
                view.setFilter(filter);
                BoAttchAssoCollection boAttchAssoColls = instance.getBoAttchAssoCollection(view);
                if (boAttchAssoColls == null || boAttchAssoColls.isEmpty()) continue;
                for (int i = 0; i < boAttchAssoColls.size(); ++i) {
                    iAsm.deleteOneAssociation(info.getAdjustId().toString(), boAttchAssoColls.get(i).getAttachment().getId().toString());
                }
            }
        }
    }

    private void revertStateByTraceRollForms(Context ctx, List<String> deleteIds) throws EASBizException, BOSException {
        Connection conn = null;
        String tmpTable = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            tmpTable = BgDBUtils.createTmpTable((TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID NVARCHAR(44))");
            if (deleteIds.isEmpty()) {
                return;
            }
            BgDBUtils.insertKey((Connection)conn, (String)("INSERT INTO " + tmpTable + " VALUES(?)"), deleteIds);
            String sql = "UPDATE T_MBG_BGFORM SET FISROLLED = 0,FROLLSOURCEID = null WHERE FISROLLED = 1 AND  FBGROLLPERIODID IS NULL and FROLLSOURCEID IN (SELECT FID FROM " + tmpTable + ")";
            BgDBUtils.executeUpdate((Connection)conn, (String)sql);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
            pool.releaseTable(tmpTable);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteAdjustUpdataBgDataTmpValue(Context ctx, Set idSet) throws BOSException {
        String tableName;
        HashMap<String, BgSchemeAccIntHelper> accIntMap;
        HashMap<String, String> tableKeyValue;
        ResultSet rs;
        PreparedStatement pmst;
        Connection conn;
        BgFormCollection colls;
        block16: {
            if (ctx == null) return;
            if (idSet == null) return;
            if (idSet.isEmpty()) {
                return;
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("bgScheme.id");
            sic.add("bgScheme.refCube");
            sic.add("processType");
            IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(sic);
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            colls = iBgForm.getBgFormCollection(view);
            if (colls == null) return;
            if (colls.isEmpty()) {
                return;
            }
            HashMap<String, BgFormInfo> bgFormInfoMap = new HashMap<String, BgFormInfo>(colls.size());
            for (int i = 0; i < colls.size(); ++i) {
                BgFormInfo formInfo = colls.get(i);
                bgFormInfoMap.put(formInfo.getId().toString(), formInfo);
            }
            StringBuffer sqlCube = new StringBuffer("SELECT f.FID id, rs.FRefCube tableName, f.FBgSchemeId FROM T_MBG_BGFORM f ");
            sqlCube.append("LEFT JOIN T_MBG_BGSCHEME rs ON f.FBGSCHEMEID=rs.Fid ");
            sqlCube.append("WHERE f.FID IN (");
            Iterator it = idSet.iterator();
            while (it.hasNext()) {
                sqlCube.append("'").append((String)it.next()).append("',");
            }
            sqlCube.deleteCharAt(sqlCube.length() - 1);
            sqlCube.append(")");
            conn = null;
            pmst = null;
            rs = null;
            tableKeyValue = new HashMap<String, String>();
            accIntMap = new HashMap<String, BgSchemeAccIntHelper>();
            conn = EJBFactory.getConnection((Context)ctx);
            pmst = conn.prepareStatement(sqlCube.toString());
            rs = pmst.executeQuery();
            while (rs.next()) {
                tableName = rs.getString("tableName");
                tableName = BgCubeUtils.getCubeName(tableName, ((BgFormInfo)bgFormInfoMap.get(rs.getString("id"))).getProcessType());
                tableKeyValue.put(rs.getString("id"), tableName);
                if (accIntMap.containsKey(tableName)) continue;
                BgSchemeAccIntHelper accIntHelper = new BgSchemeAccIntHelper(ctx, rs.getString("FBgSchemeId"), tableName);
                accIntMap.put(tableName, accIntHelper);
            }
            SQLUtils.cleanup((ResultSet)rs);
            if (!tableKeyValue.isEmpty()) break block16;
            SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
            return;
        }
        try {
            pmst = conn.prepareStatement("SELECT FID, FFormula FROM T_MBG_BgTmpData WHERE Fid IN (SELECT FDataId FROM T_MBG_BgTmpDataEntry WHERE FFormId=?)");
            HashMap<String, ArrayList<Object[]>> deleteParamMap = new HashMap<String, ArrayList<Object[]>>();
            List<Object> deleteParamList = null;
            Object v = null;
            String formula = null;
            int size = colls.size();
            for (int index = 0; index < size; ++index) {
                BgFormInfo info = colls.get(index);
                tableName = (String)tableKeyValue.get(info.getId().toString());
                if (StringUtils.isEmpty((String)tableName)) continue;
                BgSchemeAccIntHelper accIntHelper = (BgSchemeAccIntHelper)accIntMap.get(tableName);
                deleteParamMap.clear();
                pmst.setString(1, info.getId().toString());
                rs = pmst.executeQuery();
                while (rs.next()) {
                    String id = rs.getString("FID");
                    if (accIntHelper.isUseAccInt()) {
                        formula = rs.getString("FFormula");
                        tableName = accIntHelper.getSplitMap().get(DimensionFormulaHelper.getMemberNumber(DimensionFormulaHelper.splitCombinations(BgNFSHelper.parseFormulaPara(formula)[0])[0]));
                    }
                    if ((deleteParamList = (ArrayList<Object[]>)deleteParamMap.get(tableName)) == null) {
                        deleteParamList = new ArrayList<Object[]>();
                        deleteParamMap.put(tableName, (ArrayList<Object[]>)deleteParamList);
                    }
                    deleteParamList.add(new Object[]{id});
                }
                SQLUtils.cleanup((ResultSet)rs);
                if (deleteParamMap.isEmpty()) continue;
                for (String cubeName : deleteParamMap.keySet()) {
                    deleteParamList = (List)deleteParamMap.get(cubeName);
                    MbgSqlHelper.executeBatch((Connection)conn, (String)("delete " + cubeName + " where FID = ? and FState = " + 5), deleteParamList);
                    MbgSqlHelper.executeBatch((Connection)conn, (String)("update " + cubeName + " set FTmpValue = FValue where FID = ?"), deleteParamList);
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (EASBizException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
        return;
    }

    @Override
    protected IBudgetBalance _showAdjustBalance(Context ctx, String bgSchemeId, Map adjustMap, boolean isShowParent) throws BOSException, EASBizException {
        List result = this.innerAdjustCheck(ctx, bgSchemeId, adjustMap, true, isShowParent);
        if (result != null && !result.isEmpty()) {
            BudgetBalance balance = new BudgetBalance();
            for (Object param : result) {
                balance.getBalance().add((BgControlParam)param);
            }
            return balance;
        }
        return null;
    }

    @Override
    protected List _adjustCheck(Context ctx, String bgSchemeId, Map adjustMap) throws BOSException, EASBizException {
        return this.innerAdjustCheck(ctx, bgSchemeId, adjustMap, false, true);
    }

    protected List innerAdjustCheck(Context ctx, String bgSchemeId, Map adjustMap, boolean isQueryBalance, boolean isShowParent) throws BOSException, EASBizException {
        int i;
        if (StringUtils.isEmpty((String)bgSchemeId) || adjustMap == null || adjustMap.isEmpty()) {
            return null;
        }
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
        Map adjustScenarions = BgScenarioHelper.getAdjustScenarioMap((Context)ctx);
        this.filterSchemeScenario(adjustScenarions, schemeHelper.getMemberSet(DimensionConstants.DEF_SCENARIO_NUMBER, true));
        this.filterAdjustMap(adjustMap, adjustScenarions);
        if (adjustMap.isEmpty()) {
            if (!isQueryBalance) {
                throw new BgAdjustException(BgAdjustException.BGSNOACTS);
            }
            throw new BgAdjustException(BgAdjustException.BGSNOACTSBALANCE);
        }
        HashMap<String, Map<String, Set<String>>> parentMap = new HashMap<String, Map<String, Set<String>>>();
        HashMap<String, Map<String, Set<String>>> leafMap = new HashMap<String, Map<String, Set<String>>>();
        HashMap<String, Map<String, Set<String>>> ctrlLeafMap = new HashMap<String, Map<String, Set<String>>>();
        this.queryOrgMap(ctx, adjustMap.keySet(), schemeHelper.getBgOrgViewId(), parentMap, leafMap, ctrlLeafMap, isShowParent);
        this.queryFormulaMap(ctx, adjustMap, parentMap, leafMap, ctrlLeafMap, schemeHelper, isShowParent);
        HashMap<String, String> defSumMap = new HashMap<String, String>();
        HashMap<String, String> defLeafMap = new HashMap<String, String>();
        this.queryDefaultMember(ctx, defSumMap, defLeafMap);
        BgSchemeInfo bgSchemeInfo = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeInfo("select refCube, bgSchemeType.id, bgSchemeType.schemeType where id = '" + schemeHelper.getBgSchemeId() + "'");
        String refCube = bgSchemeInfo.getRefCube();
        BgSchemeAccIntHelper accIntHelper = new BgSchemeAccIntHelper(ctx, schemeHelper, refCube);
        Map<String, Set<String>> hasActualMemger = this.getHasControlMember(ctx, parentMap, ctrlLeafMap, adjustScenarions, schemeHelper, refCube, accIntHelper, defSumMap, defLeafMap);
        HashSet<String> allHasActualMember = new HashSet<String>();
        for (Set<String> subSet : hasActualMemger.values()) {
            allHasActualMember.addAll(subSet);
        }
        HashMap<String, Set<String>> leafFormulaMap = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> formulaMap = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> _formulaMap = new HashMap<String, Set<String>>();
        Map _adjustMap = null;
        HashMap subMap = new HashMap();
        HashMap<String, Map<String, Object>> tmpAdjustMap = new HashMap<String, Map<String, Object>>();
        for (Object orgId : adjustMap.keySet()) {
            _adjustMap = (Map)adjustMap.get(orgId);
            for (String key : _adjustMap.keySet()) {
                subMap.clear();
                tmpAdjustMap.clear();
                _formulaMap.clear();
                subMap.put(key, _adjustMap.get(key));
                tmpAdjustMap.put((String)orgId, subMap);
                this.fillFormulaMap(tmpAdjustMap, parentMap, leafMap, leafFormulaMap, _formulaMap, adjustScenarions, allHasActualMember, defSumMap, defLeafMap);
                this.filterNoControlMember(ctx, _formulaMap, leafFormulaMap, (Map)leafMap.get(DimensionConstants.DEF_ORGUNIT_SRCNUMBER), hasActualMemger, schemeHelper, defSumMap, defLeafMap);
                for (String key1 : _formulaMap.keySet()) {
                    if (formulaMap.containsKey(key1)) {
                        ((Set)formulaMap.get(key1)).addAll((Collection)_formulaMap.get(key1));
                        continue;
                    }
                    formulaMap.put(key1, (Set<String>)_formulaMap.get(key1));
                }
            }
        }
        this.filterNoActualData(ctx, formulaMap, leafFormulaMap, (Map)leafMap.get(DimensionConstants.DEF_ORGUNIT_SRCNUMBER), defSumMap, defLeafMap, refCube, accIntHelper);
        ArrayList result = new ArrayList();
        List tmpList = null;
        String orgUnitId2 = null;
        for (String orgUnitId2 : formulaMap.keySet()) {
            tmpList = this.adjustCheck(ctx, bgSchemeId, orgUnitId2, (Set)formulaMap.get(orgUnitId2), adjustMap, (Set)((Map)leafMap.get(DimensionConstants.DEF_ORGUNIT_SRCNUMBER)).get(orgUnitId2), leafFormulaMap, schemeHelper, isQueryBalance);
            if (tmpList == null) continue;
            result.addAll(tmpList);
        }
        if (result.isEmpty()) {
            return null;
        }
        HashMap<String, BgPeriodInfo> bgPeriodNames = new HashMap<String, BgPeriodInfo>();
        for (int i2 = 0; i2 < result.size(); ++i2) {
            BgControlParam data = (BgControlParam)result.get(i2);
            bgPeriodNames.put(data.getBgPeriodNumber(), null);
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", new HashSet(bgPeriodNames.keySet()), CompareType.INCLUDE));
        BgPeriodCollection col = BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodCollection(evi);
        for (i = 0; i < col.size(); ++i) {
            bgPeriodNames.put(col.get(i).getNumber(), col.get(i));
        }
        for (i = 0; i < result.size(); ++i) {
            BgControlParam data = (BgControlParam)result.get(i);
            data.setBgSchemeType(bgSchemeInfo.getBgSchemeType());
            data.setBgPeriodName(((BgPeriodInfo)bgPeriodNames.get(data.getBgPeriodNumber())).getName());
            data.setBgPeriodId(((BgPeriodInfo)bgPeriodNames.get(data.getBgPeriodNumber())).getId().toString());
        }
        return result;
    }

    private String replactLeafFormula(String[] formulas, Map<String, String> defSumMap, Map<String, String> defLeafMap) {
        String[] combins = formulas[0].split(",");
        boolean hasReplace = false;
        StringBuffer newFormula = new StringBuffer();
        String srcNumber = null;
        String number = null;
        for (int i = 0; i < combins.length; ++i) {
            srcNumber = DimensionFormulaHelper.getSrcNumber(combins[i]);
            number = DimensionFormulaHelper.getMemberNumber(combins[i]);
            if (DimensionConstants.DEF_INDEX_SRCNUMBER.equals(srcNumber)) {
                newFormula.append(combins[i]);
                continue;
            }
            if (defLeafMap.get(srcNumber).equals(number)) {
                newFormula.append(combins[i]);
                continue;
            }
            if (defSumMap.get(srcNumber).contains(number)) {
                hasReplace = true;
                combins[i] = DimensionFormulaHelper.getCombination(srcNumber, defLeafMap.get(srcNumber));
            }
            if (newFormula.length() > 0) {
                newFormula.append(",");
            }
            newFormula.append(combins[i]);
        }
        if (hasReplace) {
            formulas[0] = newFormula.toString();
            return BgNFSHelper.getFormulaFromParam(formulas);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void filterNoActualData(Context ctx, Map<String, Set<String>> formulaMap, Map<String, Set<String>> leafFormulaMap, Map<String, Set<String>> orgLeafMap, Map<String, String> defSumMap, Map<String, String> defLeafMap, String refCube, BgSchemeAccIntHelper accIntHelper) throws BOSException {
        if (formulaMap.isEmpty()) {
            return;
        }
        String tmpTable = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        HashMap hasActFormula = new HashMap();
        StringBuffer newFormula = new StringBuffer();
        try {
            tmpTable = accIntHelper.isUseAccInt() ? pool.createTempTable("Create Table T_MBG_ActDataTmp(FOrgUnitId INT NOT NULL, FFormula NVarchar(300) NOT NULL, FHasData INT)") : pool.createTempTable("Create Table T_MBG_ActDataTmp(FOrgUnitId Varchar(44) NOT NULL, FFormula NVarchar(300) NOT NULL, FHasData INT)");
            pool.createIndex(tmpTable, "FOrgUnitId, FFormula", true, true);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            String[] formulas = null;
            Object combins = null;
            String formula = null;
            String actScen = null;
            Object srcNumber = null;
            Object number = null;
            HashSet<String> checkRepeat = new HashSet<String>();
            String repeatKey = null;
            HashSet<String> formulaSet = new HashSet<String>();
            for (String string : formulaMap.keySet()) {
                for (String adjFormula : formulaMap.get(string)) {
                    formula = adjFormula.substring(0, adjFormula.lastIndexOf("_"));
                    actScen = adjFormula.substring(adjFormula.lastIndexOf("_") + 1);
                    formulas = BgNFSHelper.parseFormulaPara(formula);
                    formulas[3] = actScen;
                    repeatKey = string + ";" + BgNFSHelper.getFormulaFromParam(formulas);
                    if (checkRepeat.contains(repeatKey)) continue;
                    checkRepeat.add(repeatKey);
                    paramList.add(new Object[]{accIntHelper.convertOrgObject(string), BgNFSHelper.getFormulaFromParam(formulas)});
                    formulaSet.add(BgNFSHelper.getFormulaFromParam(formulas));
                    formula = this.replactLeafFormula(formulas, defSumMap, defLeafMap);
                    if (formula == null || checkRepeat.contains(repeatKey = string + ";" + formula)) continue;
                    checkRepeat.add(repeatKey);
                    paramList.add(new Object[]{accIntHelper.convertOrgObject(string), formula});
                }
            }
            Set<String> cubeNames = accIntHelper.getSplitTablesByFormula(formulaSet);
            DbUtil.executeBatch((Context)ctx, (String)("Insert Into " + tmpTable + "(FOrgUnitID, FFormula) Values(?, ?)"), paramList);
            DbUtil.execute((Context)ctx, (String)("Update " + tmpTable + " Set FHasData = 0"));
            for (String cube : cubeNames) {
                DbUtil.execute((Context)ctx, (String)("Update " + tmpTable + " t0 Set FHasData = 1 Where exists(Select FID FROM " + cube + " Where FOrgUnitId = t0.FOrgUnitId AND FFormula = t0.FFormula)"));
            }
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)("Select FOrgUnitId, FFormula FROM " + tmpTable + " Where FHasData = 1"));
            String orgUnitId = null;
            while (iRowSet.next()) {
                orgUnitId = iRowSet.getString("FOrgUnitId");
                if (!hasActFormula.containsKey(orgUnitId)) {
                    hasActFormula.put(orgUnitId, new HashSet());
                }
                ((Set)hasActFormula.get(orgUnitId)).add(iRowSet.getString("FFormula"));
            }
            SQLUtils.cleanup((ResultSet)iRowSet);
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                pool.releaseTable(tmpTable);
                throw throwable;
            }
        }
        pool.releaseTable(tmpTable);
        boolean orgIsLeaf = false;
        String formula = null;
        String adjFormula = null;
        String srcNumber = null;
        String number = null;
        String actScen = null;
        String[] formulas = null;
        String[] combins = null;
        for (String orgUnitId : formulaMap.keySet()) {
            orgIsLeaf = orgLeafMap.get(orgUnitId) == null || orgLeafMap.get(orgUnitId).contains(orgUnitId);
            Iterator<String> it = formulaMap.get(orgUnitId).iterator();
            block9: while (it.hasNext()) {
                void var24_30;
                adjFormula = it.next();
                formula = adjFormula.substring(0, adjFormula.lastIndexOf("_"));
                actScen = adjFormula.substring(adjFormula.lastIndexOf("_") + 1);
                if (orgIsLeaf && (leafFormulaMap.get(formula) == null || leafFormulaMap.get(formula).contains(formula))) continue;
                if (!hasActFormula.containsKey(orgUnitId)) {
                    it.remove();
                    continue;
                }
                formulas = BgNFSHelper.parseFormulaPara(formula);
                formulas[3] = actScen;
                if (((Set)hasActFormula.get(orgUnitId)).contains(BgNFSHelper.getFormulaFromParam(formulas))) continue;
                formulas = BgNFSHelper.parseFormulaPara(formula);
                combins = formulas[0].split(",");
                newFormula.setLength(0);
                boolean bl = false;
                while (var24_30 < combins.length) {
                    srcNumber = DimensionFormulaHelper.getSrcNumber(combins[var24_30]);
                    number = DimensionFormulaHelper.getMemberNumber(combins[var24_30]);
                    if (DimensionConstants.DEF_INDEX_SRCNUMBER.equals(srcNumber)) {
                        newFormula.append(combins[var24_30]);
                    } else {
                        if (defLeafMap.get(srcNumber).equals(number)) {
                            it.remove();
                            continue block9;
                        }
                        if (defSumMap.get(srcNumber).contains(number)) {
                            combins[var24_30] = DimensionFormulaHelper.getCombination(srcNumber, defLeafMap.get(srcNumber));
                        }
                        if (newFormula.length() > 0) {
                            newFormula.append(",");
                        }
                        newFormula.append(combins[var24_30]);
                    }
                    ++var24_30;
                }
                formulas[0] = newFormula.toString();
                formulas[3] = actScen;
                if (((Set)hasActFormula.get(orgUnitId)).contains(BgNFSHelper.getFormulaFromParam(formulas))) continue;
                it.remove();
            }
        }
    }

    private void queryDefaultMember(Context ctx, Map<String, String> defSumMap, Map<String, String> defLeafMap) throws BOSException {
        MbgMemberCollection col = MbgMemberFactory.getLocalInstance((Context)ctx).getMbgMemberCollection("select id, number, isLeaf, mbgDim.id, mbgDim.srcNumber where isSystemDefault = 1");
        if (col == null || col.isEmpty()) {
            return;
        }
        MbgMemberInfo info = null;
        Map<String, String> map = null;
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            if (info.getMbgDim() == null) continue;
            map = info.isIsLeaf() ? defLeafMap : defSumMap;
            map.put(info.getMbgDim().getSrcNumber(), info.getNumber());
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private Map<String, Set<String>> getHasControlMember(Context ctx, Map<String, Map<String, Set<String>>> parentMap, Map<String, Map<String, Set<String>>> leafMap, Map<String, Map<String, BgScenarioInfo>> adjustScenarions, BgSchemeDimensionHelper schemeHelper, String refCube, BgSchemeAccIntHelper accIntHelper, Map<String, String> defSumMap, Map<String, String> defLeafMap) throws BOSException {
        block32: {
            block33: {
                hasActualMemger = new HashMap<String, Set<String>>();
                if (parentMap.isEmpty()) {
                    return hasActualMemger;
                }
                conn = null;
                pool = TempTablePool.getInstance((Context)ctx);
                tempTable = null;
                conn = this.getConnection(ctx);
                paramList = new ArrayList<Object[]>();
                subMap = null;
                orgSet = new HashSet<String>();
                accNumbers = new HashSet<String>();
                for (Object srcNumber : leafMap.keySet()) {
                    subMap = leafMap.get(srcNumber);
                    if (DimensionConstants.DEF_INDEX_SRCNUMBER.equals(srcNumber)) {
                        accNumbers.addAll(subMap.keySet());
                    }
                    if (defLeafMap.containsKey(srcNumber) && !subMap.containsKey(leaf = defLeafMap.get(srcNumber))) {
                        paramList.add(new Object[]{srcNumber, DimensionFormulaHelper.getCombination((String)srcNumber, (String)leaf), leaf, DimensionFormulaHelper.getCombination((String)srcNumber, (String)leaf), null, accIntHelper.convertInt(accIntHelper.getSchemeHelper().getRefFieldBySrcNumber((String)srcNumber), (String)leaf)});
                    }
                    leaf = subMap.keySet().iterator();
                    while (leaf.hasNext()) {
                        number = (String)leaf.next();
                        if (DimensionConstants.DEF_INDEX_SRCNUMBER.equals(srcNumber)) {
                            accNumbers.addAll((Collection)subMap.get(number));
                        }
                        for (String childNumber : subMap.get(number)) {
                            if (DimensionConstants.DEF_ORGUNIT_SRCNUMBER.equals(srcNumber)) {
                                paramList.add(new Object[]{srcNumber, number, childNumber, childNumber, childNumber, accIntHelper.convertInt(DimensionConstants.DEF_ORGUNIT_FIELD, childNumber)});
                                orgSet.add(childNumber);
                                orgSet.add(number);
                                continue;
                            }
                            if (DimensionConstants.DEF_PERIOD_SRCNUMBER.equals(srcNumber)) {
                                paramList.add(new Object[]{srcNumber, number, childNumber, childNumber, childNumber, null});
                                continue;
                            }
                            paramList.add(new Object[]{srcNumber, DimensionFormulaHelper.getCombination((String)srcNumber, number), childNumber, DimensionFormulaHelper.getCombination((String)srcNumber, childNumber), null, accIntHelper.convertInt(accIntHelper.getSchemeHelper().getRefFieldBySrcNumber((String)srcNumber), childNumber)});
                        }
                    }
                }
                if (!paramList.isEmpty()) break block32;
                var18_19 = hasActualMemger;
                if (tempTable == null) break block33;
                pool.releaseTable(tempTable);
            }
            SQLUtils.cleanup((Connection)conn);
            return var18_19;
        }
        try {
            tempTable = pool.createTempTable("Create Table T_MBG_ControlMember(FSrcNumber Varchar(3) not null, FThisNumber NVARCHAR(80) NOT NULL, FNumber NVARCHAR(80) NOT NULL, FCombin NVARCHAR(84) NOT NULL, FID Varchar(44), FHasData INT Default 0 NOT NULL, FIntId Int)");
            pool.createIndex(tempTable, "FSrcNumber", false, false);
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + tempTable + "(FSrcNumber, FThisNumber, FNumber, FCombin, FID, FHasData, FintId) Values(?, ?, ?, ?, ?, 0, ? )"), paramList);
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + tempTable + " t0 Set FID = (Select TOP 1 FID FROM T_MBG_BgPeriod t1 Where t1.FNumber = t0.FNumber) Where FSrcNumber = '" + DimensionConstants.DEF_PERIOD_SRCNUMBER + "'"));
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + tempTable + " t0 Set FIntID = (Select TOP 1 FIntID FROM T_MBG_BgPeriod t1 Where t1.FNumber = t0.FNumber) Where FSrcNumber = '" + DimensionConstants.DEF_PERIOD_SRCNUMBER + "'"));
            actScenarios = new HashMap<K, V>();
            for (Map _subMap : adjustScenarions.values()) {
                actScenarios.putAll(_subMap);
            }
            cubeNames = accIntHelper.getSplitTablesByAcc(accNumbers);
            subSet = null;
            subList = null;
            dataTableField = null;
            memberField = null;
            updateSql = null;
            for (BgScenarioInfo scenario : actScenarios.values()) {
                subSet = new HashSet<E>();
                hasActualMemger.put(scenario.getNumber(), subSet);
                MbgSqlHelper.execute((Connection)conn, (String)("Update " + tempTable + " Set FHasData = 0"));
                for (String srcNumber : leafMap.keySet()) {
                    if (DimensionConstants.DEF_ORGUNIT_SRCNUMBER.equals(srcNumber)) {
                        dataTableField = "FOrgUnitId";
                        memberField = accIntHelper.isUseAccInt() ? "FIntID" : "FID";
                    } else if (DimensionConstants.DEF_PERIOD_SRCNUMBER.equals(srcNumber)) {
                        dataTableField = "FBgPeriodId";
                        memberField = accIntHelper.isUseAccInt() ? "FIntID" : "FID";
                    } else {
                        dataTableField = schemeHelper.getDimensionBySrcNumber().get(srcNumber).getRefField();
                        memberField = accIntHelper.isUseAccInt() != false ? "FIntID" : "FCombin";
                    }
                    for (String cubeName : cubeNames) {
                        updateSql = new StringBuffer();
                        updateSql.append("Update ").append(tempTable).append(" t0 Set FHasData = 1 Where FSrcNumber = ? AND exists(Select FID FROM ");
                        updateSql.append(cubeName).append(" t1 Where t1.FValue <> 0 AND t1.FScenario = ? ");
                        if (!orgSet.isEmpty()) {
                            updateSql.append(" and t1.FOrgUnitID in (");
                            orgId = null;
                            size = orgSet.size();
                            index = 1;
                            for (String orgId : orgSet) {
                                if (accIntHelper.isUseAccInt()) {
                                    if (index == size) {
                                        updateSql.append(accIntHelper.convertOrgObject(orgId)).append(")");
                                    } else {
                                        updateSql.append(accIntHelper.convertOrgObject(orgId)).append(",");
                                    }
                                } else if (index == size) {
                                    updateSql.append("'").append(orgId).append("')");
                                } else {
                                    updateSql.append("'").append(orgId).append("',");
                                }
                                ++index;
                            }
                        }
                        updateSql.append(" AND t0.").append(memberField).append(" = t1.").append(dataTableField).append(")");
                        MbgSqlHelper.executeBatch((Connection)conn, (String)updateSql.toString(), (Object)new Object[]{srcNumber, scenario.getScenarioId()});
                    }
                }
                subList = MbgSqlHelper.executeQuery((Connection)conn, (String)("Select distinct FThisNumber FROM " + tempTable + " Where FHasData = ?"), (Object[])new Object[]{1});
                if (subList == null) continue;
                subSet.addAll(subList);
            }
            ** if (tempTable == null) goto lbl-1000
        }
        catch (Exception e) {
            try {
                BgAdjustFacadaControllerBean.logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable var35_36) {
                if (tempTable != null) {
                    pool.releaseTable(tempTable);
                }
                SQLUtils.cleanup((Connection)conn);
                throw var35_36;
            }
        }
lbl-1000:
        // 1 sources

        {
            pool.releaseTable(tempTable);
        }
lbl-1000:
        // 2 sources

        {
        }
        SQLUtils.cleanup((Connection)conn);
        return hasActualMemger;
    }

    private void filterNoControlMember(Context ctx, Map<String, Set<String>> formulaMap, Map<String, Set<String>> leafFormulaMap, Map<String, Set<String>> orgLeafMap, Map<String, Set<String>> hasActualMemger, BgSchemeDimensionHelper schemeHelper, Map<String, String> defSumMap, Map<String, String> defLeafMap) throws BOSException {
        if (formulaMap.isEmpty()) {
            return;
        }
        boolean orgIsLeaf = false;
        String formula = null;
        String actScen = null;
        String adjFormula = null;
        Object formulas = null;
        for (String orgUnitId : formulaMap.keySet()) {
            orgIsLeaf = orgLeafMap.get(orgUnitId) == null || orgLeafMap.get(orgUnitId).contains(orgUnitId);
            Iterator<String> it = formulaMap.get(orgUnitId).iterator();
            while (it.hasNext()) {
                adjFormula = it.next();
                formula = adjFormula.substring(0, adjFormula.lastIndexOf("_"));
                actScen = adjFormula.substring(adjFormula.lastIndexOf("_") + 1);
                if (orgIsLeaf && (leafFormulaMap.get(formula) == null || leafFormulaMap.get(formula).contains(formula)) || this.checkHasData(actScen, orgUnitId, formula, hasActualMemger, defSumMap, defLeafMap)) continue;
                it.remove();
            }
        }
    }

    private boolean checkHasData(String actScenario, String orgUnitId, String formula, Map<String, Set<String>> hasActualMemger, Map<String, String> defSumMap, Map<String, String> defLeafMap) {
        if (!hasActualMemger.containsKey(actScenario)) {
            return false;
        }
        Set<String> subSet = hasActualMemger.get(actScenario);
        if (!subSet.contains(orgUnitId)) {
            return false;
        }
        String[] formulas = BgNFSHelper.parseFormulaPara(formula);
        if (!subSet.contains(formulas[1])) {
            return false;
        }
        String[] combins = DimensionFormulaHelper.splitCombinations(formulas[0]);
        for (int i = 0; i < combins.length; ++i) {
            if (subSet.contains(combins[i])) continue;
            return false;
        }
        return true;
    }

    private void filterSchemeScenario(Map<String, Map<String, BgScenarioInfo>> adjustScenarions, Set<String> schemeScenarios) {
        if (adjustScenarions == null || adjustScenarions.isEmpty()) {
            return;
        }
        ArrayList<String> bgScenarios = new ArrayList<String>(adjustScenarions.keySet());
        ArrayList<String> actScenarios = new ArrayList<String>();
        for (int i = 0; i < bgScenarios.size(); ++i) {
            if (!schemeScenarios.contains(bgScenarios.get(i))) {
                adjustScenarions.remove(bgScenarios.get(i));
                continue;
            }
            actScenarios.clear();
            actScenarios.addAll(adjustScenarions.get(bgScenarios.get(i)).keySet());
            for (int a = 0; a < actScenarios.size(); ++a) {
                if (schemeScenarios.contains(actScenarios.get(a))) continue;
                adjustScenarions.get(bgScenarios.get(i)).remove(actScenarios.get(a));
            }
        }
    }

    private List<String> getPeriodNumbers(BgControlParam bgControlParam) {
        ArrayList<String> periods = new ArrayList<String>();
        ArrayList keyList = new ArrayList(bgControlParam.getAddupBalance().keySet());
        Collections.sort(keyList);
        String minPeriod = (String)keyList.get(0);
        String maxPeriod = (String)keyList.get(keyList.size() - 1);
        periods.addAll(keyList);
        for (List listGroupData : bgControlParam.getBgGroupMap().values()) {
            for (BgGroupData sourgroupData : listGroupData) {
                if (periods.contains(sourgroupData.getBgPeriodNumber()) || sourgroupData.getBgPeriodNumber().compareTo(minPeriod) <= 0 || sourgroupData.getBgPeriodNumber().compareTo(maxPeriod) >= 0) continue;
                periods.add(sourgroupData.getBgPeriodNumber());
            }
        }
        Collections.sort(periods);
        return periods;
    }

    private List adjustCheck(Context ctx, String bgSchemeId, String orgUnitId, Set<String> formulaList, Map<String, Map<String, Object>> adjustMap, Set<String> subOrgIds, Map<String, Set<String>> leafFormulaMap, BgSchemeDimensionHelper schemeHelper, boolean isQueryBalance) throws EASBizException, BOSException, UuidException {
        ArrayList<BgControlParam> list = new ArrayList<BgControlParam>();
        if (bgSchemeId == null || orgUnitId == null || formulaList == null || formulaList.isEmpty()) {
            return list;
        }
        BgControlParam data = null;
        String formula = null;
        BigDecimal budgetValue = null;
        BigDecimal actualValue = null;
        BigDecimal adjustValue = null;
        BigDecimal tempAdjustValue = null;
        BigDecimal groupPeriodAdjustValue = null;
        String controlGroupKey = null;
        IBudgetBalance balance = BgControlFacadeFactory.getLocalInstance((Context)ctx).queryBalance(BOSUuid.read((String)bgSchemeId), BOSUuid.read((String)orgUnitId), new ArrayList<String>(formulaList), false);
        if (balance == null || balance.getBalance().isEmpty()) {
            return list;
        }
        if (isQueryBalance) {
            return balance.getBalance();
        }
        boolean loadTransitBudget = BgParamNHelper.isLoadTransitBudget((Context)ctx);
        Map<String, BigDecimal> calcControlAdjustValue = this.calcControlAdjustValue(balance, adjustMap, subOrgIds, leafFormulaMap);
        for (int i = 0; i < balance.getBalance().size(); ++i) {
            data = (BgControlParam)balance.getBalance().get(i);
            HashMap<String, BigDecimal> transitValueInAdjusts = new HashMap<String, BigDecimal>();
            if (loadTransitBudget) {
                this.loadTransitBudgetToBalance(data, leafFormulaMap, adjustMap, transitValueInAdjusts);
            }
            controlGroupKey = data.getControlGroupKey();
            if (data.getControlSetting() == null || BgCtrlTypeEnum.NoCtrl.equals((Object)data.getControlSetting().getCtrlType())) continue;
            formula = data.getFormula();
            adjustValue = null;
            budgetValue = null;
            actualValue = null;
            if (data.getControlSetting().isIsGroupCtrl()) {
                adjustValue = calcControlAdjustValue.get(controlGroupKey + "_" + formula);
                HashSet dimNumbers = new HashSet();
                Collection values = data.getBgGroupMap().values();
                for (List groupDatas : values) {
                    for (BgGroupData groupData : groupDatas) {
                        dimNumbers.add(groupData.getBgDimNumber());
                    }
                }
                if (data.isAddupCtrl()) {
                    if (data.getAddupBalance().keySet() == null || data.getAddupBalance().keySet().size() == 0) {
                        data.getAddupBalance().put(data.getBgPeriodNumber(), BigDecimal.ZERO);
                    }
                    ArrayList keyList = new ArrayList(data.getAddupBalance().keySet());
                    Collections.sort(keyList);
                    for (String addPeriod : keyList) {
                        String reFormula = data.getFormula().replaceAll(data.getBgPeriodNumber(), addPeriod);
                        groupPeriodAdjustValue = calcControlAdjustValue.get(controlGroupKey + "_" + reFormula);
                        if (groupPeriodAdjustValue != null) {
                            if (transitValueInAdjusts.containsKey(reFormula)) {
                                groupPeriodAdjustValue = groupPeriodAdjustValue.add((BigDecimal)transitValueInAdjusts.get(reFormula));
                                Iterator iterator = dimNumbers.iterator();
                                while (iterator.hasNext()) {
                                    String dimNumber = (String)iterator.next();
                                    BigDecimal bigDecimal = (BigDecimal)transitValueInAdjusts.get(reFormula = reFormula.replaceAll(data.getDimItemNumber(), dimNumber));
                                    if (bigDecimal == null) continue;
                                    groupPeriodAdjustValue = groupPeriodAdjustValue.add(bigDecimal);
                                }
                            }
                            data.getAddupBalance().put(addPeriod, groupPeriodAdjustValue.add((BigDecimal)data.getAddupBalance().get(addPeriod)));
                            continue;
                        }
                        BigDecimal previous = null;
                        for (String periodNum : this.getPeriodNumbers(data)) {
                            reFormula = data.getFormula().replaceAll(data.getBgPeriodNumber(), periodNum);
                            BigDecimal obj = calcControlAdjustValue.get(controlGroupKey + "_" + reFormula);
                            if (obj != null) {
                                previous = obj;
                            }
                            if (transitValueInAdjusts.containsKey(reFormula) && previous != null) {
                                previous = previous.add((BigDecimal)transitValueInAdjusts.get(reFormula));
                            }
                            if (!periodNum.equals(addPeriod) || previous == null) continue;
                            data.getAddupBalance().put(addPeriod, previous.add((BigDecimal)data.getAddupBalance().get(addPeriod)));
                        }
                    }
                }
            } else {
                adjustValue = this.getBgAdjustData(data, leafFormulaMap, subOrgIds, adjustMap, data.getFormula(), false);
                if (adjustValue != null && data.getControlSetting() != null) {
                    adjustValue = adjustValue.multiply(data.getControlSetting().getFlexParam());
                }
                if (data.isAddupCtrl()) {
                    if (data.getAddupBalance().keySet() == null || data.getAddupBalance().keySet().size() == 0) {
                        data.getAddupBalance().put(data.getBgPeriodNumber(), BigDecimal.ZERO);
                    }
                    for (String addPeriod : data.getAddupBalance().keySet()) {
                        if (addPeriod.equals(data.getBgPeriodNumber())) {
                            tempAdjustValue = adjustValue;
                        } else {
                            BgControlParam tempdata = null;
                            ArrayList periodNumbers = new ArrayList();
                            HashMap<String, String> lastUpdatePeriods = new HashMap<String, String>();
                            for (int ik = 0; ik < balance.getBalance().size(); ++ik) {
                                tempdata = (BgControlParam)balance.getBalance().get(ik);
                                String key = tempdata.getOrgUnit().getId().toString() + "_" + tempdata.getDimItemNumber();
                                if (!key.equals(data.getOrgUnit().getId().toString() + "_" + data.getDimItemNumber())) continue;
                                if (tempdata.getBgPeriodNumber().equals(addPeriod)) {
                                    tempAdjustValue = this.getBgAdjustData(tempdata, leafFormulaMap, subOrgIds, adjustMap, tempdata.getFormula(), true);
                                    break;
                                }
                                if (addPeriod.compareTo(tempdata.getBgPeriodNumber()) <= 0 || lastUpdatePeriods.get(key) != null && tempdata.getBgPeriodNumber().compareTo((String)lastUpdatePeriods.get(key)) <= 0) continue;
                                tempAdjustValue = this.getBgAdjustData(tempdata, leafFormulaMap, subOrgIds, adjustMap, tempdata.getFormula(), true);
                                lastUpdatePeriods.put(key, tempdata.getBgPeriodNumber());
                            }
                        }
                        String reFormula = data.getFormula().replaceAll(data.getBgPeriodNumber(), addPeriod);
                        if (transitValueInAdjusts.containsKey(reFormula)) {
                            tempAdjustValue = tempAdjustValue.add((BigDecimal)transitValueInAdjusts.get(reFormula));
                        }
                        if (tempAdjustValue == null) continue;
                        data.getAddupBalance().put(addPeriod, tempAdjustValue.add((BigDecimal)data.getAddupBalance().get(addPeriod)));
                        tempAdjustValue = null;
                    }
                }
            }
            this.dealGroupMapNullBudget(data, adjustMap, orgUnitId);
            if (adjustValue == null) continue;
            if (data.getControlSetting().isIsGroupCtrl()) {
                budgetValue = data.getExtBudget();
                actualValue = data.getExtActual();
            } else {
                budgetValue = data.getBudgetValue();
                actualValue = data.getActualValue();
                if (budgetValue != null && data.getControlSetting() != null) {
                    budgetValue = budgetValue.multiply(data.getControlSetting().getFlexParam());
                }
            }
            if (budgetValue == null) {
                budgetValue = BgNConstants.ZERO;
            }
            if (actualValue == null) {
                actualValue = BgNConstants.ZERO;
            }
            if (adjustMap.containsKey(orgUnitId) && adjustMap.get(orgUnitId).containsKey(formula)) {
                Object obj = adjustMap.get(orgUnitId).get(formula);
                BigDecimal av = null;
                if (obj instanceof BigDecimal) {
                    av = (BigDecimal)obj;
                } else if (obj instanceof BgAdjustFormDiversityData) {
                    BgAdjustFormDiversityData d = (BgAdjustFormDiversityData)obj;
                    av = d.getOldValue() == null ? d.getNewValue() : (d.getNewValue() == null ? BgNConstants.ZERO.subtract(d.getOldValue()) : d.getNewValue().subtract(d.getOldValue()));
                }
                if (av != null && av.compareTo(BigDecimal.ZERO) >= 0) continue;
            }
            this.balanceList(budgetValue, actualValue, adjustValue, list, data);
        }
        return list;
    }

    private void loadTransitBudgetToBalance(BgControlParam data, Map<String, Set<String>> leafFormulaMap, Map<String, Map<String, Object>> adjustMap, Map<String, BigDecimal> transitValueInAdjusts) {
        BigDecimal bv;
        String orgUnitId = data.getOrgUnit().getId().toString();
        String formula = data.getFormula();
        HashSet<String> bgPeriodSet = new HashSet<String>();
        if (null == adjustMap || !adjustMap.containsKey(orgUnitId)) {
            return;
        }
        Map<String, Object> formulaMap = adjustMap.get(orgUnitId);
        if (!formulaMap.containsKey(formula) && !leafFormulaMap.containsKey(formula)) {
            bv = data.getBudgetValue() != null ? data.getBudgetValue() : BigDecimal.ZERO;
            data.setBudgetValue(bv.subtract(data.getTransitBudgetValue() != null ? data.getTransitBudgetValue() : BgNConstants.ZERO));
            bv = data.getExtBudget() != null ? data.getExtBudget() : BigDecimal.ZERO;
            data.setExtBudget(bv.subtract(data.getExtTransitBudget()));
        } else {
            transitValueInAdjusts.put(formula, data.getTransitBudgetValue() != null ? data.getTransitBudgetValue() : BgNConstants.ZERO);
        }
        Map budgetDetail = data.getBudgetDetail();
        for (Object groupData : budgetDetail.values()) {
            bv = groupData.getBudgetValue() != null ? groupData.getBudgetValue() : BigDecimal.ZERO;
            formula = BgNFSHelper.getFormulaFromParam(groupData.getBgDimNumber(), groupData.getBgPeriodNumber(), data.getBgElement().getNumber(), data.getCurrency().getNumber(), data.getBgScenario().getNumber());
            bgPeriodSet.add(groupData.getBgPeriodNumber());
            if (!formulaMap.containsKey(formula) && !leafFormulaMap.containsKey(formula)) {
                groupData.setBudgetValue(bv.subtract(groupData.getTransitBudgetValue()));
                continue;
            }
            transitValueInAdjusts.put(formula, groupData.getTransitBudgetValue());
        }
        Collection values = data.getBgGroupMap().values();
        for (List lists : values) {
            for (BgGroupData groupData : lists) {
                bv = groupData.getBudgetValue() != null ? groupData.getBudgetValue() : BigDecimal.ZERO;
                formula = BgNFSHelper.getFormulaFromParam(groupData.getBgDimNumber(), groupData.getBgPeriodNumber(), data.getBgElement().getNumber(), data.getCurrency().getNumber(), data.getBgScenario().getNumber());
                bgPeriodSet.add(groupData.getBgPeriodNumber());
                if (!formulaMap.containsKey(formula) && !leafFormulaMap.containsKey(formula)) {
                    groupData.setBudgetValue(bv.subtract(groupData.getTransitBudgetValue()));
                    continue;
                }
                transitValueInAdjusts.put(formula, groupData.getTransitBudgetValue());
            }
        }
        if (data.isAddupCtrl()) {
            HashMap<String, BigDecimal> tmpValues = new HashMap<String, BigDecimal>();
            for (Map.Entry<String, BigDecimal> entry : transitValueInAdjusts.entrySet()) {
                String formula1 = entry.getKey();
                String bgPeriodNum = BgNFSHelper.parseFormulaPara(formula1)[1];
                BigDecimal value = BigDecimal.ZERO;
                for (String addPeriod : bgPeriodSet) {
                    String f;
                    if (!data.checkIsInPeriodForAddCtrl(addPeriod, bgPeriodNum) || !transitValueInAdjusts.containsKey(f = formula1.replaceAll(bgPeriodNum, addPeriod))) continue;
                    value = value.add(transitValueInAdjusts.get(f));
                }
                tmpValues.put(formula1, value);
            }
            transitValueInAdjusts.clear();
            transitValueInAdjusts.putAll(tmpValues);
        }
    }

    public BigDecimal getBgAdjustData(BgControlParam data, Map<String, Set<String>> leafFormulaMap, Set<String> subOrgIds, Map<String, Map<String, Object>> adjustMap, String formula, boolean isOnlyGetData) {
        BigDecimal av = null;
        BigDecimal adjustValue = null;
        if (!leafFormulaMap.containsKey(formula)) {
            return null;
        }
        String[] formulaParams = BgNFSHelper.parseFormulaPara(formula);
        ArrayList<String> refBgPeriods = data.getBgPeriodNums(data.getControlSetting().getCtrlType().getValue(), true, null);
        if (refBgPeriods == null || refBgPeriods.isEmpty()) {
            refBgPeriods = new ArrayList<String>();
            refBgPeriods.add(formulaParams[1]);
        }
        Iterator iterator = refBgPeriods.iterator();
        while (iterator.hasNext()) {
            String periodNumber;
            formulaParams[1] = periodNumber = (String)iterator.next();
            String newFormula = BgNFSHelper.getFormulaFromParam(formulaParams);
            if (leafFormulaMap.get(newFormula) == null) continue;
            for (String leafFormula : leafFormulaMap.get(newFormula)) {
                String[] leafFormulaParams = BgNFSHelper.parseFormulaPara(leafFormula);
                for (String subOrgId : subOrgIds) {
                    if (!adjustMap.containsKey(subOrgId) || !adjustMap.get(subOrgId).containsKey(leafFormula)) continue;
                    Object obj = adjustMap.get(subOrgId).get(leafFormula);
                    if (obj instanceof BigDecimal) {
                        av = (BigDecimal)obj;
                    } else if (obj instanceof BgAdjustFormDiversityData) {
                        BgAdjustFormDiversityData d = (BgAdjustFormDiversityData)obj;
                        av = d.getOldValue() == null ? d.getNewValue() : (d.getNewValue() == null ? BgNConstants.ZERO.subtract(d.getOldValue()) : d.getNewValue().subtract(d.getOldValue()));
                    }
                    if (av == null) {
                        av = BgNConstants.ZERO;
                    }
                    if (!isOnlyGetData) {
                        for (Map.Entry entry : data.getBudgetDetail().entrySet()) {
                            BgGroupData groupData = (BgGroupData)entry.getValue();
                            if (!groupData.getBgDimNumber().equals(formulaParams[0]) && !groupData.getBgDimNumber().equals(leafFormulaParams[0]) || !groupData.getBgPeriodNumber().equals(formulaParams[1])) continue;
                            groupData.setBudgetValue(av.add(groupData.getBudgetValue() != null ? groupData.getBudgetValue() : BigDecimal.ZERO));
                        }
                        List list22 = null;
                        for (List list22 : data.getBgGroupMap().values()) {
                            for (BgGroupData groupData : list22) {
                                if (!groupData.getBgDimNumber().equals(formulaParams[0]) || !groupData.getBgPeriodNumber().equals(formulaParams[1])) continue;
                                groupData.setBudgetValue(av.add(groupData.getBudgetValue() != null ? groupData.getBudgetValue() : BigDecimal.ZERO));
                            }
                        }
                    }
                    if (11 == data.getControlSetting().getCtrlType().getValue() && periodNumber.compareTo(data.getBgPeriodNumber()) > 0) continue;
                    if (adjustValue == null) {
                        adjustValue = av;
                        continue;
                    }
                    adjustValue = adjustValue.add(av);
                }
            }
        }
        return adjustValue;
    }

    private Map<String, BigDecimal> calcControlAdjustValue(IBudgetBalance balance, Map<String, Map<String, Object>> adjustMap, Set<String> subOrgIds, Map<String, Set<String>> leafFormulaMap) {
        BgControlParam controlParam = null;
        BgControlSettingInfo setting = null;
        String formula = null;
        String groupKey = null;
        String parentFormula = null;
        String childFormula = null;
        BigDecimal bgAdjustData = null;
        HashMap<String, Boolean> formulaRelateIsAddUpCtrl = new HashMap<String, Boolean>();
        HashMap groupFormulas = new HashMap();
        HashMap<String, BigDecimal> tmpAdjustValues = new HashMap<String, BigDecimal>();
        int in = balance.getBalance().size();
        for (int i = 0; i < in; ++i) {
            controlParam = (BgControlParam)balance.getBalance().get(i);
            if (controlParam.getControlSetting() == null || BgCtrlTypeEnum.NoCtrl.equals((Object)controlParam.getControlSetting().getCtrlType()) || !(setting = controlParam.getControlSetting()).isIsGroupCtrl() || StringUtils.isEmpty((String)setting.getGroupNo())) continue;
            groupKey = controlParam.getControlGroupKey();
            formula = BgNFSHelper.getFormulaFromParam(this.createFormulaKey(controlParam, controlParam.getDimItemNumber()));
            parentFormula = groupKey + "_" + formula;
            formulaRelateIsAddUpCtrl.put(parentFormula, setting.getCtrlType().getValue() == 11);
            bgAdjustData = this.getBgAdjustData(controlParam, leafFormulaMap, subOrgIds, adjustMap, formula, false);
            if (bgAdjustData != null && controlParam.getControlSetting() != null) {
                bgAdjustData = bgAdjustData.multiply(controlParam.getControlSetting().getFlexParam());
            }
            tmpAdjustValues.put(parentFormula, bgAdjustData);
            HashMap<String, BigDecimal> groupValues = new HashMap<String, BigDecimal>();
            for (List list : controlParam.getBgGroupMap().values()) {
                for (BgGroupData data : list) {
                    childFormula = BgNFSHelper.getFormulaFromParam(this.createFormulaKey(controlParam, data.getBgDimNumber()));
                    bgAdjustData = this.getBgAdjustData(controlParam, leafFormulaMap, subOrgIds, adjustMap, childFormula, false);
                    childFormula = groupKey + "_" + childFormula;
                    groupValues.put(childFormula, bgAdjustData);
                }
            }
            groupFormulas.put(parentFormula, groupValues);
        }
        this.sysBgGroupData4BudgetDetail(balance);
        HashMap<String, BigDecimal> adjustValues = new HashMap<String, BigDecimal>();
        ArrayList list = new ArrayList(tmpAdjustValues.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, BigDecimal>>(){

            @Override
            public int compare(Map.Entry<String, BigDecimal> o1, Map.Entry<String, BigDecimal> o2) {
                String formula1 = o1.getKey().split("_")[3];
                String formula2 = o2.getKey().split("_")[3];
                return BgNFSHelper.parseFormulaPara(formula1)[1].compareTo(BgNFSHelper.parseFormulaPara(formula2)[1]);
            }
        });
        HashMap<String, String> updateLastPeriod = new HashMap<String, String>();
        if (!tmpAdjustValues.isEmpty() && !groupFormulas.isEmpty()) {
            for (Map.Entry entry : list) {
                parentFormula = (String)entry.getKey();
                bgAdjustData = (BigDecimal)entry.getValue();
                Map groupValues = (Map)groupFormulas.get(parentFormula);
                for (Map.Entry entry1 : groupValues.entrySet()) {
                    String childformula = (String)entry1.getKey();
                    BigDecimal groupAdjustValue = (BigDecimal)entry1.getValue();
                    if (tmpAdjustValues.get(childformula) != null) {
                        bgAdjustData = bgAdjustData.add((BigDecimal)tmpAdjustValues.get(childformula));
                        continue;
                    }
                    if (((Boolean)formulaRelateIsAddUpCtrl.get(parentFormula)).booleanValue()) {
                        String[] split = childformula.split("_");
                        String[] formulaParam = BgNFSHelper.parseFormulaPara(split[3]);
                        if (updateLastPeriod.containsKey(split[1] + "_" + formulaParam[0])) {
                            String lastPeriod = (String)updateLastPeriod.get(split[1] + "_" + formulaParam[0]);
                            bgAdjustData = bgAdjustData.add((BigDecimal)tmpAdjustValues.get(childformula.replaceAll(formulaParam[1], lastPeriod)));
                        }
                        adjustValues.put(childformula, bgAdjustData);
                        continue;
                    }
                    if (groupAdjustValue == null) continue;
                    bgAdjustData = bgAdjustData.add(groupAdjustValue);
                }
                String[] split = parentFormula.split("_");
                String[] formulaParam = BgNFSHelper.parseFormulaPara(split[3]);
                updateLastPeriod.put(split[1] + "_" + formulaParam[0], formulaParam[1]);
                adjustValues.put(parentFormula, bgAdjustData);
            }
        }
        return adjustValues;
    }

    private void sysBgGroupData4BudgetDetail(IBudgetBalance balance) {
        HashMap budgetDetail = new HashMap();
        List list2 = null;
        for (BgControlParam controlParam : balance.getBalance()) {
            budgetDetail.putAll(controlParam.getBudgetDetail());
        }
        for (BgControlParam controlParam : balance.getBalance()) {
            if (controlParam.getControlSetting() == null || BgCtrlTypeEnum.NoCtrl.equals((Object)controlParam.getControlSetting().getCtrlType())) continue;
            ArrayList<String> refBgPeriods = controlParam.getBgPeriodNums(controlParam.getControlSetting().getCtrlType().getValue(), true, null);
            if (refBgPeriods == null) {
                refBgPeriods = new ArrayList<String>();
                refBgPeriods.add(controlParam.getBgPeriodNumber());
            }
            for (List list2 : controlParam.getBgGroupMap().values()) {
                for (BgGroupData sourgroupData : list2) {
                    if (budgetDetail.containsKey(sourgroupData.getKey())) {
                        BgGroupData tgtGroupData = (BgGroupData)budgetDetail.get(sourgroupData.getKey());
                        sourgroupData.setBudgetValue(tgtGroupData.getBudgetValue());
                    }
                    if (controlParam.getControlSetting().getCtrlType().getValue() == 10 || refBgPeriods == null || refBgPeriods.contains(sourgroupData.getBgPeriodNumber())) continue;
                    sourgroupData.setBudgetValue(null);
                }
            }
        }
    }

    private String[] createFormulaKey(BgControlParam controlParam, String dimItemNumber) {
        String[] formulaParams = new String[]{dimItemNumber, controlParam.getBgPeriodNumber(), controlParam.getBgElement().getNumber(), controlParam.getBgScenario().getNumber(), "true", controlParam.getCurrency().getNumber()};
        return formulaParams;
    }

    protected void balanceList(BigDecimal budgetValue, BigDecimal actualValue, BigDecimal adjustValue, List<BgControlParam> list, BgControlParam data) {
        BigDecimal newbalance = adjustValue.add(budgetValue).subtract(actualValue);
        BigDecimal sumBalance = BigDecimal.ZERO;
        BigDecimal actualSum = BigDecimal.ZERO;
        BigDecimal tempBudgetValue = BigDecimal.ZERO;
        BigDecimal tempActualValue = BigDecimal.ZERO;
        if (adjustValue.compareTo(BgNConstants.ZERO) < 0 && newbalance.compareTo(BgNConstants.ZERO) < 0) {
            data.setExtBalance(newbalance);
            data.setBalance(newbalance);
            list.add(data);
        }
        if (data.isAddupCtrl()) {
            ArrayList keyList = new ArrayList(data.getAddupBalance().keySet());
            Collections.sort(keyList);
            for (String addPeriod : keyList) {
                if (addPeriod.equals(data.getBgPeriodNumber())) {
                    data.setBalance((BigDecimal)data.getAddupBalance().get(addPeriod));
                    data.setExtBalance((BigDecimal)data.getAddupBalance().get(addPeriod));
                }
                newbalance = (BigDecimal)data.getAddupBalance().get(addPeriod);
                if ((data.getBalance() == null ? BigDecimal.ZERO : data.getBalance()).compareTo(newbalance) > 0) {
                    data.setBalance(newbalance);
                    data.setExtBalance(newbalance);
                }
                if (newbalance.compareTo(BgNConstants.ZERO) >= 0 || list.contains(data)) continue;
                list.add(data);
            }
        }
    }

    private void fillFormulaMap(Map<String, Map<String, Object>> adjustMap, Map<String, Map<String, Set<String>>> parentMap, Map<String, Map<String, Set<String>>> leafMap, Map<String, Set<String>> leafFormulaMap, Map<String, Set<String>> formulaMap, Map<String, Map<String, BgScenarioInfo>> adjustScenarions, Set<String> allHasActualMember, Map<String, String> defSumMap, Map<String, String> defLeafMap) {
        HashMap<String, Set<String>> parentFormulaMap = new HashMap<String, Set<String>>();
        HashSet parentSet = new HashSet();
        HashSet<String> actFormulaSet = null;
        Map<String, Set<String>> parentOrgMap = parentMap.get(DimensionConstants.DEF_ORGUNIT_SRCNUMBER);
        Set<String> parentOrgSet = null;
        Set<String> subFormulaSet = null;
        for (String orgUnitId : adjustMap.keySet()) {
            parentSet.clear();
            for (String formula : adjustMap.get(orgUnitId).keySet()) {
                if (!parentFormulaMap.containsKey(formula)) {
                    this.billdParentSet(formula, parentMap, parentFormulaMap, leafFormulaMap, allHasActualMember, defSumMap, defLeafMap);
                }
                if (!parentFormulaMap.containsKey(formula)) continue;
                parentSet.addAll((Collection)parentFormulaMap.get(formula));
            }
            actFormulaSet = new HashSet<String>();
            for (String formula : parentSet) {
                this.addFormula(formula, actFormulaSet, adjustScenarions);
            }
            for (String formula : adjustMap.get(orgUnitId).keySet()) {
                this.addFormula(formula, actFormulaSet, adjustScenarions);
            }
            parentOrgSet = parentOrgMap.get(orgUnitId);
            for (String oId : parentOrgSet) {
                if (!formulaMap.containsKey(oId)) {
                    formulaMap.put(oId, new HashSet());
                }
                subFormulaSet = formulaMap.get(oId);
                subFormulaSet.addAll(actFormulaSet);
            }
        }
    }

    private void addFormula(String fFormula, Collection<String> formulaList, Map<String, Map<String, BgScenarioInfo>> adjustScenarions) {
        String[] formulas = BgNFSHelper.parseFormulaPara(fFormula);
        String bgScenario = formulas[3];
        Map<String, BgScenarioInfo> tmpMap = adjustScenarions.get(bgScenario);
        if (tmpMap == null || tmpMap.isEmpty()) {
            return;
        }
        for (String actScenario : tmpMap.keySet()) {
            formulaList.add(fFormula + "_" + actScenario);
        }
    }

    private void billdParentSet(String formula, Map<String, Map<String, Set<String>>> parentMap, Map<String, Set<String>> parentFormulaMap, Map<String, Set<String>> leafFormulaMap, Set<String> allHasActualMember, Map<String, String> defSumMap, Map<String, String> defLeafMap) {
        ArrayList<Set<String>> parentItems = new ArrayList<Set<String>>();
        String[] formulas = BgNFSHelper.parseFormulaPara(formula);
        Set<String> parentPeriod = parentMap.get(DimensionConstants.DEF_PERIOD_SRCNUMBER).get(formulas[1]);
        String[] combins = DimensionFormulaHelper.splitCombinations(formulas[0]);
        String[] srcNumbers = new String[combins.length];
        HashSet<String> _allHasActualMember = new HashSet<String>(allHasActualMember);
        for (int i = 0; i < combins.length; ++i) {
            _allHasActualMember.add(combins[i]);
            srcNumbers[i] = DimensionFormulaHelper.getSrcNumber(combins[i]);
            if (parentMap.get(srcNumbers[i]) == null) {
                return;
            }
            parentItems.add(parentMap.get(srcNumbers[i]).get(DimensionFormulaHelper.getMemberNumber(combins[i])));
        }
        this.buildParentSet(formula, formulas, srcNumbers, parentItems, 0, new String[combins.length], parentPeriod, parentFormulaMap, leafFormulaMap, _allHasActualMember, defSumMap, defLeafMap);
    }

    private void buildParentSet(String formula, String[] formulas, String[] srcNumbers, List<Set<String>> parentItems, int itemIndex, String[] tmpArray, Set<String> parentPeriod, Map<String, Set<String>> parentFormulaMap, Map<String, Set<String>> leafFormulaMap, Set<String> allHasActualMember, Map<String, String> defSumMap, Map<String, String> defLeafMap) {
        if (parentItems.get(itemIndex) == null) {
            return;
        }
        Iterator<String> iterator = parentItems.get(itemIndex).iterator();
        while (iterator.hasNext()) {
            String leaf;
            String item;
            tmpArray[itemIndex] = item = iterator.next();
            boolean isHasLeaf = false;
            if (defSumMap.containsKey(srcNumbers[itemIndex]) && item.equals(defSumMap.get(srcNumbers[itemIndex])) && allHasActualMember.contains(leaf = defLeafMap.get(srcNumbers[itemIndex]))) {
                isHasLeaf = true;
            }
            if (!isHasLeaf && !allHasActualMember.contains(DimensionFormulaHelper.getCombination(srcNumbers[itemIndex], item))) continue;
            if (itemIndex == parentItems.size() - 1) {
                StringBuffer items = new StringBuffer();
                for (int i = 0; i < tmpArray.length; ++i) {
                    if (i > 0) {
                        items.append(",");
                    }
                    items.append(DimensionFormulaHelper.getCombination(srcNumbers[i], tmpArray[i]));
                }
                formulas[0] = items.toString();
                String newFormula = null;
                Iterator<String> iterator2 = parentPeriod.iterator();
                while (iterator2.hasNext()) {
                    String period;
                    formulas[1] = period = iterator2.next();
                    newFormula = BgNFSHelper.getFormulaFromParam(formulas);
                    if (!parentFormulaMap.containsKey(formula)) {
                        parentFormulaMap.put(formula, new HashSet());
                    }
                    parentFormulaMap.get(formula).add(newFormula);
                    if (!leafFormulaMap.containsKey(newFormula)) {
                        leafFormulaMap.put(newFormula, new HashSet());
                    }
                    leafFormulaMap.get(newFormula).add(formula);
                }
                continue;
            }
            this.buildParentSet(formula, formulas, srcNumbers, parentItems, itemIndex + 1, tmpArray, parentPeriod, parentFormulaMap, leafFormulaMap, allHasActualMember, defSumMap, defLeafMap);
        }
    }

    private void queryFormulaMap(Context ctx, Map<String, Map<String, Object>> adjustMap, Map<String, Map<String, Set<String>>> parentMap, Map<String, Map<String, Set<String>>> leafMap, Map<String, Map<String, Set<String>>> ctrlLeafMap, BgSchemeDimensionHelper schemeHelper, boolean isShowParent) throws BOSException {
        HashMap<String, Set<String>> queryMap = new HashMap<String, Set<String>>();
        HashSet<String> formulaSet = new HashSet<String>();
        for (Map<String, Object> subMap : adjustMap.values()) {
            formulaSet.addAll(subMap.keySet());
        }
        String[] formulas = null;
        String[] combins = null;
        for (String formula : formulaSet) {
            formulas = BgNFSHelper.parseFormulaPara(formula);
            this.addToQueryMap(DimensionConstants.DEF_PERIOD_SRCNUMBER, formulas[1], queryMap);
            combins = DimensionFormulaHelper.splitCombinations(formulas[0]);
            for (int i = 0; i < combins.length; ++i) {
                this.addToQueryMap(DimensionFormulaHelper.getSrcNumber(combins[i]), DimensionFormulaHelper.getMemberNumber(combins[i]), queryMap);
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("number");
        evi.getSelector().add("longNumber");
        IBgPeriodDisp treeBase = null;
        TreeBaseCollection col = null;
        HashMap<String, Set<String>> subParentMap = null;
        HashMap<String, Set<String>> subLeafMap = null;
        Connection conn = null;
        HashMap<String, HashMap<String, Set<String>>> allParentMap = new HashMap<String, HashMap<String, Set<String>>>();
        HashMap<String, HashMap<String, Set<String>>> allLeafMap = new HashMap<String, HashMap<String, Set<String>>>();
        try {
            conn = this.getConnection(ctx);
            for (String srcNumber : queryMap.keySet()) {
                evi.setFilter(new FilterInfo());
                if (DimensionConstants.DEF_PERIOD_SRCNUMBER.equals(srcNumber)) {
                    treeBase = BgPeriodDispFactory.getLocalInstance((Context)ctx);
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("type.id", schemeHelper.getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, false), CompareType.INCLUDE));
                } else if (DimensionConstants.DEF_INDEX_SRCNUMBER.equals(srcNumber)) {
                    treeBase = BgAccountFactory.getLocalInstance((Context)ctx);
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("bgAccountView.id", (Object)schemeHelper.getDimension(DimensionConstants.DEF_ACCOUNT_NUMBER).getViewId()));
                } else {
                    treeBase = MbgMemberFactory.getLocalInstance((Context)ctx);
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)schemeHelper.getDimensionBySrcNumber().get(srcNumber).getViewId()));
                }
                col = treeBase.getTreeBaseCollection(evi);
                subParentMap = new HashMap();
                subLeafMap = new HashMap();
                allParentMap.put(srcNumber, subParentMap);
                allLeafMap.put(srcNumber, subLeafMap);
                if (col == null || col.isEmpty()) continue;
                for (int i = 0; i < col.size(); ++i) {
                    this.addToMap(col.get(i).getNumber(), col.get(i).getLongNumber(), subParentMap, subLeafMap, isShowParent);
                }
            }
            HashSet ctrlParentNumbers = new HashSet();
            for (String srcNumber : queryMap.keySet()) {
                subParentMap = new HashMap<String, Set<String>>();
                subLeafMap = new HashMap<String, Set<String>>();
                ctrlParentNumbers.clear();
                parentMap.put(srcNumber, subParentMap);
                leafMap.put(srcNumber, subLeafMap);
                for (String number : (Set)queryMap.get(srcNumber)) {
                    subParentMap.put(number, (Set<String>)((Map)allParentMap.get(srcNumber)).get(number));
                    ctrlParentNumbers.addAll((Collection)((Map)allParentMap.get(srcNumber)).get(number));
                    subLeafMap.put(number, (Set<String>)((Map)allLeafMap.get(srcNumber)).get(number));
                }
                subLeafMap = new HashMap();
                ctrlLeafMap.put(srcNumber, subLeafMap);
                for (String number : ctrlParentNumbers) {
                    subLeafMap.put(number, (Set<String>)((Map)allLeafMap.get(srcNumber)).get(number));
                }
            }
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void addToQueryMap(String srcNumber, String number, Map<String, Set<String>> queryMap) {
        if (!queryMap.containsKey(srcNumber)) {
            queryMap.put(srcNumber, new HashSet());
        }
        queryMap.get(srcNumber).add(number);
    }

    private void queryOrgMap(Context ctx, Set orgIds, String bgOrgViewId, Map<String, Map<String, Set<String>>> parentMap, Map<String, Map<String, Set<String>>> leafMap, Map<String, Map<String, Set<String>>> ctrlLeafMap, boolean isShowParent) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("orgUnitId");
        evi.getSelector().add("longNumber");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitId", new HashSet(orgIds), CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)bgOrgViewId));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isVirtual", (Object)Boolean.FALSE));
        BgOrgUnitCollection col = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(evi);
        HashMap<String, Set<String>> subParentMap = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> subLeafMap = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> subCtrlLeafMap = new HashMap<String, Set<String>>();
        parentMap.put(DimensionConstants.DEF_ORGUNIT_SRCNUMBER, subParentMap);
        leafMap.put(DimensionConstants.DEF_ORGUNIT_SRCNUMBER, subLeafMap);
        ctrlLeafMap.put(DimensionConstants.DEF_ORGUNIT_SRCNUMBER, subCtrlLeafMap);
        HashMap<String, String> numberIdMap = new HashMap<String, String>();
        BgOrgUnitInfo info = null;
        for (int i = 0; i < col.size(); ++i) {
            String[] stringArray;
            info = col.get(i);
            numberIdMap.put(info.getNumber(), info.getOrgUnitID());
            this.addToMap(info.getNumber(), info.getLongNumber(), subParentMap, subLeafMap, isShowParent);
            if (isShowParent) {
                stringArray = info.getLongNumber().split("!");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = info.getNumber();
            }
            String[] lns = stringArray;
            for (int p = 0; p < lns.length; ++p) {
                if (!subCtrlLeafMap.containsKey(lns[p])) {
                    subCtrlLeafMap.put(lns[p], new HashSet());
                }
                for (int c = p; c < lns.length; ++c) {
                    ((Set)subCtrlLeafMap.get(lns[p])).add(lns[c]);
                }
            }
        }
        HashSet numbers = new HashSet(subLeafMap.keySet());
        numbers.removeAll(numberIdMap.keySet());
        if (!numbers.isEmpty()) {
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)bgOrgViewId));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("isVirtual", (Object)Boolean.FALSE));
            col = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(evi);
            for (int i = 0; i < col.size(); ++i) {
                info = col.get(i);
                numberIdMap.put(info.getNumber(), info.getOrgUnitID());
            }
        }
        this.replaceNumberToId(subParentMap, numberIdMap);
        this.replaceNumberToId(subLeafMap, numberIdMap);
        this.replaceNumberToId(subCtrlLeafMap, numberIdMap);
    }

    private void replaceNumberToId(Map<String, Set<String>> subMap, Map<String, String> numberIdMap) {
        String[] keys = subMap.keySet().toArray(new String[0]);
        String[] values = null;
        Set<String> subSet = null;
        for (String key : keys) {
            subSet = subMap.get(key);
            values = subSet.toArray(new String[0]);
            subSet.clear();
            subMap.remove(key);
            subMap.put(numberIdMap.get(key), subSet);
            for (String value : values) {
                subSet.add(numberIdMap.get(value));
            }
        }
    }

    private void addToMap(String number, String longNumber, Map<String, Set<String>> subParentMap, Map<String, Set<String>> subLeafMap, boolean isShowParent) {
        if (!isShowParent) {
            longNumber = number;
        }
        String[] lns = longNumber.split("!");
        subParentMap.put(number, new HashSet());
        for (int l = 0; l < lns.length; ++l) {
            subParentMap.get(number).add(lns[l]);
            if (!subLeafMap.containsKey(lns[l])) {
                subLeafMap.put(lns[l], new HashSet());
            }
            subLeafMap.get(lns[l]).add(number);
        }
    }

    private void filterAdjustMap(Map<String, Map<String, Object>> adjustMap, Map<String, Map<String, BgScenarioInfo>> adjustScenarions) {
        if (adjustMap == null || adjustMap.isEmpty()) {
            return;
        }
        if (adjustScenarions == null || adjustScenarions.isEmpty()) {
            adjustMap.clear();
        }
        Map<String, Object> tmpMap = null;
        String[] orgIds = adjustMap.keySet().toArray(new String[0]);
        String[] formulas = null;
        for (String orgUnitId : orgIds) {
            tmpMap = adjustMap.get(orgUnitId);
            for (String formula : formulas = tmpMap.keySet().toArray(new String[0])) {
                if (adjustScenarions.containsKey(BgNFSHelper.parseFormulaPara(formula)[3])) continue;
                tmpMap.remove(formula);
            }
            if (!tmpMap.isEmpty()) continue;
            adjustMap.remove(orgUnitId);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected Map _pastDataView(Context ctx, String adjustAnalyseId, String bgSchemeId, String bgVersionNumber, int processTypeInt, boolean isOnlyShowAudit) throws BOSException, EASBizException {
        block27: {
            block26: {
                resMap = new HashMap<String, ArrayList<BgAdjustPastDataInfo>>();
                if (StringUtils.isEmpty((String)adjustAnalyseId) || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)bgVersionNumber)) {
                    return resMap;
                }
                l = ctx.getLocale().getDisplayName();
                pastDataList = new ArrayList<BgAdjustPastDataInfo>();
                pastData = null;
                formulaForItem = new HashMap<K, V>();
                itemName = new HashMap<K, V>();
                itemNumbers = new HashSet<String>();
                formulaMap = new HashMap<K, V>();
                bgAdjustBill = new HashMap<String, BgAdjustPastDataInfo>();
                bgDataTable = null;
                conn = null;
                pstmt = null;
                rst = null;
                orgId = null;
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement("Select FRefCube, FOrgUnitId From T_Mbg_BgScheme Where FID = ?");
                pstmt.setString(1, bgSchemeId);
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    bgDataTable = BgCubeUtils.getCubeName(rst.getString("FRefCube"), BgProcessEnum.getEnum(processTypeInt));
                    orgId = rst.getString("FOrgUnitId");
                    break block26;
                }
                var22_21 = resMap;
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
                return var22_21;
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (StringUtils.isEmpty((String)bgDataTable)) {
                throw new BgAdjustException(BgAdjustException.NOTADJUSTRECORD);
            }
            accIntHelper = new BgSchemeAccIntHelper(ctx, bgSchemeId, bgDataTable);
            if (!accIntHelper.isUseAccInt()) ** GOTO lbl51
            accNumbers = new HashSet<String>();
            pstmt = conn.prepareStatement("Select FIndexNumber FROM T_MBG_BgAdjustAnalyseData Where FID = ?");
            pstmt.setString(1, adjustAnalyseId);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                accNumbers.add(rst.getString("FIndexNumber"));
                bgDataTable = accIntHelper.getSplitTablesByAcc(accNumbers).toArray(new String[0])[0];
                break block27;
            }
            var24_25 = resMap;
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            return var24_25;
        }
        try {
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
lbl51:
            // 2 sources

            sql = new StringBuffer();
            sql.append("SELECT ");
            sql.append("data.FID id,");
            sql.append("data.FBalance oldValue,");
            sql.append("data.FAdjValue adjustValue,");
            sql.append("data.FFormula formula,");
            sql.append("data.FBgDataID bgDataId,");
            sql.append("data.FAdjReason FAdjReason,");
            sql.append("record.FBgFormId bgFormId,");
            sql.append("org.FLongNumber orgLongNumber,");
            sql.append("org.FName_" + l + " orgName,");
            sql.append("record.FPastSource source,");
            sql.append("auditor.FName_" + l + " auditerName,");
            sql.append("record.FCreateTime auditTime,");
            sql.append("ajustor.FName_" + l + " adjustorName,");
            sql.append("data.FAdjustTime adjustTime,");
            sql.append("record.FVersionNo versionNo,");
            sql.append("element.FName_" + l + " elementName,");
            sql.append("period.FName_" + l + " periodName,");
            sql.append("bgScenario.FNumber bgScenarioNumber,");
            sql.append("bgScenario.FName_" + l + " bgScenarioName,");
            sql.append("bgVersion.FNumber bgVersionNumber,");
            sql.append("bgVersion.FName_" + l + " bgVersionName ");
            sql.append(" FROM T_MBG_BgPastData data");
            sql.append(" LEFT JOIN T_MBG_BgPastRecord record ON data.FPastRecordID = record.FID");
            sql.append(" LEFT JOIN T_PM_User auditor ON record.FCreatorID = auditor.FID");
            sql.append(" LEFT JOIN T_PM_User ajustor ON data.FAdjustorId = ajustor.FID");
            sql.append(" LEFT JOIN " + bgDataTable + " bgData ON data.FBgDataID=bgData.FID");
            if (accIntHelper.isUseAccInt()) {
                sql.append(" LEFT JOIN T_MBG_BgElement element ON element.FIntID = bgData.FBgElementID");
            } else {
                sql.append(" LEFT JOIN T_MBG_BgElement element ON element.FID = bgData.FBgElementID");
            }
            sql.append(" LEFT JOIN T_MBG_BgScenario bgScenario ON bgScenario.FScenarioID = bgData.FScenario");
            sql.append(" LEFT JOIN T_MBG_BgVersion bgVersion ON bgVersion.FVersionID = bgData.FVersion");
            if (accIntHelper.isUseAccInt()) {
                sql.append(" LEFT JOIN T_MBG_BgPeriod period ON period.FIntID = bgData.FBgPeriodID");
                sql.append(" Left JOIN T_MBG_BgOrgUnit org on bgData.FOrgUnitId = org.FIntID AND org.FViewId = '" + accIntHelper.getSchemeHelper().getBgOrgViewId() + "' and org.FIsVirtual = 0");
            } else {
                sql.append(" LEFT JOIN T_MBG_BgPeriod period ON period.FID = bgData.FBgPeriodID");
                sql.append(" Left JOIN T_Org_CostCenter org on bgData.FOrgUnitId = org.FID");
            }
            sql.append(" Where FBgDataId IN (Select FBgDataId From T_Mbg_BgAdjustAnalyseEntry Where FDataId = ?) and bgVersion.FNumber = ?");
            sql.append(" ORDER BY org.FLongNumber DESC, record.FVersionNo DESC,record.FCreateTime DESC");
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, adjustAnalyseId);
            pstmt.setString(2, bgVersionNumber);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                temFormula = rst.getString("formula");
                pastData = this.createData(formulaForItem, itemName, temFormula);
                itemNumber = BgNFSHelper.parseFormulaPara(formulaMap, temFormula)[0];
                index = itemNumber.indexOf(",");
                if (index > 0) {
                    pastData.setIndexNumber(itemNumber.substring(0, index));
                    pastData.setDimNumber(itemNumber.substring(index + 1));
                    itemNumbers.add(pastData.getDimNumber());
                } else {
                    pastData.setIndexNumber(itemNumber);
                }
                itemNumbers.add(pastData.getIndexNumber());
                pastData.setPastDataId(rst.getString("id"));
                pastData.setBgDataId(rst.getString("bgDataId"));
                pastData.setBgFormId(rst.getString("bgFormId"));
                pastData.setOrgLongNumber(rst.getString("orgLongNumber"));
                pastData.setOrgName(rst.getString("orgName"));
                pastData.setBgElementName(rst.getString("elementName"));
                pastData.setPeriod(rst.getString("periodName"));
                pastData.setPastSource(rst.getInt("source"));
                pastData.setOldValue(rst.getBigDecimal("oldValue"));
                pastData.setAdjustValue(rst.getBigDecimal("adjustValue"));
                pastData.setAdjustorName(rst.getString("adjustorName"));
                pastData.setAdjustTime(rst.getTimestamp("adjustTime"));
                pastData.setAuditorName(rst.getString("auditerName"));
                pastData.setAuditTime(rst.getTimestamp("auditTime"));
                pastData.setFormula(temFormula);
                pastData.setVersionNo(rst.getBigDecimal("versionNo"));
                pastData.setAdjustReason(rst.getString("FAdjReason"));
                pastData.setBgScenarioNumber(rst.getString("bgScenarioNumber"));
                pastData.setBgScenarioName(rst.getString("bgScenarioName"));
                pastData.setBgVersionNumber(rst.getString("bgVersionNumber"));
                pastData.setBgVersionName(rst.getString("bgVersionName"));
                pastDataList.add(pastData);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!isOnlyShowAudit) {
                sql = new StringBuffer();
                sql.append("SELECT");
                sql.append(" data.FID dataId,");
                sql.append(" data.FFormula formula,");
                sql.append(" entry.FFormId bgFormId,");
                sql.append(" us.FName_" + l + " adjustor,");
                sql.append(" data.FCreateTime createTime,");
                sql.append(" data.FValue newValue,");
                sql.append(" data.FOldValue oldValue,");
                sql.append(" data.FAdjustReason adjustReason,");
                sql.append(" data.FBgItemCombination itemComBinId,");
                sql.append(" period.FName_" + l + " periodName,");
                sql.append(" element.FName_" + l + " elementname,");
                sql.append(" bgVersion.FNumber bgVersionNumber,");
                sql.append(" bgVersion.FName_" + l + " bgVersionName,");
                sql.append("org.FLongNumber orgLongNumber,");
                sql.append("org.FName_" + l + " orgName,");
                sql.append("bgScenario.FNumber bgScenarioNumber,");
                sql.append("bgScenario.FName_" + l + " bgScenarioName");
                sql.append(" FROM T_MBG_BgTmpData data");
                sql.append(" Inner JOIN T_Org_CostCenter org on data.FOrgUnitId = org.FID");
                sql.append(" LEFT JOIN T_MBG_BgTmpDataentry entry ON data.FID = entry.FDataID");
                sql.append(" LEFT JOIN T_PM_User us ON us.FID = data.FCreatorID");
                sql.append(" LEFT JOIN T_MBG_BgElement element ON element.FID = data.FBgElementId");
                sql.append(" LEFT JOIN T_MBG_BgVersion bgVersion ON bgVersion.FVersionID = data.FVersion");
                sql.append(" LEFT JOIN T_MBG_BgPeriod period ON period.FID = data.FBgPeriodID");
                sql.append(" LEFT JOIN T_MBG_BgScenario bgScenario ON bgScenario.FScenarioID = data.FScenario");
                sql.append(" WHERE data.FId IN (Select FBgDataId From T_Mbg_BgAdjustAnalyseEntry Where FDataId = ?) and FBgSchemeRootId = ? AND bgVersion.FNumber = ?");
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, adjustAnalyseId);
                pstmt.setString(2, bgSchemeId);
                pstmt.setString(3, bgVersionNumber);
                bgFormIds = new HashSet<String>();
                tempPastDataMap = new HashMap<String, List<BgAdjustPastDataInfo>>();
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    temFormula = rst.getString("formula");
                    pastData = this.createData(formulaForItem, itemName, temFormula);
                    itemNumber = BgNFSHelper.parseFormulaPara(formulaMap, temFormula)[0];
                    index = itemNumber.indexOf(",");
                    if (index > 0) {
                        pastData.setIndexNumber(itemNumber.substring(0, index));
                        pastData.setDimNumber(itemNumber.substring(index + 1));
                        itemNumbers.add(pastData.getDimNumber());
                    } else {
                        pastData.setIndexNumber(itemNumber);
                    }
                    itemNumbers.add(pastData.getIndexNumber());
                    pastData.setBgDataId(rst.getString("dataId"));
                    pastData.setPastDataId(rst.getString("dataId"));
                    pastData.setBgFormId(rst.getString("bgFormId"));
                    pastData.setOrgLongNumber(rst.getString("orgLongNumber"));
                    pastData.setOrgName(rst.getString("orgName"));
                    pastData.setBgElementName(rst.getString("elementname"));
                    pastData.setPeriod(rst.getString("periodName"));
                    pastData.setPastSource(1);
                    type = BOSUuid.read((String)rst.getString("bgFormId")).getType();
                    if (new BgAdjustBillInfo().getBOSType().equals((Object)type)) {
                        bgAdjustBill.put(rst.getString("bgFormId"), pastData);
                        pastData.setPastSource(14);
                    } else if (new BgFormInfo().getBOSType().equals((Object)type)) {
                        bgFormIds.add(pastData.getBgFormId());
                    }
                    pastData.setOldValue(rst.getBigDecimal("oldValue"));
                    pastData.setAdjustValue(rst.getBigDecimal("newValue"));
                    pastData.setAdjustorName(rst.getString("adjustor"));
                    pastData.setAdjustTime(rst.getTimestamp("createTime"));
                    pastData.setFormula(temFormula);
                    pastData.setAdjustReason(rst.getString("adjustReason"));
                    pastData.setBgItemComBin(rst.getString("itemComBinId"));
                    pastData.setBgVersionNumber(rst.getString("bgVersionNumber"));
                    pastData.setBgVersionName(rst.getString("bgVersionName"));
                    pastData.setBgScenarioNumber(rst.getString("bgScenarioNumber"));
                    pastData.setBgScenarioName(rst.getString("bgScenarioName"));
                    pastData.setBgVersionNumber(rst.getString("bgVersionNumber"));
                    pastData.setBgVersionName(rst.getString("bgVersionName"));
                    pastData.setAdjusting(true);
                    if (!tempPastDataMap.containsKey(pastData.getBgFormId())) {
                        tempPastDatas = new ArrayList<E>();
                        tempPastDataMap.put(pastData.getBgFormId(), tempPastDatas);
                    }
                    ((List)tempPastDataMap.get(pastData.getBgFormId())).add(pastData);
                }
                this.setSourceByBgForm(ctx, pastDataList, bgFormIds, tempPastDataMap);
                this.setSourceByBgAdjustBill(ctx, pastDataList, bgAdjustBill);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            itemName = DimensionFormulaFacadeFactory.getLocalInstance(ctx).getDimensionCombName(bgSchemeId, itemNumbers, orgId, true, false);
            for (i = 0; i < pastDataList.size(); ++i) {
                pastData = (BgAdjustPastDataInfo)pastDataList.get(i);
                pastData.setIndexName((String)itemName.get(pastData.getIndexNumber()));
                if (pastData.getDimNumber() == null) continue;
                pastData.setDimName((String)itemName.get(pastData.getDimNumber()));
            }
        }
        catch (SQLException e) {
            try {
                BgAdjustFacadaControllerBean.logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable var30_34) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw var30_34;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        resMap.put("success", pastDataList);
        return resMap;
    }

    private void setRollPastSourceByRollBgForm(Context ctx, Set<String> bgFormIds, Map<String, List<BgAdjustPastDataInfo>> tempPastDataMap) throws BOSException {
        if (!bgFormIds.isEmpty()) {
            HashSet rollStates = new HashSet(2);
            Collections.addAll(rollStates, 6, 12);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.getSelector().add("id");
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", bgFormIds, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("state", rollStates, CompareType.INCLUDE));
            entityViewInfo.setFilter(filter);
            BgFormCollection bgFormCollection = BgFormFactory.getLocalInstance(ctx).getBgFormCollection(entityViewInfo);
            int in = bgFormCollection.size();
            for (int i = 0; i < in; ++i) {
                String bgFormId = bgFormCollection.get(i).getId().toString();
                if (!tempPastDataMap.containsKey(bgFormId)) continue;
                List<BgAdjustPastDataInfo> bgAdjustPastDataInfos = tempPastDataMap.get(bgFormId);
                for (BgAdjustPastDataInfo info : bgAdjustPastDataInfos) {
                    info.setPastSource(10);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _pastDataView(Context ctx, Map parameter, Set orgIdSet) throws BOSException, EASBizException {
        BgElementCollection col;
        EntityViewInfo evi;
        String[] formulaParams;
        String temFormula22;
        StringBuffer sql;
        Map itemName;
        String bgSchemeId;
        HashMap<String, String> formulaForItem;
        HashMap<String, ArrayList<BgAdjustPastDataInfo>> map = new HashMap<String, ArrayList<BgAdjustPastDataInfo>>();
        if (parameter == null || parameter.isEmpty() || orgIdSet == null || orgIdSet.isEmpty() || !parameter.containsKey("billId")) {
            return map;
        }
        String billId = null;
        HashSet<String> billIdSetOfAdjust = null;
        HashSet<String> billIdSetOfApprove = null;
        billId = (String)parameter.get("billId");
        BgFormInfo bgForm = MbgViewListFormServerHelper.getBgFormInfo(ctx, BOSUuid.read((String)billId), false);
        if (bgForm.getBgVersion().isIsRollVersion()) {
            return null;
        }
        BgFormStateEnum bgFormState = BgFormStateEnum.Approved;
        if (parameter.get("BGFORM_INFO") instanceof BgFormInfo && ((BgFormInfo)parameter.get("BGFORM_INFO")).getState() != null) {
            bgFormState = ((BgFormInfo)parameter.get("BGFORM_INFO")).getState();
        }
        billIdSetOfAdjust = new HashSet<String>(BgAdjustHelper.getOrgFormIdMap(this.getConnection(ctx), ctx, bgForm, orgIdSet).values());
        billIdSetOfApprove = new HashSet<String>(BgAdjustHelper.getOrgIdAndFormIdForApproved(this.getConnection(ctx), ctx, bgForm, orgIdSet).values());
        ArrayList<BgAdjustPastDataInfo> pastDataList = new ArrayList<BgAdjustPastDataInfo>();
        String orgUnitId = (String)parameter.get("ORGUNIT_ID");
        Set versionNumberSet = (Set)parameter.get("Version");
        Set<String> formulaSet = this.filterActOfFormula(ctx, (Set)parameter.get("formula"));
        Map adjustMap = (Map)parameter.get("adjustMap");
        if (orgIdSet == null || orgIdSet.isEmpty() || StringUtils.isEmpty((String)billId) || billIdSetOfAdjust == null && billIdSetOfApprove == null || billIdSetOfAdjust.isEmpty() && billIdSetOfApprove.isEmpty() || StringUtils.isEmpty((String)orgUnitId) || formulaSet == null || formulaSet.isEmpty() || versionNumberSet.isEmpty()) {
            return null;
        }
        BgVersionCollection versionColls = BgVersionHelper.getVersionColls((Context)ctx, (Set)versionNumberSet);
        if (versionColls == null) {
            return null;
        }
        HashMap nowAdjustMap = new HashMap();
        for (Object orgId : orgIdSet) {
            Object[] keys;
            if (adjustMap == null || !adjustMap.containsKey(orgId.toString()) || (Map)adjustMap.get(orgId.toString()) == null) continue;
            HashMap subMap = new HashMap();
            subMap.putAll((Map)adjustMap.get(orgId.toString()));
            nowAdjustMap.put(orgId.toString(), subMap);
            for (Object key : keys = subMap.keySet().toArray()) {
                if (formulaSet.contains(key)) continue;
                subMap.remove(key);
            }
        }
        BgAdjustPastDataInfo pastData = null;
        BgAdjustFormDiversityData tempData = null;
        Connection conn = null;
        PreparedStatement pmst = null;
        PreparedStatement insertPrmt = null;
        ResultSet rs = null;
        TempTablePool pool = null;
        String tmpTableName = null;
        String tmpVersionTable = null;
        String tmpBillIdTableForAdjust = null;
        String tmpBillIdTableForApprove = null;
        String tmpOrgIdTable = null;
        int batchSize = 50;
        int count = 0;
        String l = ctx.getLocale().getDisplayName();
        String bgDataTableName = null;
        HashMap formulaMap = new HashMap();
        HashMap bgadjustBill = new HashMap();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pool = TempTablePool.getInstance((Context)ctx);
            Map<String, Set<String>> childrenOrgIdsMap2332 = null;
            if (BgProcessEnum.C01.equals((Object)bgForm.getProcessType())) {
                childrenOrgIdsMap2332 = this.getChildrenOrgIdsMap(ctx, conn, bgForm.getBizBgScheme().getId().toString(), new HashSet<String>(orgIdSet));
                Iterator<String> ite = childrenOrgIdsMap2332.keySet().iterator();
                while (ite.hasNext()) {
                    orgIdSet.addAll((Collection)childrenOrgIdsMap2332.get(ite.next()));
                }
            }
            if (orgIdSet != null && !orgIdSet.isEmpty()) {
                tmpOrgIdTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FOrgId NVARCHAR(44))");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpOrgIdTable + " (FOrgId) values (?)"), (Collection)orgIdSet);
            }
            if (billIdSetOfAdjust != null && !billIdSetOfAdjust.isEmpty()) {
                tmpBillIdTableForAdjust = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FFormId NVARCHAR(44))");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpBillIdTableForAdjust + " (FFormId) values (?)"), billIdSetOfAdjust);
            }
            if (billIdSetOfApprove != null && !billIdSetOfApprove.isEmpty()) {
                tmpBillIdTableForApprove = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FFormId NVARCHAR(44))");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpBillIdTableForApprove + " (FFormId) values (?)"), billIdSetOfApprove);
            }
            tmpVersionTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(80))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpVersionTable + " (FNumber) values (?)"), (Collection)versionNumberSet);
            String creatTmpSql = "Create Table TEML_KSQL_0 (FFormula NVARCHAR(300) DEFAULT '' NOT NULL)";
            tmpTableName = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)creatTmpSql);
            String insertSql = "Insert Into " + tmpTableName + " (FFormula) values (?)";
            insertPrmt = conn.prepareStatement(insertSql);
            HashSet<String> itemNumberList = new HashSet<String>();
            formulaForItem = new HashMap<String, String>();
            for (String fromulaStr : formulaSet) {
                String[] para = BgNFSHelper.parseFormulaPara(formulaMap, fromulaStr);
                itemNumberList.add(para[0]);
                formulaForItem.put(fromulaStr, para[0]);
                insertPrmt.setString(1, fromulaStr);
                insertPrmt.addBatch();
                if (++count < batchSize) continue;
                insertPrmt.executeBatch();
                insertPrmt.clearBatch();
                count = 0;
            }
            if (count >= 0) {
                insertPrmt.executeBatch();
                insertPrmt.clearBatch();
                count = 0;
            }
            bgSchemeId = null;
            pmst = conn.prepareStatement("SELECT FID, FRefCube FROM T_MBG_BgScheme WHERE FID = (SELECT FBgSchemeID FROM T_MBG_BgForm WHERE FID = ?)");
            pmst.setString(1, billId);
            rs = pmst.executeQuery();
            if (rs.next()) {
                bgDataTableName = BgCubeUtils.getCubeName(rs.getString("FRefCube"), bgForm.getProcessType());
                bgSchemeId = rs.getString("FID");
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pmst);
            itemName = DimensionFormulaFacadeFactory.getLocalInstance(ctx).getDimensionCombName(bgSchemeId, itemNumberList, orgUnitId, true, false);
            if (StringUtils.isEmpty((String)bgDataTableName)) {
                throw new BgAdjustException(BgAdjustException.NOTADJUSTRECORD);
            }
            sql = new StringBuffer();
            if (!StringUtils.isEmpty((String)tmpBillIdTableForApprove)) {
                BgSchemeAccIntHelper accIntHelper = new BgSchemeAccIntHelper(ctx, bgSchemeId, bgDataTableName);
                Set<String> cubeNames = accIntHelper.getSplitTablesByAcc(null);
                for (String cbueName : cubeNames) {
                    sql.setLength(0);
                    pmst = this.dealPrmtForPastRecord(conn, tmpBillIdTableForApprove, tmpTableName, tmpVersionTable, l, cbueName, sql, tmpOrgIdTable, accIntHelper.getSchemeHelper().getBgOrgViewId(), accIntHelper.isUseAccInt());
                    rs = pmst.executeQuery();
                    while (rs.next()) {
                        temFormula22 = rs.getString("formula");
                        if (!formulaSet.contains(temFormula22)) continue;
                        pastData = this.createData(formulaForItem, itemName, temFormula22);
                        pastData.setPastDataId(rs.getString("id"));
                        pastData.setBgDataId(rs.getString("bgDataId"));
                        pastData.setBgFormId(rs.getString("bgFormId"));
                        pastData.setOrgName(rs.getString("orgName"));
                        pastData.setOrgLongNumber(rs.getString("orgLongNumber"));
                        pastData.setBgElementName(rs.getString("elementName"));
                        pastData.setPeriod(rs.getString("periodName"));
                        pastData.setPastSource(rs.getInt("source"));
                        pastData.setOldValue(rs.getBigDecimal("oldValue"));
                        pastData.setAdjustValue(rs.getBigDecimal("adjustValue"));
                        pastData.setAdjustorName(rs.getString("adjustorName"));
                        pastData.setAdjustTime(rs.getTimestamp("adjustTime"));
                        pastData.setAuditorName(rs.getString("auditerName"));
                        pastData.setAuditTime(rs.getTimestamp("auditTime"));
                        pastData.setFormula(temFormula22);
                        pastData.setVersionNo(rs.getBigDecimal("versionNo"));
                        pastData.setAdjustReason(rs.getString("FAdjReason"));
                        pastData.setBgItemComBin(rs.getString("itemCombin"));
                        pastData.setBgScenarioNumber(rs.getString("bgScenarioNumber"));
                        pastData.setBgScenarioName(rs.getString("bgScenarioName"));
                        pastData.setBgVersionNumber(rs.getString("bgVersionNumber"));
                        pastData.setBgVersionName(rs.getString("bgVersionName"));
                        pastDataList.add(pastData);
                    }
                    SQLUtils.cleanup((ResultSet)rs, (Statement)pmst);
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (tmpTableName != null) {
                        BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpTableName);
                    }
                    if (tmpVersionTable != null) {
                        BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpVersionTable);
                    }
                    if (tmpBillIdTableForAdjust != null) {
                        BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpBillIdTableForAdjust);
                    }
                    if (tmpOrgIdTable != null) {
                        BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpOrgIdTable);
                    }
                    if (tmpBillIdTableForApprove != null) {
                        BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpBillIdTableForApprove);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SQLUtils.cleanup(insertPrmt);
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                throw throwable;
            }
        }
        sql = new StringBuffer();
        sql.append("select fstate from t_mbg_bgform where fstate <> 15 and fid <> fadjustid and fadjustid = ?");
        pmst = conn.prepareStatement(sql.toString());
        pmst.setString(1, billId);
        rs = pmst.executeQuery();
        BgPastSourceEnum source = BgPastSourceEnum.ADJUST;
        if (bgForm.getState() != null && bgForm.getState().getValue() == 6) {
            source = BgPastSourceEnum.ROLL;
        }
        while (rs.next()) {
            int state = rs.getInt(1);
            if (state != 6) continue;
            source = BgPastSourceEnum.ROLL;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst);
        HashMap<String, BgAdjustPastDataInfo> bgAdjustBill = new HashMap<String, BgAdjustPastDataInfo>();
        if (!StringUtils.isEmpty((String)tmpBillIdTableForAdjust) && !BgFormStateEnum.Approved.equals((Object)bgFormState)) {
            sql = new StringBuffer();
            pmst = orgIdSet.size() > 1 && !BgFormStateEnum.Approved.equals((Object)bgFormState) ? this.dealPrmtForTmp(conn, l, sql, tmpBillIdTableForAdjust, tmpTableName, tmpOrgIdTable, tmpVersionTable, bgSchemeId, bgForm.getProcessType()) : this.dealPrmtForTmp(conn, l, sql, tmpBillIdTableForAdjust, null, null, null, bgSchemeId, bgForm.getProcessType());
            rs = pmst.executeQuery();
            while (rs.next()) {
                String orgId;
                temFormula22 = rs.getString("formula");
                if (!formulaSet.contains(temFormula22) || !orgIdSet.contains(orgId = rs.getString("orgId"))) continue;
                pastData = this.createData(formulaForItem, itemName, temFormula22);
                pastData.setPastDataId(rs.getString("dataId"));
                pastData.setBgFormId(rs.getString("formId"));
                pastData.setOrgName(rs.getString("orgName"));
                pastData.setOrgLongNumber(rs.getString("orgLongNumber"));
                pastData.setBgElementName(rs.getString("elementname"));
                pastData.setPeriod(rs.getString("periodName"));
                pastData.setPastSource(source.getValue());
                BOSObjectType type = BOSUuid.read((String)pastData.getBgFormId()).getType();
                if (new BgAdjustBillInfo().getBOSType().equals((Object)type)) {
                    bgAdjustBill.put(pastData.getBgFormId(), pastData);
                    pastData.setPastSource(14);
                }
                pastData.setOldValue(rs.getBigDecimal("oldValue"));
                pastData.setAdjustValue(rs.getBigDecimal("newValue"));
                pastData.setAdjustorName(rs.getString("adjustor"));
                pastData.setAdjustTime(rs.getTimestamp("createTime"));
                pastData.setFormula(temFormula22);
                pastData.setAdjustReason(rs.getString("adjustReason"));
                pastData.setBgItemComBin(rs.getString("itemComBinId"));
                pastData.setBgVersionNumber(rs.getString("bgVersionNumber"));
                pastData.setBgVersionName(rs.getString("bgVersionName"));
                pastData.setAdjusting(true);
                if (nowAdjustMap.get(orgId) != null && ((Map)nowAdjustMap.get(orgId)).containsKey(temFormula22)) {
                    tempData = (BgAdjustFormDiversityData)((Map)nowAdjustMap.get(orgId)).get(temFormula22);
                    pastData.setAdjustValue(tempData.getNewValue());
                    ((Map)nowAdjustMap.get(orgId)).remove(temFormula22);
                }
                pastDataList.add(pastData);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pmst);
        }
        HashMap<String, String> bgElements = new HashMap<String, String>();
        HashMap<String, String> bgPeriods = new HashMap<String, String>();
        for (Map subMap : nowAdjustMap.values()) {
            if (subMap == null) continue;
            for (String temFormula22 : subMap.keySet()) {
                formulaParams = BgNFSHelper.parseFormulaPara(formulaMap, temFormula22);
                bgElements.put(formulaParams[2], null);
                bgPeriods.put(formulaParams[1], null);
            }
        }
        if (!bgElements.isEmpty()) {
            evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", new HashSet(bgElements.keySet()), CompareType.INCLUDE));
            col = BgElementFactory.getLocalInstance((Context)ctx).getBgElementCollection(evi);
            for (int i = 0; i < col.size(); ++i) {
                bgElements.put(col.get(i).getNumber(), col.get(i).getName());
            }
        }
        if (!bgPeriods.isEmpty()) {
            evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", new HashSet(bgPeriods.keySet()), CompareType.INCLUDE));
            col = BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodCollection(evi);
            for (int i = 0; i < col.size(); ++i) {
                bgPeriods.put(col.get(i).getNumber(), col.get(i).getName());
            }
        }
        HashMap<String, String> formIdMap = new HashMap<String, String>();
        sql = new StringBuffer();
        sql.append("SELECT data.FFormula formula, entry.FFormId");
        sql.append(" FROM T_MBG_BgTmpData data");
        sql.append(" LEFT JOIN T_MBG_BgTmpDataEntry entry ON data.FID = entry.FDataID");
        sql.append(" LEFT JOIN T_MBG_BgVersion bgVersion ON bgVersion.FVersionID = data.FVersion");
        sql.append(" Inner JOIN " + tmpOrgIdTable + " tmpOrgIdTable on data.FOrgUnitId = tmpOrgIdTable.FOrgId");
        sql.append(" WHERE  exists (SELECT FFormula FROM " + tmpTableName + " where data.FFORMULA = FFormula)");
        sql.append(" and exists ( SELECT FNumber FROM " + tmpVersionTable + " where bgVersion.FNumber = FNumber)");
        pmst = conn.prepareStatement(sql.toString());
        rs = pmst.executeQuery();
        while (rs.next()) {
            String temFormula = rs.getString("formula");
            String formid = rs.getString("FFormId");
            formIdMap.put(temFormula, formid);
        }
        EntityViewInfo evi2 = new EntityViewInfo();
        evi2.setSelector(new SelectorItemCollection());
        evi2.getSelector().add("id");
        evi2.getSelector().add("name");
        evi2.getSelector().add("number");
        evi2.getSelector().add("longNumber");
        evi2.setFilter(new FilterInfo());
        evi2.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(nowAdjustMap.keySet()), CompareType.INCLUDE));
        FullOrgUnitCollection orgCol = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(evi2);
        Map orgMap = BgCommHelper.transeToMap((IObjectCollection)orgCol);
        if (!BgFormStateEnum.Approved.equals((Object)bgFormState)) {
            for (int index = 0; index < versionColls.size(); ++index) {
                BgVersionInfo version = versionColls.get(index);
                for (String orgId : nowAdjustMap.keySet()) {
                    String orgName = ((FullOrgUnitInfo)orgMap.get(orgId)).getName();
                    String orgLongNumber = ((FullOrgUnitInfo)orgMap.get(orgId)).getLongNumber();
                    for (String temFormula : ((Map)nowAdjustMap.get(orgId)).keySet()) {
                        formulaParams = BgNFSHelper.parseFormulaPara(formulaMap, temFormula);
                        tempData = (BgAdjustFormDiversityData)((Map)nowAdjustMap.get(orgId)).get(temFormula);
                        pastData = this.createData(formulaForItem, itemName, temFormula);
                        pastData.setPastDataId("");
                        pastData.setBgElementName((String)bgElements.get(formulaParams[2]));
                        pastData.setPeriod((String)bgPeriods.get(formulaParams[1]));
                        pastData.setPastSource(source.getValue());
                        if (formIdMap.containsKey(temFormula)) {
                            pastData.setBgFormId((String)formIdMap.get(temFormula));
                            BOSObjectType type = BOSUuid.read((String)((String)formIdMap.get(temFormula))).getType();
                            if (new BgAdjustBillInfo().getBOSType().equals((Object)type)) {
                                bgAdjustBill.put((String)formIdMap.get(temFormula), pastData);
                                pastData.setPastSource(14);
                            }
                        }
                        pastData.setOrgName(orgName);
                        pastData.setOrgLongNumber(orgLongNumber);
                        pastData.setOldValue(tempData.getOldValue());
                        pastData.setAdjustValue(tempData.getNewValue());
                        pastData.setAdjustorName(ContextUtil.getCurrentUserInfo((Context)ctx).getName());
                        pastData.setAdjustTime(new Timestamp(tempData.getAdjustTime().getTime()));
                        pastData.setFormula(temFormula);
                        pastData.setAdjustReason(tempData.getAdjustReson());
                        pastData.setBgItemComBin("");
                        pastData.setBgVersionNumber(version.getNumber());
                        pastData.setBgVersionName(version.getName());
                        pastData.setAdjusting(true);
                        pastDataList.add(pastData);
                    }
                }
            }
        }
        this.setSourceByBgAdjustBill(ctx, pastDataList, bgAdjustBill);
        HashMap<String, String> bgScenario = new HashMap<String, String>();
        for (int i = 0; i < pastDataList.size(); ++i) {
            pastData = (BgAdjustPastDataInfo)pastDataList.get(i);
            if (pastData.getBgScenarioNumber() != null) continue;
            pastData.setBgScenarioNumber(BgNFSHelper.parseFormulaPara(pastData.getFormula())[3]);
            bgScenario.put(pastData.getBgScenarioNumber(), null);
        }
        if (!bgScenario.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(new SelectorItemCollection());
            view.getSelector().add("number");
            view.getSelector().add("name");
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("number", new HashSet(bgScenario.keySet()), CompareType.INCLUDE));
            BgScenarioCollection col2 = BgScenarioFactory.getLocalInstance((Context)ctx).getBgScenarioCollection(view);
            if (col2 != null) {
                for (int i = 0; i < col2.size(); ++i) {
                    bgScenario.put(col2.get(i).getNumber(), col2.get(i).getName());
                }
            }
        }
        for (int i = 0; i < pastDataList.size(); ++i) {
            pastData = (BgAdjustPastDataInfo)pastDataList.get(i);
            if (pastData.getBgScenarioName() != null) continue;
            pastData.setBgScenarioName((String)bgScenario.get(pastData.getBgScenarioNumber()));
        }
        try {
            if (tmpTableName != null) {
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTableName);
            }
            if (tmpVersionTable != null) {
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpVersionTable);
            }
            if (tmpBillIdTableForAdjust != null) {
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpBillIdTableForAdjust);
            }
            if (tmpOrgIdTable != null) {
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpOrgIdTable);
            }
            if (tmpBillIdTableForApprove != null) {
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpBillIdTableForApprove);
            }
        }
        catch (Exception childrenOrgIdsMap2332) {
            // empty catch block
        }
        SQLUtils.cleanup((Statement)insertPrmt);
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
        map.put("success", pastDataList);
        return map;
    }

    private Set<String> filterActOfFormula(Context ctx, Set<String> formulaSet) throws BOSException {
        if (formulaSet == null || formulaSet.isEmpty()) {
            return null;
        }
        HashSet<String> rs = new HashSet<String>();
        Map scenarioCaches = BgDimCacheUtils.getScenarioCache((Context)ctx);
        for (String formula : formulaSet) {
            String[] para = BgNFSHelper.parseFormulaPara(formula);
            BgScenarioInfo info = (BgScenarioInfo)scenarioCaches.get(para[3]);
            if (!BgScenarioType.BudgetData.equals((Object)info.getType())) continue;
            rs.add(formula);
        }
        return rs;
    }

    private void setSourceByBgAdjustBill(Context ctx, List<BgAdjustPastDataInfo> pastDataList, Map<String, BgAdjustPastDataInfo> bgAdjustBill) throws BOSException {
        int i;
        EntityViewInfo entity = new EntityViewInfo();
        entity.setSelector(new SelectorItemCollection());
        entity.setFilter(new FilterInfo());
        entity.getSelector().add("id");
        entity.getSelector().add("type");
        entity.getFilter().getFilterItems().add(new FilterItemInfo("id", bgAdjustBill.keySet(), CompareType.INCLUDE));
        this.bgAdjustBillCollection = BgAdjustBillFactory.getLocalInstance(ctx).getBgAdjustBillCollection(entity);
        for (i = 0; i < this.bgAdjustBillCollection.size(); ++i) {
            if (this.bgAdjustBillCollection.get(i).getType().getValue() < 2) {
                bgAdjustBill.get(this.bgAdjustBillCollection.get(i).getId().toString()).setPastSource(13);
                continue;
            }
            bgAdjustBill.get(this.bgAdjustBillCollection.get(i).getId().toString()).setPastSource(3);
        }
        for (i = 0; i < pastDataList.size(); ++i) {
            if (!bgAdjustBill.containsKey(pastDataList.get(i).getBgFormId())) continue;
            pastDataList.get(i).setPastSource(bgAdjustBill.get(pastDataList.get(i).getBgFormId()).getPastSource());
        }
    }

    private PreparedStatement dealPrmtForTmp(Connection conn, String l, StringBuffer sql, String tmpBillIdTable, String tmpTableName, String tmpOrgIdTable, String tmpVersionTable, String bgSchemeId, BgProcessEnum processType) throws SQLException {
        sql.append("SELECT");
        sql.append(" data.FID dataId,");
        sql.append(" data.FFormula formula,");
        sql.append(" us.FName_" + l + " adjustor,");
        sql.append(" data.FCreateTime createTime,");
        sql.append(" data.FValue newValue,");
        sql.append(" data.FOldValue oldValue,");
        sql.append(" data.FAdjustReason adjustReason,");
        sql.append(" data.FBgItemCombination itemComBinId,");
        sql.append(" entry.Fformid formId ,");
        sql.append(" period.FName_" + l + " periodName,");
        sql.append(" element.FName_" + l + " elementname,");
        sql.append(" org.FName_" + l + " orgName,");
        sql.append(" org.FID orgId, ");
        sql.append(" org.FLongNumber orgLongNumber, ");
        sql.append(" bgVersion.FNumber bgVersionNumber,");
        sql.append(" bgVersion.FName_" + l + " bgVersionName");
        sql.append(" FROM T_MBG_BgTmpData data");
        sql.append(" LEFT JOIN T_MBG_BgTmpDataEntry entry ON data.FID = entry.FDataID");
        if (!StringUtils.isEmpty((String)tmpTableName)) {
            sql.append(" Inner JOIN " + tmpTableName + " tmpTableName on data.FFORMULA  = tmpTableName.FFORMULA ");
            sql.append(" Inner JOIN " + tmpOrgIdTable + " tmpOrgIdTable on data.FOrgUnitId  = tmpOrgIdTable.FOrgId ");
        } else {
            sql.append(" Inner JOIN " + tmpBillIdTable + " tmpBillIdTable on entry.FFormID = tmpBillIdTable.FFormId");
        }
        sql.append(" LEFT JOIN T_PM_User us ON us.FID=data.FLastUpdateUserID");
        sql.append(" LEFT JOIN T_MBG_BgElement element ON element.FID=data.FBgElementId");
        sql.append(" LEFT JOIN T_MBG_BgVersion bgVersion ON bgVersion.FVersionID = data.FVersion");
        sql.append(" LEFT JOIN T_MBG_BgPeriod period ON period.FID = data.FBgPeriodID");
        sql.append(" Inner JOIN T_Org_CostCenter org on data.FOrgUnitId = org.FID");
        sql.append(" where data.FbgSchemerootId = ? and data.FprocessType = ?");
        if (!StringUtils.isEmpty((String)tmpVersionTable)) {
            sql.append(" and bgVersion.FNUMBER  in (select FNumber from " + tmpVersionTable + ")");
        }
        PreparedStatement pmst = conn.prepareStatement(sql.toString());
        pmst.setString(1, bgSchemeId);
        pmst.setInt(2, processType.getValue());
        return pmst;
    }

    private PreparedStatement dealPrmtForTmp(String billId, Connection conn, String l, StringBuffer sql) throws SQLException {
        sql.append("SELECT");
        sql.append(" data.FID dataId,");
        sql.append(" data.FFormula formula,");
        sql.append(" us.FName_" + l + " adjustor,");
        sql.append(" data.FCreateTime createTime,");
        sql.append(" data.FValue newValue,");
        sql.append(" data.FOldValue oldValue,");
        sql.append(" data.FAdjustReason adjustReason,");
        sql.append(" data.FBgItemCombination itemComBinId,");
        sql.append(" period.FName_" + l + " periodName,");
        sql.append(" element.FName_" + l + " elementname,");
        sql.append("org.FName_" + l + " orgName,");
        sql.append(" bgVersion.FNumber bgVersionNumber,");
        sql.append(" bgVersion.FName_" + l + " bgVersionName");
        sql.append(" FROM T_MBG_BgTmpData data");
        sql.append(" LEFT JOIN T_MBG_BgTmpDataEntry entry ON data.FID = entry.FDataID");
        sql.append(" LEFT JOIN T_PM_User us ON us.FID=data.FCreatorID");
        sql.append(" LEFT JOIN T_MBG_BgElement element ON element.FID=data.FBgElementId");
        sql.append(" LEFT JOIN T_MBG_BgVersion bgVersion ON bgVersion.FVersionID = data.FVersion");
        sql.append(" LEFT JOIN T_MBG_BgPeriod period ON period.FID = data.FBgPeriodID");
        sql.append(" Inner JOIN T_Org_CostCenter org on data.FOrgUnitId = org.FID");
        sql.append(" WHERE entry.FFormID=?");
        PreparedStatement pmst = conn.prepareStatement(sql.toString());
        pmst.setString(1, billId);
        return pmst;
    }

    private PreparedStatement dealPrmtForPastRecord(Connection conn, String tmpBillIdTableForApprove, String tmpTableName, String tmpVersionTable, String l, String bgDataTableName, StringBuffer sql, String tmpOrgIdTable, String orgViewId, boolean isUseAcctInt) throws SQLException {
        sql.append("SELECT ");
        sql.append("data.FID id,");
        sql.append("data.FBalance oldValue,");
        sql.append("data.FAdjValue adjustValue,");
        sql.append("data.FFormula formula,");
        sql.append("data.FBgDataID bgDataId,");
        sql.append("record.FBgFormId bgFormId,");
        sql.append("data.FAdjReason FAdjReason,");
        sql.append("bgData.FBgItemCombination itemCombin,");
        sql.append("record.FPastSource source,");
        sql.append("auditor.FName_" + l + " auditerName,");
        sql.append("record.FCreateTime auditTime,");
        sql.append("ajustor.FName_" + l + " adjustorName,");
        sql.append("data.FAdjustTime adjustTime,");
        sql.append("record.FVersionNo versionNo,");
        sql.append("element.FName_" + l + " elementName,");
        sql.append("period.FName_" + l + " periodName,");
        sql.append("bgScenario.FNumber bgScenarioNumber,");
        sql.append("bgScenario.FName_" + l + " bgScenarioName,");
        sql.append("org.FName_" + l + " orgName,");
        sql.append("org.FLongNumber orgLongNumber,");
        sql.append("bgVersion.FNumber bgVersionNumber,");
        sql.append("bgVersion.FName_" + l + " bgVersionName");
        sql.append(" FROM T_MBG_BgPastData data");
        sql.append(" LEFT JOIN T_MBG_BgPastRecord record ON data.FPastRecordID = record.FID");
        sql.append(" LEFT JOIN T_PM_User auditor ON record.FCreatorID = auditor.FID");
        sql.append(" LEFT JOIN T_PM_User ajustor ON data.FAdjustorId = ajustor.FID");
        sql.append(" LEFT JOIN " + bgDataTableName + " bgData ON data.FBgDataID=bgData.FID");
        sql.append(" LEFT JOIN T_MBG_BgScenario bgScenario ON bgScenario.FScenarioID = bgData.FScenario");
        sql.append(" LEFT JOIN T_MBG_BgVersion bgVersion ON bgVersion.FVersionID = bgData.FVersion");
        if (isUseAcctInt) {
            sql.append(" LEFT JOIN T_MBG_BgElement element ON element.FIntID = bgData.FBgElementID");
            sql.append(" LEFT JOIN T_MBG_BgPeriod period ON period.FIntID = bgData.FBgPeriodID");
            sql.append(" Inner JOIN T_MBG_BgOrgUnit org on bgData.FOrgUnitId = org.FIntID and org.FIsVirtual = 0 AND org.FViewId = '" + orgViewId + "'");
            sql.append(" Inner JOIN " + tmpOrgIdTable + " tmpOrgIdTable on org.FOrgUnitId = tmpOrgIdTable.FOrgId");
        } else {
            sql.append(" LEFT JOIN T_MBG_BgElement element ON element.FID = bgData.FBgElementID");
            sql.append(" LEFT JOIN T_MBG_BgPeriod period ON period.FID = bgData.FBgPeriodID");
            sql.append(" Inner JOIN T_Org_CostCenter org on bgData.FOrgUnitId = org.FID");
            sql.append(" Inner JOIN " + tmpOrgIdTable + " tmpOrgIdTable on org.FId = tmpOrgIdTable.FOrgId");
        }
        sql.append(" WHERE");
        sql.append(" (record.FBgFormID IN (SELECT form.FID FROM T_MBG_BgForm form, " + tmpBillIdTableForApprove + " tmpBillIdTable WHERE form.FAdjustID=tmpBillIdTable.FFormId)");
        sql.append(" OR DATA.FFORMULA IN (SELECT FFormula FROM " + tmpTableName).append(" ) ");
        sql.append(" ) and bgVersion.FNumber in ( SELECT FNumber FROM " + tmpVersionTable).append(" ) ");
        sql.append(" ORDER BY record.FVersionNo DESC,record.FCreateTime DESC");
        PreparedStatement pmst = conn.prepareStatement(sql.toString());
        return pmst;
    }

    private PreparedStatement dealPrmtForPastRecord(String billId, String orgUnitId, Connection conn, String tmpTableName, String tmpVersionTable, String l, String bgDataTableName, StringBuffer sql) throws SQLException {
        sql.append("SELECT ");
        sql.append("data.FID id,");
        sql.append("data.FBalance oldValue,");
        sql.append("data.FAdjValue adjustValue,");
        sql.append("data.FFormula formula,");
        sql.append("data.FBgDataID bgDataId,");
        sql.append("record.FBgFormId bgFormId,");
        sql.append("data.FAdjReason FAdjReason,");
        sql.append("bgData.FBgItemCombination itemCombin,");
        sql.append("record.FPastSource source,");
        sql.append("auditor.FName_" + l + " auditerName,");
        sql.append("record.FCreateTime auditTime,");
        sql.append("ajustor.FName_" + l + " adjustorName,");
        sql.append("data.FAdjustTime adjustTime,");
        sql.append("record.FVersionNo versionNo,");
        sql.append("element.FName_" + l + " elementName,");
        sql.append("period.FName_" + l + " periodName,");
        sql.append("bgScenario.FNumber bgScenarioNumber,");
        sql.append("bgScenario.FName_" + l + " bgScenarioName,");
        sql.append("org.FName_" + l + " orgName,");
        sql.append("bgVersion.FNumber bgVersionNumber,");
        sql.append("bgVersion.FName_" + l + " bgVersionName");
        sql.append(" FROM T_MBG_BgPastData data");
        sql.append(" LEFT JOIN T_MBG_BgPastRecord record ON data.FPastRecordID = record.FID");
        sql.append(" LEFT JOIN T_PM_User auditor ON record.FCreatorID = auditor.FID");
        sql.append(" LEFT JOIN T_PM_User ajustor ON data.FAdjustorId = ajustor.FID");
        sql.append(" LEFT JOIN " + bgDataTableName + " bgData ON data.FBgDataID=bgData.FID");
        sql.append(" LEFT JOIN T_MBG_BgElement element ON element.FID = bgData.FBgElementID");
        sql.append(" LEFT JOIN T_MBG_BgScenario bgScenario ON bgScenario.FScenarioID = bgData.FScenario");
        sql.append(" LEFT JOIN T_MBG_BgVersion bgVersion ON bgVersion.FVersionID = bgData.FVersion");
        sql.append(" LEFT JOIN T_MBG_BgPeriod period ON period.FID = bgData.FBgPeriodID");
        sql.append(" Inner JOIN T_Org_CostCenter org on bgData.FOrgUnitId = org.FID");
        sql.append(" WHERE");
        sql.append(" (record.FBgFormID IN (SELECT FID FROM T_MBG_BgForm WHERE FAdjustID=?)");
        sql.append(" OR DATA.FFORMULA IN (SELECT FFormula FROM " + tmpTableName).append(" ) ");
        sql.append(" ) AND bgData.FOrgUnitId = ? and bgVersion.FNumber in ( SELECT FNumber FROM " + tmpVersionTable).append(" ) ");
        sql.append(" ORDER BY record.FVersionNo DESC,record.FCreateTime DESC");
        PreparedStatement pmst = conn.prepareStatement(sql.toString());
        pmst.setString(1, billId);
        pmst.setString(2, orgUnitId);
        return pmst;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _checkHasAdjust(Context ctx, String bgSchemeId, Map formulas, String versionNum, BgProcessEnum processType) throws BOSException, EASBizException {
        block52: {
            block53: {
                result = new HashMap<String, Set<String>>();
                if (StringUtils.isEmpty((String)bgSchemeId) != false) return result;
                if (formulas == null) return result;
                if (formulas.isEmpty() != false) return result;
                if (StringUtils.isEmpty((String)versionNum)) {
                    return result;
                }
                splitMap = new HashMap<K, V>();
                _formulas = formulas;
                tmpSet = null;
                formulaSet = new HashSet<String>();
                iter = _formulas.values().iterator();
                while (iter.hasNext()) {
                    formulaSet.addAll((Collection)iter.next());
                }
                conn = null;
                pstmt = null;
                rst = null;
                pool = TempTablePool.getInstance((Context)ctx);
                tmpOrgTable = null;
                tmpFormulaTable = null;
                orgId = null;
                versionId = 0;
                try {
                    conn = this.getConnection(ctx);
                    bgDataTableName = null;
                    bgSchemeRootId = null;
                    pstmt = conn.prepareStatement("SELECT FID, FRefCube FROM T_MBG_BgScheme WHERE FID = ?");
                    pstmt.setString(1, bgSchemeId);
                    rst = pstmt.executeQuery();
                    if (rst.next()) {
                        bgDataTableName = rst.getString("FRefCube");
                        if (processType != null) {
                            bgDataTableName = BgCubeUtils.getCubeName(bgDataTableName, processType);
                        }
                        bgSchemeRootId = rst.getString("FID");
                    }
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    accIntHelper = new BgSchemeAccIntHelper(ctx, bgSchemeId, bgDataTableName);
                    rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FVersionID from T_MBG_BgVersion where FNumber = ?", (Object[])new Object[]{versionNum});
                    if (rst.next()) {
                        versionId = rst.getInt("FVersionID");
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                    if (StringUtils.isEmpty((String)bgDataTableName)) {
                        throw new BgAdjustException(BgAdjustException.NOTADJUSTRECORD);
                    }
                    allOrgIds = new HashSet<K>();
                    childrenOrgIdsMap = null;
                    if (BgProcessEnum.C01.equals((Object)processType)) {
                        childrenOrgIdsMap = this.getChildrenOrgIdsMap(ctx, conn, bgSchemeId, new HashSet<String>(_formulas.keySet()));
                        ite = childrenOrgIdsMap.keySet().iterator();
                        while (ite.hasNext()) {
                            allOrgIds.addAll((Collection)childrenOrgIdsMap.get(ite.next()));
                        }
                    } else {
                        allOrgIds.addAll(_formulas.keySet());
                    }
                    tmpOrgTable = pool.createDBSystemTempTable("Create Table T_MBG_TMPORGID(FOrgUnitId Varchar(44))", conn);
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpOrgTable + "(FOrgUnitId) Values(?)"), allOrgIds);
                    tmpFormulaTable = pool.createDBSystemTempTable("Create Table T_MBG_TMPORGID(FFormula NVARCHAR(300))", conn);
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpFormulaTable + "(FFormula) Values(?)"), formulaSet);
                    rst = BgDBUtils.executeQuery((Connection)conn, (String)("select FOrgUnitId, FFormula from T_MBG_BgTmpData where FBgSchemeRootId = ? and FOrgUnitId In (select FOrgUnitId from " + tmpOrgTable + ") and FFormula IN (select FFormula from " + tmpFormulaTable + ") and FVersion = ? and FProcessType = ?"), (Object[])new Object[]{bgSchemeRootId, versionId, processType == null ? BgProcessEnum.C01.getValue() : processType.getValue()});
                    while (rst.next()) {
                        orgId = rst.getString("FOrgUnitId");
                        if (_formulas.keySet().contains(orgId)) {
                            if (result.containsKey(orgId)) {
                                tmpSet = (Set)result.get(orgId);
                            } else {
                                tmpSet = new HashSet<E>();
                                result.put(orgId, tmpSet);
                            }
                            tmpSet.add(rst.getString("FFormula"));
                        }
                        if (!BgProcessEnum.C01.equals((Object)processType) || childrenOrgIdsMap == null) continue;
                        for (String key : childrenOrgIdsMap.keySet()) {
                            childrenOrgIds = childrenOrgIdsMap.get(key);
                            if (key.equals(orgId) || !childrenOrgIds.contains(orgId)) continue;
                            if (!result.containsKey(key)) {
                                result.put(key, new HashSet<E>());
                            }
                            ((Set)result.get(key)).add(rst.getString("FFormula"));
                        }
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                    bgDataTables = accIntHelper.getSplitTablesByFormula(formulaSet);
                    bgOrgViewId = BgSchemeInfo.getViewId(ctx, bgSchemeId, DimensionConstants.DEF_ORGUNIT_NUMBER);
                    for (String bgDataTable : bgDataTables) {
                        rst = accIntHelper.isUseAccInt() != false ? BgDBUtils.executeQuery((Connection)conn, (String)("select t1.FOrgUnitId, t.FFormula FROM T_MBG_BgPastData t left join " + bgDataTable + " t1 on t.FBgDataId = t1.FID Where t1.FOrgUnitId In (select FIntId FROM T_MBG_BgOrgUnit Where FViewId = ? AND FIsVirtual = 0 AND FOrgUnitID IN(select FOrgUnitId from " + tmpOrgTable + ")) and t.FFormula IN (select FFormula from " + tmpFormulaTable + ") and t1.FVersion = ?"), (Object[])new Object[]{bgOrgViewId, versionId}) : BgDBUtils.executeQuery((Connection)conn, (String)("select t1.FOrgUnitId, t.FFormula FROM T_MBG_BgPastData t left join " + bgDataTable + " t1 on t.FBgDataId = t1.FID Where t1.FOrgUnitId In (select FOrgUnitId from " + tmpOrgTable + ") and t.FFormula IN (select FFormula from " + tmpFormulaTable + ") and t1.FVersion = ?"), (Object[])new Object[]{versionId});
                        while (rst.next()) {
                            orgId = rst.getString("FOrgUnitId");
                            if (_formulas.keySet().contains(orgId)) {
                                if (result.containsKey(orgId)) {
                                    tmpSet = (Set)result.get(orgId);
                                } else {
                                    tmpSet = new HashSet<E>();
                                    result.put(orgId, tmpSet);
                                }
                                tmpSet.add(rst.getString("FFormula"));
                            }
                            if (!BgProcessEnum.C01.equals((Object)processType) || childrenOrgIdsMap == null) continue;
                            for (String key : childrenOrgIdsMap.keySet()) {
                                childrenOrgIds = childrenOrgIdsMap.get(key);
                                if (key.equals(orgId) || !childrenOrgIds.contains(orgId)) continue;
                                if (!result.containsKey(key)) {
                                    result.put(key, new HashSet<E>());
                                }
                                ((Set)result.get(key)).add(rst.getString("FFormula"));
                            }
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                    if (!accIntHelper.isUseAccInt() || result.isEmpty()) break block52;
                    evi = new EntityViewInfo();
                    evi.setSelector(new SelectorItemCollection());
                    evi.getSelector().add("intID");
                    evi.getSelector().add("orgUnitId");
                    evi.setFilter(new FilterInfo());
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("viewID", (Object)bgOrgViewId));
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("isVirtual", (Object)false));
                    if (result.size() <= 0) ** GOTO lbl178
                    intIds = new HashSet<Integer>();
                    for (String id : result.keySet()) {
                        try {
                            intIds.add(Integer.parseInt(id));
                        }
                        catch (Exception var30_37) {}
                    }
                    if (intIds.isEmpty()) {
                        ite = result;
                        if (tmpOrgTable == null) break block53;
                    }
                    ** GOTO lbl-1000
                }
                catch (SQLException e) {
                    try {
                        BgAdjustFacadaControllerBean.logger.error((Object)"check hasAdjust data error:", (Throwable)e);
                        throw new BOSException((Throwable)e);
                        catch (Exception e) {
                            BgAdjustFacadaControllerBean.logger.error((Object)"check hasAdjust data error:", (Throwable)e);
                            throw new BOSException((Throwable)e);
                        }
                    }
                    catch (Throwable var32_39) {
                        if (tmpOrgTable != null) {
                            try {
                                pool.releaseDBSystemTempTable(tmpOrgTable, conn);
                            }
                            catch (Exception var33_40) {
                                // empty catch block
                            }
                        }
                        if (tmpFormulaTable != null) {
                            try {
                                pool.releaseDBSystemTempTable(tmpFormulaTable, conn);
                            }
                            catch (Exception var33_41) {
                                // empty catch block
                            }
                        }
                        SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                        throw var32_39;
                    }
                }
                try {
                    pool.releaseDBSystemTempTable(tmpOrgTable, conn);
                }
                catch (Exception id) {
                    // empty catch block
                }
            }
            if (tmpFormulaTable != null) {
                try {
                    pool.releaseDBSystemTempTable(tmpFormulaTable, conn);
                }
                catch (Exception id) {
                    // empty catch block
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            return ite;
lbl-1000:
            // 1 sources

            {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("intID", intIds, CompareType.INCLUDE));
lbl178:
                // 2 sources

                col = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(evi);
                orgMap = BgCommHelper.transeToMap((IObjectCollection)col, (String[])new String[]{"intID"});
                backup = result;
                result = new HashMap<K, V>();
                var30_36 = backup.keySet().iterator();
                while (var30_36.hasNext()) {
                    orgId = intId = (String)var30_36.next();
                    if (orgMap.get(intId) != null) {
                        orgId = ((BgOrgUnitInfo)orgMap.get(intId)).getOrgUnitID();
                    }
                    if (result.containsKey(orgId)) {
                        ((Set)result.get(orgId)).addAll((Collection)backup.get(intId));
                        continue;
                    }
                    result.put(orgId, (Set<String>)backup.get(intId));
                }
            }
        }
        if (tmpOrgTable != null) {
            try {
                pool.releaseDBSystemTempTable(tmpOrgTable, conn);
            }
            catch (Exception bgDataTableName) {
                // empty catch block
            }
        }
        if (tmpFormulaTable != null) {
            try {
                pool.releaseDBSystemTempTable(tmpFormulaTable, conn);
            }
            catch (Exception bgDataTableName) {
                // empty catch block
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return result;
    }

    protected Map<String, Set<String>> getChildrenOrgIdsMap(Context ctx, Connection conn, String bgSchemeId, Set<String> formulasOrgIds) throws EASBizException, BOSException {
        HashMap<String, Set<String>> childrenOrgIdsMap = new HashMap<String, Set<String>>();
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
        String bgOrgViewId = schemeHelper.getBgOrgViewId();
        String orgUnitId2 = null;
        BgOrgUnitInfo bgOrgUnit = null;
        for (String orgUnitId2 : formulasOrgIds) {
            bgOrgUnit = MbgDataHelper.getBgOrgUnitInfo(conn, ctx.getLocale(), BOSUuid.read((String)bgOrgViewId), BOSUuid.read((String)orgUnitId2), false);
            childrenOrgIdsMap.put(orgUnitId2, new HashSet());
            ((Set)childrenOrgIdsMap.get(orgUnitId2)).add(orgUnitId2);
            if (bgOrgUnit.isIsLeaf()) continue;
            ArrayList<BgOrgUnitInfo> cOrgUnits = new ArrayList<BgOrgUnitInfo>();
            BgOrgUnitCollection bgOrgUnitChildren = MbgDataHelper.getBgOrgUnitChildren(ctx, bgOrgUnit, bgOrgViewId);
            if (bgOrgUnitChildren == null || bgOrgUnitChildren.isEmpty()) continue;
            int in = bgOrgUnitChildren.size();
            for (int i = 0; i < in; ++i) {
                cOrgUnits.add(bgOrgUnitChildren.get(i));
            }
            List<String> cOrgUnitIds = MbgDataHelper.getBgOrgUnitIds(cOrgUnits);
            if (cOrgUnitIds == null || cOrgUnitIds.isEmpty()) continue;
            for (int x = 0; x < cOrgUnitIds.size(); ++x) {
                ((Set)childrenOrgIdsMap.get(orgUnitId2)).add(cOrgUnitIds.get(x));
            }
        }
        return childrenOrgIdsMap;
    }

    private BgAdjustPastDataInfo createData(Map formulaForItem, Map itemName, String temFormula) {
        String itemDisplayName;
        String itemNumber;
        BgAdjustPastDataInfo pastData = new BgAdjustPastDataInfo();
        pastData.setFormula(temFormula);
        if (formulaForItem.containsKey(temFormula)) {
            itemNumber = (String)formulaForItem.get(temFormula);
            itemDisplayName = itemName.containsKey(itemNumber) ? (String)itemName.get(itemNumber) : null;
        } else {
            itemNumber = null;
            itemDisplayName = null;
        }
        if (itemNumber != null && itemDisplayName != null) {
            if (itemNumber.split(",").length == 1) {
                pastData.setIndexName(itemDisplayName);
                pastData.setIndexNumber(itemNumber);
            } else {
                pastData.setIndexNumber(itemNumber.substring(0, itemNumber.indexOf(",", 0)));
                pastData.setDimNumber(itemNumber.substring(itemNumber.indexOf(",", 0) + 1, itemNumber.length()));
                pastData.setIndexName(itemDisplayName.substring(0, itemDisplayName.indexOf(",", 0)));
                String substring = itemDisplayName.substring(itemDisplayName.indexOf(",", 0) + 1, itemDisplayName.length());
                pastData.setDimName(substring);
            }
        }
        return pastData;
    }

    @Override
    protected boolean _modifyAjustReason(Context ctx, Map parameter) throws BOSException, EASBizException {
        if (parameter == null || parameter.isEmpty()) {
            return false;
        }
        String sql = "UPDATE T_MBG_BgTmpData SET FAdjustReason=? WHERE FID=?";
        Connection conn = null;
        PreparedStatement pmst = null;
        BgAdjustPastDataInfo dataInfo2 = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pmst = conn.prepareStatement(sql);
            int index = 0;
            int batch = 50;
            for (BgAdjustPastDataInfo dataInfo2 : parameter.keySet()) {
                pmst.setString(1, dataInfo2.getAdjustReason());
                pmst.setString(2, dataInfo2.getPastDataId());
                pmst.addBatch();
                if (++index % batch != 0) continue;
                pmst.executeBatch();
                index = 0;
            }
            if (index > 0) {
                pmst.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pmst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pmst, (Connection)conn);
        return true;
    }

    @Override
    protected boolean _isLeafOrgUnit(Context ctx, String orgUnitId, String bgSchemeId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgUnitId) || StringUtils.isEmpty((String)bgSchemeId)) {
            return false;
        }
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
        String bgOrgViewId = schemeHelper.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId();
        StringBuffer sql = new StringBuffer(" select FIsLeaf From t_mbg_bgOrgUnit where FOrgUnitId = ? and FViewId = ? and FIsVirtual = 0");
        int fIsLeaf = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, orgUnitId);
            pstmt.setString(2, bgOrgViewId);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                fIsLeaf = rst.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return fIsLeaf == 1;
    }

    protected Set getAddOrgDataPermission(Context ctx, String bgSchemeId, Object[] orgUnitInfos) throws BOSException, EASBizException {
        Set hasPermOrgIds = MbgPermissionFactory.getLocalInstance(ctx).getBgOrgUnitPermission(null, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), bgSchemeId);
        if (hasPermOrgIds != null && !hasPermOrgIds.isEmpty()) {
            HashSet<String> newOrgIds = new HashSet<String>();
            for (int i = 0; i < orgUnitInfos.length; ++i) {
                if (!hasPermOrgIds.contains(((OrgUnitInfo)orgUnitInfos[i]).getId().toString())) continue;
                newOrgIds.add(((OrgUnitInfo)orgUnitInfos[i]).getId().toString());
            }
            return newOrgIds;
        }
        return DimensionCommonHelper.getIds(orgUnitInfos);
    }

    private Set getHasPermission(Context ctx, Object[] orgUnitInfos, String addNewPermission) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)addNewPermission)) {
            return DimensionCommonHelper.getIds(orgUnitInfos);
        }
        IObjectPK[] orgPks = new IObjectPK[orgUnitInfos.length];
        for (int i = 0; i < orgUnitInfos.length; ++i) {
            orgPks[i] = new ObjectUuidPK(((OrgUnitInfo)orgUnitInfos[i]).getId());
        }
        return PermissionFactory.getLocalInstance((Context)ctx).checkBatchPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), orgPks, addNewPermission);
    }

    @Override
    protected Map _getMessage(Context ctx, String bgFormId, Set newMembers, String addNewPermissionNumber, boolean isOrgOnPageOrView, int curSheetIndex, boolean isRoll) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgFormId) || newMembers == null || newMembers.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("result", "addViewOrgSucess");
        BgFormInfo bgForm = MbgViewListFormServerHelper.getBgFormInfo(ctx, BOSUuid.read((String)bgFormId), false);
        MbgViewListManager curViewManager = (MbgViewListManager)DimensionCommonHelper.getBgFormView(ctx, bgForm);
        String bgSchemeId = bgForm.getBgScheme().getId().toString();
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
        String bgOrgViewId = schemeHelper.getBgOrgViewId();
        BgDimensionMember member22 = null;
        HashSet<String> orgUnitNumbers = new HashSet<String>();
        HashSet<String> bgOrgLongNums = new HashSet<String>();
        for (BgDimensionMember member22 : newMembers) {
            orgUnitNumbers.add(member22.getNumber());
            bgOrgLongNums.add(member22.getSortValue().toString());
        }
        EntityViewInfo view = BgAdjustHelper.getOrgView(bgOrgViewId, bgOrgLongNums);
        BgOrgUnitCollection bgOrgUnitColls = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(view);
        HashMap<String, BgOrgUnitInfo> virtualMap = new HashMap<String, BgOrgUnitInfo>();
        if (bgOrgUnitColls != null && !bgOrgUnitColls.isEmpty()) {
            for (int index = 0; index < bgOrgUnitColls.size(); ++index) {
                virtualMap.put(bgOrgUnitColls.get(index).getOrgUnitID(), bgOrgUnitColls.get(index));
            }
        }
        Map<Object, Object> bgForms = new HashMap();
        Map<Object, Object> prevForms = new HashMap();
        HashMap<String, BgFormInfo> successAddBgForms = new HashMap<String, BgFormInfo>();
        HashMap<String, FullOrgUnitInfo> noAskState = new HashMap<String, FullOrgUnitInfo>();
        HashMap<String, FullOrgUnitInfo> noExists = new HashMap<String, FullOrgUnitInfo>();
        HashMap<String, FullOrgUnitInfo> noPermission = new HashMap<String, FullOrgUnitInfo>();
        HashMap noOrgDataPermission = new HashMap();
        HashMap noCanRoll = new HashMap();
        HashMap<String, FullOrgUnitInfo> noCode = new HashMap<String, FullOrgUnitInfo>();
        HashMap limitForm = new HashMap();
        HashMap<String, FullOrgUnitInfo> existsRolledForm = new HashMap<String, FullOrgUnitInfo>();
        BgCodeNumberHelper codehelper = new BgCodeNumberHelper(ctx, null, "sourceType");
        Connection conn = null;
        Statement pstmt = null;
        ResultSet res = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            conn = this.getConnection(ctx);
            bgForms = BgAdjustHelper.getBgFormMap(ctx, conn, bgForm, true, bgOrgViewId, false, isRoll);
            Map<String, Set<String>> hasRollFormKeys = BgFormHelper.getHasRollFormKey(conn, pool, bgForm, bgOrgUnitColls.toArray(), new Object[]{bgForm.getBgTemplate()}, new Object[]{bgForm.getBgVersion()}, new Object[]{bgForm.getCurrency()}, bgForm.getProcessType().getValue(), false);
            if (isRoll) {
                BgRollRuleInfo rollInfo = BgFormFactory.getLocalInstance(ctx).getBgFormInfo("select id, bgRollRule.* where id = '" + bgForm.getId().toString() + "'").getBgRollRule();
                bgForm.setBgRollRule(rollInfo);
                BgFormInfo prevInfo = bgForm.deepclone();
                String prevPeriod = BgNPeriodHelper.getOffsetBgPeriodNumber((String)prevInfo.getBgPeriod().getNumber(), (int)(0 - prevInfo.getBgRollRule().getLength()));
                BgPeriodInfo bgPeriodInfo = null;
                try {
                    bgPeriodInfo = BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodInfo("where number = '" + prevPeriod + "'");
                }
                catch (Exception e) {
                    logger.info((Object)e.getMessage());
                }
                if (bgPeriodInfo != null) {
                    prevInfo.setBgPeriod(bgPeriodInfo);
                    prevForms = BgAdjustHelper.getBgFormMap(ctx, conn, prevInfo, true);
                }
            }
            Map<String, OrgUnitInfo> orgMap = BgAdjustHelper.getOrgMap(ctx, orgUnitNumbers);
            Set hasPermOrgIds = this.getHasPermission(ctx, orgMap.values().toArray(), addNewPermissionNumber);
            Set hasOrgDataPermIds = this.getAddOrgDataPermission(ctx, bgSchemeId, orgMap.values().toArray());
            String orgUnitId = null;
            HashMap<String, OrgUnitInfo> noTemplate = null;
            HashMap<String, BgOrgUnitInfo> virtualOrgs = new HashMap<String, BgOrgUnitInfo>();
            HashMap<String, BgFormInfo> addNewPrevs = new HashMap<String, BgFormInfo>();
            HashMap successBgFormCheckLayout = new HashMap();
            HashMap<String, OrgUnitInfo> layoutDiff = new HashMap<String, OrgUnitInfo>();
            for (BgFormInfo bgFormInfo : bgForms.values()) {
                orgUnitId = bgFormInfo.getOrgUnit().getId().toString();
                if (!orgUnitNumbers.contains(bgFormInfo.getOrgUnit().getNumber())) continue;
                if (bgFormInfo.getId() != null) {
                    if (!orgUnitNumbers.contains(bgFormInfo.getOrgUnit().getNumber())) continue;
                    if ((bgFormInfo.isIsRolled() || bgForm.isIsRolled()) && !orgUnitId.equals(bgForm.getOrgUnit().getId().toString()) && !this.checkDimensionLayout(ctx, curSheetIndex, curViewManager, orgMap, bgFormInfo.getId().toString(), layoutDiff)) {
                        layoutDiff.put(bgFormInfo.getOrgUnit().getNumber(), (OrgUnitInfo)bgFormInfo.getOrgUnit());
                        orgMap.remove(orgUnitId);
                        continue;
                    }
                    if (!isRoll && (BgFormStateEnum.Approved.equals((Object)bgFormInfo.getState()) || BgFormStateEnum.Adjusted.equals((Object)bgFormInfo.getState()) || BgFormStateEnum.AdjustApproving.equals((Object)bgFormInfo.getState())) || isRoll && (BgFormStateEnum.Approved.equals((Object)bgFormInfo.getState()) || BgFormStateEnum.UnionReport.equals((Object)bgFormInfo.getState()) || BgFormStateEnum.UnionReceive.equals((Object)bgFormInfo.getState()) || BgFormStateEnum.RollEdited.equals((Object)bgFormInfo.getState()) || BgFormStateEnum.RollApproving.equals((Object)bgFormInfo.getState()))) {
                        successAddBgForms.put(bgFormInfo.getOrgUnit().getNumber(), bgFormInfo);
                    } else if (orgMap.containsKey(orgUnitId) && !BgFormStateEnum.History.equals((Object)bgFormInfo.getState())) {
                        noAskState.put(bgFormInfo.getOrgUnit().getNumber(), bgFormInfo.getOrgUnit());
                    } else {
                        String rollKey = BgFormHelper.getRollKey4Process(bgFormInfo.getOrgUnit().getId(), bgFormInfo.getBgTemplate().getId(), bgForm.getBgVersion().getId(), bgForm.getCurrency().getId(), bgForm.getProcessType().getValue());
                        if (hasRollFormKeys.containsKey(rollKey)) {
                            Set<String> rollPeriodNums = hasRollFormKeys.get(rollKey);
                            for (String string : rollPeriodNums) {
                                if (string.compareTo(bgForm.getBgPeriod().getNumber()) <= 0) continue;
                                existsRolledForm.put(bgFormInfo.getOrgUnit().getNumber(), bgFormInfo.getOrgUnit());
                                break;
                            }
                        }
                    }
                    orgMap.remove(orgUnitId);
                    continue;
                }
                if (!hasPermOrgIds.contains(orgUnitId)) {
                    noPermission.put(bgFormInfo.getOrgUnit().getNumber(), bgFormInfo.getOrgUnit());
                    orgMap.remove(orgUnitId);
                    continue;
                }
                if (!orgMap.containsKey(orgUnitId)) continue;
                if (!virtualMap.isEmpty() && virtualMap.containsKey(orgUnitId) && Boolean.TRUE.booleanValue() == ((BgOrgUnitInfo)virtualMap.get(orgUnitId)).isIsVirtual()) {
                    virtualOrgs.put(((BgOrgUnitInfo)virtualMap.get(orgUnitId)).getNumber(), (BgOrgUnitInfo)virtualMap.get(orgUnitId));
                }
                if (isRoll) {
                    String rollKey;
                    BgFormInfo prevInfo = (BgFormInfo)prevForms.get(orgUnitId);
                    if (prevInfo == null || prevInfo.getId() == null || !BgFormStateEnum.Approved.equals((Object)prevInfo.getState()) && !BgFormStateEnum.UnionReport.equals((Object)prevInfo.getState()) && !BgFormStateEnum.UnionReceive.equals((Object)prevInfo.getState())) {
                        noExists.put(bgFormInfo.getOrgUnit().getNumber(), bgFormInfo.getOrgUnit());
                        orgMap.remove(orgUnitId);
                        continue;
                    }
                    codehelper.init((IObjectValue)prevInfo, orgUnitId);
                    if (!codehelper.isHasCodeNumber()) {
                        noCode.put(bgFormInfo.getOrgUnit().getNumber(), bgFormInfo.getOrgUnit());
                        orgMap.remove(orgUnitId);
                    } else {
                        addNewPrevs.put(prevInfo.getId().toString(), prevInfo);
                    }
                    if (!hasRollFormKeys.containsKey(rollKey = BgFormHelper.getRollKey4Process(bgFormInfo.getOrgUnit().getId(), bgFormInfo.getBgTemplate().getId(), bgForm.getBgVersion().getId(), bgForm.getCurrency().getId(), bgForm.getProcessType().getValue()))) continue;
                    Set<String> rollPeriodNums = hasRollFormKeys.get(rollKey);
                    for (String rollPeriodNumber2 : rollPeriodNums) {
                        if (rollPeriodNumber2.compareTo(bgForm.getBgPeriod().getNumber()) <= 0) continue;
                        existsRolledForm.put(bgFormInfo.getOrgUnit().getNumber(), bgFormInfo.getOrgUnit());
                        orgMap.remove(orgUnitId);
                        if (prevInfo == null || prevInfo.getId() == null || !addNewPrevs.containsKey(prevInfo.getId().toString())) continue;
                        addNewPrevs.remove(prevInfo.getId().toString());
                    }
                    continue;
                }
                noExists.put(bgFormInfo.getOrgUnit().getNumber(), bgFormInfo.getOrgUnit());
                orgMap.remove(orgUnitId);
            }
            ArrayList<String> addNewFormIds = new ArrayList<String>();
            ArrayList deleteFormIds = new ArrayList();
            if (!addNewPrevs.isEmpty()) {
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add("bgForm.id");
                evi.getSelector().add("bgForm.orgUnit.id");
                evi.getSelector().add("bgForm.orgUnit.number");
                evi.getSelector().add("dimensionData");
                evi.getSelector().add("bgForm.isRolled");
                evi.getSelector().add("bgForm.state");
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("bgForm.id", new HashSet(addNewPrevs.keySet()), CompareType.INCLUDE));
                CoreBaseCollection col = BgFormEntryFactory.getLocalInstance(ctx).getCollection(evi);
                MbgViewListXMLParser mbgViewListXMLParser = new MbgViewListXMLParser(ctx);
                Iterator it = col.iterator();
                while (it.hasNext()) {
                    BgFormEntryInfo entryInfo = (BgFormEntryInfo)it.next();
                    MbgViewListManager viewManager = mbgViewListXMLParser.parse(entryInfo.getDimensionData());
                    if (DimensionCommonHelper.isDifference(curViewManager, viewManager, -1)) {
                        layoutDiff.put(entryInfo.getBgForm().getOrgUnit().getNumber(), orgMap.remove(entryInfo.getBgForm().getOrgUnit().getId().toString()));
                        it.remove();
                        continue;
                    }
                    if ((entryInfo.getBgForm().isIsRolled() || entryInfo.getBgForm().getState().getValue() == 6) && DimensionCommonHelper.isDifferenceNotOrder(curViewManager, viewManager, curSheetIndex)) {
                        layoutDiff.put(entryInfo.getBgForm().getOrgUnit().getNumber(), orgMap.remove(entryInfo.getBgForm().getOrgUnit().getId().toString()));
                        it.remove();
                        continue;
                    }
                    addNewFormIds.add(entryInfo.getBgForm().getId().toString());
                }
                Object rollResult = BgDecomposeFacadeFactory.getLocalInstance(ctx).addNewRoll(addNewFormIds);
                if (rollResult instanceof BgFormInfo) {
                    BgFormInfo info = (BgFormInfo)rollResult;
                    successAddBgForms.put(info.getOrgUnit().getNumber(), info);
                    orgMap.remove(info.getOrgUnit().getId().toString());
                } else {
                    BgFormInfo info;
                    bgForms = BgAdjustHelper.getBgFormMap(ctx, conn, bgForm, false, bgOrgViewId, true, isRoll);
                    HashMap<String, BgFormInfo> idMap = new HashMap<String, BgFormInfo>();
                    for (Object e : bgForms.values()) {
                        info = (BgFormInfo)e;
                        idMap.put(info.getOrgUnit().getId().toString(), info);
                    }
                    for (BgFormEntryInfo bgFormEntryInfo : col) {
                        info = (BgFormInfo)idMap.get(bgFormEntryInfo.getBgForm().getOrgUnit().getId().toString());
                        orgMap.remove(info.getOrgUnit().getId().toString());
                        if (info != null && info.getId() != null && BgFormStateEnum.RollEdited.equals((Object)info.getState())) {
                            successAddBgForms.put(info.getOrgUnit().getNumber(), info);
                            continue;
                        }
                        layoutDiff.put(info.getOrgUnit().getNumber(), (OrgUnitInfo)info.getOrgUnit());
                    }
                }
            }
            if (!orgMap.isEmpty()) {
                noTemplate = new HashMap<String, OrgUnitInfo>();
                for (OrgUnitInfo org : orgMap.values()) {
                    noTemplate.put(org.getNumber(), org);
                }
                result.put("addViewOrgNoTemplate", noTemplate);
            }
            if (!virtualOrgs.isEmpty()) {
                result.put("addViewOrgIsVirtual", virtualOrgs);
            }
            if (!noPermission.isEmpty()) {
                result.put("addViewOrgNoPermission", noPermission);
            }
            if (!noOrgDataPermission.isEmpty()) {
                result.put("addOrgNoDataPermission", noOrgDataPermission);
            }
            BgAdjustHelper.dealViewManagerMap(ctx, isOrgOnPageOrView, curSheetIndex, result, curViewManager, bgOrgViewId, successAddBgForms, layoutDiff);
            if (!layoutDiff.isEmpty()) {
                result.put("addViewOrgLayoutDiff", layoutDiff);
            }
            if (!noExists.isEmpty()) {
                result.put("noExists", noExists);
            }
            if (!noAskState.isEmpty()) {
                result.put("noAskState", noAskState);
            }
            if (!noCode.isEmpty()) {
                result.put("noCode", noCode);
            }
            if (!existsRolledForm.isEmpty()) {
                result.put("existsRolledForm", existsRolledForm);
            }
            if (!limitForm.isEmpty()) {
                result.put("limitForm", limitForm);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(res, pstmt, (Connection)conn);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Set _getFormId(Context ctx, Set formIdSet) throws BOSException, EASBizException {
        HashSet<String> dealformIdSet;
        ResultSet rs;
        PreparedStatement pmst;
        Connection conn;
        block7: {
            conn = null;
            pmst = null;
            rs = null;
            TempTablePool pool = null;
            StringBuilder sql = null;
            String tmpTableName = null;
            dealformIdSet = null;
            try {
                conn = this.getConnection(ctx);
                pool = TempTablePool.getInstance((Context)ctx);
                tmpTableName = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FFORMID VARCHAR(44))");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTableName + " (FFORMID) values (?)"), (Collection)formIdSet);
                sql = new StringBuilder();
                sql.append("select b.fid from t_mbg_bgform b," + tmpTableName + " tmp where tmp.FFORMID = b.fadjustid and b.fstate <> " + 15 + " and b.fid = b.fadjustid ");
                pmst = conn.prepareStatement(sql.toString());
                rs = pmst.executeQuery();
                while (rs.next()) {
                    if (StringUtils.isEmpty((String)rs.getString("fid"))) continue;
                    if (dealformIdSet == null) {
                        dealformIdSet = new HashSet<String>();
                    }
                    dealformIdSet.add(rs.getString("fid"));
                }
                if (tmpTableName == null) break block7;
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tmpTableName != null) {
                        BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpTableName);
                    }
                    SQLUtils.cleanup(rs, pmst, (Connection)conn);
                    throw throwable;
                }
            }
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTableName);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
        return dealformIdSet;
    }

    @Override
    protected Set _getFormByOrgIdSet(Context ctx, String bgFormId, Set orgIdSet) throws BOSException, EASBizException {
        BgFormInfo info = BgFormFactory.getLocalInstance(ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId), BgNFSHelper.getSelectors());
        return new HashSet<String>(BgAdjustHelper.getOrgFormIdMap(this.getConnection(ctx), ctx, info, orgIdSet).values());
    }

    @Override
    protected void _checkTmpdate(Context ctx, IObjectValue model, Map adjustMap) throws BOSException, EASBizException {
        if (model == null || adjustMap == null || adjustMap.isEmpty()) {
            return;
        }
        if (((BgFormInfo)model).getAdjust() == null || ((BgFormInfo)model).getAdjust().getId() == null) {
            return;
        }
        Set formIdSet = this._getFormByOrgIdSet(ctx, ((BgFormInfo)model).getAdjust().getId().toString(), adjustMap.keySet());
        MbgTmpDataUtils.checkTmpData(ctx, (BgFormInfo)model, adjustMap, formIdSet);
    }

    @Override
    protected Map _getOrgIdFormIdMap(Context ctx, String bgFormId, Set orgIdSet) throws BOSException, EASBizException {
        return BgAdjustHelper.getOrgFormStateMap(this.getConnection(ctx), ctx, bgFormId, orgIdSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _getMessage(Context ctx, String bgFormId, Set newMembers, String addNewPermissionNumber) throws BOSException, EASBizException {
        ResultSet res;
        Statement pstmt;
        Connection conn;
        LinkedHashMap<String, Object> result;
        block18: {
            if (StringUtils.isEmpty((String)bgFormId)) return null;
            if (newMembers == null) return null;
            if (newMembers.isEmpty()) {
                return null;
            }
            result = new LinkedHashMap<String, Object>();
            result.put("result", "addViewOrgSucess");
            BgFormInfo bgForm = MbgViewListFormServerHelper.getBgFormInfo(ctx, BOSUuid.read((String)bgFormId), false);
            String bgSchemeId = bgForm.getBgScheme().getId().toString();
            BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
            String bgOrgViewId = schemeHelper.getBgOrgViewId();
            BgDimensionMember member2 = null;
            HashSet<String> orgUnitNumbers = new HashSet<String>();
            HashSet<String> bgOrgLongNums = new HashSet<String>();
            for (BgDimensionMember member2 : newMembers) {
                orgUnitNumbers.add(member2.getNumber());
                bgOrgLongNums.add(member2.getSortValue().toString());
            }
            EntityViewInfo view = BgAdjustHelper.getOrgView(bgOrgViewId, bgOrgLongNums);
            BgOrgUnitCollection bgOrgUnitColls = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(view);
            HashMap<String, BgOrgUnitInfo> virtualMap = new HashMap<String, BgOrgUnitInfo>();
            if (bgOrgUnitColls != null && !bgOrgUnitColls.isEmpty()) {
                for (int index = 0; index < bgOrgUnitColls.size(); ++index) {
                    virtualMap.put(bgOrgUnitColls.get(index).getOrgUnitID(), bgOrgUnitColls.get(index));
                }
            }
            Map<Object, Object> bgForms = new HashMap();
            HashMap<String, BgFormInfo> successAddBgForms = new HashMap<String, BgFormInfo>();
            HashMap<String, FullOrgUnitInfo> noAskState = new HashMap<String, FullOrgUnitInfo>();
            HashMap<String, FullOrgUnitInfo> noExists = new HashMap<String, FullOrgUnitInfo>();
            conn = null;
            pstmt = null;
            res = null;
            TempTablePool pool = null;
            String tmpTable = null;
            Object prmt = null;
            try {
                pool = TempTablePool.getInstance((Context)ctx);
                conn = this.getConnection(ctx);
                bgForms = BgAdjustHelper.getBgFormMap(ctx, conn, bgForm, true);
                Map<String, OrgUnitInfo> orgMap = BgAdjustHelper.getOrgMap(ctx, orgUnitNumbers);
                String orgUnitId = null;
                HashMap<String, OrgUnitInfo> noTemplate = null;
                HashMap<String, BgOrgUnitInfo> virtualOrgs = new HashMap<String, BgOrgUnitInfo>();
                for (BgFormInfo bgFormInfo : bgForms.values()) {
                    orgUnitId = bgFormInfo.getOrgUnit().getId().toString();
                    if (bgFormInfo.getId() != null) {
                        if (!orgUnitNumbers.contains(bgFormInfo.getOrgUnit().getNumber())) continue;
                        if (BgFormStateEnum.Approved.equals((Object)bgFormInfo.getState()) || BgFormStateEnum.Adjusted.equals((Object)bgFormInfo.getState()) || BgFormStateEnum.AdjustApproving.equals((Object)bgFormInfo.getState())) {
                            successAddBgForms.put(bgFormInfo.getOrgUnit().getNumber(), bgFormInfo);
                        } else if (orgMap.containsKey(orgUnitId) && !BgFormStateEnum.History.equals((Object)bgFormInfo.getState())) {
                            noAskState.put(bgFormInfo.getOrgUnit().getNumber(), bgFormInfo.getOrgUnit());
                        }
                        orgMap.remove(orgUnitId);
                        continue;
                    }
                    if (!orgMap.containsKey(orgUnitId)) continue;
                    if (!virtualMap.isEmpty() && virtualMap.containsKey(orgUnitId) && Boolean.TRUE.booleanValue() == ((BgOrgUnitInfo)virtualMap.get(orgUnitId)).isIsVirtual()) {
                        virtualOrgs.put(((BgOrgUnitInfo)virtualMap.get(orgUnitId)).getNumber(), (BgOrgUnitInfo)virtualMap.get(orgUnitId));
                    }
                    noExists.put(bgFormInfo.getOrgUnit().getNumber(), bgFormInfo.getOrgUnit());
                    orgMap.remove(orgUnitId);
                }
                if (!orgMap.isEmpty()) {
                    noTemplate = new HashMap<String, OrgUnitInfo>();
                    for (OrgUnitInfo org : orgMap.values()) {
                        noTemplate.put(org.getNumber(), org);
                    }
                    result.put("addViewOrgNoTemplate", noTemplate);
                }
                tmpTable = this.dealMembers(ctx, result, bgOrgViewId, successAddBgForms, conn, pool);
                if (!virtualOrgs.isEmpty()) {
                    result.put("addViewOrgIsVirtual", virtualOrgs);
                }
                if (!noExists.isEmpty()) {
                    result.put("noExists", noExists);
                }
                if (!noAskState.isEmpty()) {
                    result.put("noAskState", noAskState);
                }
                if (tmpTable == null) break block18;
            }
            catch (Throwable throwable) {
                if (tmpTable != null) {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpTable);
                }
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                throw throwable;
            }
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTable);
        }
        SQLUtils.cleanup(res, pstmt, (Connection)conn);
        return result;
    }

    private String dealMembers(Context ctx, Map result, String bgOrgViewId, Map<String, BgFormInfo> successAddBgForms, Connection conn, TempTablePool pool) throws BOSException, EASBizException {
        String tmpTable;
        PreparedStatement prmt = null;
        ResultSet rs = null;
        Set<String> sucessOrgNumSet = successAddBgForms.keySet();
        String l = ctx.getLocale().getDisplayName();
        StringBuffer sql = new StringBuffer();
        try {
            tmpTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FNumber) values (?)"), sucessOrgNumSet);
            prmt = this.dealPrmtOrg(conn, l, sql, tmpTable);
            prmt.setString(1, bgOrgViewId);
            rs = prmt.executeQuery();
            ArrayList<BgDimensionMember> successFromViews = new ArrayList<BgDimensionMember>();
            String longNumber = null;
            String longName = null;
            BgDimensionMember bgDimensionMember = null;
            while (rs.next()) {
                String id = rs.getString("id");
                String name = rs.getString("name");
                String number = rs.getString("number");
                longNumber = rs.getString("longNumber");
                longName = rs.getString("displayName");
                bgDimensionMember = new BgDimensionMember(DimensionConstants.DEF_ORGUNIT_NUMBER, id, name, number);
                bgDimensionMember.setSortValue((Comparable)((Object)longNumber));
                bgDimensionMember.setLongName(longName);
                successFromViews.add(bgDimensionMember);
            }
            result.put(MbgViewListDescriptionHelper.successFromViews, successFromViews);
        }
        catch (SQLException e) {
            try {
                throw new BOSException("", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, prmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)prmt);
        return tmpTable;
    }

    private PreparedStatement dealPrmtOrg(Connection conn, String l, StringBuffer sql, String tmpBillIdTable) throws SQLException {
        sql.append("SELECT");
        sql.append(" org.FOrgUnitID id,");
        sql.append(" org.FNumber number,");
        sql.append(" org.FName_" + l + " name,");
        sql.append(" org.FLongNumber longNumber, ");
        sql.append(" org.FDisplayName_" + l + " displayName ");
        sql.append(" FROM T_MBG_BgOrgUnit org," + tmpBillIdTable + " tmp ");
        sql.append(" WHERE tmp.FNumber = org.FNumber and org.FIsOUSealUp = 0 and org.FViewID = ?");
        PreparedStatement pmst = conn.prepareStatement(sql.toString());
        return pmst;
    }

    @Override
    protected void _checkTmpDataForView(Context ctx, IObjectValue model, Map adjustMap) throws BOSException, EASBizException {
        if (model == null || adjustMap == null || adjustMap.isEmpty()) {
            return;
        }
        BgFormInfo bgFormInfo = (BgFormInfo)model;
        String formId = bgFormInfo.getId().toString();
        HashSet<String> formIdSet = new HashSet<String>();
        formIdSet.add(formId);
        Map<String, String> orgFormIdMap = BgAdjustHelper.getOrgFormIdMap(this.getConnection(ctx), ctx, bgFormInfo, adjustMap.keySet());
        if (orgFormIdMap == null || orgFormIdMap.isEmpty()) {
            return;
        }
        formIdSet = new HashSet<String>(orgFormIdMap.values());
        MbgTmpDataUtils.checkTmpData(ctx, bgFormInfo, adjustMap, formIdSet);
    }

    private void dealGroupMapNullBudget(BgControlParam controlParam, Map<String, Map<String, Object>> adjustMap, String orgUnitId) throws BOSException {
        BgControlParam temp;
        HashMap dimNumbersToPeriods = new HashMap();
        try {
            temp = controlParam.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException("", (Throwable)e);
        }
        BgControlSettingInfo setting = null;
        List listGroupData2 = null;
        ArrayList<String> bgItemDimNumber = new ArrayList<String>();
        BgGroupData sourgroupData2 = null;
        BgGroupData bgGroupData = null;
        Map addData = controlParam.getBudgetDetail();
        String formulaStr = null;
        String scenarioNum = controlParam.getBgScenario().getNumber();
        String maxPeriodNumber = controlParam.getBgPeriodNumber();
        Object av = null;
        for (List listGroupData2 : controlParam.getBgGroupMap().values()) {
            for (BgGroupData sourgroupData2 : listGroupData2) {
                setting = sourgroupData2.getSetting();
                maxPeriodNumber = sourgroupData2.getBgPeriodNumber().compareTo(maxPeriodNumber) > 0 ? sourgroupData2.getBgPeriodNumber() : maxPeriodNumber;
                bgItemDimNumber.add(sourgroupData2.getBgDimNumber());
                if (!dimNumbersToPeriods.containsKey(sourgroupData2.getBgDimNumber())) {
                    dimNumbersToPeriods.put(sourgroupData2.getBgDimNumber(), new HashSet());
                }
                ((Set)dimNumbersToPeriods.get(sourgroupData2.getBgDimNumber())).add(sourgroupData2.getBgPeriodNumber());
            }
        }
        bgItemDimNumber.add(controlParam.getDimItemNumber());
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : controlParam.getBudgetDetail().entrySet()) {
            String string = maxPeriodNumber = ((BgGroupData)entry2.getValue()).getBgPeriodNumber().compareTo(maxPeriodNumber) > 0 ? ((BgGroupData)entry2.getValue()).getBgPeriodNumber() : maxPeriodNumber;
            if (setting == null) {
                setting = ((BgGroupData)entry2.getValue()).getSetting();
            }
            if (!dimNumbersToPeriods.containsKey(((BgGroupData)entry2.getValue()).getBgDimNumber())) {
                dimNumbersToPeriods.put(((BgGroupData)entry2.getValue()).getBgDimNumber(), new HashSet());
            }
            ((Set)dimNumbersToPeriods.get(((BgGroupData)entry2.getValue()).getBgDimNumber())).add(((BgGroupData)entry2.getValue()).getBgPeriodNumber());
        }
        List refBgPeriods = null;
        if (controlParam.getControlSetting().getCtrlType().getValue() == 10) {
            refBgPeriods = new ArrayList<String>();
            refBgPeriods.add(controlParam.getBgPeriodNumber());
        } else if (controlParam.getControlSetting().getCtrlType().getValue() == 11) {
            refBgPeriods = controlParam.getBgPeriodNums(controlParam.getControlSetting().getCtrlType().getValue(), true, null);
            if (refBgPeriods == null) {
                return;
            }
            if (controlParam.getControlSetting().getCtrlType() == BgCtrlTypeEnum.AddUpCtrl) {
                ArrayList<String> detailPeriods = new ArrayList<String>();
                for (String key : refBgPeriods) {
                    if (key.compareTo(maxPeriodNumber) > 0) continue;
                    detailPeriods.add(key);
                }
                refBgPeriods.retainAll(detailPeriods);
            }
        } else {
            refBgPeriods = controlParam.getBgPeriodNums(controlParam.getControlSetting().getCtrlType().getValue(), true, null);
        }
        if (refBgPeriods == null) {
            return;
        }
        for (String periodNumber : refBgPeriods) {
            for (String dimItemNumber : bgItemDimNumber) {
                temp.setBgPeriodNumber(periodNumber);
                formulaStr = BgNFSHelper.getFormulaFromParam(this.createFormulaKey(temp, dimItemNumber));
                if (dimNumbersToPeriods.get(dimItemNumber) != null && ((Set)dimNumbersToPeriods.get(dimItemNumber)).contains(periodNumber) || !adjustMap.containsKey(orgUnitId) || !adjustMap.get(orgUnitId).containsKey(formulaStr)) continue;
                Object obj = adjustMap.get(orgUnitId).get(formulaStr);
                bgGroupData = this.generalBgGroupData(obj, dimItemNumber, periodNumber, setting, scenarioNum);
                if (dimItemNumber.equals(controlParam.getDimItemNumber())) {
                    addData.put(BgGroupData.getKey((String)dimItemNumber, (String)periodNumber), bgGroupData);
                    continue;
                }
                if (listGroupData2 == null) continue;
                listGroupData2.add(bgGroupData);
            }
        }
    }

    private List<String> getAddUpCtrlRefBgPeriods(BgControlParam controlParam) {
        List refBgPeriods = controlParam.getBgPeriodNums(controlParam.getControlSetting().getCtrlType().getValue(), true, null);
        if (refBgPeriods == null) {
            return null;
        }
        if (controlParam.getControlSetting().getCtrlType() == BgCtrlTypeEnum.AddUpCtrl) {
            ArrayList<String> detailPeriods = new ArrayList<String>();
            for (String key : refBgPeriods) {
                if (key.compareTo(controlParam.getBgPeriodNumber()) > 0) continue;
                detailPeriods.add(key);
            }
            refBgPeriods.retainAll(detailPeriods);
        }
        return refBgPeriods;
    }

    private BgGroupData generalBgGroupData(Object obj, String BgDimNubmer, String periodNumber, BgControlSettingInfo setting, String scenarioNum) {
        BigDecimal av = null;
        BgGroupData bgGroupData = null;
        if (obj instanceof BigDecimal) {
            av = (BigDecimal)obj;
        } else if (obj instanceof BgAdjustFormDiversityData) {
            BgAdjustFormDiversityData d = (BgAdjustFormDiversityData)obj;
            av = d.getOldValue() == null ? d.getNewValue() : (d.getNewValue() == null ? BgNConstants.ZERO.subtract(d.getOldValue()) : d.getNewValue().subtract(d.getOldValue()));
        }
        bgGroupData = new BgGroupData();
        bgGroupData.setBgDimNumber(BgDimNubmer);
        bgGroupData.setBgPeriodNumber(periodNumber);
        bgGroupData.setBudgetValue(av);
        bgGroupData.setSetting(setting);
        bgGroupData.setScenarioNum(scenarioNum);
        return bgGroupData;
    }

    private IObjectPK writerLogin(Context ctx, BgFormInfo bgFormInfo, String logItemName) throws EASBizException, BOSException {
        String logObjectDetial = bgFormInfo.getNumber() + " " + bgFormInfo.getName();
        return LogUtil.beginLog((Context)ctx, (String)"writerLogin", (BOSObjectType)this.getBOSType(), null, (String)logObjectDetial, (String)logItemName);
    }

    private IObjectPK writerLogin(Context ctx, String id, String logItemName) throws EASBizException, BOSException {
        BgFormInfo bgFormInfo = BgFormFactory.getLocalInstance(ctx).getBgFormInfo("select number, name where id = '" + id + "'");
        String logName = bgFormInfo.getNumber() + " " + bgFormInfo.getName();
        return LogUtil.beginLog((Context)ctx, (String)"writerLogin", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)logItemName);
    }

    private void deleRollDataRef(Connection conn, String cubeEntryName, List<String> ids) throws SQLException {
        MbgSqlHelper.executeBatch((Connection)conn, (String)("delete from " + cubeEntryName + " where fformId = ?"), ids);
    }

    private boolean checkDimensionLayout(Context ctx, int curSheetIndex, MbgViewListManager curViewManager, Map<String, OrgUnitInfo> orgMap, String formId, Map<String, OrgUnitInfo> layoutDiff) throws BOSException, Exception {
        boolean layout = true;
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("bgForm.id");
        evi.getSelector().add("bgForm.orgUnit.id");
        evi.getSelector().add("bgForm.orgUnit.number");
        evi.getSelector().add("dimensionData");
        evi.getSelector().add("bgForm.isRolled");
        evi.getSelector().add("bgForm.state");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgForm.id", (Object)formId, CompareType.EQUALS));
        CoreBaseCollection col = BgFormEntryFactory.getLocalInstance(ctx).getCollection(evi);
        MbgViewListXMLParser parser2 = new MbgViewListXMLParser(ctx);
        Iterator it = col.iterator();
        while (it.hasNext()) {
            BgFormEntryInfo entryInfo = (BgFormEntryInfo)it.next();
            MbgViewListManager viewManager = parser2.parse(entryInfo.getDimensionData());
            if (DimensionCommonHelper.isDifference(curViewManager, viewManager, -1)) {
                layoutDiff.put(entryInfo.getBgForm().getOrgUnit().getNumber(), orgMap.remove(entryInfo.getBgForm().getOrgUnit().getId().toString()));
                layout = false;
                it.remove();
                continue;
            }
            if (!entryInfo.getBgForm().isIsRolled() && entryInfo.getBgForm().getState().getValue() != 6 || !DimensionCommonHelper.isDifferenceNotOrder(curViewManager, viewManager, curSheetIndex)) continue;
            layoutDiff.put(entryInfo.getBgForm().getOrgUnit().getNumber(), orgMap.remove(entryInfo.getBgForm().getOrgUnit().getId().toString()));
            layout = false;
            it.remove();
        }
        return layout;
    }

    @Override
    public List _transitDataView(Context ctx, Set formulas, OrgUnitInfo orgUnitInfo, BgVersionInfo bgVersionInfo, BgSchemeDimensionHelper schemeHelper) throws BOSException, EASBizException {
        ArrayList<BgAdjustPastDataInfo> pastDataList = new ArrayList<BgAdjustPastDataInfo>();
        if (formulas.isEmpty() || orgUnitInfo == null || schemeHelper == null) {
            return pastDataList;
        }
        if (bgVersionInfo == null) {
            Map bgVersionCache = BgDimCacheUtils.getVersionCache((Context)ctx);
            bgVersionInfo = (BgVersionInfo)bgVersionCache.get("Ve");
        }
        TempTablePool pool = null;
        Connection conn = null;
        String tmpOrgTable = null;
        String tmpFormulaTable = null;
        PreparedStatement pmst = null;
        ResultSet rs = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            String bgSchemeId = schemeHelper.getBgSchemeId();
            BgControlTransitUtils utils = BgControlTransitUtils.newInstance((Context)ctx, (String)bgSchemeId);
            TreeMap allLeafMap = new TreeMap(new RefFieldComparator());
            HashSet<String> orgNumbers = new HashSet<String>();
            orgNumbers.add(orgUnitInfo.getNumber());
            Map leafOrgUnitIds = utils.getLeafOrgUnitIds(conn, orgNumbers, allLeafMap);
            HashMap existsMembers = new HashMap();
            utils.queryTransitValue(ctx, conn, schemeHelper, bgVersionInfo, leafOrgUnitIds, existsMembers);
            utils.queryLeafMap(ctx, schemeHelper, existsMembers, allLeafMap);
            HashSet<String> childFormulas = new HashSet<String>();
            HashMap<String, String> formulaForItems = new HashMap<String, String>();
            for (Object formula : formulas) {
                Set childPeriodNums;
                Map map;
                String[] params = BgNFSHelper.parseFormulaPara((String)formula);
                String scenarioNumber = params[3];
                if (utils.checkIsActScenario(ctx, scenarioNumber) || (map = (Map)allLeafMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD)) == null || (childPeriodNums = (Set)((Map)allLeafMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD)).get(params[1])) == null || childPeriodNums.isEmpty()) continue;
                Set leafBgItemCombins = BgControlTransitUtils.doJoinBgItemCombin((BgSchemeDimensionHelper)schemeHelper, allLeafMap, (String)params[0]);
                String element = params[2];
                String currency = params[5];
                for (String periodNumber : childPeriodNums) {
                    for (String BgItemCombin : leafBgItemCombins) {
                        String formulaFromParam = BgNFSHelper.getFormulaFromParam(BgItemCombin, periodNumber, element, currency, scenarioNumber);
                        childFormulas.add(formulaFromParam);
                        formulaForItems.put(formulaFromParam, BgItemCombin);
                    }
                }
            }
            pool = TempTablePool.getInstance((Context)ctx);
            tmpOrgTable = BgDBUtils.createTmpTable((TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpOrgTable + " (FID) values (?)"), leafOrgUnitIds.keySet());
            tmpFormulaTable = BgDBUtils.createTmpTable((TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_2 (FFormula NVarchar(300) NOT NULL)");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpFormulaTable + " (FFormula) values (?)"), childFormulas);
            StringBuilder sql = new StringBuilder();
            pmst = this.dealPrmtForTransit(conn, ctx.getLocale().getDisplayName(), sql, tmpOrgTable, tmpFormulaTable, bgSchemeId, bgVersionInfo.getVersionId(), 1);
            rs = pmst.executeQuery();
            Map itemName = DimensionFormulaFacadeFactory.getLocalInstance(ctx).getDimensionCombName(bgSchemeId, formulaForItems.values(), orgUnitInfo.getId().toString());
            HashMap<String, BgAdjustPastDataInfo> bgAdjustBill = new HashMap<String, BgAdjustPastDataInfo>();
            HashSet<String> bgFormIds = new HashSet<String>();
            HashMap<String, List<BgAdjustPastDataInfo>> tempPastDataMap = new HashMap<String, List<BgAdjustPastDataInfo>>();
            while (rs.next()) {
                String temFormula = rs.getString("formula");
                BgAdjustPastDataInfo pastData = this.createData(formulaForItems, itemName, temFormula);
                pastData.setPastDataId(rs.getString("dataId"));
                pastData.setBgFormId(rs.getString("formId"));
                pastData.setOrgName(rs.getString("orgName"));
                pastData.setBgElementName(rs.getString("elementname"));
                pastData.setPeriod(rs.getString("periodName"));
                pastData.setPastSource(1);
                BOSObjectType type = BOSUuid.read((String)pastData.getBgFormId()).getType();
                if (new BgAdjustBillInfo().getBOSType().equals((Object)type)) {
                    bgAdjustBill.put(pastData.getBgFormId(), pastData);
                    pastData.setPastSource(14);
                } else if (new BgFormInfo().getBOSType().equals((Object)type)) {
                    bgFormIds.add(pastData.getBgFormId());
                }
                pastData.setOldValue(rs.getBigDecimal("oldValue"));
                pastData.setAdjustValue(rs.getBigDecimal("newValue"));
                if (pastData.getOldValue().compareTo(pastData.getAdjustValue()) <= 0) continue;
                pastData.setAdjustorName(rs.getString("adjustor"));
                pastData.setAdjustTime(rs.getTimestamp("createTime"));
                pastData.setFormula(temFormula);
                pastData.setAdjustReason(rs.getString("adjustReason"));
                pastData.setBgItemComBin(rs.getString("itemComBinId"));
                pastData.setBgVersionNumber(rs.getString("bgVersionNumber"));
                pastData.setBgVersionName(rs.getString("bgVersionName"));
                pastData.setBgScenarioName(rs.getString("bgScenarioName"));
                pastData.setBgScenarioNumber(rs.getString("bgScenarioNumber"));
                pastData.setAdjusting(true);
                if (!tempPastDataMap.containsKey(pastData.getBgFormId())) {
                    ArrayList tempPastDatas = new ArrayList();
                    tempPastDataMap.put(pastData.getBgFormId(), tempPastDatas);
                }
                ((List)tempPastDataMap.get(pastData.getBgFormId())).add(pastData);
            }
            this.setSourceByBgForm(ctx, pastDataList, bgFormIds, tempPastDataMap);
            this.setSourceByBgAdjustBill(ctx, pastDataList, bgAdjustBill);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                BgDBUtils.releaseTmpTable(pool, tmpOrgTable);
                BgDBUtils.releaseTmpTable(pool, tmpFormulaTable);
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                throw throwable;
            }
        }
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpOrgTable);
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpFormulaTable);
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
        return pastDataList;
    }

    private void setSourceByBgForm(Context ctx, List<BgAdjustPastDataInfo> pastDataList, Set<String> bgFormIds, Map<String, List<BgAdjustPastDataInfo>> tempPastDataMap) throws BOSException {
        this.setRollPastSourceByRollBgForm(ctx, bgFormIds, tempPastDataMap);
        Iterator<List<BgAdjustPastDataInfo>> iterator = tempPastDataMap.values().iterator();
        while (iterator.hasNext()) {
            pastDataList.addAll((Collection<BgAdjustPastDataInfo>)iterator.next());
        }
    }

    private PreparedStatement dealPrmtForTransit(Connection conn, String l, StringBuilder sql, String tmpOrgTable, String tmpFormulaTable, String bgSchemeId, int versionID, int processType) throws SQLException {
        sql.append("SELECT");
        sql.append(" data.FID dataId,");
        sql.append(" data.FFormula formula,");
        sql.append(" us.FName_" + l + " adjustor,");
        sql.append(" data.FCreateTime createTime,");
        sql.append(" data.FValue newValue,");
        sql.append(" data.FOldValue oldValue,");
        sql.append(" data.FAdjustReason adjustReason,");
        sql.append(" data.FBgItemCombination itemComBinId,");
        sql.append(" entry.Fformid formId ,");
        sql.append(" period.FName_" + l + " periodName,");
        sql.append(" element.FName_" + l + " elementname,");
        sql.append(" org.FName_" + l + " orgName,");
        sql.append(" org.FID orgId, ");
        sql.append(" bgVersion.FNumber bgVersionNumber,");
        sql.append(" bgVersion.FName_" + l + " bgVersionName,");
        sql.append("bgScenario.FNumber bgScenarioNumber,");
        sql.append("bgScenario.FName_" + l + " bgScenarioName ");
        sql.append(" FROM T_MBG_BgTmpData data");
        sql.append(" LEFT JOIN T_MBG_BgTmpDataEntry entry ON data.FID = entry.FDataID");
        sql.append(" LEFT JOIN T_PM_User us ON us.FID=data.FLastUpdateUserID");
        sql.append(" LEFT JOIN T_MBG_BgElement element ON element.FID=data.FBgElementId");
        sql.append(" LEFT JOIN T_MBG_BgVersion bgVersion ON bgVersion.FVersionID = data.FVersion");
        sql.append(" LEFT JOIN T_MBG_BgPeriod period ON period.FID = data.FBgPeriodID");
        sql.append(" LEFT JOIN T_MBG_BgScenario bgScenario ON bgScenario.FScenarioID = data.FScenario");
        sql.append(" Inner JOIN T_Org_CostCenter org on data.FOrgUnitId = org.FID");
        sql.append(" where data.FbgSchemerootId = ? and data.FFormula in (select FFormula from " + tmpFormulaTable + ") and data.ForgUnitId in (select FID from " + tmpOrgTable + ")");
        sql.append(" and Fversion = ? and FprocessType = ?");
        PreparedStatement pmst = conn.prepareStatement(sql.toString());
        pmst.setString(1, bgSchemeId);
        pmst.setInt(2, versionID);
        pmst.setInt(3, processType);
        return pmst;
    }
}

