/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgAnalysReportCollection;
import com.kingdee.eas.ma.mbg.BgAnalysReportInfo;
import com.kingdee.eas.ma.mbg.BgAnalysRptTemplateFactory;
import com.kingdee.eas.ma.mbg.BgAnalysRptTemplateInfo;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgOrgViewInfo;
import com.kingdee.eas.ma.mbg.BgTemplateStatusEnum;
import com.kingdee.eas.ma.mbg.BgTypeInfo;
import com.kingdee.eas.ma.mbg.app.AbstractBgAnalysReportControllerBean;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.analysisReport.BgAnalysRptUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BgAnalysReportControllerBean
extends AbstractBgAnalysReportControllerBean {
    private static final long serialVersionUID = -7164067360803794717L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgAnalysReportControllerBean");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _getAnalysReports(Context ctx, Map condition) throws BOSException, EASBizException {
        Connection conn;
        HashMap<String, Map<String, Object>> resultMap;
        block30: {
            Boolean[] states = (Boolean[])condition.get("states");
            String selectSchemeID = (String)condition.get("schemeID");
            BgTypeInfo typeInfo = (BgTypeInfo)condition.get("bgTypeIDs");
            BgPeriodInfo[] selectPeriodInfoS = (BgPeriodInfo[])condition.get("bgPeriodInfos");
            CurrencyInfo selectCurrency = (CurrencyInfo)condition.get("currencyInfo");
            BgVersionInfo[] selectVersion = (BgVersionInfo[])condition.get("bgVersionInfo");
            String[] selectTemplateIDS = (String[])condition.get("bgAnalysRptTemplateIDs");
            boolean isContainForbidden = (Boolean)condition.get("cludeCancel");
            BgOrgViewInfo bgOrgView = (BgOrgViewInfo)condition.get("bgOrgView");
            HashSet<String> bgTemplateIdsSet = new HashSet<String>();
            this.copyArrayToSet(bgTemplateIdsSet, selectTemplateIDS);
            HashSet<String> bgPeriodIdsSet = new HashSet<String>();
            for (int i = 0; i < selectPeriodInfoS.length; ++i) {
                bgPeriodIdsSet.add(selectPeriodInfoS[i].getId().toString());
            }
            HashSet<String> bgVersionIdsSet = new HashSet<String>();
            for (int i = 0; i < selectVersion.length; ++i) {
                bgVersionIdsSet.add(selectVersion[i].getId().toString());
            }
            Set orgUnitIDs = (Set)condition.get("orgIDs");
            if (orgUnitIDs.isEmpty()) {
                return null;
            }
            resultMap = new HashMap<String, Map<String, Object>>();
            String tmpOrgUnit = null;
            conn = null;
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            try {
                conn = this.getConnection(ctx);
                if (orgUnitIDs != null && !orgUnitIDs.isEmpty()) {
                    tmpOrgUnit = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpOrgUnit + " (FID) values (?)"), (Collection)orgUnitIDs);
                }
                LinkedHashMap<String, BgAnalysReportInfo> _bgFormMap = new LinkedHashMap<String, BgAnalysReportInfo>();
                LinkedHashMap<String, BgAnalysReportInfo> bgFormMap = new LinkedHashMap<String, BgAnalysReportInfo>();
                Map<String, Object[]> keyMap = null;
                HashSet<Integer> _state = new HashSet<Integer>();
                _state.add(new Integer(1));
                _state.add(new Integer(2));
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                SelectorItemCollection sic = this.getAnalysReportSelectorItem();
                view.getSelector().addObjectCollection((IObjectCollection)sic);
                filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)selectSchemeID, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("bgVersion.id", bgVersionIdsSet, CompareType.INCLUDE));
                boolean isTemplateIdsEmpty = EmptyUtil.isEmpty(bgTemplateIdsSet);
                if (!isTemplateIdsEmpty) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("select frootid from T_MBG_BgAnalysRptTemplate where fid in (");
                    for (Object e : bgTemplateIdsSet) {
                        sb.append("'").append(e.toString()).append("',");
                    }
                    sb = sb.deleteCharAt(sb.lastIndexOf(","));
                    sb.append(")");
                    filter.getFilterItems().add(new FilterItemInfo("bgTemplate.root.id", (Object)sb.toString(), CompareType.INNER));
                } else if (!isContainForbidden) {
                    filter.getFilterItems().add(new FilterItemInfo("bgTemplate.templateStatus", (Object)Integer.toString(0), CompareType.EQUALS));
                }
                filter.getFilterItems().add(new FilterItemInfo("bgPeriod.id", bgPeriodIdsSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)selectCurrency.getId(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("state", _state, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)("select FID from " + tmpOrgUnit), CompareType.INNER));
                if (typeInfo != null) {
                    filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", (Object)typeInfo.getId(), CompareType.EQUALS));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", null));
                    filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", (Object)"bgMAAAAKIcA7rHKd", CompareType.NOTEQUALS));
                }
                if (!isTemplateIdsEmpty) {
                    if (typeInfo != null) {
                        filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and #6 and #7 ");
                    } else {
                        filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and #6 and (#7 or #8) ");
                    }
                } else if (!isContainForbidden) {
                    if (typeInfo != null) {
                        filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and #6 and #7 ");
                    } else {
                        filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and #6 and (#7 or #8) ");
                    }
                } else if (typeInfo != null) {
                    filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and #6 ");
                } else {
                    filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and (#6 or #7) ");
                }
                view.setFilter(filter);
                BgAnalysReportCollection colls = this.getBgAnalysReportCollection(ctx, view);
                if (colls != null) {
                    StringBuffer _key = null;
                    Object var30_34 = null;
                    Iterator iter = colls.iterator();
                    while (iter.hasNext()) {
                        BgAnalysReportInfo bgAnalysReportInfo = (BgAnalysReportInfo)iter.next();
                        _key = this.getKey(bgAnalysReportInfo);
                        _bgFormMap.put(_key.toString(), bgAnalysReportInfo);
                        if (states[1].booleanValue() && bgAnalysReportInfo.getState().getValue() == 1) {
                            bgFormMap.put(_key.toString(), bgAnalysReportInfo);
                        }
                        if (!states[2].booleanValue() || bgAnalysReportInfo.getState().getValue() != 2) continue;
                        bgFormMap.put(_key.toString(), bgAnalysReportInfo);
                    }
                }
                Map<String, Map<String, BgAnalysRptTemplateInfo>> bgTemplateMap = this.queryTemplateInfo(ctx, tmpOrgUnit, selectSchemeID, bgTemplateIdsSet, isContainForbidden, typeInfo);
                keyMap = this.getKeyMap(this.queryOrgInfo(ctx, orgUnitIDs), bgTemplateMap, selectPeriodInfoS, selectCurrency, selectVersion, _bgFormMap);
                DimensionCacheHelper dimensionCacheHelper = new DimensionCacheHelper(ctx);
                if (bgOrgView != null) {
                    Map<String, Boolean> isShowAliasMap = dimensionCacheHelper.removeViewKey(bgOrgView.getId().toString(), dimensionCacheHelper.isShowAlias(bgOrgView.getId().toString(), orgUnitIDs));
                    Map<String, String> aliasMap = dimensionCacheHelper.getAliasMap(bgPeriodIdsSet);
                    resultMap.put("isShowAliasMap", isShowAliasMap);
                    resultMap.put("aliasMap", aliasMap);
                }
                resultMap.put("key2BgformMap", _bgFormMap);
                resultMap.put("bgFormAtt", bgFormMap);
                resultMap.put("keyMap", keyMap);
                if (pool == null || tmpOrgUnit == null) break block30;
            }
            catch (Exception ex) {
                try {
                    logger.error((Object)"", (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    if (pool != null && tmpOrgUnit != null) {
                        pool.releaseTable(tmpOrgUnit);
                    }
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
            pool.releaseTable(tmpOrgUnit);
        }
        SQLUtils.cleanup((Connection)conn);
        return resultMap;
    }

    private StringBuffer getKey(BgAnalysReportInfo bgFormInfo) {
        StringBuffer key = new StringBuffer(bgFormInfo.getOrgUnit().getId().toString()).append("_").append(bgFormInfo.getBgTemplate().getId().toString()).append("_").append(bgFormInfo.getBgPeriod().getId().toString()).append("_").append(bgFormInfo.getCurrency().getId().toString()).append("_").append(bgFormInfo.getBgVersion().getId().toString());
        return key;
    }

    protected SelectorItemCollection getAnalysReportSelectorItem() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("state");
        sic.add("wordID");
        sic.add("description");
        sic.add("bgScheme.id");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("bgScheme.state");
        sic.add("bgScheme.isFiling");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.number");
        sic.add("bgTemplate.name");
        sic.add("bgTemplate.root.id");
        sic.add("bgTemplate.bgType.id");
        sic.add("bgTemplate.bgType.number");
        sic.add("bgTemplate.bgType.name");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("orgUnit.longnumber");
        sic.add("orgUnit.isGrouping");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.beginDate");
        sic.add("bgPeriod.endDate");
        sic.add("bgPeriod.year");
        sic.add("bgPeriod.halfYear");
        sic.add("bgPeriod.quarter");
        sic.add("bgPeriod.month");
        sic.add("bgPeriod.week");
        sic.add("bgPeriod.showLevel");
        sic.add("bgPeriod.periodType");
        sic.add("bgPeriod.isLeaf");
        sic.add("bgPeriod.level");
        sic.add("bgPeriod.longNumber");
        sic.add("bgPeriod.displayName");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("bgVersion.id");
        sic.add("bgVersion.name");
        sic.add("bgVersion.number");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("lastUpdateTime");
        sic.add("auditor.id");
        sic.add("auditor.name");
        sic.add("auditedTime");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("createTime");
        return sic;
    }

    private Map<String, Object[]> getKeyMap(Map<String, FullOrgUnitInfo> queryOrgInfo, Map<String, Map<String, BgAnalysRptTemplateInfo>> bgTemplateMap, BgPeriodInfo[] selectPeriodInfoS, CurrencyInfo selectCurrency, BgVersionInfo[] selectVersion, Map<String, BgAnalysReportInfo> _bgFormMap) {
        HashMap<String, Object[]> keyMap = new HashMap<String, Object[]>();
        Boolean isEmpty = EmptyUtil.isEmpty(queryOrgInfo) || EmptyUtil.isEmpty(bgTemplateMap) || EmptyUtil.isEmpty((Object[])selectVersion) || EmptyUtil.isEmpty((Object[])selectPeriodInfoS) || EmptyUtil.isEmpty((CoreBaseInfo)selectCurrency);
        if (isEmpty.booleanValue()) {
            return keyMap;
        }
        Object[] tmpValue = null;
        String _orgId2 = null;
        Object _bgSchemeId = null;
        String _bgTemplateId = null;
        String tempKey2 = null;
        StringBuffer _key = null;
        Map<String, BgAnalysRptTemplateInfo> _tmpTmMap = null;
        BgPeriodInfo bgPeriodInfo2 = null;
        CurrencyInfo currencyInfo = null;
        Object bgSchemeInfo = null;
        BgAnalysRptTemplateInfo templateInfo = null;
        BgVersionInfo bgVersionInfo = null;
        String[] mapkey = null;
        for (String _orgId2 : queryOrgInfo.keySet()) {
            for (Map.Entry<String, Map<String, BgAnalysRptTemplateInfo>> entry : bgTemplateMap.entrySet()) {
                _tmpTmMap = entry.getValue();
                for (Map.Entry<String, BgAnalysRptTemplateInfo> _entrytm : _tmpTmMap.entrySet()) {
                    mapkey = _entrytm.getKey().split(":");
                    _bgTemplateId = mapkey[1];
                    templateInfo = _entrytm.getValue();
                    if (!mapkey[0].equals(_orgId2)) continue;
                    for (BgPeriodInfo bgPeriodInfo2 : selectPeriodInfoS) {
                        currencyInfo = selectCurrency;
                        for (int i = 0; i < selectVersion.length; ++i) {
                            bgVersionInfo = selectVersion[i];
                            boolean isExistForm = false;
                            for (String tempKey2 : _bgFormMap.keySet()) {
                                BgAnalysReportInfo bgFormInfo = _bgFormMap.get(tempKey2);
                                if (!bgFormInfo.getOrgUnit().getId().toString().equals(_orgId2) || !bgFormInfo.getOrgUnit().getId().toString().equals(_orgId2) || !bgFormInfo.getBgTemplate().getId().toString().equals(_bgTemplateId) || !bgFormInfo.getBgPeriod().getId().toString().equals(bgPeriodInfo2.getId().toString()) || !bgFormInfo.getBgVersion().getId().toString().equals(bgVersionInfo.getId().toString()) || !bgFormInfo.getCurrency().getId().toString().equals(currencyInfo.getId().toString())) continue;
                                isExistForm = true;
                                _key = this.getKey(_orgId2, _bgTemplateId, bgPeriodInfo2.getId().toString(), currencyInfo.getId().toString(), bgVersionInfo.getId().toString());
                                tmpValue = new Object[]{bgSchemeInfo, templateInfo, bgPeriodInfo2, currencyInfo, bgVersionInfo, queryOrgInfo.get(_orgId2)};
                                keyMap.put(_key.toString(), tmpValue);
                            }
                            if (isExistForm) continue;
                            _key = this.getKey(_orgId2, _bgTemplateId, bgPeriodInfo2.getId().toString(), currencyInfo.getId().toString(), bgVersionInfo.getId().toString());
                            tmpValue = new Object[]{bgSchemeInfo, templateInfo, bgPeriodInfo2, currencyInfo, bgVersionInfo, queryOrgInfo.get(_orgId2)};
                            keyMap.put(_key.toString(), tmpValue);
                        }
                    }
                }
            }
        }
        return keyMap;
    }

    private StringBuffer getKey(String orgID, String bgTemplateID, String bgPeriodID, String currencyID, String bgversionId) {
        StringBuffer key = new StringBuffer(orgID).append("_").append(bgTemplateID).append("_").append(bgPeriodID).append("_").append(currencyID).append("_").append(bgversionId);
        return key;
    }

    private Map<String, FullOrgUnitInfo> queryOrgInfo(Context ctx, Set<String> _filtedQueryOrgUnitIds) throws BOSException {
        HashMap<String, FullOrgUnitInfo> orgMap = new HashMap<String, FullOrgUnitInfo>();
        if (_filtedQueryOrgUnitIds == null) {
            return orgMap;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", _filtedQueryOrgUnitIds, CompareType.INCLUDE));
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("isGrouping");
        FullOrgUnitCollection col = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(evi);
        if (col != null && !col.isEmpty()) {
            for (int i = 0; i < col.size(); ++i) {
                orgMap.put(col.get(i).getId().toString(), col.get(i));
            }
        }
        return orgMap;
    }

    protected Map<String, Map<String, BgAnalysRptTemplateInfo>> queryTemplateInfo(Context ctx, String tmpOrgTable, String selectSchemeID, Set<String> bgTemplateIds, boolean isContainForbidden, BgTypeInfo bgtype) throws BOSException, EASBizException {
        if (ctx == null || selectSchemeID == null || tmpOrgTable == null || bgTemplateIds == null) {
            return new HashMap<String, Map<String, BgAnalysRptTemplateInfo>>();
        }
        HashMap<String, Map<String, BgAnalysRptTemplateInfo>> _bgTemplateMap = new HashMap<String, Map<String, BgAnalysRptTemplateInfo>>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Map<String, BgAnalysRptTemplateInfo> tmpMap = null;
        BgAnalysRptTemplateInfo templateInfo = null;
        BgTypeInfo typeInfo = null;
        ArrayList _tmpList = new ArrayList();
        String _schemeId = null;
        String _tempId = null;
        String _tempNumber = null;
        String _tempName = null;
        String _roodID = null;
        String _bgTypeID = null;
        String _bgTypeNumber = null;
        String _bgTypeName = null;
        String _templateStatus = null;
        String _bgOrgUnitId = null;
        String _tempNodeOrgUnitId = null;
        StringBuffer sql = this.queryTemplateSql(ctx);
        if (bgtype != null) {
            sql.append(" where y.FID = '" + bgtype.getId() + "' ");
        } else {
            sql.append(" where (y.FID IS NULL or y.FID <> 'bgMAAAAKIcA7rHKd') ");
        }
        sql.append(" and n.FOrgUnitId IN (select FID from " + tmpOrgTable + ")");
        sql.append(" and t.FBgSchemeId = '" + selectSchemeID + "' ");
        if (!bgTemplateIds.isEmpty()) {
            sql.append(" and t.frootid in ( select frootid from T_MBG_BgAnalysRptTemplate where fid in (");
            for (String object : bgTemplateIds) {
                sql.append("'").append(object.toString()).append("',");
            }
            sql = sql.deleteCharAt(sql.lastIndexOf(","));
            sql.append("))");
        } else if (!isContainForbidden) {
            sql.append(" and t.FTemplateStatus = 0 ");
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _schemeId = rst.getString(1);
                _tempId = rst.getString(2);
                _tempName = rst.getString(3);
                _tempNumber = rst.getString(4);
                _templateStatus = rst.getString(5);
                _roodID = rst.getString(6);
                _bgTypeID = rst.getString(7);
                _bgTypeNumber = rst.getString(8);
                _bgTypeName = rst.getString(9);
                _bgOrgUnitId = rst.getString(10);
                _tempNodeOrgUnitId = rst.getString(11);
                if (_bgTemplateMap.containsKey(_schemeId)) {
                    tmpMap = (Map)_bgTemplateMap.get(_schemeId);
                } else {
                    tmpMap = new HashMap();
                    _bgTemplateMap.put(_schemeId, tmpMap);
                }
                templateInfo = new BgAnalysRptTemplateInfo();
                templateInfo.setId(BOSUuid.read((String)_tempId));
                templateInfo.setName(_tempName);
                templateInfo.setNumber(_tempNumber);
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                fullOrgUnitInfo.setId(BOSUuid.read((String)_bgOrgUnitId));
                templateInfo.setOrgUnit(fullOrgUnitInfo);
                if (!StringUtils.isEmpty((String)_templateStatus)) {
                    templateInfo.setTemplateStatus(BgTemplateStatusEnum.getEnum(Integer.valueOf(_templateStatus)));
                }
                typeInfo = new BgTypeInfo();
                if (!StringUtils.isEmpty((String)_bgTypeID)) {
                    typeInfo.setId(BOSUuid.read((String)_bgTypeID));
                    typeInfo.setName(_bgTypeName);
                    typeInfo.setNumber(_bgTypeNumber);
                }
                templateInfo.setBgType(typeInfo);
                tmpMap.put(_tempNodeOrgUnitId + ":" + _tempId, templateInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return _bgTemplateMap;
    }

    protected StringBuffer queryTemplateSql(Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FBgSchemeId, n.FBgAnalysRptTemplateID, t.FName_" + ctx.getLocale() + ", t.FNumber,t.FTemplateStatus , t.frootid , y.FID, y.FNumber, y.FName_").append(ctx.getLocale()).append(", t.FOrgUnitId , n.FOrgUnitId from T_MBG_BgAnalysRptTemplateNode n ").append(" left join T_MBG_BgAnalysRptTemplate t on n.FBgAnalysRptTemplateID = t.FID").append(" left join T_MBg_BgType y on t.FBgTypeId = y.FID");
        return sql;
    }

    protected void copyArrayToSet(Set<String> set, String[] array) {
        if (array != null) {
            int in = array.length;
            for (int i = 0; i < in; ++i) {
                if (array[i] == null) continue;
                set.add(array[i].toString());
            }
        }
    }

    @Override
    public IObjectPK addnew(Context ctx, BgAnalysReportInfo model) throws BOSException, EASBizException {
        IObjectPK pk = null;
        try {
            if (this.exists(ctx, "select id where bgScheme.id ='" + model.getBgScheme().getId() + "' and bgTemplate.id ='" + model.getBgTemplate().getId() + "' and currency.id ='" + model.getCurrency().getId() + "' and orgUnit.id ='" + model.getOrgUnit().getId() + "' and bgPeriod.id ='" + model.getBgPeriod().getId() + "' and bgVersion.id ='" + model.getBgVersion().getId() + "'")) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource", (String)"checkReportExists", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{model.getOrgUnit().getName(), model.getBgTemplate().getName(), model.getBgPeriod().getName(), model.getBgVersion().getName(), model.getCurrency().getName()}));
            }
            model.setState(BgFormStateEnum.Edited);
            pk = super.addnew(ctx, model);
            this.createReports(ctx, pk, model);
            return pk;
        }
        catch (Exception e) {
            logger.error((Object)"addnew error.", (Throwable)e);
            if (pk != null) {
                this.delete(ctx, pk);
            }
            throw new BOSException((Throwable)e);
        }
    }

    protected void createReports(Context ctx, IObjectPK reportId, BgAnalysReportInfo model) throws Exception {
        String templateWordPath = null;
        String reportsWordPath = null;
        try {
            String unionId = model.getString("tree.id");
            model = this.getBgAnalysReportInfo(ctx, reportId, this.getAnalysReportSelectorItem());
            model.setString("tree.id", unionId);
            long time = System.currentTimeMillis();
            String attchID = null;
            byte[] templateContent = this.getTemplate(ctx, reportId, model);
            reportsWordPath = this.getFileFullName(model);
            byte[] notesContent = BgAnalysRptUtil.generateRptNotesWord(ctx, templateWordPath, reportsWordPath, model, templateContent);
            attchID = BgAnalysRptUtil.uploadWordFile(ctx, reportsWordPath, reportId.toString(), notesContent);
            time = System.currentTimeMillis() - time;
            BgDBUtils.executeUpdate((Context)ctx, (String)"update T_MBG_BgAnalysReport set FWordID=? where fid=?", (Object[])new Object[]{attchID, reportId.toString()});
        }
        catch (Exception e) {
            try {
                logger.error((Object)"createRptNotes error.", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                BgAnalysRptUtil.removeFile(templateWordPath);
                BgAnalysRptUtil.removeFile(reportsWordPath);
                throw throwable;
            }
        }
        BgAnalysRptUtil.removeFile(templateWordPath);
        BgAnalysRptUtil.removeFile(reportsWordPath);
    }

    protected byte[] getTemplate(Context ctx, IObjectPK rptNoteId, BgAnalysReportInfo model) throws Exception {
        try {
            String temWordAttachId = BgAnalysRptTemplateFactory.getLocalInstance(ctx).getBgAnalysRptTemplateInfo("select wordAttachId where id='" + model.getBgTemplate().getId().toString() + "'").getWordAttachId().toString();
            return BgAnalysRptUtil.getWordContent(ctx, temWordAttachId);
        }
        catch (Exception e) {
            logger.error((Object)"downLoadTemplate error.", (Throwable)e);
            throw e;
        }
    }

    protected String getFileFullName(BgAnalysReportInfo info) throws Exception {
        StringBuffer fileName = new StringBuffer();
        fileName.append(System.getProperty("EAS_INSTANCE_HOME")).append(File.separator);
        fileName.append(info.getOrgUnit().getName()).append("-").append(info.getName()).append("(").append(info.getNumber()).append(")-");
        fileName.append(info.getBgPeriod().getName()).append("-").append(info.getBgVersion().getName());
        fileName.append("-").append(info.getCurrency().getName()).append(".docx");
        return fileName.toString();
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    @Override
    protected boolean _updateWordId(Context ctx, String rptId, String wordId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_MBG_BgAnalysReport set FWordID=?,FLastUpdateUserID=?,FLastUpdateTime=? where fid=? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{wordId, ctx.getCaller().toString(), ReportNotesUtil.getTime(), rptId});
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        String[] attachIds = asm.getAttachmentIDsByBoID(rptId);
        if (attachIds != null) {
            IBoAttchAsso iBoAttchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx);
            for (String attachId : attachIds) {
                if (wordId.equals(attachId)) continue;
                iBoAttchAsso.deleteOneAssociation(rptId, attachId);
            }
        }
        return true;
    }

    @Override
    protected String[] _delete(Context ctx, String parentBgOrgUnitId, Map ids, Map openId, Set orgPermIds) throws BOSException, EASBizException {
        String[] stringArray;
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        HashSet<BgAnalysReportInfo> openIdS;
        LinkedHashMap<String, BgAnalysReportInfo> reportMap;
        HashSet<FullOrgUnitInfo> permOrgIds;
        HashSet<BgAnalysReportInfo> noCreateId;
        int failCount;
        int totalCount;
        block27: {
            BgAnalysReportInfo bgReportInfo2;
            Iterator itRpt;
            Set reportIds;
            if (ids == null || ids.isEmpty()) {
                return null;
            }
            Map _ids = ids;
            totalCount = 0;
            failCount = 0;
            noCreateId = new HashSet<BgAnalysReportInfo>();
            permOrgIds = new HashSet<FullOrgUnitInfo>();
            reportMap = new LinkedHashMap<String, BgAnalysReportInfo>();
            HashSet<IObjectPK> deletePks = new HashSet<IObjectPK>();
            openIdS = new HashSet<BgAnalysReportInfo>();
            ArrayList<String> newids = new ArrayList<String>();
            conn = null;
            pstmt = null;
            rst = null;
            StringBuffer sql = new StringBuffer();
            for (String orgUnitId : _ids.keySet()) {
                reportIds = (Set)_ids.get(orgUnitId);
                totalCount += reportIds.size();
                if (orgPermIds.contains(orgUnitId)) continue;
                failCount += reportIds.size();
                itRpt = reportIds.iterator();
                if (itRpt.hasNext()) {
                    bgReportInfo2 = (BgAnalysReportInfo)itRpt.next();
                    permOrgIds.add(bgReportInfo2.getOrgUnit());
                }
                ((Set)_ids.get(orgUnitId)).clear();
            }
            for (String orgUnitId : _ids.keySet()) {
                reportIds = (Set)_ids.get(orgUnitId);
                itRpt = reportIds.iterator();
                while (itRpt.hasNext()) {
                    BgAnalysReportInfo bgReportInfo2 = (BgAnalysReportInfo)itRpt.next();
                    if (!openId.containsKey(bgReportInfo2.getId().toString())) continue;
                    itRpt.remove();
                    openIdS.add(bgReportInfo2);
                }
            }
            for (String orgUnitId : _ids.keySet()) {
                reportIds = (Set)_ids.get(orgUnitId);
                itRpt = reportIds.iterator();
                while (itRpt.hasNext()) {
                    bgReportInfo2 = (BgAnalysReportInfo)itRpt.next();
                    if (bgReportInfo2.getId().getType().equals((Object)new BgAnalysReportInfo().getBOSType())) continue;
                    itRpt.remove();
                    noCreateId.add(bgReportInfo2);
                }
            }
            for (String orgUnitId : _ids.keySet()) {
                reportIds = (Set)_ids.get(orgUnitId);
                for (BgAnalysReportInfo bgReportInfo2 : reportIds) {
                    newids.add(bgReportInfo2.getId().toString());
                    reportMap.put(bgReportInfo2.getId().toString(), bgReportInfo2);
                }
            }
            conn = this.getConnection(ctx);
            List params = new ArrayList();
            sql.setLength(0);
            sql.append("Select FNumber, FID, FOrgUnitId, FState FROM T_MBG_BgAnalysReport  Where FID IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(") ");
            params = MbgSqlHelper.getBatchParams(null, (Object[])newids.toArray(), (int)50);
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < params.size(); ++i) {
                MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])params.get(i)));
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    String orgUnitId;
                    String bgReportId = rst.getString("FID");
                    orgUnitId = rst.getString("FOrgUnitId");
                    int state = rst.getInt("FState");
                    if (state == 1) {
                        deletePks.add((IObjectPK)new ObjectStringPK(bgReportId));
                        reportMap.remove(bgReportId);
                        continue;
                    }
                    noCreateId.add((BgAnalysReportInfo)reportMap.get(bgReportId));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup((Statement)pstmt);
            if (!deletePks.isEmpty()) {
                this._delete(ctx, deletePks.toArray(new IObjectPK[0]));
                this.afterDeleteReport(ctx, deletePks);
            }
            if (!reportMap.isEmpty() || !permOrgIds.isEmpty() || !noCreateId.isEmpty() || !openIdS.isEmpty()) break block27;
            String[] i = new String[]{ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource", (String)"deleteSuccess", (Locale)ctx.getLocale())};
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            return i;
        }
        try {
            String msgState = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource", (String)"checkState", (Locale)ctx.getLocale());
            String msgPerm = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource", (String)"noDeletePermOrgRpt", (Locale)ctx.getLocale());
            String msgOpen = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource", (String)"checkOpenRpt", (Locale)ctx.getLocale());
            StringBuffer msg = new StringBuffer();
            for (FullOrgUnitInfo stringArray2 : permOrgIds) {
                if (msg.length() > 0) {
                    msg.append("\r\n");
                }
                msg.append(MessageFormat.format(msgPerm, stringArray2.getName()));
            }
            for (BgAnalysReportInfo bgAnalysReportInfo : openIdS) {
                ++failCount;
                if (msg.length() > 0) {
                    msg.append("\r\n");
                }
                msg.append(MessageFormat.format(msgOpen, bgAnalysReportInfo.getOrgUnit().getName(), bgAnalysReportInfo.getNumber()));
            }
            for (BgAnalysReportInfo bgAnalysReportInfo : noCreateId) {
                ++failCount;
                if (msg.length() > 0) {
                    msg.append("\r\n");
                }
                msg.append(MessageFormat.format(msgState, bgAnalysReportInfo.getOrgUnit().getName(), bgAnalysReportInfo.getNumber()));
            }
            if (noCreateId.isEmpty() && !reportMap.isEmpty()) {
                for (String string : reportMap.keySet()) {
                    BgAnalysReportInfo info = (BgAnalysReportInfo)reportMap.get(string);
                    ++failCount;
                    if (msg.length() > 0) {
                        msg.append("\r\n");
                    }
                    msg.append(MessageFormat.format(msgState, info.getOrgUnit().getName(), info.getNumber()));
                }
            }
            String info = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource", (String)"deleteMsg", (Locale)ctx.getLocale()), totalCount, failCount, totalCount - failCount);
            stringArray = new String[]{info, msg.toString()};
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return stringArray;
    }

    private void afterDeleteReport(Context ctx, Set<IObjectPK> deletePks) throws BOSException, EASBizException {
        if (deletePks.size() == 0 || deletePks == null) {
            return;
        }
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        for (IObjectPK iPk : deletePks) {
            asm.deleteAttachemtsByBoID(iPk.toString());
        }
    }

    @Override
    protected String[] _audit(Context ctx, String parentBgOrgUnitId, Map ids, Set orgPermIds) throws BOSException, EASBizException {
        return this.dealApproved(ctx, parentBgOrgUnitId, ids, orgPermIds, true);
    }

    @Override
    protected String[] _unAudit(Context ctx, String parentBgOrgUnitId, Map ids, Set orgPermIds) throws BOSException, EASBizException {
        return this.dealApproved(ctx, parentBgOrgUnitId, ids, orgPermIds, false);
    }

    private String[] dealApproved(Context ctx, String parentBgOrgUnitId, Map ids, Set orgPermIds, boolean isAudit) throws BOSException, EASBizException {
        String[] stringArray;
        String key;
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        LinkedHashMap<String, BgAnalysReportInfo> reportMap;
        HashSet<FullOrgUnitInfo> permOrgIds;
        HashSet<BgAnalysReportInfo> noCreateId;
        int failCount;
        int totalCount;
        block24: {
            Object[] sqlObject;
            Iterator itRpt;
            Set reportIds;
            if (ids == null || ids.isEmpty()) {
                return null;
            }
            Map _ids = ids;
            totalCount = 0;
            failCount = 0;
            noCreateId = new HashSet<BgAnalysReportInfo>();
            permOrgIds = new HashSet<FullOrgUnitInfo>();
            reportMap = new LinkedHashMap<String, BgAnalysReportInfo>();
            HashSet<String> deletePks = new HashSet<String>();
            ArrayList<String> newids = new ArrayList<String>();
            conn = null;
            pstmt = null;
            rst = null;
            StringBuffer sql = new StringBuffer();
            for (String orgUnitId : _ids.keySet()) {
                reportIds = (Set)_ids.get(orgUnitId);
                totalCount += reportIds.size();
                if (orgPermIds.contains(orgUnitId)) continue;
                failCount += reportIds.size();
                itRpt = reportIds.iterator();
                if (itRpt.hasNext()) {
                    BgAnalysReportInfo bgReportInfo = (BgAnalysReportInfo)itRpt.next();
                    permOrgIds.add(bgReportInfo.getOrgUnit());
                }
                ((Set)_ids.get(orgUnitId)).clear();
            }
            for (String orgUnitId : _ids.keySet()) {
                reportIds = (Set)_ids.get(orgUnitId);
                itRpt = reportIds.iterator();
                while (itRpt.hasNext()) {
                    BgAnalysReportInfo bgReportInfo2 = (BgAnalysReportInfo)itRpt.next();
                    if (bgReportInfo2.getId().getType().equals((Object)new BgAnalysReportInfo().getBOSType())) continue;
                    itRpt.remove();
                    noCreateId.add(bgReportInfo2);
                }
            }
            for (String orgUnitId : _ids.keySet()) {
                reportIds = (Set)_ids.get(orgUnitId);
                for (BgAnalysReportInfo bgReportInfo : reportIds) {
                    newids.add(bgReportInfo.getId().toString());
                    reportMap.put(bgReportInfo.getId().toString(), bgReportInfo);
                }
            }
            conn = this.getConnection(ctx);
            List params = new ArrayList();
            sql.setLength(0);
            sql.append("Select FNumber, FID, FOrgUnitId, FState FROM T_MBG_BgAnalysReport  Where FID IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(") ");
            params = MbgSqlHelper.getBatchParams(null, (Object[])newids.toArray(), (int)50);
            pstmt = conn.prepareStatement(sql.toString());
            int auditState = isAudit ? 1 : 2;
            for (int i = 0; i < params.size(); ++i) {
                MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])params.get(i)));
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    String orgUnitId;
                    String bgReportId = rst.getString("FID");
                    orgUnitId = rst.getString("FOrgUnitId");
                    int state = rst.getInt("FState");
                    if (state == auditState) {
                        deletePks.add(bgReportId);
                        reportMap.remove(bgReportId);
                        continue;
                    }
                    noCreateId.add((BgAnalysReportInfo)reportMap.get(bgReportId));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup((Statement)pstmt);
            if (!deletePks.isEmpty()) {
                ArrayList<Object[]> sqlParams = new ArrayList<Object[]>();
                sqlObject = null;
                String userId = ctx.getCaller().toString();
                Timestamp createtime = new Timestamp(new Date().getTime());
                for (String stringArray2 : deletePks) {
                    sqlObject = isAudit ? new Object[]{2, userId, createtime, userId, createtime, stringArray2} : new Object[]{1, null, null, userId, createtime, stringArray2};
                    sqlParams.add(sqlObject);
                }
                MbgSqlHelper.executeBatch((Connection)conn, (String)"Update T_MBG_BgAnalysReport Set FState = ?,FAuditorID = ?,FAuditedTime = ?,FLastUpdateUserID = ?,FLastUpdateTime = ? Where FID = ?", sqlParams);
            }
            String string = key = isAudit ? "audit." : "unAudit.";
            if (!reportMap.isEmpty() || !permOrgIds.isEmpty() || !noCreateId.isEmpty()) break block24;
            sqlObject = new String[]{ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource", (String)(key + "auditSuccess"), (Locale)ctx.getLocale())};
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            return sqlObject;
        }
        try {
            String msgState = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource", (String)(key + "checkState"), (Locale)ctx.getLocale());
            String msgPerm = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource", (String)(key + "noPermOrgRpt"), (Locale)ctx.getLocale());
            StringBuffer msg = new StringBuffer();
            for (FullOrgUnitInfo fullOrgUnitInfo : permOrgIds) {
                if (msg.length() > 0) {
                    msg.append("\r\n");
                }
                msg.append(MessageFormat.format(msgPerm, fullOrgUnitInfo.getName()));
            }
            for (BgAnalysReportInfo bgAnalysReportInfo : noCreateId) {
                ++failCount;
                if (msg.length() > 0) {
                    msg.append("\r\n");
                }
                msg.append(MessageFormat.format(msgState, bgAnalysReportInfo.getOrgUnit().getName(), bgAnalysReportInfo.getNumber()));
            }
            if (noCreateId.isEmpty() && !reportMap.isEmpty()) {
                for (String string : reportMap.keySet()) {
                    BgAnalysReportInfo info = (BgAnalysReportInfo)reportMap.get(string);
                    ++failCount;
                    if (msg.length() > 0) {
                        msg.append("\r\n");
                    }
                    msg.append(MessageFormat.format(msgState, info.getOrgUnit().getName(), info.getNumber()));
                }
            }
            String info = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource", (String)(key + "auditMsg"), (Locale)ctx.getLocale()), totalCount, failCount, totalCount - failCount);
            stringArray = new String[]{info, msg.toString()};
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return stringArray;
    }
}

