/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgAnalysRptTemplateCollection;
import com.kingdee.eas.ma.mbg.BgAnalysRptTemplateFactory;
import com.kingdee.eas.ma.mbg.BgAnalysRptTemplateInfo;
import com.kingdee.eas.ma.mbg.BgAnalysRptTemplateNodeInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgAnalysRptTemplate;
import com.kingdee.eas.ma.mbg.IBgScheme;
import com.kingdee.eas.ma.mbg.app.AbstractBgAnalysRptDispatchFacadeControllerBean;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDispatchConstants;
import com.kingdee.eas.ma.mbg.utils.analysisReport.BgAnalysRptDispatchUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgAnalysRptDispatchFacadeControllerBean
extends AbstractBgAnalysRptDispatchFacadeControllerBean {
    private static final long serialVersionUID = -3180348755201191763L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgAnalysRptDispatchFacadeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _dispatch(Context ctx, Map parameter) throws BOSException, EASBizException {
        ArrayList<String[]> _reList = new ArrayList<String[]>();
        if (parameter == null || parameter.isEmpty()) {
            _reList.add(BgAnalysRptDispatchUtils.getDispatchResult(false, BgSchemeDispatchConstants.DEFEATED_PARAMETER_ISNULL));
            return _reList;
        }
        String _bgSchemeId = (String)parameter.get(BgBaseConstants.BGSCHEME_ID);
        String _treeID = (String)parameter.get(BgBaseConstants.UNIONGROUP_ID);
        List _orgUnitIds = (List)parameter.get(BgBaseConstants.ORGUNIT_ID);
        List _bgTemplateIds = (List)parameter.get(BgBaseConstants.BGTEMPLATE_ID);
        if (StringUtils.isEmpty((String)_bgSchemeId) || _orgUnitIds == null || _orgUnitIds.isEmpty() || _bgTemplateIds == null || _bgTemplateIds.isEmpty()) {
            _reList.add(BgAnalysRptDispatchUtils.getDispatchResult(false, BgSchemeDispatchConstants.DEFEATED_PARAMETER_ISNULL));
            return _reList;
        }
        if (!this.getBgSchemeInterface(ctx).exists((IObjectPK)new ObjectUuidPK(_bgSchemeId))) {
            _reList.add(BgAnalysRptDispatchUtils.getDispatchResult(false, "defeated.object.noexites"));
            return _reList;
        }
        IBgScheme iBgScheme = this.getBgSchemeInterface(ctx);
        IMutexServiceControl iMc = this.getMutexServicInterface(ctx);
        BgAnalysRptTemplateInfo templateInfo = null;
        List<String[]> tmpList = null;
        BgSchemeInfo schemeInfo = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(_bgSchemeId), BgAnalysRptDispatchUtils.getBgSchemeSelector());
        Map<String, FullOrgUnitInfo> orgUnitMap = BgAnalysRptDispatchUtils.getOrgUnitInfo(ctx, _orgUnitIds, _treeID);
        Map<String, BgAnalysRptTemplateInfo> bgTemplateMap = this.queryBgAnalysRptTemplateInfo(ctx, _bgTemplateIds);
        for (String _bgTemplateId : _bgTemplateIds) {
            templateInfo = bgTemplateMap.get(_bgTemplateId);
            try {
                boolean reqTemplate = iMc.requestBizObjIDForUpdate(_bgTemplateId);
                if (reqTemplate) {
                    tmpList = this.dispatchBgTemplate(ctx, schemeInfo, templateInfo, _orgUnitIds, orgUnitMap, _treeID);
                    if (tmpList == null) continue;
                    _reList.addAll(tmpList);
                    continue;
                }
                _reList.add(BgAnalysRptDispatchUtils.getDispatchResult(templateInfo, false, BgSchemeDispatchConstants.DISPATCH_FAIL_NETMUTEX));
            }
            finally {
                iMc.releaseObjIDForUpdate(_bgTemplateId);
            }
        }
        return _reList;
    }

    protected List<String[]> dispatchBgTemplate(Context ctx, BgSchemeInfo bgSchemeInfo, BgAnalysRptTemplateInfo bgTemplateInfo, List<String> orgUnitIds, Map<String, FullOrgUnitInfo> orgUnitMap, String treeID) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeInfo == null || bgTemplateInfo == null || orgUnitIds == null || orgUnitIds.isEmpty()) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        return BgAnalysRptDispatchUtils.dispatchTemplate(ctx, bgSchemeInfo, bgTemplateInfo, orgUnitIds, orgUnitMap, treeID);
    }

    public Map<String, BgAnalysRptTemplateInfo> queryBgAnalysRptTemplateInfo(Context ctx, List<String> bgTemplateIds) throws BOSException, EASBizException {
        HashMap<String, BgAnalysRptTemplateInfo> bgTemplateMap = new HashMap<String, BgAnalysRptTemplateInfo>();
        if (bgTemplateIds != null && !bgTemplateIds.isEmpty()) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(BgAnalysRptDispatchUtils.getBgTemplateSelector());
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(bgTemplateIds), CompareType.INCLUDE));
            BgAnalysRptTemplateCollection col = this.getBgAnalysRptTemplateInterface(ctx).getBgAnalysRptTemplateCollection(evi);
            if (col != null && !col.isEmpty()) {
                for (int i = 0; i < col.size(); ++i) {
                    bgTemplateMap.put(col.get(i).getId().toString(), col.get(i));
                }
            }
        }
        return bgTemplateMap;
    }

    private IMutexServiceControl getMutexServicInterface(Context ctx) throws BOSException {
        return MutexServiceControlFactory.getLocalInstance((Context)ctx);
    }

    private IBgScheme getBgSchemeInterface(Context ctx) throws BOSException {
        return BgSchemeFactory.getLocalInstance(ctx);
    }

    private IBgAnalysRptTemplate getBgAnalysRptTemplateInterface(Context ctx) throws BOSException {
        return BgAnalysRptTemplateFactory.getLocalInstance(ctx);
    }

    @Override
    protected Map _queryDispatchInfo(Context ctx, BOSUuid bgSchemeId) throws BOSException, EASBizException {
        HashMap dispatchMap = new HashMap();
        HashMap bgTemplateIdsMap = new HashMap();
        dispatchMap.put(BgSchemeDispatchConstants.SCHEME_DISPATCH, bgTemplateIdsMap);
        if (ctx == null || bgSchemeId == null) {
            return dispatchMap;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select t.FBgAnalysRptTemplateID, t.FOrgUnitId, t.FTreeID from T_MBG_BgAnalysRptTemplateNode t, T_MBG_BgAnalysRptTemplate t1 where t.FBgAnalysRptTemplateID = t1.FID and t.FOrgUnitID <> t1.FOrgUnitId and t1.FBgSchemeId = ?");
        Object[] sqlParams = new Object[]{bgSchemeId.toString()};
        BOSUuid bgTemRootId = null;
        BOSUuid orgUnitId = null;
        BOSUuid treeID = null;
        Set<BgAnalysRptTemplateNodeInfo> nodeInfos = null;
        BgAnalysRptTemplateNodeInfo nodeInfo = null;
        FullOrgUnitInfo orgInfo = null;
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
            while (rst.next()) {
                bgTemRootId = BOSUuid.read((String)rst.getString("FBgAnalysRptTemplateID"));
                orgUnitId = BOSUuid.read((String)rst.getString("FOrgUnitId"));
                nodeInfo = new BgAnalysRptTemplateNodeInfo();
                if (rst.getString("FTreeID") != null) {
                    treeID = BOSUuid.read((String)rst.getString("FTreeID"));
                    nodeInfo.setTreeID(treeID);
                }
                orgInfo = new FullOrgUnitInfo();
                orgInfo.setId(orgUnitId);
                nodeInfo.setOrgUnit(orgInfo);
                if (bgTemplateIdsMap.containsKey(bgTemRootId)) {
                    nodeInfos = (Set)bgTemplateIdsMap.get(bgTemRootId);
                } else {
                    nodeInfos = new HashSet();
                    bgTemplateIdsMap.put(bgTemRootId, nodeInfos);
                }
                nodeInfos.add(nodeInfo);
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"queryDispatchInfo Sql Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return dispatchMap;
    }

    @Override
    protected Set _queryCompanyIds(Context ctx) throws BOSException, EASBizException {
        HashSet<BOSUuid> companyIds = new HashSet<BOSUuid>();
        CompanyOrgUnitCollection colls = BgAnalysRptDispatchUtils.getCompanyOrgUnit(ctx);
        if (colls != null) {
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                companyIds.add(colls.get(i).getId());
            }
        }
        return companyIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _antiDispatch(Context ctx, Map parameter) throws BOSException, EASBizException {
        ArrayList<String[]> _reList = new ArrayList<String[]>();
        if (parameter == null || parameter.isEmpty()) {
            _reList.add(BgAnalysRptDispatchUtils.getDispatchResult(false, BgSchemeDispatchConstants.DEFEATED_PARAMETER_ISNULL));
            return _reList;
        }
        String _bgSchemeId = (String)parameter.get(BgBaseConstants.BGSCHEME_ID);
        String _treeID = (String)parameter.get(BgBaseConstants.UNIONGROUP_ID);
        List _orgUnitIds = (List)parameter.get(BgBaseConstants.ORGUNIT_ID);
        List _bgTemplateIds = (List)parameter.get(BgBaseConstants.BGTEMPLATE_ID);
        if (StringUtils.isEmpty((String)_bgSchemeId) || _orgUnitIds == null || _orgUnitIds.isEmpty() || _bgTemplateIds == null || _bgTemplateIds.isEmpty()) {
            _reList.add(BgAnalysRptDispatchUtils.getDispatchResult(false, BgSchemeDispatchConstants.DEFEATED_PARAMETER_ISNULL));
            return _reList;
        }
        if (!this.getBgSchemeInterface(ctx).exists((IObjectPK)new ObjectUuidPK(_bgSchemeId))) {
            _reList.add(BgAnalysRptDispatchUtils.getDispatchResult(false, "defeated.object.noexites"));
            return _reList;
        }
        IBgScheme iBgScheme = this.getBgSchemeInterface(ctx);
        IMutexServiceControl iMc = this.getMutexServicInterface(ctx);
        BgSchemeInfo schemeInfo = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(_bgSchemeId), BgAnalysRptDispatchUtils.getBgSchemeSelector());
        Map<String, FullOrgUnitInfo> orgUnitMap = BgAnalysRptDispatchUtils.getOrgUnitInfo(ctx, _orgUnitIds, _treeID);
        Map<String, BgAnalysRptTemplateInfo> bgTemplateMap = this.queryBgTemplateInfo(ctx, _bgTemplateIds);
        List<String[]> tmpList = null;
        BgAnalysRptTemplateInfo templateInfo = null;
        for (String _bgTemplateId : _bgTemplateIds) {
            templateInfo = bgTemplateMap.get(_bgTemplateId);
            try {
                boolean reqTemplate = iMc.requestBizObjIDForUpdate(_bgTemplateId);
                if (reqTemplate) {
                    tmpList = this.antiDispatchBgTemplate(ctx, schemeInfo, templateInfo, _orgUnitIds, orgUnitMap, _treeID);
                    if (tmpList == null) continue;
                    _reList.addAll(tmpList);
                    continue;
                }
                _reList.add(BgAnalysRptDispatchUtils.getDispatchResult(templateInfo, false, BgSchemeDispatchConstants.DISPATCH_FAIL_NETMUTEX));
            }
            finally {
                iMc.releaseObjIDForUpdate(_bgTemplateId);
            }
        }
        return _reList;
    }

    public Map<String, BgAnalysRptTemplateInfo> queryBgTemplateInfo(Context ctx, List<String> bgTemplateIds) throws BOSException, EASBizException {
        HashMap<String, BgAnalysRptTemplateInfo> bgTemplateMap = new HashMap<String, BgAnalysRptTemplateInfo>();
        if (bgTemplateIds != null && !bgTemplateIds.isEmpty()) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(BgAnalysRptDispatchUtils.getBgTemplateSelector());
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(bgTemplateIds), CompareType.INCLUDE));
            BgAnalysRptTemplateCollection col = this.getBgAnalysRptTemplateInterface(ctx).getBgAnalysRptTemplateCollection(evi);
            if (col != null && !col.isEmpty()) {
                for (int i = 0; i < col.size(); ++i) {
                    bgTemplateMap.put(col.get(i).getId().toString(), col.get(i));
                }
            }
        }
        return bgTemplateMap;
    }

    protected List<String[]> antiDispatchBgTemplate(Context ctx, BgSchemeInfo bgSchemeInfo, BgAnalysRptTemplateInfo bgTemplateInfo, List<String> orgUnitIds, Map<String, FullOrgUnitInfo> orgUnitMap, String treeID) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeInfo == null || bgTemplateInfo == null || orgUnitIds == null || orgUnitIds.isEmpty()) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        String _bgTemplateId = bgTemplateInfo.getId().toString();
        String _orgUnitId = null;
        Object entry = null;
        FullOrgUnitInfo orgUnit = null;
        ArrayList<String[]> result = new ArrayList<String[]>();
        Set<BOSUuid> refByBgFormMap = BgAnalysRptDispatchUtils.dispatchCheckRefBgForm(ctx, bgSchemeInfo.getId(), bgTemplateInfo.getId(), orgUnitIds, treeID);
        HashSet refByBgForms = new HashSet();
        ArrayList<String[]> delOrgIds = new ArrayList<String[]>();
        ArrayList<String[]> delOrgTempIds = new ArrayList<String[]>();
        for (int i = 0; i < orgUnitIds.size(); ++i) {
            _orgUnitId = orgUnitIds.get(i);
            orgUnit = orgUnitMap.get(_orgUnitId);
            if (orgUnit == null) continue;
            if (treeID == null) {
                if (refByBgFormMap.contains(orgUnit.getId())) {
                    result.add(BgAnalysRptDispatchUtils.getDispatchResult(bgTemplateInfo, (OrgUnitInfo)orgUnit, false, BgSchemeDispatchConstants.ANTIDISPATCH_FAIL_REFREPORT));
                    continue;
                }
                delOrgIds.add(new String[]{_bgTemplateId, _orgUnitId});
                result.add(BgAnalysRptDispatchUtils.getDispatchResult(bgTemplateInfo, (OrgUnitInfo)orgUnit, true, null));
                continue;
            }
            if (refByBgFormMap.contains(orgUnit.getId())) {
                result.add(BgAnalysRptDispatchUtils.getDispatchResult(bgTemplateInfo, (OrgUnitInfo)orgUnit, false, BgSchemeDispatchConstants.ANTIDISPATCH_FAIL_REFREPORT));
                continue;
            }
            delOrgIds.add(new String[]{_bgTemplateId, _orgUnitId, treeID});
            delOrgTempIds.add(new String[]{_bgTemplateId, _orgUnitId});
            result.add(BgAnalysRptDispatchUtils.getDispatchResult(bgTemplateInfo, (OrgUnitInfo)orgUnit, true, null));
        }
        if (treeID == null) {
            DbUtil.executeBatch((Context)ctx, (String)"Delete From T_MBG_BgAnalysRptTemplateNode Where FBgAnalysRptTemplateID = ? AND FOrgUnitId = ?", delOrgIds);
        } else {
            DbUtil.executeBatch((Context)ctx, (String)"Delete From T_MBG_BgAnalysRptTemplateNode Where FBgAnalysRptTemplateID = ? AND FOrgUnitId = ? AND FTreeID = ? ", delOrgIds);
            DbUtil.executeBatch((Context)ctx, (String)"Delete From T_MBG_BgAnalysRptTemplateNode Where FBgAnalysRptTemplateID = ? AND FOrgUnitId = ? AND FTreeID is null ", delOrgTempIds);
        }
        return result;
    }
}

