/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesUtil;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgAnalysRptTemplateCollection;
import com.kingdee.eas.ma.mbg.BgAnalysRptTemplateInfo;
import com.kingdee.eas.ma.mbg.BgAnalysRptTemplateNodeFactory;
import com.kingdee.eas.ma.mbg.BgDynIndexFactory;
import com.kingdee.eas.ma.mbg.BgFetchIndexFactory;
import com.kingdee.eas.ma.mbg.BgNFormException;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgTemplateException;
import com.kingdee.eas.ma.mbg.BgTemplateStatusEnum;
import com.kingdee.eas.ma.mbg.BgTypeInfo;
import com.kingdee.eas.ma.mbg.app.AbstractBgAnalysRptTemplateControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgAnalysRptTemplateControllerBean
extends AbstractBgAnalysRptTemplateControllerBean {
    private static final long serialVersionUID = -2103303233836596411L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgAnalysRptTemplateControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgAnalysRptTemplateInfo templateInfo = (BgAnalysRptTemplateInfo)model;
        if (templateInfo.getCU() == null) {
            templateInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        if (templateInfo.getRootId() == null) {
            if (templateInfo.getId() != null) {
                BOSUuid rootId = templateInfo.getId();
                templateInfo.setRootId(rootId);
            } else {
                BOSUuid id = BOSUuid.create((BOSObjectType)templateInfo.getBOSType());
                templateInfo.setId(id);
                templateInfo.setRootId(id);
            }
        }
        String number = templateInfo.getNumber();
        String orgUnitId = templateInfo.getOrgUnit().getId().toString();
        number = templateInfo.getNumber();
        if (this._checkNumberDup(ctx, templateInfo.getBgScheme().getId().toString(), number, "", orgUnitId)) {
            logger.error((Object)("BgTemplate._addnew [orgUnitId:" + orgUnitId + " number:" + number + "]"));
            throw new BgTemplateException(BgTemplateException.NUMBERDUP);
        }
        if (number.indexOf("(") >= 0 || number.indexOf(")") >= 0) {
            throw new BgNFormException(BgNFormException.NUMBERERROR);
        }
        String name = templateInfo.getName();
        if (name.indexOf("/") >= 0 || name.indexOf("\\") >= 0) {
            throw new BgNFormException(BgNFormException.NAMEERROR);
        }
        templateInfo.setNumber(number.trim());
        templateInfo.setName(name.trim());
        BgAnalysRptTemplateInfo coreInfo = templateInfo;
        IObjectPK pk = super._addnew(ctx, (IObjectValue)coreInfo);
        BgAnalysRptTemplateNodeFactory.getLocalInstance(ctx).addNew(templateInfo);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BgAnalysRptTemplateInfo info = (BgAnalysRptTemplateInfo)model;
        if (info == null || StringUtils.isEmpty((String)info.getNumber())) {
            return;
        }
        String number = info.getNumber();
        String bgSchemeId = info.getBgScheme().getId().toString();
        String orgId = info.getOrgUnit().getId().toString();
        String oql = null;
        oql = info.getId() == null ? "select id where number = '" + number + "' and bgScheme.id = '" + bgSchemeId + "' and orgUnit.id = '" + orgId + "' " : "select id where number = '" + number + "' and bgScheme.id = '" + bgSchemeId + "' and orgUnit.id = '" + orgId + "' and id <> '" + info.getId().toString() + "'";
        if (this._exists(ctx, oql)) {
            throw new BgTemplateException(BgTemplateException.NUMBERDUP);
        }
        super._update(ctx, pk, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected boolean _checkNumberDup(Context ctx, String bgSchemeId, String number, String id, String orgUnitId) throws BOSException {
        PreparedStatement sm;
        Connection connection;
        ResultSet rs;
        block6: {
            boolean bl;
            rs = null;
            connection = null;
            sm = null;
            StringBuffer sql = new StringBuffer(60);
            sql.append(" select t1.fid from T_MBG_BgAnalysRptTemplate t1, T_MBG_BgAnalysRptTemplateNode t2 where t1.FID = t2.FBgAnalysRptTemplateID AND t1.fnumber = ? and t2.forgunitid = ? and t1.FBgSchemeId = ?");
            if (!StringUtils.isEmpty((String)id)) {
                sql.append(" and t1.fid <> ?");
            }
            try {
                connection = this.getConnection(ctx);
                sm = connection.prepareStatement(sql.toString());
                sm.setString(1, number);
                sm.setString(2, orgUnitId);
                sm.setString(3, bgSchemeId);
                if (!StringUtils.isEmpty((String)id)) {
                    sm.setString(4, id);
                }
                if (!(rs = sm.executeQuery()).next()) break block6;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, sm, (Connection)connection);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return false;
    }

    @Override
    protected String[] _cancel(Context ctx, String parentBgOrgUnitId, Map idList, Map openId, Set orgPermIds) throws BOSException, EASBizException {
        return this.doBatchCancelOrCancelCancel(ctx, parentBgOrgUnitId, idList, openId, orgPermIds, true);
    }

    @Override
    protected String[] _cancelCancel(Context ctx, String parentBgOrgUnitId, Map idList, Map openId, Set orgPermIds) throws BOSException, EASBizException {
        return this.doBatchCancelOrCancelCancel(ctx, parentBgOrgUnitId, idList, openId, orgPermIds, false);
    }

    private String[] doBatchCancelOrCancelCancel(Context ctx, String parentBgOrgUnitId, Map<String, Set<String>> idList, Map openId, Set orgPermIds, boolean isCancel) throws BOSException, EASBizException {
        String[] stringArray;
        HashSet<String> orgIds;
        HashMap notPermOrg;
        HashMap notCreateOrg;
        LinkedHashMap<String, String> templateNumber;
        int totalCount;
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block32: {
            HashSet<String> orgSet;
            if (idList == null || idList.isEmpty()) {
                return null;
            }
            conn = null;
            pstmt = null;
            rst = null;
            totalCount = 0;
            Map<String, Boolean> virtualOrgMap = this.getVirtualOrgMap(ctx, parentBgOrgUnitId, idList);
            conn = this.getConnection(ctx);
            HashMap<String, String> templateCreateOrg = new HashMap<String, String>();
            templateNumber = new LinkedHashMap<String, String>();
            StringBuffer sql = new StringBuffer();
            sql.append("Select FID, FNumber, FOrgUnitId From T_MBG_BgAnalysRptTemplate Where FID IN (");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(") Order By FNumber");
            List paramList = MbgSqlHelper.getBatchParams(null, (Object[])idList.keySet().toArray(), (int)50);
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < paramList.size(); ++i) {
                MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])paramList.get(i)));
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    templateCreateOrg.put(rst.getString("FID"), rst.getString("FOrgUnitId"));
                    templateNumber.put(rst.getString("FID"), rst.getString("FNumber"));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup((Statement)pstmt);
            HashSet<String> topTempIds = new HashSet<String>();
            notCreateOrg = new HashMap();
            notPermOrg = new HashMap();
            orgIds = new HashSet<String>();
            for (String bgTemplateId : new HashSet<String>(idList.keySet())) {
                String orgUnitId = (String)templateCreateOrg.get(bgTemplateId);
                if (idList.get(bgTemplateId).contains(orgUnitId) && Boolean.FALSE.equals(virtualOrgMap.get(orgUnitId)) && orgPermIds.contains(orgUnitId)) {
                    topTempIds.add(bgTemplateId);
                }
                orgIds.addAll((Collection<String>)idList.get(bgTemplateId));
                totalCount += idList.get(bgTemplateId).size();
                if (Boolean.FALSE.equals(virtualOrgMap.get(orgUnitId))) {
                    if (orgPermIds.contains(orgUnitId)) {
                        if (!idList.get(bgTemplateId).contains(orgUnitId)) {
                            if (!notCreateOrg.containsKey(bgTemplateId)) {
                                notCreateOrg.put(bgTemplateId, new HashSet());
                            }
                            orgSet = new HashSet();
                            for (String orgid : idList.get(bgTemplateId)) {
                                if (orgUnitId.equals(orgid)) continue;
                                orgSet.add(orgid);
                            }
                            ((Set)notCreateOrg.get(bgTemplateId)).addAll(orgSet);
                        } else {
                            idList.get(bgTemplateId).remove(orgUnitId);
                        }
                    } else {
                        if (!notPermOrg.containsKey(bgTemplateId)) {
                            notPermOrg.put(bgTemplateId, new HashSet());
                        }
                        orgSet = new HashSet<String>();
                        for (String orgid : idList.get(bgTemplateId)) {
                            orgSet.add(orgid);
                        }
                        ((Set)notPermOrg.get(bgTemplateId)).addAll(orgSet);
                        idList.get(bgTemplateId).remove(orgUnitId);
                    }
                } else if (orgPermIds.contains(orgUnitId)) {
                    if (!idList.get(bgTemplateId).contains(orgUnitId)) {
                        if (!notCreateOrg.containsKey(bgTemplateId)) {
                            notCreateOrg.put(bgTemplateId, new HashSet());
                        }
                        orgSet = new HashSet();
                        for (String orgid : idList.get(bgTemplateId)) {
                            if (orgUnitId.equals(orgid)) continue;
                            orgSet.add(orgid);
                        }
                        ((Set)notCreateOrg.get(bgTemplateId)).addAll(orgSet);
                    }
                } else {
                    if (!notPermOrg.containsKey(bgTemplateId)) {
                        notPermOrg.put(bgTemplateId, new HashSet());
                    }
                    orgSet = new HashSet();
                    for (String orgid : idList.get(bgTemplateId)) {
                        orgSet.add(orgid);
                    }
                    ((Set)notPermOrg.get(bgTemplateId)).addAll(orgSet);
                }
                if (!idList.get(bgTemplateId).isEmpty()) continue;
                idList.remove(bgTemplateId);
            }
            HashSet editIds = new HashSet();
            if (!topTempIds.isEmpty()) {
                // empty if block
            }
            if (!topTempIds.isEmpty()) {
                MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBG_BgAnalysRptTemplate Set FTemplateStatus = " + (isCancel ? 10 : 0) + " Where FID = ?"), new ArrayList(topTempIds));
            }
            if (!notCreateOrg.isEmpty() || !idList.isEmpty() || !notPermOrg.isEmpty()) break block32;
            orgSet = null;
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            return orgSet;
        }
        try {
            Map<String, String> orgMap = this.getOrgMap(ctx, conn, orgIds);
            int failCount = 0;
            String key = isCancel ? "cancel." : "cancelCancel.";
            String msgNoCreate = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateResource", (String)(key + "noCreate"), (Locale)ctx.getLocale());
            String msgPerm = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateResource", (String)(key + "noPermOrg"), (Locale)ctx.getLocale());
            String msgFormat = null;
            StringBuffer msg = new StringBuffer();
            for (String bgTemplateId : templateNumber.keySet()) {
                for (String orgUnitId : orgMap.keySet()) {
                    msgFormat = notPermOrg.containsKey(bgTemplateId) && ((Set)notPermOrg.get(bgTemplateId)).contains(orgUnitId) ? msgPerm : (notCreateOrg.containsKey(bgTemplateId) && ((Set)notCreateOrg.get(bgTemplateId)).contains(orgUnitId) ? msgNoCreate : null);
                    if (msgFormat == null) continue;
                    ++failCount;
                    if (msg.length() > 0) {
                        msg.append("\r\n");
                    }
                    msg.append(MessageFormat.format(msgFormat, orgMap.get(orgUnitId), templateNumber.get(bgTemplateId)));
                }
            }
            String info = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateResource", (String)(key + "msg"), (Locale)ctx.getLocale()), totalCount, failCount, totalCount - failCount);
            stringArray = new String[]{info, msg.toString()};
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return stringArray;
    }

    private Map<String, Boolean> getVirtualOrgMap(Context ctx, String parentBgOrgUnitId, Map<String, Set<String>> _ids) throws BOSException, EASBizException {
        HashSet orgUnitIds = new HashSet();
        Iterator<Set<String>> it = _ids.values().iterator();
        while (it.hasNext()) {
            orgUnitIds.addAll(it.next());
        }
        return BgOrgUnitFactory.getLocalInstance(ctx).getOrgVirtualInfo(parentBgOrgUnitId, orgUnitIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getOrgMap(Context ctx, Connection conn, Set<String> orgIds) throws SQLException {
        LinkedHashMap<String, String> orgMap = new LinkedHashMap<String, String>();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("Select FID, FName_").append(ctx.getLocale()).append(" FName FROM T_Org_BaseUnit Where FID IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(") Order By FNumber");
            List params = MbgSqlHelper.getBatchParams(null, (Object[])orgIds.toArray(), (int)50);
            pstmt = conn.prepareStatement(sql.toString());
            orgMap.clear();
            for (int i = 0; i < params.size(); ++i) {
                MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])params.get(i)));
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    orgMap.put(rst.getString("FID"), rst.getString("FName"));
                }
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, pstmt);
            throw throwable;
        }
        SQLUtils.cleanup(rst, (Statement)pstmt);
        return orgMap;
    }

    public static SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("bgScheme.id"));
        sic.add(new SelectorItemInfo("root.id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("templateStatus"));
        sic.add(new SelectorItemInfo("bgType.*"));
        sic.add(new SelectorItemInfo("wordAttachId"));
        return sic;
    }

    @Override
    protected void _clone(Context ctx, IObjectPK bgTemplatePK, BOSUuid orgUnitId) throws BOSException, EASBizException {
        if (orgUnitId == null || bgTemplatePK == null) {
            return;
        }
        SelectorItemCollection sic = BgAnalysRptTemplateControllerBean.getSelector();
        BgAnalysRptTemplateInfo info = this.getBgAnalysRptTemplateInfo(ctx, bgTemplatePK, sic);
        BgAnalysRptTemplateInfo cloneInfo = (BgAnalysRptTemplateInfo)info.clone();
        cloneInfo.remove("id");
        cloneInfo.setOrgUnit(new FullOrgUnitInfo());
        cloneInfo.getOrgUnit().setId(orgUnitId);
        cloneInfo.setTemplateStatus(BgTemplateStatusEnum.CANCEL_CANCEL);
        if (ContextUtil.getCurrentUserInfo((Context)ctx) != null) {
            cloneInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            cloneInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        }
        cloneInfo.setNumber("clone_" + cloneInfo.getNumber());
        cloneInfo.setName(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgSchemeResource", (String)"clone", (Locale)ctx.getLocale()) + "_" + cloneInfo.getName());
        if (cloneInfo.getNumber().length() > 80) {
            throw new BgTemplateException(BgTemplateException.NUMBERTOOLONG);
        }
        if (cloneInfo.getName().length() > 255) {
            throw new BgTemplateException(BgTemplateException.NAMETOOLONG);
        }
        if (this._checkNumberDup(ctx, cloneInfo.getBgScheme().getId().toString(), cloneInfo.getNumber(), "", cloneInfo.getOrgUnit().getId().toString())) {
            throw new BgTemplateException(BgTemplateException.NUMBERDUP);
        }
        IObjectPK pk = super._save(ctx, (IObjectValue)cloneInfo);
    }

    @Override
    protected boolean _updateWordId(Context ctx, String templateId, String wordId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_MBG_BgAnalysRptTemplate set FWordAttachId=?,FLastUpdateUserID=?,FLastUpdateTime=? where fid=? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{wordId, ctx.getCaller().toString(), ReportNotesUtil.getTime(), templateId});
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        String[] attachIds = asm.getAttachmentIDsByBoID(templateId);
        if (attachIds != null) {
            IBoAttchAsso iBoAttchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx);
            for (String attachId : attachIds) {
                if (wordId.equals(attachId)) continue;
                iBoAttchAsso.deleteOneAssociation(templateId, attachId);
            }
        }
        return true;
    }

    @Override
    protected String[] _delete(Context ctx, String parentBgOrgUnitId, Map ids, Map openId, Set orgPermIds) throws BOSException, EASBizException {
        String[] stringArray;
        String bgTemplateId2;
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        HashSet<String> openIdS;
        Map<Object, Object> orgMap;
        LinkedHashMap<String, String> bgTemplateMap;
        HashMap permOrgMap;
        HashMap virtualOrgMap;
        HashMap<String, String> dispatchedMap;
        HashMap refMap;
        int failCount;
        int totalCount;
        block29: {
            Iterator itOrg;
            Set orgUnitIds;
            if (ids == null || ids.isEmpty()) {
                return null;
            }
            Map _ids = ids;
            totalCount = 0;
            failCount = 0;
            refMap = new HashMap();
            dispatchedMap = new HashMap<String, String>();
            virtualOrgMap = new HashMap();
            permOrgMap = new HashMap();
            bgTemplateMap = new LinkedHashMap<String, String>();
            orgMap = new LinkedHashMap();
            HashSet<IObjectPK> deletePks = new HashSet<IObjectPK>();
            openIdS = new HashSet<String>();
            conn = null;
            pstmt = null;
            rst = null;
            StringBuffer sql = new StringBuffer();
            for (String bgTemplateId2 : _ids.keySet()) {
                orgUnitIds = (Set)_ids.get(bgTemplateId2);
                totalCount += orgUnitIds.size();
                if (!openId.containsKey(bgTemplateId2)) continue;
                failCount += orgUnitIds.size();
                openIdS.add(bgTemplateId2);
                ((Set)_ids.get(bgTemplateId2)).clear();
            }
            Map<String, Boolean> virtualMap = this.getVirtualOrgMap(ctx, parentBgOrgUnitId, _ids);
            for (String bgTemplateId2 : _ids.keySet()) {
                orgUnitIds = (Set)_ids.get(bgTemplateId2);
                itOrg = orgUnitIds.iterator();
                while (itOrg.hasNext()) {
                    String string = (String)itOrg.next();
                    if (!Boolean.TRUE.equals(virtualMap.get(string))) continue;
                    itOrg.remove();
                    if (!virtualOrgMap.containsKey(bgTemplateId2)) {
                        virtualOrgMap.put(bgTemplateId2, new HashSet());
                    }
                    ((Set)virtualOrgMap.get(bgTemplateId2)).add(string);
                    orgMap.put(string, null);
                }
            }
            for (String bgTemplateId2 : _ids.keySet()) {
                orgUnitIds = (Set)_ids.get(bgTemplateId2);
                itOrg = orgUnitIds.iterator();
                while (itOrg.hasNext()) {
                    String string = (String)itOrg.next();
                    if (orgPermIds.contains(string)) continue;
                    itOrg.remove();
                    if (!permOrgMap.containsKey(bgTemplateId2)) {
                        permOrgMap.put(bgTemplateId2, new HashSet());
                    }
                    ((Set)permOrgMap.get(bgTemplateId2)).add(string);
                    orgMap.put(string, null);
                }
            }
            conn = this.getConnection(ctx);
            List<Object[]> params = new ArrayList();
            for (Map.Entry entry : _ids.entrySet()) {
                if (((Set)entry.getValue()).isEmpty()) continue;
                params.addAll(MbgSqlHelper.getBatchParams((Object[])new Object[]{entry.getKey()}, (Object[])((Set)entry.getValue()).toArray(), (int)50));
            }
            sql.setLength(0);
            sql.append("Select FBgTemplateID, FOrgUnitID FROM T_MBG_BgAnalysReport Where FBgTemplateID = ? And FOrgUnitID IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < params.size(); ++i) {
                MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])params.get(i)));
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgTemplateId2 = rst.getString("FBgTemplateID");
                    String string = rst.getString("FOrgUnitID");
                    orgMap.put(string, null);
                    ((Set)_ids.get(bgTemplateId2)).remove(string);
                    if (!refMap.containsKey(bgTemplateId2)) {
                        refMap.put(bgTemplateId2, new HashSet());
                    }
                    ((Set)refMap.get(bgTemplateId2)).add(string);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup((Statement)pstmt);
            sql.setLength(0);
            sql.append("Select bgTemplate.FNumber, bgTemplate.FID, bgTemplate.FOrgUnitId, Count(tempNode.FID) FTemplateCount FROM T_MBG_BgAnalysRptTemplate bgTemplate Left Join T_MBG_BgAnalysRptTemplateNode tempNode On bgTemplate.FID = tempNode.FBgAnalysRptTemplateID Where bgTemplate.FID IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(") Group By bgTemplate.FNumber, bgTemplate.FID, bgTemplate.FOrgUnitId");
            params = MbgSqlHelper.getBatchParams(null, (Object[])_ids.keySet().toArray(), (int)50);
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < params.size(); ++i) {
                MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])params.get(i)));
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgTemplateId2 = rst.getString("FID");
                    String string = rst.getString("FOrgUnitId");
                    int count = rst.getInt("FTemplateCount");
                    bgTemplateMap.put(bgTemplateId2, rst.getString("FNumber"));
                    if (!((Set)_ids.get(bgTemplateId2)).contains(string)) continue;
                    if (((Set)_ids.get(bgTemplateId2)).size() == count) {
                        deletePks.add((IObjectPK)new ObjectStringPK(bgTemplateId2));
                        continue;
                    }
                    dispatchedMap.put(bgTemplateId2, string);
                    ((Set)_ids.get(bgTemplateId2)).remove(string);
                    orgMap.put(string, null);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup((Statement)pstmt);
            params.clear();
            for (String bgTemplateId2 : _ids.keySet()) {
                for (String string : (Set)_ids.get(bgTemplateId2)) {
                    params.add(new Object[]{bgTemplateId2, string});
                }
            }
            if (!params.isEmpty()) {
                MbgSqlHelper.executeBatch((Connection)conn, (String)"Delete From T_MBG_BgAnalysRptTemplateNode Where FBgAnalysRptTemplateID = ? AND FOrgUnitId = ?", params);
            }
            if (!deletePks.isEmpty()) {
                this._delete(ctx, deletePks.toArray(new IObjectPK[0]));
                this.afterDeleteTemplate(ctx, deletePks);
            }
            if (!orgMap.isEmpty() || !openIdS.isEmpty()) break block29;
            String[] it = new String[]{ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource", (String)"deleteSuccess", (Locale)ctx.getLocale())};
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            return it;
        }
        try {
            orgMap = this.getOrgMap(ctx, conn, orgMap.keySet());
            String msgRefForm = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource", (String)"checkRefByForm", (Locale)ctx.getLocale());
            String msgDispatched = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource", (String)"checkDispatched", (Locale)ctx.getLocale());
            String msgVirtual = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource", (String)"checkVirtual", (Locale)ctx.getLocale());
            String msgPerm = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource", (String)"noDeletePermOrg", (Locale)ctx.getLocale());
            String msgOpen = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource", (String)"checkOpen", (Locale)ctx.getLocale());
            String msgFormat = null;
            StringBuffer msg = new StringBuffer();
            for (Map.Entry entry : bgTemplateMap.entrySet()) {
                bgTemplateId2 = (String)entry.getKey();
                if (openIdS.contains(bgTemplateId2)) {
                    if (msg.length() > 0) {
                        msg.append("\r\n");
                    }
                    msg.append(MessageFormat.format(msgOpen, entry.getValue()));
                    continue;
                }
                for (String string : orgMap.keySet()) {
                    msgFormat = virtualOrgMap.containsKey(bgTemplateId2) && ((Set)virtualOrgMap.get(bgTemplateId2)).contains(string) ? msgVirtual : (permOrgMap.containsKey(bgTemplateId2) && ((Set)permOrgMap.get(bgTemplateId2)).contains(string) ? msgPerm : (refMap.containsKey(bgTemplateId2) && ((Set)refMap.get(bgTemplateId2)).contains(string) ? msgRefForm : (string.equals(dispatchedMap.get(bgTemplateId2)) ? msgDispatched : null)));
                    if (msgFormat == null) continue;
                    ++failCount;
                    if (msg.length() > 0) {
                        msg.append("\r\n");
                    }
                    msg.append(MessageFormat.format(msgFormat, orgMap.get(string), entry.getValue()));
                }
            }
            String info = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource", (String)"deleteMsg", (Locale)ctx.getLocale()), totalCount, failCount, totalCount - failCount);
            stringArray = new String[]{info, msg.toString()};
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return stringArray;
    }

    private void afterDeleteTemplate(Context ctx, Set<IObjectPK> deletePks) throws BOSException, EASBizException, SQLException {
        if (deletePks.size() == 0 || deletePks == null) {
            return;
        }
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Object[] param = null;
        for (IObjectPK iPk : deletePks) {
            asm.deleteAttachemtsByBoID(iPk.toString());
            param = new Object[]{iPk.toString()};
            params.add(param);
        }
        String sql = "Delete FROM T_MBG_BgAnalysRefIndex Where FRefId = ?";
        BgDBUtils.executeBatch((Context)ctx, (String)sql, params);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IObjectCollection _getRptTemplateColls(Context ctx, BOSUuid bgSchemeId, String orgId, boolean isDisplayForbidTemp) throws BOSException, EASBizException {
        BgAnalysRptTemplateCollection bgTemplateCol = new BgAnalysRptTemplateCollection();
        if (bgSchemeId == null) {
            return bgTemplateCol;
        }
        BgAnalysRptTemplateInfo bgTemplateInfo = null;
        UserInfo userInfo = null;
        String bgTypeId = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        if (orgId == null) {
            sql.append("select t.FID AS FID, t.FName_").append(ctx.getLocale()).append(" AS FName, t.FNumber AS FNumber, t.FRootID AS FRootID, t.FBgTypeId AS FBgTypeId,t.FLastUpdateTime AS FCreateTime,u.FId AS FCreatorID ,u.FName_").append(ctx.getLocale()).append(" AS FCreatorName, t.FTemplateStatus from T_MBG_BgAnalysRptTemplate t left join T_PM_User u on t.FLastUpdateUserID  = u.FId where t.FBgSchemeId = ? ");
            if (!isDisplayForbidTemp) {
                sql.append(" and t.FTemplateStatus = 0");
            }
            sql.append(" and (t.FBgTypeID is null or t.FBgTypeID <> 'bgMAAAAKIcA7rHKd') ");
        } else {
            sql.append("select t1.FID AS FID, t1.FName_").append(ctx.getLocale()).append(" AS FName, t1.FNumber AS FNumber, t1.FRootID AS FRootID,  t1.FBgTypeId AS FBgTypeId ,t1.FLastUpdateTime AS FCreateTime,u.FID AS FCreatorID,u.FName_").append(ctx.getLocale()).append(" AS FCreatorName, t.FTemplateStatus from T_MBG_BgAnalysRptTemplate t1 left join T_MBG_BgAnalysRptTemplateNode t2 on t1.FID = t2.FBgAnalysRptTemplateID").append(" left join T_PM_User u on u.FID = t1.FLastUpdateUserID where t1.FBgSchemeId = ? ");
            sql.append(" and t2.FOrgUnitId = ? ");
            if (!isDisplayForbidTemp) {
                sql.append(" and t1.FTemplateStatus = 0");
            }
            sql.append(" and (t1.FBgTypeID is null or t1.FBgTypeID <> 'bgMAAAAKIcA7rHKd') ");
        }
        sql.append(" order by FNumber ");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgSchemeId.toString());
            if (orgId != null) {
                pstmt.setString(2, orgId);
            }
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgTemplateInfo = new BgAnalysRptTemplateInfo();
                bgTemplateInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgTemplateInfo.setName(rst.getString("FName"));
                bgTemplateInfo.setNumber(rst.getString("FNumber"));
                bgTemplateInfo.setRootId(BOSUuid.read((String)rst.getString("FRootID")));
                bgTemplateInfo.setLastUpdateTime(rst.getTimestamp("FCreateTime"));
                userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)rst.getString("FCreatorID")));
                userInfo.setName(rst.getString("FCreatorName"));
                bgTemplateInfo.setLastUpdateUser(userInfo);
                bgTemplateInfo.setTemplateStatus(BgTemplateStatusEnum.getEnum(rst.getInt("FTemplateStatus")));
                bgTypeId = rst.getString("FBgTypeId");
                if (!StringUtils.isEmpty((String)bgTypeId)) {
                    bgTemplateInfo.setBgType(new BgTypeInfo());
                    bgTemplateInfo.getBgType().setId(BOSUuid.read((String)bgTypeId));
                }
                bgTemplateCol.add(bgTemplateInfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgTemplateCol;
    }

    @Override
    protected void _saveRef(Context ctx, String schemeID, int refType, String refId, Set fetchIndexs, Set dynIndexs) throws BOSException, EASBizException {
        int i;
        AbstractObjectCollection colls;
        if (ctx == null || StringUtils.isEmpty((String)schemeID) || StringUtils.isEmpty((String)refId)) {
            return;
        }
        if ((fetchIndexs == null || fetchIndexs.isEmpty()) && (dynIndexs == null || dynIndexs.isEmpty())) {
            DbUtil.execute((Context)ctx, (String)"Delete FROM T_MBG_BgAnalysRefIndex Where FRefId = ? and FRefType = ?", (Object[])new Object[]{refId, refType});
            return;
        }
        EntityViewInfo view = null;
        ArrayList<String[]> baseDatas = new ArrayList<String[]>();
        String[] param = null;
        if (fetchIndexs != null && !fetchIndexs.isEmpty()) {
            view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("bgscheme.id", (Object)schemeID, CompareType.EQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("name", (Object)fetchIndexs, CompareType.INCLUDE));
            colls = BgFetchIndexFactory.getLocalInstance(ctx).getBgFetchIndexCollection(view);
            for (i = 0; i < colls.size(); ++i) {
                param = new String[]{colls.get(i).getId().toString()};
                baseDatas.add(param);
            }
        }
        if (dynIndexs != null && !dynIndexs.isEmpty()) {
            view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)schemeID, CompareType.EQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("name", (Object)dynIndexs, CompareType.INCLUDE));
            colls = BgDynIndexFactory.getLocalInstance(ctx).getBgDynIndexCollection(view);
            for (i = 0; i < colls.size(); ++i) {
                param = new String[]{colls.get(i).getId().toString()};
                baseDatas.add(param);
            }
        }
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tmpTable = null;
        try {
            tmpTable = pool.createTempTable("Create Table TMP_MBG_REFINDEX(FBaseDataID Varchar(44) NOT NULL)");
            DbUtil.executeBatch((Context)ctx, (String)("Insert Into " + tmpTable + "(FBaseDataID) Values(?)"), baseDatas);
            DbUtil.execute((Context)ctx, (String)("Update T_MBG_BgAnalysRefIndex t1 Set FRefType = -1 Where FRefId = ? AND FRefType = ? And NOT EXISTS (Select t2.FBaseDataId FROM " + tmpTable + " t2 Where t1.FBaseDataId = t2.FBaseDataId )"), (Object[])new Object[]{refId, refType});
            DbUtil.execute((Context)ctx, (String)"Delete From T_MBG_BgAnalysRefIndex Where FRefType = -1");
            String sql = "Insert Into T_MBG_BgAnalysRefIndex( FBgSchemeID, FRefType, FRefID, FBaseDataID) Select  ?, ?, ?, FBaseDataID FROM " + tmpTable + " t1 Where NOT EXISTS(Select * FROM T_MBG_BgAnalysRefIndex t2 Where t1.FBaseDataID = t2.FBaseDataID and t2.FRefId = ? and t2.FRefType = ?)";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{schemeID, refType, refId, refId, refType});
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tmpTable != null) {
                pool.releaseTable(tmpTable);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _queryRef(Context ctx, String schemeId, String bosType) throws BOSException, EASBizException {
        HashMap returnMap = new HashMap();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        int refType = 0;
        sql.append("select FBaseDataID,FRefID,FRefType ").append("from T_MBG_BgAnalysRefIndex where FBgSchemeID = ?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, schemeId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                String baseId = rst.getString("FBaseDataID");
                String refId = rst.getString("FRefID");
                refType = rst.getInt("FRefType");
                if (returnMap.containsKey(baseId)) {
                    if (((Map)returnMap.get(baseId)).containsKey(refType)) {
                        ((Set)((Map)returnMap.get(baseId)).get(refType)).add(refId);
                        continue;
                    }
                    HashSet<String> set = new HashSet<String>();
                    set.add(refId);
                    ((Map)returnMap.get(baseId)).put(refType, set);
                    continue;
                }
                HashMap map = new HashMap();
                HashSet<String> set = new HashSet<String>();
                set.add(refId);
                map.put(refType, set);
                returnMap.put(baseId, map);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return returnMap;
    }
}

