/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.app.AbstractBgBaseDimensionControllerBean;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.IMbgDataQuery;
import com.kingdee.eas.ma.mbg.cube.MbgDataQueryAgent;
import com.kingdee.eas.ma.mbg.cube.impl.CubeManager;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public abstract class BgBaseDimensionControllerBean
extends AbstractBgBaseDimensionControllerBean {
    private static final long serialVersionUID = 8915887797674833861L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgBaseDimensionControllerBean");
    private long startTime = 0L;
    private long beginTime = 0L;

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public IMbgDataQuery getInstance(Context ctx) {
        IMbgDataQuery agent = null;
        String url = null;
        try {
            ORMServiceLocation loc = new ORMServiceLocation("MbgDataQuery");
            if (!loc.isLocal()) {
                url = loc.getServiceURL();
                if (url == null || url.trim().length() == 0) {
                    url = "tcp://localhost";
                }
                agent = (IMbgDataQuery)RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.eas.ma.mbg.cube.MbgDataQueryAgent", IMbgDataQuery.class, new Class[]{Context.class}, new Object[]{ctx});
            } else {
                agent = new MbgDataQueryAgent(ctx);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Invalidate config file! please make sure you have the config item about UserMonitor! Error url is: " + url), (Throwable)e);
        }
        return agent;
    }

    @Override
    protected Object _dimensionQuery(Context ctx, IDimensionParameter queryParameter) throws BOSException, EASBizException {
        IMbgDataQuery query = this.getInstance(ctx);
        if (query == null) {
            throw new EASBizException(EASBizException.CHECKBLANK);
        }
        return query.dimensionQuery(queryParameter);
    }

    @Override
    protected Object _dimensionControl(Context ctx, IDimensionParameter parameter) throws BOSException, EASBizException {
        if (ctx == null || parameter == null) {
            return null;
        }
        parameter.getControlManager().setControlData(true);
        return this._dimensionQuery(ctx, parameter);
    }

    @Override
    protected Object _dimensionUpdate(Context ctx, IDimensionParameter updateParameter) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _dimensionClosure(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected Object _dimensionClosure(Context ctx, IDimensionParameter closureParameter) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected boolean _dimensionClosure(Context ctx, Map dimensionData, Map itemData) throws BOSException, EASBizException {
        return true;
    }

    protected String outTime() {
        return "invoke process use = " + (System.currentTimeMillis() - this.getStartTime()) + " ms;";
    }

    protected String outTime(long startTime) {
        return "invoke process use = " + (System.currentTimeMillis() - startTime) + " ms;";
    }

    protected String endTime() {
        return "invoke interface process allUse = " + (System.currentTimeMillis() - this.getStartTime()) + " ms;";
    }

    @Override
    protected void _checkCube(Context ctx, BOSUuid bgSchemeId) throws BOSException, EASBizException {
        if (bgSchemeId == null) {
            return;
        }
        BgSchemeInfo root = BgViewServerHelper.getBgSchemeCubeInfo(ctx, bgSchemeId);
        if (root == null) {
            return;
        }
        List<String> refDims = BgCubeUtils.getRefDims(ctx, root, true);
        try {
            CubeManager.getInstance().getCubeFacade().checkCube(ctx, root.getRefCube(), refDims);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    protected void checkExceptionMessage(Exception ex) throws EASBizException {
        if (ex == null) {
            return;
        }
        String message = ex.getMessage();
        if (message.indexOf("can't find") >= 0 && message.indexOf("period") >= 0) {
            ArrayList<String> text = new ArrayList<String>();
            Pattern p = Pattern.compile("`\\w+.\\w+`");
            Matcher m = p.matcher(message);
            while (m.find()) {
                text.add(m.group());
            }
            Object[] objs = text.toArray();
            if (objs != null && objs.length > 1) {
                String member = (String)objs[1];
                if (member != null) {
                    member = member.substring(1, member.length() - 1);
                }
                throw new DimensionException(DimensionException.PERIODMEMBERNOFOUND, new Object[]{member});
            }
        }
        logger.error((Object)"dimension olapQuery Error!", (Throwable)ex);
        throw new DimensionException(DimensionException.MEMBERNOTFIND, new String[]{ex.getMessage()});
    }
}

