/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgAdjustFacadaFactory;
import com.kingdee.eas.ma.mbg.BgAuditIdeaEnum;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeCollection;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeEntryInfo;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeEntryTemplateInfo;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeFactory;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeInfo;
import com.kingdee.eas.ma.mbg.BgCalculateSchemePeriodInfo;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeReportFactory;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeReportInfo;
import com.kingdee.eas.ma.mbg.BgFinalizedResultEnum;
import com.kingdee.eas.ma.mbg.BgFinalizedResultFactory;
import com.kingdee.eas.ma.mbg.BgFinalizedResultInfo;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormDataSourceEnum;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgPastSourceEnum;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgReCalcSchemeHelper;
import com.kingdee.eas.ma.mbg.BgSchemeDispatchFacadeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgSchemeReCalcMsgObj;
import com.kingdee.eas.ma.mbg.BgSpecialItemsInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.IBgCalculateScheme;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.IBgFormFacade;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.app.AbstractBgCalculateSchemeFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.ReCalculateFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.data.MbgDataUtils;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgCalculateSchemeServerThread;
import com.kingdee.eas.ma.mbg.utils.BgFormDiversityData;
import com.kingdee.eas.ma.mbg.utils.BgFormHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDispatchConstants;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCalculateSchemeFacadeControllerBean
extends AbstractBgCalculateSchemeFacadeControllerBean {
    private static final long serialVersionUID = 2654835388755571666L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgCalculateSchemeFacadeControllerBean");
    private static final Color EDIT_COLOR = Color.YELLOW;
    private static final Color BASE_COLOR = new Color(255, 255, 255, 0);
    public static final BigDecimal ZERO = new BigDecimal("0");
    private static final int SCALE = 4;
    public static final String NULL = "NULL";
    public static final String lowerexistsamenumber = "lowerexistsamenumber";
    public static final String lowerparttempnotassign = "lowerparttempnotassign";
    public static final String lowerbgschemenottemp = "lowerbgschemenottemp";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object _reCalculate(Context ctx, Object param) throws BOSException, EASBizException {
        boolean isLeaf;
        ArrayList<Map> reportList = new ArrayList<Map>();
        if (!(param instanceof Map)) {
            return reportList;
        }
        Map paramMap = (Map)param;
        String orgId = (String)paramMap.get("org_id");
        String bgSchemeId = (String)paramMap.get("bgScheme_id");
        String bgTemplateId = (String)paramMap.get("bgTemplate_id");
        String bgPeriodId = (String)paramMap.get("bgPeriod_id");
        String currencyId = (String)paramMap.get("currency_id");
        String bgversionId = (String)paramMap.get("bgversion_id");
        String processNumbers = (String)paramMap.get("bgprocess_numbers");
        Boolean isCalculate = (Boolean)paramMap.get("isCalculate");
        List sheetIdList = (List)paramMap.get("sheetIdList");
        Boolean isMultiOrg = (Boolean)paramMap.get("isMultiOrg");
        Set selectOrgIds = (Set)paramMap.get("selectOrgIds");
        Set distributedOrgUnitId = (Set)paramMap.get("distributedOrgUnitId");
        Boolean isWriteReport = paramMap.get("is_write_report") instanceof Boolean ? (Boolean)paramMap.get("is_write_report") : Boolean.FALSE;
        HashSet<Integer> calcStates = new HashSet<Integer>();
        calcStates.add(1);
        calcStates.add(2);
        calcStates.add(42);
        if (paramMap.get("check_form_state") != null && paramMap.get("check_form_state") instanceof Set) {
            calcStates.addAll((Set)paramMap.get("check_form_state"));
        }
        if (!StringUtils.isEmpty((String)orgId) && StringUtils.isEmpty((String)bgSchemeId)) {
            FullOrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo("select id,name,number where id = '" + orgId + "'");
            reportList.add(this.createReport(ctx, orgUnitInfo, null, null, null, null, null, ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"recalcfailbyrecalcschemenotassigned", (Locale)this.getLocale(ctx)), isMultiOrg, selectOrgIds));
            this.saveCalcReport(ctx, paramMap, null, ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"recalcfailbyrecalcschemenotassigned", (Locale)this.getLocale(ctx)));
            return reportList;
        }
        if (StringUtils.isEmpty((String)orgId) || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)bgTemplateId) || StringUtils.isEmpty((String)bgPeriodId) || StringUtils.isEmpty((String)currencyId) || StringUtils.isEmpty((String)bgversionId)) {
            return reportList;
        }
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
        Set<String> childDistributedOrgUnitId = this.dealSelectOrgIds(ctx, distributedOrgUnitId, selectOrgIds, schemeHelper.getBgOrgViewId());
        HashMap tempVarMap = new HashMap();
        ArrayList<BgProcessEnum> processTypes = null;
        if (!StringUtils.isEmpty((String)processNumbers)) {
            String[] pNumbers;
            processTypes = new ArrayList<BgProcessEnum>();
            for (String p : pNumbers = processNumbers.replaceAll(" ", "").split(";")) {
                processTypes.add(BgProcessEnum.getEnum(p));
            }
            Collections.sort(processTypes);
        } else {
            processTypes = new ArrayList();
            processTypes.add(BgProcessEnum.C01);
            processTypes.add(BgProcessEnum.C02);
            processTypes.add(BgProcessEnum.C03);
            processTypes.add(BgProcessEnum.C04);
        }
        BgVersionInfo bgVersionInfo = BgVersionFactory.getLocalInstance((Context)ctx).getBgVersionInfo("select id,name,number,versionId where id = '" + bgversionId + "'");
        this.beforeCheckAdjust(ctx, bgSchemeId, selectOrgIds, childDistributedOrgUnitId, processTypes, bgVersionInfo);
        FullOrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo("select id,name,number where id = '" + orgId + "'");
        BgTemplateInfo bgTemplateInfo = BgTemplateFactory.getLocalInstance(ctx).getBgTemplateInfo("select id,name,number,formType where id = '" + bgTemplateId + "'");
        BgPeriodInfo bgPeriodInfo = BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodInfo("select id,name,number where id = '" + bgPeriodId + "'");
        BgFormCollection bgFormList = this.queryBgForm(ctx, orgId, bgSchemeId, bgTemplateId, bgPeriodId, currencyId, bgversionId, processTypes);
        ReCalculateFacadeControllerBean.sortSpecial(ctx, schemeHelper, bgFormList);
        BgSchemeInfo bgScheme = MbgDataHelper.getBgSchemeInfo(ctx, BOSUuid.read((String)bgSchemeId));
        BgFormInfo bgFormInfo = null;
        HashMap<String, BgFormCollection> bgFormMap = new HashMap<String, BgFormCollection>();
        for (int i = 0; i < bgFormList.size(); ++i) {
            bgFormInfo = bgFormList.get(i);
            if (bgFormInfo.getBgTemplate() == null) {
                bgFormInfo.setBgTemplate(bgTemplateInfo);
            }
            if (!bgFormMap.containsKey(bgFormInfo.getProcessType().getName())) {
                bgFormMap.put(bgFormInfo.getProcessType().getName(), new BgFormCollection());
            }
            ((BgFormCollection)((Object)bgFormMap.get(bgFormInfo.getProcessType().getName()))).add(bgFormInfo);
        }
        String bgformnotexist = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"bgformnotexist", (Locale)this.getLocale(ctx));
        if (bgFormList.isEmpty()) {
            Map report = this.createReport(ctx, orgUnitInfo, bgTemplateInfo, bgPeriodInfo, bgVersionInfo, null, null, bgformnotexist, isMultiOrg, selectOrgIds);
            if (report != null) {
                reportList.add(report);
            }
            this.saveCalcReport(ctx, paramMap, null, bgformnotexist);
            return reportList;
        }
        boolean bl = isLeaf = !BgOrgUnitFactory.getLocalInstance(ctx).exists("where viewId = '" + schemeHelper.getBgOrgViewId() + "' and isVirtual = 0 and isLeaf = 0 and orgUnitId = '" + orgId + "'");
        if (BgProcessEnum.C01.getName().equals(processNumbers) && (BgTemFormTypeEnum.VIEWFORM.equals((Object)bgTemplateInfo.getFormType()) || BgTemFormTypeEnum.VIEWLIST.equals((Object)bgTemplateInfo.getFormType())) && !isLeaf && bgFormInfo != null) {
            reportList.add(this.createReport(ctx, orgUnitInfo, bgTemplateInfo, bgPeriodInfo, bgVersionInfo, bgFormInfo.getProcessType(), bgFormInfo, ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"viewsuccess", (Locale)this.getLocale(ctx)), isMultiOrg, selectOrgIds));
            this.saveCalcReport(ctx, paramMap, bgFormInfo, ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"viewsuccess", (Locale)this.getLocale(ctx)));
            return reportList;
        }
        String fail = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"fail", (Locale)this.getLocale(ctx));
        IBgFormFacade iBgFormFacade = BgFormFacadeFactory.getLocalInstance(ctx);
        IReport iReport = ReportFactory.getLocalInstance((Context)ctx);
        HashMap adjustMap = null;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        ArrayList bgFormIds = new ArrayList();
        BOSUuid ctrlUnitId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId();
        HashMap adjustExpressionMap = new HashMap();
        Object[] changSign = new Object[]{Boolean.FALSE, Boolean.FALSE};
        HashMap checkMap = new HashMap();
        DimensionCacheHelper cacheHelper = new DimensionCacheHelper(ctx);
        StringBuffer editScen = new StringBuffer();
        for (String scen : cacheHelper.getBudgetScens()) {
            if (editScen.length() > 0) {
                editScen.append(",");
            }
            editScen.append(scen);
        }
        SelectorItemCollection updatePartSic = new SelectorItemCollection();
        updatePartSic.add("data");
        updatePartSic.add("lastUpdateTime");
        updatePartSic.add("lastUpdateUser.id");
        for (int p = 0; p < processTypes.size(); ++p) {
            bgFormList = (BgFormCollection)((Object)bgFormMap.get(((BgProcessEnum)((Object)processTypes.get(p))).getName()));
            if (bgFormList == null || bgFormList.isEmpty()) {
                reportList.add(this.createReport(ctx, orgUnitInfo, bgTemplateInfo, bgPeriodInfo, bgVersionInfo, (BgProcessEnum)((Object)processTypes.get(p)), null, bgformnotexist, isMultiOrg, selectOrgIds));
                this.saveCalcReport(ctx, paramMap, null, bgformnotexist);
                continue;
            }
            int size = bgFormList.size();
            for (int i = 0; i < size; ++i) {
                try {
                    bgFormInfo = bgFormList.get(i);
                    if (!this.checkBgFormState(ctx, bgFormInfo, reportList, orgUnitInfo, bgTemplateInfo, bgPeriodInfo, bgVersionInfo, isMultiOrg, selectOrgIds, calcStates)) {
                        this.saveCalcReport(ctx, paramMap, bgFormInfo, MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"bgformstateinvalid", (Locale)this.getLocale(ctx)), bgFormInfo.getState().getAlias()));
                        continue;
                    }
                    logger.error((Object)("RecalculateBgForm: " + bgFormInfo.getNumber() + " " + bgFormInfo.getId()));
                    if (BgTemFormTypeEnum.FIXEDFORM.equals((Object)bgTemplateInfo.getFormType()) || BgTemFormTypeEnum.SPECIALFORM.equals((Object)bgTemplateInfo.getFormType())) {
                        boolean needAdjustForm = bgFormInfo.getState().getValue() == 2;
                        ObjectUuidPK bgFormPK = null;
                        if (needAdjustForm) {
                            Map resultMap = iBgFormFacade.adjustBgForm(bgFormInfo.getId());
                            if (resultMap == null || resultMap.isEmpty()) {
                                return reportList;
                            }
                            bgFormPK = (IObjectPK)resultMap.get("pk");
                        } else {
                            bgFormPK = new ObjectUuidPK(bgFormInfo.getId());
                        }
                        adjustMap = new HashMap();
                        Object[] resultObj = null;
                        Book newBook = null;
                        ctx.put((Object)"BGFORM_OPEN_STATE", (Object)"EDIT");
                        BgFormInfo info = null;
                        Book _oldBook = null;
                        try {
                            ctx.put((Object)"AUTO_CALCULATOR", (Object)Boolean.TRUE);
                            ctx.put((Object)"DATASOURCE_CALCULATE", (Object)Boolean.TRUE);
                            info = (BgFormInfo)iBgForm.getValue((IObjectPK)bgFormPK, BgNFSHelper.getSelectors());
                            info.setBgScheme(bgScheme);
                            _oldBook = info.getBook();
                        }
                        finally {
                            ctx.remove((Object)"AUTO_CALCULATOR");
                        }
                        Map initValueMap = this.getInitBudgetDataMap(info);
                        Map<String, IBgNData> schemeData = null;
                        if (needAdjustForm) {
                            List formulas = BgNFSHelper.getFormulaListOfBook(_oldBook);
                            schemeData = MbgDataUtils.querySchemeData(ctx, bgScheme, orgId, (Collection<String>)formulas, info.getBgVersion(), 1, null).get(orgId);
                            HashMap<String, IBgNData> datas = new HashMap<String, IBgNData>();
                            for (IBgNData data : schemeData.values()) {
                                datas.put(data.getFormula(), data);
                            }
                            schemeData = datas;
                        }
                        resultObj = this.calculate(ctx, info, iReport, (IObjectPK)bgFormPK, adjustMap, initValueMap, adjustExpressionMap, (IObjectPK)userPK, needAdjustForm);
                        DimensionMemberCheckHelper checkHelper = null;
                        if (resultObj != null && resultObj[0] != null && resultObj[1] != null) {
                            newBook = (Book)resultObj[0];
                            info = (BgFormInfo)resultObj[1];
                            checkHelper = DimensionMemberCheckHelper.getLocalIntance(ctx, cacheHelper, orgId, bgTemplateId, schemeHelper, BgNFSHelper.getFormulaListOfBook(newBook), info.isDecompose());
                            this.processData(ctx, newBook, _oldBook, info, initValueMap, adjustMap, adjustExpressionMap, (IObjectPK)userPK, needAdjustForm, tempVarMap, schemeData, checkHelper, editScen.toString());
                        }
                        boolean hasAdjust = false;
                        if (needAdjustForm) {
                            checkMap.putAll(adjustMap);
                            if (!adjustMap.isEmpty()) {
                                for (IBgNData formula : adjustMap.keySet()) {
                                    if (checkHelper == null) {
                                        checkHelper = DimensionMemberCheckHelper.getLocalIntance(ctx, cacheHelper, orgId, bgTemplateId, schemeHelper, new ArrayList(adjustMap.keySet()), info.isDecompose());
                                    }
                                    if (!checkHelper.canSave((String)((Object)formula), editScen.toString(), null)) continue;
                                    hasAdjust = true;
                                    break;
                                }
                            }
                        }
                        this.setChangeSign(adjustMap, adjustExpressionMap, changSign, tempVarMap);
                        if (needAdjustForm) {
                            if (!hasAdjust) {
                                this.deleteAdjustForm(iBgForm, bgFormIds, bgFormPK.toString(), ctrlUnitId, BOSUuid.read((String)userPK.toString()));
                                if (!((Boolean)changSign[0]).booleanValue() && !((Boolean)changSign[1]).booleanValue()) {
                                    reportList.add(this.createReport(ctx, orgUnitInfo, bgTemplateInfo, bgPeriodInfo, bgVersionInfo, bgFormInfo.getProcessType(), bgFormInfo, ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"datanotchanged", (Locale)this.getLocale(ctx)), isMultiOrg, selectOrgIds));
                                    this.saveCalcReport(ctx, paramMap, bgFormInfo, ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"datanotchanged", (Locale)this.getLocale(ctx)));
                                } else {
                                    reportList.add(this.createReport(ctx, orgUnitInfo, bgTemplateInfo, bgPeriodInfo, bgVersionInfo, bgFormInfo.getProcessType(), bgFormInfo, ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"datahaschanged", (Locale)this.getLocale(ctx)), isMultiOrg, selectOrgIds));
                                    this.saveCalcReport(ctx, paramMap, bgFormInfo, ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"datahaschanged", (Locale)this.getLocale(ctx)));
                                    bgFormInfo.setBook(newBook);
                                    bgFormInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                                    bgFormInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                                    iBgForm.updatePartial((CoreBaseInfo)bgFormInfo, updatePartSic);
                                }
                            } else {
                                this.auditAdjustForm(ctx, BOSUuid.read((String)bgFormPK.toString()), bgFormInfo.getId(), userInfo.getId());
                                if (!bgFormInfo.getId().toString().equals(bgFormPK.toString()) && needAdjustForm) {
                                    MbgSqlHelper.execute((Context)ctx, (String)"delete from T_MBg_bgFormEntry where fbgformid = ?", (String)bgFormPK.toString());
                                    MbgSqlHelper.execute((Context)ctx, (String)"delete from T_MBg_BgForm where FId = ?", (String)bgFormPK.toString());
                                }
                                reportList.add(this.createReport(ctx, orgUnitInfo, bgTemplateInfo, bgPeriodInfo, bgVersionInfo, bgFormInfo.getProcessType(), bgFormInfo, ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"datahaschanged", (Locale)this.getLocale(ctx)), isMultiOrg, selectOrgIds));
                                this.saveCalcReport(ctx, paramMap, bgFormInfo, ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"datahaschanged", (Locale)this.getLocale(ctx)));
                            }
                        } else if (!((Boolean)changSign[0]).booleanValue() && !((Boolean)changSign[1]).booleanValue()) {
                            reportList.add(this.createReport(ctx, orgUnitInfo, bgTemplateInfo, bgPeriodInfo, bgVersionInfo, bgFormInfo.getProcessType(), bgFormInfo, ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"datanotchanged", (Locale)this.getLocale(ctx)), isMultiOrg, selectOrgIds));
                            this.saveCalcReport(ctx, paramMap, bgFormInfo, ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"datahaschanged", (Locale)this.getLocale(ctx)));
                        } else if (!((Boolean)changSign[0]).booleanValue() && ((Boolean)changSign[1]).booleanValue()) {
                            reportList.add(this.createReport(ctx, orgUnitInfo, bgTemplateInfo, bgPeriodInfo, bgVersionInfo, bgFormInfo.getProcessType(), bgFormInfo, ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"datahaschanged", (Locale)this.getLocale(ctx)), isMultiOrg, selectOrgIds));
                            this.saveCalcReport(ctx, paramMap, bgFormInfo, ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"datahaschanged", (Locale)this.getLocale(ctx)));
                        } else {
                            reportList.add(this.createReport(ctx, orgUnitInfo, bgTemplateInfo, bgPeriodInfo, bgVersionInfo, bgFormInfo.getProcessType(), bgFormInfo, ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"datahaschanged", (Locale)this.getLocale(ctx)), isMultiOrg, selectOrgIds));
                            this.saveCalcReport(ctx, paramMap, bgFormInfo, ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"datahaschanged", (Locale)this.getLocale(ctx)));
                        }
                        adjustMap.clear();
                        adjustMap = null;
                        adjustExpressionMap.clear();
                        checkMap.clear();
                        tempVarMap.clear();
                        continue;
                    }
                    if (BgProcessEnum.C01.equals((Object)bgFormInfo.getProcessType()) && !isLeaf) {
                        reportList.add(this.createReport(ctx, orgUnitInfo, bgTemplateInfo, bgPeriodInfo, bgVersionInfo, bgFormInfo.getProcessType(), bgFormInfo, ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"viewsuccess", (Locale)this.getLocale(ctx)), isMultiOrg, selectOrgIds));
                        this.saveCalcReport(ctx, paramMap, bgFormInfo, ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"viewsuccess", (Locale)this.getLocale(ctx)));
                        continue;
                    }
                    IMbgViewBase view = bgFormInfo.getViewById(ctx, bgScheme);
                    if (view != null) {
                        DimensionCommonHelper.movePageDimensionsToRow(view);
                        ArrayList<IBgDimensionManagerBase> dimensionManagers = new ArrayList<IBgDimensionManagerBase>();
                        IBgDimensionManagerBase dimManager = null;
                        for (int s = 0; s < view.getSheetManagers().size(); ++s) {
                            dimManager = view.getSheetManagers().get(s).getDimensionManager();
                            dimensionManagers.add(dimManager);
                        }
                        try {
                            ctx.put((Object)"AUTO_CALCULATOR", (Object)Boolean.TRUE);
                            MBGFormFacadeFactory.getLocalInstance(ctx).queryBgData(bgFormInfo.getId(), (IObjectValue)bgFormInfo.getInfo(ctx, bgFormInfo.getId()), dimensionManagers, bgFormInfo.getDataType(), false, null, false, null);
                        }
                        finally {
                            ctx.remove((Object)"AUTO_CALCULATOR");
                        }
                    }
                    reportList.add(this.createReport(ctx, orgUnitInfo, bgTemplateInfo, bgPeriodInfo, bgVersionInfo, (BgProcessEnum)((Object)processTypes.get(p)), bgFormInfo, ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"viewsuccess", (Locale)this.getLocale(ctx)), isMultiOrg, selectOrgIds));
                    this.saveCalcReport(ctx, paramMap, bgFormInfo, ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"viewsuccess", (Locale)this.getLocale(ctx)));
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"budget calulate error", (Throwable)e);
                    reportList.add(this.createReport(ctx, orgUnitInfo, bgTemplateInfo, bgPeriodInfo, bgVersionInfo, bgFormInfo.getProcessType(), bgFormInfo, ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"systemerror", (Locale)this.getLocale(ctx)) + e.getStackTrace(), isMultiOrg, selectOrgIds));
                    this.saveCalcReport(ctx, paramMap, bgFormInfo, ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"systemerror", (Locale)this.getLocale(ctx)));
                }
            }
        }
        return reportList;
    }

    protected Locale getLocale(Context ctx) {
        return ctx.getLocale();
    }

    private Set<String> dealSelectOrgIds(Context ctx, Set<String> distributedOrgUnitId, Set<String> selectOrgIds, String bgOrgViewId) throws BOSException, EASBizException {
        HashSet<String> childDistributedOrgUnitId = new HashSet<String>();
        HashSet<String> virtualOrgNumber = new HashSet<String>();
        childDistributedOrgUnitId.addAll(selectOrgIds);
        final ArrayList sqlParams = new ArrayList();
        Object[] objs = null;
        String orgUnitId = null;
        StringBuffer sql = new StringBuffer();
        Connection connection = null;
        sql.append("select fid , forgUnitID,fnumber,fname_" + ctx.getLocale() + " , flongNumber from T_mbg_BgOrgUnit where fviewID = '" + bgOrgViewId + "' and fisVirtual = 0 and forgUnitId in (");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        try {
            connection = this.getConnection(ctx);
            MbgSqlHelper.executeBatchQuery((Connection)connection, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])selectOrgIds.toArray(), (int)50), (IResultReader)new IResultReader(){

                public void read(ResultSet res) throws SQLException {
                    sqlParams.add(res.getString("FLongNumber") + "!%");
                }
            });
            sql.setLength(0);
            sql.append("select forgUnitId,fNumber,fIsVirtual from t_mbg_BgOrgunit where fviewID = '" + bgOrgViewId + "' and FLongNumber like ?");
            for (int i = 1; i < 100; ++i) {
                sql.append(" OR FLongNumber like ? ");
            }
            List rsts = BgDBUtils.executeBatchQuery((Connection)connection, (String)sql.toString(), sqlParams, (int)100);
            int in = rsts.size();
            for (int i = 0; i < in; ++i) {
                objs = (Object[])rsts.get(i);
                orgUnitId = (String)objs[0];
                if (((Number)objs[2]).intValue() == 1) {
                    virtualOrgNumber.add((String)objs[1]);
                }
                childDistributedOrgUnitId.add(orgUnitId);
            }
            this.dealVirtualOrg(connection, sql.toString(), virtualOrgNumber, childDistributedOrgUnitId);
            if (distributedOrgUnitId != null && !distributedOrgUnitId.isEmpty()) {
                childDistributedOrgUnitId.retainAll(distributedOrgUnitId);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)connection);
        }
        return childDistributedOrgUnitId;
    }

    private void dealVirtualOrg(Connection connection, String sql, Set<String> virtualOrgNumber, Set<String> childDistributedOrgUnitId) throws SQLException {
        if (virtualOrgNumber == null || virtualOrgNumber.isEmpty()) {
            return;
        }
        ArrayList<String> sqlParams = new ArrayList<String>();
        Object[] objs = null;
        String orgUnitId = null;
        Iterator<String> ite = virtualOrgNumber.iterator();
        while (ite.hasNext()) {
            sqlParams.add("%!" + ite.next() + "!%");
        }
        virtualOrgNumber.clear();
        List rsts = BgDBUtils.executeBatchQuery((Connection)connection, (String)sql, sqlParams, (int)100);
        int in = rsts.size();
        for (int i = 0; i < in; ++i) {
            objs = (Object[])rsts.get(i);
            orgUnitId = (String)objs[0];
            if (((BigDecimal)objs[2]).intValue() == 1) {
                virtualOrgNumber.add((String)objs[1]);
            }
            childDistributedOrgUnitId.add(orgUnitId);
        }
        if (virtualOrgNumber.isEmpty()) {
            return;
        }
        this.dealVirtualOrg(connection, sql, virtualOrgNumber, childDistributedOrgUnitId);
    }

    /*
     * WARNING - void declaration
     */
    private void beforeCheckAdjust(Context ctx, String bgSchemeId, Set<String> selectOrgIds, Set<String> childDistributedOrgUnitId, List<BgProcessEnum> processTypes, BgVersionInfo bgVersionInfo) throws BOSException {
        Connection conn = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer resultMessage = new StringBuffer();
        HashSet<String> hasAdjustDataOrgUnit = new HashSet<String>();
        try {
            conn = this.getConnection(ctx);
            sql.append("Select  org.fnumber,org.fname_").append(ctx.getLocale()).append(" FROM T_MBG_BgTmpData t left join T_mbg_bgOrgunit org on t.forgUnitId = org.FOrgUnitID Where t.FBgSchemeRootId ='").append(bgSchemeId).append("' ").append("and FProcessType in ( ");
            for (BgProcessEnum bgProcessEnum : processTypes) {
                sql.append(bgProcessEnum.getValue()).append(",");
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(" ) and t.forgUnitId in (");
            for (int i = 1; i < 50; ++i) {
                sql.append("?,");
            }
            sql.append("?)");
            if (bgVersionInfo != null) {
                sql.append(" and fversion = ").append(bgVersionInfo.getVersionId());
            }
            ArrayList<String> billIds = new ArrayList<String>();
            for (String string : childDistributedOrgUnitId) {
                billIds.add(string);
            }
            List list = BgDBUtils.executeBatchQuery((Connection)conn, (String)sql.toString(), new ArrayList<String>(childDistributedOrgUnitId));
            if (list != null && !list.isEmpty()) {
                for (Object[] obj : list) {
                    if (hasAdjustDataOrgUnit.contains(obj[1].toString())) continue;
                    hasAdjustDataOrgUnit.add(obj[1].toString());
                    resultMessage.append(obj[0].toString()).append("(").append(obj[1].toString()).append("),");
                }
            }
            Object var14_22 = null;
            if (resultMessage.length() > 0) {
                String string = resultMessage.substring(0, resultMessage.length() - 1);
            }
            if (resultMessage.length() > 0) {
                void var14_24;
                throw new BgFormException(BgFormException.SHOWEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"orgRangeHasAdjustData", (Locale)ctx.getLocale()) + (String)var14_24});
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rst);
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void beforeCheckAdjust(Context ctx, String bgSchemeId, Set<String> selectOrgIds, Set<String> childDistributedOrgUnitId, List<BgProcessEnum> processTypes) throws BOSException {
        this.beforeCheckAdjust(ctx, bgSchemeId, selectOrgIds, childDistributedOrgUnitId, processTypes, null);
    }

    private BigDecimal compute(BigDecimal minuend, BigDecimal subtrahend) {
        if (minuend == null && subtrahend == null) {
            return new BigDecimal("0.00");
        }
        if (minuend != null && subtrahend == null) {
            return minuend;
        }
        if (minuend == null && subtrahend != null) {
            minuend = new BigDecimal("0.00");
        }
        return minuend.subtract(subtrahend);
    }

    private void setChangeSign(Map adjustMap, Map adjustExpressionMap, Object[] changSign, Map tempVarMap) {
        if (adjustMap != null && adjustMap.size() > 0) {
            adjustMap.clear();
        }
        changSign[0] = tempVarMap != null && tempVarMap.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        if (adjustExpressionMap != null && adjustExpressionMap.size() > 0) {
            changSign[1] = Boolean.TRUE;
            adjustExpressionMap.clear();
        }
    }

    private void checkBgFormInAdjustBill(Context ctx, List bgFormList, List reportList, FullOrgUnitInfo orgUnitInfo, BgTemplateInfo bgTemplateInfo, BgPeriodInfo bgPeriodInfo, boolean isMultiOrg) {
    }

    private boolean checkBgFormState(Context ctx, BgFormInfo info, List reportList, FullOrgUnitInfo orgUnitInfo, BgTemplateInfo bgTemplateInfo, BgPeriodInfo bgPeriodInfo, BgVersionInfo bgVersionInfo, boolean isMultiOrg, Set<String> selectOrgIds, Set<Integer> calcStates) {
        if (calcStates.contains(info.getState().getValue())) {
            return true;
        }
        reportList.add(this.createReport(ctx, orgUnitInfo, bgTemplateInfo, bgPeriodInfo, bgVersionInfo, info.getProcessType(), info, MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"bgformstateinvalid", (Locale)this.getLocale(ctx)), info.getState().getAlias()), isMultiOrg, selectOrgIds));
        return false;
    }

    private BgFormCollection queryBgForm(Context ctx, String orgId, String bgSchemeId, String bgTemplateId, String bgPeriodId, String currencyId, String bgVersionId, List<BgProcessEnum> processTypes) throws BOSException {
        StringBuffer pSql = new StringBuffer();
        if (processTypes != null) {
            pSql.append(" and FProcessType IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)pSql, (int)processTypes.size()).append(")");
        }
        StringBuffer queryBgFormSql = new StringBuffer();
        queryBgFormSql.append(" select t0.fid, t0.fadjustid, t0.fstate, t0.fname, t0.fnumber, t0.fdatasource, t0.fxnum, t0.fprocesstype, t1.FDimensionNumber, t1.FMemberDisplayName from t_mbg_bgform t0 Left Join T_MBG_BgSpecialItems t1 ON t0.FID = t1.FBgFormId where t0.forgunitid = ? and t0.fbgschemeid = ? ");
        queryBgFormSql.append(" and t0.fbgtemplateid = ? and t0.fbgperiodid = ? and t0.fcurrencyid = ? and t0.fbgversionId = ? and t0.fstate not in (").append(5).append(",").append(15).append(" )");
        queryBgFormSql.append(" and t0.fid not in (select fadjustId from t_mbg_bgform where fstate in (").append(4).append(",").append(35).append("))");
        queryBgFormSql.append(pSql);
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        BgFormCollection bgFormList = new BgFormCollection();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(queryBgFormSql.toString());
            pstmt.setString(1, orgId);
            pstmt.setString(2, bgSchemeId);
            pstmt.setString(3, bgTemplateId);
            pstmt.setString(4, bgPeriodId);
            pstmt.setString(5, currencyId);
            pstmt.setString(6, bgVersionId);
            if (processTypes != null) {
                for (int i = 0; i < processTypes.size(); ++i) {
                    pstmt.setInt(7 + i, processTypes.get(i).getValue());
                }
            }
            rs = pstmt.executeQuery();
            int state = 0;
            BgFormInfo bgFormInfo = null;
            BgSchemeInfo bgSchemeInfo = null;
            while (rs.next()) {
                bgFormInfo = new BgFormInfo();
                bgFormInfo.setName(rs.getString("fname"));
                bgFormInfo.setNumber(rs.getString("fnumber"));
                bgFormInfo.setDataSource(BgFormDataSourceEnum.getEnum(rs.getInt("fdatasource")));
                bgFormInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                state = rs.getInt("fstate");
                bgFormInfo.setState(BgFormStateEnum.getEnum(state));
                bgFormInfo.setXNum(rs.getString("fxnum"));
                bgSchemeInfo = new BgSchemeInfo();
                bgSchemeInfo.setId(BOSUuid.read((String)bgSchemeId));
                bgFormInfo.setBgScheme(bgSchemeInfo);
                bgFormInfo.setProcessType(BgProcessEnum.getEnum(rs.getInt("fprocesstype")));
                if (!StringUtils.isEmpty((String)rs.getString("FDimensionNumber"))) {
                    bgFormInfo.getBgSpecialItems().add(new BgSpecialItemsInfo());
                    bgFormInfo.getBgSpecialItems().get(0).setDimensionNumber(rs.getString("FDimensionNumber"));
                    bgFormInfo.getBgSpecialItems().get(0).setMemberDisplayName(rs.getString("FMemberDisplayName"));
                }
                bgFormList.add(bgFormInfo);
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return bgFormList;
    }

    private void auditAdjustForm(Context ctx, BOSUuid bgFromID, BOSUuid adjsutID, BOSUuid userID) throws BOSException, EASBizException {
        HashMap<String, BgPastSourceEnum> auditParams = new HashMap<String, BgPastSourceEnum>();
        auditParams.put("BgPastSource", BgPastSourceEnum.BIZCALC);
        BgAdjustFacadaFactory.getLocalInstance(ctx).audit(bgFromID.toString(), auditParams);
        BgFormFacadeFactory.getLocalInstance(ctx).submitAuditIdea(adjsutID, userID, BgAuditIdeaEnum.ADJUSTPASS, ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"autorecalcautidpassed", (Locale)this.getLocale(ctx)));
    }

    private void deleteAdjustForm(IBgForm iBgForm, List bgFormIds, String bgFormId, BOSUuid ctrlUnitId, BOSUuid userID) throws BOSException, EASBizException {
        bgFormIds.clear();
        bgFormIds.add(bgFormId);
        BOSUuid[] ids = new BOSUuid[bgFormIds.size()];
        for (int i = 0; i < bgFormIds.size(); ++i) {
            ids[i] = BOSUuid.read((String)((String)bgFormIds.get(i)));
        }
        iBgForm.batchRemove(ids);
    }

    private boolean reportCheck(Context ctx, String bgFormId) throws BOSException, EASBizException {
        List nopass;
        BOSUuid[] uuid = new BOSUuid[]{BOSUuid.read((String)bgFormId)};
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        List check = iBgForm.reportCheck(uuid);
        return check.size() < 3 || check.get(2) == null || (nopass = (List)check.get(2)) == null || nopass.size() <= 0;
    }

    private Object[] calculate(Context ctx, BgFormInfo info, IReport iReport, IObjectPK bgFormPK, Map adjustMap, Map initValueMap, Map adjustExpressionMap, IObjectPK userPK, boolean needAdjustForm) throws BOSException, EASBizException {
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        try {
            this.refreshBook(ctx, info);
        }
        catch (Exception e1) {
            logger.error((Object)"error", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        info.put("myBgPeriod", info.getBgPeriod());
        Object[] result = new Object[2];
        byte[] newData = iReport.backCacl((IObjectValue)info, info.getZipData());
        Book _book = null;
        try {
            _book = IOHelper.unpackBook((byte[])newData);
            result[0] = _book;
            result[1] = info;
            return result;
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
            return result;
        }
    }

    protected void refreshBook(Context ctx, BgFormInfo info) throws Exception {
        BgFormHelper.backFillBgFormInfo(ctx, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processData(Context ctx, Book _newBook, Book _oldBook, BgFormInfo info, Map initValueMap, Map adjustMap, Map adjustExpressionMap, IObjectPK userPK, boolean needAdjustForm, Map tempVarMap, Map<String, IBgNData> schemeData, DimensionMemberCheckHelper checkHelper, String editScen) throws BOSException, EASBizException {
        BgNFSHelper.disableCal(_newBook);
        BgNFSHelper.disableUndo(_newBook);
        if (_newBook != null) {
            if (needAdjustForm) {
                this.updateChangeValueInfo(_newBook, _oldBook, initValueMap, adjustMap, adjustExpressionMap, userPK, true, tempVarMap, schemeData, checkHelper, editScen);
            } else {
                this.updateChangeValueInfo(_newBook, _oldBook, initValueMap, adjustMap, adjustExpressionMap, userPK, false, tempVarMap, schemeData, checkHelper, editScen);
            }
            IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
            BgNFSHelper.setBudget((IObjectValue)info);
            if (!adjustMap.isEmpty()) {
                if (!adjustMap.isEmpty()) {
                    String formula = "";
                    String valueObj = "";
                    Iterator iterator = adjustMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        formula = iterator.next().toString();
                        valueObj = adjustMap.get(formula);
                        if (!(valueObj instanceof BgFormDiversityData)) continue;
                        initValueMap.put(formula, ((BgFormDiversityData)((Object)valueObj)).getNewValue());
                    }
                }
            } else if (!adjustMap.isEmpty() || adjustExpressionMap.size() > 0) {
                // empty if block
            }
            try {
                info.setBook(_newBook);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                info.put("ignoreDataState", Boolean.TRUE);
                iBgForm.save((CoreBaseInfo)info);
            }
            catch (Exception exception) {
            }
            finally {
                info.remove("ignoreDataState");
            }
        }
    }

    private void updateChangeValueInfo(Book _newBook, Book _oldBook, Map initValueMap, Map adjustMap, Map adjustExpressionMap, IObjectPK userPK, boolean needChangeColor, Map tempVarMap, Map<String, IBgNData> schemeData, DimensionMemberCheckHelper checkHelper, String editScen) {
        if (_newBook == null || adjustMap == null) {
            return;
        }
        Sheet _sheet = null;
        int size = _newBook.getSheetCount();
        for (int index = 0; index < size; ++index) {
            _sheet = _newBook.getSheet(index);
            this.updateSheetChangeValueInfo(initValueMap, _oldBook, adjustMap, adjustExpressionMap, _sheet, userPK, needChangeColor, tempVarMap, schemeData, checkHelper, editScen);
        }
    }

    private void updateSheetChangeValueInfo(Map initValueMap, Book _oldBook, Map adjustMap, Map adjustExpressionMap, Sheet sheet, IObjectPK userPK, boolean needChangeColor, Map tempVarMap, Map<String, IBgNData> schemeData, DimensionMemberCheckHelper checkHelper, String editScen) {
        if (sheet == null) {
            return;
        }
        Cell _cell = null;
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
            for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                _cell = sheet.getCell(rowIndex, colIndex, false);
                this.updateCellChangeValueInfo(initValueMap, _oldBook, adjustMap, adjustExpressionMap, sheet, _cell, userPK, needChangeColor, tempVarMap, schemeData, checkHelper, editScen);
            }
        }
    }

    private void updateCellChangeValueInfo(Map initValueMap, Book _oldBook, Map adjustMap, Map adjustExpressionMap, Sheet sheet, Cell cell, IObjectPK userPK, boolean needChangeColor, Map tempVarMap, Map<String, IBgNData> schemeData, DimensionMemberCheckHelper checkHelper, String editScen) {
        if (cell == null) {
            return;
        }
        BgFormDiversityData divData = null;
        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
            ArrayList<String> _delFormulaList = new ArrayList<String>();
            Object _obj = null;
            BigDecimal _newValue = null;
            BigDecimal _oldValue = null;
            BigDecimal _adjOldValue = null;
            BigDecimal _adjNewValue = null;
            String _formulaStr = null;
            _formulaStr = BgNFSHelper.getFormulaOfCell(cell);
            _obj = BgNFSHelper.getValue(cell);
            if (_obj instanceof BigDecimal) {
                _newValue = (BigDecimal)_obj;
            } else if (_obj == null) {
                BgNFSHelper.setValue(cell, null);
                _newValue = ZERO;
            } else {
                try {
                    _newValue = new BigDecimal(_obj.toString());
                }
                catch (Exception ex) {
                    BgNFSHelper.setValue(cell, ZERO);
                    _newValue = ZERO;
                }
            }
            if (initValueMap.containsKey(_formulaStr)) {
                if (tempVarMap.containsKey(_formulaStr)) {
                    divData = (BgFormDiversityData)tempVarMap.get(_formulaStr);
                    _adjOldValue = divData.getOldValue();
                    _adjNewValue = divData.getNewValue();
                    if (_newValue != null) {
                        _newValue = _newValue.setScale(4, RoundingMode.HALF_UP);
                    }
                    _oldValue = (_adjNewValue = _adjNewValue.setScale(4, RoundingMode.HALF_UP)).compareTo(_newValue) != 0 ? _adjNewValue : _adjOldValue;
                    if (_newValue.compareTo(_adjOldValue) == 0) {
                        _delFormulaList.add(_formulaStr);
                    }
                } else {
                    _oldValue = (BigDecimal)initValueMap.get(_formulaStr);
                }
                if (schemeData != null && schemeData.containsKey(_formulaStr)) {
                    _oldValue = schemeData.get(_formulaStr).getBudgetValue();
                    _oldValue = _oldValue != null ? _oldValue.setScale(4, 4) : ZERO;
                }
                if ((_newValue = _newValue.setScale(4, 4)).compareTo(_oldValue = _oldValue.setScale(4, 4)) != 0) {
                    if (checkHelper == null || checkHelper.canSave(_formulaStr, editScen, null)) {
                        if (adjustMap.containsKey(_formulaStr)) {
                            this.updateDivInfo(cell, _formulaStr, _newValue, adjustMap, userPK, needChangeColor);
                        } else {
                            this.createDivInfo(cell, _formulaStr, _newValue, _oldValue, adjustMap, userPK, needChangeColor, tempVarMap);
                        }
                    }
                    BgNFSHelper.setBudgetValue(cell, _newValue);
                } else {
                    this.removeDivInfo(cell, _formulaStr, adjustMap, needChangeColor);
                    BgNFSHelper.setBudgetValue(cell, _oldValue);
                }
                int j = _delFormulaList.size();
                for (int i = 0; i < j; ++i) {
                    tempVarMap.remove(_delFormulaList.get(i));
                }
                if (!DimensionCommonHelper.isEquals(_obj, BgNFSHelper.getValue(_oldBook.getSheet(sheet.getSheetIndex()).getCell(cell.getRow(), cell.getCol(), false)))) {
                    adjustExpressionMap.put(_formulaStr, cell.getValue());
                }
            } else if (checkHelper == null || checkHelper.canSave(_formulaStr, editScen, null)) {
                this.createDivInfo(cell, _formulaStr, _newValue, ZERO, adjustMap, userPK, needChangeColor, tempVarMap);
            }
        } else if (BgNFSHelper.checkHasExpression(cell)) {
            int row = cell.getRow();
            int col = cell.getCol();
            int sheetIndex = sheet.getIndex();
            try {
                Variant oldValue = _oldBook.getSheet(sheetIndex).getCell(row, col, false).getValue();
                if (!cell.getValue().equals(oldValue)) {
                    adjustExpressionMap.put(BgNFSHelper.getExpression(cell), cell.getValue());
                }
            }
            catch (Exception e) {
                logger.error((Object)e.toString());
            }
        }
    }

    private void removeDivInfo(Cell cell, String formulaStr, Map adjustMap, boolean needChangeColor) {
        adjustMap.remove(formulaStr);
        if (needChangeColor) {
            Color adjustBeforeColor = BgNFSHelper.getAdjustBeforeColor(cell);
            if (adjustBeforeColor != null) {
                BgNFSHelper.setAdjustBeforeColor(cell, null);
                BgNFSHelper.setBackGroup(cell, adjustBeforeColor);
            } else if (EDIT_COLOR.equals(BgNFSHelper.getBackGroup(cell))) {
                BgNFSHelper.setBackGroup(cell, BASE_COLOR);
            }
        }
    }

    private void createDivInfo(Cell cell, String formulaStr, BigDecimal newValue, BigDecimal oldValue, Map adjustMap, IObjectPK userPK, boolean needChangeColor, Map tempVarMap) {
        if (newValue.equals(oldValue)) {
            return;
        }
        BgFormDiversityData divData = new BgFormDiversityData();
        divData.setFormula(formulaStr);
        divData.setNewValue(newValue);
        divData.setOldValue(oldValue);
        divData.setAdjustTime(new Timestamp(System.currentTimeMillis()));
        adjustMap.put(formulaStr, divData);
        if (!tempVarMap.containsKey(formulaStr)) {
            tempVarMap.put(formulaStr, divData);
        }
        if (needChangeColor) {
            BgNFSHelper.setAdjustBeforeColor(cell);
            BgNFSHelper.setBackGroup(cell, EDIT_COLOR);
        }
    }

    private void updateDivInfo(Cell cell, String formulaStr, BigDecimal newValue, Map adjustMap, IObjectPK userPK, boolean needChangeColor) {
        BgFormDiversityData divData = (BgFormDiversityData)adjustMap.get(formulaStr);
        if (divData != null) {
            divData.setNewValue(newValue);
            divData.setAdjustTime(new Timestamp(System.currentTimeMillis()));
        }
        if (needChangeColor) {
            BgNFSHelper.setBackGroup(cell, EDIT_COLOR);
        }
    }

    private Map createReport(Context ctx, FullOrgUnitInfo orgUnitInfo, BgTemplateInfo bgTemplateInfo, BgPeriodInfo bgPeriodInfo, BgVersionInfo bgVersion, BgProcessEnum processType, BgFormInfo bgFormInfo, String calcResult, boolean isMultiOrg, Set<String> selectOrgIds) {
        HashMap<BgSchemeReCalcMsgObj, String> map = new HashMap<BgSchemeReCalcMsgObj, String>();
        BgSchemeReCalcMsgObj key = null;
        key = new BgSchemeReCalcMsgObj("ORG", ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"org", (Locale)this.getLocale(ctx)), 1);
        map.put(key, orgUnitInfo.getNumber() + "(" + orgUnitInfo.getName() + ")");
        key = new BgSchemeReCalcMsgObj("TEMPLATE", ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"bgtemplate", (Locale)this.getLocale(ctx)), 2);
        if (bgTemplateInfo != null) {
            map.put(key, bgTemplateInfo.getNumber() + "(" + bgTemplateInfo.getName() + ")");
        } else {
            map.put(key, "");
        }
        key = new BgSchemeReCalcMsgObj("BGFORM", ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"bgform", (Locale)this.getLocale(ctx)), 3);
        if (bgFormInfo != null) {
            map.put(key, bgFormInfo.getName());
        } else {
            map.put(key, "");
        }
        key = new BgSchemeReCalcMsgObj("VERSION", ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"specialItem", (Locale)this.getLocale(ctx)), 4);
        if (bgFormInfo != null && bgFormInfo.getBgSpecialItems() != null && !bgFormInfo.getBgSpecialItems().isEmpty()) {
            map.put(key, bgFormInfo.getBgSpecialItems().get(0).getMemberDisplayName());
        } else {
            map.put(key, "");
        }
        key = new BgSchemeReCalcMsgObj("PERIOD", ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"bgperiod", (Locale)this.getLocale(ctx)), 5);
        if (bgPeriodInfo != null) {
            map.put(key, bgPeriodInfo.getNumber() + "(" + bgPeriodInfo.getName() + ")");
        } else {
            map.put(key, "");
        }
        key = new BgSchemeReCalcMsgObj("PROCESSTYPE", ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"processType", (Locale)this.getLocale(ctx)), 6);
        if (processType == null) {
            map.put(key, "");
        } else {
            map.put(key, processType.getAlias());
        }
        key = new BgSchemeReCalcMsgObj("RECALC_RESULT", ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"recalcresult", (Locale)this.getLocale(ctx)), 7);
        map.put(key, calcResult);
        return map;
    }

    private SelectorItemCollection getBgSchemeSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.id"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.id"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.rootId"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.name"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.number"));
        return sic;
    }

    private SelectorItemCollection getCalcSchemeSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("entry.bgCalculateScheme.id"));
        sic.add(new SelectorItemInfo("entry.template.template.id"));
        sic.add(new SelectorItemInfo("entry.template.template.rootId"));
        sic.add(new SelectorItemInfo("entry.template.template.name"));
        sic.add(new SelectorItemInfo("entry.template.template.number"));
        sic.add(new SelectorItemInfo("entry.template.seq"));
        sic.add(new SelectorItemInfo("entry.template.sheet.id"));
        sic.add(new SelectorItemInfo("entry.template.sheet.sheetId"));
        sic.add(new SelectorItemInfo("entry.template.sheet.sheetName"));
        sic.add(new SelectorItemInfo("entry.template.period.id"));
        sic.add(new SelectorItemInfo("entry.template.period.seq"));
        sic.add(new SelectorItemInfo("entry.template.period.period.name"));
        sic.add(new SelectorItemInfo("entry.template.period.period.number"));
        sic.add(new SelectorItemInfo("entry.template.period.period.periodType"));
        sic.add(new SelectorItemInfo("entry.template.period.period.beginDate"));
        sic.add(new SelectorItemInfo("entry.template.period.period.endDate"));
        sic.add(new SelectorItemInfo("entry.currency.id"));
        sic.add(new SelectorItemInfo("entry.currency.name"));
        sic.add(new SelectorItemInfo("entry.isCollect"));
        sic.add(new SelectorItemInfo("entry.isCollectFirst"));
        sic.add(new SelectorItemInfo("entry.isCalculate"));
        sic.add(new SelectorItemInfo("entry.seq"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("bgScheme.id"));
        sic.add(new SelectorItemInfo("bgScheme.rootId"));
        sic.add(new SelectorItemInfo("bgScheme.name"));
        sic.add(new SelectorItemInfo("bgScheme.number"));
        sic.add(new SelectorItemInfo("rootId"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("bgVersion.id"));
        sic.add(new SelectorItemInfo("bgVersion.name"));
        sic.add(new SelectorItemInfo("bgVersion.number"));
        sic.add(new SelectorItemInfo("periodNums"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("processTypeNumber"));
        sic.add(new SelectorItemInfo("processTypeName"));
        sic.add(new SelectorItemInfo("cu.id"));
        sic.add(new SelectorItemInfo("createOrgUnit.id"));
        sic.add(new SelectorItemInfo("createOrgUnit.id"));
        sic.add(new SelectorItemInfo("createOrgUnit.id"));
        return sic;
    }

    @Override
    @Deprecated
    protected boolean _checkHasAssigned(Context ctx, Map param) throws BOSException, EASBizException {
        if (param == null || param.isEmpty()) {
            return false;
        }
        boolean re = false;
        return re;
    }

    @Override
    protected Object _assign(Context ctx, String bgSchemeId, List calSchemeIds, List orgUnitIds, boolean isReplace) throws BOSException, EASBizException {
        ArrayList<String[]> arrayList;
        if (StringUtils.isEmpty((String)bgSchemeId) || calSchemeIds == null || calSchemeIds.isEmpty() || orgUnitIds == null || orgUnitIds.isEmpty()) {
            return null;
        }
        Connection conn = null;
        IRowSet rst = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tempTable = null;
        String key = null;
        HashMap<String, String> existMap = new HashMap<String, String>();
        String bosType = new BgCalculateSchemeInfo().getBOSType().toString();
        List _calSchemeIds = calSchemeIds;
        List _orgUnitIds = orgUnitIds;
        try {
            conn = this.getConnection(ctx);
            tempTable = pool.createTempTable("Create Table T_MBG_BgCalcSchAssign(FSuperId Varchar(44) NOT NULL, FOrgUnitId Varchar(44) NOT NULL, FRootID Varchar(44), FNumber NVarchar(255), FThisId Varchar(44), FIsRepeat INT)");
            pool.createIndex(tempTable, "FSuperId,FOrgUnitId", true, true);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (String calId : _calSchemeIds) {
                for (String orgId : _orgUnitIds) {
                    paramList.add(new Object[]{calId, orgId});
                }
            }
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + tempTable + "(FSuperId, FOrgUnitId, FIsRepeat) Values(?, ?, 0)"), paramList);
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + tempTable + " t0 Set FRootId = (Select FRootId FROM T_MBG_BgCalcScheme Where FID = t0.FSuperID)"));
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + tempTable + " t0 Set FNumber = (Select FNumber FROM T_MBG_BgCalcScheme Where FID = t0.FSuperID)"));
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Update " + tempTable + " t0 Set FIsRepeat = 1 Where exists(Select FID FROM T_MBG_BgCalcScheme t1 Where t0.FRootId <> t1.FRootId AND t0.FOrgUnitId = t1.FOrgUnitId AND t1.FBgSchemeId = ? AND t0.FNumber = t1.FNumber)"), (Object)new Object[]{bgSchemeId});
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + tempTable + " t0 Set FThisId = (Select FID FROM T_MBG_BgCalcScheme t1 Where t0.FRootId = t1.FRootId AND t0.FOrgUnitId = t1.FOrgUnitId)"));
            HashSet<String> hasRepeat = new HashSet<String>();
            HashSet<String> hasExists = new HashSet<String>();
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("Select FSuperID, FOrgUnitId, FIsRepeat, FThisId, FNumber FROM " + tempTable + " Where FIsRepeat = 1 OR FThisId IS NOT NULL"));
            while (rst.next()) {
                key = this.getAssignKey(rst.getString("FSuperId"), rst.getString("FOrgUnitId"));
                if (rst.getBoolean("FIsRepeat")) {
                    hasRepeat.add(key);
                    continue;
                }
                hasExists.add(key);
                if (StringUtils.isEmpty((String)rst.getString("FThisId"))) continue;
                existMap.put(rst.getString("FOrgUnitId") + "_" + rst.getString("FNumber"), rst.getString("FThisId"));
            }
            SQLUtils.cleanup((ResultSet)rst);
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(this.getCalcSchemeSelectors());
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(calSchemeIds), CompareType.INCLUDE));
            BgCalculateSchemeCollection calcSchCol = BgCalculateSchemeFactory.getLocalInstance(ctx).getBgCalculateSchemeCollection(evi);
            Map sourceSchMap = BgCommHelper.transeToMap((IObjectCollection)calcSchCol);
            evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("id");
            evi.getSelector().add("orgUnitId");
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)BgViewServerHelper.getBudgetViewID(ctx, bgSchemeId), CompareType.INCLUDE));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitId", new HashSet(orgUnitIds), CompareType.INCLUDE));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("isVirtual", (Object)Boolean.FALSE));
            BgOrgUnitCollection orgCol = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(evi);
            Map bgOrgUnitMap = BgCommHelper.transeToMap((IObjectCollection)orgCol, (String[])new String[]{"orgUnitID"});
            Map _resultMap = BgSchemeDispatchFacadeFactory.getLocalInstance(ctx).queryDispatchInfo(BOSUuid.read((String)bgSchemeId));
            Map dispatchMap = null;
            dispatchMap = _resultMap != null && _resultMap.get(BgSchemeDispatchConstants.SCHEME_DISPATCH) != null ? (Map)_resultMap.get(BgSchemeDispatchConstants.SCHEME_DISPATCH) : new HashMap();
            CoreBaseCollection saveCol = new CoreBaseCollection();
            ArrayList<String[]> result = new ArrayList<String[]>();
            int count = 5;
            String[] _result = new String[5];
            String partsuccess = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"partsuccess", (Locale)ctx.getLocale());
            String successStr = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"success", (Locale)ctx.getLocale());
            String failStr = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"fail", (Locale)ctx.getLocale());
            String lowerexistsamenumberStr = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)lowerexistsamenumber, (Locale)ctx.getLocale());
            String lowerparttempnotassignStr = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)lowerparttempnotassign, (Locale)ctx.getLocale());
            String lowerbgschemenottempStr = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)lowerbgschemenottemp, (Locale)ctx.getLocale());
            BgCalculateSchemeInfo info = null;
            BgCalculateSchemeInfo childInfo = null;
            BgOrgUnitInfo orgUnitInfo = null;
            BgCalculateSchemeEntryInfo childEntryInfo = null;
            BgCalculateSchemeEntryInfo entryInfo = null;
            BgCalculateSchemeEntryTemplateInfo childEntryTempInfo = null;
            BgCalculateSchemeEntryTemplateInfo entryTempInfo = null;
            BgCalculateSchemePeriodInfo childPeriodInfo = null;
            BgCalculateSchemePeriodInfo periodInfo = null;
            ArrayList<Object[]> noTemplateParams = new ArrayList<Object[]>();
            BOSUuid bgTemplateId = null;
            int seq = 0;
            for (String calcId : _calSchemeIds) {
                info = (BgCalculateSchemeInfo)sourceSchMap.get(calcId);
                for (String orgId : _orgUnitIds) {
                    orgUnitInfo = (BgOrgUnitInfo)bgOrgUnitMap.get(orgId);
                    key = this.getAssignKey(calcId, orgId);
                    _result = new String[5];
                    _result[0] = Boolean.TRUE.toString();
                    _result[1] = info.getName();
                    _result[2] = orgUnitInfo.getNumber() + "(" + orgUnitInfo.getName() + ")";
                    result.add(_result);
                    if (hasRepeat.contains(key)) {
                        _result[3] = failStr;
                        _result[4] = lowerexistsamenumberStr;
                        continue;
                    }
                    if (!isReplace && hasExists.contains(key)) {
                        _result[3] = successStr;
                        continue;
                    }
                    seq = 0;
                    childInfo = new BgCalculateSchemeInfo();
                    childInfo.setParent(info);
                    childInfo.setRootId(info.getRootId());
                    childInfo.setOrgUnit(orgUnitInfo.castToFullOrgUnitInfo());
                    childInfo.setBgScheme(info.getBgScheme());
                    childInfo.setPeriodNums(info.getPeriodNums());
                    childInfo.setCurrency(info.getCurrency());
                    childInfo.setName(info.getName());
                    childInfo.setNumber(info.getNumber());
                    childInfo.setDescription(info.getDescription());
                    childInfo.setCreateOrgUnit(info.getCreateOrgUnit());
                    childInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                    childInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                    childInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                    childInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                    childInfo.setBgVersion(info.getBgVersion());
                    childInfo.setCU(info.getCU());
                    childInfo.setIsFormal(info.isIsFormal());
                    childInfo.setProcessTypeName(info.getProcessTypeName());
                    childInfo.setProcessTypeNumber(info.getProcessTypeNumber());
                    int jn = info.getEntry().size();
                    for (int j = 0; j < jn; ++j) {
                        entryInfo = info.getEntry().get(j);
                        bgTemplateId = entryInfo.getTemplate().getTemplate().getId();
                        if (!dispatchMap.containsKey(bgTemplateId) || !((Set)dispatchMap.get(bgTemplateId)).contains(BOSUuid.read((String)orgId))) continue;
                        childEntryInfo = new BgCalculateSchemeEntryInfo();
                        childEntryInfo.setIsCalculate(entryInfo.isIsCalculate());
                        childEntryInfo.setIsCollect(entryInfo.isIsCollect());
                        childEntryInfo.setIsCollectFirst(entryInfo.isIsCollectFirst());
                        childEntryInfo.setPeriodNum(entryInfo.getPeriodNum());
                        childEntryInfo.setSeq(entryInfo.getSeq());
                        childEntryInfo.setCurrency(entryInfo.getCurrency());
                        childEntryTempInfo = new BgCalculateSchemeEntryTemplateInfo();
                        entryTempInfo = entryInfo.getTemplate();
                        childEntryInfo.setTemplate(childEntryTempInfo);
                        childEntryTempInfo.setTemplate(entryTempInfo.getTemplate());
                        childEntryTempInfo.setSeq(seq);
                        if (entryTempInfo.getPeriod() != null && entryTempInfo.getPeriod().size() > 0) {
                            int xn = entryTempInfo.getPeriod().size();
                            for (int x = 0; x < xn; ++x) {
                                periodInfo = entryTempInfo.getPeriod().get(x);
                                childPeriodInfo = new BgCalculateSchemePeriodInfo();
                                childPeriodInfo.setPeriod(periodInfo.getPeriod());
                                childPeriodInfo.setSeq(periodInfo.getSeq());
                                childEntryTempInfo.getPeriod().add(childPeriodInfo);
                            }
                        }
                        childInfo.getEntry().add(childEntryInfo);
                        ++seq;
                    }
                    if (childInfo.getEntry().isEmpty()) {
                        _result[3] = failStr;
                        _result[4] = lowerbgschemenottempStr;
                        noTemplateParams.add(new Object[]{childInfo.getRootId().toString(), orgId});
                        continue;
                    }
                    saveCol.add((CoreBaseInfo)childInfo);
                    _result[3] = successStr;
                    if (childInfo.getEntry().size() == info.getEntry().size()) continue;
                    _result[3] = partsuccess;
                    _result[4] = lowerparttempnotassignStr;
                }
            }
            if (isReplace) {
                if (!noTemplateParams.isEmpty()) {
                    MbgSqlHelper.executeBatch((Connection)conn, (String)("Delete FROM " + tempTable + " Where FRootId = ? AND FOrgUnitId = ?"), noTemplateParams);
                }
                MbgSqlHelper.execute((Connection)conn, (String)("Delete FROM T_MBG_BgCalcSchePeriod Where FTemplateId IN(Select FID FROM T_MBG_BgCalcScheEntryTem Where FID IN(Select FTemplateId FROM T_MBG_BgCalcSchemeEntry Where FBgCalculateSchemeID IN(Select FThisId FROM " + tempTable + " Where FThisId IS NOT NULL)))"));
                MbgSqlHelper.execute((Connection)conn, (String)("Delete FROM T_MBG_BgCalcScheEntryTem Where FID IN(Select FTemplateId FROM T_MBG_BgCalcSchemeEntry Where FBgCalculateSchemeID IN(Select FThisId FROM " + tempTable + " Where FThisId IS NOT NULL))"));
                MbgSqlHelper.execute((Connection)conn, (String)("Delete FROM T_MBG_BgCalcSchemeEntry Where FBgCalculateSchemeID IN(Select FThisId FROM " + tempTable + " Where FThisId IS NOT NULL)"));
                MbgSqlHelper.execute((Connection)conn, (String)("Delete FROM T_MBG_BgCalcScheme Where FID IN(Select FThisId FROM " + tempTable + " Where FThisId IS NOT NULL)"));
            }
            if (!saveCol.isEmpty()) {
                for (int i = 0; i < saveCol.size(); ++i) {
                    info = (BgCalculateSchemeInfo)saveCol.get(i);
                    if (info.getId() != null || !existMap.containsKey(info.getOrgUnit().getId().toString() + "_" + info.getNumber())) continue;
                    info.setId(BOSUuid.read((String)((String)existMap.get(info.getOrgUnit().getId().toString() + "_" + info.getNumber()))));
                }
                BgCalculateSchemeFactory.getLocalInstance(ctx).addnewBatchData(saveCol);
            }
            arrayList = result;
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                pool.releaseTable(tempTable);
                SQLUtils.cleanup(rst);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        pool.releaseTable(tempTable);
        SQLUtils.cleanup((ResultSet)rst);
        SQLUtils.cleanup((Connection)conn);
        return arrayList;
    }

    protected String getAssignKey(Object superId, Object orgUnitId) {
        return superId + "_" + orgUnitId;
    }

    @Override
    protected Object _execute(Context ctx, Object params) throws BOSException, EASBizException {
        if (!(params instanceof List)) {
            return null;
        }
        BgCalculateSchemeCollection coll = null;
        List list = (List)params;
        if (list != null && !list.isEmpty() && list.get(0) instanceof String) {
            StringBuffer sql = new StringBuffer();
            sql.append("update T_MBG_BgCalcScheme set fisformal = 1 where frootid in ");
            StringBuffer filter = new StringBuffer();
            filter.append("(");
            for (int i = 0; i < list.size(); ++i) {
                if (i == list.size() - 1) {
                    filter.append("'").append(list.get(i)).append("'");
                    continue;
                }
                filter.append("'").append(list.get(i)).append("',");
            }
            filter.append(")");
            sql.append(filter.toString());
            sql.append("or fid in ").append(filter.toString());
            DbUtil.execute((Context)ctx, (String)sql.toString());
            StringBuffer sql1 = new StringBuffer("select id,name,orgUnit.id,orgUnit.name where rootid in " + filter.toString());
            sql1.append("or id in ").append(filter.toString());
            coll = BgCalculateSchemeFactory.getLocalInstance(ctx).getBgCalculateSchemeCollection(sql1.toString());
        }
        return coll;
    }

    @Override
    protected boolean _antiExecute(Context ctx, Object params) throws BOSException, EASBizException {
        if (!(params instanceof List)) {
            return false;
        }
        List list = (List)params;
        if (list != null && !list.isEmpty() && list.get(0) instanceof String) {
            StringBuffer sql = new StringBuffer();
            sql.append("update T_MBG_BgCalcScheme set fisformal = 0 where frootid in (");
            StringBuffer filter = new StringBuffer();
            for (int i = 0; i < list.size(); ++i) {
                if (i == list.size() - 1) {
                    filter.append("'").append(list.get(i)).append("'");
                    continue;
                }
                filter.append("'").append(list.get(i)).append("',");
            }
            filter.append(")");
            sql.append(filter.toString());
            sql.append(" or fid in ( ").append(filter.toString());
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        return true;
    }

    @Override
    protected void _reCalculateByTransaction(Context ctx) throws BOSException, EASBizException {
        HashMap<String, String> bgSchemeOrgViewId = new HashMap<String, String>();
        HashMap calSchemeOrgViewId = new HashMap();
        IRowSet row = null;
        try {
            row = DbUtil.executeQuery((Context)ctx, (String)"Select t0.FMemberID, t1.FBgSchemeID FROM T_MBG_BgDimSettingsMember t0, T_MBG_BgDimSettings t1 Where t0.FBgDimSettingsID = t1.FID");
            while (row.next()) {
                bgSchemeOrgViewId.put(row.getString("FBgSchemeID"), row.getString("FMemberID"));
            }
            SQLUtils.cleanup((ResultSet)row);
            if (bgSchemeOrgViewId.isEmpty()) {
                return;
            }
            row = DbUtil.executeQuery((Context)ctx, (String)"select fid, fbgschemeid from T_MBG_BgCalcScheme where frootId = fid");
            while (row.next()) {
                calSchemeOrgViewId.put(row.getString("FID"), bgSchemeOrgViewId.get(row.getString("fbgschemeid")));
            }
            SQLUtils.cleanup((ResultSet)row);
            for (String calcScheId : calSchemeOrgViewId.keySet()) {
                this.executeCalculateScheme(ctx, calcScheId, (String)calSchemeOrgViewId.get(calcScheId));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)row);
        }
    }

    public void executeCalculateScheme(Context ctx, String calculateSchemeID, String bgOrgViewId) throws Exception {
        LinkedHashSet<String> orgList = new LinkedHashSet<String>();
        String sql = "select forgunitid , flongnumber from T_MBG_BgOrgUnit where forgunitid in (select forgunitid from T_MBG_BgCalcScheme where frootid='" + calculateSchemeID + "' and FISFORMAL = 1 ) order by flevel desc, flongnumber asc";
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (row != null) {
            while (row.next()) {
                orgList.add(row.getString("forgunitid"));
            }
        }
        HashMap<String, BgCalculateSchemeInfo> bcsMap = new HashMap<String, BgCalculateSchemeInfo>();
        IBgCalculateScheme iBgCalculateScheme = BgCalculateSchemeFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("rootId", (Object)calculateSchemeID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isFormal", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(BgReCalcSchemeHelper.getSelectors());
        BgCalculateSchemeCollection coll = iBgCalculateScheme.getBgCalculateSchemeCollection(view);
        if (coll != null) {
            for (int i = 0; i < coll.size(); ++i) {
                BgCalculateSchemeInfo info = coll.get(i);
                bcsMap.put(info.getOrgUnit().getId().toString(), info);
            }
        }
        BgCalculateSchemeInfo info = null;
        for (String orgId : orgList) {
            info = (BgCalculateSchemeInfo)bcsMap.get(orgId);
            if (info == null) continue;
            BgReCalcSchemeHelper.sortBgCalcSchemeInfosTemplateAndPeriods(info);
            for (int j = 0; j < info.getEntry().size(); ++j) {
                BgCalculateSchemeEntryInfo entryInfo = info.getEntry().get(j);
                for (int k = 0; k < entryInfo.getTemplate().getPeriod().size(); ++k) {
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("org_id", info.getOrgUnit().getId().toString());
                    param.put("bgScheme_id", info.getBgScheme().getId().toString());
                    param.put("bgTemplate_id", entryInfo.getTemplate().getTemplate().getId().toString());
                    param.put("bgPeriod_id", entryInfo.getTemplate().getPeriod().get(k).getPeriod().getId().toString());
                    param.put("currency_id", info.getCurrency().getId().toString());
                    param.put("bgversion_id", info.getBgVersion().getId().toString());
                    param.put("bgprocess_numbers", info.getProcessTypeNumber());
                    param.put("isCalculate", entryInfo.isIsCalculate());
                    param.put("sheetIdList", null);
                    param.put("isMultiOrg", Boolean.FALSE);
                    param.put("selectOrgIds", orgList);
                    this._reCalculate(ctx, param);
                }
            }
        }
    }

    protected Map getBgDataMap(BgFormInfo bgFormInfo) {
        Map bgdataMap = (Map)bgFormInfo.get("CELL_DATA");
        if (bgdataMap.get(bgFormInfo.getOrgUnit().getId().toString()) instanceof Map) {
            return (Map)bgdataMap.get(bgFormInfo.getOrgUnit().getId().toString());
        }
        return bgdataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getInitBudgetDataMap(BgFormInfo bgFormInfo) throws Exception {
        Map bgdataMap;
        Map _bgdataMap = bgdataMap = (Map)bgFormInfo.get("CELL_DATA");
        if (bgdataMap.get(bgFormInfo.getOrgUnit().getId().toString()) instanceof Map) {
            _bgdataMap = (Map)bgdataMap.get(bgFormInfo.getOrgUnit().getId().toString());
        }
        HashMap<String, BigDecimal> initMap = new HashMap<String, BigDecimal>();
        Book book = bgFormInfo.getBook();
        BgNFSHelper.disableUndo(book);
        BgNFSHelper.disableCal(book);
        try {
            for (int s = 0; s < book.getSheetCount(); ++s) {
                Sheet sheet = book.getSheet(s);
                for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                    for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                        String _tmpStr;
                        String _bgDataKey;
                        Cell cell = sheet.getCell(r, c, false);
                        if (!BgNFSHelper.checkHasFormulaOfCell(cell) || !_bgdataMap.containsKey(_bgDataKey = DimUtils.getDimDataKey(_tmpStr = BgNFSHelper.getFormulaOfCell(cell), bgFormInfo.getBgVersion().getNumber()))) continue;
                        BgNDataInfo _info = (BgNDataInfo)_bgdataMap.get(_bgDataKey);
                        if (cell == null || _info == null) continue;
                        initMap.put(_tmpStr, _info.getBudgetValue());
                    }
                }
            }
        }
        finally {
            BgNFSHelper.enableCal(book);
            BgNFSHelper.enableUndo(book);
        }
        return initMap;
    }

    protected Map getInitBudgetData(Context ctx, String bgFormId) throws BOSException, EASBizException, SQLException {
        HashMap<String, BigDecimal> initMap = new HashMap<String, BigDecimal>();
        if (StringUtils.isEmpty((String)bgFormId)) {
            return initMap;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String dataTableName = BgCubeUtils.getBgDataTableNameByFormId(ctx, bgFormId);
        if (StringUtils.isEmpty((String)dataTableName)) {
            return null;
        }
        String dataEntryTableName = BgCubeUtils.getBudgetEntryCubeName(dataTableName);
        String querySql = "select FFormula, FValue from " + dataTableName + " where Fid in(Select FDataId From " + dataEntryTableName + " Where FFormId = ?)";
        String formulaStr = null;
        BigDecimal value = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(querySql);
            pstmt.setString(1, bgFormId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                formulaStr = rst.getString("FFormula");
                value = rst.getBigDecimal("FValue");
                initMap.put(formulaStr, value);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BgFormException(BgFormException.DATABASEERROR, e.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return initMap;
    }

    protected void saveBgData(Context ctx, BgFormInfo bgFormInfo, Map initValueMap, Map adjustMap) throws EASBizException, BOSException {
    }

    @Override
    @Deprecated
    protected Map _getNotAssigned(Context ctx, Map param) throws BOSException, EASBizException {
        Hashtable notAssingedTbale = new Hashtable();
        return notAssingedTbale;
    }

    @Override
    protected Map _queryDispatchInfo(Context ctx, BOSUuid bgSchemeId) throws BOSException, EASBizException {
        HashMap dispatchMap = new HashMap();
        HashMap bgTemplateIdsMap = new HashMap();
        dispatchMap.put(BgSchemeDispatchConstants.SCHEME_DISPATCH, bgTemplateIdsMap);
        if (ctx == null || bgSchemeId == null) {
            return dispatchMap;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select t.FRootId, t.FOrgUnitId from T_MBG_BgCalcScheme t where FBgSchemeId = ?");
        Object[] sqlParams = new Object[]{bgSchemeId.toString()};
        BOSUuid bgTemRootId = null;
        BOSUuid orgUnitId = null;
        Set<BOSUuid> orgUnitIds = null;
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
            while (rst.next()) {
                bgTemRootId = BOSUuid.read((String)rst.getString("FRootId"));
                orgUnitId = BOSUuid.read((String)rst.getString("FOrgUnitId"));
                if (bgTemplateIdsMap.containsKey(bgTemRootId)) {
                    orgUnitIds = (Set)bgTemplateIdsMap.get(bgTemRootId);
                } else {
                    orgUnitIds = new HashSet();
                    bgTemplateIdsMap.put(bgTemRootId, orgUnitIds);
                }
                orgUnitIds.add(orgUnitId);
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"queryDispatchInfo Sql Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return dispatchMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object _reCalculate(Context ctx, String bgCalcSchemeId, IObjectValue info, Set selectOrgIds) throws BOSException, EASBizException {
        ArrayList resultlst;
        block26: {
            resultlst = new ArrayList();
            if (StringUtils.isEmpty((String)bgCalcSchemeId) || !(info instanceof BgFinalizedResultInfo)) {
                return resultlst;
            }
            boolean isExpetion = false;
            try {
                BgCalculateSchemeInfo calcSchemeInfo = null;
                IBgCalculateScheme iBgCalculateScheme = BgCalculateSchemeFactory.getLocalInstance(ctx);
                HashSet<String> distributedOrgUnitId = new HashSet<String>();
                BgCalculateSchemeInfo thisInfo = iBgCalculateScheme.getBgCalculateSchemeInfo((IObjectPK)new ObjectUuidPK(bgCalcSchemeId), BgReCalcSchemeHelper.getSelectors());
                BgSchemeInfo bgSchemeInfo = thisInfo.getBgScheme();
                BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeInfo.getId().toString());
                BgCalculateSchemeCollection bgCalculateSchemeCollection = iBgCalculateScheme.getBgCalculateSchemeCollection("select orgUnit.id where rootid = '" + thisInfo.getRootId().toString() + "'");
                int in = bgCalculateSchemeCollection.size();
                for (int i = 0; i < in; ++i) {
                    distributedOrgUnitId.add(bgCalculateSchemeCollection.get(i).getOrgUnit().getId().toString());
                }
                BgOrgUnitInfo bgOrgUnit = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitInfo("select id, orgUnitId, number, name, longNumber where viewId = '" + schemeHelper.getBgOrgViewId() + "' and orgUnitId = '" + thisInfo.getOrgUnit().getId() + "' and isVirtual = 0");
                BgOrgUnitCollection orgCol = MbgDataHelper.getBgOrgUnitChildren(ctx, bgOrgUnit, schemeHelper.getBgOrgViewId());
                ArrayList<BgOrgUnitInfo> bgOrgUnits = new ArrayList<BgOrgUnitInfo>();
                if (orgCol != null && !orgCol.isEmpty()) {
                    if (!this.isEmpty(selectOrgIds)) {
                        HashSet<String> selectOrgNumbers = null;
                        selectOrgNumbers = new HashSet<String>();
                        for (int o = 0; o < orgCol.size(); ++o) {
                            bgOrgUnit = orgCol.get(o);
                            if (!selectOrgIds.contains(bgOrgUnit.getOrgUnitID())) continue;
                            selectOrgNumbers.add(bgOrgUnit.getNumber());
                        }
                        String[] longNumbers = null;
                        block7: for (int o = 0; o < orgCol.size(); ++o) {
                            bgOrgUnit = orgCol.get(o);
                            longNumbers = bgOrgUnit.getLongNumber().split("!");
                            for (int l = 0; l < longNumbers.length; ++l) {
                                if (!selectOrgNumbers.contains(longNumbers[l])) continue;
                                bgOrgUnits.add(bgOrgUnit);
                                continue block7;
                            }
                        }
                    } else {
                        for (int i = 0; i < orgCol.size(); ++i) {
                            bgOrgUnits.add(orgCol.get(i));
                        }
                    }
                }
                Collections.sort(bgOrgUnits, new Comparator<BgOrgUnitInfo>(){

                    @Override
                    public int compare(BgOrgUnitInfo o1, BgOrgUnitInfo o2) {
                        int a = o2.getLevel() - o1.getLevel();
                        if (a == 0) {
                            return o2.getLongNumber().compareTo(o1.getLongNumber());
                        }
                        return a;
                    }
                });
                LinkedHashSet<String> orgList = new LinkedHashSet<String>();
                for (BgOrgUnitInfo bgOrgInfo : bgOrgUnits) {
                    orgList.add(bgOrgInfo.getOrgUnitID());
                }
                this.beforeCheckAdjust(ctx, bgSchemeInfo.getId().toString(), orgList, orgList, BgReCalcSchemeHelper.getBgProcessTypes(thisInfo.getProcessTypeNumber()));
                HashMap<String, BgCalculateSchemeInfo> bcsMap = new HashMap<String, BgCalculateSchemeInfo>();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("rootId", (Object)thisInfo.getRootId().toString(), CompareType.EQUALS));
                view.setFilter(filter);
                view.setSelector(BgReCalcSchemeHelper.getSelectors());
                BgCalculateSchemeCollection coll = iBgCalculateScheme.getBgCalculateSchemeCollection(view);
                if (coll != null) {
                    for (int i = 0; i < coll.size(); ++i) {
                        calcSchemeInfo = coll.get(i);
                        if (!orgList.contains(calcSchemeInfo.getOrgUnit().getId().toString())) continue;
                        bcsMap.put(calcSchemeInfo.getOrgUnit().getId().toString(), calcSchemeInfo);
                    }
                }
                Map<String, Map<String, BgCalculateSchemeReportInfo>> bgCalcSchemeReportMap = this.initResult(ctx, info, orgList, bcsMap);
                if (BgCalculateSchemeServerThread.getOptimalPoolSize(ctx) > 1) {
                    BgCalculateSchemeServerThread bgCalculateSchemeServerThread = new BgCalculateSchemeServerThread(ctx, orgList, info, bgCalcSchemeReportMap, bcsMap);
                    bgCalculateSchemeServerThread.reCalculateThread();
                } else {
                    String bgPeriodId = null;
                    String bgVersionId = null;
                    String bgTemplateId = null;
                    String currencyId = null;
                    int index = 0;
                    for (String orgId : orgList) {
                        calcSchemeInfo = (BgCalculateSchemeInfo)bcsMap.get(orgId);
                        if (calcSchemeInfo == null) continue;
                        BgReCalcSchemeHelper.sortBgCalcSchemeInfosTemplateAndPeriods(calcSchemeInfo);
                        for (int j = 0; j < calcSchemeInfo.getEntry().size(); ++j) {
                            BgCalculateSchemeEntryInfo entryInfo = calcSchemeInfo.getEntry().get(j);
                            for (int k = 0; k < entryInfo.getTemplate().getPeriod().size(); ++k) {
                                List<BgProcessEnum> bgProcessTypes = BgReCalcSchemeHelper.getBgProcessTypes(calcSchemeInfo.getProcessTypeNumber());
                                for (BgProcessEnum bgProcessType : bgProcessTypes) {
                                    bgTemplateId = entryInfo.getTemplate().getTemplate().getId().toString();
                                    bgPeriodId = entryInfo.getTemplate().getPeriod().get(k).getPeriod().getId().toString();
                                    bgVersionId = calcSchemeInfo.getBgVersion().getId().toString();
                                    currencyId = calcSchemeInfo.getCurrency().getId().toString();
                                    String key = BgReCalcSchemeHelper.getCalcFormKey(orgId, bgPeriodId, bgVersionId, currencyId, bgTemplateId, bgProcessType.getName());
                                    HashMap<String, Object> param = new HashMap<String, Object>();
                                    param.put("org_id", calcSchemeInfo.getOrgUnit().getId().toString());
                                    param.put("bgScheme_id", calcSchemeInfo.getBgScheme().getId().toString());
                                    param.put("bgTemplate_id", bgTemplateId);
                                    param.put("bgPeriod_id", bgPeriodId);
                                    param.put("currency_id", currencyId);
                                    param.put("bgversion_id", bgVersionId);
                                    param.put("bgprocess_numbers", bgProcessType.getName());
                                    param.put("isCalculate", entryInfo.isIsCalculate());
                                    param.put("sheetIdList", null);
                                    param.put("isMultiOrg", Boolean.TRUE);
                                    param.put("selectOrgIds", orgList);
                                    param.put("is_write_report", Boolean.TRUE);
                                    this.saveCalcResult(ctx, calcSchemeInfo, info, ++index);
                                    if (bgCalcSchemeReportMap.containsKey(key)) {
                                        param.put("report_info", bgCalcSchemeReportMap.get(key));
                                    }
                                    Object object = this._reCalculate(ctx, param);
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"\u6570\u636e\u91cd\u7b97\u65b9\u6848\u91cd\u7b97\u5f02\u5e38\uff1a", (Throwable)e);
                if (e.getCause() instanceof BgFormException) {
                    isExpetion = true;
                    BgFinalizedResultInfo resultInfo = (BgFinalizedResultInfo)info;
                    resultInfo.setResult(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"calcFinish", (Locale)this.getLocale(ctx)));
                    resultInfo.setState(BgFinalizedResultEnum.exception);
                    resultInfo.setException(((BgFormException)((Object)e.getCause())).getCode() + "#" + ((BgFormException)((Object)e.getCause())).getMessage());
                    BgFinalizedResultFactory.getLocalInstance(ctx).save(resultInfo);
                    break block26;
                }
                throw new BOSException((Throwable)e);
            }
            finally {
                if (info instanceof BgFinalizedResultInfo && !isExpetion) {
                    BgFinalizedResultInfo resultInfo = (BgFinalizedResultInfo)info;
                    resultInfo.setResult(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgCalcSchemeResource", (String)"calcFinish", (Locale)this.getLocale(ctx)));
                    resultInfo.setState(BgFinalizedResultEnum.calcFinish);
                    BgFinalizedResultFactory.getLocalInstance(ctx).save(resultInfo);
                }
            }
        }
        return resultlst;
    }

    protected Map<String, Map<String, BgCalculateSchemeReportInfo>> initResult(Context ctx, IObjectValue info, Set<String> orgList, Map<String, BgCalculateSchemeInfo> bcsMap) throws EASBizException, BOSException {
        HashMap<String, Map<String, BgCalculateSchemeReportInfo>> bgCalcSchemeReportMap = new HashMap<String, Map<String, BgCalculateSchemeReportInfo>>();
        if (info == null || !(info instanceof BgFinalizedResultInfo) || orgList == null || orgList.isEmpty() || bcsMap == null || bcsMap.isEmpty()) {
            return bgCalcSchemeReportMap;
        }
        BgFinalizedResultInfo resultInfo = (BgFinalizedResultInfo)info;
        BgCalculateSchemeInfo calcSchemInfo = null;
        String bgSchemeId = null;
        HashSet<String> bgVersionIds = new HashSet<String>();
        HashSet<String> bgPeriodIds = new HashSet<String>();
        HashSet<String> bgTemplateIds = new HashSet<String>();
        HashSet<String> currencyIds = new HashSet<String>();
        HashSet<Integer> bgProcessTypes = new HashSet<Integer>();
        int sumCount = 0;
        for (String orgId : orgList) {
            calcSchemInfo = bcsMap.get(orgId);
            if (calcSchemInfo == null) continue;
            Set<Integer> bgProcessTypeSet = BgReCalcSchemeHelper.getBgProcessTypeSet(calcSchemInfo.getProcessTypeNumber());
            BgReCalcSchemeHelper.sortBgCalcSchemeInfosTemplateAndPeriods(calcSchemInfo);
            for (int j = 0; j < calcSchemInfo.getEntry().size(); ++j) {
                BgCalculateSchemeEntryInfo entryInfo = calcSchemInfo.getEntry().get(j);
                for (int k = 0; k < entryInfo.getTemplate().getPeriod().size(); ++k) {
                    for (Integer processType : bgProcessTypeSet) {
                        ++sumCount;
                    }
                    bgSchemeId = calcSchemInfo.getBgScheme().getId().toString();
                    bgVersionIds.add(calcSchemInfo.getBgVersion().getId().toString());
                    bgPeriodIds.add(entryInfo.getTemplate().getPeriod().get(k).getPeriod().getId().toString());
                    bgTemplateIds.add(entryInfo.getTemplate().getTemplate().getId().toString());
                    currencyIds.add(calcSchemInfo.getCurrency().getId().toString());
                    bgProcessTypes.addAll(bgProcessTypeSet);
                }
            }
        }
        resultInfo.setTotalCount(sumCount);
        resultInfo.setCurrentIndex(0);
        resultInfo.setState(BgFinalizedResultEnum.calc);
        BgFinalizedResultFactory.getLocalInstance(ctx).save(resultInfo);
        Map<String, Map<String, BgFormInfo>> bgFormMap = this.queryCalcForms(ctx, bgSchemeId, orgList, bgVersionIds, bgPeriodIds, bgTemplateIds, currencyIds, bgProcessTypes);
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        Timestamp time = new Timestamp(System.currentTimeMillis());
        BgCalculateSchemeReportInfo reportInfo = null;
        CoreBaseCollection reportColls = new CoreBaseCollection();
        String bgPeriodId = null;
        String bgVersionId = null;
        String bgTemplateId = null;
        String currencyId = null;
        for (String orgId : orgList) {
            calcSchemInfo = bcsMap.get(orgId);
            if (calcSchemInfo == null) continue;
            BgReCalcSchemeHelper.sortBgCalcSchemeInfosTemplateAndPeriods(calcSchemInfo);
            for (int j = 0; j < calcSchemInfo.getEntry().size(); ++j) {
                BgCalculateSchemeEntryInfo entryInfo = calcSchemInfo.getEntry().get(j);
                for (int k = 0; k < entryInfo.getTemplate().getPeriod().size(); ++k) {
                    List<BgProcessEnum> bgProcessTypesLst = BgReCalcSchemeHelper.getBgProcessTypes(calcSchemInfo.getProcessTypeNumber());
                    for (BgProcessEnum bgProcessType : bgProcessTypesLst) {
                        bgTemplateId = entryInfo.getTemplate().getTemplate().getId().toString();
                        bgPeriodId = entryInfo.getTemplate().getPeriod().get(k).getPeriod().getId().toString();
                        String key = BgReCalcSchemeHelper.getCalcFormKey(orgId, bgPeriodId, bgVersionId = calcSchemInfo.getBgVersion().getId().toString(), currencyId = calcSchemInfo.getCurrency().getId().toString(), bgTemplateId, bgProcessType.getName());
                        if (!bgCalcSchemeReportMap.containsKey(key)) {
                            bgCalcSchemeReportMap.put(key, new HashMap());
                        }
                        if (bgFormMap.containsKey(key)) {
                            Map<String, BgFormInfo> sMap = bgFormMap.get(key);
                            for (String dimNum : sMap.keySet()) {
                                reportInfo = new BgCalculateSchemeReportInfo();
                                reportInfo.setId(BOSUuid.create((BOSObjectType)reportInfo.getBOSType()));
                                reportInfo.setBgCalcScheme(calcSchemInfo);
                                reportInfo.setOrgUnit(calcSchemInfo.getOrgUnit());
                                reportInfo.setBgPeriod(entryInfo.getTemplate().getPeriod().get(k).getPeriod());
                                reportInfo.setBgTemplate(entryInfo.getTemplate().getTemplate());
                                reportInfo.setExecutor(user);
                                reportInfo.setStartTime(time);
                                reportInfo.setBgForm(sMap.get(dimNum));
                                reportColls.add((CoreBaseInfo)reportInfo);
                                ((Map)bgCalcSchemeReportMap.get(key)).put(dimNum, reportInfo);
                            }
                            continue;
                        }
                        reportInfo = new BgCalculateSchemeReportInfo();
                        reportInfo.setId(BOSUuid.create((BOSObjectType)reportInfo.getBOSType()));
                        reportInfo.setBgCalcScheme(calcSchemInfo);
                        reportInfo.setOrgUnit(calcSchemInfo.getOrgUnit());
                        reportInfo.setBgPeriod(entryInfo.getTemplate().getPeriod().get(k).getPeriod());
                        reportInfo.setBgTemplate(entryInfo.getTemplate().getTemplate());
                        reportInfo.setExecutor(user);
                        reportInfo.setStartTime(time);
                        reportColls.add((CoreBaseInfo)reportInfo);
                        ((Map)bgCalcSchemeReportMap.get(key)).put(NULL, reportInfo);
                    }
                }
            }
        }
        if (!reportColls.isEmpty()) {
            BgCalculateSchemeReportFactory.getLocalInstance(ctx).submitBatchData(reportColls);
        }
        return bgCalcSchemeReportMap;
    }

    protected void saveCalcResult(Context ctx, BgCalculateSchemeInfo calcSchemeInfo, IObjectValue info, int index) throws EASBizException, BOSException {
        BgReCalcSchemeHelper.saveCalcResult(ctx, calcSchemeInfo, info, index);
    }

    protected void saveCalcReport(Context ctx, BgCalculateSchemeReportInfo reportInfo, String result) throws EASBizException, BOSException {
        Timestamp time = new Timestamp(System.currentTimeMillis());
        reportInfo.setFinishTime(time);
        reportInfo.setResult(result);
        BgCalculateSchemeReportFactory.getLocalInstance(ctx).save(reportInfo);
    }

    protected void saveCalcReport(Context ctx, Map paramMap, BgFormInfo bgFormInfo, String calcResult) throws EASBizException, BOSException {
        Boolean isWriteReport = paramMap.get("is_write_report") instanceof Boolean ? (Boolean)paramMap.get("is_write_report") : Boolean.FALSE;
        Map reportMap = paramMap.get("report_info") instanceof Map ? (Map)paramMap.get("report_info") : null;
        String currencyId = (String)paramMap.get("currency_id");
        BgCalculateSchemeReportInfo info = null;
        if (reportMap != null) {
            if (bgFormInfo != null) {
                if (!StringUtils.isEmpty((String)bgFormInfo.getSpecialItemNumber()) && reportMap.containsKey(bgFormInfo.getSpecialItemNumber())) {
                    info = (BgCalculateSchemeReportInfo)reportMap.get(bgFormInfo.getSpecialItemNumber());
                    this.saveCalcReport(ctx, info, calcResult);
                } else if (reportMap.containsKey(NULL)) {
                    info = (BgCalculateSchemeReportInfo)reportMap.get(NULL);
                    this.saveCalcReport(ctx, info, calcResult);
                }
            } else if (reportMap.containsKey(NULL)) {
                info = (BgCalculateSchemeReportInfo)reportMap.get(NULL);
                this.saveCalcReport(ctx, info, calcResult);
            }
        }
    }

    protected boolean isEmpty(Collection colls) {
        return colls == null || colls.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, Map<String, BgFormInfo>> queryCalcForms(Context ctx, String bgSchemeId, Set<String> orgIds, Set<String> bgVersionIds, Set<String> bgPeriodIds, Set<String> bgTemplateIds, Set<String> currencyIds, Set<Integer> processTypes) throws BOSException {
        HashMap<String, Map<String, BgFormInfo>> bgFormMap = new HashMap<String, Map<String, BgFormInfo>>();
        if (StringUtils.isEmpty((String)bgSchemeId)) return bgFormMap;
        if (this.isEmpty(orgIds)) return bgFormMap;
        if (this.isEmpty(bgVersionIds)) return bgFormMap;
        if (this.isEmpty(bgPeriodIds)) return bgFormMap;
        if (this.isEmpty(bgTemplateIds)) return bgFormMap;
        if (this.isEmpty(processTypes)) {
            return bgFormMap;
        }
        String tmpOrgUnitTable = null;
        String tmpBgPeriodTable = null;
        String tmpTemplateTable = null;
        String tmpCurrencyTable = null;
        String tmpVersionTable = null;
        Connection conn = null;
        Object rst = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        BgFormCollection bgFormList = new BgFormCollection();
        try {
            conn = this.getConnection(ctx);
            tmpOrgUnitTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpOrgUnitTable + " (FID) values (?)"), orgIds);
            tmpVersionTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpVersionTable + " (FID) values (?)"), bgVersionIds);
            tmpBgPeriodTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpBgPeriodTable + " (FID) values (?)"), bgPeriodIds);
            tmpTemplateTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTemplateTable + " (FID) values (?)"), bgTemplateIds);
            tmpCurrencyTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpCurrencyTable + " (FID) values (?)"), currencyIds);
            StringBuffer pSql = new StringBuffer();
            if (processTypes != null) {
                pSql.append(" and FProcessType IN(");
                MbgSqlHelper.addPlaceHolder((StringBuffer)pSql, (int)processTypes.size()).append(")");
            }
            StringBuffer queryBgFormSql = new StringBuffer();
            queryBgFormSql.append(" select t0.fid, t0.fadjustid, t0.fstate, t0.fname, t0.fnumber, t0.fdatasource, t0.fprocesstype, t1.FDimensionNumber, t1.FMemberDisplayName,  t0.forgunitid, t0.fbgperiodid, t0.fcurrencyid, t0.fbgversionId, t0.FBgTemplateID  from t_mbg_bgform t0 Left Join T_MBG_BgSpecialItems t1 ON t0.FID = t1.FBgFormId where t0.forgunitid in (select FID from " + tmpOrgUnitTable + ") and t0.fbgschemeid = ? ");
            queryBgFormSql.append(" and t0.fbgtemplateid in (select FID From " + tmpTemplateTable + ") and t0.fbgperiodid in (select FID from " + tmpBgPeriodTable + ") and t0.fcurrencyid in (select FID from " + tmpCurrencyTable + ") and t0.fbgversionId in (select FID from " + tmpVersionTable + ") and t0.fstate not in (").append(5).append(",").append(15).append(" )");
            queryBgFormSql.append(" and t0.fid not in (select fadjustId from t_mbg_bgform where fstate in (").append(4).append(",").append(35).append("))");
            queryBgFormSql.append(pSql);
            pstmt = conn.prepareStatement(queryBgFormSql.toString());
            pstmt.setString(1, bgSchemeId);
            if (processTypes != null) {
                ArrayList<Integer> lst = new ArrayList<Integer>(processTypes);
                for (int i = 0; i < lst.size(); ++i) {
                    pstmt.setInt(2 + i, (Integer)lst.get(i));
                }
            }
            rs = pstmt.executeQuery();
            int state = 0;
            BgFormInfo bgFormInfo = null;
            BgSchemeInfo bgSchemeInfo = null;
            FullOrgUnitInfo orgUnitInfo = null;
            BgPeriodInfo bgPeriodInfo = null;
            BgVersionInfo bgVersionInfo = null;
            CurrencyInfo currencyInfo = null;
            BgTemplateInfo bgTemplateInfo = null;
            String key = null;
            String specialDimNum = NULL;
            while (rs.next()) {
                bgFormInfo = new BgFormInfo();
                bgFormInfo.setName(rs.getString("fname"));
                bgFormInfo.setNumber(rs.getString("fnumber"));
                bgFormInfo.setDataSource(BgFormDataSourceEnum.getEnum(rs.getInt("fdatasource")));
                bgFormInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                state = rs.getInt("fstate");
                bgFormInfo.setState(BgFormStateEnum.getEnum(state));
                bgSchemeInfo = new BgSchemeInfo();
                bgSchemeInfo.setId(BOSUuid.read((String)bgSchemeId));
                bgFormInfo.setBgScheme(bgSchemeInfo);
                bgFormInfo.setProcessType(BgProcessEnum.getEnum(rs.getInt("fprocesstype")));
                bgTemplateInfo = new BgTemplateInfo();
                bgTemplateInfo.setId(BOSUuid.read((String)rs.getString("FBgTemplateID")));
                bgFormInfo.setBgTemplate(bgTemplateInfo);
                if (!StringUtils.isEmpty((String)rs.getString("FDimensionNumber"))) {
                    bgFormInfo.getBgSpecialItems().add(new BgSpecialItemsInfo());
                    bgFormInfo.getBgSpecialItems().get(0).setDimensionNumber(rs.getString("FDimensionNumber"));
                    bgFormInfo.getBgSpecialItems().get(0).setMemberDisplayName(rs.getString("FMemberDisplayName"));
                    bgFormInfo.getBgTemplate().setFormType(BgTemFormTypeEnum.SPECIALFORM);
                }
                orgUnitInfo = new FullOrgUnitInfo();
                orgUnitInfo.setId(BOSUuid.read((String)rs.getString("forgunitid")));
                bgFormInfo.setOrgUnit(orgUnitInfo);
                bgPeriodInfo = new BgPeriodInfo();
                bgPeriodInfo.setId(BOSUuid.read((String)rs.getString("fbgperiodid")));
                bgFormInfo.setBgPeriod(bgPeriodInfo);
                bgVersionInfo = new BgVersionInfo();
                bgVersionInfo.setId(BOSUuid.read((String)rs.getString("fbgversionId")));
                bgFormInfo.setBgVersion(bgVersionInfo);
                currencyInfo = new CurrencyInfo();
                currencyInfo.setId(BOSUuid.read((String)rs.getString("fcurrencyid")));
                bgFormInfo.setCurrency(currencyInfo);
                key = BgReCalcSchemeHelper.getCalcFormKey(bgFormInfo.getOrgUnit().getId().toString(), bgFormInfo.getBgPeriod().getId().toString(), bgFormInfo.getBgVersion().getId().toString(), bgFormInfo.getCurrency().getId().toString(), bgFormInfo.getBgTemplate().getId().toString(), bgFormInfo.getProcessType().getName());
                if (!bgFormMap.containsKey(key)) {
                    bgFormMap.put(key, new HashMap());
                }
                specialDimNum = !StringUtils.isEmpty((String)bgFormInfo.getSpecialItemNumber()) ? bgFormInfo.getSpecialItemNumber() : NULL;
                ((Map)bgFormMap.get(key)).put(specialDimNum, bgFormInfo);
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    BgDBUtils.releaseDBTmpTable((Connection)conn, (TempTablePool)pool, tmpOrgUnitTable);
                    BgDBUtils.releaseDBTmpTable((Connection)conn, (TempTablePool)pool, tmpTemplateTable);
                    BgDBUtils.releaseDBTmpTable((Connection)conn, (TempTablePool)pool, tmpBgPeriodTable);
                    BgDBUtils.releaseDBTmpTable((Connection)conn, (TempTablePool)pool, tmpCurrencyTable);
                    BgDBUtils.releaseDBTmpTable((Connection)conn, (TempTablePool)pool, tmpVersionTable);
                }
                catch (Exception e2) {
                    logger.error((Object)"", (Throwable)e2);
                    throw new BOSException((Throwable)e2);
                }
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        try {
            BgDBUtils.releaseDBTmpTable((Connection)conn, (TempTablePool)pool, (String)tmpOrgUnitTable);
            BgDBUtils.releaseDBTmpTable((Connection)conn, (TempTablePool)pool, (String)tmpTemplateTable);
            BgDBUtils.releaseDBTmpTable((Connection)conn, (TempTablePool)pool, (String)tmpBgPeriodTable);
            BgDBUtils.releaseDBTmpTable((Connection)conn, (TempTablePool)pool, (String)tmpCurrencyTable);
            BgDBUtils.releaseDBTmpTable((Connection)conn, (TempTablePool)pool, (String)tmpVersionTable);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return bgFormMap;
    }

    private class PastDataTmpInfo {
        private String formula = null;
        private BigDecimal pastValue = null;
        private BigDecimal balance = null;
        private String adjustorID = null;
        private Timestamp adjustTime = null;

        private PastDataTmpInfo() {
        }

        public String getFormula() {
            return this.formula;
        }

        public void setFormula(String formula) {
            this.formula = formula;
        }

        public BigDecimal getPastValue() {
            return this.pastValue;
        }

        public void setPastValue(BigDecimal pastValue) {
            this.pastValue = pastValue;
        }

        public BigDecimal getBalance() {
            return this.balance;
        }

        public void setBalance(BigDecimal balance) {
            this.balance = balance;
        }

        public String getAdjustorID() {
            return this.adjustorID;
        }

        public void setAdjustorID(String adjustorID) {
            this.adjustorID = adjustorID;
        }

        public Timestamp getAdjustTime() {
            return this.adjustTime;
        }

        public void setAdjustTime(Timestamp adjustTime) {
            this.adjustTime = adjustTime;
        }
    }
}

