/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.bgcsl.BgCslFormInfo;
import com.kingdee.eas.ma.bgcsl.utils.BgCslSchemeDimensionHelper;
import com.kingdee.eas.ma.bgcsl.utils.MbgCslDataHelper;
import com.kingdee.eas.ma.mbg.BgDimensionFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.app.AbstractBgChatgptAnalyseDataFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.calctrace.BizCalcTraceUtils;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.face.IDimension;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.face.IMember;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.vo.MemberObject;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class BgChatgptAnalyseDataFacadeControllerBean
extends AbstractBgChatgptAnalyseDataFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgChatgptAnalyseDataFacadeControllerBean");

    @Override
    protected Object _queryData(Context ctx, Map params) throws BOSException, EASBizException {
        if (ctx == null || params == null || params.isEmpty() || params.get("BGFORM_INFO") == null || params.get("FORMULA") == null) {
            return null;
        }
        String jsonStr = "";
        IDimDataQuery info = (IDimDataQuery)params.get("BGFORM_INFO");
        Map bgFormulas = (Map)params.get("FORMULA");
        if (bgFormulas.isEmpty()) {
            return null;
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgFormInfo bgFormInfo = MbgDataHelper.getBgFormInfo(conn, ctx.getLocale(), info.getId());
            if (info instanceof BgFormInfo) {
                bgFormInfo = MbgDataHelper.getBgFormInfo(conn, ctx.getLocale(), info.getId());
            } else if (info instanceof BgCslFormInfo) {
                bgFormInfo = MbgCslDataHelper.getBgCslFormInfo((Context)ctx, (Connection)conn, (String)info.getId().toString());
            }
            String bgSchemeId = bgFormInfo.getBizBgScheme().getId().toString();
            String orgId = bgFormInfo.getBizOrgUnit().getId().toString();
            HashSet<String> bgVersionNums = new HashSet<String>();
            bgVersionNums.add(bgFormInfo.getBizVersion().getNumber());
            IDimensionParameter parameter = this.transParameter(ctx, bgSchemeId, orgId, bgVersionNums, bgFormulas, bgFormInfo);
            Map<String, Map<String, BgDimensionMember>> allMembersMap = this.getMembersMap(ctx, parameter, bgSchemeId, orgId);
            Object data = BgDimensionFacadeFactory.getLocalInstance(ctx).dimensionQuery(parameter);
            jsonStr = this.transResult(ctx, parameter, allMembersMap, data, bgFormulas);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        logger.error((Object)("BgChatgptAnalyseDataFacadeControllerBean _queryData Json : " + jsonStr));
        return jsonStr;
    }

    protected Map<String, MbgDimInfo> getDimsMap(IDimensionParameter parameter) {
        HashMap<String, MbgDimInfo> srcDimsMap = new HashMap<String, MbgDimInfo>();
        Map<String, String> srcFieldMap = parameter.getDataManager().getSrcFieldMap();
        Map<String, MbgDimInfo> mbgDims = parameter.getDataManager().getMbgDims();
        String srcNum2 = null;
        String field = null;
        for (String srcNum2 : srcFieldMap.keySet()) {
            field = srcFieldMap.get(srcNum2);
            if (!mbgDims.containsKey(field)) continue;
            srcDimsMap.put(srcNum2, mbgDims.get(field));
        }
        return srcDimsMap;
    }

    protected Map<String, Map<String, BgDimensionMember>> getMembersMap(Context ctx, IDimensionParameter parameter, String bgSchemeId, String orgId) throws EASBizException, BOSException {
        Map<String, IDimension> dimensionMap = parameter.getDimensionMap();
        HashMap<String, Set<String>> allMemberNums = new HashMap<String, Set<String>>();
        for (String dimNum : dimensionMap.keySet()) {
            IDimension dimension = dimensionMap.get(dimNum);
            if (!allMemberNums.containsKey(dimension.getField())) {
                allMemberNums.put(dimension.getField(), new HashSet());
            }
            for (int i = 0; i < dimension.getDimensionMember().size(); ++i) {
                IMember member = dimension.getDimensionMember().get(i);
                if (DimUtils.checkBaseDimension(dimNum)) {
                    ((Set)allMemberNums.get(dimension.getField())).add(member.getNumber());
                    continue;
                }
                ((Set)allMemberNums.get(dimension.getField())).add(member.getDimNumber());
            }
        }
        return BizCalcTraceUtils.queryMembersName(ctx, allMemberNums, orgId, bgSchemeId);
    }

    protected String transResult(Context ctx, IDimensionParameter parameter, Map<String, Map<String, BgDimensionMember>> allMembersMap, Object data, Map<String, List<String>> bgFormulas) throws BOSException {
        StringBuffer result = new StringBuffer();
        if (data != null && data instanceof Map) {
            String orgId2 = null;
            String formula = null;
            BgNViewDataInfo dataInfo = null;
            Map bgDataMap = (Map)data;
            Map<String, BgOrgUnitInfo> bgOrgMap = this.getBgOrgUnit(ctx, parameter, new HashSet<String>(bgDataMap.keySet()));
            Map<String, MbgDimInfo> srcDimsMap = this.getDimsMap(parameter);
            result.append("[");
            Boolean checkHasData = false;
            for (String orgId2 : bgDataMap.keySet()) {
                TreeMap<String, BgNViewDataInfo> dataMap = new TreeMap<String, BgNViewDataInfo>((Map)bgDataMap.get(orgId2));
                if (!bgFormulas.containsKey(orgId2)) continue;
                int count = 0;
                Iterator itr = dataMap.keySet().iterator();
                while (itr.hasNext()) {
                    ++count;
                    formula = (String)itr.next();
                    dataInfo = (BgNViewDataInfo)dataMap.get(formula);
                    if (!bgFormulas.get(orgId2).contains(dataInfo.getFormula())) continue;
                    result.append("{");
                    if (bgOrgMap.keySet().size() > 1) {
                        result.append("\"\u9884\u7b97\u7ec4\u7ec7\"\uff1a\"" + bgOrgMap.get(orgId2).getName() + "\",");
                    }
                    result.append(this.getFormulaMsg(dataMap, parameter, formula, dataInfo, srcDimsMap, allMembersMap));
                    result.append("}");
                    checkHasData = true;
                    if (count == dataMap.keySet().size()) continue;
                    result.append(",");
                }
                if (bgOrgMap.keySet().size() <= 1 || result.toString().endsWith(",")) continue;
                result.append(",");
            }
            if (result.toString().endsWith(",")) {
                result = new StringBuffer(result.substring(0, result.length() - 1));
            }
            if (!checkHasData.booleanValue()) {
                return "";
            }
            result.append("]");
        }
        return result.toString();
    }

    protected Map<String, BgOrgUnitInfo> getBgOrgUnit(Context ctx, IDimensionParameter parameter, Set<String> qeryOrgIds) throws BOSException {
        HashMap<String, BgOrgUnitInfo> bgOrgMap = new HashMap<String, BgOrgUnitInfo>();
        if (qeryOrgIds != null && !qeryOrgIds.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(new SelectorItemCollection());
            view.getSelector().add("id");
            view.getSelector().add("number");
            view.getSelector().add("name");
            view.getSelector().add("longNumber");
            view.getSelector().add("orgUnitId");
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("viewID", (Object)parameter.getBgOrgViewId().toString(), CompareType.EQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitId", qeryOrgIds, CompareType.INCLUDE));
            view.getFilter().getFilterItems().add(new FilterItemInfo("isVirtual", (Object)Boolean.FALSE, CompareType.EQUALS));
            BgOrgUnitCollection bgOrgColls = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(view);
            if (bgOrgColls != null && !bgOrgColls.isEmpty()) {
                for (int i = 0; i < bgOrgColls.size(); ++i) {
                    bgOrgMap.put(bgOrgColls.get(i).getOrgUnitID(), bgOrgColls.get(i));
                }
            }
        }
        return bgOrgMap;
    }

    protected String getFormulaMsg(Map<String, BgNViewDataInfo> dataMap, IDimensionParameter parameter, String formula, BgNViewDataInfo dataInfo, Map<String, MbgDimInfo> srcDimsMap, Map<String, Map<String, BgDimensionMember>> allMembersMap) {
        String[] formulaParams = null;
        String bgItemNumber = null;
        String bgPeriodNumber = null;
        String bgElementNumber = null;
        String bgScenario = null;
        String currencyNumber = null;
        StringBuffer formulaMsg = new StringBuffer();
        Map<String, String> srcFieldMap = parameter.getDataManager().getSrcFieldMap();
        formulaParams = BgNFSHelper.parseFormulaPara(formula);
        bgItemNumber = formulaParams[0];
        String[] items = bgItemNumber.split(",");
        for (int i = 0; i < items.length; ++i) {
            String item = items[i];
            String[] arrs = item.split(":");
            if (this.checkIsOne(arrs[0], srcFieldMap, allMembersMap, dataMap) && !DimensionConstants.DEF_INDEX_SRCNUMBER.equals(arrs[0])) continue;
            formulaMsg.append("\"").append(srcDimsMap.get(arrs[0]).getName()).append("\"").append(":").append("\"").append(this.getMemberName(arrs[0], arrs[1], srcFieldMap, allMembersMap)).append("\"");
            formulaMsg.append(",");
        }
        bgPeriodNumber = formulaParams[1];
        formulaMsg.append("\"").append(srcDimsMap.get(DimensionConstants.DEF_PERIOD_SRCNUMBER).getName()).append("\"").append(":").append("\"").append(this.getMemberName(DimensionConstants.DEF_PERIOD_SRCNUMBER, bgPeriodNumber, srcFieldMap, allMembersMap)).append("\"").append(",");
        if (!this.checkIsOne(DimensionConstants.DEF_ELEMENT_SRCNUMBER, srcFieldMap, allMembersMap, dataMap)) {
            bgElementNumber = formulaParams[2];
            formulaMsg.append("\"").append(srcDimsMap.get(DimensionConstants.DEF_ELEMENT_SRCNUMBER).getName()).append("\"").append(":").append("\"").append(this.getMemberName(DimensionConstants.DEF_ELEMENT_SRCNUMBER, bgElementNumber, srcFieldMap, allMembersMap)).append("\"").append(",");
        }
        if (!this.checkIsOne(DimensionConstants.DEF_SCENARIO_SRCNUMBER, srcFieldMap, allMembersMap, dataMap)) {
            bgScenario = formulaParams[3];
            formulaMsg.append("\"").append(srcDimsMap.get(DimensionConstants.DEF_SCENARIO_SRCNUMBER).getName()).append("\"").append(":").append("\"").append(this.getMemberName(DimensionConstants.DEF_SCENARIO_SRCNUMBER, bgScenario, srcFieldMap, allMembersMap)).append("\"").append(",");
        }
        if (!this.checkIsOne(DimensionConstants.DEF_CURRENCY_SRCNUMBER, srcFieldMap, allMembersMap, dataMap)) {
            currencyNumber = formulaParams[5];
            formulaMsg.append("\"").append(srcDimsMap.get(DimensionConstants.DEF_CURRENCY_SRCNUMBER).getName()).append("\"").append(":").append("\"").append(this.getMemberName(DimensionConstants.DEF_CURRENCY_SRCNUMBER, currencyNumber, srcFieldMap, allMembersMap)).append("\"").append(",");
        }
        BigDecimal value = BigDecimal.ZERO;
        value = dataInfo.getState() == 5 ? dataInfo.getBudgetValue() : (dataInfo.getBizActual() != BgNConstants.ZERO ? dataInfo.getBizActual() : (dataInfo.getAddActualValue() != BgNConstants.ZERO ? dataInfo.getAddActualValue() : dataInfo.getBudgetValue()));
        formulaMsg.append("\"").append("\u6570\u503c").append("\"").append(":").append(value);
        return formulaMsg.toString();
    }

    protected boolean checkIsOne(String srcNumber, Map<String, String> srcFieldMap, Map<String, Map<String, BgDimensionMember>> allMembersMap, Map<String, BgNViewDataInfo> dataMap) {
        if (dataMap.keySet().size() == 1) {
            return false;
        }
        Map<String, BgDimensionMember> tmpMap = allMembersMap.get(srcFieldMap.get(srcNumber));
        return tmpMap.keySet().size() == 1;
    }

    protected String getMemberName(String srcNumber, String memberNumber, Map<String, String> srcFieldMap, Map<String, Map<String, BgDimensionMember>> allMembersMap) {
        return allMembersMap.get(srcFieldMap.get(srcNumber)).get(memberNumber).getName();
    }

    protected IDimensionParameter transParameter(Context ctx, String bgSchemeId, String orgId, Set<String> bgVersionNums, Map<String, List<String>> bgFormulas, IDimDataQuery bgFormInfo) throws Exception {
        IBgDimensionManager iBgDimensionManager;
        IDimensionParameter parameter = null;
        ArrayList<IBgDimensionManagerBase> dimensionManager = new ArrayList<IBgDimensionManagerBase>();
        BgSchemeInfo bgSchemeInfo = null;
        OrgUnitInfo orgUnitInfo = null;
        BOSUuid bgOrgViewId = null;
        BgSchemeDimensionHelper schemeHelper = null;
        Map<String, String> srcFieldMap = null;
        IMbgViewManager viewManager = null;
        bgSchemeInfo = BgViewServerHelper.getBgSchemeInfo(ctx, BOSUuid.read((String)bgSchemeId));
        orgUnitInfo = MbgDataHelper.getOrgUnitInfo(ctx, BOSUuid.read((String)orgId));
        bgOrgViewId = bgSchemeInfo.getEditOrgViewId();
        if (bgFormInfo instanceof BgFormInfo) {
            schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
        } else if (bgFormInfo instanceof BgCslFormInfo) {
            schemeHelper = new BgCslSchemeDimensionHelper(ctx, bgSchemeId, ((BgCslFormInfo)bgFormInfo).getOrgTree());
        }
        srcFieldMap = this.getSrcFieldMap(ctx, schemeHelper);
        String orgUnitId2 = null;
        HashSet<String> formulas = new HashSet<String>();
        for (String orgUnitId2 : bgFormulas.keySet()) {
            formulas.addAll((Collection<String>)bgFormulas.get(orgUnitId2));
        }
        viewManager = DimensionFormulaHelper.buildViewMamager(ctx, formulas, bgVersionNums);
        if (bgFormInfo instanceof BgFormInfo) {
            viewManager = TemplateFacadeFactory.getLocalInstance(ctx).loadViewManager(orgUnitInfo.getId().toString(), bgSchemeId, viewManager);
        }
        if ((iBgDimensionManager = viewManager.getSheetManagers().get(0).getDimensionManager()).getPageDisplayDimension().isEmpty() && !iBgDimensionManager.getPageDimension().isEmpty()) {
            iBgDimensionManager.getPageDisplayDimension().addAll(iBgDimensionManager.getPageDimension());
        }
        if (iBgDimensionManager.getRowDisplayDimension().isEmpty() && !iBgDimensionManager.getRowDimension().isEmpty()) {
            iBgDimensionManager.getRowDisplayDimension().addAll(iBgDimensionManager.getRowDimension());
        }
        if (iBgDimensionManager.getColDisplayDimension().isEmpty() && !iBgDimensionManager.getColDimension().isEmpty()) {
            iBgDimensionManager.getColDisplayDimension().addAll(iBgDimensionManager.getColDimension());
        }
        dimensionManager.add(viewManager.getSheetManagers().get(0).getDimensionManager());
        parameter = DimUtils.transDimParameter(ctx, dimensionManager, bgFormInfo, bgOrgViewId);
        parameter.getDataManager().getSrcFieldMap().putAll(srcFieldMap);
        MbgDimCollection colls = null;
        MbgDimInfo mbgDim = null;
        if (parameter.getDataManager().getDimensions() != null && !parameter.getDataManager().getDimensions().isEmpty()) {
            colls = parameter.getDataManager().getDimensions();
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                mbgDim = colls.get(i);
                parameter.getDataManager().getMbgDims().put(mbgDim.getRefField(), mbgDim);
                parameter.getDataManager().getFieldSrcMap().put(mbgDim.getRefField(), mbgDim.getSrcNumber());
            }
        }
        parameter.getDataManager().getSrcFieldMap().put(DimensionConstants.DEF_PROCESS_SRCNUMBER, DimensionConstants.DEF_PROCESS_FIELD);
        parameter.getDataManager().getFieldSrcMap().put(DimensionConstants.DEF_PROCESS_FIELD, DimensionConstants.DEF_PROCESS_SRCNUMBER);
        if (bgFormInfo.getProcessType().equals((Object)BgProcessEnum.C02)) {
            parameter.setValueType(256);
        } else if (bgFormInfo.getProcessType().equals((Object)BgProcessEnum.C03)) {
            parameter.setValueType(512);
        } else if (bgFormInfo.getProcessType().equals((Object)BgProcessEnum.C04)) {
            parameter.setValueType(1024);
        }
        if (bgFormulas.keySet().size() > 1) {
            HashSet<String> qeryOrgIds = new HashSet<String>();
            qeryOrgIds.addAll(bgFormulas.keySet());
            parameter.setQeryOrgIds(qeryOrgIds);
            Map<String, BgOrgUnitInfo> bgOrgMap = this.getBgOrgUnit(ctx, parameter, qeryOrgIds);
            if (bgOrgMap != null && !bgOrgMap.isEmpty() && !parameter.getPageDims().isEmpty()) {
                IDimension orgDim = null;
                for (int x = 0; x < parameter.getPageDims().size(); ++x) {
                    IDimension dimension = parameter.getPageDims().get(x);
                    if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber())) continue;
                    orgDim = dimension;
                    break;
                }
                if (orgDim != null) {
                    for (BgOrgUnitInfo bgOrgInfo : bgOrgMap.values()) {
                        MemberObject mem = new MemberObject();
                        mem.setName(bgOrgInfo.getName());
                        mem.setNumber(bgOrgInfo.getNumber());
                        mem.setMdxNumber(bgOrgInfo.getLongNumber());
                        orgDim.addMember(mem);
                    }
                    parameter.getPageDims().remove(orgDim);
                    parameter.getRowDims().add(orgDim);
                }
            }
        } else if (!StringUtils.isEmpty((String)orgUnitId2)) {
            parameter.setOrgUnitId(BOSUuid.read((String)orgUnitId2));
        }
        return parameter;
    }

    public Map<String, String> getSrcFieldMap(Context ctx, BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        if (ctx == null || schemeHelper == null) {
            return null;
        }
        String dimNumber = null;
        HashMap<String, String> srcFieldMap = new HashMap<String, String>();
        Map<String, String> refFieldMap = schemeHelper.getRefFieldMap();
        Map<String, String> srcNumberMap = schemeHelper.getSrcNumberMap();
        for (Map.Entry<String, String> entry : srcNumberMap.entrySet()) {
            dimNumber = entry.getKey();
            if (refFieldMap == null || !refFieldMap.containsKey(dimNumber)) continue;
            srcFieldMap.put(entry.getValue(), refFieldMap.get(dimNumber));
        }
        return srcFieldMap;
    }
}

