/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.PostilFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgCommentEntryInfo;
import com.kingdee.eas.ma.mbg.BgCommentFactory;
import com.kingdee.eas.ma.mbg.BgCommentInfo;
import com.kingdee.eas.ma.mbg.BgCommentRefInfo;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.IBgComment;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.app.AbstractBgCommentControllerBean;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.ViewlistCombinHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCommentControllerBean
extends AbstractBgCommentControllerBean {
    private static final long serialVersionUID = 224171981838594985L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgCommentControllerBean");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _queryBgComments(Context ctx, Map queryData, BgProcessEnum processType) throws BOSException, EASBizException {
        IRowSet rst;
        Connection conn;
        HashMap postils;
        block82: {
            TempTablePool pool;
            String tmpVersionTable;
            String tmpScenarioTable;
            String tmpCurrencyTable;
            String tmpElementTable;
            String tmpBgPeriodTable;
            String tmpBgIndexTable;
            String tmpOrgUnitTable;
            block83: {
                postils = new HashMap();
                if (ctx == null) return postils;
                if (queryData == null) return postils;
                if (queryData.isEmpty()) {
                    return postils;
                }
                Set bgSchemeIds = null;
                if (queryData.containsKey("BGSCHEME_ID")) {
                    bgSchemeIds = (Set)queryData.get("BGSCHEME_ID");
                }
                Set orgUnitIds = null;
                if (queryData.containsKey("ORGUNIT_ID")) {
                    orgUnitIds = (Set)queryData.get("ORGUNIT_ID");
                }
                Set bgIndexNums = null;
                if (queryData.containsKey(DimensionBaseConstants.DEF_BGINDEX_FIELD)) {
                    bgIndexNums = (Set)queryData.get(DimensionBaseConstants.DEF_BGINDEX_FIELD);
                }
                Set bgPeriodNums = null;
                if (queryData.containsKey(DimensionBaseConstants.DEF_PERIOD_FIELD)) {
                    bgPeriodNums = (Set)queryData.get(DimensionBaseConstants.DEF_PERIOD_FIELD);
                }
                Set elementNums = null;
                if (queryData.containsKey(DimensionBaseConstants.DEF_ELEMENT_FIELD)) {
                    elementNums = (Set)queryData.get(DimensionBaseConstants.DEF_ELEMENT_FIELD);
                }
                Set currencyNums = null;
                if (queryData.containsKey(DimensionBaseConstants.DEF_CURRENCY_FIELD)) {
                    currencyNums = (Set)queryData.get(DimensionBaseConstants.DEF_CURRENCY_FIELD);
                }
                Set scenarioNums = null;
                if (queryData.containsKey(DimensionBaseConstants.DEF_SCENARIO_FIELD)) {
                    scenarioNums = (Set)queryData.get(DimensionBaseConstants.DEF_SCENARIO_FIELD);
                }
                Set versionNums = null;
                if (queryData.containsKey(DimensionBaseConstants.DEF_VERSION_FIELD)) {
                    versionNums = (Set)queryData.get(DimensionBaseConstants.DEF_VERSION_FIELD);
                }
                String formulaValue = null;
                if (queryData.containsKey("formula")) {
                    formulaValue = (String)queryData.get("formula");
                }
                if (BgCommHelper.isEmpty((Collection)bgSchemeIds)) return postils;
                if (BgCommHelper.isEmpty((Collection)orgUnitIds)) return postils;
                if (BgCommHelper.isEmpty((Collection)bgIndexNums)) return postils;
                if (BgCommHelper.isEmpty((Collection)bgPeriodNums)) {
                    return postils;
                }
                String tmpSchemeTable = null;
                tmpOrgUnitTable = null;
                tmpBgIndexTable = null;
                tmpBgPeriodTable = null;
                tmpElementTable = null;
                tmpCurrencyTable = null;
                tmpScenarioTable = null;
                tmpVersionTable = null;
                String bgSchemeId = null;
                String orgUnitId = null;
                String formula = null;
                String versionNum = null;
                String content = null;
                String dimKey = null;
                conn = null;
                rst = null;
                pool = TempTablePool.getInstance((Context)ctx);
                Map orgPostil = null;
                Map postilMap = null;
                List<String> tmpPostils = null;
                try {
                    conn = this.getConnection(ctx);
                    tmpSchemeTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpSchemeTable + " (FID) values (?)"), (Collection)bgSchemeIds);
                    tmpOrgUnitTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpOrgUnitTable + " (FID) values (?)"), (Collection)orgUnitIds);
                    tmpBgIndexTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(80))");
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpBgIndexTable + " (FNumber) values (?)"), (Collection)bgIndexNums);
                    tmpBgPeriodTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(80))");
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpBgPeriodTable + " (FNumber) values (?)"), (Collection)bgPeriodNums);
                    if (elementNums != null && !elementNums.isEmpty()) {
                        tmpElementTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(80))");
                        BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpElementTable + " (FNumber) values (?)"), (Collection)elementNums);
                    }
                    if (currencyNums != null && !currencyNums.isEmpty()) {
                        tmpCurrencyTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(80))");
                        BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpCurrencyTable + " (FNumber) values (?)"), (Collection)currencyNums);
                    }
                    if (scenarioNums != null && !scenarioNums.isEmpty()) {
                        tmpScenarioTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(80))");
                        BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpScenarioTable + " (FNumber) values (?)"), (Collection)scenarioNums);
                    }
                    if (versionNums != null && !versionNums.isEmpty()) {
                        tmpVersionTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(80))");
                        BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpVersionTable + " (FNumber) values (?)"), (Collection)versionNums);
                    }
                    StringBuffer sql2333332 = new StringBuffer();
                    sql2333332.append("select c.FBgSchemeId, c.FOrgUnitId, c.FFormula, c.FBgVersion, ce.FBgContent_" + ctx.getLocale() + " AS FBgContent from T_MBG_BgCommentEntry ce left join T_MBG_BgComment c on c.FID = ce.FBgCommentId where exists (select FID from " + tmpSchemeTable + " where FID = c.FBgSchemeId) and exists (select FID from " + tmpOrgUnitTable + " where FID = c.FOrgUnitId) ");
                    sql2333332.append(" and c.FProcessType = " + processType.getValue() + " ");
                    if (tmpBgIndexTable != null) {
                        sql2333332.append(" and exists (select FNumber from " + tmpBgIndexTable + " where FNumber = c.FBgAccount)");
                    }
                    if (tmpBgPeriodTable != null) {
                        sql2333332.append(" and exists (select FNumber from " + tmpBgPeriodTable + " where FNumber = c.FBgPeriod)");
                    }
                    if (tmpElementTable != null) {
                        sql2333332.append(" and exists (select FNumber from " + tmpElementTable + " where FNumber = c.FBgElement)");
                    }
                    if (tmpCurrencyTable != null) {
                        sql2333332.append(" and exists (select FNumber from " + tmpCurrencyTable + " where FNumber = c.FBgCurrency)");
                    }
                    if (tmpScenarioTable != null) {
                        sql2333332.append(" and exists (select FNumber from " + tmpScenarioTable + " where FNumber = c.FBgScenario)");
                    }
                    if (tmpVersionTable != null) {
                        sql2333332.append(" and exists (select FNumber from " + tmpVersionTable + " where FNumber = c.FBgVersion)");
                    }
                    if (formulaValue != null) {
                        sql2333332.append(" and where c.fformula = " + formulaValue);
                    }
                    rst = BgDBUtils.executeQuery((Connection)conn, (String)sql2333332.toString());
                    while (rst.next()) {
                        bgSchemeId = rst.getString("FBgSchemeId");
                        orgUnitId = rst.getString("FOrgUnitId");
                        formula = rst.getString("FFormula");
                        versionNum = rst.getString("FBgVersion");
                        dimKey = DimUtils.getDimDataKey(formula, versionNum);
                        content = rst.getString("FBgContent");
                        if (postils.containsKey(bgSchemeId)) {
                            orgPostil = (Map)postils.get(bgSchemeId);
                        } else {
                            orgPostil = new HashMap();
                            postils.put(bgSchemeId, orgPostil);
                        }
                        if (orgPostil.containsKey(orgUnitId)) {
                            postilMap = (Map)orgPostil.get(orgUnitId);
                        } else {
                            postilMap = new HashMap();
                            orgPostil.put(orgUnitId, postilMap);
                        }
                        if (postilMap.containsKey(dimKey)) {
                            tmpPostils = (List)postilMap.get(dimKey);
                        } else {
                            tmpPostils = new ArrayList();
                            postilMap.put(dimKey, tmpPostils);
                        }
                        tmpPostils.add(content);
                    }
                    if (pool == null) break block82;
                    if (tmpSchemeTable == null) break block83;
                }
                catch (SQLException ex) {
                    try {
                        logger.error((Object)"sql error:", (Throwable)ex);
                        throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                        catch (Exception ex2) {
                            throw new BOSException((Throwable)ex2);
                        }
                    }
                    catch (Throwable throwable) {
                        if (pool != null) {
                            if (tmpSchemeTable != null) {
                                try {
                                    BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpSchemeTable);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (tmpOrgUnitTable != null) {
                                try {
                                    BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpOrgUnitTable);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (tmpBgIndexTable != null) {
                                try {
                                    BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpBgIndexTable);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (tmpElementTable != null) {
                                try {
                                    BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpElementTable);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (tmpCurrencyTable != null) {
                                try {
                                    BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpCurrencyTable);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (tmpScenarioTable != null) {
                                try {
                                    BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpScenarioTable);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (tmpVersionTable != null) {
                                try {
                                    BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpVersionTable);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (tmpBgPeriodTable != null) {
                                try {
                                    BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpBgPeriodTable);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        SQLUtils.cleanup(rst, null, (Connection)conn);
                        throw throwable;
                    }
                }
                try {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpSchemeTable);
                }
                catch (Exception sql2333332) {
                    // empty catch block
                }
            }
            if (tmpOrgUnitTable != null) {
                try {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpOrgUnitTable);
                }
                catch (Exception sql2333332) {
                    // empty catch block
                }
            }
            if (tmpBgIndexTable != null) {
                try {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpBgIndexTable);
                }
                catch (Exception sql2333332) {
                    // empty catch block
                }
            }
            if (tmpElementTable != null) {
                try {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpElementTable);
                }
                catch (Exception sql2333332) {
                    // empty catch block
                }
            }
            if (tmpCurrencyTable != null) {
                try {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpCurrencyTable);
                }
                catch (Exception sql2333332) {
                    // empty catch block
                }
            }
            if (tmpScenarioTable != null) {
                try {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpScenarioTable);
                }
                catch (Exception sql2333332) {
                    // empty catch block
                }
            }
            if (tmpVersionTable != null) {
                try {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpVersionTable);
                }
                catch (Exception sql2333332) {
                    // empty catch block
                }
            }
            if (tmpBgPeriodTable != null) {
                try {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpBgPeriodTable);
                }
                catch (Exception sql2333332) {
                    // empty catch block
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return postils;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _queryBgComments(Context ctx, IDimDataQuery bgFormInfo, String bgOrgViewId, IMbgViewBase viewManager) throws BOSException, EASBizException {
        IRowSet rst;
        Connection conn;
        HashMap resultMap;
        block28: {
            Set<String> orgNums;
            resultMap = new HashMap();
            if (bgFormInfo == null) {
                return resultMap;
            }
            String bgSchemeId = bgFormInfo.getBizBgScheme().getId().toString();
            if (!this.checkSchemeHasBgComments(ctx, bgSchemeId)) {
                return resultMap;
            }
            String formOrgId = bgFormInfo.getBizOrgUnit().getId().toString();
            String formVersion = bgFormInfo.getBizVersion().getNumber();
            IMbgViewBase view = viewManager;
            if (viewManager == null && bgFormInfo instanceof BgFormInfo) {
                view = this.getViewBybgForm(ctx, (BgFormInfo)bgFormInfo);
            }
            if (view == null) {
                return resultMap;
            }
            Map<String, Set<String>> dimNumsMap = this.getDimNumsMap(view);
            HashSet<String> orgIds = new HashSet<String>();
            ArrayList<MbgViewListDimensionInfo> allDimensions = new ArrayList<MbgViewListDimensionInfo>();
            for (IMbgSheetBase iMbgSheetBase : view.getSheetManagers()) {
                if (iMbgSheetBase instanceof MbgViewListSheetManager) {
                    allDimensions.addAll(((MbgViewListSheetManager)iMbgSheetBase).getDimensionManager().getAllDimensions());
                    continue;
                }
                allDimensions.addAll(iMbgSheetBase.getDimensionManager().getDimension());
            }
            for (int i = 0; i < allDimensions.size(); ++i) {
                BgDimensionBaseInfo bgDimensionBaseInfo;
                if (!(allDimensions.get(i) instanceof BgDimensionBaseInfo) || !DimensionConstants.DEF_ORGUNIT_NUMBER.equals((bgDimensionBaseInfo = (BgDimensionBaseInfo)allDimensions.get(i)).getNumber())) continue;
                for (int m = 0; m < bgDimensionBaseInfo.getMember().size(); ++m) {
                    if (!(bgDimensionBaseInfo.getMember().get(m) instanceof BgDimensionMember)) continue;
                    orgIds.add(((BgDimensionMember)bgDimensionBaseInfo.getMember().get(m)).getAttribute());
                }
            }
            if (orgIds.isEmpty() && dimNumsMap.containsKey(DimensionConstants.DEF_ORGUNIT_NUMBER) && !(orgNums = dimNumsMap.get(DimensionConstants.DEF_ORGUNIT_NUMBER)).isEmpty()) {
                SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
                selectorItemCollection.add("id");
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", orgNums, CompareType.INCLUDE));
                evi.setFilter(filter);
                BgOrgUnitCollection colls = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(evi);
                if (colls != null && !colls.isEmpty()) {
                    for (int index = 0; index < colls.size(); ++index) {
                        orgIds.add(colls.get(index).getOrgUnitID().toString());
                    }
                }
            }
            if (orgIds.isEmpty()) {
                orgIds.add(formOrgId);
            }
            Set<String> bgVersion = dimNumsMap.get(DimensionConstants.DEF_VERSION_NUMBER);
            Set<String> set = dimNumsMap.get(DimensionConstants.DEF_SCENARIO_NUMBER);
            Set<String> bgAccount = dimNumsMap.get(DimensionConstants.DEF_ACCOUNT_NUMBER);
            Set<String> bgPeriod = dimNumsMap.get(DimensionConstants.DEF_PERIOD_NUMBER);
            Set<String> bgCurrency = dimNumsMap.get(DimensionConstants.DEF_CURRENCY_NUMBER);
            Set<String> bgElement = dimNumsMap.get(DimensionConstants.DEF_ELEMENT_NUMBER);
            if (bgVersion == null || bgVersion.isEmpty()) {
                if (bgVersion == null) {
                    bgVersion = new HashSet<String>();
                    dimNumsMap.put(DimensionConstants.DEF_VERSION_NUMBER, bgVersion);
                }
                bgVersion.add(formVersion);
            }
            if (orgIds.isEmpty()) return resultMap;
            if (bgVersion.isEmpty()) return resultMap;
            if (set == null) return resultMap;
            if (set.isEmpty()) return resultMap;
            if (bgAccount == null) return resultMap;
            if (bgAccount.isEmpty()) return resultMap;
            if (bgPeriod == null) return resultMap;
            if (bgPeriod.isEmpty()) return resultMap;
            if (bgCurrency == null) return resultMap;
            if (bgCurrency.isEmpty()) return resultMap;
            if (bgElement == null) return resultMap;
            if (bgElement.isEmpty()) {
                return resultMap;
            }
            String orgTempTable = null;
            String bgVersionTempTable = null;
            String bgScenarioTempTable = null;
            String bgAccountTempTable = null;
            String bgPeriodTempTable = null;
            String bgCurrencyTempTable = null;
            String bgElementTempTable = null;
            String bgCommentId = null;
            String schemeId = null;
            String orgUnitId = null;
            String formula = null;
            String bgVersionNum = null;
            String entryId = null;
            String bgContent = null;
            String userName = null;
            String userID = null;
            String bgScenarioNum = null;
            String bgAccountNum = null;
            String bgPeriodNum = null;
            String bgCurrencyNum = null;
            String bgElementNum = null;
            Timestamp bgCommentCreateTime = null;
            Timestamp bgCommentLastUpdateTime = null;
            Timestamp entryCreateTime = null;
            Timestamp entryLastUpdateTime = null;
            BgCommentInfo bgCommentInfo = null;
            BgCommentEntryInfo entryInfo = null;
            UserInfo userInfo = null;
            conn = null;
            rst = null;
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            StringBuffer sql = new StringBuffer();
            try {
                conn = this.getConnection(ctx);
                orgTempTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FOrgUnitID VARCHAR(44))");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + orgTempTable + " (FOrgUnitID) values (?)"), orgIds);
                bgVersionTempTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FBgVersion NVARCHAR(80))");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + bgVersionTempTable + " (FBgVersion) values (?)"), bgVersion);
                bgScenarioTempTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FBgScenario NVARCHAR(80))");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + bgScenarioTempTable + " (FBgScenario) values (?)"), set);
                bgAccountTempTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FBgAccount NVARCHAR(80))");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + bgAccountTempTable + " (FBgAccount) values (?)"), bgAccount);
                bgPeriodTempTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FBgPeriod NVARCHAR(80))");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + bgPeriodTempTable + " (FBgPeriod) values (?)"), bgPeriod);
                bgCurrencyTempTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FBgCurrency NVARCHAR(80))");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + bgCurrencyTempTable + " (FBgCurrency) values (?)"), bgCurrency);
                bgElementTempTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FbgElement NVARCHAR(80))");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + bgElementTempTable + " (FbgElement) values (?)"), bgElement);
                Locale locale = ctx.getLocale();
                sql.append(" Select bgComment.FId bgComment_FId, bgComment.FBgSchemeId bgComment_FBgSchemeId, bgComment.FOrgUnitId bgComment_FOrgUnitId, bgComment.FFormula bgComment_FFormula, bgComment.FBgVersion bgComment_FBgVersion, ").append(" bgComment.FBgScenario bgComment_FBgScenario, bgComment.FBgAccount bgComment_FBgAccount, bgComment.FBgPeriod bgComment_FBgPeriod, bgComment.FBgCurrency bgComment_FBgCurrency, bgComment.FBgElement bgComment_FBgElement, ").append(" bgComment.FCreateTime bgComment_FCreateTime, bgComment.FLastUpdateTime bgComment_FLastUpdateTime, ").append(" entry.Fid entry_Fid, entry.FBgContent_" + locale + " entry_FBgContent, entry.FCreateTime entry_FCreateTime, entry.FLastUpdateTime entry_FLastUpdateTime, entry.FCreatorID entry_FCreatorID, ").append(" pmUser.FName_" + locale + " user_FName ").append(" From T_MBG_BgCommentEntry entry ").append(" left join T_MBG_BgComment bgComment on bgComment.FId = entry.FBgCommentId ").append(" left join T_PM_User pmUser on pmUser.FId = entry.FCreatorID ").append(" Where FBgSchemeId = ? and bgComment.FProcessType = " + bgFormInfo.getProcessType().getValue()).append(" And bgComment.FOrgUnitId in ( Select FOrgUnitID From " + orgTempTable + ") ").append(" And bgComment.FBgVersion in ( Select FBgVersion From " + bgVersionTempTable + ")").append(" And bgComment.FBgScenario in ( Select FBgScenario From " + bgScenarioTempTable + ") ").append(" And bgComment.FBgAccount in ( Select FBgAccount From " + bgAccountTempTable + ") ").append(" And bgComment.FBgPeriod in ( Select FBgPeriod From " + bgPeriodTempTable + ") ").append(" And bgComment.FBgCurrency in ( Select FBgCurrency From " + bgCurrencyTempTable + ") ").append(" And bgComment.FBgElement in ( Select FBgElement From " + bgElementTempTable + ") ").append("  Order By entry_FCreateTime");
                rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgSchemeId});
                while (rst.next()) {
                    bgCommentId = rst.getString("bgComment_FId");
                    schemeId = rst.getString("bgComment_FBgSchemeId");
                    orgUnitId = rst.getString("bgComment_FOrgUnitId");
                    formula = rst.getString("bgComment_FFormula");
                    bgVersionNum = rst.getString("bgComment_FBgVersion");
                    bgScenarioNum = rst.getString("bgComment_FBgScenario");
                    bgAccountNum = rst.getString("bgComment_FBgAccount");
                    bgPeriodNum = rst.getString("bgComment_FBgPeriod");
                    bgCurrencyNum = rst.getString("bgComment_FBgCurrency");
                    bgElementNum = rst.getString("bgComment_FBgElement");
                    bgCommentCreateTime = rst.getTimestamp("bgComment_FCreateTime");
                    bgCommentLastUpdateTime = rst.getTimestamp("bgComment_FLastUpdateTime");
                    entryId = rst.getString("entry_Fid");
                    bgContent = rst.getString("entry_FBgContent");
                    entryCreateTime = rst.getTimestamp("entry_FCreateTime");
                    entryLastUpdateTime = rst.getTimestamp("entry_FLastUpdateTime");
                    userName = rst.getString("user_FName");
                    userID = rst.getString("entry_FCreatorID");
                    if (!resultMap.containsKey(orgUnitId)) {
                        resultMap.put(orgUnitId, new HashMap());
                    }
                    if (!((Map)resultMap.get(orgUnitId)).containsKey(bgVersionNum)) {
                        ((Map)resultMap.get(orgUnitId)).put(bgVersionNum, new HashMap());
                    }
                    if (!((Map)((Map)resultMap.get(orgUnitId)).get(bgVersionNum)).containsKey(formula)) {
                        bgCommentInfo = new BgCommentInfo();
                        bgCommentInfo.setId(BOSUuid.read((String)bgCommentId));
                        bgCommentInfo.setBgSchemeId(BOSUuid.read((String)schemeId));
                        bgCommentInfo.setOrgUnitId(BOSUuid.read((String)orgUnitId));
                        bgCommentInfo.setFormula(formula);
                        bgCommentInfo.setBgVersion(bgVersionNum);
                        bgCommentInfo.setBgScenario(bgScenarioNum);
                        bgCommentInfo.setBgAccount(bgAccountNum);
                        bgCommentInfo.setBgPeriod(bgPeriodNum);
                        bgCommentInfo.setBgCurrency(bgCurrencyNum);
                        bgCommentInfo.setBgElement(bgElementNum);
                        bgCommentInfo.setCreateTime(bgCommentCreateTime);
                        bgCommentInfo.setLastUpdateTime(bgCommentLastUpdateTime);
                        bgCommentInfo.setProcessType(bgFormInfo.getProcessType());
                        ((Map)((Map)resultMap.get(orgUnitId)).get(bgVersionNum)).put(formula, bgCommentInfo);
                    }
                    entryInfo = new BgCommentEntryInfo();
                    entryInfo.setId(BOSUuid.read((String)entryId));
                    entryInfo.setBgContent(bgContent);
                    entryInfo.setCreateTime(entryCreateTime);
                    entryInfo.setLastUpdateTime(entryLastUpdateTime);
                    entryInfo.setBgComment(bgCommentInfo);
                    userInfo = new UserInfo();
                    userInfo.setName(userName);
                    userInfo.setId(BOSUuid.read((String)userID));
                    entryInfo.setCreator(userInfo);
                    if (((Map)((Map)resultMap.get(orgUnitId)).get(bgVersionNum)).get(formula) == null) continue;
                    ((BgCommentInfo)((Map)((Map)resultMap.get(orgUnitId)).get(bgVersionNum)).get(formula)).getEntries().add(entryInfo);
                }
                if (pool == null) break block28;
            }
            catch (Exception ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    if (pool != null) {
                        try {
                            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)orgTempTable);
                            BgDBUtils.releaseTmpTable((TempTablePool)pool, bgVersionTempTable);
                            BgDBUtils.releaseTmpTable((TempTablePool)pool, bgScenarioTempTable);
                            BgDBUtils.releaseTmpTable((TempTablePool)pool, bgAccountTempTable);
                            BgDBUtils.releaseTmpTable((TempTablePool)pool, bgPeriodTempTable);
                            BgDBUtils.releaseTmpTable((TempTablePool)pool, bgCurrencyTempTable);
                            BgDBUtils.releaseTmpTable((TempTablePool)pool, bgElementTempTable);
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                        }
                    }
                    SQLUtils.cleanup(rst, null, (Connection)conn);
                    throw throwable;
                }
            }
            try {
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)orgTempTable);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)bgVersionTempTable);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)bgScenarioTempTable);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)bgAccountTempTable);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)bgPeriodTempTable);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)bgCurrencyTempTable);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)bgElementTempTable);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return resultMap;
    }

    private Map<String, Set<String>> getDimNumsMap(IMbgViewBase view) {
        HashMap<String, Set<String>> dimNumsMap = new HashMap<String, Set<String>>();
        IBgDimensionManagerBase dimensionManager = null;
        BgDimensionBaseInfo dimInfo = null;
        BgDimensionMember member = null;
        List memberLst = null;
        for (int i = 0; i < view.getSheetManagers().size(); ++i) {
            dimensionManager = view.getSheetManagers().get(i).getDimensionManager();
            if (dimensionManager == null) continue;
            if (dimensionManager instanceof MbgViewListDimensionManager) {
                this.putViewlistMembersTogether((MbgViewListDimensionManager)dimensionManager);
            }
            for (int j = 0; j < dimensionManager.getDimension().size(); ++j) {
                if (!(dimensionManager.getDimension().get(j) instanceof BgDimensionBaseInfo) || !DimensionConstants.canNotDel.contains((dimInfo = (BgDimensionBaseInfo)dimensionManager.getDimension().get(j)).getNumber())) continue;
                if (!dimNumsMap.containsKey(dimInfo.getNumber())) {
                    dimNumsMap.put(dimInfo.getNumber(), new HashSet());
                }
                if ((memberLst = dimInfo.getMember()) == null || memberLst.isEmpty()) continue;
                for (int k = 0; k < memberLst.size(); ++k) {
                    member = (BgDimensionMember)memberLst.get(k);
                    ((Set)dimNumsMap.get(dimInfo.getNumber())).add(member.getNumber());
                }
            }
        }
        return dimNumsMap;
    }

    private void putViewlistMembersTogether(MbgViewListDimensionManager manager) {
        if (manager == null) {
            return;
        }
        BgDimensionBaseInfo dimInfo = null;
        HashMap<String, BgDimensionBaseInfo> dimsMap = new HashMap<String, BgDimensionBaseInfo>();
        IMbgViewListObject object = null;
        List<MbgViewListDimensionInfo> viewDims = null;
        MbgViewListDimensionInfo viewDim = null;
        HashMap membersMap = new HashMap();
        for (int j = 0; j < manager.getDimension().size(); ++j) {
            if (!(manager.getDimension().get(j) instanceof BgDimensionBaseInfo)) continue;
            dimInfo = (BgDimensionBaseInfo)manager.getDimension().get(j);
            dimsMap.put(dimInfo.getNumber(), dimInfo);
            membersMap.put(dimInfo.getNumber(), new HashSet());
        }
        List<IMbgViewListObject> rowCols = manager.getRowCols();
        int in = rowCols.size();
        for (int i = 0; i < in; ++i) {
            object = rowCols.get(i);
            if (!(object instanceof MbgViewListRowCol)) continue;
            ViewlistCombinHelper.parseCombinMembers((MbgViewListRowCol)object);
            viewDims = ((MbgViewListRowCol)object).getDimensions();
            if (viewDims == null) continue;
            int jn = viewDims.size();
            for (int j = 0; j < jn; ++j) {
                viewDim = viewDims.get(j);
                if (!membersMap.containsKey(viewDim.getNumber())) continue;
                ((Set)membersMap.get(viewDim.getNumber())).addAll(viewDim.getMember());
            }
        }
        for (String num : dimsMap.keySet()) {
            ((BgDimensionBaseInfo)dimsMap.get(num)).getMember().addAll((Collection)membersMap.get(num));
        }
    }

    private IMbgViewBase getViewBybgForm(Context ctx, BgFormInfo bgForm) throws EASBizException, BOSException {
        IMbgViewBase view = DimensionCommonHelper.getBgFormView(ctx, bgForm);
        int formType = bgForm.getBgTemplate().getFormType().getValue();
        if (formType == 4) {
            view = MBGFormFacadeFactory.getLocalInstance(ctx).loadViewManager(bgForm.getId().toString(), null, (IMbgViewManager)view, null, bgForm.getOrgUnit().getId().toString(), true, false);
        } else if (formType == 2) {
            Map result = MBGViewListFormFacadeFactory.getLocalInstance(ctx).initViewListData(bgForm, null, null, (MbgViewListManager)view, null);
            view = (IMbgViewBase)result.get("dimensino.member");
        }
        return view;
    }

    @Override
    protected void _saveBgComments(Context ctx, IDimDataQuery bgFormInfo, Map bgCommentsMap, IObjectCollection postilColls, String cellFullName) throws BOSException, EASBizException {
        CoreBaseCollection deleteColls;
        if (bgFormInfo == null) {
            return;
        }
        if (bgFormInfo.getId() != null) {
            if (!StringUtils.isEmpty((String)cellFullName)) {
                String sheetId = cellFullName.substring(0, cellFullName.lastIndexOf("!"));
                String cellName = cellFullName.substring(cellFullName.lastIndexOf("!") + 1);
                DbUtil.execute((Context)ctx, (String)"Delete FROM T_RPT_RPTPOSTIL Where FREPORTID = ? AND FCellName = ? AND FSheetId IN(Select FID FROM T_RPT_RPTSHEETPARA Where FSheetID = ?)", (Object[])new Object[]{bgFormInfo.getId().toString(), cellName, sheetId});
            } else {
                DbUtil.execute((Context)ctx, (String)"Delete FROM T_RPT_RPTPOSTIL Where FREPORTID = ?", (Object[])new Object[]{bgFormInfo.getId().toString()});
            }
        }
        if (postilColls != null && !postilColls.isEmpty()) {
            PostilFactory.getLocalInstance((Context)ctx).save((CoreBaseCollection)postilColls);
        }
        if (bgCommentsMap == null || bgCommentsMap.isEmpty()) {
            return;
        }
        IBgComment iBgComment = BgCommentFactory.getLocalInstance(ctx);
        if (bgCommentsMap.containsKey("save_collections")) {
            CoreBaseCollection saveColls = (CoreBaseCollection)bgCommentsMap.get("save_collections");
            this.setProcessType(saveColls, bgFormInfo.getProcessType());
            if (saveColls != null && !saveColls.isEmpty()) {
                iBgComment.saveBatchData(saveColls);
                this.saveBgCommentRef(ctx, saveColls, bgFormInfo);
            }
        }
        if (bgCommentsMap.containsKey("delete_collections") && (deleteColls = (CoreBaseCollection)bgCommentsMap.get("delete_collections")) != null && !deleteColls.isEmpty()) {
            IObjectPK[] deletePks = new IObjectPK[deleteColls.size()];
            for (int i = 0; i < deleteColls.size(); ++i) {
                deletePks[i] = new ObjectUuidPK(deleteColls.get(i).getId());
            }
            this.deleteBgCommentRef(ctx, deleteColls);
            iBgComment.deleteBatchData(deletePks);
        }
    }

    private void setProcessType(CoreBaseCollection col, BgProcessEnum processType) {
        if (col != null && processType != null) {
            for (int i = 0; i < col.size(); ++i) {
                ((BgCommentInfo)col.get(i)).setProcessType(processType);
            }
        }
    }

    private void saveBgCommentRef(Context ctx, CoreBaseCollection updateColls, IDimDataQuery bgFormInfo) throws BOSException {
        if (updateColls == null || updateColls.isEmpty() || bgFormInfo == null) {
            return;
        }
        String refBosType = new BgCommentRefInfo().getBOSType().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("Insert into T_MBG_BgCommentRef (Fid, FBgFormId, FBgCommentId ) ").append(" Select newbosid('" + refBosType + "'), ? , comm.FId ").append(" From T_mbg_bgComment comm ").append(" Where comm.FBgSchemeId = ? ").append(" And comm.FOrgUnitId = ? ").append(" And comm.FBgVersion = ? ").append(" And comm.FFormula = ? ").append(" And not exists(Select commentRef.fid From t_mbg_bgCommentRef commentRef Where commentRef.FBgFormId = ? and commentRef.FBgCommentId = comm.FID)");
        ArrayList<Object[]> addRefParams = new ArrayList<Object[]>();
        BgCommentInfo info = null;
        int size = updateColls.size();
        for (int index = 0; index < size; ++index) {
            info = (BgCommentInfo)updateColls.get(index);
            Object[] param = new Object[6];
            addRefParams.add(param);
            param[0] = bgFormInfo.getId().toString();
            param[1] = info.getBgSchemeId().toString();
            param[2] = info.getOrgUnitId().toString();
            param[3] = info.getBgVersion();
            param[4] = info.getFormula();
            param[5] = bgFormInfo.getId().toString();
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            MbgSqlHelper.executeBatch((Connection)conn, (String)sql.toString(), addRefParams);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void deleteBgCommentRef(Context ctx, CoreBaseCollection deleteColls) throws BOSException {
        if (deleteColls == null || deleteColls.isEmpty()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" Delete From T_MBG_BgCommentRef ").append(" Where FBgCommentId IN (Select Fid From T_MBG_BgComment ").append(" Where FBgSchemeId = ? AND FOrgUnitId = ? AND FBgVersion = ? and FFormula = ? )");
        ArrayList<Object[]> deleteRefParams = new ArrayList<Object[]>();
        BgCommentInfo info = null;
        int size = deleteColls.size();
        for (int index = 0; index < size; ++index) {
            info = (BgCommentInfo)deleteColls.get(index);
            Object[] param = new Object[4];
            deleteRefParams.add(param);
            param[0] = info.getBgSchemeId().toString();
            param[1] = info.getOrgUnitId().toString();
            param[2] = info.getBgVersion();
            param[3] = info.getFormula();
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            MbgSqlHelper.executeBatch((Connection)conn, (String)sql.toString(), deleteRefParams);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected void _saveBgComments(Context ctx, Map bgCommentMap, BgProcessEnum processType) throws BOSException, EASBizException {
        Object[] formula = bgCommentMap.keySet().toArray();
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_MBG_BgCommentEntry where  FBgCommentId in (select Fid from T_MBG_BgComment where FFormula = '" + formula[0] + "')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        StringBuffer sql2 = new StringBuffer();
        sql2.append("delete from T_MBG_BgComment where FFormula = '" + formula[0] + "'");
        DbUtil.execute((Context)ctx, (String)sql2.toString());
        IBgComment iBgComment = BgCommentFactory.getLocalInstance(ctx);
        if (bgCommentMap.containsKey(formula[0])) {
            CoreBaseCollection saveColls = (CoreBaseCollection)bgCommentMap.get(formula[0]);
            this.setProcessType(saveColls, processType);
            if (saveColls != null && !saveColls.isEmpty()) {
                iBgComment.saveBatchData(saveColls);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _queryBgComments(Context ctx, String formulaValue, Map queryData, BgProcessEnum processType) throws BOSException, EASBizException {
        HashMap postils = new HashMap();
        if (ctx == null) return postils;
        if (queryData == null) return postils;
        if (queryData.isEmpty()) {
            return postils;
        }
        String bgSchemeIdValue = null;
        if (queryData.containsKey("BGSCHEME_ID")) {
            bgSchemeIdValue = (String)queryData.get("BGSCHEME_ID");
        }
        String orgUnitIdValue = null;
        if (queryData.containsKey("ORGUNIT_ID")) {
            orgUnitIdValue = (String)queryData.get("ORGUNIT_ID");
        }
        String versionNumValue = null;
        if (queryData.containsKey(DimensionBaseConstants.DEF_VERSION_FIELD)) {
            versionNumValue = (String)queryData.get(DimensionBaseConstants.DEF_VERSION_FIELD);
        }
        if (queryData.containsKey("formula")) {
            formulaValue = (String)queryData.get("formula");
        }
        if (bgSchemeIdValue == null) return postils;
        if (orgUnitIdValue == null) return postils;
        if (formulaValue == null) return postils;
        if (versionNumValue == null) {
            return postils;
        }
        String bgSchemeId = null;
        String orgUnitId = null;
        String formula = null;
        HashMap<String, BgCommentInfo> postilMap = new HashMap<String, BgCommentInfo>();
        String bgCommentId = null;
        String bgVersionNum = null;
        String entryId = null;
        String bgContent = null;
        String userName = null;
        Timestamp bgCommentCreateTime = null;
        Timestamp bgCommentLastUpdateTime = null;
        Timestamp entryCreateTime = null;
        Timestamp entryLastUpdateTime = null;
        BgCommentInfo bgCommentInfo = null;
        BgCommentEntryInfo entryInfo = null;
        UserInfo userInfo = null;
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("select c.Fid,c.FBgSchemeId, c.FOrgUnitId, c.FFormula, c.FBgVersion, pmUser.FName_" + ctx.getLocale() + " AS user_FName , entry.FBgContent_" + ctx.getLocale() + " AS FBgContent ,").append(" entry.Fid  AS entry_Fid, entry.FBgContent_" + ctx.getLocale() + " AS entry_FBgContent, entry.FCreateTime AS entry_FCreateTime, entry.FLastUpdateTime AS entry_FLastUpdateTime ").append(" from T_MBG_BgComment c left join T_MBG_BgCommentEntry entry on c.FID = entry.FBgCommentId ").append(" left join T_PM_User pmUser on pmUser.FId = entry.FCreatorID ").append(" where c.FBgSchemeId = '" + bgSchemeIdValue + "'").append(" and c.FOrgUnitId = '" + orgUnitIdValue + "'").append(" and c.FBgVersion = '" + versionNumValue + "'").append(" and c.FFormula = '" + formulaValue + "'").append(" and c.FProcessType = " + processType.getValue());
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            while (rst.next()) {
                bgSchemeId = rst.getString("FBgSchemeId");
                orgUnitId = rst.getString("FOrgUnitId");
                formula = rst.getString("FFormula");
                bgVersionNum = rst.getString("FBgVersion");
                bgCommentId = rst.getString("Fid");
                entryId = rst.getString("entry_Fid");
                bgContent = rst.getString("entry_FBgContent");
                entryCreateTime = rst.getTimestamp("entry_FCreateTime");
                entryLastUpdateTime = rst.getTimestamp("entry_FLastUpdateTime");
                userName = rst.getString("user_FName");
                if (postilMap.containsKey(formula)) {
                    bgCommentInfo = (BgCommentInfo)postilMap.get(formula);
                } else {
                    bgCommentInfo = new BgCommentInfo();
                    bgCommentInfo.setId(BOSUuid.read((String)bgCommentId));
                    bgCommentInfo.setBgSchemeId(BOSUuid.read((String)bgSchemeId));
                    bgCommentInfo.setOrgUnitId(BOSUuid.read((String)orgUnitId));
                    bgCommentInfo.setFormula(formula);
                    bgCommentInfo.setBgVersion(bgVersionNum);
                    bgCommentInfo.setCreateTime(bgCommentCreateTime);
                    bgCommentInfo.setLastUpdateTime(bgCommentLastUpdateTime);
                    bgCommentInfo.setProcessType(processType);
                    postilMap.put(formula, bgCommentInfo);
                }
                if (entryId == null) continue;
                entryInfo = new BgCommentEntryInfo();
                entryInfo.setId(BOSUuid.read((String)entryId));
                entryInfo.setBgContent(bgContent);
                entryInfo.setCreateTime(entryCreateTime);
                entryInfo.setLastUpdateTime(entryLastUpdateTime);
                entryInfo.setBgComment(bgCommentInfo);
                userInfo = new UserInfo();
                userInfo.setName(userName);
                entryInfo.setLastUpdateUser(userInfo);
                bgCommentInfo.getEntries().add(entryInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (Exception ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return postilMap;
    }

    @Override
    protected void _saveBgComments(Context ctx, IObjectCollection saveBgComments, IObjectCollection deleteBgComments, BgProcessEnum processType, List refBills) throws BOSException, EASBizException {
        CoreBaseCollection deleteColls;
        IBgComment iBgComment = BgCommentFactory.getLocalInstance(ctx);
        CoreBaseCollection saveColls = (CoreBaseCollection)saveBgComments;
        this.setProcessType(saveColls, processType);
        if (saveColls != null && !saveColls.isEmpty()) {
            iBgComment.saveBatchData(saveColls);
            if (refBills != null) {
                for (Object info : refBills) {
                    if (info instanceof String[]) {
                        BgFormInfo f = new BgFormInfo();
                        f.setId(BOSUuid.read((String)((String[])info)[0]));
                        this.saveBgCommentRef(ctx, saveColls, f);
                        continue;
                    }
                    if (!(info instanceof IDimDataQuery)) continue;
                    this.saveBgCommentRef(ctx, saveColls, (IDimDataQuery)info);
                }
            }
        }
        if ((deleteColls = (CoreBaseCollection)deleteBgComments) != null && !deleteColls.isEmpty()) {
            IObjectPK[] deletePks = new IObjectPK[deleteColls.size()];
            for (int i = 0; i < deleteColls.size(); ++i) {
                deletePks[i] = new ObjectUuidPK(deleteColls.get(i).getId());
            }
            this.deleteBgCommentRef(ctx, deleteColls);
            iBgComment.deleteBatchData(deletePks);
        }
    }

    protected boolean checkSchemeHasBgComments(Context ctx, String bgSchemeId) throws BOSException, EASBizException {
        String sql = "select top 1 FID from T_MBG_BgComment where FBgSchemeId = '" + bgSchemeId + "'";
        IRowSet rowset = null;
        boolean isHasBgComments = false;
        try {
            rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowset.next()) {
                isHasBgComments = true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rowset);
        }
        return isHasBgComments;
    }
}

