/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgAdjustBillCollection;
import com.kingdee.eas.ma.mbg.BgAdjustBillEntryCollection;
import com.kingdee.eas.ma.mbg.BgAdjustBillEntryInfo;
import com.kingdee.eas.ma.mbg.BgAdjustBillFactory;
import com.kingdee.eas.ma.mbg.BgAdjustBillInfo;
import com.kingdee.eas.ma.mbg.BgAdjustBillStateEnum;
import com.kingdee.eas.ma.mbg.BgAuditIdeaCollection;
import com.kingdee.eas.ma.mbg.BgAuditIdeaFactory;
import com.kingdee.eas.ma.mbg.BgAuditIdeaInfo;
import com.kingdee.eas.ma.mbg.BgCourseCommentCollection;
import com.kingdee.eas.ma.mbg.BgCourseCommentFactory;
import com.kingdee.eas.ma.mbg.BgCourseCommentInfo;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgPastDataCollection;
import com.kingdee.eas.ma.mbg.BgPastDataInfo;
import com.kingdee.eas.ma.mbg.BgPastRecordCollection;
import com.kingdee.eas.ma.mbg.BgPastRecordFactory;
import com.kingdee.eas.ma.mbg.BgPastRecordInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.IBgAdjustBill;
import com.kingdee.eas.ma.mbg.IBgAuditIdea;
import com.kingdee.eas.ma.mbg.IBgCourseComment;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.IBgPastRecord;
import com.kingdee.eas.ma.mbg.IMbgViewListDesCell;
import com.kingdee.eas.ma.mbg.IMbgViewListDesCellEntry;
import com.kingdee.eas.ma.mbg.MBgAdjustConstants;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellCollection;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellEntryCollection;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellEntryFactory;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellEntryInfo;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellFactory;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellInfo;
import com.kingdee.eas.ma.mbg.app.AbstractBgCopyDataToDecompFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgCopyDataToDecompFacadeControllerBean
extends AbstractBgCopyDataToDecompFacadeControllerBean {
    private static final long serialVersionUID = 320991458005029202L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgCopyDataToDecompFacadeControllerBean");

    @Override
    protected Map _excute(Context ctx, String sourceBgSchemeId, String targeBgSchemeId) throws BOSException, EASBizException {
        Map<BOSUuid, BOSUuid> templateMap;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)sourceBgSchemeId) || StringUtils.isEmpty((String)targeBgSchemeId)) {
            return resultMap;
        }
        BgSchemeInfo sourceScheme = BgViewServerHelper.getBgSchemeInfo(ctx, BOSUuid.read((String)sourceBgSchemeId));
        BgSchemeInfo targeScheme = BgViewServerHelper.getBgSchemeInfo(ctx, BOSUuid.read((String)targeBgSchemeId));
        BgSchemeDimensionHelper targeHelper = new BgSchemeDimensionHelper(ctx, sourceBgSchemeId);
        String tBgOrgViewId = targeHelper.getBgOrgViewId();
        BgCubeUtils.checkTable(ctx);
        ArrayList<String> orgLst = new ArrayList<String>();
        BgOrgUnitCollection orgColls = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection("select orgUnitID where viewId = '" + tBgOrgViewId + "' and isLeaf = 1 ");
        if (orgColls != null && !orgColls.isEmpty()) {
            for (int index = 0; index < orgColls.size(); ++index) {
                orgLst.add(orgColls.get(index).getOrgUnitID());
            }
        }
        if ((templateMap = this.getTemplateMap(ctx, sourceScheme, targeScheme)) == null || templateMap.isEmpty()) {
            return resultMap;
        }
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        BgFormCollection existColls = iBgForm.getBgFormCollection("select id where bgScheme.id = '" + targeScheme.getId().toString() + "'");
        if (existColls != null && !existColls.isEmpty()) {
            throw new BgFormException(BgFormException.SHOWEXCEPTION, new String[]{BgNFSHelper.getHardCodeRes(ctx, "existDataMove")});
        }
        HashMap<BOSUuid, BOSUuid> formIdMap = null;
        BgFormInfo sForm = null;
        BgFormInfo tForm = null;
        CoreBaseCollection tColls = null;
        for (int index = 0; index < orgLst.size(); ++index) {
            String orgUnitId = (String)orgLst.get(index);
            BgFormCollection colls = iBgForm.getBgFormCollection("where bgScheme.id = '" + sourceScheme.getId().toString() + "' and orgUnit.id = '" + orgUnitId + "'");
            if (colls == null || colls.isEmpty()) continue;
            formIdMap = new HashMap<BOSUuid, BOSUuid>();
            tColls = new CoreBaseCollection();
            for (int i = 0; i < colls.size(); ++i) {
                sForm = colls.get(i);
                if (!templateMap.containsKey(sForm.getBgTemplate().getId())) continue;
                tForm = sForm.deepclone();
                tForm.setId(BOSUuid.create((BOSObjectType)tForm.getBOSType()));
                tForm.setBgScheme(targeScheme);
                tForm.getBgTemplate().setId(templateMap.get(sForm.getBgTemplate().getId()));
                tForm.setProcessType(BgProcessEnum.C02);
                tColls.add((CoreBaseInfo)tForm);
                formIdMap.put(sForm.getId(), tForm.getId());
            }
            if (!tColls.isEmpty()) {
                iBgForm.addnewBatchData(tColls);
            }
            this.copyDesCell(ctx, formIdMap, templateMap, sourceBgSchemeId, targeBgSchemeId, orgUnitId);
            Map<BOSUuid, BOSUuid> bgAdjustBillIdMap = this.copyBgAdjustBill(ctx, formIdMap, templateMap, sourceBgSchemeId, targeScheme, orgUnitId);
            this.copyPastRecord(ctx, formIdMap, templateMap, sourceBgSchemeId, targeBgSchemeId, orgUnitId, bgAdjustBillIdMap);
        }
        Connection conn = null;
        String sCubeName = sourceScheme.getRefCube();
        String sCubeEntry = BgCubeUtils.getBudgetEntryCubeName(sCubeName);
        String tDecCubeName = BgCubeUtils.getCubeName(targeScheme.getRefCube(), BgProcessEnum.C02);
        String tDecCubeEntry = BgCubeUtils.getEntryCubeName(targeScheme.getRefCube(), BgProcessEnum.C02);
        try {
            conn = this.getConnection(ctx);
            List<String> fieldlst = sourceScheme.getRefFields(conn);
            StringBuffer fields = new StringBuffer();
            fields.append("FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitID, FFormula, FValue, FTmpValue, ");
            for (String field : fieldlst) {
                fields.append(field + ",");
            }
            fields.append("FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState");
            StringBuffer sql = new StringBuffer();
            sql.append("Insert Into " + tDecCubeName + " (").append(fields).append(") select ").append(fields).append(" from " + sCubeName + " where FScenario in (select FScenarioID from t_mbg_bgScenario where FType = " + 0 + ")");
            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString());
            BgDBUtils.executeUpdate((Connection)conn, (String)("insert into " + tDecCubeEntry + " ( FFormId, FDataId ) select FFormId, FDataId from " + sCubeEntry));
        }
        catch (SQLException e) {
            throw new BOSException("", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        resultMap.put("success", BgNFSHelper.getHardCodeRes(ctx, "dataMoveSuccess"));
        return resultMap;
    }

    protected void copyDesCell(Context ctx, Map<BOSUuid, BOSUuid> formIdMap, Map<BOSUuid, BOSUuid> templateMap, String sSchemeId, String tSchemeId, String orgUnitId) throws BOSException, EASBizException {
        if (formIdMap.isEmpty() || templateMap.isEmpty() || StringUtils.isEmpty((String)sSchemeId) || StringUtils.isEmpty((String)tSchemeId) || StringUtils.isEmpty((String)orgUnitId)) {
            return;
        }
        IMbgViewListDesCell iMbgViewListDesCell = MbgViewListDesCellFactory.getLocalInstance(ctx);
        IMbgViewListDesCellEntry iMbgViewListDesCellEntry = MbgViewListDesCellEntryFactory.getLocalInstance(ctx);
        HashSet<String> sIds = new HashSet<String>();
        MbgViewListDesCellInfo sInfo = null;
        MbgViewListDesCellInfo tInfo = null;
        MbgViewListDesCellCollection sColls = null;
        CoreBaseCollection tColls = null;
        MbgViewListDesCellEntryInfo sEntry = null;
        MbgViewListDesCellEntryInfo tEntry = null;
        MbgViewListDesCellEntryCollection sEntrys = null;
        CoreBaseCollection tEntrys = null;
        HashMap<BOSUuid, BOSUuid> desMap = null;
        sColls = iMbgViewListDesCell.getMbgViewListDesCellCollection("where bgSchemeId = '" + sSchemeId + "' and orgUnitId = '" + orgUnitId + "'");
        if (sColls != null && !sColls.isEmpty()) {
            tColls = new CoreBaseCollection();
            desMap = new HashMap<BOSUuid, BOSUuid>();
            for (int i = 0; i < sColls.size(); ++i) {
                sInfo = sColls.get(i);
                sIds.add(sInfo.getId().toString());
                tInfo = (MbgViewListDesCellInfo)sInfo.clone();
                tInfo.remove("id");
                tInfo.setId(BOSUuid.create((BOSObjectType)tInfo.getBOSType()));
                tInfo.setBgSchemeId(BOSUuid.read((String)tSchemeId));
                tInfo.setBgTemplateId(templateMap.get(sInfo.getBgTemplateId()));
                tInfo.setProcessType(BgProcessEnum.C02);
                tColls.add((CoreBaseInfo)tInfo);
                desMap.put(sInfo.getId(), tInfo.getId());
            }
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("viewListDesId", sIds, CompareType.INCLUDE));
            sEntrys = iMbgViewListDesCellEntry.getMbgViewListDesCellEntryCollection(view);
            if (sEntrys != null && !sEntrys.isEmpty()) {
                tEntrys = new CoreBaseCollection();
                for (int i = 0; i < sEntrys.size(); ++i) {
                    sEntry = sEntrys.get(i);
                    if (!desMap.containsKey(sEntry.getViewListDesId())) continue;
                    tEntry = new MbgViewListDesCellEntryInfo();
                    tEntry.setId(BOSUuid.create((BOSObjectType)tEntry.getBOSType()));
                    tEntry.setViewListDesId((BOSUuid)desMap.get(sEntry.getViewListDesId()));
                    if (templateMap.containsKey(sEntry.getBgFormId())) {
                        tEntry.setBgFormId(templateMap.get(sEntry.getBgFormId()));
                    } else if (formIdMap.containsKey(sEntry.getBgFormId())) {
                        tEntry.setBgFormId(formIdMap.get(sEntry.getBgFormId()));
                    }
                    tEntrys.add((CoreBaseInfo)tEntry);
                }
            }
            if (!tColls.isEmpty()) {
                iMbgViewListDesCell.saveBatchData(tColls);
            }
            if (tEntrys != null && !tEntrys.isEmpty()) {
                iMbgViewListDesCellEntry.saveBatchData(tEntrys);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<BOSUuid, BOSUuid> copyBgAdjustBill(Context ctx, Map<BOSUuid, BOSUuid> formIdMap, Map<BOSUuid, BOSUuid> templateMap, String sSchemeId, BgSchemeInfo tSchemeInfo, String orgUnitId) throws BOSException, EASBizException {
        PreparedStatement pstmt;
        Connection conn;
        HashMap<BOSUuid, BOSUuid> bgAdjustBillIdMap;
        block18: {
            bgAdjustBillIdMap = new HashMap<BOSUuid, BOSUuid>();
            if (formIdMap.isEmpty()) return bgAdjustBillIdMap;
            if (templateMap.isEmpty()) return bgAdjustBillIdMap;
            if (StringUtils.isEmpty((String)sSchemeId)) return bgAdjustBillIdMap;
            if (tSchemeInfo == null) return bgAdjustBillIdMap;
            if (StringUtils.isEmpty((String)orgUnitId)) {
                return bgAdjustBillIdMap;
            }
            IBgAdjustBill iBgAdjustBill = BgAdjustBillFactory.getLocalInstance(ctx);
            BgAdjustBillCollection sColls = null;
            CoreBaseCollection tColls = null;
            BgAdjustBillInfo sInfo = null;
            BgAdjustBillInfo tInfo = null;
            BgAdjustBillEntryCollection sEntrys = null;
            BgAdjustBillEntryCollection tEntrys = null;
            BgAdjustBillEntryInfo sEntry = null;
            BgAdjustBillEntryInfo tEntry = null;
            HashSet<String> sIds = new HashSet<String>();
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = MBgAdjustConstants.getSelectors();
            sic.add("bizDate");
            sic.add("CU.id");
            view.setSelector(sic);
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)sSchemeId, CompareType.EQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
            sColls = iBgAdjustBill.getBgAdjustBillCollection(view);
            if (sColls != null && !sColls.isEmpty()) {
                tColls = new CoreBaseCollection();
                for (int i = 0; i < sColls.size(); ++i) {
                    sInfo = sColls.get(i);
                    sIds.add(sInfo.getId().toString());
                    sEntrys = sInfo.getEntity();
                    tInfo = (BgAdjustBillInfo)sInfo.clone();
                    tInfo.setId(BOSUuid.create((BOSObjectType)tInfo.getBOSType()));
                    tInfo.setBgScheme(tSchemeInfo);
                    tInfo.setProcessType(BgProcessEnum.C02);
                    tInfo.setNumber(null);
                    if (tInfo.getState().equals((Object)BgAdjustBillStateEnum.submit)) {
                        tInfo.setState(BgAdjustBillStateEnum.adjusting);
                    }
                    if (sEntrys != null && !sEntrys.isEmpty()) {
                        tEntrys = new BgAdjustBillEntryCollection();
                        for (int j = 0; j < sEntrys.size(); ++j) {
                            sEntry = sEntrys.get(j);
                            tEntry = (BgAdjustBillEntryInfo)sEntry.clone();
                            tEntry.setId(BOSUuid.create((BOSObjectType)tEntry.getBOSType()));
                            tEntry.setBgAdjustBill(tInfo);
                            tEntrys.add(tEntry);
                        }
                        tInfo.getEntity().clear();
                        tInfo.getEntity().addCollection(tEntrys);
                    }
                    bgAdjustBillIdMap.put(sInfo.getId(), tInfo.getId());
                    tColls.add((CoreBaseInfo)tInfo);
                    iBgAdjustBill.addnew(tInfo);
                }
            }
            if (sIds.isEmpty()) return bgAdjustBillIdMap;
            conn = null;
            pstmt = null;
            ResultSet rs = null;
            String tmpTable = null;
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            ArrayList<Object[]> billPeridos = new ArrayList<Object[]>();
            Object[] billPeriod = null;
            try {
                conn = this.getConnection(ctx);
                tmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FID) values (?)"), sIds);
                String sql2332 = "select fbillid, fperiodId ,fseq from T_mbg_adjustBillPeriods where fbillid in (select FID From " + tmpTable + ") order by fseq";
                pstmt = conn.prepareStatement(sql2332);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    billPeriod = new Object[]{rs.getString("fbillid"), rs.getString("fperiodId"), rs.getInt("fseq")};
                    billPeridos.add(billPeriod);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
                StringBuffer sqlStr = new StringBuffer();
                int batchIndex = 0;
                sqlStr.append("Insert Into T_mbg_adjustBillPeriods (FbillID, fperiodId,fseq) Values (?,?,?)");
                pstmt = conn.prepareStatement(sqlStr.toString());
                for (int index = 0; index < billPeridos.size(); ++index) {
                    billPeriod = (Object[])billPeridos.get(index);
                    if (!bgAdjustBillIdMap.containsKey(BOSUuid.read((String)String.valueOf(billPeriod[0])))) continue;
                    pstmt.setString(1, ((BOSUuid)bgAdjustBillIdMap.get(BOSUuid.read((String)String.valueOf(billPeriod[0])))).toString());
                    pstmt.setString(2, String.valueOf(billPeriod[1]));
                    pstmt.setInt(3, (Integer)billPeriod[2]);
                    pstmt.addBatch();
                    if (++batchIndex < 50) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                }
                if (batchIndex != 0) {
                    pstmt.executeBatch();
                }
                if (pool == null || tmpTable == null) break block18;
            }
            catch (Exception e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (pool != null && tmpTable != null) {
                        try {
                            pool.releaseDBSystemTempTable(tmpTable, conn);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            try {
                pool.releaseDBSystemTempTable(tmpTable, conn);
            }
            catch (Exception sql2332) {
                // empty catch block
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return bgAdjustBillIdMap;
    }

    protected void copyPastRecord(Context ctx, Map<BOSUuid, BOSUuid> formIdMap, Map<BOSUuid, BOSUuid> templateMap, String sSchemeId, String tSchemeId, String orgUnitId, Map<BOSUuid, BOSUuid> bgAdjustBillIdMap) throws BOSException, EASBizException {
        IBgPastRecord iBgPastRecord = BgPastRecordFactory.getLocalInstance(ctx);
        BgPastRecordCollection sColls = null;
        CoreBaseCollection tColls = null;
        BgPastRecordInfo sInfo = null;
        BgPastRecordInfo tInfo = null;
        BgPastDataCollection sEntrys = null;
        BgPastDataCollection tEntrys = null;
        BgPastDataInfo sEntry = null;
        BgPastDataInfo tEntry = null;
        HashSet<String> formIds = new HashSet<String>();
        for (BOSUuid id : formIdMap.keySet()) {
            formIds.add(id.toString());
        }
        for (BOSUuid id : bgAdjustBillIdMap.keySet()) {
            formIds.add(id.toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("pastDatas.*");
        view.setSelector(sic);
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("bgFormId", formIds, CompareType.INCLUDE));
        sColls = iBgPastRecord.getBgPastRecordCollection(view);
        if (sColls != null && !sColls.isEmpty()) {
            tColls = new CoreBaseCollection();
            for (int i = 0; i < sColls.size(); ++i) {
                sInfo = sColls.get(i);
                tInfo = (BgPastRecordInfo)sInfo.clone();
                tInfo.setId(BOSUuid.create((BOSObjectType)tInfo.getBOSType()));
                if (sInfo.getBgFormId() != null) {
                    if (formIdMap.containsKey(BOSUuid.read((String)sInfo.getBgFormId()))) {
                        tInfo.setBgFormId(formIdMap.get(BOSUuid.read((String)sInfo.getBgFormId())).toString());
                    } else if (bgAdjustBillIdMap.containsKey(BOSUuid.read((String)sInfo.getBgFormId()))) {
                        tInfo.setBgFormId(bgAdjustBillIdMap.get(BOSUuid.read((String)sInfo.getBgFormId())).toString());
                    }
                }
                if ((sEntrys = tInfo.getPastDatas()) != null && !sEntrys.isEmpty()) {
                    tEntrys = new BgPastDataCollection();
                    for (int j = 0; j < sEntrys.size(); ++j) {
                        sEntry = sEntrys.get(j);
                        tEntry = (BgPastDataInfo)sEntry.clone();
                        tEntry.setId(BOSUuid.create((BOSObjectType)tEntry.getBOSType()));
                        tEntry.setPastRecord(tInfo);
                        tEntrys.add(tEntry);
                    }
                    if (!tEntrys.isEmpty()) {
                        tInfo.getPastDatas().clear();
                        tInfo.getPastDatas().addCollection(tEntrys);
                    }
                }
                tColls.add((CoreBaseInfo)tInfo);
            }
            if (!tColls.isEmpty()) {
                iBgPastRecord.saveBatchData(tColls);
            }
        }
    }

    protected void copyBgAuditIdea(Context ctx, Map<BOSUuid, BOSUuid> formIdMap) throws BOSException, EASBizException {
        IBgAuditIdea iBgAuditIdea = BgAuditIdeaFactory.getLocalInstance(ctx);
        BgAuditIdeaCollection sColls = null;
        CoreBaseCollection tColls = null;
        BgAuditIdeaInfo sInfo = null;
        BgAuditIdeaInfo tInfo = null;
        HashSet<String> formIds = new HashSet<String>();
        for (BOSUuid id : formIdMap.keySet()) {
            formIds.add(id.toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("formId", formIds, CompareType.INCLUDE));
        sColls = iBgAuditIdea.getBgAuditIdeaCollection(view);
        if (sColls != null && !sColls.isEmpty()) {
            tColls = new CoreBaseCollection();
            for (int i = 0; i < sColls.size(); ++i) {
                sInfo = sColls.get(i);
                if (formIdMap.containsKey(sInfo.getFormId())) {
                    tInfo = (BgAuditIdeaInfo)sInfo.clone();
                    tInfo.setId(BOSUuid.create((BOSObjectType)tInfo.getBOSType()));
                    tInfo.setFormId(formIdMap.get(tInfo.getFormId()));
                }
                if (tColls.isEmpty()) continue;
                iBgAuditIdea.saveBatchData(tColls);
            }
        }
    }

    protected void copyBgCourseComment(Context ctx, Map<BOSUuid, BOSUuid> formIdMap) throws BOSException, EASBizException {
        IBgCourseComment iBgCourseComment = BgCourseCommentFactory.getLocalInstance(ctx);
        BgCourseCommentCollection sColls = null;
        CoreBaseCollection tColls = null;
        BgCourseCommentInfo sInfo = null;
        BgCourseCommentInfo tInfo = null;
        HashSet<String> formIds = new HashSet<String>();
        for (BOSUuid id : formIdMap.keySet()) {
            formIds.add(id.toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("bgFormId", formIds, CompareType.INCLUDE));
        sColls = iBgCourseComment.getBgCourseCommentCollection(view);
        if (sColls != null && !sColls.isEmpty()) {
            tColls = new CoreBaseCollection();
            for (int i = 0; i < sColls.size(); ++i) {
                sInfo = sColls.get(i);
                if (formIdMap.containsKey(BOSUuid.read((String)sInfo.getBgFormId()))) {
                    tInfo = (BgCourseCommentInfo)sInfo.clone();
                    tInfo.setId(BOSUuid.create((BOSObjectType)tInfo.getBOSType()));
                    tInfo.setBgFormId(formIdMap.get(BOSUuid.read((String)sInfo.getBgFormId())).toString());
                    tColls.add((CoreBaseInfo)tInfo);
                }
                if (tColls.isEmpty()) continue;
                iBgCourseComment.saveBatchData(tColls);
            }
        }
    }

    private Map<BOSUuid, BOSUuid> getTemplateMap(Context ctx, BgSchemeInfo sSchemeInfo, BgSchemeInfo tSchemeInfo) throws BOSException {
        if (sSchemeInfo == null || tSchemeInfo == null) {
            return null;
        }
        BgTemplateInfo sInfo = null;
        BgTemplateInfo tInfo = null;
        HashMap<BOSUuid, BOSUuid> mp = new HashMap<BOSUuid, BOSUuid>();
        String sql = "select id, number, name, bgScheme.id where bgScheme.id in ('" + sSchemeInfo.getId().toString() + "', '" + tSchemeInfo.getId().toString() + "')";
        BgTemplateCollection colls = BgTemplateFactory.getLocalInstance(ctx).getBgTemplateCollection(sql);
        if (colls != null) {
            for (int i = 0; i < colls.size(); ++i) {
                sInfo = colls.get(i);
                for (int j = 0; j < colls.size(); ++j) {
                    tInfo = colls.get(j);
                    if (!sInfo.getBgScheme().getId().toString().equals(sSchemeInfo.getId().toString()) || !tInfo.getBgScheme().getId().toString().equals(tSchemeInfo.getId().toString()) || !sInfo.getNumber().equals(tInfo.getNumber())) continue;
                    mp.put(sInfo.getId(), tInfo.getId());
                }
            }
        }
        return mp;
    }
}

