/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectSingleKey;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgParamNHelper;
import com.kingdee.eas.ma.mbg.BgCourseCommentCollection;
import com.kingdee.eas.ma.mbg.BgCourseCommentFactory;
import com.kingdee.eas.ma.mbg.BgCourseCommentInfo;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgTemplateStatusEnum;
import com.kingdee.eas.ma.mbg.BgTypeInfo;
import com.kingdee.eas.ma.mbg.MbgPermissionFactory;
import com.kingdee.eas.ma.mbg.MbgPermissionTypeEnum;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.app.AbstractBgCourseFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCourseFacadeControllerBean
extends AbstractBgCourseFacadeControllerBean {
    private static final long serialVersionUID = 497115466766338585L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgCourseFacadeControllerBean");
    private static final String PERMISSION_STR = "mbg_course01_list";

    @Override
    protected Map _queryCourseInfo(Context ctx, Map parameter) throws BOSException, EASBizException {
        TempTablePool pool;
        Connection conn;
        String dataPermBgForm;
        String tmpBgForm;
        HashMap<String, Map> resultMap;
        block43: {
            String[] orgIds;
            if (parameter == null || parameter.isEmpty()) {
                return null;
            }
            String bgOrgViewId = (String)parameter.get("CURR_ORGUNIT_VIEW_ID");
            String curUserID = (String)parameter.get("CURR_USER_ID");
            String selectBgOrgID = (String)parameter.get("SEL_ORGUNIT_ID");
            String[] selectSchemeIDS = (String[])parameter.get("SEL_BGSCHEME_IDS");
            String[] selectPeriodIDS = (String[])parameter.get("SEL_BGPERIOD_IDS");
            String[] selectCurrencyIDS = (String[])parameter.get("SEL_CURRENCY_IDS");
            String[] selectVersionIDS = (String[])parameter.get("SEL_BGVERSION_IDS");
            String[] selectTemplateIDS = (String[])parameter.get("SEL_BGTEMPLATE_IDS");
            Set dataPermFormIdSet = (Set)parameter.get("DATAPERM_FORMIDS");
            boolean isContainForbidden = (Boolean)parameter.get("SEL_FORBIDDEN_TEMPLATE");
            int[] processType = (int[])parameter.get("SEL_PROCESSTYPE");
            HashSet<Integer> processTypes = new HashSet<Integer>();
            if (processType != null && processType.length > 0) {
                processTypes.add(processType[0]);
            }
            Integer selectOrgunitType = (Integer)parameter.get("SEL_ORGUNIT_TYPE");
            BgTypeInfo bgtypeInfo = (BgTypeInfo)parameter.get("SEL_BGTYPE");
            resultMap = new HashMap<String, Map>();
            HashSet<Integer> _state = new HashSet<Integer>();
            HashMap<String, String> _bgFormAtt = new HashMap<String, String>();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection sic = this.getBgFormSelectorItem();
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            HashSet<String> bgSchemeIdsSet = new HashSet<String>();
            this.copyArrayToSet(bgSchemeIdsSet, selectSchemeIDS);
            HashSet<String> bgTemplateIdsSet = new HashSet<String>();
            this.copyArrayToSet(bgTemplateIdsSet, selectTemplateIDS);
            HashSet<String> bgPeriodIdsSet = new HashSet<String>();
            this.copyArrayToSet(bgPeriodIdsSet, selectPeriodIDS);
            HashSet<String> currnecyIdsSet = new HashSet<String>();
            this.copyArrayToSet(currnecyIdsSet, selectCurrencyIDS);
            _state.add(new Integer(15));
            _state.add(new Integer(5));
            HashSet<String> bgVersionIdsSet = new HashSet<String>();
            this.copyArrayToSet(bgVersionIdsSet, selectVersionIDS);
            filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", bgSchemeIdsSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("bgVersion.id", bgVersionIdsSet, CompareType.INCLUDE));
            boolean isTemplateIdsEmpty = EmptyUtil.isEmpty(bgTemplateIdsSet);
            if (!isTemplateIdsEmpty) {
                StringBuilder sb = new StringBuilder();
                sb.append("select frootid from T_MBG_BgTemplate where fid in (");
                for (Object e : bgTemplateIdsSet) {
                    sb.append("'").append(e.toString()).append("',");
                }
                sb = sb.deleteCharAt(sb.lastIndexOf(","));
                sb.append(")");
                filter.getFilterItems().add(new FilterItemInfo("bgTemplate.root.id", (Object)sb.toString(), CompareType.INNER));
            } else if (!isContainForbidden) {
                filter.getFilterItems().add(new FilterItemInfo("bgTemplate.templateStatus", (Object)Integer.toString(0), CompareType.EQUALS));
            }
            filter.getFilterItems().add(new FilterItemInfo("bgPeriod.id", bgPeriodIdsSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", currnecyIdsSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("state", _state, CompareType.NOTINCLUDE));
            BgOrgUnitInfo bgOrgUnitInfo = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitInfo("select id, longNumber, orgUnitID, level where id = '" + selectBgOrgID + "'");
            Set<Object> _queryOrgUnitIds = new HashSet<String>();
            if (selectOrgunitType == 2) {
                _queryOrgUnitIds = this.queryImmOrgUnit(ctx, bgOrgUnitInfo.getLongNumber(), bgOrgViewId, bgOrgUnitInfo.getLevel() + 1);
            } else if (selectOrgunitType == 3) {
                _queryOrgUnitIds = this.queryImmOrgUnit(ctx, bgOrgUnitInfo.getLongNumber(), bgOrgViewId, -1);
            }
            if (bgOrgUnitInfo.getLongNumber().indexOf("!") <= 0) {
                _queryOrgUnitIds.add(bgOrgUnitInfo.getOrgUnitID());
            }
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo _filter = new FilterInfo();
            _filter.getFilterItems().add(new FilterItemInfo("id", bgSchemeIdsSet, CompareType.INCLUDE));
            entityViewInfo.setFilter(_filter);
            entityViewInfo.getSelector().add("orgUnit.id");
            entityViewInfo.getSelector().add("bgSchemeType.schemeType");
            BgSchemeCollection bgSchemeCollection = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeCollection(entityViewInfo);
            HashMap<String, BgSchemeInfo> bgSchemeMap = new HashMap<String, BgSchemeInfo>();
            for (int i = 0; i < bgSchemeCollection.size(); ++i) {
                bgSchemeMap.put(bgSchemeCollection.get(i).getId().toString(), bgSchemeCollection.get(i));
                if (!bgOrgUnitInfo.getOrgUnitID().equals(bgSchemeCollection.get(i).getOrgUnit().getId().toString())) continue;
                _queryOrgUnitIds.add(bgOrgUnitInfo.getOrgUnitID());
            }
            if (_queryOrgUnitIds.isEmpty()) {
                return null;
            }
            Set<Object> permissionOrgUnits = new HashSet();
            BgOrgUnitCollection orgUnitColl = null;
            if (selectOrgunitType == 2) {
                orgUnitColl = this.getDirectOrgUnits(ctx, bgOrgViewId, bgOrgUnitInfo, false, true);
            } else if (selectOrgunitType == 3) {
                permissionOrgUnits = this.getAllOrgUnits(ctx, bgOrgViewId, bgOrgUnitInfo, false, true);
            }
            if (orgUnitColl != null && !orgUnitColl.isEmpty()) {
                for (int i = 0; i < orgUnitColl.size(); ++i) {
                    if (DimensionCommonHelper.isDecompose(BgProcessEnum.getEnum(processType[0])) && orgUnitColl.get(i).isIsLeaf()) continue;
                    permissionOrgUnits.add(orgUnitColl.get(i).getOrgUnitID().toString());
                }
            }
            _queryOrgUnitIds.retainAll(permissionOrgUnits);
            Set bgOrgUnitPer = MbgPermissionFactory.getLocalInstance(ctx).getBgOrgUnitPermission(null, curUserID, selectSchemeIDS.length > 0 ? selectSchemeIDS[0] : null);
            if (!bgOrgUnitPer.isEmpty()) {
                Iterator<Object> iterator = _queryOrgUnitIds.iterator();
                while (iterator.hasNext()) {
                    String orgid = (String)iterator.next();
                    if (bgOrgUnitPer.contains(orgid)) continue;
                    iterator.remove();
                }
            }
            if (parameter.get("SEL_ORGS") instanceof String[] && (orgIds = (String[])parameter.get("SEL_ORGS")).length > 0) {
                _queryOrgUnitIds.retainAll(Arrays.asList(orgIds));
            }
            this.filterOrgIdByOrgRange(ctx, _queryOrgUnitIds);
            if (_queryOrgUnitIds.isEmpty()) {
                return null;
            }
            String tmpOrgUnit = null;
            tmpBgForm = null;
            dataPermBgForm = null;
            conn = null;
            pool = TempTablePool.getInstance((Context)ctx);
            try {
                conn = this.getConnection(ctx);
                tmpOrgUnit = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpOrgUnit + " (FID) values (?)"), _queryOrgUnitIds);
                tmpBgForm = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.executeUpdate((Connection)conn, (String)("insert into " + tmpBgForm + "(FID) (select fadjustId from T_MBG_BgForm where FState in (" + 4 + " , " + 35 + "))"));
                dataPermBgForm = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.insertKey((Connection)conn, (String)("insert into " + dataPermBgForm + "(FID) values (?)"), (Collection)dataPermFormIdSet);
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)("select FID from " + tmpOrgUnit), CompareType.INNER));
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)("select FID from " + tmpBgForm), CompareType.NOTINNER));
                if (bgtypeInfo != null) {
                    filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", (Object)bgtypeInfo.getId().toString()));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", null));
                    filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", (Object)"bgMAAAAKIcA7rHKd", CompareType.NOTEQUALS));
                }
                filter.getFilterItems().add(new FilterItemInfo("bgTemplate.readonly", (Object)new Boolean(false), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("processType", processTypes, CompareType.INCLUDE));
                if (!isTemplateIdsEmpty) {
                    if (bgtypeInfo != null) {
                        filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and #6 and #7 and #8 and #9 and #10 ");
                    } else {
                        filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and #6 and #7 and (#8 or #9) and #10 and #11");
                    }
                } else if (!isContainForbidden) {
                    if (bgtypeInfo != null) {
                        filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and #6 and #7 and #8 and #9 and #10");
                    } else {
                        filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and #6 and #7 and (#8 or #9) and #10 and #11");
                    }
                } else if (bgtypeInfo != null) {
                    filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and #6 and #7 and #8 and #9  ");
                } else {
                    filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and #6 and (#7 or #8) and #9 and #10 ");
                }
                this.filterQuery(filter);
                if (!dataPermFormIdSet.isEmpty()) {
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)("select FID from " + dataPermBgForm), CompareType.INNER));
                    filter.mergeFilter(filterInfo, "and");
                }
                MbgPermissionHelper.addFieldDataPermission(ctx, RptSrcTypeEnum.PT_BUDGET_REPORT, curUserID, filter, MbgPermissionTypeEnum.TEMPLATE, "bgtemplate.id", selectSchemeIDS.length > 0 ? selectSchemeIDS[0] : null, true);
                view.setFilter(filter);
                Map<String, BgFormInfo> bgFormMap = this.queryBgFormFromDB(ctx, view, _bgFormAtt);
                Map<String, Map<String, BgTemplateInfo>> bgTemplateMap = this.queryBgTemplateInfo(ctx, curUserID, bgOrgUnitInfo.getOrgUnitID(), tmpOrgUnit, bgSchemeIdsSet, bgTemplateIdsSet, false, isContainForbidden, bgSchemeMap, bgtypeInfo);
                BgPeriodCollection bgPeriodCol = this.queryBgPeriod(ctx, bgPeriodIdsSet);
                CurrencyCollection currencyCol = this.queryCurrency(ctx, currnecyIdsSet);
                BgVersionCollection bgVersionCol = this.queryBgVersion(ctx, bgVersionIdsSet);
                Map keyMap = this.getKeyMap(this.queryOrgInfo(ctx, bgOrgViewId, _queryOrgUnitIds), bgTemplateMap, bgPeriodCol, currencyCol, bgVersionCol, bgFormMap);
                DimensionCacheHelper cacheHelper = new DimensionCacheHelper(ctx);
                Map<String, Boolean> isShowAliasMap = cacheHelper.removeViewKey(bgOrgViewId, cacheHelper.isShowAlias(bgOrgViewId, _queryOrgUnitIds));
                Map<String, String> aliasMap = cacheHelper.getAliasMap(bgPeriodIdsSet);
                Map virtualMap = BgOrgUnitFactory.getLocalInstance(ctx).getOrgVirtualInfo(selectBgOrgID, _queryOrgUnitIds);
                resultMap.put("key2BgformMap", bgFormMap);
                resultMap.put("bgFormAtt", _bgFormAtt);
                resultMap.put("keyMap", keyMap);
                resultMap.put("isShowAliasMap", isShowAliasMap);
                resultMap.put("aliasMap", aliasMap);
                resultMap.put("virtualMap", virtualMap);
                if (pool == null || tmpOrgUnit == null) break block43;
            }
            catch (Exception ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    if (pool != null && tmpOrgUnit != null) {
                        pool.releaseTable(tmpOrgUnit);
                    }
                    if (pool != null && tmpBgForm != null) {
                        pool.releaseTable(tmpBgForm);
                    }
                    if (pool != null && dataPermBgForm != null) {
                        pool.releaseTable(dataPermBgForm);
                    }
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
            pool.releaseTable(tmpOrgUnit);
        }
        if (pool != null && tmpBgForm != null) {
            pool.releaseTable(tmpBgForm);
        }
        if (pool != null && dataPermBgForm != null) {
            pool.releaseTable(dataPermBgForm);
        }
        SQLUtils.cleanup((Connection)conn);
        return resultMap;
    }

    private boolean isCurrentOrgInRange(Context ctx, String userId, String orgId) {
        OrgRangeCollection collection = null;
        try {
            collection = OrgRangeFactory.getLocalInstance((Context)ctx).findFullOrgCol(Arrays.asList(userId), Arrays.asList(orgId), OrgRangeType.BIZ_ORG_TYPE);
        }
        catch (Exception e) {
            logger.error((Object)"filterOrgIdByOrgRange error", (Throwable)e);
            return true;
        }
        return !collection.isEmpty();
    }

    private void filterOrgIdByOrgRange(Context ctx, Set<String> queryOrgIds) {
        if (!BgParamNHelper.isFilterByOrgRange((Context)ctx)) {
            return;
        }
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        if (ToolUtils.isNullList(queryOrgIds) || userPK == null) {
            return;
        }
        OrgRangeCollection collection = null;
        try {
            collection = OrgRangeFactory.getLocalInstance((Context)ctx).findFullOrgCol(Arrays.asList(userPK.toString()), new ArrayList<String>(queryOrgIds), OrgRangeType.BIZ_ORG_TYPE);
        }
        catch (Exception e) {
            logger.error((Object)"filterOrgIdByOrgRange error", (Throwable)e);
            return;
        }
        HashSet<String> inRangIdSet = new HashSet<String>();
        for (int i = 0; i < collection.size(); ++i) {
            inRangIdSet.add(collection.get(i).getOrg().getId().toString());
        }
        queryOrgIds.retainAll(inRangIdSet);
    }

    private Set<String> getAllOrgUnits(Context ctx, String bgOrgViewId, BgOrgUnitInfo bgOrgUnitInfo, boolean isOUSealUp, boolean isNeedAddOrgRange) throws BOSException {
        String longNumber = bgOrgUnitInfo.getLongNumber();
        if (StringUtils.isEmpty((String)bgOrgViewId)) {
            throw new BOSException("BgOrgViewId is null!");
        }
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        if (!this.isCurrentOrgInRange(ctx, userPK.toString(), bgOrgUnitInfo.getOrgUnitID())) {
            return new HashSet<String>();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select orgUnitId,longNumber,name where viewid = '" + bgOrgViewId + "' and ( longNumber like '" + longNumber + "!%'");
        if (longNumber.indexOf("!") <= 0) {
            sql.append(" or longNumber  = '" + longNumber + "'");
        }
        sql.append(" )");
        BgOrgUnitCollection bgOrgUnitColl = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(sql.toString());
        sql.setLength(0);
        ArrayList<Object> paramList = new ArrayList<Object>();
        sql.append("Select org.FOrgUnitId AS FOrgUnitId, org.FLongNumber AS FLongNumber, org.FShowLevel AS FShowLevel FROM T_Mbg_BgOrgUnit org ");
        if (!isOUSealUp || isNeedAddOrgRange) {
            sql.append(" INNER JOIN T_PM_ORGRANGE orgRange ON orgRange.FOrgId = org.FORGUNITID ").append(" AND orgRange.FUserId = ? and orgRange.FType = ?");
            paramList.add(userPK.toString());
            paramList.add(10);
            sql.append(" Where org.FViewId = ? ");
            paramList.add(bgOrgViewId);
            if (longNumber != null) {
                sql.append(" AND ( org.FLongNumber like ? ");
                paramList.add(longNumber + "!%");
                sql.append(" or org.FlongNumber in (Select FlongNumber FROM T_MBg_BgOrgUnit Where FID = ? ))");
                paramList.add(bgOrgUnitInfo.getId().toString());
            }
            if (!isOUSealUp) {
                sql.append(" AND org.FIsOUSealUp = 0 ");
            }
        }
        sql.append(" Order By FShowLevel");
        HashMap<String, String> rangeOrgs = new HashMap<String, String>();
        IRowSet rs = null;
        String orgUnitId = null;
        String nLongNumber2 = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
            while (rs.next()) {
                orgUnitId = rs.getString("FOrgUnitId");
                longNumber = rs.getString("FLongNumber");
                rangeOrgs.put(orgUnitId, longNumber);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        HashMap<String, String> notRangeOrgs = new HashMap<String, String>();
        BgOrgUnitInfo orgUnitInfo = null;
        if (bgOrgUnitColl != null && !bgOrgUnitColl.isEmpty()) {
            int in = bgOrgUnitColl.size();
            for (int i = 0; i < in; ++i) {
                orgUnitInfo = bgOrgUnitColl.get(i);
                orgUnitId = orgUnitInfo.getOrgUnitID();
                longNumber = orgUnitInfo.getLongNumber();
                if (rangeOrgs == null || rangeOrgs.keySet().contains(orgUnitInfo.getOrgUnitID())) continue;
                notRangeOrgs.put(orgUnitId, longNumber);
            }
        }
        if (notRangeOrgs != null && !notRangeOrgs.isEmpty()) {
            for (String nLongNumber2 : notRangeOrgs.values()) {
                Iterator iter = bgOrgUnitColl.iterator();
                while (iter.hasNext()) {
                    longNumber = ((BgOrgUnitInfo)iter.next()).getLongNumber();
                    if (rangeOrgs.containsValue(longNumber) || !longNumber.startsWith(nLongNumber2.concat("!"))) continue;
                    iter.remove();
                }
            }
            if (notRangeOrgs.containsKey(bgOrgUnitInfo.getOrgUnitID()) || !rangeOrgs.containsKey(bgOrgUnitInfo.getOrgUnitID())) {
                bgOrgUnitColl.clear();
            }
        }
        HashSet<String> permissionOrgUnits = new HashSet<String>();
        int in = bgOrgUnitColl.size();
        for (int i = 0; i < in; ++i) {
            permissionOrgUnits.add(bgOrgUnitColl.get(i).getOrgUnitID());
        }
        return permissionOrgUnits;
    }

    @Override
    public BgOrgUnitCollection _getDirectOrgUnits(Context ctx, String bgOrgViewId, BgOrgUnitInfo bgOrgUnitInfo, boolean isOUSealUp, boolean isNeedAddOrgRange) throws BOSException {
        if (StringUtils.isEmpty((String)bgOrgViewId)) {
            throw new BOSException("BgOrgViewId is null!");
        }
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> paramList = new ArrayList<Object>();
        sql.append("Select org.FID AS FID , org.FOrgUnitId AS FOrgUnitId, org.FNumber AS FNumber, org.FName_").append(ctx.getLocale()).append(" AS FName, org.FLongNumber AS FLongNumber, org.FLevel AS FLevel, org.FIsLeaf AS FIsLeaf,org.FParentId AS FparentId, org.FIsVirtual AS FIsVirtual, org.FSimpleName AS FSimpleName, org.FShowLevel AS FShowLevel FROM T_Mbg_BgOrgUnit org Where org.FViewId = ? ");
        paramList.add(bgOrgViewId);
        sql.append(" AND ( FParentId = ? ");
        paramList.add(bgOrgUnitInfo.getId().toString());
        String longNumber = bgOrgUnitInfo.getLongNumber();
        if (longNumber != null) {
            sql.append(" AND org.FLongNumber like ? ");
            paramList.add(longNumber + "!%");
            if (bgOrgUnitInfo.getLongNumber().indexOf("!") <= 0) {
                sql.append(" or org.FlongNumber in (Select FlongNumber FROM T_MBg_BgOrgUnit Where FID = ? )");
                paramList.add(bgOrgUnitInfo.getId().toString());
            }
            sql.append(" ) ");
        }
        if (!isOUSealUp) {
            sql.append(" AND org.FIsOUSealUp = 0 ");
        }
        if (isNeedAddOrgRange) {
            sql.append(" AND EXISTS (select top 1 * from T_PM_ORGRANGE range where range.ForgId = ? and range.FuserId=  ? and range.FType = ?)");
            paramList.add(bgOrgUnitInfo.getOrgUnitID());
            paramList.add(userPK.toString());
            paramList.add(10);
        }
        sql.append(" Order By FShowLevel");
        BgOrgUnitCollection col = new BgOrgUnitCollection();
        IRowSet rs = null;
        HashMap<String, BgOrgUnitInfo> orgMap = new HashMap<String, BgOrgUnitInfo>();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
            while (rs.next()) {
                BgOrgUnitInfo info = new BgOrgUnitInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                info.setOrgUnitID(rs.getString("FOrgUnitId"));
                info.setNumber(rs.getString("FNumber"));
                info.setName(rs.getString("FName"));
                info.setLongNumber(rs.getString("FLongNumber"));
                info.setLevel(rs.getInt("FLevel"));
                info.setIsLeaf(rs.getBoolean("FIsLeaf"));
                info.setIsVirtual(rs.getBoolean("FIsVirtual"));
                info.setSimpleName(rs.getString("FSimpleName"));
                info.setShowLevel(rs.getInt("FShowLevel"));
                String parentTmpId = rs.getString("FParentId");
                if (parentTmpId == null) {
                    info.setParent(null);
                } else {
                    BgOrgUnitInfo parentInfo = new BgOrgUnitInfo();
                    parentInfo.setId(BOSUuid.read((String)parentTmpId));
                    info.setParent(parentInfo);
                }
                orgMap.put(info.getOrgUnitID(), info);
                col.add(info);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        this.filterDirectOrgsByOrgRange(ctx, col, orgMap);
        return col;
    }

    private void filterDirectOrgsByOrgRange(Context ctx, BgOrgUnitCollection col, Map<String, BgOrgUnitInfo> orgMap) {
        HashSet<String> orgIds = new HashSet<String>(orgMap.keySet());
        if (ToolUtils.isNullList(orgIds) || !BgParamNHelper.isFilterByOrgRange((Context)ctx)) {
            return;
        }
        HashSet<String> outRangeList = new HashSet<String>(orgIds);
        this.filterOrgIdByOrgRange(ctx, orgIds);
        if (ToolUtils.isNullList(orgIds)) {
            col.clear();
            return;
        }
        outRangeList.removeAll(orgIds);
        for (String outRangeId : outRangeList) {
            if (this.hashChildInRange(outRangeId, orgIds, orgMap)) continue;
            col.remove(orgMap.get(outRangeId));
        }
    }

    private boolean hashChildInRange(String currOrgId, Set<String> orgIds, Map<String, BgOrgUnitInfo> orgMap) {
        BgOrgUnitInfo currInfo = orgMap.get(currOrgId);
        for (String orgId : orgIds) {
            BgOrgUnitInfo info = orgMap.get(orgId);
            if (!info.getLongNumber().contains(currInfo.getLongNumber().concat("!"))) continue;
            return true;
        }
        return false;
    }

    private Map<String, FullOrgUnitInfo> queryOrgInfo(Context ctx, String orgViewId, Set<String> _filtedQueryOrgUnitIds) throws BOSException {
        HashMap<String, FullOrgUnitInfo> orgMap = new HashMap<String, FullOrgUnitInfo>();
        if (StringUtils.isEmpty((String)orgViewId) || _filtedQueryOrgUnitIds == null) {
            return orgMap;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", _filtedQueryOrgUnitIds, CompareType.INCLUDE));
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        FullOrgUnitCollection col = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(evi);
        if (col != null && !col.isEmpty()) {
            for (int i = 0; i < col.size(); ++i) {
                orgMap.put(col.get(i).getId().toString(), col.get(i));
            }
        }
        return orgMap;
    }

    protected void copyArrayToSet(Set<String> set, String[] array) {
        if (array != null) {
            int in = array.length;
            for (int i = 0; i < in; ++i) {
                if (array[i] == null) continue;
                set.add(array[i].toString());
            }
        }
    }

    protected BgVersionCollection queryBgVersion(Context ctx, Set bgPeriodIds) throws BOSException, EASBizException {
        if (ctx == null || bgPeriodIds == null) {
            return new BgVersionCollection();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        if (!bgPeriodIds.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)bgPeriodIds, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        BgVersionCollection bgPeriodCol = BgVersionFactory.getLocalInstance((Context)ctx).getBgVersionCollection(view);
        return bgPeriodCol;
    }

    protected BgPeriodCollection queryBgPeriod(Context ctx, Set bgPeriodIds) throws BOSException, EASBizException {
        if (ctx == null || bgPeriodIds == null) {
            return new BgPeriodCollection();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("alias");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        if (!bgPeriodIds.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)bgPeriodIds, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        BgPeriodCollection bgPeriodCol = BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodCollection(view);
        return bgPeriodCol;
    }

    protected CurrencyCollection queryCurrency(Context ctx, Set currencyIds) throws BOSException, EASBizException {
        if (ctx == null || currencyIds == null) {
            return new CurrencyCollection();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        if (!currencyIds.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)currencyIds, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        CurrencyCollection currencyCol = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view);
        return currencyCol;
    }

    private Map<String, BgFormInfo> queryBgFormFromDB(Context ctx, EntityViewInfo view, Map<String, String> _bgFormAtt) throws BOSException, EASBizException {
        LinkedHashMap<String, BgFormInfo> _bgFormMap = new LinkedHashMap<String, BgFormInfo>();
        if (view == null || _bgFormAtt == null) {
            return _bgFormMap;
        }
        HashMap<String, String> _bgFormIdMap = new HashMap<String, String>();
        HashSet<String> bgFormIdSet = new HashSet<String>();
        BgFormInfo bgFormInfo = null;
        BgFormCollection bgFormColl = null;
        StringBuffer _key = null;
        try {
            bgFormColl = BgFormFactory.getLocalInstance(ctx).getBgFormCollection(view);
            ArrayList<String> ids = new ArrayList<String>();
            for (int i = 0; i < bgFormColl.size(); ++i) {
                ids.add(bgFormColl.get(i).getId().toString());
            }
            Map<String, String> bgformattach = this._queryHasAttach(ctx, ids);
            if (bgFormColl != null) {
                Iterator iter = bgFormColl.iterator();
                while (iter.hasNext()) {
                    bgFormInfo = (BgFormInfo)iter.next();
                    _key = this.getKey(bgFormInfo);
                    _bgFormMap.put(_key.toString(), bgFormInfo);
                    _bgFormIdMap.put(bgFormInfo.getId().toString(), _key.toString());
                    bgFormIdSet.add(bgFormInfo.getId().toString());
                    if (!bgformattach.containsKey(bgFormInfo.getId().toString())) continue;
                    _bgFormAtt.put(_key.toString(), bgformattach.get(bgFormInfo.getId().toString()));
                }
            }
            if (!_bgFormIdMap.isEmpty()) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("state");
                sic.add("bgFormId");
                sic.add("lastUpdateTime");
                viewInfo.getSelector().addObjectCollection((IObjectCollection)sic);
                viewInfo.setFilter(new FilterInfo());
                viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("bgFormId", bgFormIdSet, CompareType.INCLUDE));
                viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
                BgCourseCommentCollection colls = BgCourseCommentFactory.getLocalInstance(ctx).getBgCourseCommentCollection(viewInfo);
                BgCourseCommentInfo info = null;
                HashMap<String, Timestamp> formTimeMap = new HashMap<String, Timestamp>();
                for (int i = 0; i < colls.size(); ++i) {
                    info = colls.get(i);
                    if (formTimeMap.containsKey(info.getBgFormId())) {
                        if (((Timestamp)formTimeMap.get(info.getBgFormId())).getTime() >= info.getLastUpdateTime().getTime()) continue;
                        formTimeMap.put(info.getBgFormId(), info.getLastUpdateTime());
                        continue;
                    }
                    formTimeMap.put(info.getBgFormId(), info.getLastUpdateTime());
                }
                for (String key : formTimeMap.keySet()) {
                    if (!_bgFormIdMap.containsKey(key) || !_bgFormMap.containsKey(_bgFormIdMap.get(key))) continue;
                    ((BgFormInfo)_bgFormMap.get(_bgFormIdMap.get(key))).setTimestamp("lastCourseTime", (Timestamp)formTimeMap.get(key));
                }
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
            throw ex;
        }
        return _bgFormMap;
    }

    private StringBuffer getKey(BgFormInfo bgFormInfo) {
        StringBuffer key = new StringBuffer(bgFormInfo.getOrgUnit().getId().toString()).append("_").append(bgFormInfo.getBgTemplate().getId().toString()).append("_").append(bgFormInfo.getBgPeriod().getId().toString()).append("_").append(bgFormInfo.getCurrency().getId().toString()).append("_").append(bgFormInfo.getBgVersion().getId().toString());
        if (!bgFormInfo.getBgSpecialItems().isEmpty()) {
            key.append("_").append(bgFormInfo.getBgSpecialItems().get(0).getId().toString());
        } else {
            key.append("_").append("null");
        }
        return key;
    }

    private StringBuffer getKey(String orgID, String bgTemplateID, String bgPeriodID, String currencyID, String bgversionId) {
        StringBuffer key = new StringBuffer(orgID).append("_").append(bgTemplateID).append("_").append(bgPeriodID).append("_").append(currencyID).append("_").append(bgversionId);
        return key;
    }

    private StringBuffer getKey(String orgID, String bgTemplateID, String bgPeriodID, String currencyID, String bgversionId, String specialItemId) {
        StringBuffer key = new StringBuffer(orgID).append("_").append(bgTemplateID).append("_").append(bgPeriodID).append("_").append(currencyID).append("_").append(bgversionId).append("_").append(specialItemId);
        return key;
    }

    protected Map getKeyMap(Map<String, FullOrgUnitInfo> orgMap, Map<String, Map<String, BgTemplateInfo>> bgTemplateMap, BgPeriodCollection bgPeriodCol, CurrencyCollection currencyCol, BgVersionCollection bgVersionCol, Map<String, BgFormInfo> _bgFormMap) {
        HashMap<String, Object[]> keyMap = new HashMap<String, Object[]>();
        Boolean isEmpty = EmptyUtil.isEmpty(orgMap) || EmptyUtil.isEmpty(bgTemplateMap) || EmptyUtil.isEmpty((AbstractObjectCollection)bgVersionCol) || EmptyUtil.isEmpty((AbstractObjectCollection)bgPeriodCol) || EmptyUtil.isEmpty((AbstractObjectCollection)currencyCol);
        if (isEmpty.booleanValue()) {
            return keyMap;
        }
        Object[] tmpValue = null;
        String _orgId2 = null;
        Object _bgSchemeId = null;
        String _bgTemplateId = null;
        String tempKey2 = null;
        String specialItemId = null;
        StringBuffer _key = null;
        Map<String, BgTemplateInfo> _tmpTmMap = null;
        BgPeriodInfo bgPeriodInfo = null;
        CurrencyInfo currencyInfo = null;
        Object bgSchemeInfo = null;
        BgTemplateInfo templateInfo = null;
        BgVersionInfo bgVersionInfo = null;
        String[] mapkey = null;
        for (String _orgId2 : orgMap.keySet()) {
            for (Map.Entry<String, Map<String, BgTemplateInfo>> entry : bgTemplateMap.entrySet()) {
                _tmpTmMap = entry.getValue();
                for (Map.Entry<String, BgTemplateInfo> _entrytm : _tmpTmMap.entrySet()) {
                    mapkey = _entrytm.getKey().split(":");
                    _bgTemplateId = mapkey[1];
                    templateInfo = _entrytm.getValue();
                    if (!mapkey[0].equals(_orgId2)) continue;
                    int ips = bgPeriodCol.size();
                    for (int ip = 0; ip < ips; ++ip) {
                        bgPeriodInfo = bgPeriodCol.get(ip);
                        int ics = currencyCol.size();
                        for (int ic = 0; ic < ics; ++ic) {
                            currencyInfo = currencyCol.get(ic);
                            for (int i = 0; i < bgVersionCol.size(); ++i) {
                                bgVersionInfo = bgVersionCol.get(i);
                                boolean isExistForm = false;
                                for (String tempKey2 : _bgFormMap.keySet()) {
                                    BgFormInfo bgFormInfo = _bgFormMap.get(tempKey2);
                                    specialItemId = null;
                                    if (!bgFormInfo.getOrgUnit().getId().toString().equals(_orgId2)) continue;
                                    if (!bgFormInfo.getBgSpecialItems().isEmpty()) {
                                        specialItemId = bgFormInfo.getBgSpecialItems().get(0).getId().toString();
                                    }
                                    if (!bgFormInfo.getOrgUnit().getId().toString().equals(_orgId2) || !bgFormInfo.getBgTemplate().getId().toString().equals(_bgTemplateId) || !bgFormInfo.getBgPeriod().getId().toString().equals(bgPeriodInfo.getId().toString()) || !bgFormInfo.getBgVersion().getId().toString().equals(bgVersionInfo.getId().toString()) || !bgFormInfo.getCurrency().getId().toString().equals(currencyInfo.getId().toString())) continue;
                                    isExistForm = true;
                                    _key = this.getKey(_orgId2, _bgTemplateId, bgPeriodInfo.getId().toString(), currencyInfo.getId().toString(), bgVersionInfo.getId().toString(), specialItemId);
                                    tmpValue = new Object[]{bgSchemeInfo, templateInfo, bgPeriodInfo, currencyInfo, bgVersionInfo, orgMap.get(_orgId2)};
                                    keyMap.put(_key.toString(), tmpValue);
                                }
                                if (isExistForm) continue;
                                _key = this.getKey(_orgId2, _bgTemplateId, bgPeriodInfo.getId().toString(), currencyInfo.getId().toString(), bgVersionInfo.getId().toString(), specialItemId);
                                tmpValue = new Object[]{bgSchemeInfo, templateInfo, bgPeriodInfo, currencyInfo, bgVersionInfo, orgMap.get(_orgId2)};
                                keyMap.put(_key.toString(), tmpValue);
                            }
                        }
                    }
                }
            }
        }
        return keyMap;
    }

    protected void filterQuery(FilterInfo filterInfo) {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Set<String> queryImmOrgUnit(Context ctx, String orgLongNumber, String orgViewId, int level) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgLongNumber)) return new HashSet<String>();
        if (StringUtils.isEmpty((String)orgViewId)) {
            return new HashSet<String>();
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        HashSet<String> orgUnitSet = new HashSet<String>();
        String _orgUnitId = null;
        String sql = "select FOrgUnitId from T_MBG_BGORGUNIT where  fviewid = ? and FLongnumber like ? " + (level > 0 ? "and FLevel = ?" : "");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, orgViewId);
            pstmt.setString(2, orgLongNumber + "!%");
            if (level > 0) {
                pstmt.setInt(3, level);
            }
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _orgUnitId = rst.getString(1);
                orgUnitSet.add(_orgUnitId);
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return orgUnitSet;
    }

    protected Map queryBgSchemeInfo(Context ctx, String userId, Set queryOrgUnitIds, Set bgSchemeRootIds, boolean _isBgPermissionUsed) throws BOSException, EASBizException {
        if (ctx == null || queryOrgUnitIds == null || bgSchemeRootIds == null) {
            return new HashMap();
        }
        HashMap _bgSchemeMap = new HashMap();
        Map<String, BgSchemeInfo> _tmpMap = null;
        String _orgId = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("dateFrom");
        sic.add("dateTo");
        sic.add("isFormal");
        sic.add("period");
        sic.add("state");
        sic.add("isSubmitByScheme");
        sic.add("isFiling");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        if (!queryOrgUnitIds.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("orgunit.id", (Object)queryOrgUnitIds, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)bgSchemeRootIds, CompareType.INCLUDE));
        view.setFilter(filter);
        BgSchemeCollection bgSchemeCol = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeCollection(view);
        BgSchemeInfo info = null;
        int j = bgSchemeCol.size();
        for (int i = 0; i < j; ++i) {
            info = bgSchemeCol.get(i);
            _orgId = info.getOrgUnit().getId().toString();
            if (_bgSchemeMap.containsKey(_orgId)) {
                _tmpMap = (Map)_bgSchemeMap.get(_orgId);
            } else {
                _tmpMap = new HashMap();
                _bgSchemeMap.put(_orgId, _tmpMap);
            }
            _tmpMap.put(info.getId().toString(), info);
        }
        return _bgSchemeMap;
    }

    protected Map<String, Map<String, BgTemplateInfo>> queryBgTemplateInfo(Context ctx, String userId, String currentOrgUnitID, String tmpOrgTable, Set<String> bgSchemeRootIds, Set<String> bgTemplateIds, boolean isPermission, boolean isContainForbidden, Map<String, BgSchemeInfo> bgSchemeMap, BgTypeInfo bgtypeInfo) throws BOSException, EASBizException {
        if (ctx == null || userId == null || bgSchemeRootIds == null || bgSchemeRootIds.isEmpty() || tmpOrgTable == null || bgTemplateIds == null) {
            return new HashMap<String, Map<String, BgTemplateInfo>>();
        }
        HashMap<String, Map<String, BgTemplateInfo>> _bgTemplateMap = new HashMap<String, Map<String, BgTemplateInfo>>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Map<String, BgTemplateInfo> tmpMap = null;
        BgTemplateInfo templateInfo = null;
        BgTypeInfo typeInfo = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        String _schemeId = null;
        String _tempId = null;
        String _tempNumber = null;
        String _tempName = null;
        String _roodID = null;
        String _bgTypeID = null;
        String _bgTypeNumber = null;
        String _bgTypeName = null;
        String _formType = null;
        String _templateStatus = null;
        String _bgOrgUnitId = null;
        String _tempNodeOrgUnitId = null;
        StringBuffer sql = this.queryBgTemplateSql(ctx);
        sql.append(" and n.FOrgUnitId IN (select FID from " + tmpOrgTable + ")");
        if (!bgSchemeRootIds.isEmpty()) {
            sql.append(" and t.FBgSchemeId IN ( ");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)bgSchemeRootIds.size());
            sql.append(" )");
            _tmpList.addAll(bgSchemeRootIds);
        }
        if (!bgTemplateIds.isEmpty()) {
            sql.append(" and t.frootid in ( select frootid from T_MBg_BgTemplate where fid in (");
            for (String object : bgTemplateIds) {
                sql.append("'").append(object.toString()).append("',");
            }
            sql = sql.deleteCharAt(sql.lastIndexOf(","));
            sql.append("))");
        } else if (!isContainForbidden) {
            sql.append(" and t.FTemplateStatus = 0 ");
        }
        if (bgtypeInfo != null) {
            sql.append(" and t.FBgTypeID = '" + bgtypeInfo.getId().toString() + "' ");
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            MbgSqlHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _schemeId = rst.getString(1);
                _tempId = rst.getString(2);
                _tempName = rst.getString(3);
                _tempNumber = rst.getString(4);
                _formType = rst.getString(5);
                _templateStatus = rst.getString(6);
                _roodID = rst.getString(7);
                _bgTypeID = rst.getString(8);
                _bgTypeNumber = rst.getString(9);
                _bgTypeName = rst.getString(10);
                _bgOrgUnitId = rst.getString(11);
                _tempNodeOrgUnitId = rst.getString(12);
                if (_bgTemplateMap.containsKey(_schemeId)) {
                    tmpMap = (Map)_bgTemplateMap.get(_schemeId);
                } else {
                    tmpMap = new HashMap();
                    _bgTemplateMap.put(_schemeId, tmpMap);
                }
                templateInfo = new BgTemplateInfo();
                templateInfo.setId(BOSUuid.read((String)_tempId));
                templateInfo.setName(_tempName);
                templateInfo.setNumber(_tempNumber);
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                fullOrgUnitInfo.setId(BOSUuid.read((String)_bgOrgUnitId));
                templateInfo.setOrgUnit(fullOrgUnitInfo);
                if (!StringUtils.isEmpty((String)_formType)) {
                    templateInfo.setFormType(BgTemFormTypeEnum.getEnum(Integer.valueOf(_formType)));
                }
                if (!StringUtils.isEmpty((String)_templateStatus)) {
                    templateInfo.setTemplateStatus(BgTemplateStatusEnum.getEnum(Integer.valueOf(_templateStatus)));
                }
                typeInfo = new BgTypeInfo();
                if (!StringUtils.isEmpty((String)_bgTypeID)) {
                    typeInfo.setId(BOSUuid.read((String)_bgTypeID));
                    typeInfo.setName(_bgTypeName);
                    typeInfo.setNumber(_bgTypeNumber);
                }
                templateInfo.setBgType(typeInfo);
                tmpMap.put(_tempNodeOrgUnitId + ":" + _tempId, templateInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        HashSet<String> _bgTemplateIds = new HashSet<String>();
        HashSet<String> _hasPermissionTemplateIds = new HashSet<String>();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        BgTemplateCollection col = null;
        for (String bgSchemeId : _bgTemplateMap.keySet()) {
            tmpMap = (HashMap)_bgTemplateMap.get(bgSchemeId);
            _bgTemplateIds.clear();
            _hasPermissionTemplateIds.clear();
            for (BgTemplateInfo t : tmpMap.values()) {
                _bgTemplateIds.add(t.getId().toString());
            }
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", _bgTemplateIds, CompareType.INCLUDE));
            MbgPermissionHelper.addBgTemplatePermission(ctx, bgSchemeMap.get(bgSchemeId).getBgSchemeType().getSchemeType(), userId, evi.getFilter(), bgSchemeId, true);
            col = BgTemplateFactory.getLocalInstance(ctx).getBgTemplateCollection(evi);
            for (int i = 0; i < col.size(); ++i) {
                _hasPermissionTemplateIds.add(col.get(i).getId().toString());
            }
            _bgTemplateIds.clear();
            _bgTemplateIds.addAll(tmpMap.keySet());
            for (String id : _bgTemplateIds) {
                if (_hasPermissionTemplateIds.contains(((BgTemplateInfo)tmpMap.get(id)).getId().toString())) continue;
                tmpMap.remove(id);
            }
        }
        return _bgTemplateMap;
    }

    protected StringBuffer queryBgTemplateSql(Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FBgSchemeId, n.FBgTemplateId, t.FName, t.FNumber,t.FFormType,t.FTemplateStatus , t.frootid , y.FID, y.FNumber, y.FName_").append(ctx.getLocale()).append(", t.FOrgUnitId , n.FOrgUnitId from T_MBG_BgTemplateNode n ").append(" left join T_MBg_BgTemplate t on n.FBgTemplateId = t.FID").append(" left join T_MBg_BgType y on t.FBgTypeId = y.FID").append(" where (y.FID IS NULL or y.FID <> 'bgMAAAAKIcA7rHKd') ").append(" and t.FISREADONLY = 0");
        return sql;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<String[]> queryBgPeriodIds(Context ctx, Set<String> bgPeriodIds) throws BOSException, EASBizException {
        if (ctx == null) return new ArrayList<String[]>();
        if (bgPeriodIds == null) {
            return new ArrayList<String[]>();
        }
        int index = 0;
        int batchSize = 50;
        int size = bgPeriodIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<String> _bgPeriodIds = new ArrayList<String>();
        ArrayList<String[]> _bgPeriods = new ArrayList<String[]>();
        _bgPeriodIds.addAll(bgPeriodIds);
        String _id = null;
        String _number = null;
        String[] _strs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FName_").append(ctx.getLocale()).append(", FNumber from T_MBg_BgPeriod where FID IN (");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?) order by FNumber");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                for (int x = 1; x <= batchSize; ++x, ++pos) {
                    if (pos < size) {
                        pstmt.setString(x, (String)_bgPeriodIds.get(pos));
                        continue;
                    }
                    pstmt.setString(x, "#");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _id = rst.getString(1);
                    String _name = rst.getString(2);
                    _number = rst.getString(3);
                    _strs = new String[]{_id, _name, _number};
                    _bgPeriods.add(_strs);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return _bgPeriods;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<String[]> queryCurrencyIds(Context ctx, Set<String> currencyIds) throws BOSException, EASBizException {
        if (ctx == null) return new ArrayList<String[]>();
        if (currencyIds == null) {
            return new ArrayList<String[]>();
        }
        int index = 0;
        int batchSize = 10;
        int size = currencyIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<String> _currencyIds = new ArrayList<String>();
        ArrayList<String[]> _currencys = new ArrayList<String[]>();
        _currencyIds.addAll(currencyIds);
        String _id = null;
        String _number = null;
        String[] _strs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FName_").append(ctx.getLocale()).append(", FNumber from T_BD_Currency where FID IN (");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?) order by FNumber");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                for (int x = 1; x <= batchSize; ++x, ++pos) {
                    if (pos < size) {
                        pstmt.setString(x, (String)_currencyIds.get(pos));
                        continue;
                    }
                    pstmt.setString(x, "#");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _id = rst.getString(1);
                    String _name = rst.getString(2);
                    _number = rst.getString(3);
                    _strs = new String[]{_id, _name, _number};
                    _currencys.add(_strs);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return _currencys;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map<Integer, String> _loadColorScheme(Context ctx) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Integer _state = null;
        String _color = null;
        HashMap<Integer, String> colorScheme = new HashMap<Integer, String>();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FState, FColor from T_MBg_BgColorScheme");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _state = new Integer(rst.getInt(1));
                _color = rst.getString(2);
                colorScheme.put(_state, _color);
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return colorScheme;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _saveColorScheme(Context ctx, Map colorScheme) throws BOSException, EASBizException {
        if (colorScheme == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Map.Entry _entry2222222 = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("delete from T_MBg_BgColorScheme");
            pstmt.executeUpdate();
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement("insert into T_MBg_BgColorScheme (FState, FColor) values(?, ?)");
            for (Map.Entry _entry2222222 : colorScheme.entrySet()) {
                pstmt.setInt(1, (Integer)_entry2222222.getKey());
                pstmt.setString(2, (String)_entry2222222.getValue());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    protected IPermission getPermissionInterface(Context ctx) throws BOSException {
        return PermissionFactory.getLocalInstance((Context)ctx);
    }

    protected boolean verifyPermission(Context ctx, String userId, String orgUnitId) throws BOSException, EASBizException {
        return this.getPermissionInterface(ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(orgUnitId), this.getPermissionNum());
    }

    protected String getPermissionNum() {
        return PERMISSION_STR;
    }

    protected Set<String> verifyPermission(Context ctx, String ctrlUnitId, String userId, Set<String> orgUnitIdSet) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)userId) || orgUnitIdSet == null || orgUnitIdSet.isEmpty()) {
            return new HashSet<String>();
        }
        FullOrgUnitInfo _orgUnitInfo = null;
        FullOrgUnitCollection _orgUnitCol = null;
        HashSet<String> _orgUnitIdSet = new HashSet<String>();
        _orgUnitCol = this.getPermissionInterface(ctx).getAuthorizedOrgOfIncludeSubCU((IObjectPK)new ObjectUuidPK(ctrlUnitId), (IObjectPK)new ObjectUuidPK(userId), OrgType.CostCenter, null, this.getPermissionNum());
        if (_orgUnitCol != null && !_orgUnitCol.isEmpty()) {
            int in = _orgUnitCol.size();
            for (int i = 0; i < in; ++i) {
                _orgUnitInfo = _orgUnitCol.get(i);
                _orgUnitIdSet.add(_orgUnitInfo.getId().toString());
            }
            orgUnitIdSet.retainAll(_orgUnitIdSet);
        } else {
            orgUnitIdSet.clear();
        }
        return orgUnitIdSet;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String _loadCause(Context ctx, String bgFormId, String formula) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgFormId)) return null;
        if (StringUtils.isEmpty((String)formula)) {
            return null;
        }
        byte[] _byte = null;
        String _cause = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FCause from T_MBg_BgCourseCause where FBgFormId = ? and FFormula = ?");
            pstmt.setString(1, bgFormId);
            pstmt.setString(2, formula);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                _byte = MbgSqlHelper.getBytes((ResultSet)rst, (int)1);
                _cause = (String)BgAnalyseHelper.getObject(_byte);
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
                catch (IOException ex3) {
                    logger.error((Object)ex3);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex3.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return _cause;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _saveCause(Context ctx, String userId, String bgFormId, String formula, String cause) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgFormId)) return;
        if (StringUtils.isEmpty((String)formula)) {
            return;
        }
        byte[] _byte = null;
        String _userId = null;
        Timestamp _Timestamp = new Timestamp(System.currentTimeMillis());
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        _userId = StringUtils.isEmpty((String)userId) ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : userId;
        _byte = BgAnalyseHelper.getBytes(cause);
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("SELECT FID FROM T_MBg_BgCourseCause WHERE FBgFormId = ? and FFormula = ?");
            pstmt.setString(1, bgFormId);
            pstmt.setString(2, formula);
            rst = pstmt.executeQuery();
            boolean isExists = rst.next();
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!isExists) {
                pstmt = conn.prepareStatement("INSERT INTO T_MBg_BgCourseCause(FID, FBgFormID, FFormula, FCreatorID, FCreatorTime, FLastUpdateUserId, FLastUpdateTime) (select FID, ?, FFormula, '" + _userId + "', NOW(), '" + _userId + "', NOW() from T_MBg_BgData bgdata where bgdata." + BgViewServerHelper.getBgDataFilterByBgFormId() + " and bgdata.FFormula = ?)");
                pstmt.setString(1, bgFormId);
                pstmt.setString(2, bgFormId);
                pstmt.setString(3, formula);
                pstmt.executeUpdate();
                SQLUtils.cleanup((Statement)pstmt);
            }
            pstmt = conn.prepareStatement("update T_MBg_BgCourseCause set FCause = ?, FLastUpdateUserID = ?, FLastUpdateTime = ? where FBgFormId = ? and FFormula = ?");
            pstmt.setBytes(1, _byte);
            pstmt.setString(2, _userId);
            pstmt.setTimestamp(3, _Timestamp);
            pstmt.setString(4, bgFormId);
            pstmt.setString(5, formula);
            pstmt.executeUpdate();
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _queryOrgInfo(Context ctx, Map parameter) throws BOSException, EASBizException {
        int in;
        if (parameter == null) return new HashMap();
        if (parameter.isEmpty()) {
            return new HashMap();
        }
        boolean _isBgPermissionUsed = false;
        String bgOrgViewId = (String)parameter.get("CURR_ORGUNIT_VIEW_ID");
        String CURR_USER_ID = (String)parameter.get("CURR_USER_ID");
        String CURR_CTRLORGUNIT_ID = (String)parameter.get("CURR_CTRLORGUNIT_ID");
        String selectBgOrgId = (String)parameter.get("SEL_ORGUNIT_ID");
        Integer SEL_ORGUNIT_TYPE = (Integer)parameter.get("SEL_ORGUNIT_TYPE");
        String[] SEL_BGSCHEME_IDS = (String[])parameter.get("SEL_BGSCHEME_IDS");
        String[] SEL_BGPERIOD_IDS = (String[])parameter.get("SEL_BGPERIOD_IDS");
        String[] SEL_CURRENCY_IDS = (String[])parameter.get("SEL_CURRENCY_IDS");
        String[] SEL_BGTEMPLATE_IDS = (String[])parameter.get("SEL_BGTEMPLATE_IDS");
        String[] SEL_BGVERSION_IDS = (String[])parameter.get("SEL_BGVERSION_IDS");
        int[] processType = (int[])parameter.get("SEL_PROCESSTYPE");
        boolean isContainForBidden = (Boolean)parameter.get("SEL_FORBIDDEN_TEMPLATE");
        BgOrgUnitInfo bgOrgUnitInfo = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitInfo("select id, longNumber, orgUnitID, level where id = '" + selectBgOrgId + "'");
        Set<Object> _queryOrgUnitIds = new HashSet<String>();
        if (SEL_ORGUNIT_TYPE == 1) {
            if (this.verifyPermission(ctx, CURR_USER_ID, bgOrgUnitInfo.getOrgUnitID())) {
                _queryOrgUnitIds.add(bgOrgUnitInfo.getOrgUnitID());
            }
        } else if (SEL_ORGUNIT_TYPE == 2) {
            _queryOrgUnitIds = this.queryImmOrgUnit(ctx, bgOrgUnitInfo.getLongNumber(), bgOrgViewId, bgOrgUnitInfo.getLevel() + 1);
        } else if (SEL_ORGUNIT_TYPE == 3) {
            _queryOrgUnitIds = this.queryImmOrgUnit(ctx, bgOrgUnitInfo.getLongNumber(), bgOrgViewId, -1);
        }
        HashSet<String> leafOrgIds = new HashSet<String>();
        Set<Object> permissionOrgUnits = new HashSet();
        BgOrgUnitCollection orgUnitColl = null;
        if (SEL_ORGUNIT_TYPE == 2) {
            orgUnitColl = this.getDirectOrgUnits(ctx, bgOrgViewId, bgOrgUnitInfo, false, true);
        } else if (SEL_ORGUNIT_TYPE == 3) {
            permissionOrgUnits = this.getAllOrgUnits(ctx, bgOrgViewId, bgOrgUnitInfo, false, true);
        }
        if (orgUnitColl != null && !orgUnitColl.isEmpty()) {
            for (int i = 0; i < orgUnitColl.size(); ++i) {
                permissionOrgUnits.add(orgUnitColl.get(i).getOrgUnitID().toString());
                if (!orgUnitColl.get(i).isIsLeaf()) continue;
                leafOrgIds.add(orgUnitColl.get(i).getOrgUnitID().toString());
            }
        }
        HashSet<String> _filtedQueryOrgUnitIds = new HashSet<String>();
        for (String string : _queryOrgUnitIds) {
            if (!permissionOrgUnits.contains(string)) continue;
            _filtedQueryOrgUnitIds.add(string);
        }
        if (bgOrgUnitInfo.getLevel() != 1) {
            _filtedQueryOrgUnitIds.add(bgOrgUnitInfo.getOrgUnitID());
        }
        this.filterOrgIdByOrgRange(ctx, _filtedQueryOrgUnitIds);
        UserInfo userinfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        Set set = MbgPermissionFactory.getLocalInstance(ctx).getBgOrgUnitPermission(null, userinfo.getId().toString(), SEL_BGSCHEME_IDS.length > 0 ? SEL_BGSCHEME_IDS[0] : null);
        if (!set.isEmpty()) {
            Iterator iterator = _filtedQueryOrgUnitIds.iterator();
            while (iterator.hasNext()) {
                String orgid = (String)iterator.next();
                if (set.contains(orgid)) continue;
                iterator.remove();
            }
        }
        if (_filtedQueryOrgUnitIds.isEmpty()) {
            return new HashMap();
        }
        HashMap<String, Map<Integer, BigDecimal>> _dataMap = new HashMap<String, Map<Integer, BigDecimal>>();
        Map<Integer, BigDecimal> _tmpMap = null;
        int _state = 0;
        int _count = 0;
        boolean formSum = false;
        Object var29_31 = null;
        String _id2222222 = null;
        String _orgUnitId = null;
        String _bgPeriodId = null;
        String _bgVersionId = null;
        String _templateId = null;
        String org_period_version = null;
        ArrayList<Object> _tmpList = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        StringBuffer tempSql = new StringBuffer();
        sql.append("select f.FOrgUnitId, f.FBgPeriodId,f.Fbgversionid, f.FState, t.fid, count(f.FID) from T_MBg_BgForm f left join T_MBg_BgScheme s on f.Fbgschemeid = s.fid ").append("left join T_MBg_BgTemplate t on f.FBgTemplateId = t.FID ").append("where (t.FBgTypeId is null or t.fbgtypeid <> 'bgMAAAAKIcA7rHKd') ").append(" and t.FIsReadOnly = 0").append(" and f.FOrgUnitId IN (");
        for (Object e : _filtedQueryOrgUnitIds) {
            if (e == null) continue;
            sql.append("?,");
            _tmpList.add(e.toString());
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(") ");
        if (!isContainForBidden) {
            sql.append(" and t.FTemplateStatus = 0 ");
        }
        if (SEL_BGSCHEME_IDS != null && SEL_BGSCHEME_IDS.length > 0) {
            sql.append(" AND s.FId IN (");
            in = SEL_BGSCHEME_IDS.length;
            for (int i = 0; i < in; ++i) {
                _id2222222 = SEL_BGSCHEME_IDS[i];
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (SEL_BGTEMPLATE_IDS != null && SEL_BGTEMPLATE_IDS.length > 0) {
            sql.append(" AND t.FRootID IN (");
            in = SEL_BGTEMPLATE_IDS.length;
            for (int i = 0; i < in; ++i) {
                _id2222222 = SEL_BGTEMPLATE_IDS[i];
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (SEL_BGPERIOD_IDS != null && SEL_BGPERIOD_IDS.length > 0) {
            sql.append(" AND f.FBgPeriodId IN (");
            for (String _id2222222 : SEL_BGPERIOD_IDS) {
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (SEL_CURRENCY_IDS != null && SEL_CURRENCY_IDS.length > 0) {
            sql.append(" AND f.FCurrencyId IN (");
            in = SEL_CURRENCY_IDS.length;
            for (int i = 0; i < in; ++i) {
                _id2222222 = SEL_CURRENCY_IDS[i];
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (SEL_CURRENCY_IDS != null && SEL_CURRENCY_IDS.length > 0) {
            sql.append(" AND f.Fbgversionid IN (");
            for (String _id2222222 : SEL_BGVERSION_IDS) {
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (processType != null && processType.length > 0) {
            sql.append(" AND f.FProcessType IN (");
            in = processType.length;
            for (int i = 0; i < in; ++i) {
                int type = processType[i];
                sql.append("?,");
                _tmpList.add(type);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        sql.append(" group by f.FOrgUnitId,f.FBgPeriodId,f.Fbgversionid, f.FState,t.fid");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Set<String> temp = null;
        HashMap formCount = new HashMap();
        HashMap templateCount = new HashMap();
        try {
            this.queryOrgCount(ctx, CURR_USER_ID, _dataMap, _filtedQueryOrgUnitIds, SEL_BGSCHEME_IDS, SEL_BGTEMPLATE_IDS, _isBgPermissionUsed, processType[0], leafOrgIds, isContainForBidden);
            conn = this.getConnection(ctx);
            tempSql.setLength(0);
            pstmt = conn.prepareStatement(sql.toString());
            MbgSqlHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _orgUnitId = rst.getString(1);
                _bgPeriodId = rst.getString(2);
                _bgVersionId = rst.getString(3);
                _state = rst.getInt(4);
                _templateId = rst.getString(5);
                _count = rst.getInt(6);
                org_period_version = _orgUnitId + ";" + _bgPeriodId + ";" + _bgVersionId;
                if (_state == 4 || _state == 35 || _state == 15) continue;
                if (_dataMap.containsKey(org_period_version)) {
                    _tmpMap = (Map)_dataMap.get(org_period_version);
                } else {
                    _tmpMap = new HashMap();
                    _dataMap.put(org_period_version, _tmpMap);
                }
                if (_tmpMap.containsKey(new Integer(_state))) {
                    _tmpMap.put(new Integer(_state), ((BigDecimal)_tmpMap.get(new Integer(_state))).add(new BigDecimal(_count)));
                } else {
                    _tmpMap.put(new Integer(_state), new BigDecimal(_count));
                }
                if (_tmpMap.containsKey(new Integer(10000))) {
                    temp = (Set)_tmpMap.get(new Integer(10000));
                } else {
                    temp = new HashSet();
                    _tmpMap.put(new Integer(10000), (BigDecimal)((Object)temp));
                }
                temp.add(_templateId);
                if (_tmpMap.containsKey(new Integer(10001))) {
                    _tmpMap.put(new Integer(10001), ((BigDecimal)_tmpMap.get(10001)).add(new BigDecimal(_count)));
                    continue;
                }
                _tmpMap.put(new Integer(10001), new BigDecimal(_count));
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return _dataMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void queryOrgCount(Context ctx, String userId, Map queryMap, Set orgUnitIds, String[] bgSchemeRootIds, String[] bgTemplateRootIDS, boolean isBgPermissionUsed, int processType, Set<String> leafOrgIds, boolean isContainForBidden) throws BOSException, EASBizException {
        if (ctx == null) {
            return;
        }
        HashSet<String> bgTemplateIds = new HashSet<String>();
        if (bgTemplateRootIDS != null && bgTemplateRootIDS.length > 0) {
            bgTemplateIds.addAll(Arrays.asList(bgTemplateRootIDS));
        }
        HashSet<String> bgSchemeIds = new HashSet<String>(Arrays.asList(bgSchemeRootIds));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo _filter = new FilterInfo();
        _filter.getFilterItems().add(new FilterItemInfo("id", bgSchemeIds, CompareType.INCLUDE));
        view.setFilter(_filter);
        view.getSelector().add("orgUnit.id");
        view.getSelector().add("bgSchemeType.schemeType");
        BgSchemeCollection bgSchemeCollection = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeCollection(view);
        HashSet<String> hadPerTemplateIds = new HashSet<String>();
        for (int i = 0; i < bgSchemeCollection.size(); ++i) {
            view = new EntityViewInfo();
            view.setSelector(new SelectorItemCollection());
            view.getSelector().add("id");
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeCollection.get(i).getId().toString()));
            MbgPermissionHelper.addBgTemplatePermission(ctx, bgSchemeCollection.get(i).getBgSchemeType().getSchemeType(), userId, view.getFilter(), bgSchemeCollection.get(i).getId().toString(), false);
            BgTemplateCollection col = BgTemplateFactory.getLocalInstance(ctx).getBgTemplateCollection(view);
            for (int c = 0; c < col.size(); ++c) {
                hadPerTemplateIds.add(col.get(c).getId().toString());
            }
        }
        if (bgTemplateIds.isEmpty()) {
            bgTemplateIds.addAll(hadPerTemplateIds);
        } else {
            bgTemplateIds.retainAll(hadPerTemplateIds);
        }
        bgTemplateRootIDS = bgTemplateIds.toArray(new String[0]);
        int _count = 0;
        int formSum = 0;
        Integer _state = new Integer(100);
        String _rootId2222222 = null;
        String _orgUnitId2222222 = null;
        Map<Integer, BigDecimal> _tmpMap = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select n.FOrgUnitId, count(n.fid) from T_MBg_BgTemplateNode n ").append("left join T_MBg_BgTemplate t on n.FBgTemplateId = t.FID ").append("where (t.FBgTypeId is null or t.fbgtypeid <> 'bgMAAAAKIcA7rHKd') ").append(" and t.FOrgUnitId <> n.FOrgUnitId ").append(" and t.FIsReadOnly = 0");
        if (!isContainForBidden) {
            sql.append(" and t.FTemplateStatus = 0 ");
        }
        if (orgUnitIds != null && !orgUnitIds.isEmpty()) {
            sql.append(" and n.FOrgUnitId IN (");
            for (String _orgUnitId2222222 : orgUnitIds) {
                sql.append("?,");
                _tmpList.add(_orgUnitId2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (bgSchemeRootIds != null && bgSchemeRootIds.length > 0) {
            sql.append(" AND t.FBgSchemeId IN (");
            for (String _rootId2222222 : bgSchemeRootIds) {
                sql.append("?,");
                _tmpList.add(_rootId2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (bgTemplateRootIDS != null && bgTemplateRootIDS.length > 0) {
            sql.append(" AND t.FRootID IN (");
            for (String _rootId2222222 : bgTemplateRootIDS) {
                sql.append("?,");
                _tmpList.add(_rootId2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        sql.append(" group by n.FOrgUnitId");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            MbgSqlHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _orgUnitId2222222 = rst.getString(1);
                _count = rst.getInt(2);
                if (DimensionCommonHelper.isDecompose(BgProcessEnum.getEnum(processType)) && leafOrgIds.contains(_orgUnitId2222222)) {
                    _count = 0;
                }
                formSum = 0;
                if (queryMap.containsKey(_orgUnitId2222222)) {
                    _tmpMap = (Map)queryMap.get(_orgUnitId2222222);
                    formSum = ((BigDecimal)_tmpMap.get(new Integer(100))).intValue();
                } else {
                    _tmpMap = new HashMap();
                    queryMap.put(_orgUnitId2222222, _tmpMap);
                }
                _tmpMap.put(new Integer(100), new BigDecimal(formSum += _count));
                if (queryMap.containsKey(_orgUnitId2222222)) {
                    _tmpMap = (Map)queryMap.get(_orgUnitId2222222);
                } else {
                    _tmpMap = new HashMap();
                    queryMap.put(_orgUnitId2222222, _tmpMap);
                }
                _tmpMap.put(_state, new BigDecimal(_count));
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _querySchemeInfo(Context ctx, Map parameter) throws BOSException, EASBizException {
        int in;
        if (parameter == null) return new HashMap();
        if (parameter.isEmpty()) {
            return new HashMap();
        }
        boolean _isBgPermissionUsed = false;
        String bgOrgViewId = (String)parameter.get("CURR_ORGUNIT_VIEW_ID");
        String CURR_USER_ID = (String)parameter.get("CURR_USER_ID");
        String CURR_CTRLORGUNIT_ID = (String)parameter.get("CURR_CTRLORGUNIT_ID");
        String selectBgOrgId = (String)parameter.get("SEL_ORGUNIT_ID");
        Integer SEL_ORGUNIT_TYPE = (Integer)parameter.get("SEL_ORGUNIT_TYPE");
        String[] SEL_BGSCHEME_IDS = (String[])parameter.get("SEL_BGSCHEME_IDS");
        String[] SEL_BGPERIOD_IDS = (String[])parameter.get("SEL_BGPERIOD_IDS");
        String[] SEL_CURRENCY_IDS = (String[])parameter.get("SEL_CURRENCY_IDS");
        String[] SEL_BGTEMPLATE_IDS = (String[])parameter.get("SEL_BGTEMPLATE_IDS");
        String[] SEL_BGVERSION_IDS = (String[])parameter.get("SEL_BGVERSION_IDS");
        int[] processType = (int[])parameter.get("SEL_PROCESSTYPE");
        boolean isContainForBidden = (Boolean)parameter.get("SEL_FORBIDDEN_TEMPLATE");
        BgOrgUnitInfo bgOrgUnitInfo = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitInfo("select id, longNumber, orgUnitID, level where id = '" + selectBgOrgId + "'");
        Set<Object> _queryOrgUnitIds = new HashSet<String>();
        if (SEL_ORGUNIT_TYPE == 1) {
            if (this.verifyPermission(ctx, CURR_USER_ID, bgOrgUnitInfo.getOrgUnitID())) {
                _queryOrgUnitIds.add(bgOrgUnitInfo.getOrgUnitID());
            }
        } else if (SEL_ORGUNIT_TYPE == 2) {
            _queryOrgUnitIds = this.queryImmOrgUnit(ctx, bgOrgUnitInfo.getLongNumber(), bgOrgViewId, bgOrgUnitInfo.getLevel() + 1);
        } else if (SEL_ORGUNIT_TYPE == 3) {
            _queryOrgUnitIds = this.queryImmOrgUnit(ctx, bgOrgUnitInfo.getLongNumber(), bgOrgViewId, -1);
        }
        HashSet<String> leafOrgIds = new HashSet<String>();
        Set<Object> permissionOrgUnits = new HashSet();
        BgOrgUnitCollection orgUnitColl = null;
        if (SEL_ORGUNIT_TYPE == 2) {
            orgUnitColl = this.getDirectOrgUnits(ctx, bgOrgViewId, bgOrgUnitInfo, false, true);
        } else if (SEL_ORGUNIT_TYPE == 3) {
            permissionOrgUnits = this.getAllOrgUnits(ctx, bgOrgViewId, bgOrgUnitInfo, false, true);
        }
        if (orgUnitColl != null && !orgUnitColl.isEmpty()) {
            for (int i = 0; i < orgUnitColl.size(); ++i) {
                permissionOrgUnits.add(orgUnitColl.get(i).getOrgUnitID().toString());
            }
        }
        HashSet<String> _filtedQueryOrgUnitIds = new HashSet<String>();
        for (String string : _queryOrgUnitIds) {
            if (!permissionOrgUnits.contains(string)) continue;
            _filtedQueryOrgUnitIds.add(string);
        }
        _filtedQueryOrgUnitIds.add(bgOrgUnitInfo.getOrgUnitID());
        UserInfo userinfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        Set set = MbgPermissionFactory.getLocalInstance(ctx).getBgOrgUnitPermission(null, userinfo.getId().toString(), SEL_BGSCHEME_IDS.length > 0 ? SEL_BGSCHEME_IDS[0] : null);
        if (!set.isEmpty()) {
            Iterator iterator = _filtedQueryOrgUnitIds.iterator();
            while (iterator.hasNext()) {
                String orgid = (String)iterator.next();
                if (set.contains(orgid)) continue;
                iterator.remove();
            }
        }
        if (_filtedQueryOrgUnitIds.isEmpty()) {
            return new HashMap();
        }
        _queryOrgUnitIds = _filtedQueryOrgUnitIds;
        if (!(parameter.get("SEL_ORGS") instanceof String[])) return null;
        String[] orgIds = (String[])parameter.get("SEL_ORGS");
        if (orgIds.length > 0) {
            _queryOrgUnitIds.retainAll(Arrays.asList(orgIds));
        }
        if (SEL_BGSCHEME_IDS != null && SEL_BGSCHEME_IDS.length == 1) {
            String bgschemeId = SEL_BGSCHEME_IDS[0];
            BgSchemeInfo bgSchemeInfo = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeInfo((IObjectPK)new ObjectSingleKey((Object)bgschemeId));
            BOSUuid rootUnitID = bgSchemeInfo.getOrgUnit().getId();
            BOSUuid orgUnitId = BgOrgUnitFactory.getLocalInstance(ctx).getBuildTreeOrgUnitId(rootUnitID, BOSUuid.read((String)bgOrgViewId));
            if (orgUnitId != null && _queryOrgUnitIds.contains(orgUnitId.toString())) {
                _queryOrgUnitIds.remove(orgUnitId.toString());
            }
        }
        LinkedHashMap<String, Map<Integer, BigDecimal>> _dataMap = new LinkedHashMap<String, Map<Integer, BigDecimal>>();
        Map<Integer, BigDecimal> _tmpMap = null;
        LinkedHashMap<String, String> _nameMap = new LinkedHashMap<String, String>();
        ArrayList<Object> _tmpList = new ArrayList<Object>();
        Set<String> temp = null;
        int _state = 0;
        int _count = 0;
        boolean formSum = false;
        Object _obj2222222 = null;
        String _id2222222 = null;
        String _name = null;
        String _rootId = null;
        Object _longNumber = null;
        Object _orgUnitId = null;
        String bgPeriodId = null;
        String bgVersionId = null;
        String bgOrgunitId = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FName, t.FRootId, f.FState, count(f.FID), f.FBgPeriodId, f.FBgVersionId, t.FNumber,f.FOrgUnitId from T_MBg_BgForm f ").append("left join T_MBg_BgScheme s on f.FBgSchemeId = s.FID ").append("left join T_MBg_BgTemplate t on f.FBgTemplateId = t.FID ").append("where (t.FBgTypeId is null or t.fbgtypeid <> 'bgMAAAAKIcA7rHKd') ");
        sql.append(" and t.FIsReadOnly = 0");
        if (!isContainForBidden) {
            sql.append(" and t.FTemplateStatus = 0 ");
        }
        if (_queryOrgUnitIds != null && !_queryOrgUnitIds.isEmpty()) {
            sql.append(" and f.FOrgUnitId IN (");
            for (Object _obj2222222 : _queryOrgUnitIds) {
                if (_obj2222222 == null) continue;
                sql.append("?,");
                _tmpList.add(_obj2222222.toString());
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (SEL_BGSCHEME_IDS != null && SEL_BGSCHEME_IDS.length > 0) {
            sql.append(" AND s.FId IN (");
            in = SEL_BGSCHEME_IDS.length;
            for (int i = 0; i < in; ++i) {
                _id2222222 = SEL_BGSCHEME_IDS[i];
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (SEL_BGTEMPLATE_IDS != null && SEL_BGTEMPLATE_IDS.length > 0) {
            sql.append(" AND t.FRootID IN (");
            in = SEL_BGTEMPLATE_IDS.length;
            for (int i = 0; i < in; ++i) {
                _id2222222 = SEL_BGTEMPLATE_IDS[i];
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (SEL_BGPERIOD_IDS != null && SEL_BGPERIOD_IDS.length > 0) {
            sql.append(" AND f.FBgPeriodId IN (");
            for (String _id2222222 : SEL_BGPERIOD_IDS) {
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (SEL_CURRENCY_IDS != null && SEL_CURRENCY_IDS.length > 0) {
            sql.append(" AND f.FCurrencyId IN (");
            in = SEL_CURRENCY_IDS.length;
            for (int i = 0; i < in; ++i) {
                _id2222222 = SEL_CURRENCY_IDS[i];
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (SEL_CURRENCY_IDS != null && SEL_CURRENCY_IDS.length > 0) {
            sql.append(" AND f.Fbgversionid IN (");
            for (String _id2222222 : SEL_BGVERSION_IDS) {
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (processType != null && processType.length > 0) {
            sql.append(" AND f.FProcessType IN (");
            in = processType.length;
            for (int i = 0; i < in; ++i) {
                int type = processType[i];
                sql.append("?,");
                _tmpList.add(type);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        sql.append(" and f.FId not in (select fadjustId from T_MBg_bgform where fstate in (4,35))");
        sql.append(" group by t.FName, t.FRootId, f.FState , f.FBgPeriodId, f.FBgVersionId, t.FNumber,f.FOrgUnitId order by t.FNumber");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            this.querySchemeCount(ctx, CURR_USER_ID, _dataMap, _nameMap, _queryOrgUnitIds, SEL_BGSCHEME_IDS, SEL_BGTEMPLATE_IDS, _isBgPermissionUsed, processType[0], leafOrgIds, isContainForBidden, bgOrgUnitInfo);
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            MbgSqlHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _name = rst.getString(1);
                _rootId = rst.getString(2);
                _state = rst.getInt(3);
                _count = rst.getInt(4);
                bgPeriodId = rst.getString(5);
                bgVersionId = rst.getString(6);
                bgOrgunitId = rst.getString(8);
                String vpKey = _rootId + ";" + bgPeriodId + ";" + bgVersionId;
                _nameMap.put(_rootId, _name);
                if (_dataMap.containsKey(vpKey)) {
                    _tmpMap = (Map)_dataMap.get(vpKey);
                } else {
                    _tmpMap = new HashMap();
                    _dataMap.put(vpKey, _tmpMap);
                }
                if (_tmpMap.containsKey(new Integer(_state))) {
                    _tmpMap.put(new Integer(_state), ((BigDecimal)_tmpMap.get(new Integer(_state))).add(new BigDecimal(_count)));
                } else {
                    _tmpMap.put(new Integer(_state), new BigDecimal(_count));
                }
                if (_tmpMap.containsKey(new Integer(10000))) {
                    temp = (Set)_tmpMap.get(new Integer(10000));
                } else {
                    temp = new HashSet();
                    _tmpMap.put(new Integer(10000), (BigDecimal)((Object)temp));
                }
                temp.add(bgOrgunitId);
                if (_tmpMap.containsKey(new Integer(10001))) {
                    _tmpMap.put(new Integer(10001), ((BigDecimal)_tmpMap.get(10001)).add(new BigDecimal(_count)));
                    continue;
                }
                _tmpMap.put(new Integer(10001), new BigDecimal(_count));
            }
            _dataMap.put("BGTEMPLATE_INFO", _nameMap);
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return _dataMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void querySchemeCount(Context ctx, String userId, Map queryMap, Map nameMap, Set orgUnitIds, String[] bgSchemeRootIds, String[] bgTemplateRootIDS, boolean isBgPermissionUsed, int processType, Set<String> leafOrgIds, boolean isContainForBidden, BgOrgUnitInfo bgOrgUnitInfo) throws BOSException, EASBizException {
        if (ctx == null) {
            return;
        }
        int _count = 0;
        Integer _state = new Integer(100);
        String _id2222222 = null;
        String _rootId = null;
        String _name = null;
        String _tCreateOrgId = null;
        Map<Integer, BigDecimal> _tmpMap = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FName, t.FRootId, MAX(t.FOrgUnitId), count(n.FID), t.FNumber  from T_MBg_BgTemplate t ").append("left join T_MBg_BgTemplateNode n on n.FBgTemplateId = t.FID ").append("where (t.FBgTypeId is null or t.fbgtypeid <> 'bgMAAAAKIcA7rHKd') ");
        sql.append(" and t.FIsReadOnly = 0");
        if (!isContainForBidden) {
            sql.append(" and t.FTemplateStatus = 0 ");
        }
        if (orgUnitIds != null && !orgUnitIds.isEmpty()) {
            sql.append(" and n.FOrgUnitId IN (");
            for (String _id2222222 : orgUnitIds) {
                if (DimensionCommonHelper.isDecompose(BgProcessEnum.getEnum(processType)) && leafOrgIds.contains(_id2222222)) continue;
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (bgSchemeRootIds != null && bgSchemeRootIds.length > 0) {
            sql.append(" AND t.FBgSchemeId IN (");
            int in = bgSchemeRootIds.length;
            for (int i = 0; i < in; ++i) {
                _id2222222 = bgSchemeRootIds[i];
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (bgTemplateRootIDS != null && bgTemplateRootIDS.length > 0) {
            sql.append(" AND t.FRootID IN (");
            for (String _id2222222 : bgTemplateRootIDS) {
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        sql = MbgPermissionHelper.addFieldDataPermissionBySQL(ctx, RptSrcTypeEnum.PT_BUDGET_REPORT, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), sql, MbgPermissionTypeEnum.TEMPLATE, "t.FID", bgSchemeRootIds[0]);
        sql.append(" group by t.FName, t.FRootId, t.FNumber order by t.FNumber");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            MbgSqlHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _name = rst.getString(1);
                _rootId = rst.getString(2);
                _tCreateOrgId = rst.getString(3);
                _count = rst.getInt(4);
                if (_count > 0 && orgUnitIds.contains(_tCreateOrgId)) {
                    --_count;
                }
                if (queryMap.containsKey(_rootId)) {
                    _tmpMap = (Map)queryMap.get(_rootId);
                } else {
                    _tmpMap = new LinkedHashMap();
                    queryMap.put(_rootId, _tmpMap);
                }
                nameMap.put(_rootId, _name);
                _tmpMap.put(_state, new BigDecimal(_count));
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)"", (Throwable)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    protected Map<String, String> _queryHasAttach(Context ctx, List ids) throws BOSException, EASBizException {
        final HashMap<String, String> result = new HashMap<String, String>();
        if (ids == null || ids.isEmpty()) {
            return result;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FBoID ,count(*) from  T_BAS_BoAttchAsso where FBoID in ( ");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)50);
        sql.append(" ) group by FBoID ");
        List params = MbgSqlHelper.getBatchParams(null, (Object[])ids.toArray(), (int)50);
        MbgSqlHelper.executeBatchQuery((Context)ctx, (String)sql.toString(), (List)params, (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                result.put(res.getString(1), res.getString(2));
            }
        });
        return result;
    }

    protected SelectorItemCollection getBgFormSelectorItem() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("state");
        sic.add("courseOrgId");
        sic.add("lastUpdateTime");
        sic.add("processType");
        sic.add("bgScheme.id");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("bgScheme.dateFrom");
        sic.add("bgScheme.dateTo");
        sic.add("bgScheme.isFormal");
        sic.add("bgScheme.period");
        sic.add("bgScheme.state");
        sic.add("bgScheme.isSubmitByScheme");
        sic.add("bgScheme.isFiling");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.number");
        sic.add("bgTemplate.name");
        sic.add("bgTemplate.formType");
        sic.add("bgTemplate.root.id");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("orgUnit.longnumber");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("bgVersion.id");
        sic.add("bgVersion.name");
        sic.add("bgVersion.number");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("bgItemGroup.id");
        sic.add("bgItem.id");
        sic.add("auditor.id");
        sic.add("auditor.name");
        sic.add("auditOrgUnit.id");
        sic.add("auditOrgUnit.name");
        sic.add("auditOrgUnit.number");
        sic.add("auditOrgUnit.longnumber");
        sic.add("bgSpecialItems.id");
        sic.add("bgSpecialItems.memberDisplayName");
        sic.add("bgSpecialItems.dimensionNumber");
        return sic;
    }

    protected IPermissionServiceProvider getPermissionSerInterface(Context ctx) throws Exception {
        return PermissionServiceProviderFactory.getLocalInstance((Context)ctx);
    }
}

