/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgParamCHelper;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgDecomposeFacadeFactory;
import com.kingdee.eas.ma.mbg.BgDecomposeFormCollection;
import com.kingdee.eas.ma.mbg.BgDecomposeFormFactory;
import com.kingdee.eas.ma.mbg.BgDecomposeFormInfo;
import com.kingdee.eas.ma.mbg.BgDecomposeManagerCollection;
import com.kingdee.eas.ma.mbg.BgDecomposeManagerFactory;
import com.kingdee.eas.ma.mbg.BgDecomposeManagerInfo;
import com.kingdee.eas.ma.mbg.BgDecomposeRefOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgDecomposeRefOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormDataSourceEnum;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgSpecialItemsCollection;
import com.kingdee.eas.ma.mbg.BgSpecialItemsInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.DimRelashipGroupEntryCollection;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.DimensionRelationshipCollection;
import com.kingdee.eas.ma.mbg.IBgDecomposeFacade;
import com.kingdee.eas.ma.mbg.IBgDecomposeManager;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.app.AbstractBgDecomposeFormControllerBean;
import com.kingdee.eas.ma.mbg.app.utils.MbgViewListFormServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MbgRelationMap;
import com.kingdee.eas.ma.mbg.common.MbgViewListAtribute;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberRelationShipHelper;
import com.kingdee.eas.ma.mbg.utils.MBgCheckHelper;
import com.kingdee.eas.ma.mbg.utils.RangeDecomposeParamFilter;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgDecomposeFormControllerBean
extends AbstractBgDecomposeFormControllerBean {
    private static final long serialVersionUID = 1344550351679451246L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgDecomposeFormControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String[] _batchRemove(Context ctx, Set bgFormIds, String bgOrgUnitId) throws BOSException, EASBizException {
        int failCount;
        if (bgFormIds == null || bgFormIds.isEmpty() || StringUtils.isEmpty((String)bgOrgUnitId)) {
            return null;
        }
        String[] result = new String[2];
        BgOrgUnitInfo bgOrgUnit = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitInfo("select id, viewId, longNumber, orgUnitID, isVirtual where id = '" + bgOrgUnitId + "'");
        BgOrgUnitCollection childOrg = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection("select id, longNumber, orgUnitID, isVirtual where viewId = '" + bgOrgUnit.getViewID() + "' AND longNumber like '" + bgOrgUnit.getLongNumber() + "!%'");
        childOrg.add(bgOrgUnit);
        Map orgUnitMap = BgCommHelper.transeToMap((IObjectCollection)childOrg, (String[])new String[]{"orgUnitID"});
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("bgForm.id");
        evi.getSelector().add("bgForm.number");
        evi.getSelector().add("bgForm.name");
        evi.getSelector().add("orgUnit.id");
        evi.getSelector().add("orgUnit.name");
        evi.getSelector().add("decomposeUser.id");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)bgFormIds, CompareType.INCLUDE));
        BgDecomposeFormCollection formCol = this.getBgDecomposeFormCollection(ctx, evi);
        Map formMap = BgCommHelper.transeToMap((IObjectCollection)formCol);
        Map orgFormMap = BgCommHelper.transeToMap((IObjectCollection)formCol, (String[])new String[]{"orgUnit.id"});
        String permItemName = "mbg_bgDecomposeForm05_remove";
        IObjectPK[] orgPks = new IObjectPK[orgFormMap.size()];
        int index = 0;
        for (String orgId : orgFormMap.keySet()) {
            orgPks[index++] = new ObjectStringPK(orgId);
        }
        Set permissionOrgId = PermissionFactory.getLocalInstance((Context)ctx).checkBatchPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), orgPks, permItemName);
        Set<String> lockSet = null;
        ArrayList<String> _ids = new ArrayList<String>(bgFormIds);
        try {
            lockSet = MBgCheckHelper.requestMutex(ctx, _ids, true);
        }
        catch (Exception e) {
            logger.error((Object)"\u91ca\u653e\u4e92\u65a5\u9501   batchObjectUpdateLockService error : ", (Throwable)e);
        }
        finally {
            if (lockSet != null) {
                _ids.removeAll(lockSet);
            }
            MBgCheckHelper.releaseMutex(ctx, _ids);
        }
        boolean isControlDDLOption = BgParamCHelper.isControlDDLOption();
        StringBuffer detailMsg = new StringBuffer();
        HashSet<String> successIds = new HashSet<String>();
        ArrayList<Object[]> deleteParams = new ArrayList<Object[]>();
        Object[] deleteobjs = null;
        BgDecomposeFormInfo info = null;
        for (Object formId : bgFormIds) {
            info = (BgDecomposeFormInfo)formMap.get(formId);
            if (isControlDDLOption && !ContextUtil.getCurrentUserInfo((Context)ctx).getId().equals((Object)info.getDecomposeUser().getId())) {
                this.addRemoveMsg(ctx, detailMsg, info, "decomposeProcessCreator");
                continue;
            }
            if (!permissionOrgId.contains(info.getOrgUnit().getId().toString())) {
                this.addRemoveMsg(ctx, detailMsg, info, "decompProcessHasNoPermission");
                continue;
            }
            if (((BgOrgUnitInfo)orgUnitMap.get(info.getOrgUnit().getId().toString())).isIsVirtual()) {
                this.addRemoveMsg(ctx, detailMsg, info, "decompProcessVirtual");
                continue;
            }
            if (lockSet.contains(formId)) {
                this.addRemoveMsg(ctx, detailMsg, info, "decompProcessHasNoMutex");
                continue;
            }
            successIds.add((String)formId);
            deleteobjs = new Object[]{formId.toString()};
            deleteParams.add(deleteobjs);
        }
        if (!successIds.isEmpty()) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", successIds, CompareType.INCLUDE));
            this.delete(ctx, filter);
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bgDecompForm.id", successIds, CompareType.INCLUDE));
            BgDecomposeManagerFactory.getLocalInstance(ctx).delete(filter);
            try {
                BgDBUtils.executeBatch((Context)ctx, (String)"delete from T_MBG_BgDecomposeManagerTable where  fbgdecompformid=? ", deleteParams);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        result[0] = (failCount = bgFormIds.size() - successIds.size()) == 0 ? ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"decomposeDeleteSuccess", (Locale)ctx.getLocale()) : (failCount == bgFormIds.size() ? ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"decomposeDeleteFail", (Locale)ctx.getLocale()) : MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"decomposeDeletePartSuccess", (Locale)ctx.getLocale()), bgFormIds.size(), bgFormIds.size() - failCount, failCount));
        if (failCount > 0) {
            result[1] = detailMsg.toString();
        }
        return result;
    }

    private void addRemoveMsg(Context ctx, StringBuffer detailMsg, BgDecomposeFormInfo info, String msgKey) {
        if (detailMsg.length() > 0) {
            detailMsg.append("\r\n");
        }
        detailMsg.append(MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)msgKey, (Locale)ctx.getLocale()), info.getOrgUnit().getName(), info.getBgForm().getNumber()));
    }

    @Override
    protected Object _assignData(Context ctx, String bgDecomposeFormId) throws BOSException, EASBizException {
        boolean isAssignData = true;
        Object resultObj = this.assign(ctx, bgDecomposeFormId, isAssignData);
        return resultObj;
    }

    @Override
    protected Object _assign(Context ctx, String bgDecomposeFormId) throws BOSException, EASBizException {
        boolean isAssignData = false;
        Object resultObj = this.assign(ctx, bgDecomposeFormId, isAssignData);
        return resultObj;
    }

    private Object assign(Context ctx, String bgDecomposeFormId, boolean isAssignData) throws BOSException, EASBizException {
        boolean existsDecomposeData;
        boolean filter;
        Object[] resultObj = null;
        ArrayList<BgFormInfo> notEditFormList = new ArrayList<BgFormInfo>();
        if (StringUtils.isEmpty((String)bgDecomposeFormId)) {
            return null;
        }
        long st = System.currentTimeMillis();
        String logSign = bgDecomposeFormId + "_Assign_" + st;
        logger.error((Object)("****************Assign Start(" + logSign + ")*********************"));
        if (isAssignData) {
            logger.error((Object)("****************\u64cd\u4f5c\u7c7b\u578b\uff1a\u4e0b\u8fbe\u7f16\u5236\u6570\u636e (" + logSign + ")*********************"));
        } else {
            logger.error((Object)("****************\u64cd\u4f5c\u7c7b\u578b\uff1a\u5206\u89e3\u4e0b\u8fbe (" + logSign + ")*********************"));
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)bgDecomposeFormId));
        BgDecomposeFormInfo bgDecomposeInfo = BgDecomposeFormFactory.getLocalInstance(ctx).getBgDecomposeFormInfo((IObjectPK)pk, this.getSelectors());
        if (bgDecomposeInfo == null) {
            return null;
        }
        BgFormInfo bgForm = bgDecomposeInfo.getBgForm();
        BgFormInfo deepcloneForm = bgForm.deepclone();
        deepcloneForm.setDataSource(BgFormDataSourceEnum.CURRENTWORKOUT);
        RangeDecomposeParamFilter decomposeParamFilter = RangeDecomposeParamFilter.newInstance(ctx);
        Map<String, Set<String>> formulaValuesByDecompose = this.getFormulaValuesByDecompose(ctx, bgDecomposeInfo);
        boolean bl = filter = decomposeParamFilter.isFilter() && BgTemFormTypeEnum.VIEWLIST.equals((Object)bgForm.getBgTemplate().getFormType());
        if (bgForm == null) {
            return null;
        }
        BgSchemeDimensionHelper bgSchemeHelper = new BgSchemeDimensionHelper(ctx, bgForm.getBizBgScheme().getId().toString());
        BgOrgUnitCollection bgOrgUnitCollection = this.getBgOrgUnitColl(ctx, bgDecomposeInfo, bgSchemeHelper.getBgOrgViewId());
        Iterator iter = bgOrgUnitCollection.iterator();
        while (iter.hasNext()) {
            BgOrgUnitInfo orgUnitInfo = (BgOrgUnitInfo)iter.next();
            if (formulaValuesByDecompose.containsKey(orgUnitInfo.getOrgUnitID())) continue;
            iter.remove();
        }
        BgOrgUnitCollection refOrgs = new BgOrgUnitCollection();
        refOrgs.addCollection(bgOrgUnitCollection);
        BgSchemeInfo schemeInfo = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeInfo("where id = '" + bgForm.getBizBgScheme().getId().toString() + "'");
        if (bgOrgUnitCollection == null || bgOrgUnitCollection.size() == 0) {
            return null;
        }
        HashMap<String, BgOrgUnitInfo> orgMap = new HashMap<String, BgOrgUnitInfo>();
        BgOrgUnitCollection leafOrgColls = new BgOrgUnitCollection();
        BgOrgUnitCollection notLeafOrgColls = new BgOrgUnitCollection();
        for (int i = 0; i < bgOrgUnitCollection.size(); ++i) {
            BgOrgUnitInfo bgOrgUnitInfo = bgOrgUnitCollection.get(i);
            if (!orgMap.containsKey(bgOrgUnitInfo.getOrgUnitID())) {
                orgMap.put(bgOrgUnitInfo.getOrgUnitID(), bgOrgUnitInfo);
            }
            if (bgOrgUnitInfo.isIsLeaf()) {
                leafOrgColls.add(bgOrgUnitInfo);
                continue;
            }
            notLeafOrgColls.add(bgOrgUnitInfo);
        }
        BgTemplateInfo bgTemplate = bgForm.getBgTemplate();
        if (bgTemplate == null) {
            return null;
        }
        BgPeriodInfo bgPeriod = bgForm.getBgPeriod();
        if (bgPeriod == null) {
            return null;
        }
        BgVersionInfo bgVersion = bgForm.getBgVersion();
        if (bgVersion == null) {
            return null;
        }
        CurrencyInfo currency = bgForm.getCurrency();
        if (currency == null) {
            return null;
        }
        IBgDecomposeFacade localInstance = this.getInterface4Decomposition(ctx);
        Map<Integer, Map<String, String>> orgIdOfExistBgform = null;
        orgIdOfExistBgform = this.getExistsOrgIdOfBgForm(ctx, isAssignData, logSign, bgDecomposeInfo, refOrgs, bgTemplate, bgPeriod, bgVersion, currency);
        Object[] resultObjByProcess = null;
        if (orgIdOfExistBgform != null && isAssignData) {
            if (!orgIdOfExistBgform.containsKey(new Integer(1)) && leafOrgColls != null && !leafOrgColls.isEmpty()) {
                orgIdOfExistBgform.put(new Integer(1), new HashMap());
            }
            if (!orgIdOfExistBgform.containsKey(new Integer(2)) && notLeafOrgColls != null && !notLeafOrgColls.isEmpty()) {
                orgIdOfExistBgform.put(new Integer(2), new HashMap());
            }
        }
        if (orgIdOfExistBgform != null) {
            for (Map.Entry<Integer, Map<String, String>> entry : orgIdOfExistBgform.entrySet()) {
                Integer key = entry.getKey();
                if (isAssignData) {
                    HashMap<Integer, Map<String, String>> existFormByProcess = new HashMap<Integer, Map<String, String>>();
                    existFormByProcess.put(key, orgIdOfExistBgform.get(key));
                    if (1 == key) {
                        resultObjByProcess = this.addBgForm(isAssignData, resultObj, logSign, deepcloneForm, leafOrgColls, bgTemplate, bgPeriod, bgVersion, currency, localInstance, existFormByProcess);
                        if (filter) {
                            this.filterMemberFromAddbgForm(ctx, formulaValuesByDecompose, bgSchemeHelper, deepcloneForm.getBgScheme(), leafOrgColls, bgTemplate, bgPeriod, bgVersion, currency, BgProcessEnum.C01);
                        }
                    } else if (2 == key) {
                        resultObjByProcess = this.addBgForm(isAssignData, resultObj, logSign, deepcloneForm, notLeafOrgColls, bgTemplate, bgPeriod, bgVersion, currency, localInstance, existFormByProcess);
                        if (filter) {
                            this.filterMemberFromAddbgForm(ctx, formulaValuesByDecompose, bgSchemeHelper, deepcloneForm.getBgScheme(), notLeafOrgColls, bgTemplate, bgPeriod, bgVersion, currency, BgProcessEnum.C02);
                        }
                    }
                } else if (3 == key) {
                    resultObjByProcess = this.addBgForm(isAssignData, resultObj, logSign, deepcloneForm, bgOrgUnitCollection, bgTemplate, bgPeriod, bgVersion, currency, localInstance, orgIdOfExistBgform);
                    if (filter) {
                        this.filterMemberFromAddbgForm(ctx, formulaValuesByDecompose, bgSchemeHelper, deepcloneForm.getBgScheme(), bgOrgUnitCollection, bgTemplate, bgPeriod, bgVersion, currency, BgProcessEnum.C03);
                    }
                }
                if (resultObj != null) {
                    if (resultObj instanceof Object[]) {
                        Object[] objArrByProcess;
                        String str1;
                        Object[] objArr = resultObj;
                        if (objArr.length != 4 || !(objArr[2] instanceof List)) continue;
                        String str0 = objArr[0] == null ? "" : objArr[0].toString();
                        String string = str1 = objArr[1] == null ? "" : objArr[1].toString();
                        if (!(resultObjByProcess instanceof Object[]) || (objArrByProcess = (Object[])resultObjByProcess).length != 4 || !(objArrByProcess[2] instanceof List)) continue;
                        String str0ByProcess = objArr[0] == null ? "" : objArrByProcess[0].toString();
                        String str1ByProcess = objArr[1] == null ? "" : objArrByProcess[1].toString();
                        objArr[0] = str0 + "\r\n" + str0ByProcess;
                        objArr[1] = str1 + "\r\n" + str1ByProcess;
                        ((List)objArr[2]).addAll((List)objArrByProcess[2]);
                        if (objArr[3] == null) {
                            objArr[3] = objArrByProcess[3];
                            continue;
                        }
                        if (objArrByProcess[3] == null) continue;
                        Integer[] oldArr = (Integer[])objArr[3];
                        Integer[] newArr = (Integer[])objArrByProcess[3];
                        oldArr[0] = oldArr[0] + newArr[0];
                        oldArr[1] = oldArr[1] + newArr[1];
                        continue;
                    }
                    if (!(resultObj instanceof BgFormInfo) || !(resultObjByProcess instanceof Object[])) continue;
                    resultObj = resultObjByProcess;
                    continue;
                }
                resultObj = resultObjByProcess;
            }
        } else {
            resultObjByProcess = this.addBgForm(isAssignData, resultObj, logSign, deepcloneForm, bgOrgUnitCollection, bgTemplate, bgPeriod, bgVersion, currency, localInstance, orgIdOfExistBgform);
            if (filter) {
                this.filterMemberFromAddbgForm(ctx, formulaValuesByDecompose, bgSchemeHelper, deepcloneForm.getBgScheme(), bgOrgUnitCollection, bgTemplate, bgPeriod, bgVersion, currency, isAssignData ? deepcloneForm.getProcessType() : BgProcessEnum.C03);
            }
            resultObj = resultObjByProcess;
        }
        if (!(existsDecomposeData = this.getDecomposeDataInterFace(ctx).exists("where bgDecompForm.id ='" + bgDecomposeInfo.getId().toString() + "'"))) {
            return null;
        }
        long st4 = System.currentTimeMillis();
        Map<String, List<BgDecomposeManagerInfo>> decomposeDataMap = this.getDecomposeDataMap(ctx, bgDecomposeInfo, logSign);
        logger.error((Object)("\u64cd\u4f5c\uff1a\u3010\u67e5\u8be2\u5e76\u62fc\u88c5\u5206\u89e3\u5904\u7406\u6570\u636e\u3011 \u8017\u65f6 \uff1a" + (System.currentTimeMillis() - st4) + "ms(" + logSign + ")"));
        Map<String, String> scInnNumMap = this.getScenMap(ctx);
        Map<String, String> verInnNumMap = this.getVersionMap(ctx);
        BgFormCollection bgFormCollection = new BgFormCollection();
        IBgForm bgFormInstance = this.getBgFormInstance(ctx);
        boolean isAssignSuccess = false;
        orgIdOfExistBgform = this.getExistsOrgIdOfBgForm(ctx, isAssignData, logSign, bgDecomposeInfo, refOrgs, bgTemplate, bgPeriod, bgVersion, currency);
        if (orgIdOfExistBgform != null && !orgIdOfExistBgform.isEmpty()) {
            long sumUpdateMembersTime = 0L;
            long st2 = System.currentTimeMillis();
            HashSet<String> orgIdSet = new HashSet<String>();
            HashSet<String> formIdSet = new HashSet<String>();
            for (Map.Entry<Integer, Map<String, String>> entry : orgIdOfExistBgform.entrySet()) {
                for (Map.Entry<String, String> item : entry.getValue().entrySet()) {
                    Object formId;
                    String orgId = item.getKey();
                    if (!StringUtils.isEmpty((String)orgId)) {
                        orgIdSet.add(orgId);
                    }
                    if (StringUtils.isEmpty((String)(formId = item.getValue()))) continue;
                    formIdSet.add((String)formId);
                }
            }
            if (orgIdSet.isEmpty() || formIdSet.isEmpty()) {
                return null;
            }
            logger.error((Object)("\u5b58\u5728\u9884\u7b97\u8868\u7684\u7ec4\u7ec7\u6570\u91cf \uff1a" + orgIdSet.size() + "(" + logSign + ")"));
            Map<String, BgFormInfo> existsBgFroms = this.getBgFromConllection(formIdSet, ctx, orgMap);
            if (existsBgFroms == null || existsBgFroms.isEmpty()) {
                return null;
            }
            MbgXMLParser parsers4View = new MbgXMLParser(ctx);
            MbgViewListXMLParser parsers = new MbgViewListXMLParser(ctx);
            IMbgViewBase curbgFormView = null;
            FullOrgUnitInfo sourceFullOrgUnitInfo = bgForm.getOrgUnit().castToFullOrgUnitInfo();
            for (String orgId : orgIdSet) {
                IMbgViewBase existsFormView;
                BgFormInfo existsbgFormInfo;
                BgFormStateEnum state;
                Map<String, Set<String>> formulaData = null;
                if (filter) {
                    formulaData = RangeDecomposeParamFilter.parseFormluaData(bgSchemeHelper, formulaValuesByDecompose.get(orgId));
                }
                if (!BgFormStateEnum.Edited.equals((Object)(state = (existsbgFormInfo = existsBgFroms.get(orgId)).getState())) && !BgFormStateEnum.Back.equals((Object)state)) {
                    notEditFormList.add(existsbgFormInfo);
                    continue;
                }
                Object data = null;
                if (4 != bgForm.getBgTemplate().getFormType().getValue() && 2 != bgForm.getBgTemplate().getFormType().getValue()) continue;
                if (curbgFormView == null) {
                    curbgFormView = bgForm.getView(ctx, schemeInfo);
                }
                if (this.isDiffLayout(bgForm, existsbgFormInfo, ctx, curbgFormView, existsFormView = existsbgFormInfo.getView(ctx, schemeInfo))) continue;
                long st5 = System.currentTimeMillis();
                if (BgTemFormTypeEnum.VIEWFORM.equals((Object)existsbgFormInfo.getFormType()) && BgTemFormTypeEnum.VIEWFORM.equals((Object)bgForm.getFormType())) {
                    IMbgViewManager curView = (IMbgViewManager)curbgFormView;
                    IMbgViewManager existsView = (IMbgViewManager)existsFormView;
                    List<IMbgSheetManager> curSheetManagers = curView.getSheetManagers();
                    List<IMbgSheetManager> existsSheetManagers = existsView.getSheetManagers();
                    BgDimensionInfo sourceDim = null;
                    BgDimensionBaseInfo targetDim = null;
                    if (curSheetManagers != null && !curSheetManagers.isEmpty() && existsSheetManagers != null && !existsSheetManagers.isEmpty()) {
                        for (int i = 0; i < curSheetManagers.size(); ++i) {
                            IMbgSheetManager sourceMbgSheetManager = curSheetManagers.get(i);
                            IMbgSheetManager targetMbgSheetManager = existsSheetManagers.get(i);
                            IBgDimensionManager sourceDimensionManager = sourceMbgSheetManager.getDimensionManager();
                            IBgDimensionManager targetDimensionManager = targetMbgSheetManager.getDimensionManager();
                            for (int d = 0; d < sourceDimensionManager.getDimension().size(); ++d) {
                                sourceDim = (BgDimensionInfo)sourceDimensionManager.getDimension().get(d);
                                targetDim = DimensionCommonHelper.searchDimension(sourceDim.getNumber(), targetDimensionManager);
                                List addMems = this.getOnlyInfo(sourceDim.getMember(), targetDim.getMember(), filter ? formulaData.get(targetDim.getNumber()) : null);
                                targetDim.getMember().addAll(addMems);
                            }
                        }
                    }
                    data = MbgXMLParser.unParse(existsView);
                } else if (BgTemFormTypeEnum.VIEWLIST.equals((Object)existsbgFormInfo.getFormType()) && BgTemFormTypeEnum.VIEWLIST.equals((Object)bgForm.getFormType())) {
                    MbgViewListManager curViewlistView = (MbgViewListManager)curbgFormView;
                    MbgViewListManager existsViewlistView = (MbgViewListManager)existsFormView;
                    this.updateMbgViewManager(ctx, curViewlistView, existsViewlistView, (IObjectValue)sourceFullOrgUnitInfo, (IObjectValue)((BgOrgUnitInfo)orgMap.get(orgId)).castToFullOrgUnitInfo(), formulaData, bgSchemeHelper);
                    data = parsers.unParse(existsViewlistView);
                }
                if (data != null) {
                    existsbgFormInfo.getEntries().get(0).setDimensionData((byte[])data);
                }
                bgFormCollection.add(existsbgFormInfo);
                long perUpdateMembersTime = System.currentTimeMillis() - st5;
                sumUpdateMembersTime += perUpdateMembersTime;
            }
            logger.error((Object)("\u64cd\u4f5c\uff1a\u3010\u66f4\u65b0\u8868\u6210\u5458\u3011 \u8017\u65f6 \uff1a" + sumUpdateMembersTime + "ms(" + logSign + ")"));
            if (bgFormCollection != null || !bgFormCollection.isEmpty()) {
                CoreBaseCollection colls = new CoreBaseCollection();
                colls.addObjectCollection((IObjectCollection)bgFormCollection);
                bgFormInstance.saveBatchData(colls);
            }
            long sumParseFormulaTime4Update = 0L;
            if (orgIdSet != null && !orgIdSet.isEmpty()) {
                HashMap<Integer, String> processTypeFormId = new HashMap<Integer, String>();
                HashMap allBgData = new HashMap();
                Map<String, Map<String, BgNViewDataInfo>> _bgData = null;
                for (String orgId : orgIdSet) {
                    BgFormInfo existsbgFormInfo = existsBgFroms.get(orgId);
                    BgFormStateEnum state = existsbgFormInfo.getState();
                    if (!BgFormStateEnum.Edited.equals((Object)state) && !BgFormStateEnum.Back.equals((Object)state)) continue;
                    long st7 = System.currentTimeMillis();
                    Set<String> formulas = MbgViewListFormServerHelper.getFormula(ctx, existsbgFormInfo, bgSchemeHelper);
                    long perParseFormulaTime4Update = System.currentTimeMillis() - st7;
                    sumParseFormulaTime4Update += perParseFormulaTime4Update;
                    if (existsbgFormInfo == null || formulas == null || formulas.isEmpty()) continue;
                    _bgData = this.inertData(ctx, decomposeDataMap, formulas, existsbgFormInfo, logSign, scInnNumMap, verInnNumMap);
                    Integer processType = existsbgFormInfo.getProcessType().getValue();
                    processTypeFormId.put(processType, existsbgFormInfo.getId().toString());
                    if (_bgData != null) {
                        if (!allBgData.containsKey(processType)) {
                            allBgData.put(processType, new HashMap());
                        }
                        ((Map)allBgData.get(processType)).putAll(_bgData);
                    }
                    isAssignSuccess = true;
                }
                logger.error((Object)("\u64cd\u4f5c\uff1a\u3010\u66f4\u65b0\u64cd\u4f5c\u89e3\u6790\u9879\u76ee\u516c\u5f0f\u3011 \u8017\u65f6 \uff1a" + sumParseFormulaTime4Update + "ms(" + logSign + ")"));
                long st6 = System.currentTimeMillis();
                for (Integer processType : allBgData.keySet()) {
                    MBGFormFacadeFactory.getLocalInstance(ctx).saveBgData((String)processTypeFormId.get(processType), (Map)allBgData.get(processType), false);
                }
                long sumInsertAndUpdateDataTime = System.currentTimeMillis() - st6;
                logger.error((Object)("\u64cd\u4f5c\uff1a\u3010\u6279\u91cf\u6570\u636e\u4e0b\u8fbe\u3011 \u8017\u65f6 \uff1a" + sumInsertAndUpdateDataTime + "ms(" + logSign + ")"));
            }
            logger.error((Object)("\u64cd\u4f5c\uff1a\u3010\u66f4\u65b0\u8868\u6210\u5458\u5e76\u4e0b\u8fbe\u603b\u6570\u636e\u3011 \u8017\u65f6 \uff1a" + (System.currentTimeMillis() - st2) + "ms(" + logSign + ")"));
        }
        logger.error((Object)("\u64cd\u4f5c\uff1a\u3010\u4e0b\u8fbe\u603b\u6570\u636e\u3011 \u8017\u65f6 \uff1a" + (System.currentTimeMillis() - st) + "ms(" + logSign + ")"));
        logger.error((Object)("****************Assign End(" + logSign + ")*********************"));
        int notEditSize = notEditFormList.size();
        if (resultObj instanceof Object[]) {
            Object[] objArr = resultObj;
            if (objArr.length >= 3 && objArr[1] instanceof String && objArr[0] instanceof String && !StringUtils.isEmpty((String)((String)objArr[1]))) {
                objArr[2] = isAssignSuccess;
            }
            if (objArr.length >= 4) {
                String formMsg = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"bgDecompose", (Locale)ctx.getLocale());
                Integer[] counts = (Integer[])objArr[3];
                objArr[0] = counts[1] == 0 ? ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"addNewSuccess", (Locale)ctx.getLocale(), (Object[])new Object[]{formMsg, counts[0]}) : (counts[0] == counts[1] ? ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"addNewFail", (Locale)ctx.getLocale(), (Object[])new Object[]{formMsg, notEditSize + counts[1]}) : ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"addNewSuccessFail", (Locale)ctx.getLocale(), (Object[])new Object[]{formMsg, notEditSize + counts[0] - counts[1], notEditSize + counts[1]}));
                resultObj = new Object[3];
                resultObj[0] = objArr[0];
                String replaceMsg = "";
                if (!StringUtils.isEmpty((String)((String)objArr[1])) && objArr[1] instanceof String) {
                    String msg1 = (String)objArr[1];
                    String[] split = msg1.split("\r\n");
                    for (int i = 0; i < split.length; ++i) {
                        String item = split[i];
                        replaceMsg = replaceMsg + item.replaceFirst("(\\d+)", String.valueOf(i + 1)) + "\r\n";
                    }
                }
                for (int i = 0; i < notEditSize; ++i) {
                    BgFormInfo bgFormInfo = (BgFormInfo)notEditFormList.get(i);
                    String detail = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"stateFialedForm", (Locale)ctx.getLocale(), (Object[])new Object[]{bgFormInfo.getOrgUnit().getName()});
                    int seq = counts[1] + i + 1;
                    replaceMsg = replaceMsg + seq + "\u3001" + detail + "\r\n";
                }
                resultObj[1] = StringUtils.isEmpty((String)replaceMsg) ? objArr[1] : replaceMsg;
                resultObj[2] = objArr[2];
            }
        } else if ((resultObj instanceof BgFormInfo || resultObj == null) && !notEditFormList.isEmpty()) {
            resultObj = new Object[3];
            if (isAssignData) {
                resultObj[0] = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"assignDecomposeDataError", (Locale)ctx.getLocale());
            } else {
                String formMsg = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"bgDecompose", (Locale)ctx.getLocale());
                resultObj[0] = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"addNewFail", (Locale)ctx.getLocale(), (Object[])new Object[]{formMsg, notEditSize});
            }
            StringBuilder msg = new StringBuilder();
            for (int i = 0; i < notEditSize; ++i) {
                BgFormInfo bgFormInfo = (BgFormInfo)notEditFormList.get(i);
                String detail = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"stateFialedForm", (Locale)ctx.getLocale(), (Object[])new Object[]{bgFormInfo.getOrgUnit().getName()});
                msg.append(detail).append("\r\n");
            }
            resultObj[1] = StringUtils.isEmpty((String)msg.toString()) ? "" : msg.toString();
            resultObj[2] = Boolean.TRUE;
        }
        return resultObj;
    }

    private void filterMemberFromAddbgForm(Context ctx, Map<String, Set<String>> formulaValuesByDecompose, BgSchemeDimensionHelper schemeHelper, BgSchemeInfo bgScheme, BgOrgUnitCollection bgOrgUnits, BgTemplateInfo bgTemplate, BgPeriodInfo bgPeriod, BgVersionInfo bgVersion, CurrencyInfo currency, BgProcessEnum processType) throws BOSException, EASBizException {
        if (bgOrgUnits == null || bgOrgUnits.isEmpty()) {
            return;
        }
        HashSet<String> orgIds = new HashSet<String>();
        for (int i = 0; i < bgOrgUnits.size(); ++i) {
            orgIds.add(bgOrgUnits.get(i).getOrgUnitID());
        }
        MbgViewListXMLParser parsers = new MbgViewListXMLParser(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(BgNFSHelper.getSelectors(false));
        FilterInfo filterInfo = new FilterInfo();
        evi.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)schemeHelper.getBgSchemeId(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bgTemplate.id", (Object)bgTemplate.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bgPeriod.id", (Object)bgPeriod.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bgVersion.id", (Object)bgVersion.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currency.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", orgIds, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("processType", (Object)processType, CompareType.EQUALS));
        BgFormCollection bgForms = BgFormFactory.getLocalInstance(ctx).getBgFormCollection(evi);
        byte[] data = null;
        CoreBaseCollection updateBgForms = new CoreBaseCollection();
        for (int i = 0; i < bgForms.size(); ++i) {
            BgFormInfo formInfo = bgForms.get(i);
            IMbgViewBase curbgFormView = formInfo.getView(ctx, bgScheme);
            Map<String, Set<String>> parseFormluaDatas = RangeDecomposeParamFilter.parseFormluaData(schemeHelper, formulaValuesByDecompose.get(formInfo.getOrgUnit().getId().toString()));
            List<? extends IMbgSheetBase> sheetManagers = curbgFormView.getSheetManagers();
            if (BgTemFormTypeEnum.VIEWLIST.equals((Object)formInfo.getBgTemplate().getFormType())) {
                for (int j = 0; j < sheetManagers.size(); ++j) {
                    MbgViewListSheetManager sheetManager = (MbgViewListSheetManager)sheetManagers.get(j);
                    MbgViewListDimensionManager dimensionManager = sheetManager.getDimensionManager();
                    List<IMbgViewListObject> rowCols = dimensionManager.getRowCols();
                    for (IMbgViewListObject rowCol : rowCols) {
                        if (rowCol == null || !(rowCol instanceof MbgViewListRowCol)) continue;
                        MbgViewListRowCol rowObj = (MbgViewListRowCol)rowCol;
                        List<MbgViewListDimensionInfo> dimensions = rowObj.getDimensions();
                        for (MbgViewListDimensionInfo info : dimensions) {
                            List members = info.getMember();
                            DimensionMemberValueModeEnum memberValueType = info.getMemberValueType();
                            if (!DimensionMemberValueModeEnum.Null.equals((Object)memberValueType) && !DimensionMemberValueModeEnum.RelationMapping.equals((Object)memberValueType) && !DimensionMemberValueModeEnum.Manual.equals((Object)memberValueType)) continue;
                            Set<String> formulaValues = parseFormluaDatas.get(info.getNumber());
                            Iterator iter = members.iterator();
                            while (iter.hasNext()) {
                                BgDimensionMember member = (BgDimensionMember)iter.next();
                                if (formulaValues.contains(member.getNumber())) continue;
                                iter.remove();
                            }
                            List selectMembers = info.getSelectMembers();
                            Iterator iter2 = selectMembers.iterator();
                            while (iter2.hasNext()) {
                                BgDimensionMember member = (BgDimensionMember)iter2.next();
                                if (formulaValues.contains(member.getNumber())) continue;
                                iter2.remove();
                            }
                        }
                    }
                }
                data = parsers.unParse((MbgViewListManager)curbgFormView);
            }
            if (data == null) continue;
            formInfo.getEntries().get(0).setDimensionData(data);
            updateBgForms.add((CoreBaseInfo)formInfo);
        }
        if (!updateBgForms.isEmpty()) {
            BgFormFactory.getLocalInstance(ctx).saveBatchData(updateBgForms);
        }
    }

    private Object addBgForm(boolean isAssignData, Object resultObj, String logSign, BgFormInfo deepcloneForm, BgOrgUnitCollection bgOrgUnitCollection, BgTemplateInfo bgTemplate, BgPeriodInfo bgPeriod, BgVersionInfo bgVersion, CurrencyInfo currency, IBgDecomposeFacade localInstance, Map<Integer, Map<String, String>> orgIdOfExistBgform) throws BOSException, EASBizException {
        if (orgIdOfExistBgform != null && !orgIdOfExistBgform.isEmpty()) {
            HashSet<String> orgIdSet = new HashSet<String>();
            HashSet<String> formIdSet = new HashSet<String>();
            for (Map.Entry<Integer, Map<String, String>> entry : orgIdOfExistBgform.entrySet()) {
                for (Map.Entry<String, String> item : entry.getValue().entrySet()) {
                    String formId;
                    String orgId = item.getKey();
                    if (!StringUtils.isEmpty((String)orgId)) {
                        orgIdSet.add(orgId);
                    }
                    if (StringUtils.isEmpty((String)(formId = item.getValue()))) continue;
                    formIdSet.add(formId);
                }
            }
            logger.error((Object)("\u5b58\u5728\u9884\u7b97\u8868\u7684\u7ec4\u7ec7\u6570\u91cf \uff1a" + orgIdSet.size() + "(" + logSign + ")"));
            Iterator iterator = bgOrgUnitCollection.iterator();
            while (iterator.hasNext()) {
                BgOrgUnitInfo bgOrgUnitInfo = (BgOrgUnitInfo)iterator.next();
                if (!orgIdSet.contains(bgOrgUnitInfo.getOrgUnitID().toString())) continue;
                iterator.remove();
            }
        }
        if (!bgOrgUnitCollection.isEmpty()) {
            BgSpecialItemsCollection bgSpecialItems;
            int processTypeValue = 3;
            if (isAssignData) {
                processTypeValue = 0;
            }
            long st3 = System.currentTimeMillis();
            deepcloneForm.setId(null);
            deepcloneForm.setNumber(null);
            BgTemFormTypeEnum formType = deepcloneForm.getBgTemplate().getFormType();
            if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)formType) && (bgSpecialItems = deepcloneForm.getBgSpecialItems()) != null && !bgSpecialItems.isEmpty()) {
                for (int i = 0; i < bgSpecialItems.size(); ++i) {
                    BgSpecialItemsInfo bgSpecialItemsInfo = bgSpecialItems.get(i);
                    if (bgSpecialItemsInfo == null) continue;
                    bgSpecialItemsInfo.setId(null);
                }
            }
            resultObj = localInstance.addNewDecompose(deepcloneForm, DimensionCommonHelper.getValues((Object)bgOrgUnitCollection), DimensionCommonHelper.getValues(bgTemplate), DimensionCommonHelper.getValues(bgPeriod), DimensionCommonHelper.getValues(bgVersion), DimensionCommonHelper.getValues(currency), null, false, true, true, processTypeValue, isAssignData);
            logger.error((Object)("\u64cd\u4f5c\uff1a\u3010\u65b0\u589e\u9884\u7b97\u8868\u3011 \u8017\u65f6 \uff1a" + (System.currentTimeMillis() - st3) / 1000L + "s(" + logSign + ")"));
        }
        return resultObj;
    }

    private Map<Integer, Map<String, String>> getExistsOrgIdOfBgForm(Context ctx, boolean isAssignData, String logSign, BgDecomposeFormInfo bgDecomposeInfo, BgOrgUnitCollection bgOrgUnitCollection, BgTemplateInfo bgTemplate, BgPeriodInfo bgPeriod, BgVersionInfo bgVersion, CurrencyInfo currency) throws BOSException, EASBizException {
        long st1 = System.currentTimeMillis();
        Map<Integer, Map<String, String>> orgIdOfExistBgform = isAssignData ? this.getOrgIdSetOfExistsByOrg(ctx, bgDecomposeInfo, bgOrgUnitCollection, bgTemplate, bgPeriod, bgVersion, currency) : this.getOrgIdSetOfExists(ctx, bgDecomposeInfo, bgOrgUnitCollection, bgTemplate, bgPeriod, bgVersion, currency, 3);
        logger.error((Object)("\u64cd\u4f5c\uff1a\u3010\u67e5\u8be2\u5b58\u5728\u76f8\u540c\u6a21\u677f\u3001\u5e01\u522b\u3001\u671f\u95f4\u3001\u7248\u672c\u7684\u8868\u3011 \u8017\u65f6 \uff1a" + (System.currentTimeMillis() - st1) + "ms(" + logSign + ")"));
        return orgIdOfExistBgform;
    }

    private IBgForm getBgFormInstance(Context ctx) throws BOSException {
        return BgFormFactory.getLocalInstance(ctx);
    }

    private Map<String, Map<String, BgNViewDataInfo>> inertData(Context ctx, Map<String, List<BgDecomposeManagerInfo>> decomposeDataMap, Set<String> formulas, BgFormInfo bgFormInfo, String logSign, Map<String, String> scInnNumMap, Map<String, String> verInnNumMap) throws BOSException, EASBizException {
        if (formulas != null && !formulas.isEmpty() && bgFormInfo != null) {
            List<BgDecomposeManagerInfo> list = decomposeDataMap.get(bgFormInfo.getOrgUnit().getId().toString());
            if (list == null || list.isEmpty()) {
                return null;
            }
            Iterator<BgDecomposeManagerInfo> iterator = list.iterator();
            while (iterator.hasNext()) {
                BgDecomposeManagerInfo bgDecomposeManagerInfo = iterator.next();
                String formula = bgDecomposeManagerInfo.getFormula();
                if (StringUtils.isEmpty((String)formula) || formulas.contains(formula)) continue;
                iterator.remove();
            }
            return this.saveAssignDataToDB(ctx, scInnNumMap, verInnNumMap, bgFormInfo, list);
        }
        return null;
    }

    private Map<String, Map<String, BgNViewDataInfo>> saveAssignDataToDB(Context ctx, Map<String, String> scInnNumMap, Map<String, String> verInnNumMap, BgFormInfo bgFormInfo, List<BgDecomposeManagerInfo> list) throws BOSException, EASBizException {
        HashMap<String, Map<String, BgNViewDataInfo>> bgDataMap = new HashMap<String, Map<String, BgNViewDataInfo>>();
        FullOrgUnitInfo orgUnit = bgFormInfo.getOrgUnit();
        String orgId = orgUnit.getId().toString();
        bgDataMap.put(orgId, new HashMap());
        for (int j = 0; j < list.size(); ++j) {
            BgDecomposeManagerInfo bgDecomposeManagerInfo = list.get(j);
            if (bgDecomposeManagerInfo == null) continue;
            BgNViewDataInfo bgData = new BgNViewDataInfo();
            bgData.setFormula(bgDecomposeManagerInfo.getFormula());
            bgData.setBgItemNumber(bgDecomposeManagerInfo.getBgItemCombination());
            bgData.setBgPeriodNumber(bgDecomposeManagerInfo.getBgPeriod().getNumber());
            bgData.setBgIndexNum(bgDecomposeManagerInfo.getBgItemCombination().split(",")[0]);
            bgData.setBgElementNumber(bgDecomposeManagerInfo.getBgELement().getNumber());
            bgData.setCurrencyNumber(bgDecomposeManagerInfo.getCurrency().getNumber());
            bgData.setBgScenario(scInnNumMap.get(String.valueOf(bgDecomposeManagerInfo.getScenario())));
            String versionNum = verInnNumMap.get(String.valueOf(bgDecomposeManagerInfo.getVersion()));
            bgData.setBgVersion(versionNum);
            bgData.setBudgetValue(bgDecomposeManagerInfo.getValue());
            bgData.setState(1);
            bgData.setBgDataSource(5);
            ((Map)bgDataMap.get(orgId)).put(bgDecomposeManagerInfo.getFormula() + "_" + versionNum, bgData);
        }
        MBGFormFacadeFactory.getLocalInstance(ctx).saveBgData(bgFormInfo.getId().toString(), bgDataMap, false);
        return bgDataMap;
    }

    private Map<String, String> getVersionMap(Context ctx) throws BOSException {
        HashMap<String, String> verInnNumMap = new HashMap<String, String>();
        BgVersionInfo _version = null;
        BgVersionCollection _bgVerColls = BgVersionHelper.getVersionColls((Context)ctx);
        if (_bgVerColls != null) {
            int in = _bgVerColls.size();
            for (int i = 0; i < in; ++i) {
                _version = _bgVerColls.get(i);
                verInnNumMap.put(String.valueOf(_version.getVersionId()), _version.getNumber());
            }
        }
        return verInnNumMap;
    }

    private Map<String, String> getScenMap(Context ctx) throws BOSException {
        HashMap<String, String> scInnNumMap = new HashMap<String, String>();
        BgScenarioInfo _scenario = null;
        BgScenarioCollection _bgScenColls = BgScenarioHelper.getScenarioColls((Context)ctx);
        if (_bgScenColls != null) {
            int in = _bgScenColls.size();
            for (int i = 0; i < in; ++i) {
                _scenario = _bgScenColls.get(i);
                scInnNumMap.put(String.valueOf(_scenario.getScenarioId()), _scenario.getNumber());
            }
        }
        return scInnNumMap;
    }

    private Map<String, List<BgDecomposeManagerInfo>> getDecomposeDataMap(Context ctx, BgDecomposeFormInfo bgDecomposeInfo, String logSign) throws BOSException {
        HashMap<String, List<BgDecomposeManagerInfo>> decomposeDataMap = new HashMap<String, List<BgDecomposeManagerInfo>>();
        long st1 = System.currentTimeMillis();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        BgDecomposeManagerInfo info = null;
        BgDecomposeManagerCollection bgDecomposeManagerCollection = new BgDecomposeManagerCollection();
        try {
            conn = this.getConnection(ctx);
            StringBuilder sql = new StringBuilder("Select t.FID, t.FOrgUnitID, t.FFormula, t.FBgItemCombination, t.FBgPeriodID, t.FBgELementID, t.FCurrencyID, t.FScenario, t.FValue, t.FVersion , ");
            sql.append(" p.FNumber pNumber, e.FNumber eNumber, c.FNumber cNumber ");
            sql.append(" From T_MBG_BgDecomposeManager t, T_MBG_BgPeriod p, T_MBG_BgElement e, T_BD_Currency c ");
            sql.append(" where t.FBgPeriodID = p.FID and t.FBgELementID = e.FID and t.FCurrencyID = c.FID and t.FBgDecompFormID = ?");
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgDecomposeInfo.getId().toString());
            res = pstmt.executeQuery();
            while (res.next()) {
                info = this.getBgDecomposeManagerInfo(res);
                bgDecomposeManagerCollection.add(info);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pstmt, (Connection)conn);
        logger.error((Object)("\u64cd\u4f5c\uff1a\u3010\u5206\u89e3\u5904\u7406\u6570\u636e\u67e5\u8be2\u3011 \u8017\u65f6 \uff1a" + (System.currentTimeMillis() - st1) + "ms(" + logSign + ")"));
        for (int i = 0; i < bgDecomposeManagerCollection.size(); ++i) {
            BgDecomposeManagerInfo bgDecomposeManagerInfo = bgDecomposeManagerCollection.get(i);
            if (bgDecomposeManagerInfo == null) continue;
            String orgId = bgDecomposeManagerInfo.getOrgUnit().getId().toString();
            if (!decomposeDataMap.containsKey(orgId)) {
                decomposeDataMap.put(orgId, new ArrayList());
            }
            ((List)decomposeDataMap.get(orgId)).add(bgDecomposeManagerInfo);
        }
        return decomposeDataMap;
    }

    private BgDecomposeManagerInfo getBgDecomposeManagerInfo(ResultSet res) throws SQLException {
        String id = res.getString("FID");
        String orgId = res.getString("FOrgUnitID");
        String formula = res.getString("FFormula");
        BgDecomposeManagerInfo info = new BgDecomposeManagerInfo();
        info.setId(BOSUuid.read((String)id));
        FullOrgUnitInfo orgInfo = new FullOrgUnitInfo();
        orgInfo.setId(BOSUuid.read((String)orgId));
        info.setOrgUnit(orgInfo);
        info.setFormula(formula);
        info.setBgItemCombination(res.getString("FBgItemCombination"));
        info.setScenario(res.getInt("FScenario"));
        info.setVersion(res.getBigDecimal("FVersion"));
        info.setValue(res.getBigDecimal("FValue"));
        BgPeriodInfo pInfo = new BgPeriodInfo();
        pInfo.setId(BOSUuid.read((String)res.getString("FBgPeriodID")));
        pInfo.setNumber(res.getString("pNumber"));
        info.setBgPeriod(pInfo);
        BgElementInfo eInfo = new BgElementInfo();
        eInfo.setId(BOSUuid.read((String)res.getString("FBgELementID")));
        eInfo.setNumber(res.getString("eNumber"));
        info.setBgELement(eInfo);
        CurrencyInfo cInfo = new CurrencyInfo();
        cInfo.setId(BOSUuid.read((String)res.getString("FCurrencyID")));
        cInfo.setNumber(res.getString("cNumber"));
        info.setCurrency(cInfo);
        return info;
    }

    private IBgDecomposeManager getDecomposeDataInterFace(Context ctx) throws BOSException {
        return BgDecomposeManagerFactory.getLocalInstance(ctx);
    }

    private Map<Integer, Map<String, String>> getOrgIdSetOfExists(Context ctx, BgDecomposeFormInfo bgDecomposeInfo, BgOrgUnitCollection bgOrgUnitCollection, BgTemplateInfo bgTemplate, BgPeriodInfo bgPeriod, BgVersionInfo bgVersion, CurrencyInfo currency, int processType) throws BOSException, EASBizException {
        IBgDecomposeFacade localInstance = this.getInterface4Decomposition(ctx);
        Map orgIdOfExistBgform = null;
        orgIdOfExistBgform = localInstance.checkExistsForm((IObjectValue)bgDecomposeInfo, DimensionCommonHelper.getValues((Object)bgOrgUnitCollection), DimensionCommonHelper.getValues(bgTemplate), DimensionCommonHelper.getValues(bgPeriod), DimensionCommonHelper.getValues(bgVersion), DimensionCommonHelper.getValues(currency), processType, false);
        return orgIdOfExistBgform;
    }

    private Map<Integer, Map<String, String>> getOrgIdSetOfExistsByOrg(Context ctx, BgDecomposeFormInfo bgDecomposeInfo, BgOrgUnitCollection bgOrgUnitCollection, BgTemplateInfo bgTemplate, BgPeriodInfo bgPeriod, BgVersionInfo bgVersion, CurrencyInfo currency) throws BOSException, EASBizException {
        IBgDecomposeFacade localInstance = this.getInterface4Decomposition(ctx);
        Map orgIdOfExistBgform = null;
        orgIdOfExistBgform = localInstance.checkExistsForm((IObjectValue)bgDecomposeInfo, DimensionCommonHelper.getValues((Object)bgOrgUnitCollection), DimensionCommonHelper.getValues(bgTemplate), DimensionCommonHelper.getValues(bgPeriod), DimensionCommonHelper.getValues(bgVersion), DimensionCommonHelper.getValues(currency), 0, true);
        return orgIdOfExistBgform;
    }

    private IBgDecomposeFacade getInterface4Decomposition(Context ctx) throws BOSException {
        return BgDecomposeFacadeFactory.getLocalInstance(ctx);
    }

    private BgOrgUnitCollection getBgOrgUnitColl(Context ctx, BgDecomposeFormInfo bgDecomposeInfo, String bgOrgViewId) throws BOSException {
        BgDecomposeRefOrgUnitCollection refOrgUnit = bgDecomposeInfo.getRefOrgUnit();
        if (refOrgUnit == null || refOrgUnit.size() == 0) {
            return null;
        }
        HashSet<String> orgIdSet = new HashSet<String>();
        for (int i = 0; i < refOrgUnit.size(); ++i) {
            BgDecomposeRefOrgUnitInfo bgDecomposeRefOrgUnitInfo = refOrgUnit.get(i);
            BOSUuid orgUnitID = bgDecomposeRefOrgUnitInfo.getOrgUnitID();
            if (orgUnitID == null || StringUtils.isEmpty((String)orgUnitID.toString())) continue;
            orgIdSet.add(orgUnitID.toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitID", orgIdSet, CompareType.INCLUDE));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)false, CompareType.EQUALS));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("isVirtual", (Object)false, CompareType.EQUALS));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("viewID", (Object)bgOrgViewId));
        BgOrgUnitCollection bgOrgUnitCollection = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(viewInfo);
        return bgOrgUnitCollection;
    }

    private Map<String, BgFormInfo> getBgFromConllection(Set<String> formIds, Context ctx, Map<String, BgOrgUnitInfo> orgMap) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        viewInfo.setSelector(this.getSelectors4BgForm());
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("id", formIds, CompareType.INCLUDE));
        BgFormCollection bgFormCollection = this.getBgFormInstance(ctx).getBgFormCollection(viewInfo);
        if (bgFormCollection == null || bgFormCollection.isEmpty()) {
            return null;
        }
        HashMap<String, BgFormInfo> bgFormMap = new HashMap<String, BgFormInfo>();
        for (int i = 0; i < bgFormCollection.size(); ++i) {
            BgFormInfo formInfo = bgFormCollection.get(i);
            if (!orgMap.containsKey(formInfo.getOrgUnit().getId().toString())) continue;
            if (orgMap.get(formInfo.getOrgUnit().getId().toString()).isIsLeaf()) {
                if (BgProcessEnum.C02.equals((Object)formInfo.getProcessType())) continue;
                bgFormMap.put(formInfo.getOrgUnit().getId().toString(), formInfo);
                continue;
            }
            if (orgMap.get(formInfo.getOrgUnit().getId().toString()).isIsLeaf() || BgProcessEnum.C01.equals((Object)formInfo.getProcessType())) continue;
            bgFormMap.put(formInfo.getOrgUnit().getId().toString(), formInfo);
        }
        return bgFormMap;
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bgScheme.id");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("orgUnit.longnumber");
        sic.add("orgUnit.simplename");
        sic.add("orgUnit.level");
        sic.add("isAssign");
        sic.add("isAssignData");
        sic.add("decomposeUser.id");
        sic.add("decomposeUser.name");
        sic.add("decomposeUser.number");
        sic.add("decomposeTime");
        sic.add("assignUser.id");
        sic.add("assignUser.number");
        sic.add("assignUser.name");
        sic.add("assignTime");
        sic.add("refOrgUnit.*");
        sic.add("bgForm.*");
        sic.add("bgForm.orgUnit.id");
        sic.add("bgForm.orgUnit.name");
        sic.add("bgForm.orgUnit.number");
        sic.add("bgForm.orgUnit.longnumber");
        sic.add("bgForm.orgUnit.simplename");
        sic.add("bgForm.orgUnit.level");
        sic.add("bgForm.company.id");
        sic.add("bgForm.company.name");
        sic.add("bgForm.company.number");
        sic.add("bgForm.bgScheme.id");
        sic.add("bgForm.bgScheme.name");
        sic.add("bgForm.bgScheme.number");
        sic.add("bgForm.bgScheme.period");
        sic.add("bgForm.bgScheme.isFormal");
        sic.add("bgForm.bgScheme.refCube");
        sic.add("bgForm.bgScheme.dateFrom");
        sic.add("bgForm.bgScheme.dateTo");
        sic.add("bgForm.bgTemplate.id");
        sic.add("bgForm.bgTemplate.name");
        sic.add("bgForm.bgTemplate.number");
        sic.add("bgForm.bgTemplate.formType");
        sic.add("bgForm.bgTemplate.bgType");
        sic.add("bgForm.bgTemplate.styleSet.id");
        sic.add("bgForm.bgTemplate.styleSet.number");
        sic.add("bgForm.bgTemplate.styleSet.name");
        sic.add("bgForm.bgTemplate.styleSet.data");
        sic.add("bgForm.bgTemplate.styleSet.isSysDefault");
        sic.add("bgForm.bgTemplate.styleSet.defaultMeasureUnit");
        sic.add("bgForm.bgTemplate.styleSet.lastUpdateTime");
        sic.add("bgForm.bgTemplate.styleSet.bgMeasureUnit");
        sic.add("bgForm.bgTemplate.data");
        sic.add("bgForm.bgTemplate.bgScheme.id");
        sic.add("bgForm.processType");
        sic.add("bgForm.entries.id");
        sic.add("bgForm.entries.bgformid");
        sic.add("bgForm.entries.dimensionData");
        sic.add("bgForm.entries.dimensionStyle");
        sic.add("bgForm.bgSpecialItems.*");
        sic.add("bgForm.bgPeriod.id");
        sic.add("bgForm.bgPeriod.name");
        sic.add("bgForm.bgPeriod.number");
        sic.add("bgForm.bgPeriod.periodType");
        sic.add("bgForm.bgVersion.id");
        sic.add("bgForm.bgVersion.name");
        sic.add("bgForm.bgVersion.number");
        sic.add("bgForm.bgVersion.versionId");
        sic.add("bgForm.currency.id");
        sic.add("bgForm.currency.name");
        sic.add("bgForm.currency.number");
        return sic;
    }

    private SelectorItemCollection getSelectors4BgDecomposeFormManager() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("bgPeriod.*");
        sic.add("bgELement.*");
        sic.add("currency.*");
        return sic;
    }

    private SelectorItemCollection getSelectors4BgForm() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("orgUnit.longnumber");
        sic.add("orgUnit.simplename");
        sic.add("orgUnit.level");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.number");
        sic.add("bgScheme.id");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("bgScheme.period");
        sic.add("bgScheme.isFormal");
        sic.add("bgScheme.refCube");
        sic.add("bgScheme.dateFrom");
        sic.add("bgScheme.dateTo");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.name");
        sic.add("bgTemplate.number");
        sic.add("bgTemplate.formType");
        sic.add("bgTemplate.bgType");
        sic.add("bgTemplate.styleSet.id");
        sic.add("bgTemplate.styleSet.number");
        sic.add("bgTemplate.styleSet.name");
        sic.add("bgTemplate.styleSet.data");
        sic.add("bgTemplate.styleSet.isSysDefault");
        sic.add("bgTemplate.styleSet.defaultMeasureUnit");
        sic.add("bgTemplate.styleSet.lastUpdateTime");
        sic.add("bgTemplate.styleSet.bgMeasureUnit");
        sic.add("bgTemplate.data");
        sic.add("bgTemplate.bgScheme.id");
        sic.add("processType");
        sic.add("entries.id");
        sic.add("entries.bgformid");
        sic.add("entries.dimensionData");
        sic.add("entries.dimensionStyle");
        sic.add("bgSpecialItems.*");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.periodType");
        sic.add("bgVersion.id");
        sic.add("bgVersion.name");
        sic.add("bgVersion.number");
        sic.add("bgVersion.versionId");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        return sic;
    }

    private boolean isDiffLayout(BgFormInfo curbgForm, BgFormInfo existsBgForm, Context ctx, IMbgViewBase curbgFormView, IMbgViewBase existsFormView) throws EASBizException, BOSException {
        if (curbgForm == null || existsBgForm == null || ctx == null || !curbgForm.getBgTemplate().getId().equals((Object)existsBgForm.getBgTemplate().getId())) {
            return false;
        }
        BgTemFormTypeEnum formType = curbgForm.getFormType();
        if (BgTemFormTypeEnum.VIEWFORM.equals((Object)formType)) {
            IMbgViewManager curView = (IMbgViewManager)curbgFormView;
            IMbgViewManager existsView = (IMbgViewManager)existsFormView;
            return DimensionCommonHelper.isDifferenceNotOrder(curView, existsView, -1);
        }
        if (BgTemFormTypeEnum.VIEWLIST.equals((Object)formType)) {
            MbgViewListManager curViewlistView = (MbgViewListManager)curbgFormView;
            MbgViewListManager existsViewlistView = (MbgViewListManager)existsFormView;
            return DimensionCommonHelper.isDifferenceNotOrder(curViewlistView, existsViewlistView, -1);
        }
        return false;
    }

    private void updateMbgViewManager(Context ctx, MbgViewListManager curViewlistView, MbgViewListManager existsViewlistView, IObjectValue sourceOrgUnitInfo, IObjectValue targetOrgUnitInfo, Map<String, Set<String>> formulaValues, BgSchemeDimensionHelper bgSchemeHelper) throws BOSException {
        try {
            List sourceSheetManagers = curViewlistView.getSheetManagers();
            List targetSheetManagers = existsViewlistView.getSheetManagers();
            List sourcePageDimension = null;
            List<IMbgViewListObject> sourceRowDimension = null;
            List<IMbgViewListObject> sourceColDimension = null;
            List targetPageDimension = null;
            List<IMbgViewListObject> targetRowDimension = null;
            List<IMbgViewListObject> targetColDimension = null;
            List<MbgRelationMap> sourcePageRelationMaps = null;
            List<MbgRelationMap> targetPageRelationMaps = null;
            List sourceDimensions = null;
            List targetDimensions = null;
            List sourceRowDimensions = null;
            List sourceColDimensions = null;
            List targetRowDimensions = null;
            List targetColDimensions = null;
            for (int i = 0; i < sourceSheetManagers.size(); ++i) {
                sourcePageDimension = ((MbgViewListSheetManager)sourceSheetManagers.get(i)).getDimensionManager().getPageDimension();
                sourceRowDimensions = ((MbgViewListSheetManager)sourceSheetManagers.get(i)).getDimensionManager().getRowDimension();
                sourceColDimensions = ((MbgViewListSheetManager)sourceSheetManagers.get(i)).getDimensionManager().getColDimension();
                sourceRowDimension = ((MbgViewListSheetManager)sourceSheetManagers.get(i)).getDimensionManager().getRows();
                sourceColDimension = ((MbgViewListSheetManager)sourceSheetManagers.get(i)).getDimensionManager().getColumns();
                targetPageDimension = ((MbgViewListSheetManager)targetSheetManagers.get(i)).getDimensionManager().getPageDimension();
                targetRowDimensions = ((MbgViewListSheetManager)targetSheetManagers.get(i)).getDimensionManager().getRowDimension();
                targetColDimensions = ((MbgViewListSheetManager)targetSheetManagers.get(i)).getDimensionManager().getColDimension();
                targetRowDimension = ((MbgViewListSheetManager)targetSheetManagers.get(i)).getDimensionManager().getRows();
                targetColDimension = ((MbgViewListSheetManager)targetSheetManagers.get(i)).getDimensionManager().getColumns();
                sourcePageRelationMaps = ((MbgViewListSheetManager)sourceSheetManagers.get(i)).getDimensionManager().getPageRelationMaps();
                sourceDimensions = ((MbgViewListSheetManager)sourceSheetManagers.get(i)).getDimensionManager().getDimension();
                targetDimensions = ((MbgViewListSheetManager)targetSheetManagers.get(i)).getDimensionManager().getDimension();
                targetPageRelationMaps = ((MbgViewListSheetManager)targetSheetManagers.get(i)).getDimensionManager().getPageRelationMaps();
                this.updateSortDimension(sourceDimensions, targetDimensions);
                this.updateSortDimension(sourcePageDimension, targetPageDimension);
                this.updateSortDimension(sourceRowDimensions, targetRowDimensions);
                this.updateSortDimension(sourceColDimensions, targetColDimensions);
                this.updatePageDimension(ctx, sourcePageDimension, targetPageDimension, sourcePageRelationMaps, targetPageRelationMaps, targetOrgUnitInfo, formulaValues, bgSchemeHelper);
                this.updateRowDimension(ctx, sourceRowDimension, targetRowDimension, sourceOrgUnitInfo, targetOrgUnitInfo, formulaValues, bgSchemeHelper);
                this.updateColDimension(ctx, sourceColDimension, targetColDimension, sourceOrgUnitInfo, targetOrgUnitInfo, formulaValues, bgSchemeHelper);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void updateSortDimension(List sourceDimensions, List targetDimensions) {
        MbgViewListDimensionInfo templateDimensionInfo = null;
        MbgViewListDimensionInfo formDimensionInfo = null;
        Object tempDimensionInfo = null;
        Object templateAtribute = null;
        Object formAtribute = null;
        Object temp = null;
        ArrayList newFormDimensions = new ArrayList();
        for (int i = 0; i < sourceDimensions.size(); ++i) {
            if (sourceDimensions.get(i) instanceof MbgViewListAtribute) {
                newFormDimensions.add(sourceDimensions.get(i));
                continue;
            }
            if (!(sourceDimensions.get(i) instanceof MbgViewListDimensionInfo)) continue;
            templateDimensionInfo = (MbgViewListDimensionInfo)sourceDimensions.get(i);
            for (int j = 0; j < targetDimensions.size(); ++j) {
                if (!(targetDimensions.get(j) instanceof MbgViewListDimensionInfo)) continue;
                formDimensionInfo = (MbgViewListDimensionInfo)targetDimensions.get(j);
                if (templateDimensionInfo.getNumber().equalsIgnoreCase(formDimensionInfo.getNumber())) break;
            }
            newFormDimensions.add(formDimensionInfo);
        }
        targetDimensions.clear();
        targetDimensions.addAll(newFormDimensions);
    }

    private void updatePageDimension(Context ctx, List templatePageDimension, List formPageDimension, List templatePageRelationMaps, List formPageRelationMaps, IObjectValue orgUnitInfo, Map<String, Set<String>> formulaValues, BgSchemeDimensionHelper bgSchemeHelper) {
        this.updateRelationMap(ctx, templatePageDimension, formPageDimension, templatePageRelationMaps, formPageRelationMaps, orgUnitInfo, formulaValues, bgSchemeHelper);
    }

    private void updateRelationMap(Context ctx, List sourceDimensions, List targetDimensions, List sourceRelationMaps, List targetRelationMaps, IObjectValue orgUnitInfo, Map<String, Set<String>> formulaValues, BgSchemeDimensionHelper bgSchemeHelper) {
        MbgViewListDimensionInfo sourceDimensionInfo = null;
        MbgViewListDimensionInfo targetDimensionInfo = null;
        Object tempDimensionInfo = null;
        Map<String, BgDimensionInfo> dimensionBySrcNumbers = bgSchemeHelper.getDimensionBySrcNumber();
        for (int i = 0; i < sourceDimensions.size(); ++i) {
            sourceDimensionInfo = (MbgViewListDimensionInfo)sourceDimensions.get(i);
            targetDimensionInfo = (MbgViewListDimensionInfo)targetDimensions.get(i);
            if (!sourceDimensionInfo.getMemberValueType().equals((Object)targetDimensionInfo.getMemberValueType())) {
                return;
            }
            if (DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(sourceDimensionInfo.getNumber())) continue;
            if (sourceDimensionInfo.getMemberValueType().equals((Object)DimensionMemberValueModeEnum.Null) || sourceDimensionInfo.getMemberValueType().equals((Object)DimensionMemberValueModeEnum.SelectMember)) {
                targetDimensionInfo.getMember().addAll(this.getOnlyInfo(sourceDimensionInfo.getMember(), targetDimensionInfo.getMember(), formulaValues != null ? formulaValues.get(targetDimensionInfo.getNumber()) : null));
                targetDimensionInfo.getSelectMembers().addAll(this.getOnlyInfo(sourceDimensionInfo.getSelectMembers(), targetDimensionInfo.getSelectMembers(), formulaValues != null ? formulaValues.get(targetDimensionInfo.getNumber()) : null));
                targetDimensionInfo.getCanAddMember().addAll(this.getOnlyInfo(sourceDimensionInfo.getCanAddMember(), targetDimensionInfo.getCanAddMember(), formulaValues != null ? formulaValues.get(targetDimensionInfo.getNumber()) : null));
                continue;
            }
            if (sourceDimensionInfo.getMemberValueType().equals((Object)DimensionMemberValueModeEnum.RelationMapping)) {
                int j;
                int m;
                MbgRelationMap sourceMbgRelationMap = null;
                Object targetMbgRelationMap = null;
                DimRelashipGroupEntryCollection sourceEntries = null;
                Object targetEntries = null;
                DimensionRelationshipCollection sourceRelationShips = null;
                DimensionRelationshipCollection targetRelationShips = null;
                DimensionRelationshipCollection dimRelationCol = null;
                HashSet<String> relationDimensionNumber = new HashSet<String>();
                boolean isFillWhereNull = false;
                for (m = 0; m < sourceRelationMaps.size(); ++m) {
                    sourceMbgRelationMap = (MbgRelationMap)sourceRelationMaps.get(m);
                    sourceEntries = sourceMbgRelationMap.getGroup().getEntries();
                    for (int n = 0; n < sourceEntries.size(); ++n) {
                        if (!sourceEntries.get(n).getDimNumber().equals(sourceDimensionInfo.getNumber())) continue;
                        sourceRelationShips = sourceMbgRelationMap.getRelationShips();
                        isFillWhereNull = sourceMbgRelationMap.isFillWhereNull();
                        break;
                    }
                    if (sourceRelationShips != null) break;
                }
                targetRelationShips = this.getRelationshipCollection(targetRelationMaps, targetDimensionInfo);
                try {
                    if (sourceMbgRelationMap != null) {
                        DimensionMemberRelationShipHelper shipHelper = DimensionFormulaFacadeFactory.getLocalInstance(ctx).buildRelationHelper(sourceMbgRelationMap.getGroup().getId().toString(), orgUnitInfo.get("id").toString(), null);
                        if (shipHelper == null || shipHelper.getGroup() == null) {
                            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.ma.mbg.TemplateResource", (String)"selectRelation")));
                        }
                        dimRelationCol = shipHelper.getCol();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                }
                if (dimRelationCol == null) {
                    return;
                }
                for (m = 0; m < dimRelationCol.size(); ++m) {
                    relationDimensionNumber.add(dimRelationCol.get(m).getDimensionNumber());
                }
                if (sourceRelationShips != null && sourceRelationShips.size() == 0 && isFillWhereNull) {
                    if (dimRelationCol == null) {
                        return;
                    }
                    for (j = 0; j < dimRelationCol.size(); ++j) {
                        if (targetRelationShips.contains(dimRelationCol.get(j))) continue;
                        targetRelationShips.add(dimRelationCol.get(j));
                    }
                    continue;
                }
                if (sourceRelationShips == null || sourceRelationShips.size() <= 0) continue;
                block7: for (j = 0; j < sourceRelationShips.size(); ++j) {
                    int m2 = 0;
                    for (m2 = 0; m2 < targetRelationShips.size() && !sourceRelationShips.get(j).getDimensionNumber().equals(targetRelationShips.get(m2).getDimensionNumber()); ++m2) {
                    }
                    if (m2 != targetRelationShips.size() || !relationDimensionNumber.contains(sourceRelationShips.get(j).getDimensionNumber())) continue;
                    String dimensionNumber = sourceRelationShips.get(j).getDimensionNumber();
                    String[] splits = dimensionNumber.split(",");
                    for (int k = 0; k < splits.length; ++k) {
                        String dimNumber = splits[k];
                        if (StringUtils.isEmpty((String)dimNumber)) continue;
                        String[] sn = dimNumber.split(":");
                        BgDimensionInfo dimensionInfo = dimensionBySrcNumbers.get(sn[0]);
                        if (formulaValues == null) break;
                        if (formulaValues.get(dimensionInfo.getNumber()) != null && !formulaValues.get(dimensionInfo.getNumber()).contains(sn[1])) continue block7;
                    }
                    targetRelationShips.add(sourceRelationShips.get(j));
                }
                continue;
            }
            if (!sourceDimensionInfo.getMemberValueType().equals((Object)DimensionMemberValueModeEnum.Manual)) continue;
            targetDimensionInfo.getCanAddMember().addAll(this.getOnlyInfo(sourceDimensionInfo.getCanAddMember(), targetDimensionInfo.getCanAddMember(), formulaValues != null ? formulaValues.get(sourceDimensionInfo.getNumber()) : null));
        }
    }

    private void updateRowDimension(Context ctx, List sourceRowDimension, List targetRowDimension, IObjectValue sourceOrgUnitInfo, IObjectValue targetOrgUnitInfo, Map<String, Set<String>> formulaValues, BgSchemeDimensionHelper bgSchemeHelper) {
        List<MbgViewListDimensionInfo> sourceDimensions = null;
        List<MbgViewListDimensionInfo> targetDimensions = null;
        List<MbgRelationMap> sourceRowRelationMaps = null;
        List<MbgRelationMap> targetRowRelationMaps = null;
        MbgViewListRowCol sourceMbgViewListRowCol = null;
        MbgViewListRowCol targetMbgViewListRowCol = null;
        FullOrgUnitInfo sourceOrg = (FullOrgUnitInfo)sourceOrgUnitInfo;
        FullOrgUnitInfo targetOrg = (FullOrgUnitInfo)targetOrgUnitInfo;
        String targetOrgId = targetOrg.getId().toString();
        String targetOrgNumber = targetOrg.getNumber();
        String targetOrgName = targetOrg.getName();
        Map<Integer, Object> rowCols = this.dealBefore(sourceRowDimension, targetRowDimension);
        String sourceLongNumber = sourceOrg.getLongNumber();
        block0: for (int i = 0; i < sourceRowDimension.size(); ++i) {
            if (!(sourceRowDimension.get(i) instanceof MbgViewListRowCol)) continue;
            sourceMbgViewListRowCol = (MbgViewListRowCol)sourceRowDimension.get(i);
            sourceRowRelationMaps = sourceMbgViewListRowCol.getRelationMaps();
            sourceDimensions = sourceMbgViewListRowCol.getDimensions();
            for (int j = 0; j < sourceDimensions.size(); ++j) {
                if (!MBGLayoutConstants.BG_ORGANIZATION.equals(sourceDimensions.get(j).getNumber())) continue;
                List members = sourceDimensions.get(j).getMember();
                if (members == null || members.isEmpty()) break block0;
                for (int k = 0; k < members.size(); ++k) {
                    BgDimensionMember member = (BgDimensionMember)members.get(k);
                    if (member != null && MBGLayoutConstants.BG_ORGANIZATION.equals(member.getType()) && !member.getSortValue().equals(sourceLongNumber)) break block0;
                }
            }
            if (!(targetRowDimension.get(i) instanceof MbgViewListRowCol)) continue;
            targetMbgViewListRowCol = (MbgViewListRowCol)targetRowDimension.get(i);
            targetDimensions = targetMbgViewListRowCol.getDimensions();
            targetRowRelationMaps = targetMbgViewListRowCol.getRelationMaps();
            this.updateRelationMap(ctx, sourceDimensions, targetDimensions, sourceRowRelationMaps, targetRowRelationMaps, targetOrgUnitInfo, formulaValues, bgSchemeHelper);
            List<BgDimensionMember> changeSelectMembers = this.dealCombMem(targetOrgId, targetOrgNumber, targetOrgName, sourceMbgViewListRowCol.getCombinSelectMembers(), formulaValues);
            targetMbgViewListRowCol.getCombinSelectMembers().addAll(this.getOnlyInfo(changeSelectMembers, targetMbgViewListRowCol.getCombinSelectMembers(), null));
            List<BgDimensionMember> changeComMembers = this.dealCombMem(targetOrgId, targetOrgNumber, targetOrgName, sourceMbgViewListRowCol.getCombinMembers(), formulaValues);
            targetMbgViewListRowCol.getCombinMembers().addAll(this.getOnlyInfo(changeComMembers, targetMbgViewListRowCol.getCombinMembers(), null));
        }
        this.dealAfter(targetRowDimension, rowCols);
    }

    private void dealAfter(List targetRowDimension, Map<Integer, Object> rowCols) {
        if (!rowCols.isEmpty()) {
            for (Map.Entry<Integer, Object> entry : rowCols.entrySet()) {
                targetRowDimension.add(entry.getKey(), entry.getValue());
            }
        }
    }

    private Map<Integer, Object> dealBefore(List sourceRowDimension, List targetRowDimension) {
        HashMap<Integer, Object> rowCols = new HashMap<Integer, Object>();
        for (int i = 0; i < targetRowDimension.size(); ++i) {
            if (targetRowDimension.get(i) instanceof MbgViewListRowCol) continue;
            rowCols.put(i, targetRowDimension.get(i));
        }
        Iterator iterator = targetRowDimension.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof MbgViewListRowCol) continue;
            iterator.remove();
        }
        iterator = sourceRowDimension.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof MbgViewListRowCol) continue;
            iterator.remove();
        }
        return rowCols;
    }

    private List<BgDimensionMember> dealCombMem(String targetOrgId, String targetOrgNumber, String targetOrgName, List<BgDimensionMember> combinMembers, Map<String, Set<String>> formulaValues) {
        ArrayList<BgDimensionMember> tempMembers = new ArrayList<BgDimensionMember>(combinMembers);
        if (tempMembers == null || tempMembers.size() == 0) {
            return tempMembers;
        }
        Iterator iter = tempMembers.iterator();
        while (iter.hasNext()) {
            BgDimensionMember bgDimensionMember = (BgDimensionMember)iter.next();
            if (bgDimensionMember == null) continue;
            String type = bgDimensionMember.getType();
            String name = bgDimensionMember.getName();
            String attribute = bgDimensionMember.getAttribute();
            String number = bgDimensionMember.getNumber();
            String[] splitType = type.split(",");
            String[] splitName = name.split(DimensionConstants.TICK_SEPARATOR);
            String[] splitAttribute = attribute.split(",");
            String[] splitNumber = number.split(",");
            if (splitType == null || splitType.length == 0) {
                return tempMembers;
            }
            for (int k = 0; k < splitType.length; ++k) {
                if (splitType[k] != null && DimensionConstants.DEF_ORGUNIT_NUMBER.equals(splitType[k])) {
                    splitName[k] = targetOrgName;
                    splitAttribute[k] = targetOrgId;
                    splitNumber[k] = targetOrgNumber;
                    continue;
                }
                if (k >= splitNumber.length || formulaValues == null || !formulaValues.containsKey(splitType[k]) || formulaValues.get(splitType[k]).contains(splitNumber[k])) continue;
                iter.remove();
                break;
            }
            bgDimensionMember.setAttribute(this.getCombString(splitAttribute, ","));
            bgDimensionMember.setName(this.getCombString(splitName, DimensionConstants.TICK_SEPARATOR));
            bgDimensionMember.setNumber(this.getCombString(splitNumber, ","));
        }
        return tempMembers;
    }

    private String getCombString(String[] split, String mark) {
        String combString = "";
        if (split == null || split.length == 0) {
            return "";
        }
        for (int i = 0; i < split.length; ++i) {
            combString = i == split.length - 1 ? combString + split[i] : combString + split[i] + mark;
        }
        return combString;
    }

    private void updateColDimension(Context ctx, List sourceColDimension, List targetColDimension, IObjectValue sourceOrgUnitInfo, IObjectValue targetOrgUnitInfo, Map<String, Set<String>> formulaValues, BgSchemeDimensionHelper bgSchemeHelper) {
        List<MbgViewListDimensionInfo> sourceDimensions = null;
        List<MbgViewListDimensionInfo> targetDimensions = null;
        List<MbgRelationMap> sourceRowRelationMaps = null;
        List<MbgRelationMap> targetRowRelationMaps = null;
        FullOrgUnitInfo sourceOrg = (FullOrgUnitInfo)sourceOrgUnitInfo;
        String sourceLongNumber = sourceOrg.getLongNumber();
        Map<Integer, Object> rowCols = this.dealBefore(sourceColDimension, targetColDimension);
        block0: for (int i = 0; i < sourceColDimension.size(); ++i) {
            if (!(sourceColDimension.get(i) instanceof MbgViewListRowCol)) continue;
            sourceDimensions = ((MbgViewListRowCol)sourceColDimension.get(i)).getDimensions();
            sourceRowRelationMaps = ((MbgViewListRowCol)sourceColDimension.get(i)).getRelationMaps();
            for (int j = 0; j < sourceDimensions.size(); ++j) {
                if (!MBGLayoutConstants.BG_ORGANIZATION.equals(sourceDimensions.get(j).getNumber())) continue;
                List members = sourceDimensions.get(j).getMember();
                if (members == null || members.isEmpty()) break block0;
                for (int k = 0; k < members.size(); ++k) {
                    BgDimensionMember member = (BgDimensionMember)members.get(k);
                    if (member != null && MBGLayoutConstants.BG_ORGANIZATION.equals(member.getType()) && !member.getSortValue().equals(sourceLongNumber)) break block0;
                }
            }
            if (!(sourceColDimension.get(i) instanceof MbgViewListRowCol)) continue;
            targetDimensions = ((MbgViewListRowCol)targetColDimension.get(i)).getDimensions();
            targetRowRelationMaps = ((MbgViewListRowCol)targetColDimension.get(i)).getRelationMaps();
            this.updateRelationMap(ctx, sourceDimensions, targetDimensions, sourceRowRelationMaps, targetRowRelationMaps, targetOrgUnitInfo, formulaValues, bgSchemeHelper);
        }
        this.dealAfter(targetColDimension, rowCols);
    }

    public List getOnlyInfo(List sourceInfos, List targetInfos, Set<String> filterNumbers) {
        ArrayList result = new ArrayList();
        HashSet<String> formNumbers = new HashSet<String>();
        HashMap<String, String> type_numbers = new HashMap<String, String>();
        for (int i = 0; i < targetInfos.size(); ++i) {
            formNumbers.add(this.buildFormula(type_numbers, targetInfos.get(i)));
        }
        for (int j = 0; j < sourceInfos.size(); ++j) {
            Object o = sourceInfos.get(j);
            String sFormula = this.buildFormula(type_numbers, o);
            if (filterNumbers != null && !filterNumbers.contains(BgViewHelper.getNumber(o)) || formNumbers.contains(sFormula)) continue;
            result.add(o);
        }
        return result;
    }

    private String buildFormula(Map<String, String> type_numbers, Object object) {
        type_numbers.clear();
        if (object instanceof BgDimensionMember) {
            BgDimensionMember m = (BgDimensionMember)object;
            if (StringUtils.isEmpty((String)m.getNumber())) {
                return "";
            }
            String[] numbers = m.getNumber().split(",");
            Object[] types = m.getType().split(",");
            for (int i = 0; i < types.length; ++i) {
                if (i > numbers.length - 1) continue;
                type_numbers.put((String)types[i], numbers[i]);
            }
            Arrays.sort(types);
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < types.length; ++i) {
                if (i > 0) {
                    result.append(",");
                }
                result.append(type_numbers.get(types[i]));
            }
            return result.toString();
        }
        return BgViewHelper.getNumber(object);
    }

    public DimensionRelationshipCollection getRelationshipCollection(List mbgRelationMaps, MbgViewListDimensionInfo DimensionInfo2) {
        MbgRelationMap mbgRelationMap = null;
        DimRelashipGroupEntryCollection dimRelashipEntries = null;
        DimensionRelationshipCollection relationShips = null;
        for (int m = 0; m < mbgRelationMaps.size(); ++m) {
            mbgRelationMap = (MbgRelationMap)mbgRelationMaps.get(m);
            dimRelashipEntries = mbgRelationMap.getGroup().getEntries();
            for (int n = 0; n < dimRelashipEntries.size(); ++n) {
                if (!dimRelashipEntries.get(n).getDimNumber().equals(DimensionInfo2.getNumber())) continue;
                relationShips = mbgRelationMap.getRelationShips();
                break;
            }
            if (relationShips != null) break;
        }
        return relationShips;
    }

    public Map<String, Set<String>> getFormulaValuesByDecompose(Context ctx, BgDecomposeFormInfo info) throws BOSException {
        HashMap<String, Set<String>> formulas = new HashMap<String, Set<String>>();
        BgDecomposeManagerCollection decomposeManagers = this.getDecomposeDataInterFace(ctx).getBgDecomposeManagerCollection("select orgUnit,formula where bgDecompForm.id ='" + info.getId().toString() + "'");
        for (int i = 0; i < decomposeManagers.size(); ++i) {
            BgDecomposeManagerInfo bgDecomposeManagerInfo = decomposeManagers.get(i);
            String orgId = bgDecomposeManagerInfo.getOrgUnit().getId().toString();
            if (!formulas.containsKey(orgId)) {
                formulas.put(orgId, new HashSet());
            }
            ((Set)formulas.get(orgId)).add(bgDecomposeManagerInfo.getFormula());
        }
        return formulas;
    }
}

