/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgElementCollection;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgUpperGatherEnum;
import com.kingdee.eas.ma.base.IBgAccount;
import com.kingdee.eas.ma.base.IMbgMember;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimFactory;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.MbgMemberCollection;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodHelper;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.IBgOrgUnit;
import com.kingdee.eas.ma.mbg.app.AbstractBgDimensionFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDrillParameter;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDrillResult;
import com.kingdee.eas.ma.mbg.dimension.face.IDimension;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.impl.DimDrillResult;
import com.kingdee.eas.ma.mbg.dimension.impl.DimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.vo.DimensionObject;
import com.kingdee.eas.ma.mbg.dimension.vo.MemberObject;
import com.kingdee.eas.ma.mbg.utils.BgCslDimConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgAnalyseUtils;
import com.kingdee.eas.ma.nbudget.face.IBudgetData;
import com.kingdee.eas.ma.nbudget.face.IBudgetPlanParameter;
import com.kingdee.eas.ma.nbudget.face.IMember;
import com.kingdee.eas.ma.nbudget.impl.BudgetData;
import com.kingdee.eas.ma.nbudget.impl.MemberData;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgDimensionFacadeControllerBean
extends AbstractBgDimensionFacadeControllerBean {
    private static final long serialVersionUID = -7419933414203337501L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgDimensionFacadeControllerBean");

    @Override
    protected Object _dimQuery(Context ctx, IDimensionParameter parameter) throws BOSException, EASBizException {
        if (ctx == null || parameter == null) {
            return null;
        }
        parameter.getControlManager().setCheckNullMember(false);
        return this._dimensionQuery(ctx, parameter);
    }

    @Override
    protected void _dimWebQuery(Context ctx, String bgSchemeKey) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)bgSchemeKey)) {
            return;
        }
        MbgAnalyseUtils utils = new MbgAnalyseUtils(ctx);
        utils.setMbgSchemeKey(bgSchemeKey);
        utils.executeQuery();
    }

    @Override
    protected void _dimensionClosure(Context ctx) throws BOSException, EASBizException {
        super._dimensionClosure(ctx);
    }

    @Override
    protected Object _dimensionClosure(Context ctx, IDimensionParameter closureParameter) throws BOSException, EASBizException {
        super._dimensionClosure(ctx, closureParameter);
        return this.checkDimensionClosure(ctx, closureParameter);
    }

    @Override
    protected boolean _dimensionClosure(Context ctx, Map dimensionData, Map itemData) throws BOSException, EASBizException {
        boolean re = super._dimensionClosure(ctx, dimensionData, itemData);
        if (re) {
            re = this.checkDimensionClosure(ctx, dimensionData, itemData);
        }
        return re;
    }

    protected boolean checkDimensionClosure(Context ctx, Map dimensionData, Map itemData) throws BOSException, EASBizException {
        return false;
    }

    private Object checkDimensionClosure(Context ctx, IDimensionParameter closureParameter) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected List<IBudgetData> _bizDimensionQuery(Context ctx, IBudgetPlanParameter queryParameter) throws BOSException, EASBizException {
        ArrayList<IBudgetData> bgDatas;
        block9: {
            bgDatas = new ArrayList<IBudgetData>();
            if (queryParameter == null) {
                return bgDatas;
            }
            IDimensionParameter parameter = this.checkBizBudgetParameter(ctx, queryParameter);
            if (parameter == null) {
                return bgDatas;
            }
            parameter.setValueType(1);
            boolean hasMultiple = false;
            String orgUnitNumber = null;
            IDimension dimension = DimUtils.getOrgUnitDimension(parameter);
            if (dimension.getDimensionMember().size() > 1) {
                hasMultiple = true;
            } else {
                orgUnitNumber = dimension.getDimensionMember().get(0).getNumber();
            }
            Map bgDataMap = (Map)this._dimensionQuery(ctx, parameter);
            if (bgDataMap == null) break block9;
            Map.Entry singleEntry2 = null;
            Map.Entry multipleEntry2 = null;
            Map tmpMap = null;
            String[] params = null;
            IBgNData data = null;
            BudgetData bgData = null;
            Date date = null;
            CalendarHelper helper = new CalendarHelper();
            if (hasMultiple) {
                for (Map.Entry multipleEntry2 : bgDataMap.entrySet()) {
                    orgUnitNumber = (String)multipleEntry2.getKey();
                    tmpMap = (Map)multipleEntry2.getValue();
                    for (Map.Entry singleEntry2 : tmpMap.entrySet()) {
                        params = BgNFSHelper.parseFormulaPara((String)singleEntry2.getKey());
                        data = (IBgNData)singleEntry2.getValue();
                        bgData = new BudgetData();
                        bgData.setOrgUnitNumber(orgUnitNumber);
                        bgData.setItemNumber(params[0]);
                        bgData.setPeriodType(queryParameter.getPeriodType());
                        date = BgNPeriodHelper.getPeriodDate((String)params[1]);
                        bgData.setYear(helper.getCurrentlyYear(date));
                        bgData.setPeriod(helper.getCurrentlyMonth(date));
                        bgData.setBudgetValue(data.getBudgetValue());
                        bgDatas.add((IBudgetData)bgData);
                    }
                }
            } else {
                for (Map.Entry singleEntry2 : bgDataMap.entrySet()) {
                    params = BgNFSHelper.parseFormulaPara((String)singleEntry2.getKey());
                    data = (IBgNData)singleEntry2.getValue();
                    bgData = new BudgetData();
                    bgData.setOrgUnitNumber(orgUnitNumber);
                    bgData.setItemNumber(params[0]);
                    bgData.setPeriodType(queryParameter.getPeriodType());
                    date = BgNPeriodHelper.getPeriodDate((String)params[1]);
                    bgData.setYear(helper.getCurrentlyYear(date));
                    bgData.setPeriod(helper.getCurrentlyMonth(date));
                    bgData.setBudgetValue(data.getBudgetValue());
                    bgDatas.add((IBudgetData)bgData);
                }
            }
        }
        return bgDatas;
    }

    @Override
    protected Map _bizDimensionQuery(Context ctx, IBudgetPlanParameter queryParameter, int valueType) throws BOSException, EASBizException {
        HashMap bgDataMap = new HashMap();
        if (queryParameter == null) {
            return bgDataMap;
        }
        IDimensionParameter parameter = this.checkBizBudgetParameter(ctx, queryParameter);
        if (parameter == null) {
            return bgDataMap;
        }
        parameter.setValueType(valueType);
        return (Map)this._dimensionQuery(ctx, parameter);
    }

    private IDimensionParameter checkBizBudgetParameter(Context ctx, IBudgetPlanParameter parameter) throws BOSException, EASBizException {
        if (parameter == null || parameter.getDimension() == null) {
            return null;
        }
        String orgUnitId = parameter.getOrgUnitId();
        String bgSchemeId = parameter.getBgSchemeId();
        String bgElementId = parameter.getBgElementId();
        String currencyId = parameter.getCurrencyId();
        int periodType = parameter.getPeriodType();
        Date beginDate = parameter.getBeginDate();
        Date endDate = parameter.getEndDate();
        DimensionParameter dimensionParameter = new DimensionParameter();
        dimensionParameter.setOrgUnitId(BOSUuid.read((String)orgUnitId));
        dimensionParameter.setBgSchemeId(BOSUuid.read((String)bgSchemeId));
        BgSchemeInfo scheme = BgViewServerHelper.getBgSchemeInfo(ctx, dimensionParameter.getBgSchemeId());
        dimensionParameter.setBgSchemeId(scheme.getId());
        dimensionParameter.setBgOrgViewId(scheme.getEditOrgViewId());
        MbgDimInfo mbgDim = null;
        MbgDimCollection colls = null;
        HashMap<String, MbgDimInfo> dimMap = new HashMap<String, MbgDimInfo>();
        colls = DimUtils.getDimensionColls(ctx);
        if (colls == null || colls.isEmpty()) {
            return null;
        }
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            mbgDim = colls.get(i);
            dimMap.put(mbgDim.getNumber(), mbgDim);
        }
        boolean hasOrgUnit = false;
        boolean hasPeriod = false;
        boolean hasElement = false;
        boolean hasCurrency = false;
        MemberObject member = null;
        IDimension dimension = null;
        com.kingdee.eas.ma.nbudget.face.IDimension _tmpDim = null;
        List dims = parameter.getDimension();
        int in2 = dims.size();
        for (int i = 0; i < in2; ++i) {
            _tmpDim = (com.kingdee.eas.ma.nbudget.face.IDimension)dims.get(i);
            if (!dimMap.containsKey(_tmpDim.getNumber())) continue;
            mbgDim = (MbgDimInfo)dimMap.get(_tmpDim.getNumber());
            try {
                dimension = this.transDimension(ctx, parameter, _tmpDim, mbgDim);
            }
            catch (Exception ex) {
                logger.error((Object)"bizDimensionQuery transDimension Error:", (Throwable)ex);
            }
            if (dimension == null) continue;
            try {
                DimUtils.transMdxMemberNumber(ctx, dimensionParameter, dimension);
            }
            catch (Exception ex) {
                throw new BOSException((Throwable)ex);
            }
            if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber())) {
                hasOrgUnit = true;
            } else if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber())) {
                hasPeriod = true;
            } else if (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber())) {
                hasElement = true;
            } else if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber())) {
                hasCurrency = true;
            }
            dimensionParameter.getRowDims().add(dimension);
            dimensionParameter.getDimensionMap().put(dimension.getNumber(), dimension);
            if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber()) && dimension.getField() == null) continue;
            try {
                DimUtils.queryItemLongNumber(ctx, dimensionParameter, dimension);
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)"query Member LongNumber Error", (Throwable)ex);
            }
        }
        CostCenterOrgUnitInfo unitInfo = null;
        if (!hasOrgUnit) {
            if (StringUtils.isEmpty((String)orgUnitId)) {
                throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
            }
            unitInfo = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
            if (unitInfo == null) {
                throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
            }
            dimension = new DimensionObject();
            dimension.setNumber(DimensionConstants.DEF_ORGUNIT_NUMBER);
            member = new MemberObject();
            member.setName(unitInfo.getName());
            member.setNumber(unitInfo.getNumber());
            member.setMdxNumber(unitInfo.getLongNumber());
            dimension.getDimensionMember().add(member);
            try {
                DimUtils.transMdxMemberNumber(ctx, dimensionParameter, dimension);
            }
            catch (Exception ex) {
                throw new BOSException((Throwable)ex);
            }
            dimensionParameter.getPageDims().add(dimension);
            dimensionParameter.getDimensionMap().put(dimension.getNumber(), dimension);
        }
        if (!hasPeriod) {
            CalendarHelper helper = new CalendarHelper();
            int year = helper.getCurrentlyYear();
            if (beginDate == null) {
                beginDate = helper.getFirstDayOfYear(year);
            }
            if (endDate == null) {
                endDate = helper.getLastDayOfYear(year);
            }
            BgPeriodInfo bgPeriodInfo = null;
            BgPeriodCollection pColls = BgPeriodHelper.getPeriodColInfo((Context)ctx, (Date)beginDate, (Date)endDate, (int)periodType);
            if (pColls == null || pColls.isEmpty()) {
                throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
            }
            dimension = new DimensionObject();
            dimension.setNumber(DimensionConstants.DEF_PERIOD_NUMBER);
            int in3 = pColls.size();
            for (int i = 0; i < in3; ++i) {
                bgPeriodInfo = pColls.get(i);
                member = new MemberObject();
                member.setName(bgPeriodInfo.getName());
                member.setNumber(bgPeriodInfo.getNumber());
                dimension.getDimensionMember().add(member);
            }
            try {
                DimUtils.transMdxMemberNumber(ctx, dimensionParameter, dimension);
            }
            catch (Exception ex) {
                throw new BOSException((Throwable)ex);
            }
            dimensionParameter.getColDims().add(dimension);
            dimensionParameter.getDimensionMap().put(dimension.getNumber(), dimension);
        }
        if (!hasElement) {
            if (StringUtils.isEmpty((String)bgElementId)) {
                throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
            }
            BgElementInfo bgElementInfo = BgElementFactory.getLocalInstance((Context)ctx).getBgElementInfo((IObjectPK)new ObjectUuidPK(bgElementId));
            if (bgElementInfo == null) {
                throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
            }
            dimension = new DimensionObject();
            dimension.setNumber(DimensionConstants.DEF_ELEMENT_NUMBER);
            member = new MemberObject();
            member.setName(bgElementInfo.getName());
            member.setNumber(bgElementInfo.getNumber());
            dimension.getDimensionMember().add(member);
            dimensionParameter.getPageDims().add(dimension);
            dimensionParameter.getDimensionMap().put(dimension.getNumber(), dimension);
        }
        if (!hasCurrency) {
            CurrencyInfo currencyInfo = null;
            if (StringUtils.isEmpty((String)currencyId)) {
                CompanyOrgUnitInfo companyInfo = null;
                try {
                    companyInfo = BgViewServerHelper.getCompanyFromOrgUnit(ctx, (OrgUnitInfo)unitInfo);
                }
                catch (Exception ex) {
                    throw new BOSException((Throwable)ex);
                }
                if (companyInfo != null) {
                    currencyInfo = companyInfo.getBaseCurrency();
                }
            } else {
                currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            }
            if (currencyInfo == null) {
                throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
            }
            dimension = new DimensionObject();
            dimension.setNumber(DimensionConstants.DEF_CURRENCY_NUMBER);
            member = new MemberObject();
            member.setName(currencyInfo.getName());
            member.setNumber(currencyInfo.getNumber());
            dimension.getDimensionMember().add(member);
            dimensionParameter.getPageDims().add(dimension);
            dimensionParameter.getDimensionMap().put(dimension.getNumber(), dimension);
        }
        return dimensionParameter;
    }

    private IDimension transDimension(Context ctx, IBudgetPlanParameter parameter, com.kingdee.eas.ma.nbudget.face.IDimension dim, MbgDimInfo mbgDim) throws Exception {
        List<com.kingdee.eas.ma.mbg.dimension.face.IMember> members;
        if (dim == null || dim.getNumber() == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        DimensionObject dimension = new DimensionObject();
        dimension.setNumber(dim.getNumber());
        dimension.setField(mbgDim.getRefField());
        if (DimUtils.checkBaseDimension(dim.getNumber())) {
            dimension.setField(null);
        }
        if ((members = this.transMember(ctx, parameter, dim, mbgDim)) != null) {
            dimension.getDimensionMember().addAll(members);
        }
        return dimension;
    }

    private List<com.kingdee.eas.ma.mbg.dimension.face.IMember> transMember(Context ctx, IBudgetPlanParameter parameter, com.kingdee.eas.ma.nbudget.face.IDimension dim, MbgDimInfo mbgDim) throws Exception {
        if (dim == null) {
            return null;
        }
        if (dim.getDimensionMember().isEmpty()) {
            this.checkDimensionMember(ctx, parameter, dim, mbgDim);
        }
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        IMember _member = null;
        ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IMember> members = new ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IMember>();
        int in = dim.getDimensionMember().size();
        for (int i = 0; i < in; ++i) {
            _member = (IMember)dim.getDimensionMember().get(i);
            member = this.transMember(_member);
            if (member == null) continue;
            members.add(member);
        }
        return members;
    }

    private com.kingdee.eas.ma.mbg.dimension.face.IMember transMember(IMember member) {
        if (member == null) {
            return null;
        }
        MemberObject memberObj = new MemberObject();
        memberObj.setSrcNumber(member.getSrcNumber());
        memberObj.setName(member.getName());
        memberObj.setNumber(member.getNumber());
        memberObj.setMdxNumber(member.getLongNumber());
        return memberObj;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkDimensionMember(Context ctx, IBudgetPlanParameter parameter, com.kingdee.eas.ma.nbudget.face.IDimension dim, MbgDimInfo mbgDim) throws Exception {
        BgSchemeInfo root;
        Object rst;
        PreparedStatement pstmt;
        Connection conn;
        String longnumber;
        long time;
        block11: {
            String bgSchemeId;
            block10: {
                if (ctx == null || parameter == null || dim == null || mbgDim == null) {
                    return;
                }
                time = System.currentTimeMillis();
                logger.debug((Object)"begin check use DimNumber!");
                String orgUnitId = parameter.getOrgUnitId();
                bgSchemeId = parameter.getBgSchemeId();
                longnumber = null;
                conn = null;
                pstmt = null;
                rst = null;
                conn = this.getConnection(ctx);
                rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FLongNumber from T_ORG_COSTCENTER where FID = ?", (Object[])new Object[]{orgUnitId});
                if (rst.next()) {
                    longnumber = rst.getString("FLongNumber");
                }
                SQLUtils.cleanup((ResultSet)rst, pstmt);
                if (!StringUtils.isEmpty((String)longnumber)) break block10;
                SQLUtils.cleanup((ResultSet)rst, pstmt, (Connection)conn);
                return;
            }
            root = BgViewServerHelper.getBgSchemeCubeInfo(ctx, BOSUuid.read((String)bgSchemeId));
            if (root != null) break block11;
            SQLUtils.cleanup((ResultSet)rst, pstmt, (Connection)conn);
            return;
        }
        try {
            String[] nums = null;
            HashSet<String> dimNums = new HashSet<String>();
            MemberData _member = null;
            StringBuffer sql = new StringBuffer();
            sql.append("select " + mbgDim.getRefField() + " from " + root.getRefCube() + " where FOrgUnitId in (select fid from T_ORG_CostCenter where FLongNumber like ?) and " + mbgDim.getRefField() + " IS NOT NULL");
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, longnumber + "%");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                if (dimNums.contains(rst.getString(1))) continue;
                dimNums.add(rst.getString(1));
                nums = rst.getString(1).split(":");
                if (nums == null) continue;
                _member = new MemberData();
                _member.setSrcNumber(nums[0]);
                _member.setNumber(nums[1]);
                dim.getDimensionMember().add(_member);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"check Dimension Use Member Erro:", (Throwable)ex);
                throw ex;
                catch (SQLDataException ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        logger.debug((Object)("end check use DimNumber! all use " + (System.currentTimeMillis() - time) + "ms."));
        return;
    }

    @Override
    protected void _bizDimensionUpdate(Context ctx) throws BOSException, EASBizException {
    }

    @Override
    protected IDimDrillResult _dimDrill(Context ctx, IDimDrillParameter parameter, Map isAllMap) throws BOSException, EASBizException {
        DimDrillResult result;
        block145: {
            result = new DimDrillResult();
            result.setDimData(new HashMap<String, Object>());
            if (ctx == null || parameter == null) {
                return result;
            }
            HashSet<String> ignoreLongNums = new HashSet<String>();
            Connection conn = null;
            try {
                Object _obj;
                IDimension cslDimension;
                List<com.kingdee.eas.ma.mbg.dimension.face.IMember> dimensionMember;
                int i;
                ArrayList<BgPeriodInfo> subPeriods;
                ArrayList<Object> subOrgUnits;
                BgSchemeInfo bgSchemeInfo;
                SelectorItemCollection sic;
                block148: {
                    block146: {
                        conn = this.getConnection(ctx);
                        boolean showSeal = parameter.isShowSeal();
                        if (parameter.getCurrBgOrgUnit() != null) {
                            BgOrgUnitInfo ccOrgUnit = (BgOrgUnitInfo)BgOrgUnitFactory.getLocalInstance(ctx).getValue("select id, name, number, longnumber, orgUnitID, level, isleaf, isVirtual, isOUSealUp, polAlgorithm where id = '" + parameter.getCurrBgOrgUnit().getId().toString() + "'");
                            if (ccOrgUnit != null) {
                                if (!showSeal && ccOrgUnit.isIsOUSealUp()) {
                                    IDimDrillResult iDimDrillResult = null;
                                    return iDimDrillResult;
                                }
                                if (ccOrgUnit.getPolAlgorithm().equals((Object)BgUpperGatherEnum.ignore) && parameter.checkNeedIgnore(ccOrgUnit)) {
                                    IDimDrillResult iDimDrillResult = null;
                                    return iDimDrillResult;
                                }
                                result.setCurrOrgUnit(ccOrgUnit);
                            }
                        } else if (parameter.getBgOrgUnit() != null) {
                            result.setCurrOrgUnit(parameter.getBgOrgUnit());
                        }
                        sic = new SelectorItemCollection();
                        bgSchemeInfo = BgViewServerHelper.getBgSchemeInfo(ctx, parameter.getBgSchemeId());
                        if (bgSchemeInfo == null) {
                            DimDrillResult dimDrillResult = result;
                            return dimDrillResult;
                        }
                        if (parameter.hasInit()) {
                            EntityViewInfo view = new EntityViewInfo();
                            FilterInfo filter = new FilterInfo();
                            view.setFilter(filter);
                            sic = new SelectorItemCollection();
                            sic.add("id");
                            sic.add("name");
                            sic.add("number");
                            sic.add("isLeaf");
                            sic.add("longNumber");
                            view.getSelector().addObjectCollection((IObjectCollection)sic);
                            BgPeriodInfo periodInfo = null;
                            BgPeriodCollection colls = BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodCollection(view);
                            if (colls != null) {
                                int in = colls.size();
                                for (int i2 = 0; i2 < in; ++i2) {
                                    periodInfo = colls.get(i2);
                                    result.getSchemePeriodMap().put(periodInfo.getNumber(), periodInfo);
                                }
                            }
                            if (!parameter.getDimDatas().isEmpty()) {
                                String dimNumber22 = null;
                                String srcNumber = null;
                                String number = null;
                                String[] formulaParams = null;
                                String[] dimNums = null;
                                String[] tmpStrs = null;
                                HashMap<String, Set<String>> dimNumberMap = new HashMap<String, Set<String>>();
                                Set<String> dimNumberSet = null;
                                for (String formulaStr : parameter.getDimDatas()) {
                                    formulaParams = BgNFSHelper.parseFormulaPara(formulaStr);
                                    for (String dimNumber22 : formulaParams[0].split(",")) {
                                        tmpStrs = dimNumber22.split(":");
                                        if (tmpStrs == null || tmpStrs.length <= 1) continue;
                                        srcNumber = tmpStrs[0];
                                        number = tmpStrs[1];
                                        if (dimNumberMap.containsKey(srcNumber)) {
                                            dimNumberSet = (Set)dimNumberMap.get(srcNumber);
                                        } else {
                                            dimNumberSet = new HashSet();
                                            dimNumberMap.put(srcNumber, dimNumberSet);
                                        }
                                        dimNumberSet.add(number);
                                    }
                                }
                                result.setLeafDataMap(this.checkDimNumberIsLeaf(conn, dimNumberMap, bgSchemeInfo));
                            }
                        }
                        subOrgUnits = new ArrayList<Object>();
                        if (parameter.getUnionId() == null) {
                            List<BgOrgUnitInfo> tmpSubOrgUnits = this.dealExpendOrgUnit(ctx, parameter, isAllMap, result, ignoreLongNums, conn);
                            for (BgOrgUnitInfo info : tmpSubOrgUnits) {
                                subOrgUnits.add(info.castToFullOrgUnitInfo());
                            }
                        } else {
                            this.dealExpendUnionOrgUnit(ctx, parameter, isAllMap, result, conn);
                            subOrgUnits.addAll(result.getSubUnionOrgUnits());
                            if (!parameter.getQueryUnionOrgUnits().isEmpty()) {
                                subOrgUnits.addAll(parameter.getQueryUnionOrgUnits());
                            }
                        }
                        BgPeriodInfo bgPeriod = null;
                        subPeriods = new ArrayList<BgPeriodInfo>();
                        if (!parameter.hasExpendPeriod()) break block146;
                        bgPeriod = parameter.getQueryPeriods().get(0);
                        IRowSet rst = null;
                        try {
                            StringBuffer sql = new StringBuffer();
                            if (StringUtils.isEmpty((String)bgPeriod.getLongNumber())) {
                                sql.append("select FID, FNumber, FName_" + ctx.getLocale() + ", FLongNumber, FIsLeaf, FPeriodType from T_MBG_BgPeriod where FParentID = ? order by FNumber");
                                rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgPeriod.getId().toString()});
                            } else if (isAllMap.get("isAllPer") instanceof Boolean && ((Boolean)isAllMap.get("isAllPer")).booleanValue()) {
                                sql.append("select FBgPeriodID, FNumber, FName_" + ctx.getLocale() + ", FLongNumber, FIsLeaf, FPeriodType from T_MBG_BgPeriodDisp where FLongNumber like  ? order by FLongNumber");
                                rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgPeriod.getLongNumber() + "!%"});
                            } else {
                                sql.append("select FBgPeriodID, FNumber, FName_" + ctx.getLocale() + ", FLongNumber, FIsLeaf, FPeriodType from T_MBG_BgPeriodDisp where FParentID IN(select FID FROM T_MBG_BgPeriodDisp Where FLongNumber = ?) order by FNumber");
                                rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgPeriod.getLongNumber()});
                            }
                            while (rst.next()) {
                                bgPeriod = new BgPeriodInfo();
                                bgPeriod.setId(BOSUuid.read((String)rst.getString(1)));
                                bgPeriod.setNumber(rst.getString(2));
                                bgPeriod.setName(rst.getString(3));
                                bgPeriod.setLongNumber(rst.getString(4));
                                bgPeriod.setIsLeaf(rst.getBoolean(5));
                                bgPeriod.setPeriodType(BgPeriodEnum.getEnum((int)rst.getInt(6)));
                                subPeriods.add(bgPeriod);
                            }
                        }
                        catch (SQLException ex) {
                            try {
                                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                            }
                            catch (Throwable throwable) {
                                SQLUtils.cleanup(rst);
                                throw throwable;
                            }
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                        result.setSubBgPeriods(subPeriods);
                        break block148;
                    }
                    subPeriods.addAll(parameter.getQueryPeriods());
                    result.setSubBgPeriods(subPeriods);
                }
                String expSrcNum = null;
                String expNumber = null;
                String viewId = null;
                String longNumber = null;
                ArrayList<MemberObject> subDimNumbers = new ArrayList<MemberObject>();
                if (parameter.hasExpandDimNum()) {
                    String dimNumber = parameter.getQueryDimNumbers().get(0);
                    String[] tmpStrs = dimNumber.split(":");
                    if (tmpStrs != null && tmpStrs.length > 1) {
                        StringBuffer sql;
                        MemberObject member;
                        String number;
                        expSrcNum = tmpStrs[0];
                        expNumber = tmpStrs[1];
                        IRowSet rst = null;
                        if (expSrcNum.equalsIgnoreCase(DimensionBaseConstants.DEF_INDEX_SRCNUMBER)) {
                            viewId = StringUtils.cnulls((Object)bgSchemeInfo.getViewId(DimensionBaseConstants.DEF_ACCOUNT_NUMBER), null);
                            ignoreLongNums.clear();
                            if (viewId != null) {
                                number = null;
                                member = null;
                                HashMap<String, Boolean> leafDataMap = new HashMap<String, Boolean>();
                                ArrayList<String> sqlParams = new ArrayList<String>();
                                sql = new StringBuffer();
                                if (isAllMap.get("isAllAcc") instanceof Boolean && ((Boolean)isAllMap.get("isAllAcc")).booleanValue()) {
                                    try {
                                        rst = BgDBUtils.executeQuery((Connection)conn, (String)"select TOP 1 FLongNumber from T_MBg_BgAccount where FNumber = ? and FBgAccountViewId = ?", (Object[])new Object[]{expNumber, viewId});
                                        if (rst.next()) {
                                            longNumber = StringUtils.cnulls((String)rst.getString("FLongNumber"), null);
                                        }
                                    }
                                    catch (SQLException ex) {
                                        throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                                    }
                                    finally {
                                        SQLUtils.cleanup((ResultSet)rst);
                                    }
                                    sql.append("select t.FNumber, t.FName_" + ctx.getLocale() + ", t.FLongNumber, c.FNumber , t.FPolAlgorithm from T_MBg_BgAccount t left join T_MBg_BgAccount c on t.FID = c.FParentID where t.FLongNumber like '" + longNumber + "!%' and t.FBgAccountViewId = ? order by t.FLongNumber ASC");
                                    sqlParams.add(viewId);
                                } else {
                                    sql.append("select t.FNumber, t.FName_" + ctx.getLocale() + ", t.FLongNumber, c.FNumber, t.FPolAlgorithm  from T_MBg_BgAccount t left join T_MBg_BgAccount c on t.FID = c.FParentID where t.FParentID IN (select FID from T_MBg_BgAccount where FNumber = ? and FBgAccountViewId = ?) order by t.FNumber ASC");
                                    sqlParams.add(expNumber);
                                    sqlParams.add(viewId);
                                }
                                try {
                                    rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), sqlParams);
                                    while (rst.next()) {
                                        number = rst.getString(1);
                                        dimNumber = expSrcNum + ":" + number;
                                        if (leafDataMap.containsKey(dimNumber)) continue;
                                        member = new MemberObject();
                                        member.setSrcNumber(expSrcNum);
                                        member.setNumber(number);
                                        member.setName(rst.getString(2));
                                        member.setMdxNumber(rst.getString(3));
                                        int ignoreType = rst.getInt("FPolAlgorithm");
                                        if (ignoreType == 3) {
                                            ignoreLongNums.add(member.getMdxNumber());
                                            continue;
                                        }
                                        subDimNumbers.add(member);
                                        if (rst.getString(4) != null) {
                                            leafDataMap.put(dimNumber, false);
                                            continue;
                                        }
                                        leafDataMap.put(dimNumber, true);
                                    }
                                }
                                catch (SQLException ex) {
                                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                                }
                                finally {
                                    SQLUtils.cleanup((ResultSet)rst);
                                }
                                result.setLeafDataMap(leafDataMap);
                                MemberObject memberObj = null;
                                Iterator iter = subDimNumbers.iterator();
                                while (iter.hasNext()) {
                                    memberObj = (MemberObject)iter.next();
                                    for (String next : ignoreLongNums) {
                                        if (memberObj.getMdxNumber().indexOf(next) <= -1) continue;
                                        iter.remove();
                                    }
                                }
                            }
                        } else {
                            try {
                                rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FNumber from T_MBG_MbgDim where FSrcNumber = ?", (Object[])new Object[]{expSrcNum});
                                if (rst.next()) {
                                    viewId = StringUtils.cnulls((Object)bgSchemeInfo.getViewId(rst.getString("FNumber")), null);
                                }
                            }
                            catch (SQLException ex) {
                                try {
                                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                                }
                                catch (Throwable throwable) {
                                    SQLUtils.cleanup(rst);
                                    throw throwable;
                                }
                            }
                            SQLUtils.cleanup((ResultSet)rst);
                            if (viewId != null) {
                                number = null;
                                member = null;
                                HashMap<String, Boolean> leafDataMap = new HashMap<String, Boolean>();
                                ArrayList<String> sqlParams = new ArrayList<String>();
                                sql = new StringBuffer();
                                if (isAllMap.get("isAllDim") instanceof Boolean && ((Boolean)isAllMap.get("isAllDim")).booleanValue()) {
                                    try {
                                        rst = BgDBUtils.executeQuery((Connection)conn, (String)"select TOP 1 FLongNumber from T_MBg_MbgMember where FNumber = ? and FViewId = ?", (Object[])new Object[]{expNumber, viewId});
                                        if (rst.next()) {
                                            longNumber = StringUtils.cnulls((String)rst.getString("FLongNumber"), null);
                                        }
                                    }
                                    catch (SQLException ex) {
                                        throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                                    }
                                    finally {
                                        SQLUtils.cleanup((ResultSet)rst);
                                    }
                                    sql.append("select t.FNumber, t.FName_" + ctx.getLocale() + ", t.FLongNumber, c.FNumber, t.FisSystemDefault from T_MBg_MbgMember t left join T_MBg_MbgMember c on t.FID = c.FParentID where t.FLongNumber like '" + longNumber + "!%' and t.FViewId = ?  order by t.FisSystemDefault DESC, t.FLongNumber ASC");
                                    sqlParams.add(viewId);
                                } else {
                                    sql.append("select t.FNumber, t.FName_" + ctx.getLocale() + ", t.FLongNumber, c.FNumber, t.FisSystemDefault from T_MBg_MbgMember t left join T_MBg_MbgMember c on t.FID = c.FParentID where t.FParentID IN (select FID from T_MBg_MbgMember where FNumber = ? and FViewId = ?)  order by t.FisSystemDefault DESC, t.FNumber ASC");
                                    sqlParams.add(expNumber);
                                    sqlParams.add(viewId);
                                }
                                try {
                                    rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), sqlParams);
                                    while (rst.next()) {
                                        number = rst.getString(1);
                                        dimNumber = expSrcNum + ":" + number;
                                        if (leafDataMap.containsKey(dimNumber)) continue;
                                        member = new MemberObject();
                                        member.setSrcNumber(expSrcNum);
                                        member.setNumber(number);
                                        member.setName(rst.getString(2));
                                        member.setMdxNumber(rst.getString(3));
                                        subDimNumbers.add(member);
                                        if (rst.getString(4) != null) {
                                            leafDataMap.put(dimNumber, false);
                                            continue;
                                        }
                                        leafDataMap.put(dimNumber, true);
                                    }
                                }
                                catch (SQLException ex) {
                                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                                }
                                finally {
                                    SQLUtils.cleanup((ResultSet)rst);
                                }
                                result.setLeafDataMap(leafDataMap);
                            }
                        }
                    }
                    result.getSubDimNumbers().addAll(subDimNumbers);
                }
                if (parameter.getDimDatas().isEmpty()) break block145;
                String formulaStr = null;
                String tmpStr = null;
                String dimNumber32 = null;
                String srcNumber = null;
                String[] params = null;
                String[] tmpStrs = null;
                String[] dimNums = null;
                com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
                IDimension dimension = null;
                MbgDimInfo dimInfo = null;
                HashSet<String> currencySet = new HashSet<String>();
                HashSet<String> bgElementSet = new HashSet<String>();
                HashSet<String> bgPeriodSet = new HashSet<String>();
                HashSet<String> bgScenarioSet = new HashSet<String>();
                HashMap<String, IDimension> dimsMap = new HashMap<String, IDimension>();
                DimensionParameter dimParam = new DimensionParameter();
                dimParam.setCalcBiz(parameter.isCalcBiz());
                if (parameter.hasExpendOrgUnit()) {
                    if (subOrgUnits.isEmpty()) {
                        if (null == parameter.getUnionId()) {
                            dimParam.setOrgUnitId(parameter.getBgOrgUnit() != null ? BOSUuid.read((String)parameter.getBgOrgUnit().getOrgUnitID()) : BOSUuid.read((String)result.getCurrOrgUnit().getOrgUnitID()));
                        } else {
                            dimParam.setOrgUnitId(parameter.getCurUnionOrgUnit().getId());
                        }
                    }
                } else if (!parameter.isMutilAnalyse()) {
                    if (null == parameter.getUnionId()) {
                        dimParam.setOrgUnitId(parameter.getBgOrgUnit() != null ? BOSUuid.read((String)parameter.getBgOrgUnit().getOrgUnitID()) : BOSUuid.read((String)result.getCurrOrgUnit().getOrgUnitID()));
                    } else {
                        dimParam.setOrgUnitId(parameter.getCurUnionOrgUnit().getId());
                    }
                } else if (parameter.hasCalcBiz()) {
                    if (null == parameter.getUnionId()) {
                        dimParam.setOrgUnitId(parameter.getBgOrgUnit() != null ? BOSUuid.read((String)parameter.getBgOrgUnit().getOrgUnitID()) : BOSUuid.read((String)result.getCurrOrgUnit().getOrgUnitID()));
                    } else {
                        dimParam.setOrgUnitId(parameter.getCurUnionOrgUnit().getId());
                    }
                }
                dimParam.setBgSchemeId(parameter.getBgSchemeId());
                dimParam.setBgTemplateId(parameter.getBgTemplateIds());
                dimParam.setBgOrgViewId(parameter.getBgOrgViewId());
                dimParam.setValueType(parameter.getValueType());
                dimParam.addPeriodStandardNumber(parameter.getPeriodStandardNumber());
                dimParam.getControlManager().setAdjust(parameter.hasAdjust());
                dimParam.getDataManager().setBgScheme(bgSchemeInfo);
                dimParam.getDataManager().setOrgUnit(MbgDataHelper.getBaseOrgUnitInfo(ctx, dimParam.getOrgUnitId()));
                dimParam.getDataManager().setBgOrgUnit(parameter.getBgOrgUnit() != null ? parameter.getBgOrgUnit() : result.getCurrOrgUnit());
                dimParam.setAdjustPastData(parameter.isQueryAdjustRecord());
                if (parameter.getViewStates() == null || parameter.getViewStates().isEmpty() || dimParam.getDataManager().getCustomState().addAll(parameter.getViewStates())) {
                    // empty if block
                }
                if (parameter.isMutilAnalyse() && !parameter.hasCalcBiz()) {
                    dimParam.getControlManager().setHasCalcBiz(false);
                }
                Map<String, MbgDimInfo> dimInfoMap = DimUtils.getDimInfoMap(ctx);
                HashMap<String, Set<String>> dimNumsMap = new HashMap<String, Set<String>>();
                Set<String> dimNumsSet = null;
                int in = parameter.getDimDatas().size();
                for (i = 0; i < in; ++i) {
                    formulaStr = parameter.getDimDatas().get(i);
                    params = BgNFSHelper.parseFormulaPara(formulaStr);
                    tmpStr = params[0];
                    tmpStrs = tmpStr.split(",");
                    if (tmpStrs != null) {
                        for (String dimNumber32 : tmpStrs) {
                            dimNums = dimNumber32.split(":");
                            srcNumber = dimNums[0];
                            String number = dimNums[1];
                            dimInfo = dimInfoMap.get(srcNumber);
                            if (dimsMap.containsKey(srcNumber)) {
                                dimension = (IDimension)dimsMap.get(srcNumber);
                            } else {
                                dimension = new DimensionObject();
                                dimension.setNumber(dimInfo.getNumber());
                                dimension.setField(dimInfo.getRefField());
                                dimension.setSrcNumber(dimInfo.getSrcNumber());
                                dimsMap.put(srcNumber, dimension);
                                dimParam.getRowDims().add(dimension);
                                dimParam.getDimensionMap().put(dimension.getNumber(), dimension);
                            }
                            if (dimNumsMap.containsKey(srcNumber)) {
                                dimNumsSet = (Set)dimNumsMap.get(srcNumber);
                            } else {
                                dimNumsSet = new HashSet();
                                dimNumsMap.put(srcNumber, dimNumsSet);
                            }
                            if (expNumber != null && expSrcNum != null && expSrcNum.equals(srcNumber) && expNumber.equals(number)) {
                                int xn = subDimNumbers.size();
                                for (int x = 0; x < xn; ++x) {
                                    member = (com.kingdee.eas.ma.mbg.dimension.face.IMember)subDimNumbers.get(x);
                                    if (dimNumsSet.contains(member.getNumber())) continue;
                                    dimNumsSet.add(member.getNumber());
                                    dimension.getDimensionMember().add(member);
                                }
                                continue;
                            }
                            if (dimNumsSet.contains(number)) continue;
                            dimNumsSet.add(number);
                            member = new MemberObject();
                            member.setNumber(number);
                            member.setSrcNumber(srcNumber);
                            dimension.getDimensionMember().add(member);
                        }
                    }
                    bgPeriodSet.add(params[1]);
                    bgElementSet.add(params[2]);
                    currencySet.add(params[5]);
                    bgScenarioSet.add(params[3]);
                }
                in = dimParam.getRowDims().size();
                for (i = 0; i < in; ++i) {
                    dimension = dimParam.getRowDims().get(i);
                    try {
                        DimUtils.queryItemLongNumber(ctx, dimParam, dimension);
                        continue;
                    }
                    catch (Exception ex) {
                        logger.error((Object)"drill Dimension Member LongNumber Error:", (Throwable)ex);
                    }
                }
                if (parameter.isQueryAllCSL() && null != (dimensionMember = (cslDimension = dimParam.getDimension(DimensionBaseConstants.DEF_CSL_FIELD)).getDimensionMember()) && !dimensionMember.isEmpty()) {
                    Iterator<String> iterator = BgCslDimConstants.canEditCslAjdNumberSet.iterator();
                    while (iterator.hasNext()) {
                        com.kingdee.eas.ma.mbg.dimension.face.IMember csl_01 = dimensionMember.get(0).clone();
                        String iMember = iterator.next();
                        csl_01.setNumber(iMember);
                        csl_01.setMdxNumber(iMember);
                        dimensionMember.add(csl_01);
                    }
                }
                EntityViewInfo view = null;
                FilterInfo filter = null;
                dimension = new DimensionObject();
                dimension.setNumber(DimensionConstants.DEF_ORGUNIT_NUMBER);
                dimension.setField(DimensionConstants.DEF_ORGUNIT_FIELD);
                dimension.setSrcNumber(DimensionConstants.DEF_ORGUNIT_SRCNUMBER);
                if (!subOrgUnits.isEmpty()) {
                    IDimension cslDimension2;
                    List<com.kingdee.eas.ma.mbg.dimension.face.IMember> dimensionMember2;
                    boolean isContainLeaf = false;
                    int in2 = subOrgUnits.size();
                    for (int i3 = 0; i3 < in2; ++i3) {
                        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)subOrgUnits.get(i3);
                        if (null != parameter.getUnionId() && orgUnitInfo.isIsLeaf()) {
                            isContainLeaf = true;
                        }
                        member = new MemberObject();
                        member.setName(orgUnitInfo.getName());
                        member.setNumber(orgUnitInfo.getNumber());
                        member.setMdxNumber(orgUnitInfo.getLongNumber());
                        dimension.getDimensionMember().add(member);
                    }
                    if (isContainLeaf && null != (dimensionMember2 = (cslDimension2 = dimParam.getDimension(DimensionBaseConstants.DEF_CSL_FIELD)).getDimensionMember()) && !dimensionMember2.isEmpty()) {
                        com.kingdee.eas.ma.mbg.dimension.face.IMember csl_01 = dimensionMember2.get(0).clone();
                        csl_01.setNumber("CSL-01");
                        csl_01.setMdxNumber("CSL-01");
                        dimensionMember2.add(csl_01);
                    }
                }
                dimParam.getColDims().add(dimension);
                dimParam.getDimensionMap().put(dimension.getNumber(), dimension);
                dimension = new DimensionObject();
                dimension.setNumber(DimensionConstants.DEF_PERIOD_NUMBER);
                dimension.setField(DimensionConstants.DEF_PERIOD_FIELD);
                dimension.setSrcNumber(DimensionConstants.DEF_PERIOD_SRCNUMBER);
                BgPeriodInfo bgPeriodInfo = null;
                if (!subPeriods.isEmpty()) {
                    int in3 = subPeriods.size();
                    for (int i4 = 0; i4 < in3; ++i4) {
                        bgPeriodInfo = (BgPeriodInfo)subPeriods.get(i4);
                        member = new MemberObject();
                        member.setName(bgPeriodInfo.getName());
                        member.setNumber(bgPeriodInfo.getNumber());
                        member.setMdxNumber(bgPeriodInfo.getLongNumber());
                        dimension.getDimensionMember().add(member);
                    }
                } else {
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", bgPeriodSet, CompareType.INCLUDE));
                    view.setFilter(filter);
                    sic = new SelectorItemCollection();
                    sic.add("name");
                    sic.add("number");
                    sic.add("longnumber");
                    view.getSelector().addObjectCollection((IObjectCollection)sic);
                    BgPeriodCollection bgPeriodColls = BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodCollection(view);
                    if (bgPeriodColls == null) {
                        DimDrillResult in3 = result;
                        return in3;
                    }
                    int in4 = bgPeriodColls.size();
                    for (int i5 = 0; i5 < in4; ++i5) {
                        bgPeriodInfo = bgPeriodColls.get(i5);
                        member = new MemberObject();
                        member.setName(bgPeriodInfo.getName());
                        member.setNumber(bgPeriodInfo.getNumber());
                        member.setMdxNumber(bgPeriodInfo.getLongNumber());
                        dimension.getDimensionMember().add(member);
                    }
                }
                try {
                    DimUtils.transMdxMemberNumber(ctx, dimParam, dimension);
                }
                catch (Exception ex) {
                    throw new BOSException((Throwable)ex);
                }
                dimParam.getColDims().add(dimension);
                dimParam.getDimensionMap().put(dimension.getNumber(), dimension);
                dimension = new DimensionObject();
                dimension.setNumber(DimensionConstants.DEF_ELEMENT_NUMBER);
                dimension.setField(DimensionConstants.DEF_ELEMENT_FIELD);
                dimension.setSrcNumber(DimensionConstants.DEF_ELEMENT_SRCNUMBER);
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", bgElementSet, CompareType.INCLUDE));
                view.setFilter(filter);
                sic = new SelectorItemCollection();
                sic.add("name");
                sic.add("number");
                view.getSelector().addObjectCollection((IObjectCollection)sic);
                BgElementCollection bgElementColls = BgElementFactory.getLocalInstance((Context)ctx).getBgElementCollection(view);
                if (bgElementColls == null) {
                    DimDrillResult i5 = result;
                    return i5;
                }
                BgElementInfo bgElementInfo = null;
                int in522 = bgElementColls.size();
                for (int i6 = 0; i6 < in522; ++i6) {
                    bgElementInfo = bgElementColls.get(i6);
                    member = new MemberObject();
                    member.setName(bgElementInfo.getName());
                    member.setNumber(bgElementInfo.getNumber());
                    member.setSrcNumber(DimensionConstants.DEF_ELEMENT_SRCNUMBER);
                    dimension.getDimensionMember().add(member);
                }
                if (parameter.isMutilAnalyse()) {
                    dimParam.getColDims().add(dimension);
                } else {
                    dimParam.getPageDims().add(dimension);
                }
                dimParam.getDimensionMap().put(dimension.getNumber(), dimension);
                DimUtils.queryItemLongNumber(ctx, dimParam, dimension);
                dimension = new DimensionObject();
                dimension.setNumber(DimensionConstants.DEF_CURRENCY_NUMBER);
                dimension.setField(DimensionConstants.DEF_CURRENCY_FIELD);
                dimension.setSrcNumber(DimensionConstants.DEF_CURRENCY_SRCNUMBER);
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", currencySet, CompareType.INCLUDE));
                view.setFilter(filter);
                sic = new SelectorItemCollection();
                sic.add("name");
                sic.add("number");
                view.getSelector().addObjectCollection((IObjectCollection)sic);
                CurrencyCollection currencyColls = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view);
                if (currencyColls == null) {
                    DimDrillResult in522 = result;
                    return in522;
                }
                CurrencyInfo currency = null;
                int in622 = currencyColls.size();
                for (int i7 = 0; i7 < in622; ++i7) {
                    currency = currencyColls.get(i7);
                    member = new MemberObject();
                    member.setName(currency.getName());
                    member.setNumber(currency.getNumber());
                    member.setSrcNumber(DimensionConstants.DEF_CURRENCY_SRCNUMBER);
                    dimension.getDimensionMember().add(member);
                }
                if (parameter.isMutilAnalyse()) {
                    dimParam.getColDims().add(dimension);
                } else {
                    dimParam.getPageDims().add(dimension);
                }
                dimParam.getDimensionMap().put(dimension.getNumber(), dimension);
                dimension = new DimensionObject();
                dimension.setNumber(DimensionConstants.DEF_SCENARIO_NUMBER);
                dimension.setField(DimensionConstants.DEF_SCENARIO_FIELD);
                dimension.setSrcNumber(DimensionConstants.DEF_SCENARIO_SRCNUMBER);
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", bgScenarioSet, CompareType.INCLUDE));
                view.setFilter(filter);
                sic = new SelectorItemCollection();
                sic.add("name");
                sic.add("number");
                view.getSelector().addObjectCollection((IObjectCollection)sic);
                BgScenarioCollection scenarioColls = BgScenarioFactory.getLocalInstance((Context)ctx).getBgScenarioCollection(view);
                if (scenarioColls == null) {
                    DimDrillResult in622 = result;
                    return in622;
                }
                BgScenarioInfo scenario = null;
                int in7 = scenarioColls.size();
                for (int i8 = 0; i8 < in7; ++i8) {
                    scenario = scenarioColls.get(i8);
                    member = new MemberObject();
                    member.setName(scenario.getName());
                    member.setNumber(scenario.getNumber());
                    member.setSrcNumber(DimensionConstants.DEF_SCENARIO_SRCNUMBER);
                    dimension.getDimensionMember().add(member);
                }
                if (parameter.isMutilAnalyse()) {
                    dimParam.getColDims().add(dimension);
                } else {
                    dimParam.getPageDims().add(dimension);
                }
                dimParam.getDimensionMap().put(dimension.getNumber(), dimension);
                DimUtils.queryItemLongNumber(ctx, dimParam, dimension);
                DimUtils.transScenarioNumber(ctx, dimension);
                dimension = new DimensionObject();
                dimension.setNumber(DimensionConstants.DEF_VERSION_NUMBER);
                dimension.setField(DimensionConstants.DEF_VERSION_FIELD);
                dimension.setSrcNumber(DimensionConstants.DEF_VERSION_SRCNUMBER);
                if (parameter.isMutilAnalyse()) {
                    dimension.getDimensionMember().addAll(parameter.getBgVersions());
                    dimParam.getColDims().add(dimension);
                } else {
                    dimension.getDimensionMember().add(parameter.getBgVersion());
                    dimParam.getPageDims().add(dimension);
                }
                dimParam.getDimensionMap().put(dimension.getNumber(), dimension);
                if (!parameter.isMutilAnalyse()) {
                    DimUtils.queryItemLongNumber(ctx, dimParam, dimension);
                }
                DimUtils.transVersionNumber(ctx, dimension);
                HashSet<String> orgUnitIds = new HashSet<String>();
                for (OrgUnitInfo orgUnitInfo : subOrgUnits) {
                    if (DimensionCommonHelper.isDecompose(dimParam.getValueType()) && 512 != dimParam.getValueType() && orgUnitInfo.isIsLeaf()) continue;
                    orgUnitIds.add(orgUnitInfo.getId().toString());
                }
                dimParam.setQeryOrgIds(orgUnitIds);
                dimParam.setUnionId(parameter.getUnionId());
                dimParam.getDataManager().setDimDataQuery(parameter.getDimDataQuery());
                if (!orgUnitIds.isEmpty() && (_obj = this._dimensionQuery(ctx, dimParam)) instanceof Map) {
                    result.setDimData((Map)_obj);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"dimension drill error", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        return result;
    }

    private OrgStructureInfo getOrgStructureByUnit(Context ctx, String unitInfoID, String treeInfoID) throws BOSException {
        IOrgStructure iStruc = OrgStructureFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeInfoID));
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)unitInfoID));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("longnumber"));
        OrgStructureCollection structInfos = iStruc.getOrgStructureCollection(view);
        if (structInfos.size() != 0) {
            return structInfos.get(0);
        }
        return null;
    }

    private void dealExpendUnionOrgUnit(Context ctx, IDimDrillParameter parameter, Map isAllMap, IDimDrillResult result, Connection conn) throws SQLException, BOSException {
        IRowSet rst;
        String unionId = parameter.getUnionId().toString();
        OrgUnitInfo curUnionOrgUnit = parameter.getCurUnionOrgUnit();
        result.setCurrUnionOrgUnit(curUnionOrgUnit);
        OrgStructureInfo struct = this.getOrgStructureByUnit(ctx, curUnionOrgUnit.getId().toString(), unionId);
        StringBuilder sql = new StringBuilder();
        ArrayList<OrgUnitInfo> subUnionOrgUnits = new ArrayList<OrgUnitInfo>();
        sql.append("select unit.FID,unit.FNumber,unit.FName_").append(ctx.getLocale()).append(",struct.FLongNumber,struct.FIsLeaf  from T_ORG_Structure struct ").append(" left join T_ORG_Tree tree on struct.FTREEID = tree.FID ").append(" left join T_ORG_BaseUnit unit on struct.FUNITID = unit.FID ").append(" where (unit.FISGROUPING  = 1 or unit.FISCOSTORGUNIT  = 1) and tree.FID = ? ");
        if (parameter.hasExpendOrgUnit()) {
            if (this.isExpendAllOrg(isAllMap)) {
                sql.append("and struct.FLongNumber like ?  order by struct.FLongNumber");
                rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId, struct.getLongNumber() + "!%"});
            } else {
                sql.append("and struct.FParentId = ? order by struct.FLongNumber");
                rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId, struct.getId().toString()});
            }
        } else {
            sql.append(" and struct.FID = ?");
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId, struct.getId().toString()});
        }
        while (rst.next()) {
            OrgUnitInfo info = new OrgUnitInfo();
            info.setId(BOSUuid.read((String)rst.getString("FID")));
            info.setNumber(rst.getString("FNumber"));
            info.setName(rst.getString("FName_" + ctx.getLocale()));
            info.setLongNumber(rst.getString("FLongNumber"));
            info.setIsLeaf(rst.getBoolean("FIsLeaf"));
            subUnionOrgUnits.add(info);
        }
        result.setSubUnionOrgUnits(subUnionOrgUnits);
    }

    private List<BgOrgUnitInfo> dealExpendOrgUnit(Context ctx, IDimDrillParameter parameter, Map isAllMap, IDimDrillResult result, Set<String> ignoreLongNums, Connection conn) throws BOSException, EASBizException, SQLException {
        Object orgUnitInfo = null;
        List<BgOrgUnitInfo> subOrgUnits = new ArrayList<BgOrgUnitInfo>();
        HashMap<String, String> orgUnitMap = new HashMap<String, String>();
        HashMap<String, Map<String, BgOrgUnitInfo>> virUnitMap = new HashMap<String, Map<String, BgOrgUnitInfo>>();
        HashMap<String, BgOrgUnitInfo> orgInfoMap = new HashMap<String, BgOrgUnitInfo>();
        HashSet<String> virNumSet = new HashSet<String>();
        this.selectSubOrgUnits(ctx, parameter, isAllMap, result, ignoreLongNums, conn, subOrgUnits, orgUnitMap, virUnitMap, orgInfoMap, virNumSet);
        subOrgUnits = this.filterIgnoreOrgUnits(result, ignoreLongNums);
        this.replaceLongNumberToSubOrgUnits(subOrgUnits, virUnitMap, orgInfoMap);
        return subOrgUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectSubOrgUnits(Context ctx, IDimDrillParameter parameter, Map isAllMap, IDimDrillResult result, Set<String> ignoreLongNums, Connection conn, List<BgOrgUnitInfo> subOrgUnits, Map<String, String> orgUnitMap, Map<String, Map<String, BgOrgUnitInfo>> virUnitMap, Map<String, BgOrgUnitInfo> orgInfoMap, Set<String> virNumSet) throws BOSException, EASBizException, SQLException {
        block53: {
            block56: {
                boolean showSeal;
                block54: {
                    block52: {
                        IRowSet rst;
                        BgOrgUnitInfo bgOrgUnit;
                        block50: {
                            showSeal = parameter.isShowSeal();
                            if (!parameter.hasExpendOrgUnit()) break block52;
                            String bgOrgViewId = parameter.getBgOrgViewId().toString();
                            bgOrgUnit = parameter.getBgOrgUnit();
                            boolean isVirtual = bgOrgUnit.isIsVirtual();
                            String pLongNumber = bgOrgUnit.getLongNumber();
                            int sepCount = pLongNumber.split("!").length;
                            BgOrgUnitInfo noVirtualOrg = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitInfo("select id, longNumber where orgUnitId = '" + bgOrgUnit.getOrgUnitID() + "' and viewId = '" + bgOrgViewId + "' and isVirtual = 0");
                            if (isVirtual) {
                                virNumSet.add(bgOrgUnit.getNumber());
                            }
                            String[] mbgOrgTables = MbgVirtualView.getMbgOrgUnitSnap((Connection)conn, (BOSUuid)BOSUuid.read((String)bgOrgViewId), (BOSUuid)BOSUuid.read((String)bgOrgUnit.getOrgUnitID()), null);
                            String mbgOrgFact = null;
                            if (mbgOrgTables != null && StringUtils.isEmpty((String)(mbgOrgFact = mbgOrgTables[2]))) {
                                mbgOrgFact = mbgOrgTables[0];
                            }
                            rst = null;
                            HashSet<String> orgUnitIdSet = new HashSet<String>();
                            if (mbgOrgTables != null && mbgOrgTables[1] != null) {
                                rst = BgDBUtils.executeQuery((Connection)conn, (String)("select FChildID from " + mbgOrgTables[1] + " where FID in (select FOrgUnitID from T_MBG_BgOrgUnit where FViewID = ? and FPolAlgorithm <> " + 3 + " and FLongNumber like ?)"), (Object[])new Object[]{bgOrgViewId.toString(), bgOrgUnit.getLongNumber() + "!%"});
                                while (rst.next()) {
                                    orgUnitIdSet.add(rst.getString("FChildID"));
                                }
                            }
                            SQLUtils.cleanup(rst);
                            Map<String, BgOrgUnitInfo> childOrgUnitsMap = this.getAllChildOrg(ctx, parameter, ignoreLongNums, conn, orgUnitIdSet);
                            SQLUtils.cleanup(rst);
                            StringBuffer sql = new StringBuffer();
                            if (showSeal) {
                                if (this.isExpendAllOrg(isAllMap)) {
                                    sql.append("select t.FID, t.FOrgUnitID, t.FNumber, t.FName_" + ctx.getLocale() + " AS FName, t.FLongNumber, t.FIsLeaf, t.FIsVirtual, t.FPolAlgorithm from T_MBG_BgOrgUnit t where t.FLongNumber like ? and FViewId = ? order by t.FLongNumber");
                                } else {
                                    sql.append("select t.FID, t.FOrgUnitID, t.FNumber, t.FName_" + ctx.getLocale() + " AS FName, t.FLongNumber, t.FIsLeaf, t.FIsVirtual, t.FPolAlgorithm from T_MBG_BgOrgUnit t join T_MBG_BgOrgUnit p on t.FParentID = p.FID where p.FID = ? order by t.FNumber");
                                }
                            } else if (this.isExpendAllOrg(isAllMap)) {
                                sql.append("select t.FID, t.FOrgUnitID, t.FNumber, t.FName_" + ctx.getLocale() + " AS FName, t.FLongNumber, t.FIsLeaf, t.FIsVirtual, t.FPolAlgorithm from T_MBG_BgOrgUnit t where t.FLongNumber like ? and FViewId = ? and FIsOUSealUp = 0 order by t.FLongNumber");
                            } else {
                                sql.append("select t.FID, t.FOrgUnitID, t.FNumber, t.FName_" + ctx.getLocale() + " AS FName, t.FLongNumber, t.FIsLeaf, t.FIsVirtual, t.FPolAlgorithm from T_MBG_BgOrgUnit t where t.FParentID = ? and t.FIsOUSealUp = 0 order by t.FLongNumber");
                            }
                            try {
                                BgOrgUnitInfo orgUnitInfo;
                                rst = this.isExpendAllOrg(isAllMap) ? BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{noVirtualOrg.getLongNumber() + "!%", bgOrgViewId}) : BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgOrgUnit.getId().toString()});
                                HashSet<String> orgIds = new HashSet<String>();
                                while (rst.next()) {
                                    orgUnitInfo = new BgOrgUnitInfo();
                                    orgUnitInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                                    orgUnitInfo.setOrgUnitID(rst.getString("FOrgUnitID"));
                                    orgUnitInfo.setNumber(rst.getString("FNumber"));
                                    orgUnitInfo.setName(rst.getString("FName"));
                                    Iterator<String> longNumber = rst.getString("FLongNumber");
                                    orgUnitInfo.setLongNumber((String)((Object)longNumber));
                                    orgUnitInfo.setIsLeaf(rst.getBoolean("FIsLeaf"));
                                    orgUnitInfo.setIsVirtual(rst.getBoolean("FIsVirtual"));
                                    int ignoreType = rst.getInt("FPolAlgorithm");
                                    if (ignoreType == 3 && parameter.checkNeedIgnore(orgUnitInfo)) {
                                        ignoreLongNums.add(orgUnitInfo.getLongNumber());
                                        continue;
                                    }
                                    subOrgUnits.add(orgUnitInfo);
                                    orgIds.add(rst.getString("FOrgUnitID"));
                                    if (!orgUnitInfo.isIsVirtual()) continue;
                                    virNumSet.add(orgUnitInfo.getNumber());
                                }
                                SQLUtils.cleanup((ResultSet)rst);
                                if (this.isExpendAllOrg(isAllMap)) {
                                    for (Map.Entry<String, BgOrgUnitInfo> entry : childOrgUnitsMap.entrySet()) {
                                        if (orgIds.contains(entry.getKey()) || !showSeal && entry.getValue().isIsOUSealUp()) continue;
                                        subOrgUnits.add(entry.getValue());
                                    }
                                }
                                if (virNumSet.isEmpty()) break block50;
                                sql = new StringBuffer();
                                sql.append("select FID, FNumber, FLongNumber, FOrgUnitID, FName_" + ctx.getLocale() + " AS FName, FIsLeaf, FIsVirtual, FPolAlgorithm from T_MBG_BgOrgUnit where FViewId = ? and FNumber IN (");
                                for (String _number : virNumSet) {
                                    sql.append("'" + _number + "',");
                                }
                                sql.append("'#') and FIsVirtual = 0");
                                try {
                                    rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgOrgViewId});
                                    while (rst.next()) {
                                        orgUnitMap.put(rst.getString("FNumber"), rst.getString("FLongNumber"));
                                        orgUnitInfo = new BgOrgUnitInfo();
                                        orgUnitInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                                        orgUnitInfo.setOrgUnitID(rst.getString("FOrgUnitID"));
                                        orgUnitInfo.setNumber(rst.getString("FNumber"));
                                        orgUnitInfo.setName(rst.getString("FName"));
                                        orgUnitInfo.setLongNumber(rst.getString("FLongNumber"));
                                        orgUnitInfo.setIsLeaf(rst.getBoolean("FIsLeaf"));
                                        orgUnitInfo.setIsVirtual(rst.getBoolean("FIsVirtual"));
                                        orgInfoMap.put(orgUnitInfo.getNumber(), orgUnitInfo);
                                    }
                                }
                                finally {
                                    SQLUtils.cleanup((ResultSet)rst);
                                }
                                if (!this.isExpendAllOrg(isAllMap)) break block50;
                                sql = new StringBuffer();
                                ArrayList<String> params = new ArrayList<String>();
                                int size = orgInfoMap.values().size();
                                int count = 0;
                                for (BgOrgUnitInfo org : orgInfoMap.values()) {
                                    if (count == 0) {
                                        sql.append("select * from (");
                                    }
                                    sql.append("select t.FID, t.FOrgUnitID, t.FNumber, t.FName_" + ctx.getLocale() + " AS FName, t.FLongNumber, t.FIsLeaf, t.FIsVirtual, t.FPolAlgorithm, '" + org.getNumber() + "' AS FOrignalOrg from T_MBG_BgOrgUnit t where t.FLongNumber like '" + org.getLongNumber() + "%' and FViewId = ? ");
                                    if (count != size - 1) {
                                        sql.append(" union all ");
                                    } else {
                                        sql.append(") as t1 order by FLongNumber");
                                    }
                                    params.add(bgOrgViewId);
                                    ++count;
                                }
                                try {
                                    rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), params);
                                    while (rst.next()) {
                                        String orgNumber = rst.getString("FOrignalOrg");
                                        if (!virUnitMap.containsKey(orgNumber)) {
                                            virUnitMap.put(orgNumber, new HashMap());
                                        }
                                        Map<String, BgOrgUnitInfo> map = virUnitMap.get(orgNumber);
                                        orgUnitInfo = new BgOrgUnitInfo();
                                        orgUnitInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                                        orgUnitInfo.setOrgUnitID(rst.getString("FOrgUnitID"));
                                        orgUnitInfo.setNumber(rst.getString("FNumber"));
                                        orgUnitInfo.setName(rst.getString("FName"));
                                        orgUnitInfo.setLongNumber(rst.getString("FLongNumber"));
                                        orgUnitInfo.setIsLeaf(rst.getBoolean("FIsLeaf"));
                                        orgUnitInfo.setIsVirtual(rst.getBoolean("FIsVirtual"));
                                        map.put(orgUnitInfo.getNumber(), orgUnitInfo);
                                    }
                                }
                                finally {
                                    SQLUtils.cleanup((ResultSet)rst);
                                }
                            }
                            catch (SQLException ex) {
                                try {
                                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                                }
                                catch (Throwable throwable) {
                                    SQLUtils.cleanup(rst);
                                    throw throwable;
                                }
                            }
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                        HashMap<String, BgOrgUnitInfo> longNumberMap = new HashMap<String, BgOrgUnitInfo>();
                        HashMap<String, BgOrgUnitInfo> subOrgMap = new HashMap<String, BgOrgUnitInfo>();
                        longNumberMap.put(bgOrgUnit.getNumber(), bgOrgUnit);
                        for (BgOrgUnitInfo _orgUnit : subOrgUnits) {
                            subOrgMap.put(_orgUnit.getNumber(), _orgUnit);
                        }
                        for (BgOrgUnitInfo _orgUnit : subOrgUnits) {
                            this.calcLongNumber(_orgUnit, longNumberMap, subOrgMap);
                        }
                        result.setSubOrgUnits(subOrgUnits);
                        break block53;
                    }
                    if (parameter.getCurrBgOrgUnit() == null || parameter.getQueryOrgUnits() == null || parameter.getQueryOrgUnits().size() > 1) break block54;
                    StringBuffer sql = new StringBuffer();
                    if (showSeal) {
                        sql.append("select t.FID, t.FOrgUnitID, t.FNumber, t.FName_" + ctx.getLocale() + " AS FName, t.FLongNumber, t.FIsLeaf, t.FIsVirtual, t.FPolAlgorithm from T_MBG_BgOrgUnit t where t.FID = ?");
                    } else {
                        sql.append("select t.FID, t.FOrgUnitID, t.FNumber, t.FName_" + ctx.getLocale() + " AS FName, t.FLongNumber, t.FIsLeaf, t.FIsVirtual, t.FPolAlgorithm from T_MBG_BgOrgUnit t where t.FID = ? and t.FIsOUSealUp = 0 ");
                    }
                    IRowSet rst = null;
                    try {
                        rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{parameter.getCurrBgOrgUnit().getId().toString()});
                        while (rst.next()) {
                            BgOrgUnitInfo orgUnitInfo = new BgOrgUnitInfo();
                            orgUnitInfo.setOrgUnitID(rst.getString("FOrgUnitID"));
                            orgUnitInfo.setNumber(rst.getString("FNumber"));
                            orgUnitInfo.setName(rst.getString("FName"));
                            orgUnitInfo.setLongNumber(rst.getString("FLongNumber"));
                            orgUnitInfo.setIsLeaf(rst.getBoolean("FIsLeaf"));
                            orgUnitInfo.setIsVirtual(rst.getBoolean("FIsVirtual"));
                            int ignoreType = rst.getInt("FPolAlgorithm");
                            if (ignoreType == 3 && parameter.checkNeedIgnore(orgUnitInfo)) {
                                ignoreLongNums.add(orgUnitInfo.getLongNumber());
                                continue;
                            }
                            subOrgUnits.add(orgUnitInfo);
                        }
                    }
                    catch (SQLException ex) {
                        try {
                            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(rst);
                            throw throwable;
                        }
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                    result.setSubOrgUnits(subOrgUnits);
                    break block53;
                }
                if (parameter.getBgOrgUnit() == null) break block56;
                String bgOrgViewId = parameter.getBgOrgViewId().toString();
                BgOrgUnitInfo bgOrgUnit = parameter.getBgOrgUnit();
                Locale locale = ctx.getLocale();
                StringBuffer sql = new StringBuffer();
                if (showSeal) {
                    sql.append("select t.FID, t.FOrgUnitID, t.FNumber, t.FName_" + locale + " , t.FLongNumber, t.FIsLeaf, t.FIsVirtual, t.FPolAlgorithm  from T_MBG_BgOrgUnit t where t.FViewId = ? and t.FOrgUnitId = ? and t.FIsVirtual = ?");
                } else {
                    sql.append("select t.FID, t.FOrgUnitID, t.FNumber, t.FName_" + locale + " , t.FLongNumber, t.FIsLeaf, t.FIsVirtual, t.FPolAlgorithm from T_MBG_BgOrgUnit t where t.FViewId = ? and t.FOrgUnitId = ? and t.FIsVirtual = ?  and t.FIsOUSealUp = 0");
                }
                IRowSet rst = null;
                try {
                    rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgOrgViewId, bgOrgUnit.getOrgUnitID(), bgOrgUnit.isIsVirtual()});
                    while (rst.next()) {
                        BgOrgUnitInfo orgUnitInfo = new BgOrgUnitInfo();
                        orgUnitInfo.setOrgUnitID(rst.getString("FOrgUnitID"));
                        orgUnitInfo.setNumber(rst.getString("FNumber"));
                        orgUnitInfo.setName(rst.getString("FName_" + locale));
                        orgUnitInfo.setLongNumber(rst.getString("FLongNumber"));
                        orgUnitInfo.setIsLeaf(rst.getBoolean("FIsLeaf"));
                        orgUnitInfo.setIsVirtual(rst.getBoolean("FIsVirtual"));
                        int ignoreType = rst.getInt("FPolAlgorithm");
                        if (ignoreType == 3 && parameter.checkNeedIgnore(orgUnitInfo)) {
                            ignoreLongNums.add(orgUnitInfo.getLongNumber());
                            continue;
                        }
                        subOrgUnits.add(orgUnitInfo);
                    }
                }
                catch (SQLException ex) {
                    try {
                        throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rst);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rst);
                result.setSubOrgUnits(subOrgUnits);
                break block53;
            }
            subOrgUnits.addAll(parameter.getQueryOrgUnits());
            result.setSubOrgUnits(subOrgUnits);
        }
    }

    private List<BgOrgUnitInfo> filterIgnoreOrgUnits(IDimDrillResult result, Set<String> ignoreLongNums) {
        List<BgOrgUnitInfo> subOrgUnits = result.getSubOrgUnits();
        Iterator<BgOrgUnitInfo> iter = subOrgUnits.iterator();
        while (iter.hasNext()) {
            String longNumber = iter.next().getLongNumber();
            for (String next : ignoreLongNums) {
                if (!longNumber.startsWith(next + "!")) continue;
                iter.remove();
            }
        }
        return subOrgUnits;
    }

    private void replaceLongNumberToSubOrgUnits(List<BgOrgUnitInfo> subOrgUnits, Map<String, Map<String, BgOrgUnitInfo>> virUnitMap, Map<String, BgOrgUnitInfo> orgInfoMap) {
        HashMap<String, BgOrgUnitInfo> subOrgMap = new HashMap<String, BgOrgUnitInfo>();
        for (BgOrgUnitInfo orgUnitInfo : subOrgUnits) {
            subOrgMap.put(orgUnitInfo.getNumber(), orgUnitInfo);
        }
        for (BgOrgUnitInfo orgUnitInfo : subOrgUnits) {
            if (!orgUnitInfo.isIsVirtual() || orgInfoMap.isEmpty() || !orgInfoMap.containsKey(orgUnitInfo.getNumber())) continue;
            BgOrgUnitInfo bgOrgUnitInfo = orgInfoMap.get(orgUnitInfo.getNumber());
            orgUnitInfo.setIsLeaf(bgOrgUnitInfo.isIsLeaf());
            orgUnitInfo.setId(bgOrgUnitInfo.getId());
            String virLongNumber = orgUnitInfo.getLongNumber();
            if (!virUnitMap.containsKey(orgUnitInfo.getNumber())) continue;
            Map<String, BgOrgUnitInfo> map = virUnitMap.get(orgUnitInfo.getNumber());
            String realLongNumber = map.get(orgUnitInfo.getNumber()).getLongNumber();
            for (BgOrgUnitInfo subOrgUnitInfo : map.values()) {
                if (realLongNumber.equals(subOrgUnitInfo.getNumber())) continue;
                String replaceLongNumber = subOrgUnitInfo.getLongNumber().replace(realLongNumber, virLongNumber);
                ((BgOrgUnitInfo)subOrgMap.get(subOrgUnitInfo.getNumber())).setLongNumber(replaceLongNumber);
            }
        }
        Collections.sort(subOrgUnits, new Comparator<BgOrgUnitInfo>(){

            @Override
            public int compare(BgOrgUnitInfo o1, BgOrgUnitInfo o2) {
                return o1.getLongNumber().compareTo(o2.getLongNumber());
            }
        });
    }

    private void calcLongNumber(BgOrgUnitInfo _orgUnit, Map<String, BgOrgUnitInfo> longNumberMap, Map<String, BgOrgUnitInfo> subOrgMap) {
        if (longNumberMap.containsKey(_orgUnit.getNumber())) {
            return;
        }
        logger.error((Object)("calcLongNumber " + _orgUnit.getLongNumber()));
        String[] lns = _orgUnit.getLongNumber().split("!");
        if (lns.length == 1) {
            return;
        }
        BgOrgUnitInfo pOrgUnit = subOrgMap.get(lns[lns.length - 2]);
        if (pOrgUnit == null) {
            return;
        }
        this.calcLongNumber(pOrgUnit, longNumberMap, subOrgMap);
        _orgUnit.setLongNumber(pOrgUnit.getLongNumber() + "!" + _orgUnit.getNumber());
        longNumberMap.put(_orgUnit.getNumber(), _orgUnit);
    }

    private BgOrgUnitCollection getOrgColl(Context ctx, Set<String> virNumSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", virNumSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("name");
        sic.add("number");
        sic.add("longnumber");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        BgOrgUnitCollection bgOrgUnitCollection = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(view);
        return bgOrgUnitCollection;
    }

    private int getSepIndex(int sepCount, String longNumber) {
        String[] split = longNumber.split("!");
        int childSepCount = 0;
        for (int i = 0; i < split.length; ++i) {
            if (!"!".equals(split[i])) continue;
            if (sepCount != childSepCount) {
                ++childSepCount;
                continue;
            }
            return i - 1;
        }
        return -1;
    }

    private boolean isExpendAllOrg(Map isAllMap) {
        return isAllMap.get("isAllOrg") instanceof Boolean && (Boolean)isAllMap.get("isAllOrg") != false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, BgOrgUnitInfo> getAllChildOrg(Context ctx, IDimDrillParameter parameter, Set<String> ignoreLongNums, Connection conn, Set<String> orgUnitIdSet) throws BOSException, EASBizException, SQLException {
        HashMap<String, BgOrgUnitInfo> childOrgUnitsMap;
        String tmpOrgUnitName;
        TempTablePool pool;
        block8: {
            pool = TempTablePool.getInstance((Context)ctx);
            tmpOrgUnitName = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            childOrgUnitsMap = new HashMap<String, BgOrgUnitInfo>();
            IRowSet rst = null;
            try {
                ArrayList<Object[]> orgParams = new ArrayList<Object[]>();
                for (String orgUnitId : orgUnitIdSet) {
                    orgParams.add(new Object[]{orgUnitId});
                }
                BgDBUtils.executeBatch((Connection)conn, (String)("Insert Into " + tmpOrgUnitName + "(FID) Values(?)"), orgParams);
                rst = BgDBUtils.executeQuery((Connection)conn, (String)("select t.FID, t.FOrgUnitID, t.FNumber, t.FName_" + ctx.getLocale() + " AS FName, t.FLongNumber, t.FIsLeaf, t.FIsVirtual, t.FPolAlgorithm, t.FIsOUSealUp from T_MBG_BgOrgUnit t, " + tmpOrgUnitName + " tmp where t.FOrgUnitID = tmp.FID AND t.FViewId = ? order by t.FLongNumber"), (Object[])new Object[]{parameter.getBgOrgViewId().toString()});
                while (rst.next()) {
                    BgOrgUnitInfo orgUnitInfo = new BgOrgUnitInfo();
                    orgUnitInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                    orgUnitInfo.setOrgUnitID(rst.getString("FOrgUnitID"));
                    orgUnitInfo.setNumber(rst.getString("FNumber"));
                    orgUnitInfo.setName(rst.getString("FName"));
                    orgUnitInfo.setLongNumber(rst.getString("FLongNumber"));
                    orgUnitInfo.setIsLeaf(rst.getBoolean("FIsLeaf"));
                    orgUnitInfo.setIsVirtual(rst.getBoolean("FIsVirtual"));
                    orgUnitInfo.setIsOUSealUp(rst.getBoolean("FIsOUSealUp"));
                    int ignoreType = rst.getInt("FPolAlgorithm");
                    if (ignoreType == 3 && parameter.checkNeedIgnore(orgUnitInfo)) {
                        ignoreLongNums.add(orgUnitInfo.getLongNumber());
                        continue;
                    }
                    childOrgUnitsMap.put(rst.getString("FOrgUnitID"), orgUnitInfo);
                }
                if (rst == null) break block8;
            }
            catch (Exception e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (rst != null) {
                        SQLUtils.cleanup(rst);
                    }
                    pool.releaseTable(tmpOrgUnitName);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        pool.releaseTable(tmpOrgUnitName);
        return childOrgUnitsMap;
    }

    private Map<String, Boolean> checkDimNumberIsLeaf(Connection conn, Map<String, Set<String>> dimNumberMap, BgSchemeInfo bgSchemeInfo) throws EASBizException {
        HashMap<String, Boolean> leafDataMap = new HashMap<String, Boolean>();
        if (conn == null || dimNumberMap == null || bgSchemeInfo == null) {
            return leafDataMap;
        }
        String dimNumber = null;
        String srcNumber = null;
        String number2 = null;
        Set<String> dimNumberSet = null;
        String viewId = null;
        IRowSet rst = null;
        Map.Entry<String, Set<String>> entry2 = null;
        for (Map.Entry<String, Set<String>> entry2 : dimNumberMap.entrySet()) {
            srcNumber = entry2.getKey();
            dimNumberSet = entry2.getValue();
            if (srcNumber.equalsIgnoreCase(DimensionBaseConstants.DEF_INDEX_SRCNUMBER)) {
                this.checkAccountIsLeaf(conn, bgSchemeInfo, dimNumberSet, leafDataMap);
                continue;
            }
            viewId = null;
            try {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FNumber from T_MBG_MbgDim where FSrcNumber = ?", (Object[])new Object[]{srcNumber});
                if (rst.next()) {
                    viewId = StringUtils.cnulls((Object)bgSchemeInfo.getViewId(rst.getString("FNumber")), null);
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst);
            if (viewId != null) {
                StringBuffer sql = new StringBuffer();
                ArrayList<String> sqlParams = new ArrayList<String>();
                sql.append("select top 1 FID, FNumber from T_Mbg_MbgMember where FParentID IN (select FID from T_Mbg_MbgMember where FNumber = ? AND FViewId = ?)");
                for (String number2 : dimNumberSet) {
                    dimNumber = srcNumber + ":" + number2;
                    sqlParams.clear();
                    sqlParams.add(number2);
                    sqlParams.add(viewId);
                    try {
                        rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), sqlParams);
                        if (rst.next()) {
                            if (number2.equals(rst.getString("FNumber"))) {
                                leafDataMap.put(dimNumber, true);
                                continue;
                            }
                            leafDataMap.put(dimNumber, false);
                            continue;
                        }
                        leafDataMap.put(dimNumber, true);
                    }
                    catch (SQLException ex) {
                        throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                continue;
            }
            for (String number2 : dimNumberSet) {
                dimNumber = srcNumber + ":" + number2;
                leafDataMap.put(dimNumber, true);
            }
        }
        return leafDataMap;
    }

    private void checkAccountIsLeaf(Connection conn, BgSchemeInfo bgSchemeInfo, Set<String> dimNumberSet, Map<String, Boolean> leafDataMap) throws EASBizException {
        if (bgSchemeInfo == null || dimNumberSet == null) {
            return;
        }
        String dimNumber = null;
        String number2 = null;
        IRowSet rst = null;
        String srcNumber = DimensionBaseConstants.DEF_INDEX_SRCNUMBER;
        String viewId = StringUtils.cnulls((Object)bgSchemeInfo.getViewId(DimensionBaseConstants.DEF_ACCOUNT_NUMBER), null);
        if (viewId != null) {
            StringBuffer sql = new StringBuffer();
            ArrayList<String> sqlParams = new ArrayList<String>();
            sql.append("select top 1 FID, FNumber from T_Mbg_BgAccount where FParentID IN (select FID from T_Mbg_BgAccount where FNumber = ? AND FBgAccountViewId = ?)");
            for (String number2 : dimNumberSet) {
                block12: {
                    dimNumber = srcNumber + ":" + number2;
                    sqlParams.clear();
                    sqlParams.add(number2);
                    sqlParams.add(viewId);
                    try {
                        rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), sqlParams);
                        if (rst.next()) {
                            if (number2.equals(rst.getString("FNumber"))) {
                                leafDataMap.put(dimNumber, true);
                            } else {
                                leafDataMap.put(dimNumber, false);
                            }
                            break block12;
                        }
                        leafDataMap.put(dimNumber, true);
                    }
                    catch (SQLException ex) {
                        try {
                            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(rst);
                            throw throwable;
                        }
                    }
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        } else {
            for (String number2 : dimNumberSet) {
                dimNumber = srcNumber + ":" + number2;
                leafDataMap.put(dimNumber, true);
            }
        }
    }

    @Override
    protected void _checkBgOrgView(Context ctx, BOSUuid bgOrgViewId) throws BOSException, EASBizException {
        if (bgOrgViewId == null) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String _queryFormByData(Context ctx, Map parameter) throws BOSException, EASBizException {
        String adjustTmpTable;
        String returnFormId;
        String tmpTable;
        TempTablePool pool;
        ResultSet rs;
        PreparedStatement prepareStatement;
        Connection connection;
        block61: {
            String string;
            block60: {
                String string2;
                block59: {
                    String string3;
                    block58: {
                        String string4;
                        block57: {
                            String string5;
                            block56: {
                                String string6;
                                block55: {
                                    String string7;
                                    block54: {
                                        String string8;
                                        block53: {
                                            String string9;
                                            block51: {
                                                block52: {
                                                    connection = null;
                                                    prepareStatement = null;
                                                    rs = null;
                                                    Set<String> adjustIds = null;
                                                    Set<String> ids = null;
                                                    pool = null;
                                                    tmpTable = null;
                                                    returnFormId = null;
                                                    adjustTmpTable = null;
                                                    try {
                                                        String bgschemeId = (String)parameter.get("schemeId");
                                                        String orgId = (String)parameter.get("orgId");
                                                        String bgVersionId = (String)parameter.get("versionId");
                                                        String formula = (String)parameter.get("formula");
                                                        String bgFormId = (String)parameter.get("form");
                                                        String typeName = (String)parameter.get("processType");
                                                        BgProcessEnum processType = null;
                                                        BgFormInfo bgFormInfo = this.getBgFormInfo(ctx, bgFormId);
                                                        if (bgFormInfo == null) {
                                                            String string10 = null;
                                                            return string10;
                                                        }
                                                        String adjustFormId = bgFormInfo.getAdjustId() != null ? bgFormInfo.getAdjustId().toString() : "";
                                                        BgFormStateEnum state = bgFormInfo.getState();
                                                        if (!StringUtils.isEmpty((String)typeName)) {
                                                            processType = BgProcessEnum.getEnum(typeName);
                                                        }
                                                        BgSchemeInfo bgSchemeInfo = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeInfo("select refCube where id = '" + bgschemeId + "'");
                                                        String refCube = bgSchemeInfo.getRefCube();
                                                        String entryCubeName = null;
                                                        if (processType != null) {
                                                            if (BgProcessEnum.C01.equals((Object)processType)) {
                                                                entryCubeName = BgCubeUtils.getBudgetEntryCubeName(refCube);
                                                            } else if (BgProcessEnum.C02.equals((Object)processType)) {
                                                                entryCubeName = BgCubeUtils.getDecomposeEntryCubeName(refCube);
                                                                refCube = BgCubeUtils.getDecomposeCubeName(refCube);
                                                            } else if (BgProcessEnum.C03.equals((Object)processType)) {
                                                                entryCubeName = BgCubeUtils.getDecomposeSendDownEntryCubeName(refCube);
                                                                refCube = BgCubeUtils.getDecomposeSendDownCubeName(refCube);
                                                            } else if (BgProcessEnum.C04.equals((Object)processType)) {
                                                                entryCubeName = BgCubeUtils.getDecomposeGatherEntryCubeName(refCube);
                                                                refCube = BgCubeUtils.getDecomposeGatherCubeName(refCube);
                                                            }
                                                        }
                                                        if (StringUtils.isEmpty((String)refCube) || StringUtils.isEmpty(entryCubeName)) {
                                                            String string11 = null;
                                                            return string11;
                                                        }
                                                        connection = this.getConnection(ctx);
                                                        BgSchemeAccIntHelper accIntHelper = new BgSchemeAccIntHelper(ctx, bgschemeId, refCube);
                                                        HashSet<String> formulaSet = new HashSet<String>();
                                                        formulaSet.add(formula);
                                                        Set<String> cubeNames = accIntHelper.getSplitTablesByFormula(formulaSet);
                                                        String cubeName = cubeNames.toArray(new String[1])[0];
                                                        Object _orgUnitId = accIntHelper.convertOrgObject(orgId);
                                                        if (BgFormStateEnum.Adjusted.equals((Object)state) || BgFormStateEnum.AdjustApproving.equals((Object)state)) {
                                                            adjustIds = this.getFormIdSetWithAdjust(orgId, formula, bgVersionId, adjustFormId, bgschemeId, prepareStatement, rs, connection);
                                                            SQLUtils.cleanup(rs, prepareStatement);
                                                            if (adjustIds != null && adjustIds.contains(adjustFormId)) {
                                                                string9 = null;
                                                                SQLUtils.cleanup(rs, prepareStatement, (Connection)connection);
                                                                if (tmpTable == null) break block51;
                                                                break block52;
                                                            }
                                                            this.processAdjustFormId(ctx, connection, prepareStatement, rs, adjustIds);
                                                            SQLUtils.cleanup(rs, prepareStatement);
                                                        }
                                                        ids = this.getFormIdSetWithApproved(cubeName, entryCubeName, _orgUnitId, formula, bgVersionId, bgFormId, prepareStatement, rs, connection);
                                                        SQLUtils.cleanup(rs, prepareStatement);
                                                        if (ids == null || ids.isEmpty() || ids.contains(bgFormId)) {
                                                            string8 = null;
                                                            SQLUtils.cleanup(rs, prepareStatement, (Connection)connection);
                                                            break block53;
                                                        }
                                                        pool = TempTablePool.getInstance((Context)ctx);
                                                        tmpTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                                                        BgDBUtils.insertKey((Connection)connection, (String)("Insert Into " + tmpTable + " (FID) values (?)"), ids);
                                                        if ((BgFormStateEnum.Adjusted.equals((Object)state) || BgFormStateEnum.AdjustApproving.equals((Object)state)) && adjustIds != null && !adjustIds.isEmpty()) {
                                                            adjustTmpTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                                                            BgDBUtils.insertKey((Connection)connection, (String)("Insert Into " + adjustTmpTable + " (FID) values (?)"), adjustIds);
                                                        } else if ((BgFormStateEnum.Adjusted.equals((Object)state) || BgFormStateEnum.AdjustApproving.equals((Object)state)) && adjustIds != null && adjustIds.isEmpty()) {
                                                            adjustIds = this.getFormId(_orgUnitId, formula, bgVersionId, adjustFormId, bgschemeId, prepareStatement, rs, connection, cubeName, entryCubeName);
                                                            SQLUtils.cleanup(rs, prepareStatement);
                                                            if (adjustIds != null && adjustIds.contains(adjustFormId)) {
                                                                string7 = null;
                                                                SQLUtils.cleanup(rs, prepareStatement, (Connection)connection);
                                                                break block54;
                                                            }
                                                            this.processAdjustFormId(ctx, connection, prepareStatement, rs, adjustIds);
                                                            SQLUtils.cleanup(rs, prepareStatement);
                                                            adjustTmpTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                                                            BgDBUtils.insertKey((Connection)connection, (String)("Insert Into " + adjustTmpTable + " (FID) values (?)"), adjustIds);
                                                        }
                                                        if ((BgFormStateEnum.Adjusted.equals((Object)state) || BgFormStateEnum.AdjustApproving.equals((Object)state)) && !StringUtils.isEmpty((String)adjustTmpTable)) {
                                                            returnFormId = this.getFormIdWithTCPVS(connection, adjustTmpTable, bgFormInfo, prepareStatement, rs);
                                                            SQLUtils.cleanup(rs, prepareStatement);
                                                            if (!StringUtils.isEmpty((String)returnFormId)) {
                                                                string6 = returnFormId;
                                                                SQLUtils.cleanup(rs, prepareStatement, (Connection)connection);
                                                                break block55;
                                                            }
                                                            returnFormId = this.getFormIdWithTS(connection, adjustTmpTable, bgFormInfo, prepareStatement, rs);
                                                            SQLUtils.cleanup(rs, prepareStatement);
                                                            if (!StringUtils.isEmpty((String)returnFormId)) {
                                                                string5 = returnFormId;
                                                                SQLUtils.cleanup(rs, prepareStatement, (Connection)connection);
                                                                break block56;
                                                            }
                                                            returnFormId = this.getFormIdWithState(connection, adjustTmpTable, bgFormInfo, prepareStatement, rs);
                                                            SQLUtils.cleanup(rs, prepareStatement);
                                                            if (!StringUtils.isEmpty((String)returnFormId)) {
                                                                string4 = returnFormId;
                                                                SQLUtils.cleanup(rs, prepareStatement, (Connection)connection);
                                                                break block57;
                                                            }
                                                        }
                                                        returnFormId = this.getFormIdWithTCPV(connection, tmpTable, bgFormInfo, prepareStatement, rs);
                                                        SQLUtils.cleanup(rs, prepareStatement);
                                                        if (!StringUtils.isEmpty((String)returnFormId)) {
                                                            string3 = returnFormId;
                                                            SQLUtils.cleanup(rs, prepareStatement, (Connection)connection);
                                                            break block58;
                                                        }
                                                        returnFormId = this.getFormIdWithTemplate(connection, tmpTable, bgFormInfo, prepareStatement, rs);
                                                        SQLUtils.cleanup(rs, prepareStatement);
                                                        if (!StringUtils.isEmpty((String)returnFormId)) {
                                                            string2 = returnFormId;
                                                            SQLUtils.cleanup(rs, prepareStatement, (Connection)connection);
                                                            break block59;
                                                        }
                                                        returnFormId = this.getFormIdWithOutTemplate(connection, tmpTable, prepareStatement, rs);
                                                        SQLUtils.cleanup(rs, prepareStatement);
                                                        if (!StringUtils.isEmpty((String)returnFormId)) {
                                                            string = returnFormId;
                                                            SQLUtils.cleanup(rs, prepareStatement, (Connection)connection);
                                                            break block60;
                                                        }
                                                        SQLUtils.cleanup(rs, prepareStatement, (Connection)connection);
                                                        break block61;
                                                    }
                                                    catch (Exception e) {
                                                        throw new BOSException((Throwable)e);
                                                    }
                                                }
                                                BgDBUtils.releaseTmpTable(pool, tmpTable);
                                            }
                                            if (adjustTmpTable == null) return string9;
                                            BgDBUtils.releaseTmpTable((TempTablePool)pool, adjustTmpTable);
                                            return string9;
                                        }
                                        if (tmpTable != null) {
                                            BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpTable);
                                        }
                                        if (adjustTmpTable == null) return string8;
                                        BgDBUtils.releaseTmpTable((TempTablePool)pool, adjustTmpTable);
                                        return string8;
                                    }
                                    if (tmpTable != null) {
                                        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTable);
                                    }
                                    if (adjustTmpTable == null) return string7;
                                    BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)adjustTmpTable);
                                    return string7;
                                }
                                if (tmpTable != null) {
                                    BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTable);
                                }
                                if (adjustTmpTable == null) return string6;
                                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)adjustTmpTable);
                                return string6;
                            }
                            if (tmpTable != null) {
                                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTable);
                            }
                            if (adjustTmpTable == null) return string5;
                            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)adjustTmpTable);
                            return string5;
                        }
                        if (tmpTable != null) {
                            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTable);
                        }
                        if (adjustTmpTable == null) return string4;
                        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)adjustTmpTable);
                        return string4;
                    }
                    if (tmpTable != null) {
                        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTable);
                    }
                    if (adjustTmpTable == null) return string3;
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)adjustTmpTable);
                    return string3;
                }
                if (tmpTable != null) {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTable);
                }
                if (adjustTmpTable == null) return string2;
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)adjustTmpTable);
                return string2;
            }
            if (tmpTable != null) {
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTable);
            }
            if (adjustTmpTable == null) return string;
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)adjustTmpTable);
            return string;
        }
        if (tmpTable != null) {
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTable);
        }
        if (adjustTmpTable == null) return returnFormId;
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)adjustTmpTable);
        return returnFormId;
        finally {
            SQLUtils.cleanup(rs, prepareStatement, connection);
            if (tmpTable != null) {
                BgDBUtils.releaseTmpTable(pool, tmpTable);
            }
            if (adjustTmpTable != null) {
                BgDBUtils.releaseTmpTable(pool, adjustTmpTable);
            }
        }
    }

    private Set<String> getFormIdSetWithAdjust(String orgId, String formula, String bgVersionId, String adjustFormId, String bgschemeId, PreparedStatement prepareStatement, ResultSet rs, Connection connection) throws SQLException {
        HashSet<String> adjustIds = new HashSet<String>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT entry.FFormID FROM ");
        sql.append("T_MBG_BGTMPDATA bgdata,");
        sql.append("T_MBG_BGTMPDATAENTRY entry ");
        sql.append("WHERE bgdata.FID = entry.FDataID ");
        sql.append("AND bgdata.FFormula= ? ");
        sql.append("AND bgdata.FOrgUnitID= ? and bgdata.FVersion= ? ");
        sql.append("AND bgdata.FBGSCHEMEROOTID = ? ");
        prepareStatement = connection.prepareStatement(sql.toString());
        prepareStatement.setString(1, formula);
        prepareStatement.setString(2, orgId);
        prepareStatement.setInt(3, Integer.valueOf(bgVersionId));
        prepareStatement.setString(4, bgschemeId);
        rs = prepareStatement.executeQuery();
        while (rs.next()) {
            if (adjustIds == null) {
                adjustIds = new HashSet();
            }
            adjustIds.add(rs.getString("FFormID"));
        }
        return adjustIds;
    }

    private Set<String> getFormId(Object orgId, String formula, String bgVersionId, String adjustFormId, String bgschemeId, PreparedStatement prepareStatement, ResultSet rs, Connection connection, String refCube, String entryCubeName) throws SQLException {
        HashSet<String> adjustIds = new HashSet<String>();
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT entry.FFORMID formId FROM ");
        sql.append(entryCubeName + " entry, ");
        sql.append(refCube + " cubeData ");
        sql.append(" WHERE entry.FDataId = cubeData.FID ");
        sql.append(" AND cubeData.FVersion= ? ");
        sql.append(" AND cubeData.FFormula= ? ");
        sql.append(" AND  cubeData.FOrgUnitID= ? ");
        prepareStatement = connection.prepareStatement(sql.toString());
        prepareStatement.setInt(1, Integer.valueOf(bgVersionId));
        prepareStatement.setString(2, formula);
        prepareStatement.setObject(3, orgId);
        rs = prepareStatement.executeQuery();
        while (rs.next()) {
            if (adjustIds == null) {
                adjustIds = new HashSet();
            }
            adjustIds.add(rs.getString("formId"));
        }
        return adjustIds;
    }

    private Set<String> getFormIdSetWithApproved(String refCube, String entryCubeName, Object orgId, String formula, String bgVersionId, String bgFormId, PreparedStatement prepareStatement, ResultSet rs, Connection connection) throws SQLException {
        HashSet<String> ids = new HashSet<String>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT entry.FFormID FROM ");
        sql.append(refCube + " bgdata,");
        sql.append(entryCubeName + " entry ");
        sql.append("WHERE bgdata.FID = entry.FDataID ");
        sql.append("AND bgdata.FFormula= ? ");
        sql.append("AND bgdata.FOrgUnitID= ? and bgdata.FVersion= ? ");
        prepareStatement = connection.prepareStatement(sql.toString());
        prepareStatement.setString(1, formula);
        prepareStatement.setObject(2, orgId);
        prepareStatement.setInt(3, Integer.valueOf(bgVersionId));
        rs = prepareStatement.executeQuery();
        while (rs.next()) {
            ids.add(rs.getString("FFormID"));
        }
        return ids;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processAdjustFormId(Context ctx, Connection connection, PreparedStatement prepareStatement, ResultSet rs, Set<String> ids) throws Exception {
        TempTablePool pool = null;
        String tmpTable = null;
        try {
            pool = TempTablePool.getInstance((Context)ctx);
            tmpTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)connection, (String)("Insert Into " + tmpTable + " (FID) values (?)"), ids);
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT bgform.FID FROM T_MBG_BgForm bgform," + tmpTable + " tmp ");
            sql.append("WHERE bgform.FAdjustID = tmp.FID ");
            sql.append("AND bgform.FState <> ? ");
            sql.append("AND bgform.FID <> bgform.FAdjustID ");
            prepareStatement = connection.prepareStatement(sql.toString());
            prepareStatement.setInt(1, 15);
            rs = prepareStatement.executeQuery();
            ids.clear();
            while (rs.next()) {
                if (StringUtils.isEmpty((String)rs.getString("FID"))) continue;
                ids.add(rs.getString("FID"));
            }
            if (tmpTable == null) return;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (tmpTable == null) throw throwable;
                BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpTable);
                throw throwable;
            }
        }
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTable);
        return;
    }

    private String getFormIdWithOutTemplate(Connection connection, String tmpTable, PreparedStatement prepareStatement, ResultSet rs) throws SQLException {
        String returnFormId = null;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT TOP 1 bgform.FID FROM T_MBG_BgForm bgform," + tmpTable + " tmp ");
        sql.append("WHERE bgform.FID = tmp.FID ");
        sql.append("AND bgform.FState <> ? ");
        prepareStatement = connection.prepareStatement(sql.toString());
        prepareStatement.setInt(1, 15);
        rs = prepareStatement.executeQuery();
        while (rs.next()) {
            returnFormId = rs.getString("FID");
        }
        return returnFormId;
    }

    private String getFormIdWithTemplate(Connection connection, String tmpTable, BgFormInfo bgFormInfo, PreparedStatement prepareStatement, ResultSet rs) throws SQLException {
        String returnFormId = null;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT TOP 1 bgform.FID FROM T_MBG_BgForm bgform," + tmpTable + " tmp ");
        sql.append("WHERE bgform.FID = tmp.FID ");
        sql.append("AND bgform.FState <> ? ");
        sql.append("AND bgform.FBgTemplateID = ? ");
        prepareStatement = connection.prepareStatement(sql.toString());
        prepareStatement.setInt(1, 15);
        prepareStatement.setString(2, bgFormInfo.getBgTemplate().getId().toString());
        rs = prepareStatement.executeQuery();
        while (rs.next()) {
            returnFormId = rs.getString("FID");
        }
        return returnFormId;
    }

    private String getFormIdWithTCPV(Connection connection, String tmpTable, BgFormInfo bgFormInfo, PreparedStatement prepareStatement, ResultSet rs) throws SQLException {
        String returnFormId = null;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT TOP 1 bgform.FID FROM T_MBG_BgForm bgform," + tmpTable + " tmp ");
        sql.append("WHERE bgform.FID = tmp.FID ");
        sql.append("AND bgform.FState <> ? ");
        sql.append("AND bgform.FBgTemplateID = ? ");
        sql.append("AND bgform.FBgVersionID = ? ");
        sql.append("AND bgform.FBgPeriodID = ? ");
        sql.append("AND bgform.FCurrencyID = ? ");
        prepareStatement = connection.prepareStatement(sql.toString());
        prepareStatement.setInt(1, 15);
        prepareStatement.setString(2, bgFormInfo.getBgTemplate().getId().toString());
        prepareStatement.setString(3, bgFormInfo.getBgVersion().getId().toString());
        prepareStatement.setString(4, bgFormInfo.getBgPeriod().getId().toString());
        prepareStatement.setString(5, bgFormInfo.getCurrency().getId().toString());
        rs = prepareStatement.executeQuery();
        while (rs.next()) {
            returnFormId = rs.getString("FID");
        }
        return returnFormId;
    }

    private String getFormIdWithState(Connection connection, String tmpTable, BgFormInfo bgFormInfo, PreparedStatement prepareStatement, ResultSet rs) throws SQLException {
        String returnFormId = null;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT TOP 1 bgform.FID FROM T_MBG_BgForm bgform," + tmpTable + " tmp ");
        sql.append("WHERE bgform.FID = tmp.FID ");
        sql.append("AND bgform.FState IN (?, ?) ");
        prepareStatement = connection.prepareStatement(sql.toString());
        prepareStatement.setInt(1, BgFormStateEnum.Adjusted.getValue());
        prepareStatement.setInt(2, BgFormStateEnum.AdjustApproving.getValue());
        rs = prepareStatement.executeQuery();
        while (rs.next()) {
            returnFormId = rs.getString("FID");
        }
        return returnFormId;
    }

    private String getFormIdWithTS(Connection connection, String tmpTable, BgFormInfo bgFormInfo, PreparedStatement prepareStatement, ResultSet rs) throws SQLException {
        String returnFormId = null;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT TOP 1 bgform.FID FROM T_MBG_BgForm bgform," + tmpTable + " tmp ");
        sql.append("WHERE bgform.FID = tmp.FID ");
        sql.append("AND bgform.FState IN (?, ?) ");
        sql.append("AND bgform.FBgTemplateID = ? ");
        prepareStatement = connection.prepareStatement(sql.toString());
        prepareStatement.setInt(1, BgFormStateEnum.Adjusted.getValue());
        prepareStatement.setInt(2, BgFormStateEnum.AdjustApproving.getValue());
        prepareStatement.setString(3, bgFormInfo.getBgTemplate().getId().toString());
        rs = prepareStatement.executeQuery();
        while (rs.next()) {
            returnFormId = rs.getString("FID");
        }
        return returnFormId;
    }

    private String getFormIdWithTCPVS(Connection connection, String tmpTable, BgFormInfo bgFormInfo, PreparedStatement prepareStatement, ResultSet rs) throws SQLException {
        String returnFormId = null;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT TOP 1 bgform.FID FROM T_MBG_BgForm bgform," + tmpTable + " tmp ");
        sql.append("WHERE bgform.FID = tmp.FID ");
        sql.append("AND bgform.FState IN (?, ?) ");
        sql.append("AND bgform.FBgTemplateID = ? ");
        sql.append("AND bgform.FBgVersionID = ? ");
        sql.append("AND bgform.FBgPeriodID = ? ");
        sql.append("AND bgform.FCurrencyID = ? ");
        prepareStatement = connection.prepareStatement(sql.toString());
        prepareStatement.setInt(1, BgFormStateEnum.Adjusted.getValue());
        prepareStatement.setInt(2, BgFormStateEnum.AdjustApproving.getValue());
        prepareStatement.setString(3, bgFormInfo.getBgTemplate().getId().toString());
        prepareStatement.setString(4, bgFormInfo.getBgVersion().getId().toString());
        prepareStatement.setString(5, bgFormInfo.getBgPeriod().getId().toString());
        prepareStatement.setString(6, bgFormInfo.getCurrency().getId().toString());
        rs = prepareStatement.executeQuery();
        while (rs.next()) {
            returnFormId = rs.getString("FID");
        }
        return returnFormId;
    }

    private BgFormInfo getBgFormInfo(Context ctx, String bgFormId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgFormId)) {
            return null;
        }
        return BgFormFactory.getLocalInstance(ctx).getBgFormInfo("where id = '" + bgFormId + "'");
    }

    @Override
    public Map _getDimNumberIsLeaf(Context ctx, Map dimNumberMap, String bgSchemeId) throws BOSException, EASBizException {
        HashMap<String, Boolean> leafDataMap = new HashMap<String, Boolean>();
        if (ctx == null || dimNumberMap == null || bgSchemeId == null) {
            return leafDataMap;
        }
        BgSchemeInfo bgSchemeInfo = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeInfo("select id, name, number, bgDimSettings.*, bgDimSettings.members.* where id = '" + bgSchemeId + "'");
        Object rst = null;
        String viewId = null;
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("longNumber");
        evi.getSelector().add("isLeaf");
        evi.setFilter(new FilterInfo());
        IMbgMember memInterface = MbgMemberFactory.getLocalInstance((Context)ctx);
        IBgAccount accInterface = BgAccountFactory.getLocalInstance((Context)ctx);
        IBgOrgUnit orgInterface = BgOrgUnitFactory.getLocalInstance(ctx);
        HashMap mp = new HashMap(dimNumberMap);
        ArrayList<String> orgIds = new ArrayList<String>(bgSchemeInfo.getOrgViewIds());
        String orgViewId = StringUtils.cnulls((String)((String)orgIds.get(0)), null);
        String accViewId = StringUtils.cnulls((Object)bgSchemeInfo.getViewId(DimensionBaseConstants.DEF_ACCOUNT_NUMBER), null);
        HashMap<String, String> viewIdMap = new HashMap<String, String>();
        if (viewId == null) {
            HashSet set = new HashSet(mp.keySet());
            set.remove(DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER);
            set.remove(DimensionBaseConstants.DEF_INDEX_SRCNUMBER);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setSelector(new SelectorItemCollection());
            entityViewInfo.getSelector().add("id");
            entityViewInfo.getSelector().add("number");
            entityViewInfo.getSelector().add("srcNumber");
            entityViewInfo.setFilter(new FilterInfo());
            entityViewInfo.getFilter().getFilterItems().add(new FilterItemInfo("srcNumber", (Object)set, CompareType.INCLUDE));
            MbgDimCollection mbgDimCollection = MbgDimFactory.getLocalInstance((Context)ctx).getMbgDimCollection(entityViewInfo);
            for (int i = 0; i < mbgDimCollection.size(); ++i) {
                MbgDimInfo mbgDimInfo = mbgDimCollection.get(i);
                viewId = StringUtils.cnulls((Object)bgSchemeInfo.getViewId(mbgDimInfo.getNumber()), null);
                if (viewIdMap.containsKey(mbgDimInfo.getSrcNumber())) continue;
                viewIdMap.put(mbgDimInfo.getSrcNumber(), viewId);
            }
        }
        try {
            for (Map.Entry entry : mp.entrySet()) {
                int i;
                String srcNumber = (String)entry.getKey();
                Set numberSet = (Set)entry.getValue();
                if (srcNumber.equalsIgnoreCase(DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER)) {
                    evi.getFilter().getFilterItems().clear();
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)orgViewId));
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)numberSet, CompareType.INCLUDE));
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("isVirtual", (Object)Boolean.FALSE));
                    BgOrgUnitCollection bgOrgUnitCollection = orgInterface.getBgOrgUnitCollection(evi);
                    for (i = 0; i < bgOrgUnitCollection.size(); ++i) {
                        BgOrgUnitInfo bgOrgUnitInfo = bgOrgUnitCollection.get(i);
                        leafDataMap.put(srcNumber + ":" + bgOrgUnitInfo.getNumber(), bgOrgUnitInfo.isIsLeaf());
                    }
                    continue;
                }
                if (srcNumber.equalsIgnoreCase(DimensionBaseConstants.DEF_INDEX_SRCNUMBER)) {
                    evi.getFilter().getFilterItems().clear();
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("bgAccountView.id", (Object)accViewId));
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)numberSet, CompareType.INCLUDE));
                    BgAccountCollection bgAccountCollection = accInterface.getBgAccountCollection(evi);
                    for (i = 0; i < bgAccountCollection.size(); ++i) {
                        BgAccountInfo bgAccountInfo = bgAccountCollection.get(i);
                        leafDataMap.put(srcNumber + ":" + bgAccountInfo.getNumber(), bgAccountInfo.isIsLeaf());
                    }
                    continue;
                }
                if (srcNumber.equalsIgnoreCase(DimensionBaseConstants.DEF_INDEX_SRCNUMBER)) continue;
                evi.getFilter().getFilterItems().clear();
                evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", viewIdMap.get(srcNumber)));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)numberSet, CompareType.INCLUDE));
                MbgMemberCollection mbgMemberCollection = memInterface.getMbgMemberCollection(evi);
                for (i = 0; i < mbgMemberCollection.size(); ++i) {
                    MbgMemberInfo mbgMemberInfo = mbgMemberCollection.get(i);
                    leafDataMap.put(srcNumber + ":" + mbgMemberInfo.getNumber(), mbgMemberInfo.isIsLeaf());
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return leafDataMap;
    }
}

