/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgDynIndexInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.app.AbstractBgDynIndexControllerBean;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgDynIndexControllerBean
extends AbstractBgDynIndexControllerBean {
    private static final long serialVersionUID = 8629880357075921125L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgDynIndexControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgDynIndexInfo info = (BgDynIndexInfo)model;
        if (this.isNumberExists(ctx, info)) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{info.getNumber()});
        }
        if (this.isNameExists(ctx, info)) {
            throw new EASBizException(EASBizException.CHECKNAMEDUP, new Object[]{info.getName()});
        }
        if (info.getId() == null) {
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        }
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BgDynIndexInfo info = (BgDynIndexInfo)model;
        if (this.isNumberExists(ctx, info)) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{info.getNumber()});
        }
        if (this.isNameExists(ctx, info)) {
            throw new EASBizException(EASBizException.CHECKNAMEDUP, new Object[]{info.getName()});
        }
        super._update(ctx, pk, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    private boolean isNumberExists(Context ctx, BgDynIndexInfo info) throws EASBizException, BOSException {
        if (info == null || StringUtils.isEmpty((String)info.getNumber())) {
            return true;
        }
        String number = info.getNumber();
        String bgSchemeId = info.getBgScheme().getId().toString();
        String oql = null;
        oql = info.getId() == null ? "select id where number = '" + number + "' and bgScheme.id = '" + bgSchemeId + "'" : "select id where number = '" + number + "' and bgScheme.id = '" + bgSchemeId + "' and id <> '" + info.getId().toString() + "'";
        return this._exists(ctx, oql);
    }

    private boolean isNameExists(Context ctx, BgDynIndexInfo info) throws EASBizException, BOSException {
        if (info == null || StringUtils.isEmpty((String)info.getName())) {
            return true;
        }
        String name = info.getName();
        String bgSchemeId = info.getBgScheme().getId().toString();
        String oql = null;
        oql = info.getId() == null ? "select id where name = '" + name + "' and bgScheme.id = '" + bgSchemeId + "'" : "select id where name = '" + name + "' and bgScheme.id = '" + bgSchemeId + "' and id <> '" + info.getId().toString() + "'";
        return this._exists(ctx, oql);
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        BgDynIndexInfo groupInfo = (BgDynIndexInfo)model;
        FilterInfo curCUFilter = new FilterInfo();
        if (groupInfo != null) {
            try {
                groupInfo = (BgDynIndexInfo)this._getValue(ctx, "select bgScheme.id where id = '" + groupInfo.getId().toString() + "'");
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
            if (groupInfo.getBgScheme() != null) {
                curCUFilter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)groupInfo.getBgScheme().getId().toString(), CompareType.EQUALS));
            }
        }
        return curCUFilter;
    }

    @Override
    protected void _deleteOrgRef(Context ctx, String indexID) throws BOSException, EASBizException {
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgDBUtils.executeUpdate((Connection)conn, (String)"delete from T_MBG_BgDynIndexOrg where FIndexID = ?", (Object[])new Object[]{indexID});
        }
        catch (SQLException e) {
            throw new BgException(BgException.DATABASEERROR);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected void _saveOrgRef(Context ctx, String indexID, Set setOrgIds, String treeID, int orgType) throws BOSException, EASBizException {
        PreparedStatement pstmt = null;
        Connection conn = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into T_MBG_BgDynIndexOrg").append(" (FIndexID, FOrgUnitID, FTreeID, FOrgType) Values (?,?,?,?)");
        int batchSize = 50;
        int batchIndex = 0;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (String object : setOrgIds) {
                pstmt.setString(1, indexID);
                pstmt.setString(2, object);
                pstmt.setString(3, treeID);
                pstmt.setInt(4, orgType);
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex > 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected Map _getOrgMap(Context ctx, String indexId) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        Statement pstmt = null;
        Connection conn = null;
        IRowSet rowSet = null;
        try {
            conn = this.getConnection(ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("select org.FOrgUnitID, d.FOrgType, org.fid,org.fnumber,org.flongnumber,org.fname_" + ctx.getLocale().getLanguage() + " from  T_MBG_BgDynIndexOrg d left join t_mbg_bgorgunit org on org.fid = d.FOrgUnitID where FIndexID = ? and FOrgType = 0 order by org.fnumber, org.flongnumber ");
            rowSet = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{indexId});
            BgOrgUnitInfo unitInfo = null;
            ArrayList<BgOrgUnitInfo> bgOrgList = new ArrayList<BgOrgUnitInfo>();
            while (rowSet.next()) {
                unitInfo = new BgOrgUnitInfo();
                unitInfo.setOrgUnitID(rowSet.getString(1));
                unitInfo.setId(BOSUuid.read((String)rowSet.getString(3)));
                unitInfo.setNumber(rowSet.getString(4));
                unitInfo.setLongNumber(rowSet.getString(5));
                unitInfo.setName(rowSet.getString(6));
                bgOrgList.add(unitInfo);
            }
            if (bgOrgList.size() > 0) {
                map.put("bgOrg", bgOrgList);
            }
            sql = new StringBuffer();
            sql.append("select d.FOrgUnitID, d.FTreeID, org.fid,org.fnumber,org.flongnumber,org.fname_" + ctx.getLocale().getLanguage() + " from  T_MBG_BgDynIndexOrg d left join t_org_baseunit org on org.fid = d.FOrgUnitID where FIndexID = ? and FOrgType = 1 order by org.fnumber, org.flongnumber ");
            rowSet = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{indexId});
            OrgUnitInfo orgInfo = null;
            ArrayList<OrgUnitInfo> OrgList = new ArrayList<OrgUnitInfo>();
            while (rowSet.next()) {
                orgInfo = new OrgUnitInfo();
                orgInfo.setString("uionID", rowSet.getString(2));
                orgInfo.setId(BOSUuid.read((String)rowSet.getString(3)));
                orgInfo.setNumber(rowSet.getString(4));
                orgInfo.setLongNumber(rowSet.getString(5));
                orgInfo.setName(rowSet.getString(6));
                OrgList.add(orgInfo);
            }
            if (OrgList.size() > 0) {
                map.put("cslOrg", OrgList);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rowSet, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rowSet, pstmt, (Connection)conn);
        return map;
    }
}

