/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgExamineCheckInfo;
import com.kingdee.eas.ma.mbg.BgExamineDataCheckResult;
import com.kingdee.eas.ma.mbg.BgExamineInfo;
import com.kingdee.eas.ma.mbg.BgExamineReportInfo;
import com.kingdee.eas.ma.mbg.BgExamineResult;
import com.kingdee.eas.ma.mbg.app.AbstractBgExamineCheckControllerBean;
import com.kingdee.eas.ma.mbg.app.utils.BgExamineServelHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgExamineCheckControllerBean
extends AbstractBgExamineCheckControllerBean {
    private static final long serialVersionUID = -1639774276375587357L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgExamineCheckControllerBean");

    @Override
    protected void _addnew(Context ctx, List billIds, BgExamineResult result) throws BOSException, EASBizException {
        if (ctx == null || billIds == null || billIds.isEmpty() || result == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        Object obj = null;
        String reportId = BOSUuid.create((BOSObjectType)new BgExamineReportInfo().getBOSType()).toString();
        BOSObjectType checkType = new BgExamineCheckInfo().getBOSType();
        result.setReportId(reportId);
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        Timestamp time = new Timestamp(System.currentTimeMillis());
        try {
            int i;
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("delete from T_MBG_BgExamineCheck where FBillId = ?");
            int in = billIds.size();
            for (i = 0; i < in; ++i) {
                obj = billIds.get(i);
                pstmt.setString(1, obj.toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement("Insert Into T_MBG_BgExamineReport (FID, FReport) values (?,?)");
            pstmt.setString(1, reportId);
            BgDBUtils.setBytes((PreparedStatement)pstmt, (int)2, (byte[])BgAnalyseHelper.getBytes(result));
            pstmt.executeUpdate();
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement("Insert Into T_MBG_BgExamineCheck (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FBillId, FReportID) values (?,?,?,?,?,?,?,?)");
            in = billIds.size();
            for (i = 0; i < in; ++i) {
                obj = billIds.get(i);
                if (!(obj instanceof String)) continue;
                pstmt.setString(1, BOSUuid.create((BOSObjectType)checkType).toString());
                pstmt.setString(2, user != null ? user.getId().toString() : null);
                pstmt.setTimestamp(3, time);
                pstmt.setString(4, user != null ? user.getId().toString() : null);
                pstmt.setTimestamp(5, time);
                pstmt.setString(6, null);
                pstmt.setString(7, obj.toString());
                pstmt.setString(8, reportId);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt);
            BgDBUtils.executeUpdate((Connection)conn, (String)"delete from T_MBG_BgExamineReport where not exists (select FReportID from T_MBG_BgExamineCheck where FReportID = T_MBG_BgExamineReport.FID)");
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"addnew examine check report error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _updateReport(Context ctx, List results) throws BOSException, EASBizException {
        if (results == null || results.isEmpty()) {
            return;
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (BgExamineResult r : results) {
            if (r.getReportId() == null) continue;
            paramList.add(new Object[]{BgAnalyseHelper.getBytes(r), r.getReportId()});
        }
        DbUtil.executeBatch((Context)ctx, (String)"Update T_MBG_BgExamineReport Set FReport = ? Where FID = ?", paramList);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _getReport(Context ctx, Set billIds) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        String tmpTable;
        ArrayList<Object> results;
        TempTablePool pool;
        block14: {
            if (billIds == null) return null;
            if (billIds.isEmpty()) {
                return null;
            }
            pool = TempTablePool.getInstance((Context)ctx);
            results = new ArrayList<Object>();
            tmpTable = null;
            conn = null;
            pstmt = null;
            rst = null;
            try {
                conn = this.getConnection(ctx);
                Map<String, Set<String>> billIdMap = BgExamineServelHelper.queryRefExamine(ctx, conn, pool, billIds);
                if (billIdMap == null || billIdMap.isEmpty()) {
                    List list = null;
                    return list;
                }
                billIds.retainAll(billIdMap.keySet());
                if (billIds.isEmpty()) {
                    List list = null;
                    return list;
                }
                Object obj = null;
                Object[] objs = null;
                tmpTable = pool.createTempTable("Create Table T_MBG_BgExamTmpRpt(FBillId Varchar(44) Not Null Primary Key, FCreateTime DateTime, FReportId Varchar(44))");
                MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + tmpTable + "(FBillId) Values(?)"), new ArrayList(billIds));
                MbgSqlHelper.execute((Connection)conn, (String)("Update " + tmpTable + " t0 Set FCreateTime = (Select Max(FCreateTime) FROM T_MBG_BgExamineCheck  t1 Where t0.FBillId = t1.FBillId)"));
                MbgSqlHelper.execute((Connection)conn, (String)("Update " + tmpTable + " t0 Set FReportId = (Select Top 1 FReportId FROM T_MBG_BgExamineCheck t1 Where t0.FBillId = t1.FBillId AND t0.FCreateTime = t1.FCreateTime)"));
                pstmt = conn.prepareStatement("select FID, FReport from T_MBG_BgExamineReport where FID IN (Select FReportId FROM " + tmpTable + " Where FReportId IS NOT NULL)");
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    obj = BgAnalyseHelper.getObject(BgDBUtils.getBytes((ResultSet)rst, (String)"FReport"));
                    objs = DimensionCommonHelper.getValues(obj);
                    if (objs != null) {
                        for (int i = 0; i < objs.length; ++i) {
                            if (!(objs[i] instanceof BgExamineResult) || ((BgExamineResult)objs[i]).getReportId() != null) continue;
                            ((BgExamineResult)objs[i]).setReportId(rst.getString("FID"));
                        }
                    }
                    if (obj == null) continue;
                    results.add(obj);
                }
                if (tmpTable == null) break block14;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            pool.releaseTable(tmpTable);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        if (!results.isEmpty()) return results;
        return null;
        finally {
            if (tmpTable != null) {
                pool.releaseTable(tmpTable);
            }
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
    }

    @Override
    protected Object _getReport(Context ctx, String billId) throws BOSException, EASBizException {
        if (ctx == null || billId == null) {
            return null;
        }
        HashSet<String> billIds = new HashSet<String>();
        billIds.add(billId);
        List results = this._getReport(ctx, billIds);
        if (results != null && !results.isEmpty()) {
            return results.get(0);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected Map _getOrgReport(Context ctx, Set billIds, String bgExamineId, Set passStats) throws BOSException, EASBizException {
        if (billIds == null || billIds.isEmpty()) {
            return null;
        }
        pool = TempTablePool.getInstance((Context)ctx);
        results = new HashMap<String, Object>();
        tmpTable = null;
        billId = null;
        conn = null;
        pstmt = null;
        rst = null;
        result = null;
        info = null;
        try {
            conn = this.getConnection(ctx);
            billIdMap = BgExamineServelHelper.queryRefExamine(ctx, conn, pool, billIds);
            if (billIdMap == null || billIdMap.isEmpty()) {
                var15_16 = null;
                return var15_16;
            }
            billIds.retainAll(billIdMap.keySet());
            if (billIds.isEmpty()) {
                var15_17 = null;
                return var15_17;
            }
            obj = null;
            objs = null;
            tmpTable = pool.createTempTable("Create Table T_MBG_BgExamTmpRpt(FBillId Varchar(44) Not Null Primary Key, FCreateTime DateTime, FReportId Varchar(44))");
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + tmpTable + "(FBillId) Values(?)"), new ArrayList<E>(billIds));
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + tmpTable + " t0 Set FCreateTime = (Select Max(FCreateTime) FROM T_MBG_BgExamineCheck  t1 Where t0.FBillId = t1.FBillId)"));
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + tmpTable + " t0 Set FReportId = (Select Top 1 FReportId FROM T_MBG_BgExamineCheck t1 Where t0.FBillId = t1.FBillId AND t0.FCreateTime = t1.FCreateTime)"));
            pstmt = conn.prepareStatement("select  t1.FReport, t2.FBillId, t1.FID from T_MBG_BgExamineReport t1 join T_MBG_BgExamineCheck t2 on t1.FID = t2.FReportId where t1.FID IN (Select FReportId FROM " + tmpTable + " Where FReportId IS NOT NULL ) and t2.FBillId in(Select FBillId FROM " + tmpTable + ")");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                obj = BgAnalyseHelper.getObject(BgDBUtils.getBytes((ResultSet)rst, (int)1));
                billId = rst.getString(2);
                if (obj == null || !billIdMap.containsKey(billId)) continue;
                objs = DimensionCommonHelper.getValues(obj);
                if (objs != null) {
                    for (i = 0; i < objs.length; ++i) {
                        if (!(objs[i] instanceof BgExamineResult)) continue;
                        result = (BgExamineResult)objs[i];
                        this.processBgExamineResult(result, bgExamineId, passStats);
                        if (result.getReportId() == null) {
                            ((BgExamineResult)objs[i]).setReportId(rst.getString("FID"));
                        }
                        if (StringUtils.isEmpty((String)bgExamineId)) continue;
                        for (BgExamineInfo info : result.examines) {
                            if (!billIdMap.get(billId).contains(info.getId().toString())) {
                                info.put(DimensionConstants.ISENABLE2, Boolean.FALSE);
                                continue;
                            }
                            info.remove(DimensionConstants.ISENABLE2);
                        }
                    }
                }
                if (obj == null) continue;
                results.put(rst.getString(2), obj);
            }
            ** if (tmpTable == null) goto lbl-1000
        }
        catch (Exception e) {
            BgExamineCheckControllerBean.logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tmpTable != null) {
                pool.releaseTable(tmpTable);
            }
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
lbl-1000:
        // 1 sources

        {
            pool.releaseTable(tmpTable);
        }
lbl-1000:
        // 2 sources

        {
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    protected void processBgExamineResult(BgExamineResult result, String bgExamineId, Set passStats) {
        BgExamineServelHelper.removeScopeFromResult(result);
        BgExamineInfo bgExamine = null;
        List<BgExamineInfo> examines = result.examines;
        List<BgExamineInfo> errors = result.errors;
        Map<String, Map<String, Map<String, List<BgExamineDataCheckResult>>>> checkResultMap = result.getSubsetCheckResultMap();
        Map<String, Map<String, List<BgExamineDataCheckResult>>> orgCheckMap = null;
        if (!StringUtils.isEmpty((String)bgExamineId) && examines != null && !examines.isEmpty()) {
            int index;
            for (index = examines.size() - 1; index > 0; --index) {
                if (bgExamineId.equals(examines.get(index).getId().toString())) continue;
                bgExamine = examines.get(index);
                HashSet<String> subsetId = new HashSet<String>();
                for (int i = 0; i < bgExamine.getBgExamineSubset().size(); ++i) {
                    subsetId.add(bgExamine.getBgExamineSubset().get(i).getId().toString());
                }
                Iterator<String> ite = checkResultMap.keySet().iterator();
                while (ite.hasNext()) {
                    orgCheckMap = checkResultMap.get(ite.next());
                    Iterator<String> it = orgCheckMap.keySet().iterator();
                    while (it.hasNext()) {
                        if (!subsetId.contains(it.next())) continue;
                        it.remove();
                    }
                }
                examines.remove(index);
            }
            for (index = errors.size() - 1; index > 0; --index) {
                if (bgExamineId.equals(errors.get(index).getId().toString())) continue;
                errors.remove(index);
            }
            if (passStats != null && !passStats.isEmpty() && !passStats.contains(0)) {
                for (index = errors.size() - 1; index > 0; --index) {
                    if (bgExamineId.equals(errors.get(index).getId().toString())) continue;
                    errors.remove(index);
                }
            }
        }
    }
}

