/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.biz.BizCalcException;
import com.kingdee.eas.ma.biz.app.utils.BizCalcServelHelper;
import com.kingdee.eas.ma.mbg.BgExamineCollection;
import com.kingdee.eas.ma.mbg.BgExamineFactory;
import com.kingdee.eas.ma.mbg.BgExamineGroupFactory;
import com.kingdee.eas.ma.mbg.BgExamineGroupInfo;
import com.kingdee.eas.ma.mbg.BgExamineHistCollection;
import com.kingdee.eas.ma.mbg.BgExamineHistFactory;
import com.kingdee.eas.ma.mbg.BgExamineInfo;
import com.kingdee.eas.ma.mbg.BgExamineParseException;
import com.kingdee.eas.ma.mbg.BgExamineRefBgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgExamineRefBgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgExamineStateEnum;
import com.kingdee.eas.ma.mbg.BgExamineSubsetCollection;
import com.kingdee.eas.ma.mbg.BgExamineSubsetFactory;
import com.kingdee.eas.ma.mbg.BgExamineSubsetInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgScopeCollection;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgVariateCollection;
import com.kingdee.eas.ma.mbg.BgVariateFactory;
import com.kingdee.eas.ma.mbg.BgVariateInfo;
import com.kingdee.eas.ma.mbg.IBgExamine;
import com.kingdee.eas.ma.mbg.IBgExamineGroup;
import com.kingdee.eas.ma.mbg.app.AbstractBgExamineControllerBean;
import com.kingdee.eas.ma.mbg.app.utils.BgExamineServelHelper;
import com.kingdee.eas.ma.mbg.common.BgCopySchemeResult;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgProcessHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.parse.BgExamineFormulaVerifyHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgExamineControllerBean
extends AbstractBgExamineControllerBean {
    private static final long serialVersionUID = 7772475868044296038L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgExamineControllerBean");
    protected String RES = "com.kingdee.eas.ma.mbg.BgSchemeCopyResource";

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._submit(ctx, model);
        this.dealBgTemplate(ctx, model);
        return pk;
    }

    private void dealBgTemplate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgTemplateCollection refBgTemplateColl;
        BgExamineInfo currBgExamineInfo = (BgExamineInfo)model;
        if (!(currBgExamineInfo.get("bgtemplate") instanceof BgTemplateCollection)) {
            return;
        }
        if (currBgExamineInfo.getId() != null) {
            BgExamineRefBgTemplateFactory.getLocalInstance(ctx).delete("where bgExamine.id = '" + currBgExamineInfo.getId() + "'");
        }
        if ((refBgTemplateColl = (BgTemplateCollection)((Object)currBgExamineInfo.get("bgtemplate"))) != null && refBgTemplateColl.size() != 0) {
            CoreBaseCollection colls = new CoreBaseCollection();
            BgExamineRefBgTemplateInfo refBgTemplate = null;
            int n = refBgTemplateColl.size();
            for (int i = 0; i < n; ++i) {
                refBgTemplate = new BgExamineRefBgTemplateInfo();
                refBgTemplate.setBgExamine(currBgExamineInfo);
                refBgTemplate.setBgTemplate(refBgTemplateColl.get(i));
                colls.add((CoreBaseInfo)refBgTemplate);
            }
            BgExamineRefBgTemplateFactory.getLocalInstance(ctx).addnew(colls);
        }
    }

    @Override
    protected IObjectPK _copyAddNew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this._submit(ctx, model);
    }

    @Override
    protected Map _batchDelete(Context ctx, List idList, String bgSchemeID) throws BOSException, EASBizException {
        if (idList == null || bgSchemeID == null) {
            return null;
        }
        Map<String, Set<String>> incorrectState = this.checkDeleteSavedBgExamine(ctx, bgSchemeID, idList);
        String id = null;
        if (!idList.isEmpty()) {
            ArrayList<ObjectUuidPK> pkList = new ArrayList<ObjectUuidPK>();
            int in = idList.size();
            for (int i = 0; i < in; ++i) {
                id = (String)idList.get(i);
                pkList.add(new ObjectUuidPK(id));
            }
            BgExamineServelHelper.deleteSubsets(ctx, pkList.toArray());
            BgExamineFactory.getLocalInstance(ctx).delete(pkList.toArray(new IObjectPK[pkList.size()]));
            BgExamineServelHelper.updateHist(ctx, new HashSet<String>(idList));
        }
        return incorrectState;
    }

    private Map<String, Set<String>> checkDeleteSavedBgExamine(Context ctx, String bgSchemeId, List idList) throws BOSException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        if (ctx == null || idList == null || idList.isEmpty()) {
            return result;
        }
        result.put("SavedMap", new HashSet());
        HashSet selectedBizRule = new HashSet();
        HashSet<String> removeSet = new HashSet<String>();
        selectedBizRule.addAll(idList);
        BgExamineCollection selectedBgExamines = this.getBgExamineCollectionByIds(ctx, bgSchemeId, selectedBizRule);
        BgExamineInfo bgExamineInfo = null;
        int count = selectedBgExamines.size();
        for (int i = 0; i < count; ++i) {
            bgExamineInfo = selectedBgExamines.get(i);
            if (bgExamineInfo.getState() != BgExamineStateEnum.SAVED) continue;
            ((Set)result.get("SavedMap")).add(bgExamineInfo.getNumber());
            removeSet.add(bgExamineInfo.getId().toString());
        }
        idList.removeAll(removeSet);
        return result;
    }

    @Override
    protected Map _batchCancel(Context ctx, Set bgExamineIds) throws BOSException, EASBizException {
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        HashSet inCorrectStateSet = new HashSet();
        result.put("incorrectNumSet", inCorrectStateSet);
        if (bgExamineIds == null || bgExamineIds.isEmpty()) {
            return result;
        }
        IBgExamine iBgExamine = BgExamineFactory.getLocalInstance(ctx);
        BgExamineCollection examineInfoColls = this.getBgExamineCollectionByIds(ctx, null, bgExamineIds);
        CoreBaseCollection updateColls = new CoreBaseCollection();
        BgExamineInfo tmpCalcInfo = null;
        for (int i = 0; i < examineInfoColls.size(); ++i) {
            tmpCalcInfo = examineInfoColls.get(i);
            if (tmpCalcInfo.getState().getValue() == 1) {
                tmpCalcInfo.setState(BgExamineStateEnum.DISABLE);
                tmpCalcInfo.setDisableTime(new Timestamp(System.currentTimeMillis()));
                tmpCalcInfo.setDisableUser(new UserInfo(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()));
                updateColls.add((CoreBaseInfo)tmpCalcInfo);
                continue;
            }
            ((Set)result.get("incorrectNumSet")).add(tmpCalcInfo.getNumber());
        }
        result.put("cancelFailCount", Integer.valueOf(examineInfoColls.size() - updateColls.size()));
        result.put("totalSize", Integer.valueOf(examineInfoColls.size()));
        if (!updateColls.isEmpty()) {
            HashSet<String> ids = new HashSet<String>();
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add("id");
            view.getSelector().add("sourceBgExamineId");
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sourceBgExamineId", (Object)bgExamineIds, CompareType.INCLUDE));
            view.setFilter(filter);
            BgExamineHistCollection histCol = BgExamineHistFactory.getLocalInstance(ctx).getBgExamineHistCollection(view);
            if (histCol != null && !histCol.isEmpty()) {
                int in = histCol.size();
                for (int i = 0; i < in; ++i) {
                    ids.add(histCol.get(i).getSourceBgExamineId());
                }
            }
            CoreBaseCollection needAddHis = new CoreBaseCollection();
            int in = updateColls.size();
            for (int i = 0; i < in; ++i) {
                if (ids.contains(updateColls.get(i).getId().toString())) continue;
                needAddHis.add(updateColls.get(i));
            }
            BgExamineServelHelper.addHist(ctx, needAddHis, false, true);
            iBgExamine.updateBatchData(updateColls);
        }
        return result;
    }

    @Override
    protected Map _cancelCancelColls(Context ctx, Set bgExamineIds, String bgSchemeId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (bgExamineIds == null || bgExamineIds.isEmpty() || StringUtils.isEmpty((String)bgSchemeId)) {
            return result;
        }
        BgExamineCollection examineInfoColls = this.getBgExamineCollectionByIds(ctx, bgSchemeId, bgExamineIds);
        CoreBaseCollection updateColls = new CoreBaseCollection();
        HashSet<BgExamineInfo> examineInfoSet = new HashSet<BgExamineInfo>();
        HashMap<String, BgExamineInfo> tmpMap = new HashMap<String, BgExamineInfo>();
        BgExamineInfo tmpExamineInfo = null;
        for (int i = 0; i < examineInfoColls.size(); ++i) {
            tmpExamineInfo = examineInfoColls.get(i);
            if (tmpExamineInfo.getState().getValue() != 1) {
                tmpExamineInfo.setState(BgExamineStateEnum.SAVED);
                tmpExamineInfo.setEnableTime(new Timestamp(System.currentTimeMillis()));
                tmpExamineInfo.setEnableUser(new UserInfo(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()));
                tmpMap.put(tmpExamineInfo.getNumber(), tmpExamineInfo);
                examineInfoSet.add(tmpExamineInfo);
                continue;
            }
            if (result.get("incorrectNumSet") == null) {
                HashSet<String> inCorrectStateSet = new HashSet<String>();
                result.put("incorrectNumSet", inCorrectStateSet);
                inCorrectStateSet.add(tmpExamineInfo.getNumber());
                continue;
            }
            ((Set)result.get("incorrectNumSet")).add(tmpExamineInfo.getNumber());
        }
        Map<String, String> verifyResultMsg = this.getVerifyResultMsgByExamineColls(ctx, examineInfoSet, bgSchemeId);
        String calcNum2 = null;
        for (String calcNum2 : tmpMap.keySet()) {
            if (verifyResultMsg.containsKey(calcNum2)) continue;
            updateColls.add((CoreBaseInfo)tmpMap.get(calcNum2));
        }
        BgExamineServelHelper.addHist(ctx, updateColls, false, false);
        result.put("cancelFailCount", examineInfoColls.size() - updateColls.size());
        result.put("totalSize", examineInfoColls.size());
        result.put("verifyErrorMsg", this.combineAllKeysToStr(verifyResultMsg));
        if (!updateColls.isEmpty()) {
            BgExamineFactory.getLocalInstance(ctx).updateBatchData(updateColls);
        }
        return result;
    }

    private Map<String, String> getVerifyResultMsgByExamineColls(Context ctx, Set<BgExamineInfo> examineInfoSet, String bgSchemeId) throws EASBizException, BOSException {
        Map<String, String> resultMap = new HashMap<String, String>();
        if (ctx == null || examineInfoSet == null || examineInfoSet.isEmpty() || StringUtils.isEmpty((String)bgSchemeId)) {
            return resultMap;
        }
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
        resultMap = BgExamineServelHelper.getVerifyResultMsgByExamineColls(ctx, examineInfoSet, schemeHelper);
        return resultMap;
    }

    private String combineAllKeysToStr(Map<String, String> verifyResultMsg) {
        if (verifyResultMsg.isEmpty()) {
            return null;
        }
        return BgExamineServelHelper.combineAllKeysToStr(verifyResultMsg);
    }

    private BgExamineCollection getBgExamineCollectionByIds(Context ctx, String bgSchemeId, Set bgExamineIds) throws BOSException {
        return BgExamineServelHelper.getBgExamineCollectionByIds(ctx, bgSchemeId, bgExamineIds);
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        BgExamineInfo info = (BgExamineInfo)model;
        if (info == null || info.getBgScheme() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)info.getBgScheme().getId().toString(), CompareType.EQUALS));
        if (info.getOrgTree() != null) {
            filter.getFilterItems().add(new FilterItemInfo("orgTree.id", (Object)info.getOrgTree().getId().toString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("orgTree.id", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)info.getOrgUnit().getId().toString(), CompareType.EQUALS));
        }
        return filter;
    }

    @Override
    protected String _importBgExamine(Context ctx, String bgSchemeId, String orgUnitId, Map bgExamineMap, Map refBgTempMap, ErrorHandleModeEnum errorHandle) throws BOSException, EASBizException {
        if (bgExamineMap == null || bgExamineMap.isEmpty()) {
            return null;
        }
        BgSchemeInfo bgScheme = new BgSchemeInfo();
        bgScheme.setId(BOSUuid.read((String)bgSchemeId));
        FullOrgUnitInfo orgUnit = new FullOrgUnitInfo();
        orgUnit.setId(BOSUuid.read((String)orgUnitId));
        Map _bgExamineMap = bgExamineMap;
        Map _refBgTempMap = refBgTempMap;
        Map _relyMap = bgExamineMap;
        BgExamineInfo bgExamineInfo2 = null;
        BgTemplateCollection bgTemplateCol2 = null;
        BgTemplateInfo bgTemplateInfo = null;
        String bgExamineId2 = null;
        HashSet<String> keys = new HashSet<String>();
        HashMap<String, BgTemplateInfo> number_info = new HashMap<String, BgTemplateInfo>();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.setFilter(new FilterInfo());
        Iterator it = _bgExamineMap.values().iterator();
        while (it.hasNext()) {
            keys.add(((BgExamineInfo)it.next()).getNumber());
        }
        evi.getFilter().getFilterItems().clear();
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", keys, CompareType.INCLUDE));
        BgExamineCollection bgExamineCol = this.getBgExamineCollection(ctx, evi);
        HashSet<String> hasBizNumber = new HashSet<String>();
        if (bgExamineCol != null && !bgExamineCol.isEmpty()) {
            for (int i = 0; i < bgExamineCol.size(); ++i) {
                hasBizNumber.add(bgExamineCol.get(i).getNumber());
            }
        }
        if (_refBgTempMap != null && !_refBgTempMap.isEmpty()) {
            int i;
            keys.clear();
            for (BgTemplateCollection bgTemplateCol2 : _refBgTempMap.values()) {
                for (i = 0; i < bgTemplateCol2.size(); ++i) {
                    keys.add(bgTemplateCol2.get(i).getNumber());
                }
            }
            evi.getFilter().getFilterItems().clear();
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", keys, CompareType.INCLUDE));
            BgTemplateCollection tempCol = BgTemplateFactory.getLocalInstance(ctx).getBgTemplateCollection(evi);
            for (i = 0; i < tempCol.size(); ++i) {
                number_info.put(tempCol.get(i).getNumber(), tempCol.get(i));
            }
            for (String bgExamineId2 : _refBgTempMap.keySet()) {
                bgTemplateCol2 = (BgTemplateCollection)((Object)_refBgTempMap.get(bgExamineId2));
                Iterator it1 = bgTemplateCol2.iterator();
                while (it1.hasNext()) {
                    bgTemplateInfo = (BgTemplateInfo)it1.next();
                    if (!number_info.containsKey(bgTemplateInfo.getNumber())) {
                        it1.remove();
                        continue;
                    }
                    bgTemplateInfo.setId(((BgTemplateInfo)number_info.get(bgTemplateInfo.getNumber())).getId());
                }
                if (bgTemplateCol2.isEmpty() || !_bgExamineMap.containsKey(bgExamineId2)) continue;
                bgExamineInfo2 = (BgExamineInfo)_bgExamineMap.get(bgExamineId2);
                bgExamineInfo2.put("bgtemplate", (Object)bgTemplateCol2);
            }
        }
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
        LinkedHashMap<String, LinkedHashMap<String, String>> bgExamineFormulaMap = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        LinkedHashMap<String, Map<String, Set<String>>> bgScopeSrcMap = new LinkedHashMap<String, Map<String, Set<String>>>();
        LinkedHashMap<String, Map<String, BgScopeCollection>> bgScopeMap = new LinkedHashMap<String, Map<String, BgScopeCollection>>();
        BgExamineFormulaVerifyHelper.buildParseParam(_bgExamineMap.values(), bgExamineFormulaMap, bgScopeSrcMap, bgScopeMap, schemeHelper);
        BgExamineFormulaVerifyHelper formulaParser = new BgExamineFormulaVerifyHelper(bgExamineFormulaMap, bgScopeSrcMap, bgScopeMap, schemeHelper, true);
        formulaParser.batchParse();
        HashSet<String> parseErrorNumber = new HashSet<String>();
        for (String number : formulaParser.getAllExceptions().keySet()) {
            Map<String, Map<Integer, List<Exception>>> subsetException = formulaParser.getAllExceptions().get(number);
            for (Map<Integer, List<Exception>> lineException : subsetException.values()) {
                if (lineException.isEmpty()) continue;
                parseErrorNumber.add(number);
            }
        }
        StringBuffer message = new StringBuffer();
        int success = 0;
        boolean hasFail = !hasBizNumber.isEmpty() || !parseErrorNumber.isEmpty();
        IBgExamineGroup iBgExamineGroup = BgExamineGroupFactory.getLocalInstance(ctx);
        CoreBaseCollection subSetCol = new CoreBaseCollection();
        for (BgExamineInfo bgExamineInfo2 : _bgExamineMap.values()) {
            if (hasBizNumber.contains(bgExamineInfo2.getNumber())) {
                message.append(new BgExamineParseException(BgExamineParseException.NUMBEREXISTS, new Object[]{bgExamineInfo2.getNumber()}).getMessage());
                message.append("\r\n");
                continue;
            }
            if (!bgExamineInfo2.getBgExamineGroup().getId().toString().equals("PCto8jovS9md/v3tQ45tMIdbVAE=") && !iBgExamineGroup.exists((IObjectPK)new ObjectUuidPK(bgExamineInfo2.getBgExamineGroup().getId()))) {
                if (iBgExamineGroup.exists("where number = '" + bgExamineInfo2.getBgExamineGroup().getNumber() + "' and bgScheme.id = '" + bgSchemeId + "' and isCsl = 0")) {
                    BgExamineGroupInfo group = iBgExamineGroup.getBgExamineGroupInfo("where number = '" + bgExamineInfo2.getBgExamineGroup().getNumber() + "' and bgScheme.id = '" + bgSchemeId + "' and isCsl = 0 ");
                    if (group != null) {
                        bgExamineInfo2.setBgExamineGroup(group);
                    }
                } else {
                    message.append(new BgExamineParseException(BgExamineParseException.BGEXAMINEGROUP_NOTEXIST, new Object[]{bgExamineInfo2.getNumber()}).getMessage());
                    message.append("\r\n");
                    continue;
                }
            }
            if (formulaParser.getAllExceptions().containsKey(bgExamineInfo2.getNumber())) {
                boolean hasException = false;
                Map<String, Map<Integer, List<Exception>>> subsetException = formulaParser.getAllExceptions().get(bgExamineInfo2.getNumber());
                for (String subsetName : subsetException.keySet()) {
                    Map<Integer, List<Exception>> lineException = subsetException.get(subsetName);
                    ArrayList<Integer> keyList = new ArrayList<Integer>(lineException.keySet());
                    Collections.sort(keyList);
                    for (Integer line : keyList) {
                        hasException = true;
                        List<Exception> Exceptions = lineException.get(line);
                        for (Exception exception : Exceptions) {
                            message.append(exception.getMessage()).append("\r\n");
                        }
                    }
                }
                if (hasException) continue;
            }
            if (hasFail && ErrorHandleModeEnum.ReturnRightnow.equals((Object)errorHandle)) continue;
            ++success;
            subSetCol.addObjectCollection((IObjectCollection)bgExamineInfo2.getBgExamineSubset());
            bgExamineInfo2.setBgScheme(bgScheme);
            bgExamineInfo2.setOrgUnit(orgUnit);
            bgExamineInfo2.setVersion(bgExamineInfo2.getVersion() == null ? BizCalcServelHelper.DEFAULT_VERSION : bgExamineInfo2.getVersion());
            this._submit(ctx, (IObjectValue)bgExamineInfo2);
            BgExamineSubsetFactory.getLocalInstance(ctx).saveBatchData(subSetCol);
            if (!BgExamineStateEnum.SAVED.equals((Object)bgExamineInfo2.getState())) continue;
            bgExamineInfo2.setVersion(null);
            this.addHist(ctx, bgExamineInfo2, false, false);
        }
        if (message.length() != 0) {
            message.insert(0, new BizCalcException(BizCalcException.IMPORTFAIL, new Object[]{_bgExamineMap.size() - success}).getMessage() + "\r\n");
            message.insert(0, new BizCalcException(BizCalcException.IMPORTSUCCESS, new Object[]{success}).getMessage() + "\r\n");
        }
        return message.toString();
    }

    @Override
    protected Map _queryDimMember(Context ctx, Map dimMemMap, String bgSchemeID, boolean onlyNeedNumber, String orgTreeId) throws BOSException, EASBizException {
        String defaultBgSchemeID = bgSchemeID;
        HashMap existDimMemMap = new HashMap();
        HashSet<Object> memSet = null;
        for (Object scheme : dimMemMap.keySet()) {
            String bgScheme = scheme.toString();
            Map tmpMap = (Map)dimMemMap.get(bgScheme);
            if (!bgScheme.equals("default_bgScheme")) {
                bgSchemeID = this.getBgSchemeIdByNum(ctx, bgScheme);
                if (bgSchemeID == null) {
                    continue;
                }
            } else {
                bgSchemeID = defaultBgSchemeID;
            }
            for (Object obj : tmpMap.keySet()) {
                String dimNum = (String)obj;
                if (StringUtils.isEmpty((String)dimNum)) continue;
                Set numbers = (Set)tmpMap.get(dimNum);
                Object dim = null;
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                view.setSelector(this.getSelector());
                Object bizInterface = null;
                CoreBaseCollection colls = null;
                if (dimNum.equals(DimensionConstants.DEF_SCENARIO_NUMBER)) {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getCommonFilterSQL(bgSchemeID, dimNum, null), CompareType.INNER));
                    bizInterface = BgScenarioFactory.getLocalInstance((Context)ctx);
                } else if (dimNum.equals(DimensionConstants.DEF_VERSION_NUMBER)) {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getCommonFilterSQL(bgSchemeID, dimNum, null), CompareType.INNER));
                    filter.getFilterItems().add(new FilterItemInfo("isRollVersion", (Object)0, CompareType.EQUALS));
                    bizInterface = BgVersionFactory.getLocalInstance((Context)ctx);
                } else if (dimNum.equals(DimensionConstants.DEF_CURRENCY_NUMBER)) {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getCommonFilterSQL(bgSchemeID, dimNum, null), CompareType.INNER));
                    bizInterface = CurrencyFactory.getLocalInstance((Context)ctx);
                } else if (dimNum.equals(DimensionConstants.DEF_ELEMENT_NUMBER)) {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getCommonFilterSQL(bgSchemeID, dimNum, null), CompareType.INNER));
                    bizInterface = BgElementFactory.getLocalInstance((Context)ctx);
                } else if (dimNum.equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) {
                    if (orgTreeId != null) {
                        if (new OrgTreeInfo().getBOSType().equals((Object)BOSUuid.getBOSObjectType((String)orgTreeId, (boolean)true))) {
                            BgExamineServelHelper.addOrgTreeFilter(ctx, filter, orgTreeId);
                            bizInterface = FullOrgUnitFactory.getLocalInstance((Context)ctx);
                        } else {
                            filter.getFilterItems().add(new FilterItemInfo("viewId", (Object)this.getCommonFilterSQL(bgSchemeID, dimNum, null), CompareType.INNER));
                            filter.getFilterItems().add(new FilterItemInfo("isVirtual", (Object)0, CompareType.EQUALS));
                            bizInterface = BgOrgUnitFactory.getLocalInstance(ctx);
                        }
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("viewId", (Object)this.getCommonFilterSQL(bgSchemeID, dimNum, null), CompareType.INNER));
                        filter.getFilterItems().add(new FilterItemInfo("isVirtual", (Object)0, CompareType.EQUALS));
                        bizInterface = BgOrgUnitFactory.getLocalInstance(ctx);
                    }
                } else if (dimNum.equals(DimensionConstants.DEF_INDEX_NUMBER)) {
                    filter.getFilterItems().add(new FilterItemInfo("bgAccountView.Id", (Object)this.getCommonFilterSQL(bgSchemeID, dimNum, null), CompareType.INNER));
                    bizInterface = BgAccountFactory.getLocalInstance((Context)ctx);
                } else if (dimNum.equals(DimensionConstants.DEF_PERIOD_NUMBER)) {
                    filter.getFilterItems().add(new FilterItemInfo("type.id", (Object)this.getCommonFilterSQL(bgSchemeID, dimNum, null), CompareType.INNER));
                    bizInterface = BgPeriodDispFactory.getLocalInstance((Context)ctx);
                } else if (dimNum.equals("BG_Period1") || dimNum.equals("BG_Period2")) {
                    filter.getFilterItems().add(new FilterItemInfo("type.id", (Object)this.getCommonFilterSQL(bgSchemeID, DimensionConstants.DEF_PERIOD_NUMBER, null), CompareType.INNER));
                    bizInterface = BgPeriodDispFactory.getLocalInstance((Context)ctx);
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("viewId", (Object)this.getCommonFilterSQL(bgSchemeID, dimNum, null), CompareType.INNER));
                    bizInterface = MbgMemberFactory.getLocalInstance((Context)ctx);
                }
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)numbers, CompareType.INCLUDE));
                if (bizInterface != null) {
                    colls = bizInterface.getCollection(view);
                }
                HashMap dimTmpMap = null;
                if (!existDimMemMap.containsKey(bgScheme)) {
                    dimTmpMap = new HashMap();
                    memSet = new HashSet<Object>();
                    dimTmpMap.put(dimNum, memSet);
                    existDimMemMap.put(bgScheme, dimTmpMap);
                } else if (!((Map)existDimMemMap.get(bgScheme)).containsKey(dimNum)) {
                    dimTmpMap = new HashMap();
                    memSet = new HashSet();
                    dimTmpMap.put(dimNum, memSet);
                    ((Map)existDimMemMap.get(bgScheme)).putAll(dimTmpMap);
                }
                if (colls != null && colls.size() > 0 && memSet != null) {
                    for (int i = 0; i < colls.size(); ++i) {
                        DataBaseInfo dimMem = (DataBaseInfo)colls.get(i);
                        if (onlyNeedNumber) {
                            memSet.add(dimMem.getNumber());
                            continue;
                        }
                        BgDimensionMember dimMember = null;
                        dimMember = new BgDimensionMember(dimNum, null, dimMem.getName(), dimMem.getNumber());
                        memSet.add(dimMember);
                    }
                    continue;
                }
                if (!BgProcessHelper.DEF_PROCESS_NUMBER.equals(dimNum)) continue;
                if (onlyNeedNumber && memSet != null) {
                    memSet.add(BgProcessEnum.C01.getName());
                    memSet.add(BgProcessEnum.C02.getName());
                    memSet.add(BgProcessEnum.C03.getName());
                    memSet.add(BgProcessEnum.C04.getName());
                    continue;
                }
                if (memSet == null) continue;
                memSet.addAll(BgProcessHelper.getExistProcessMembers().values());
            }
        }
        return existDimMemMap;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("dimNumber"));
        return selector;
    }

    private String getCommonFilterSQL(String bgSchemeID, String dimNum, String number) {
        StringBuffer sql = new StringBuffer();
        sql.append("select FMemberID from T_MBG_BgDimSettingsMember dimmen ").append("join T_MBG_BgDimSettings dimsett on  dimsett.FID = dimmen.FBgDimSettingsID ").append("join T_MBG_BgScheme scheme on scheme.FID = dimsett.FBgSchemeID ").append("where scheme.FID = '").append(bgSchemeID).append("' ").append("and dimsett.FDimNumber = '").append(dimNum).append("' ");
        return sql.toString();
    }

    @Override
    protected Set _queryVariate(Context ctx, String bgSchemeID, Set varSet, boolean isMultiMem) throws BOSException, EASBizException {
        if (bgSchemeID == null || varSet == null) {
            return null;
        }
        return this.createVarDimMember(ctx, bgSchemeID, varSet);
    }

    private Set<BgDimensionMember> createVarDimMember(Context ctx, String bgSchemeID, Set numberSet) throws BOSException, EASBizException {
        HashSet<BgDimensionMember> varSet = new HashSet<BgDimensionMember>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.setSelector(this.getSelector());
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)numberSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeID, CompareType.EQUALS));
        BgVariateCollection colls = BgVariateFactory.getLocalInstance(ctx).getBgVariateCollection(view);
        BgDimensionMember dim = null;
        if (colls != null && colls.size() > 0) {
            for (int i = 0; i < colls.size(); ++i) {
                BgVariateInfo dimMem = colls.get(i);
                dim = new BgDimensionMember(dimMem.getDimNumber(), null, dimMem.getName(), dimMem.getNumber());
                varSet.add(dim);
            }
        }
        return varSet;
    }

    private String getBgSchemeIdByNum(Context ctx, String number) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)number) || ctx == null) {
            return null;
        }
        BgSchemeInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.setSelector(this.getSelector());
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        BgSchemeCollection col = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeCollection(view);
        if (col != null && !col.isEmpty()) {
            info = col.get(0);
            return info.getId().toString();
        }
        return null;
    }

    @Override
    protected Map _queryAllDimMember(Context ctx, List bgSchemes) throws BOSException, EASBizException {
        if (ctx == null || bgSchemes == null || bgSchemes.isEmpty()) {
            return null;
        }
        HashMap<String, Map<String, String>> dimNumberMap = new HashMap<String, Map<String, String>>();
        Map<String, String> srcNumberMap = null;
        Connection conn = null;
        IRowSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT scheme.FNUMBER, d.fsrcnumber, d.fnumber FROM T_MBG_BgDimSettings s  left join T_MBG_mbgdim d on s.fdimnumber = d.fnumber left join T_MBG_BgScheme scheme on s.Fbgschemeid = scheme.FID where scheme.FNUMBER in (");
        StringBuffer params = new StringBuffer();
        for (int i = 0; i < bgSchemes.size(); ++i) {
            params.append("?");
            params.append(",");
        }
        params.deleteCharAt(params.length() - 1);
        sql.append(params);
        sql.append(")");
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Collection)bgSchemes);
            while (rst.next()) {
                String bgSchemeNumber = rst.getString(1);
                String srcNumber = rst.getString("FSrcNumber");
                String fnumber = rst.getString(3);
                if (srcNumber == null || fnumber == null) continue;
                if (!dimNumberMap.containsKey(bgSchemeNumber)) {
                    srcNumberMap = new HashMap();
                    dimNumberMap.put(bgSchemeNumber, srcNumberMap);
                    if (srcNumberMap.containsKey(srcNumber)) continue;
                    srcNumberMap.put(srcNumber, fnumber);
                    continue;
                }
                srcNumberMap = (Map)dimNumberMap.get(bgSchemeNumber);
                if (srcNumberMap.containsKey(srcNumber)) continue;
                srcNumberMap.put(srcNumber, fnumber);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"_queryAllDimMember Sql Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return dimNumberMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set _getExamines(Context ctx, Set billIds) throws BOSException, EASBizException {
        HashSet<String> examineIDSet = new HashSet<String>();
        if (billIds == null || billIds.isEmpty()) {
            return examineIDSet;
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            Map<String, Set<String>> billIdMap = BgExamineServelHelper.queryRefExamine(ctx, conn, null, new ArrayList<String>(billIds));
            if (billIdMap != null) {
                for (Set<String> subSet : billIdMap.values()) {
                    examineIDSet.addAll(subSet);
                }
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return examineIDSet;
    }

    @Override
    protected List _importExamineSchemeCopy(Context ctx, String bgSchemeId, String orgUnitId, Map bgExamineMap, Map refBgTempMap) throws BOSException, EASBizException {
        if (bgExamineMap == null || bgExamineMap.isEmpty()) {
            return null;
        }
        ArrayList<BgCopySchemeResult> result = new ArrayList<BgCopySchemeResult>();
        BgSchemeInfo bgScheme = new BgSchemeInfo();
        bgScheme.setId(BOSUuid.read((String)bgSchemeId));
        FullOrgUnitInfo orgUnit = new FullOrgUnitInfo();
        orgUnit.setId(BOSUuid.read((String)orgUnitId));
        Map _bgExamineMap = bgExamineMap;
        Map _refBgTempMap = refBgTempMap;
        BgExamineInfo bgExamineInfo2 = null;
        BgTemplateCollection bgTemplateCol2 = null;
        BgTemplateInfo bgTemplateInfo = null;
        String bgExamineId2 = null;
        HashSet<String> keys = new HashSet<String>();
        HashMap<String, BgTemplateInfo> number_info = new HashMap<String, BgTemplateInfo>();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.setFilter(new FilterInfo());
        Iterator it = _bgExamineMap.values().iterator();
        while (it.hasNext()) {
            keys.add(((BgExamineInfo)it.next()).getNumber());
        }
        evi.getFilter().getFilterItems().clear();
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", keys, CompareType.INCLUDE));
        BgExamineCollection bgExamineCol = this.getBgExamineCollection(ctx, evi);
        HashSet<String> hasBizNumber = new HashSet<String>();
        if (bgExamineCol != null && !bgExamineCol.isEmpty()) {
            for (int i = 0; i < bgExamineCol.size(); ++i) {
                hasBizNumber.add(bgExamineCol.get(i).getNumber());
            }
        }
        if (_refBgTempMap != null && !_refBgTempMap.isEmpty()) {
            int i;
            keys.clear();
            for (BgTemplateCollection bgTemplateCol2 : _refBgTempMap.values()) {
                for (i = 0; i < bgTemplateCol2.size(); ++i) {
                    keys.add(bgTemplateCol2.get(i).getNumber());
                }
            }
            evi.getFilter().getFilterItems().clear();
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", keys, CompareType.INCLUDE));
            BgTemplateCollection tempCol = BgTemplateFactory.getLocalInstance(ctx).getBgTemplateCollection(evi);
            for (i = 0; i < tempCol.size(); ++i) {
                number_info.put(tempCol.get(i).getNumber(), tempCol.get(i));
            }
            for (String bgExamineId2 : _refBgTempMap.keySet()) {
                bgTemplateCol2 = (BgTemplateCollection)((Object)_refBgTempMap.get(bgExamineId2));
                Iterator it1 = bgTemplateCol2.iterator();
                while (it1.hasNext()) {
                    bgTemplateInfo = (BgTemplateInfo)it1.next();
                    if (!number_info.containsKey(bgTemplateInfo.getNumber())) {
                        it1.remove();
                        continue;
                    }
                    bgTemplateInfo.setId(((BgTemplateInfo)number_info.get(bgTemplateInfo.getNumber())).getId());
                }
                if (!bgTemplateCol2.isEmpty() && _bgExamineMap.containsKey(bgExamineId2)) {
                    bgExamineInfo2 = (BgExamineInfo)_bgExamineMap.get(bgExamineId2);
                    bgExamineInfo2.put("bgtemplate", (Object)bgTemplateCol2);
                }
                if (!bgTemplateCol2.isEmpty()) continue;
                BgExamineInfo remove = (BgExamineInfo)_bgExamineMap.remove(bgExamineId2);
                String baseMsg = EASResource.getString((String)this.RES, (String)"examine");
                String name = this.getName(remove);
                String copyResult = EASResource.getString((String)this.RES, (String)"examineNotTemp");
                BgCopySchemeResult s = new BgCopySchemeResult();
                s.setBaseMsg(baseMsg);
                s.setName(name);
                s.setCopyResult(copyResult);
                result.add(s);
            }
        }
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
        LinkedHashMap<String, LinkedHashMap<String, String>> bgExamineFormulaMap = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        LinkedHashMap<String, Map<String, Set<String>>> bgScopeSrcMap = new LinkedHashMap<String, Map<String, Set<String>>>();
        LinkedHashMap<String, Map<String, BgScopeCollection>> bgScopeMap = new LinkedHashMap<String, Map<String, BgScopeCollection>>();
        BgExamineFormulaVerifyHelper.buildParseParam(_bgExamineMap.values(), bgExamineFormulaMap, bgScopeSrcMap, bgScopeMap, schemeHelper);
        BgExamineFormulaVerifyHelper formulaParser = new BgExamineFormulaVerifyHelper(bgExamineFormulaMap, bgScopeSrcMap, bgScopeMap, schemeHelper, true);
        formulaParser.batchParse();
        HashSet<String> parseErrorNumber = new HashSet<String>();
        for (String number : formulaParser.getAllExceptions().keySet()) {
            Map<String, Map<Integer, List<Exception>>> subsetException = formulaParser.getAllExceptions().get(number);
            for (Map<Integer, List<Exception>> lineException : subsetException.values()) {
                if (lineException.isEmpty()) continue;
                parseErrorNumber.add(number);
            }
        }
        StringBuffer message = new StringBuffer();
        boolean success = false;
        boolean hasFail = !hasBizNumber.isEmpty() || !parseErrorNumber.isEmpty();
        IBgExamineGroup iBgExamineGroup = BgExamineGroupFactory.getLocalInstance(ctx);
        CoreBaseCollection subSetCol = new CoreBaseCollection();
        for (BgExamineInfo bgExamineInfo2 : _bgExamineMap.values()) {
            bgExamineInfo2.setId(BOSUuid.create((BOSObjectType)bgExamineInfo2.getBOSType()));
            if (hasBizNumber.contains(bgExamineInfo2.getNumber())) {
                String baseMsg = EASResource.getString((String)this.RES, (String)"examine");
                String name = this.getName(bgExamineInfo2);
                String orgName = this.getOrgName(bgExamineInfo2.getOrgUnit());
                String copyResult = EASResource.getString((String)this.RES, (String)"existsSameExameNumber");
                BgCopySchemeResult s = new BgCopySchemeResult();
                s.setBaseMsg(baseMsg);
                s.setName(name);
                s.setCopyResult(copyResult);
                s.setOrgName(orgName);
                result.add(s);
                continue;
            }
            if (!bgExamineInfo2.getBgExamineGroup().getId().toString().equals("PCto8jovS9md/v3tQ45tMIdbVAE=")) {
                if (iBgExamineGroup.exists("where number = '" + bgExamineInfo2.getBgExamineGroup().getNumber() + "' and bgScheme.id = '" + bgSchemeId + "' and isCsl = 0 ")) {
                    BgExamineGroupInfo group = iBgExamineGroup.getBgExamineGroupInfo("where number = '" + bgExamineInfo2.getBgExamineGroup().getNumber() + "' and bgScheme.id = '" + bgSchemeId + "' and isCsl = 0");
                    if (group != null) {
                        bgExamineInfo2.setBgExamineGroup(group);
                    }
                } else {
                    BgExamineGroupInfo BgExamineGroup2 = bgExamineInfo2.getBgExamineGroup();
                    BgExamineGroup2.setId(BOSUuid.create((BOSObjectType)BgExamineGroup2.getBOSType()));
                    BgExamineGroup2.setBgScheme(bgScheme);
                    BgExamineGroup2.setOrgUnit(orgUnit);
                    bgExamineInfo2.setBgExamineGroup(BgExamineGroup2);
                    iBgExamineGroup.addnew(BgExamineGroup2);
                }
            }
            if (formulaParser.getAllExceptions().containsKey(bgExamineInfo2.getNumber())) {
                boolean hasException = false;
                Map<String, Map<Integer, List<Exception>>> subsetException = formulaParser.getAllExceptions().get(bgExamineInfo2.getNumber());
                StringBuilder msg = new StringBuilder();
                for (String subsetName : subsetException.keySet()) {
                    Map<Integer, List<Exception>> lineException = subsetException.get(subsetName);
                    ArrayList<Integer> keyList = new ArrayList<Integer>(lineException.keySet());
                    Collections.sort(keyList);
                    for (Integer line : keyList) {
                        hasException = true;
                        List<Exception> Exceptions = lineException.get(line);
                        for (Exception exception : Exceptions) {
                            msg.append(exception.getMessage()).append(";");
                        }
                    }
                }
                if (hasException) {
                    String baseMsg = EASResource.getString((String)this.RES, (String)"examine");
                    String name = this.getName(bgExamineInfo2);
                    BgCopySchemeResult s = new BgCopySchemeResult();
                    s.setBaseMsg(baseMsg);
                    s.setName(name);
                    s.setCopyResult(msg.toString());
                    result.add(s);
                    continue;
                }
            }
            subSetCol.addObjectCollection((IObjectCollection)bgExamineInfo2.getBgExamineSubset());
            bgExamineInfo2.setBgScheme(bgScheme);
            bgExamineInfo2.setOrgUnit(orgUnit);
            bgExamineInfo2.setVersion(BgExamineServelHelper.DEFAULT_VERSION);
            this._submit(ctx, (IObjectValue)bgExamineInfo2);
            if (BgExamineStateEnum.SAVED.equals((Object)bgExamineInfo2.getState())) {
                bgExamineInfo2.setVersion(null);
                this.addHist(ctx, bgExamineInfo2, false, false);
            }
            CoreBaseCollection subsetCol = new CoreBaseCollection();
            BgExamineSubsetCollection bgExamineSubset = bgExamineInfo2.getBgExamineSubset();
            if (bgExamineSubset != null) {
                for (int i = 0; i < bgExamineSubset.size(); ++i) {
                    BgExamineSubsetInfo bgExamineSubInfo = bgExamineSubset.get(i);
                    bgExamineSubInfo.setId(BOSUuid.create((BOSObjectType)bgExamineSubInfo.getBOSType()));
                    bgExamineSubInfo.setBgExamine(bgExamineInfo2);
                    BgScopeCollection scope = bgExamineSubInfo.getBgScope();
                    for (int j = 0; j < scope.size(); ++j) {
                        scope.get(j).setBgExamineSubset(bgExamineSubInfo);
                    }
                    subsetCol.add((CoreBaseInfo)bgExamineSubInfo);
                }
            }
            BgExamineSubsetFactory.getLocalInstance(ctx).saveBatchData(subsetCol);
        }
        return result;
    }

    private String getName(BgExamineInfo info) {
        return info.getName() + "(" + info.getNumber() + ")";
    }

    private String getOrgName(FullOrgUnitInfo info) {
        return info.getNumber() + "(" + info.getName() + ")";
    }

    private void addHist(Context ctx, BgExamineInfo info, boolean isDelete, boolean isFromCancel) throws EASBizException, BOSException {
        CoreBaseCollection updateColls = new CoreBaseCollection();
        updateColls.add((CoreBaseInfo)info);
        BgExamineServelHelper.addHist(ctx, updateColls, isDelete, isFromCancel);
    }
}

