/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.face.ICalcData;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcData;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcExpreUtils;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.BinaryExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FormulaExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FunctionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MdxMemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.VariateExpr;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.biz.utils.BizExprUtils;
import com.kingdee.eas.ma.biz.utils.BizPtoUtils;
import com.kingdee.eas.ma.mbg.BgAdjustBillInfo;
import com.kingdee.eas.ma.mbg.BgCommentFactory;
import com.kingdee.eas.ma.mbg.BgDimensionFacadeFactory;
import com.kingdee.eas.ma.mbg.BgExamineCheckFactory;
import com.kingdee.eas.ma.mbg.BgExamineDataCheckResult;
import com.kingdee.eas.ma.mbg.BgExamineInfo;
import com.kingdee.eas.ma.mbg.BgExamineResult;
import com.kingdee.eas.ma.mbg.BgExamineSubsetInfo;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgDimensionFacade;
import com.kingdee.eas.ma.mbg.MbgExamCalcObj;
import com.kingdee.eas.ma.mbg.MbgExamineCheckException;
import com.kingdee.eas.ma.mbg.app.AbstractBgExamineFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.app.utils.BgExamineServelHelper;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.dimension.IDimension;
import com.kingdee.eas.ma.mbg.cube.member.Member;
import com.kingdee.eas.ma.mbg.cube.query.QueryData;
import com.kingdee.eas.ma.mbg.cube.utils.MbgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.impl.DimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.vo.DimensionObject;
import com.kingdee.eas.ma.mbg.utils.BgVariateUtils;
import com.kingdee.eas.ma.mbg.utils.BizCalcObj;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MBgExamineUtils;
import com.kingdee.eas.ma.mbg.utils.MBgPeriodVariable;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleScriptContext;
import org.apache.log4j.Logger;

public class BgExamineFacadeControllerBean
extends AbstractBgExamineFacadeControllerBean {
    private static final long serialVersionUID = -2626068285054869020L;
    private static Logger logger = Logger.getLogger((String)BgExamineFacadeControllerBean.class.getName());
    private BgSchemeInfo schemeInfo = null;
    private Map<String, String> variateMap = null;
    private MbgDimCollection mbgDims = null;
    private Map<String, MbgDimInfo> fieldDimMap = null;
    private Map<String, String> srcFieldMap = null;
    private Map<String, Set<String>> examineMap = null;
    private Map<String, Set<String>> examRefMap = null;
    private Map<BOSUuid, Set<String>> chkOrgExamineMap = new HashMap<BOSUuid, Set<String>>();
    private Map<String, Map<String, String>> orgParentMap = new HashMap<String, Map<String, String>>();
    private Map<String, String> defultMap = new HashMap<String, String>();
    private Map<String, Set<String>> schemeFieldMap = new HashMap<String, Set<String>>();
    private Map<String, Map<String, Set<String>>> fieldMap = new HashMap<String, Map<String, Set<String>>>();

    @Override
    protected boolean _canExamine(Context ctx, String billId) throws BOSException, EASBizException {
        boolean canExamine = false;
        if (ctx == null || StringUtils.isEmpty((String)billId)) {
            return canExamine;
        }
        ArrayList<String> _billIds = new ArrayList<String>();
        _billIds.add(billId);
        return this.canExamineLocal(ctx, _billIds);
    }

    @Override
    protected boolean _canExamine(Context ctx, String[] billIds) throws BOSException, EASBizException {
        boolean canExamine = false;
        if (ctx == null || billIds == null || billIds.length == 0) {
            return canExamine;
        }
        ArrayList<String> _billIds = new ArrayList<String>();
        int in = billIds.length;
        for (int i = 0; i < in; ++i) {
            _billIds.add(billIds[i]);
        }
        return this.canExamineLocal(ctx, _billIds);
    }

    @Override
    protected boolean _canExamine(Context ctx, List billIds) throws BOSException, EASBizException {
        return this.canExamineLocal(ctx, billIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean canExamineLocal(Context ctx, List<String> billIds) throws BOSException, EASBizException {
        boolean canExamine = false;
        if (ctx == null || billIds == null || billIds.isEmpty()) {
            return canExamine;
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            Map<String, Set<String>> examines = BgExamineServelHelper.queryRefExamine(ctx, conn, null, billIds);
            if (examines != null && !examines.isEmpty()) {
                canExamine = true;
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return canExamine;
    }

    @Override
    protected Object _examine(Context ctx, String billId) throws BOSException, EASBizException {
        return this.examineLocal(ctx, billId);
    }

    @Override
    protected boolean _examinesWF(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (ctx == null || billId == null) {
            return false;
        }
        BgExamineResult result = (BgExamineResult)this.examineLocal(ctx, billId.toString());
        if (result != null) {
            return result.result;
        }
        return false;
    }

    protected Map queryAllDimMember(Context ctx) throws BOSException, EASBizException {
        if (ctx == null) {
            return null;
        }
        HashMap<String, Map<String, String>> dimNumberMap = new HashMap<String, Map<String, String>>();
        Map<String, String> srcNumberMap = null;
        Connection conn = null;
        IRowSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT scheme.FNUMBER, d.fsrcnumber, d.fnumber FROM T_MBG_BgDimSettings s  left join T_MBG_mbgdim d on s.fdimnumber = d.fnumber left join T_MBG_BgScheme scheme on s.Fbgschemeid = scheme.FID ");
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            while (rst.next()) {
                String bgSchemeNumber = rst.getString(1);
                String srcNumber = rst.getString("FSrcNumber");
                String fnumber = rst.getString(3);
                if (srcNumber == null || fnumber == null) continue;
                if (!dimNumberMap.containsKey(bgSchemeNumber)) {
                    srcNumberMap = new HashMap();
                    dimNumberMap.put(bgSchemeNumber, srcNumberMap);
                    if (srcNumberMap.containsKey(srcNumber)) continue;
                    srcNumberMap.put(srcNumber, fnumber);
                    continue;
                }
                srcNumberMap = (Map)dimNumberMap.get(bgSchemeNumber);
                if (srcNumberMap.containsKey(srcNumber)) continue;
                srcNumberMap.put(srcNumber, fnumber);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"_queryAllDimMember Sql Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return dimNumberMap;
    }

    protected Object examineLocal(Context ctx, String billId) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)billId)) {
            return null;
        }
        ArrayList<String> billIds = new ArrayList<String>();
        billIds.add(billId);
        return this._examines(ctx, billIds);
    }

    @Override
    protected Object _examines(Context ctx, String[] billIds) throws BOSException, EASBizException {
        if (ctx == null || billIds == null || billIds.length == 0) {
            return null;
        }
        ArrayList<String> _billIds = new ArrayList<String>();
        int in = billIds.length;
        for (int i = 0; i < in; ++i) {
            _billIds.add(billIds[i]);
        }
        return this.examinesLocal(ctx, _billIds, this.queryAllDimMember(ctx));
    }

    @Override
    protected Object _examines(Context ctx, List billIds) throws BOSException, EASBizException {
        String bosType = null;
        ArrayList<String> adjList = new ArrayList<String>();
        ArrayList<String> cslList = new ArrayList<String>();
        ArrayList<String> lst = new ArrayList<String>();
        for (int index = 0; index < billIds.size(); ++index) {
            bosType = BOSUuid.read((String)((String)billIds.get(index))).getType().toString();
            if ("AD34C4CD".equals(bosType)) {
                adjList.add((String)billIds.get(index));
                continue;
            }
            if ("655ADD42".equals(bosType) || "9E7BD5E2".equals(bosType)) {
                cslList.add((String)billIds.get(index));
                continue;
            }
            lst.add((String)billIds.get(index));
        }
        ArrayList<BgExamineResult> result = new ArrayList<BgExamineResult>();
        Map map = new HashMap();
        if (adjList.size() > 0 || cslList.size() > 0 || lst.size() > 0) {
            map = this.queryAllDimMember(ctx);
        }
        if (adjList.size() > 0) {
            result.add(this.examinesLocal(ctx, adjList, map));
        }
        if (cslList.size() > 0) {
            result.add(this.examinesLocal(ctx, cslList, map));
        }
        if (lst.size() > 0) {
            result.add(this.examinesLocal(ctx, lst, map));
        }
        return result;
    }

    protected BgExamineResult examinesLocal(Context ctx, List<String> billIds, Map dimNumberMap) throws BOSException, EASBizException {
        BgExamineResult result = new BgExamineResult();
        result.checkTime = new Date(System.currentTimeMillis());
        if (ctx == null || billIds == null || billIds.isEmpty()) {
            return result;
        }
        boolean hasPeriodVariable = false;
        BgExamineInfo examine = null;
        List<IExpress> expres = null;
        ArrayList<IExpress> allExpres = new ArrayList<IExpress>();
        Map<String, List<IDimDataQuery>> orgFormMap = null;
        Connection conn = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            conn = this.getConnection(ctx);
            this.examineMap = BgExamineServelHelper.queryRefExamine(ctx, conn, pool, billIds);
            this.examRefMap = MBgExamineUtils.getMbgExamRefMap(this.examineMap);
            result.examines = MBgExamineUtils.queryExamine(ctx, conn, pool, this.examineMap);
            result.examRefMap = this.examRefMap;
            if (result.examines == null || result.examines.isEmpty()) {
                this.checkBgExamineResult(result);
                this.saveBgExamineResult(ctx, billIds, result);
                BgExamineResult bgExamineResult = result;
                return bgExamineResult;
            }
            int in = result.examines.size();
            for (int i = 0; i < in; ++i) {
                examine = result.examines.get(i);
                for (int j = 0; j < examine.getBgExamineSubset().size(); ++j) {
                    expres = examine.getBgExamineSubset().get(j).getExpres();
                    if (expres == null) continue;
                    allExpres.addAll(expres);
                }
            }
            if (allExpres.isEmpty()) {
                this.checkBgExamineResult(result);
                this.saveBgExamineResult(ctx, billIds, result);
                BgExamineResult i = result;
                return i;
            }
            List<IDimDataQuery> billValues = MbgDataHelper.getBillValue(ctx, conn, billIds);
            if (billValues == null || billValues.isEmpty()) {
                throw new MbgExamineCheckException(MbgExamineCheckException.SCHEMEERROR);
            }
            this.filterValue(billValues, this.examRefMap);
            MBgPeriodVariable variable = new MBgPeriodVariable(ctx.getLocale());
            hasPeriodVariable = variable.checkPeirodVariale(result.examines, this.getBgPeriodNums(billValues), null, true);
            orgFormMap = MBgExamineUtils.getOrgFormMap(billValues);
            this.schemeInfo = MbgDataHelper.getBgSchemeByForm(conn, ctx.getLocale(), BOSUuid.read((String)billIds.get(0)));
            if (this.schemeInfo == null) {
                throw new MbgExamineCheckException(MbgExamineCheckException.SCHEMEERROR);
            }
            this.variateMap = BgVariateUtils.queryVariate(conn, this.schemeInfo.getId());
            this.mbgDims = DimUtils.getDimensionColls(conn, ctx.getLocale());
            this.fieldDimMap = DimUtils.getDimInfoByField(this.mbgDims);
            this.srcFieldMap = DimUtils.getSrcFieldMap(this.mbgDims);
            this.srcFieldMap.put(DimensionConstants.DEF_PROCESS_SRCNUMBER, DimensionConstants.DEF_PROCESS_FIELD);
            Map<String, List<IDimDataQuery>> diffValueMap = this.diffValue(billValues, hasPeriodVariable);
            Map.Entry<String, List<IDimDataQuery>> entry2 = null;
            for (Map.Entry<String, List<IDimDataQuery>> entry2 : diffValueMap.entrySet()) {
                this.examineValues(ctx, conn, variable, entry2.getValue(), entry2.getKey(), result, dimNumberMap);
            }
        }
        catch (ParseException ex) {
            logger.error((Object)"examine parse error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        if (result.examines != null) {
            ArrayList<BgExamineInfo> remove = new ArrayList<BgExamineInfo>();
            BgExamineSubsetInfo subsetInfo = null;
            Set<String> orgUnitIds = orgFormMap.keySet();
            boolean isExist = true;
            int in = result.examines.size();
            for (int i = 0; i < in; ++i) {
                examine = result.examines.get(i);
                for (int j = 0; j < examine.getBgExamineSubset().size(); ++j) {
                    subsetInfo = examine.getBgExamineSubset().get(j);
                    if (this.chkOrgExamineMap.containsKey(subsetInfo.getId())) {
                        Set<String> chkOrgSet = this.chkOrgExamineMap.get(subsetInfo.getId());
                        if (chkOrgSet.containsAll(orgUnitIds)) continue;
                        isExist = false;
                        break;
                    }
                    isExist = false;
                }
                if (isExist) {
                    remove.add(examine);
                }
                isExist = true;
            }
            if (!remove.isEmpty()) {
                result.examines.removeAll(remove);
            }
        }
        this.checkPostil(ctx, result);
        this.checkBgExamineResult(result);
        this.saveBgExamineResult(ctx, billIds, result);
        return result;
    }

    protected void examineValues(Context ctx, Connection conn, MBgPeriodVariable variable, List<IDimDataQuery> values, String bgPeriodNum, BgExamineResult result, Map dimNumberMap) throws Exception {
        if (ctx == null || conn == null || variable == null || values == null || bgPeriodNum == null || result == null) {
            return;
        }
        String schemeNumber = null;
        String orgUnitNumber22 = null;
        String orgUnitId = null;
        IDimensionParameter parameter = null;
        HashMap<String, IObjectValue> scenaioMap = new HashMap<String, IObjectValue>();
        HashMap<String, IObjectValue> versionMap = new HashMap<String, IObjectValue>();
        BgScenarioInfo _scenario = null;
        BgVersionInfo _version = null;
        OrgUnitInfo orgUnit = null;
        IDimDataQuery model = null;
        BgExamineInfo examine = null;
        BgExamineSubsetInfo subsetInfo = null;
        HashMap<String, OrgUnitInfo> orgUnitMap = new HashMap<String, OrgUnitInfo>();
        HashMap<String, OrgUnitInfo> orgUnitNumMap = new HashMap<String, OrgUnitInfo>();
        Map.Entry<String, List<IDimDataQuery>> fEntry22 = null;
        List<BgExamineInfo> _examines = null;
        Map[] CMPDataMap = new Map[4];
        Object orgDataMap = null;
        Object mbgDataMap = null;
        Set<Object> chkOrgSet = null;
        Object bgData = null;
        Object calcData = null;
        String bosType = values.get(0).getBOSType().toString();
        if ("AD34C4CD".equals(bosType)) {
            result.dataType = 128;
        } else if ("655ADD42".equals(bosType) || "9E7BD5E2".equals(bosType)) {
            result.dataType = 64;
        }
        if (values.get(0) instanceof BgFormInfo && DimensionCommonHelper.isDecompose(((BgFormInfo)values.get(0)).getProcessType())) {
            result.dataType = ((BgFormInfo)values.get(0)).getDataType();
        }
        boolean isCheckAdjustData = false;
        BOSUuid unionId = null;
        int in = values.size();
        for (int i = 0; i < in; ++i) {
            model = values.get(i);
            int state = model.getBizState();
            if ("3BA5F027".equals(bosType) && (4 == state || 35 == state || 6 == state || 6 == state)) {
                isCheckAdjustData = true;
                break;
            }
            if (unionId != null || model.getBizUnionId() == null) continue;
            unionId = model.getBizUnionId();
        }
        BOSUuid[] bgTemplateIds = this.getBgTemplateIds(values);
        Map<String, List<IDimDataQuery>> orgFormMap = MBgExamineUtils.getOrgFormMap(values);
        Map<String, Map<String, Set<String>>> formDataMap = MBgExamineUtils.parseFormDimData(ctx, this.schemeInfo, values, this.srcFieldMap, result);
        Set<String> checkBillIds = MBgExamineUtils.checkFormMember(formDataMap);
        HashMap<String, Map<String, Set<String>>> pFormDataMap = new HashMap<String, Map<String, Set<String>>>();
        for (String formId : formDataMap.keySet()) {
            Map<String, Set<String>> formMap = formDataMap.get(formId);
            Map<String, Set<String>> pMbgDataMap = MBgExamineUtils.getParentMemberMap(conn, this.schemeInfo, formMap, this.fieldDimMap);
            pFormDataMap.put(formId, pMbgDataMap);
        }
        boolean isEmpty = true;
        Map<String, Set<String>> formEntry22 = null;
        for (Map<String, Set<String>> formEntry22 : formDataMap.values()) {
            if (formEntry22.isEmpty()) continue;
            isEmpty = false;
            break;
        }
        if (isEmpty) {
            return;
        }
        IExpress expr = null;
        ExprDimQuery query = null;
        List<IDimDataQuery> bills = null;
        ArrayList<ExprDimQuery> querys = new ArrayList<ExprDimQuery>();
        List calcObjs = null;
        Object var45_49 = null;
        HashMap schemeOrgMap = new HashMap();
        Map<String, Set<String>> scopeMap = null;
        Set orgNumSet = null;
        MbgExamCalcObj calcObj = null;
        HashMap examCalcObjs = new HashMap();
        HashSet<String> bgPeriodNums = new HashSet<String>();
        bgPeriodNums.add(bgPeriodNum);
        HashSet<String> processTypes = new HashSet<String>();
        HashSet<String> allProcessTypes = new HashSet<String>();
        HashSet<String> showSubsetIds = new HashSet<String>();
        for (Map.Entry<String, List<IDimDataQuery>> fEntry22 : orgFormMap.entrySet()) {
            orgUnitId = fEntry22.getKey();
            bills = fEntry22.getValue();
            orgUnit = MbgDataHelper.getBaseOrgUnitInfo(conn, ctx.getLocale(), BOSUuid.read((String)orgUnitId));
            orgUnitMap.put(orgUnitId, orgUnit);
            orgUnitNumMap.put(orgUnit.getNumber(), orgUnit);
            result.orgUnitMap.put(orgUnit.getNumber(), new String[]{orgUnit.getNumber(), orgUnit.getName(), orgUnit.getId().toString()});
            _examines = this.filterExamine(bills, this.examineMap, result.examines);
            processTypes.clear();
            for (IDimDataQuery info : bills) {
                if (info instanceof BgFormInfo) {
                    processTypes.add(((BgFormInfo)info).getProcessType().getName());
                    continue;
                }
                processTypes.add(BgProcessEnum.C01.getName());
            }
            allProcessTypes.addAll(processTypes);
            Map allPeriodMap = BizPtoUtils.queryBgPeriodInfo((Connection)conn);
            if (_examines.isEmpty()) continue;
            int in2 = result.examines.size();
            for (int i = 0; i < in2; ++i) {
                examine = result.examines.get(i);
                calcObjs = examCalcObjs.containsKey(examine.getId()) ? (List)examCalcObjs.get(examine.getId()) : new ArrayList();
                examCalcObjs.put(examine.getId(), calcObjs);
                for (int index = 0; index < examine.getBgExamineSubset().size(); ++index) {
                    subsetInfo = examine.getBgExamineSubset().get(index);
                    Set<String> processTypeScope = subsetInfo.getProcessScope();
                    if (!processTypeScope.isEmpty()) {
                        processTypeScope.retainAll(processTypes);
                        if (processTypeScope.isEmpty()) {
                            result.noShowSubSets.add(subsetInfo.getId().toString());
                            continue;
                        }
                    }
                    showSubsetIds.add(subsetInfo.getId().toString());
                    variable.transPeirodVariale((IObjectValue)examine, (IObjectCollection)subsetInfo.getBgScope(), bgPeriodNums, null, result.casues);
                    scopeMap = subsetInfo.getScopeData(ctx, this.schemeInfo, this.schemeInfo.getEditOrgViewId(), unionId, this.mbgDims, this.variateMap);
                    if (scopeMap.containsKey(DimensionBaseConstants.DEF_ORGUNIT_FIELD) && !(orgNumSet = scopeMap.get(DimensionBaseConstants.DEF_ORGUNIT_FIELD)).contains(orgUnit.getNumber())) {
                        if (this.chkOrgExamineMap.containsKey(subsetInfo.getId())) {
                            chkOrgSet = this.chkOrgExamineMap.get(subsetInfo.getId());
                        } else {
                            chkOrgSet = new HashSet();
                            this.chkOrgExamineMap.put(subsetInfo.getId(), chkOrgSet);
                        }
                        chkOrgSet.add(orgUnit.getId().toString());
                        continue;
                    }
                    List<IExpress> expres = subsetInfo.getExpres(true);
                    HashMap<String, String> expresMap = new HashMap<String, String>();
                    if (expres == null) continue;
                    variable.transPeirodVariale((IObjectValue)examine, expres, bgPeriodNums, null, result.casues, expresMap);
                    HashSet<String> scopePeriods = new HashSet<String>();
                    if (scopeMap != null && scopeMap.containsKey(DimensionConstants.DEF_PERIOD_FIELD)) {
                        scopePeriods.addAll((Collection<String>)scopeMap.get(DimensionConstants.DEF_PERIOD_FIELD));
                    }
                    expres = this.processPtoExpress(conn, subsetInfo, expres, allPeriodMap, pFormDataMap, scopePeriods, expresMap);
                    int jn = expres.size();
                    for (int j = 0; j < jn; ++j) {
                        expr = expres.get(j);
                        BgVariateUtils.checkVarMember(expr, this.variateMap);
                        boolean checkExpr = false;
                        for (Map pMbgDataMap : pFormDataMap.values()) {
                            if (!MBgExamineUtils.checkExpr(expr, (Map<String, Set<String>>)pMbgDataMap, this.srcFieldMap)) continue;
                            checkExpr = true;
                        }
                        if (!checkExpr) continue;
                        this.mergeOrgParent(MBgExamineUtils.getOrgParentNumbers(conn, expr, this.schemeInfo.getNumber(), orgUnit.getNumber()));
                        query = this.getDimQuery(this.schemeInfo.getNumber(), orgUnit.getNumber(), expr, scopeMap, formDataMap, null, this.srcFieldMap, this.orgParentMap, dimNumberMap);
                        if (query != null) {
                            query.examineId = examine.getId().toString();
                            querys.add(query);
                            MBgExamineUtils.queryCache(ctx, this.schemeInfo, this.fieldDimMap, query, result);
                            for (Map.Entry entry : query.schemeMap.entrySet()) {
                                if (schemeOrgMap.containsKey(entry.getKey())) {
                                    orgNumSet = (Set)schemeOrgMap.get(entry.getKey());
                                } else {
                                    orgNumSet = new HashSet<String>();
                                    schemeOrgMap.put(entry.getKey(), orgNumSet);
                                }
                                if (orgNumSet == null) continue;
                                orgNumSet.addAll((Collection)entry.getValue());
                            }
                            MBgExamineUtils.checkFunctionMember(expr, this.schemeInfo.getNumber(), orgUnit.getNumber(), query, formDataMap);
                        }
                        calcObj = new MbgExamCalcObj();
                        calcObj.subSetInfo = subsetInfo;
                        calcObj.mbgExamine = examine;
                        calcObj.expr = expr;
                        calcObj.query = query;
                        calcObj.parse();
                        calcObj.orignScript = expresMap.containsKey(calcObj.planScript) && expresMap.get(calcObj.planScript) != null ? (String)expresMap.get(calcObj.planScript) : calcObj.planScript;
                        calcObjs.add(calcObj);
                    }
                }
            }
        }
        result.noShowSubSets.removeAll(showSubsetIds);
        if (!schemeOrgMap.isEmpty()) {
            BgVersionCollection _bgVerColls;
            BgScenarioCollection _bgScenColls;
            HashMap<String, String> scInnNumMap = new HashMap<String, String>();
            HashMap<String, String> scNumInnMap = new HashMap<String, String>();
            HashMap<String, String> verInnNumMap = new HashMap<String, String>();
            HashMap<String, String> verNumInnMap = new HashMap<String, String>();
            IBgDimensionFacade facade = BgDimensionFacadeFactory.getLocalInstance(ctx);
            if ((scInnNumMap.isEmpty() || scNumInnMap.isEmpty() || scenaioMap.isEmpty()) && (_bgScenColls = BgScenarioHelper.getScenarioColls((Connection)conn, (Locale)ctx.getLocale())) != null) {
                int in3 = _bgScenColls.size();
                for (int i = 0; i < in3; ++i) {
                    _scenario = _bgScenColls.get(i);
                    scInnNumMap.put(String.valueOf(_scenario.getScenarioId()), _scenario.getNumber());
                    scNumInnMap.put(_scenario.getNumber(), String.valueOf(_scenario.getScenarioId()));
                    scenaioMap.put(_scenario.getNumber(), (IObjectValue)_scenario);
                }
            }
            if ((verInnNumMap.isEmpty() || verNumInnMap.isEmpty() || versionMap.isEmpty()) && (_bgVerColls = BgVersionHelper.getVersionColls((Connection)conn, (Locale)ctx.getLocale())) != null) {
                int in4 = _bgVerColls.size();
                for (int i = 0; i < in4; ++i) {
                    _version = _bgVerColls.get(i);
                    if (_version.isIsRollVersion()) continue;
                    verInnNumMap.put(String.valueOf(_version.getVersionId()), _version.getNumber());
                    verNumInnMap.put(_version.getNumber(), String.valueOf(_version.getVersionId()));
                    versionMap.put(_version.getNumber(), (IObjectValue)_version);
                }
            }
            for (Map.Entry entry : schemeOrgMap.entrySet()) {
                schemeNumber = (String)entry.getKey();
                orgNumSet = (Set)entry.getValue();
                BgSchemeInfo schemeInfo = MbgDataHelper.getBgSchemeByNumber(conn, ctx.getLocale(), schemeNumber);
                result.bgSchemeMap.put(schemeInfo.getNumber(), new String[]{schemeInfo.getNumber(), schemeInfo.getName(), schemeInfo.getId().toString()});
                this.queryDefaultExtDimMap(conn, schemeInfo);
                for (String orgUnitNumber22 : orgNumSet) {
                    BizCalcExpreUtils utils;
                    int index;
                    if (orgUnitNumMap.containsKey(orgUnitNumber22)) {
                        orgUnit = (OrgUnitInfo)orgUnitNumMap.get(orgUnitNumber22);
                    } else {
                        orgUnit = MbgDataHelper.getBaseOrgUnitByNumber(conn, ctx.getLocale(), orgUnitNumber22);
                        orgUnitMap.put(orgUnit.getId().toString(), orgUnit);
                        orgUnitNumMap.put(orgUnit.getNumber(), orgUnit);
                        result.orgUnitMap.put(orgUnit.getNumber(), new String[]{orgUnit.getNumber(), orgUnit.getName(), orgUnit.getId().toString()});
                    }
                    if ((parameter = this.transDimensionParameter(ctx, conn, schemeInfo, orgUnit, querys, formDataMap, this.examRefMap, null, this.fieldDimMap, scenaioMap, versionMap)) == null) continue;
                    if (result.dataType == 64) {
                        parameter.setUnionId(unionId);
                        parameter.setValueType(64);
                    } else if (result.dataType == 128) {
                        parameter.setUnionId(unionId);
                        parameter.setValueType(128);
                    } else if (DimensionCommonHelper.isDecompose(result.dataType)) {
                        parameter.setValueType(result.dataType);
                    }
                    parameter.setBgTemplateId(bgTemplateIds);
                    parameter.addPeriodStandardNumber(bgPeriodNum);
                    parameter.getControlManager().setAdjust(isCheckAdjustData);
                    parameter.getDataManager().setDimensions(this.mbgDims);
                    parameter.getDataManager().getInnNumMap().put(DimensionConstants.DEF_SCENARIO_FIELD, scInnNumMap);
                    parameter.getDataManager().getNumInnMap().put(DimensionConstants.DEF_SCENARIO_FIELD, scNumInnMap);
                    parameter.getDataManager().getInnNumMap().put(DimensionConstants.DEF_VERSION_FIELD, verInnNumMap);
                    parameter.getDataManager().getNumInnMap().put(DimensionConstants.DEF_VERSION_FIELD, verNumInnMap);
                    Object cmpObj = null;
                    IDimensionParameter[] parameters = this.getCMPParameter(ctx, parameter, querys, (Set<String>)(unionId != null ? new HashSet<String>() : allProcessTypes));
                    if (parameters == null) {
                        cmpObj = facade.dimensionQuery(parameter);
                        index = 0;
                        if (parameter.getValueType() == 256) {
                            index = 1;
                        } else if (parameter.getValueType() == 512) {
                            index = 2;
                        } else if (parameter.getValueType() == 1024) {
                            index = 3;
                        }
                        CMPDataMap[index] = this.getSchemeDataMap(cmpObj, schemeNumber, orgUnitMap, parameter, scenaioMap, scNumInnMap, verNumInnMap, CMPDataMap[index]);
                        int in5 = parameter.getQuerys().size();
                        for (int i = 0; i < in5; ++i) {
                            MBgExamineUtils.queryCache(ctx, schemeInfo, this.fieldDimMap, parameter.getQuerys().get(i).getMbgDimMap().values(), result);
                        }
                        IDimensionParameter cloneParameter = null;
                        if (orgUnit != null && orgFormMap.containsKey(orgUnit.getId().toString())) {
                            bills = orgFormMap.get(orgUnit.getId().toString());
                        }
                        if (bills != null && !bills.isEmpty()) {
                            cloneParameter = parameter.getClone(ctx);
                            cloneParameter.setBillId(bills.get(0).getId());
                            cloneParameter.getDataManager().setDimDataQuery(bills.get(0));
                        }
                        utils = new BizCalcExpreUtils(ctx, conn, cloneParameter == null ? parameter : cloneParameter);
                        utils.setFlag(true);
                        utils.setExamine(_examines);
                        utils.setExamCalcObjs(examCalcObjs);
                        utils.calcs(querys);
                        continue;
                    }
                    for (index = 0; index < parameters.length; ++index) {
                        parameter = parameters[index];
                        if (parameter == null) continue;
                        cmpObj = facade.dimensionQuery(parameter);
                        CMPDataMap[index] = this.getSchemeDataMap(cmpObj, schemeNumber, orgUnitMap, parameter, scenaioMap, scNumInnMap, verNumInnMap, CMPDataMap[index]);
                        int in6 = parameter.getQuerys().size();
                        for (int i = 0; i < in6; ++i) {
                            MBgExamineUtils.queryCache(ctx, schemeInfo, this.fieldDimMap, parameter.getQuerys().get(i).getMbgDimMap().values(), result);
                        }
                        IDimensionParameter cloneParameter = null;
                        if (orgUnit != null && orgFormMap.containsKey(orgUnit.getId().toString())) {
                            bills = orgFormMap.get(orgUnit.getId().toString());
                        }
                        if (bills != null && !bills.isEmpty()) {
                            cloneParameter = parameter.getClone(ctx);
                            cloneParameter.setBillId(bills.get(0).getId());
                            cloneParameter.getDataManager().setDimDataQuery(bills.get(0));
                        }
                        utils = new BizCalcExpreUtils(ctx, conn, cloneParameter == null ? parameter : cloneParameter);
                        utils.setFlag(true);
                        utils.setExamine(_examines);
                        utils.setExamCalcObjs(examCalcObjs);
                        utils.calcs(querys);
                    }
                }
            }
        }
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("js");
        SimpleScriptContext context = new SimpleScriptContext();
        logger.debug((Object)("ScriptEngine class:" + engine.getClass()));
        String billId = null;
        Set<String> refBgFormIds = null;
        List<BgExamineDataCheckResult> checkResult = null;
        String processType = BgProcessEnum.C01.getName();
        for (Map.Entry<String, List<IDimDataQuery>> fEntry22 : orgFormMap.entrySet()) {
            orgUnitId = fEntry22.getKey();
            bills = fEntry22.getValue();
            orgUnit = (OrgUnitInfo)orgUnitMap.get(orgUnitId);
            _examines = this.filterExamine(bills, this.examineMap, result.examines);
            int xn = _examines.size();
            for (int x = 0; x < xn; ++x) {
                examine = _examines.get(x);
                for (int index = 0; index < examine.getBgExamineSubset().size(); ++index) {
                    subsetInfo = examine.getBgExamineSubset().get(index);
                    scopeMap = subsetInfo.getScopeData(ctx, this.schemeInfo, this.schemeInfo.getEditOrgViewId(), unionId, this.mbgDims, this.variateMap);
                    if (scopeMap.containsKey(DimensionBaseConstants.DEF_ORGUNIT_FIELD) && !(orgNumSet = scopeMap.get(DimensionBaseConstants.DEF_ORGUNIT_FIELD)).contains(orgUnit.getNumber()) || !examCalcObjs.containsKey(examine.getId())) continue;
                    calcObjs = (List)examCalcObjs.get(examine.getId());
                    refBgFormIds = this.examRefMap.get(examine.getId().toString());
                    int yn = bills.size();
                    for (int y = 0; y < yn; ++y) {
                        model = bills.get(y);
                        if (model instanceof BgFormInfo) {
                            processType = ((BgFormInfo)model).getProcessType().getName();
                        }
                        if (checkBillIds.contains(billId = model.getId().toString()) || !refBgFormIds.contains(billId)) continue;
                        int jn = calcObjs.size();
                        for (int j = 0; j < jn; ++j) {
                            calcObj = (MbgExamCalcObj)calcObjs.get(j);
                            if (calcObj != null && this.orgParentMap.isEmpty() && calcObj.query.schemeMap != null && calcObj.query.schemeMap.containsKey(model.getBizBgScheme().getNumber()) && !calcObj.query.schemeMap.get(model.getBizBgScheme().getNumber()).contains(orgUnit.getNumber()) || calcObj == null) continue;
                            if (calcObj.query.schemeMap != null && calcObj.query.schemeMap.containsKey(model.getBizBgScheme().getNumber()) && !calcObj.query.schemeMap.get(model.getBizBgScheme().getNumber()).contains(orgUnit.getNumber())) {
                                if (!this.orgParentMap.containsKey(model.getBizBgScheme().getNumber()) || !this.orgParentMap.get(model.getBizBgScheme().getNumber()).containsKey(orgUnit.getNumber())) continue;
                                String parentNumber = this.orgParentMap.get(model.getBizBgScheme().getNumber()).get(orgUnit.getNumber());
                                if (!calcObj.query.schemeMap.get(model.getBizBgScheme().getNumber()).contains(parentNumber)) continue;
                            }
                            if ((checkResult = calcObj.check(ctx, engine, context, this.mbgDims, this.schemeInfo, unionId, orgUnit, formDataMap.get(model.getId().toString()), CMPDataMap, this.srcFieldMap, this.orgParentMap, processType, this.defultMap, this.fieldMap)) == null || checkResult.isEmpty()) continue;
                            MBgExamineUtils.queryCache(ctx, this.schemeInfo, checkResult, this.fieldDimMap, this.srcFieldMap, result);
                            if (calcObj.subSetInfo != null && subsetInfo.getId().equals((Object)calcObj.subSetInfo.getId())) {
                                result.addSubsetCheckResult(orgUnit.getNumber(), subsetInfo.getId().toString(), calcObj, checkResult);
                            }
                            if (3 == examine.getNoPass().getValue() || result.errors.contains(examine)) continue;
                            result.errors.add(examine);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> queryDefaultExtDimMap(Connection conn, BgSchemeInfo schemeInfo) throws SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (conn == null) {
            return map;
        }
        List<BOSUuid> viewIds = schemeInfo.getExtDimViewIds();
        StringBuffer query = new StringBuffer();
        query.append("Select distinct m.FRefField, m.FSrcNumber, t.FNumber from T_MBG_MbgMember t left join T_MBG_MbgDim m on t.FDimId = m.FID where");
        if (viewIds != null && !viewIds.isEmpty()) {
            query.append(" t.FViewId IN (");
            int in = viewIds.size();
            for (int i = 0; i < in; ++i) {
                query.append("'" + viewIds.get(i) + "',");
            }
        } else {
            return map;
        }
        query = query.delete(query.length() - 1, query.length());
        query.append(") and");
        query.append(" t.FIsSystemDefault = 1");
        query.append(" and t.FIsleaf = 0");
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)query.toString());
            while (rst.next()) {
                map.put(rst.getString("FRefField"), rst.getString("FSrcNumber") + ":" + rst.getString("FNumber"));
                this.defultMap.put(rst.getString("FRefField"), rst.getString("FSrcNumber") + ":" + rst.getString("FNumber"));
                if (this.schemeFieldMap.containsKey(schemeInfo.getNumber())) {
                    this.schemeFieldMap.get(schemeInfo.getNumber()).add(rst.getString("FRefField"));
                    continue;
                }
                HashSet<String> set = new HashSet<String>();
                set.add(rst.getString("FRefField"));
                this.schemeFieldMap.put(schemeInfo.getNumber(), set);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return map;
    }

    protected Set<String> getBgPeriodNums(List<IDimDataQuery> values) {
        HashSet<String> bgPeriodNums = new HashSet<String>();
        if (values == null || values.isEmpty()) {
            return bgPeriodNums;
        }
        for (IDimDataQuery value : values) {
            bgPeriodNums.add(value.getBizPeriod().getNumber());
        }
        return bgPeriodNums;
    }

    protected Set<String> getBgPeriodNumsByAdjust(List<BgAdjustBillInfo> values) {
        HashSet<String> bgPeriodNums = new HashSet<String>();
        if (values == null || values.isEmpty()) {
            return bgPeriodNums;
        }
        for (BgAdjustBillInfo value : values) {
            int in = value.getEntity().size();
            for (int i = 0; i < in; ++i) {
                bgPeriodNums.add(value.getEntity().get(i).getPeriod().getNumber());
            }
        }
        return bgPeriodNums;
    }

    protected ExprDimQuery getDimQuery(String currSchemeNum, String currOrgUnitNum, IExpress expr, Map<String, Set<String>> scopeMap, Map<String, Map<String, Set<String>>> formDataMap, Map<String, Set<String>> adjustDataMap, Map<String, String> srcFieldMap, Map<String, Map<String, String>> orgParentMap, Map dimNumberMap) {
        HashSet<String> unionFields = new HashSet<String>();
        if (expr instanceof BinaryExpr) {
            MBgExamineUtils.getUnionDimField((BinaryExpr)expr, unionFields, srcFieldMap);
        }
        if (expr instanceof BinaryExpr) {
            return this.getDimQuery(new ExprDimQuery(), currSchemeNum, currOrgUnitNum, (BinaryExpr)expr, scopeMap, formDataMap, adjustDataMap, unionFields, srcFieldMap, orgParentMap, dimNumberMap);
        }
        return null;
    }

    protected ExprDimQuery getDimQuery(ExprDimQuery query, String currSchemeNum, String currOrgUnitNum, BinaryExpr expr, Map<String, Set<String>> scopeMap, Map<String, Map<String, Set<String>>> formDataMap, Map<String, Set<String>> adjustDataMap, Set<String> unionFields, Map<String, String> srcFieldMap, Map<String, Map<String, String>> orgParentMap, Map dimNumberMap) {
        if (expr == null) {
            return query;
        }
        if (query == null) {
            query = new ExprDimQuery();
        }
        if (expr.left instanceof BinaryExpr) {
            query = this.getDimQuery(query, currSchemeNum, currOrgUnitNum, (BinaryExpr)expr.left, scopeMap, formDataMap, adjustDataMap, unionFields, srcFieldMap, orgParentMap, dimNumberMap);
        } else if (expr.left instanceof MdxMemberExpr) {
            if (query.expr == null) {
                query.expr = (MdxMemberExpr)expr.left;
            }
            query = this.getDimQuery(query, currSchemeNum, currOrgUnitNum, (MdxMemberExpr)expr.left, scopeMap, formDataMap, adjustDataMap, unionFields, srcFieldMap, orgParentMap, (Map<String, Map<String, String>>)dimNumberMap);
        } else if (expr.left instanceof VariateExpr) {
            query = this.getDimQuery(query, currSchemeNum, currOrgUnitNum, (VariateExpr)expr.left, scopeMap, formDataMap, adjustDataMap, unionFields, srcFieldMap, orgParentMap, dimNumberMap);
        } else if (expr.left instanceof FormulaExpr) {
            BizExprUtils.getFormulaExpr((IExpress)expr.left, query.formulaMaps);
        }
        this.checkOperType(expr, query);
        if (expr.right instanceof BinaryExpr) {
            query = this.getDimQuery(query, currSchemeNum, currOrgUnitNum, (BinaryExpr)expr.right, scopeMap, formDataMap, adjustDataMap, unionFields, srcFieldMap, orgParentMap, dimNumberMap);
        } else if (expr.right instanceof MdxMemberExpr) {
            query = this.getDimQuery(query, currSchemeNum, currOrgUnitNum, (MdxMemberExpr)expr.right, scopeMap, formDataMap, adjustDataMap, unionFields, srcFieldMap, orgParentMap, (Map<String, Map<String, String>>)dimNumberMap);
        } else if (expr.right instanceof VariateExpr) {
            query = this.getDimQuery(query, currSchemeNum, currOrgUnitNum, (VariateExpr)expr.right, scopeMap, formDataMap, adjustDataMap, unionFields, srcFieldMap, orgParentMap, dimNumberMap);
        } else if (expr.right instanceof FormulaExpr) {
            BizExprUtils.getFormulaExpr((IExpress)expr.right, query.formulaMaps);
        }
        return query;
    }

    protected void checkOperType(BinaryExpr binaryExpr, ExprDimQuery query) {
        if (binaryExpr == null || binaryExpr.operType == null || query == null) {
            return;
        }
        if (binaryExpr.operType.getSID() == 13 || binaryExpr.operType.getSID() == 14 || binaryExpr.operType.getSID() == 15 || binaryExpr.operType.getSID() == 16 || binaryExpr.operType.getSID() == 17 || binaryExpr.operType.getSID() == 18) {
            query.hasRight = true;
        }
    }

    protected ExprDimQuery getDimQuery(ExprDimQuery query, String currSchemeNum, String currOrgUnitNum, VariateExpr expr, Map<String, Set<String>> scopeMap, Map<String, Map<String, Set<String>>> formDataMap, Map<String, Set<String>> adjustDataMap, Set<String> unionFields, Map<String, String> srcFieldMap, Map<String, Map<String, String>> orgParentMap, Map dimNumberMap) {
        if (expr == null) {
            return query;
        }
        if (query == null) {
            query = new ExprDimQuery();
        }
        if (expr.expr != null) {
            query = this.getDimQuery(query, currSchemeNum, currOrgUnitNum, expr.expr, scopeMap, formDataMap, adjustDataMap, unionFields, srcFieldMap, orgParentMap, (Map<String, Map<String, String>>)dimNumberMap);
        }
        return query;
    }

    protected ExprDimQuery getDimQuery(ExprDimQuery query, String currSchemeNum, String currOrgUnitNum, MdxMemberExpr expr, Map<String, Set<String>> scopeMap, Map<String, Map<String, Set<String>>> formDataMap, Map<String, Set<String>> adjustDataMap, Set<String> unionFields, Map<String, String> srcFieldMap, Map<String, Map<String, String>> orgParentMap, Map<String, Map<String, String>> dimNumberMap) {
        if (expr == null) {
            return query;
        }
        if (query == null) {
            query = new ExprDimQuery();
        }
        MemberExpr schemeExpr = null;
        MemberExpr orgUnitExpr = null;
        FunctionExpr functionExpr = null;
        String orgUnitNumber = null;
        for (Object _expr : expr.params) {
            if (!(_expr instanceof MemberExpr)) continue;
            if (DimensionBaseConstants.DEF_SCHEME_SRCNUMBER.equals(((MemberExpr)_expr).srcNumber)) {
                schemeExpr = (MemberExpr)_expr;
                continue;
            }
            if (!DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER.equals(((MemberExpr)_expr).srcNumber)) continue;
            orgUnitExpr = (MemberExpr)_expr;
            orgUnitNumber = orgUnitExpr.number;
        }
        String schemeNumber = schemeExpr != null ? schemeExpr.number : currSchemeNum;
        for (IExpress _expr : expr.params) {
            if (!(_expr instanceof FunctionExpr)) continue;
            functionExpr = (FunctionExpr)_expr;
            if (!functionExpr.functionName.equalsIgnoreCase("Parent")) continue;
            if (functionExpr.params.isEmpty()) {
                orgUnitNumber = currOrgUnitNum;
                continue;
            }
            if (functionExpr.params.size() != 1) continue;
            String tOrgUnitNumber = (String)functionExpr.params.get(0);
            if (StringUtils.isEmpty((String)tOrgUnitNumber)) {
                tOrgUnitNumber = currOrgUnitNum;
            }
            if (!orgParentMap.containsKey(schemeNumber) || !orgParentMap.get(schemeNumber).containsKey(tOrgUnitNumber)) continue;
            orgUnitNumber = orgParentMap.get(schemeNumber).get(tOrgUnitNumber);
        }
        orgUnitNumber = orgUnitNumber != null ? orgUnitNumber : currOrgUnitNum;
        Set<Object> orgNumSet = null;
        if (query.schemeMap.containsKey(schemeNumber)) {
            orgNumSet = query.schemeMap.get(schemeNumber);
        } else {
            orgNumSet = new HashSet();
            query.schemeMap.put(schemeNumber, orgNumSet);
        }
        orgNumSet.add(orgUnitNumber);
        if (scopeMap != null) {
            String dimNumber22 = null;
            Object srcNumber = null;
            String field = null;
            Map.Entry<String, Set<String>> entry22 = null;
            Object var22_22 = null;
            for (Map.Entry<String, Set<String>> entry22 : scopeMap.entrySet()) {
                field = entry22.getKey();
                Set<String> set = entry22.getValue();
                if (DimensionBaseConstants.DEF_ORGUNIT_FIELD.equals(field)) continue;
                for (String dimNumber22 : set) {
                    srcNumber = DimUtils.getSrcNumber(dimNumber22);
                    MBgExamineUtils.putDimNumber(field, (String)srcNumber, dimNumber22, query.scopeNumMap, srcFieldMap);
                }
            }
        }
        HashSet<String> fieldSet = new HashSet<String>();
        for (IExpress _expr : expr.params) {
            if (!(_expr instanceof MemberExpr) || DimensionBaseConstants.DEF_SCHEME_SRCNUMBER.equals(((MemberExpr)_expr).srcNumber)) continue;
            if (((MemberExpr)_expr).field == null) {
                ((MemberExpr)_expr).field = srcFieldMap.get(((MemberExpr)_expr).srcNumber);
            }
            fieldSet.add(((MemberExpr)_expr).field);
            MBgExamineUtils.putDimNumber(schemeNumber, orgUnitNumber, ((MemberExpr)_expr).field, ((MemberExpr)_expr).srcNumber, ((MemberExpr)_expr).number, query.dimNumMap);
            if (!query.hasRight) continue;
            MBgExamineUtils.putDimNumber(schemeNumber, orgUnitNumber, ((MemberExpr)_expr).field, ((MemberExpr)_expr).srcNumber, ((MemberExpr)_expr).number, query.rdimNumMap);
        }
        for (String field : unionFields) {
            if (fieldSet.contains(field)) continue;
            Set tmpSet = null;
            if (formDataMap != null) {
                Object var22_26 = null;
                for (Map map : formDataMap.values()) {
                    if (!map.containsKey(field)) continue;
                    tmpSet = (Set)map.get(field);
                    MBgExamineUtils.putDimNumber(schemeNumber, orgUnitNumber, field, tmpSet, query.dimNumMap);
                }
            }
            if (adjustDataMap == null || !adjustDataMap.containsKey(field)) continue;
            tmpSet = adjustDataMap.get(field);
            MBgExamineUtils.putDimNumber(schemeNumber, orgUnitNumber, field, tmpSet, query.dimNumMap);
        }
        if (!schemeNumber.equals(currSchemeNum) && dimNumberMap != null && !dimNumberMap.isEmpty()) {
            Set<String> keySetRight;
            Set<String> keySetLeft = dimNumberMap.get(currSchemeNum) != null ? dimNumberMap.get(currSchemeNum).keySet() : null;
            Set<String> set = keySetRight = dimNumberMap.get(schemeNumber) != null ? dimNumberMap.get(schemeNumber).keySet() : null;
            if (keySetLeft != null) {
                String srcnumber22 = null;
                for (String srcnumber22 : keySetLeft) {
                    if (keySetRight != null && keySetRight.contains(srcnumber22)) continue;
                    if (query.fieldSet.containsKey(schemeNumber)) {
                        query.fieldSet.get(schemeNumber).add(srcFieldMap.get(srcnumber22));
                        continue;
                    }
                    HashSet<String> set2 = new HashSet<String>();
                    set2.add(srcFieldMap.get(srcnumber22));
                    query.fieldSet.put(schemeNumber, set2);
                }
            }
        }
        return query;
    }

    protected BOSUuid[] getBgTemplateIds(List<IDimDataQuery> billValues) {
        if (billValues == null || billValues.isEmpty()) {
            return null;
        }
        HashSet<BOSUuid> tmpIdSet = new HashSet<BOSUuid>();
        int in = billValues.size();
        for (int i = 0; i < in; ++i) {
            tmpIdSet.add(billValues.get(i).getBizTemplateId());
        }
        int index = 0;
        BOSUuid[] bgTempletIds = new BOSUuid[tmpIdSet.size()];
        Iterator iter = tmpIdSet.iterator();
        while (iter.hasNext()) {
            bgTempletIds[index] = (BOSUuid)iter.next();
            ++index;
        }
        return bgTempletIds;
    }

    protected ICalcData transMbgData(BgNDataInfo bgData, Map<String, IObjectValue> scenObjMap, Map<String, String> scenNumInnMap, Map<String, String> verNumInnMap, int valueType) {
        if (bgData == null) {
            return null;
        }
        BizCalcData calcData = new BizCalcData();
        calcData.setFormula(bgData.getFormula());
        calcData.setDimNumber(bgData.getBgItemNumber());
        calcData.setBgPeriodNumber(bgData.getBgPeriodNumber());
        calcData.setBgElementNumber(bgData.getBgElementNumber());
        calcData.setBgScenarioNumber(bgData.getBgScenario());
        calcData.setBgScenario(Integer.valueOf(scenNumInnMap.get(calcData.getBgScenarioNumber())).intValue());
        if (bgData.getBgVersion() != null) {
            calcData.setBgVersionNumber(bgData.getBgVersion());
            calcData.setBgVersion(Integer.valueOf(verNumInnMap.get(calcData.getBgVersionNumber())).intValue());
        }
        calcData.setCurrencyNumber(bgData.getCurrencyNumber());
        if (scenObjMap.containsKey(calcData.getBgScenarioNumber())) {
            BgScenarioInfo scenario = (BgScenarioInfo)scenObjMap.get(calcData.getBgScenarioNumber());
            int type = scenario.getType().getValue();
            if (0 == type) {
                calcData.setValue(bgData.getBudgetValueNoDef());
            } else if (1 == type) {
                if (valueType == 16 || valueType == 32 || valueType == 2048) {
                    calcData.setValue(bgData.getAddActualNoDef());
                } else {
                    calcData.setValue(bgData.getBizActualNoDef());
                }
            }
        }
        return calcData;
    }

    protected void filterValue(List<IDimDataQuery> billValues, Map<String, Set<String>> examRefMap) {
        if (billValues == null || billValues.isEmpty() || examRefMap == null) {
            return;
        }
        HashSet refBgFormIds = new HashSet();
        Iterator<Set<String>> iter = examRefMap.values().iterator();
        while (iter.hasNext()) {
            refBgFormIds.addAll(iter.next());
        }
        ArrayList<IDimDataQuery> removes = new ArrayList<IDimDataQuery>();
        IDimDataQuery model = null;
        String billId = null;
        int in = billValues.size();
        for (int i = 0; i < in; ++i) {
            model = billValues.get(i);
            billId = model.getId().toString();
            if (refBgFormIds.contains(billId)) continue;
            removes.add(model);
        }
        if (!removes.isEmpty()) {
            billValues.removeAll(removes);
        }
    }

    protected Map<String, List<IDimDataQuery>> diffValue(List<IDimDataQuery> billValues, boolean hasPeriodVariable) {
        HashMap<String, List<IDimDataQuery>> diffValueMap = new HashMap<String, List<IDimDataQuery>>();
        if (billValues == null || billValues.isEmpty()) {
            return diffValueMap;
        }
        String bgPeriodNum = null;
        List<IDimDataQuery> tmpValues = null;
        for (IDimDataQuery dimData : billValues) {
            if (hasPeriodVariable) {
                bgPeriodNum = dimData.getBizPeriod().getNumber();
            } else if (bgPeriodNum == null) {
                bgPeriodNum = dimData.getBizPeriod().getNumber();
            }
            if (diffValueMap.containsKey(bgPeriodNum)) {
                tmpValues = (List)diffValueMap.get(bgPeriodNum);
            } else {
                tmpValues = new ArrayList();
                diffValueMap.put(dimData.getBizPeriod().getNumber(), tmpValues);
            }
            tmpValues.add(dimData);
        }
        return diffValueMap;
    }

    protected List<BgExamineInfo> filterExamine(List<IDimDataQuery> billValues, Map<String, Set<String>> examineMap, List<BgExamineInfo> examines) {
        ArrayList<BgExamineInfo> examinefilter = new ArrayList<BgExamineInfo>();
        HashSet examineIds = new HashSet();
        for (IDimDataQuery model : billValues) {
            examineIds.addAll(examineMap.get(model.getId().toString()));
        }
        for (BgExamineInfo _examine : examines) {
            if (!examineIds.contains(_examine.getId().toString())) continue;
            examinefilter.add(_examine);
        }
        return examinefilter;
    }

    protected IDimensionParameter transDimensionParameter(Context ctx, Connection conn, BgSchemeInfo schemeInfo, OrgUnitInfo orgUnitInfo, List<ExprDimQuery> querys, Map<String, Map<String, Set<String>>> formDataMap, Map<String, Set<String>> examRefMap, Map<String, Set<String>> adjustDataMap, Map<String, MbgDimInfo> mbgDimMap, Map<String, IObjectValue> scenaioMap, Map<String, IObjectValue> versionMap) throws Exception {
        if (ctx == null || conn == null || schemeInfo == null || orgUnitInfo == null || querys == null || querys.isEmpty() || mbgDimMap == null || scenaioMap == null || versionMap == null) {
            return null;
        }
        DimensionParameter parameter = new DimensionParameter();
        parameter.getDataManager().setBgScheme(schemeInfo);
        parameter.getDataManager().setOrgUnit(orgUnitInfo);
        BgOrgUnitInfo bgOrgUnit = MbgDataHelper.getBgOrgUnitInfo(conn, ctx.getLocale(), parameter.getDataManager().getBgScheme().getEditOrgViewId(), parameter.getDataManager().getOrgUnit().getId());
        if (bgOrgUnit == null) {
            // empty if block
        }
        parameter.getDataManager().setBgOrgUnit(bgOrgUnit);
        parameter.getDataManager().getBgScenarioMap().putAll(scenaioMap);
        parameter.getDataManager().getBgVersionMap().putAll(versionMap);
        parameter.setBgSchemeId(parameter.getDataManager().getBgScheme().getId());
        parameter.setBgOrgViewId(parameter.getDataManager().getBgScheme().getEditOrgViewId());
        parameter.setOrgUnitId(parameter.getDataManager().getOrgUnit().getId());
        parameter.setValueType(1);
        parameter.getControlManager().setHasQueryDataState(false);
        Map<String, Map<String, Set<String>>> orgDimMap = null;
        Map<String, Set<String>> dimNumMap = null;
        ExprDimQuery query = null;
        QueryData queryData = null;
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = null;
        IDimension mbgDimen2 = null;
        int in = querys.size();
        for (int i = 0; i < in; ++i) {
            IDimension periodDim;
            Set<String> bgFormIds;
            query = querys.get(i);
            if (!query.dimNumMap.containsKey(schemeInfo.getNumber()) || !(orgDimMap = query.dimNumMap.get(schemeInfo.getNumber())).containsKey(orgUnitInfo.getNumber()) && !orgDimMap.containsKey("DEFAULT_ORGUNIT_NUMBER")) continue;
            queryData = new QueryData();
            HashSet<String> notExists = new HashSet<String>();
            if (orgDimMap.containsKey(orgUnitInfo.getNumber())) {
                dimNumMap = orgDimMap.get(orgUnitInfo.getNumber());
                if (!this.schemeInfo.getNumber().equals(schemeInfo.getNumber())) {
                    for (String key : dimNumMap.keySet()) {
                        if (!this.defultMap.containsKey(key)) continue;
                        dimNumMap.get(key).add(this.defultMap.get(key));
                    }
                    if (this.schemeFieldMap.containsKey(schemeInfo.getNumber())) {
                        Set<String> schemefiledSet = this.schemeFieldMap.get(schemeInfo.getNumber());
                        for (String fieldKey : schemefiledSet) {
                            HashSet<String> fieldSet;
                            Map<Object, Object> orgField;
                            if (this.fieldMap.containsKey(schemeInfo.getNumber())) {
                                orgField = this.fieldMap.get(schemeInfo.getNumber());
                                if (orgField.containsKey(orgUnitInfo.getNumber())) {
                                    ((Set)orgField.get(orgUnitInfo.getNumber())).add(fieldKey);
                                    continue;
                                }
                                fieldSet = new HashSet();
                                fieldSet.add(fieldKey);
                                orgField.put(orgUnitInfo.getNumber(), fieldSet);
                                this.fieldMap.put(schemeInfo.getNumber(), orgField);
                                continue;
                            }
                            orgField = new HashMap();
                            fieldSet = new HashSet<String>();
                            fieldSet.add(fieldKey);
                            orgField.put(orgUnitInfo.getNumber(), fieldSet);
                            this.fieldMap.put(schemeInfo.getNumber(), orgField);
                        }
                    }
                    if (this.fieldMap.containsKey(schemeInfo.getNumber()) && this.fieldMap.get(schemeInfo.getNumber()).containsKey(orgUnitInfo.getNumber())) {
                        Set<String> field = this.fieldMap.get(schemeInfo.getNumber()).get(orgUnitInfo.getNumber());
                        Iterator<String> iterator = field.iterator();
                        while (iterator.hasNext()) {
                            String fieldKey;
                            fieldKey = iterator.next();
                            if (dimNumMap.containsKey(fieldKey)) continue;
                            HashSet fieldSet = new HashSet();
                            fieldSet.add(this.defultMap.get(fieldKey));
                            dimNumMap.put(fieldKey, fieldSet);
                            notExists.add(fieldKey);
                        }
                    }
                }
                MBgExamineUtils.addMbgMember(queryData, dimNumMap, mbgDimMap, false);
            } else if (orgDimMap.containsKey("DEFAULT_ORGUNIT_NUMBER")) {
                dimNumMap = orgDimMap.get("DEFAULT_ORGUNIT_NUMBER");
                if (!this.schemeInfo.getNumber().equals(schemeInfo.getNumber())) {
                    for (String key : dimNumMap.keySet()) {
                        if (!this.defultMap.containsKey(key)) continue;
                        dimNumMap.get(key).add(this.defultMap.get(key));
                    }
                }
                MBgExamineUtils.addMbgMember(queryData, dimNumMap, mbgDimMap, false);
            }
            if (examRefMap != null && formDataMap != null && examRefMap.containsKey(query.examineId) && (bgFormIds = examRefMap.get(query.examineId)) != null) {
                Map<String, Set<String>> formNumMap = null;
                HashMap<String, Set> formTempNumMap = new HashMap<String, Set>();
                for (String bgFormId : bgFormIds) {
                    if (!formDataMap.containsKey(bgFormId)) continue;
                    formNumMap = formDataMap.get(bgFormId);
                    if (!this.schemeInfo.getNumber().equals(schemeInfo.getNumber()) && dimNumMap != null) {
                        for (String key : dimNumMap.keySet()) {
                            if (!formNumMap.containsKey(key) || notExists.contains(key)) continue;
                            formTempNumMap.put(key, (Set)((HashSet)formNumMap.get(key)).clone());
                            formNumMap.get(key).retainAll((Collection)dimNumMap.get(key));
                        }
                    }
                    MBgExamineUtils.addMbgMember(queryData, formNumMap, mbgDimMap, false);
                    for (String key : formTempNumMap.keySet()) {
                        formNumMap.get(key).addAll((Collection)formTempNumMap.get(key));
                    }
                }
            }
            if (adjustDataMap != null) {
                MBgExamineUtils.addMbgMember(queryData, adjustDataMap, mbgDimMap, true);
            }
            if (query.scopeNumMap != null && !query.scopeNumMap.isEmpty()) {
                MBgExamineUtils.addMbgMember1(queryData, query.scopeNumMap, mbgDimMap);
            }
            if (!query.rdimNumMap.isEmpty() && query.rdimNumMap.containsKey(schemeInfo.getNumber()) && ((orgDimMap = query.rdimNumMap.get(schemeInfo.getNumber())).containsKey(orgUnitInfo.getNumber()) || orgDimMap.containsKey("DEFAULT_ORGUNIT_NUMBER"))) {
                if (orgDimMap.containsKey(orgUnitInfo.getNumber())) {
                    dimNumMap = orgDimMap.get(orgUnitInfo.getNumber());
                    MBgExamineUtils.addMbgMember(queryData, dimNumMap, mbgDimMap, false);
                } else if (orgDimMap.containsKey("DEFAULT_ORGUNIT_NUMBER")) {
                    dimNumMap = orgDimMap.get("DEFAULT_ORGUNIT_NUMBER");
                    MBgExamineUtils.addMbgMember(queryData, dimNumMap, mbgDimMap, false);
                }
            }
            if (query.offPeriodSet != null && !query.offPeriodSet.isEmpty() && (periodDim = queryData.getMbgDimMap().get(DimensionBaseConstants.DEF_PERIOD_FIELD)) != null) {
                Member mbgMember = null;
                for (String number : query.offPeriodSet) {
                    mbgMember = new Member();
                    mbgMember.setNumber(number);
                    mbgMember.setDimNumber(number);
                    periodDim.addMember(mbgMember);
                }
            }
            if (!query.fieldSet.isEmpty()) {
                Iterator<IDimension> iter = queryData.getMbgDimMap().values().iterator();
                while (iter.hasNext()) {
                    mbgDimen2 = iter.next();
                    if (query.fieldSet.get(schemeInfo.getNumber()) == null || !query.fieldSet.get(schemeInfo.getNumber()).contains(mbgDimen2.getField())) continue;
                    iter.remove();
                }
            }
            for (IDimension mbgDimen2 : queryData.getMbgDimMap().values()) {
                if (!DimensionConstants.necessary.contains(mbgDimen2.getNumber()) && parameter.getDataManager().getBgScheme().getViewId(mbgDimen2.getNumber()) == null) {
                    return null;
                }
                MbgCubeUtils.queryItemLongNumber(ctx, parameter, mbgDimen2);
                MbgCubeUtils.transScenarioNumber(ctx, scenaioMap, mbgDimen2);
                MbgCubeUtils.transVersionNumber(ctx, versionMap, mbgDimen2);
                MbgCubeUtils.transBgPeriodMember(ctx, parameter, mbgDimen2, false);
                if (parameter.getDimensionMap().containsKey(mbgDimen2.getNumber())) {
                    dimension = parameter.getDimensionMap().get(mbgDimen2.getNumber());
                } else {
                    dimension = new DimensionObject();
                    dimension.setNumber(mbgDimen2.getNumber());
                    dimension.setField(mbgDimen2.getField());
                    dimension.setSrcNumber(mbgDimen2.getSrcNumber());
                    parameter.getDimensionMap().put(dimension.getNumber(), dimension);
                }
                MbgCubeUtils.mergeDimension(mbgDimen2, dimension);
            }
            if (!query.formulaMaps.isEmpty()) {
                MBgExamineUtils.mergeDimData(query.exprDataMap, queryData.getMbgDimMap());
            }
            parameter.getQuerys().add(queryData);
        }
        return parameter;
    }

    protected void checkBgExamineResult(BgExamineResult result) {
        if (result != null) {
            result.check();
        }
    }

    protected void saveBgExamineResult(Context ctx, List<String> billIds, BgExamineResult result) throws BOSException, EASBizException {
        BgExamineServelHelper.removeScopeFromResult(result);
        BgExamineCheckFactory.getLocalInstance(ctx).addnew(billIds, result);
    }

    @Override
    protected List _queryRefBills(Context ctx, BizCalcObj checkObj, int dataType, List billIds) throws BOSException, EASBizException {
        ArrayList<IDimDataQuery> refBills = new ArrayList<IDimDataQuery>();
        if (ctx == null || checkObj == null) {
            return refBills;
        }
        BgSchemeInfo schemeInfo = null;
        OrgUnitInfo unitInfo = null;
        BgVersionInfo versionInfo = null;
        Connection conn = null;
        IRowSet rst = null;
        String mbgDataId = null;
        String cubeName = null;
        String cubeEntry = null;
        HashSet<String> bgFormIds = new HashSet<String>();
        try {
            conn = this.getConnection(ctx);
            schemeInfo = MbgDataHelper.getBgSchemeByNumber(conn, ctx.getLocale(), checkObj.schemeNum);
            unitInfo = MbgDataHelper.getOrgUnitByNumber(conn, ctx.getLocale(), checkObj.orgUnitNum);
            versionInfo = MbgDataHelper.getBgVersionByNumber(conn, ctx.getLocale(), checkObj.versionNum);
            if (dataType == 64) {
                cubeName = BgCubeUtils.getCFSCubeName(schemeInfo.getRefCube());
                cubeEntry = BgCubeUtils.getCFSEntryCubeName(schemeInfo.getRefCube());
            } else if (dataType == 128) {
                cubeName = BgCubeUtils.getCFSAdjustCubeName(schemeInfo.getRefCube());
                cubeEntry = BgCubeUtils.getCFSAdjustEntryCubeName(schemeInfo.getRefCube());
            } else if (DimensionCommonHelper.isDecompose(dataType)) {
                cubeName = BgCubeUtils.getCubeName(schemeInfo.getRefCube(), dataType);
                cubeEntry = BgCubeUtils.getCubeEntryName(schemeInfo.getRefCube(), dataType);
            } else {
                cubeName = schemeInfo.getRefCube();
                cubeEntry = BgCubeUtils.getBudgetEntryCubeName(schemeInfo.getRefCube());
            }
            if (schemeInfo != null && unitInfo != null && versionInfo != null) {
                List<IDimDataQuery> tmpList;
                rst = BgDBUtils.executeQuery((Connection)conn, (String)("select top 1 FID from " + cubeName + " where FOrgUnitId = ? and FFormula = ? and FVersion = ?"), (Object[])new Object[]{unitInfo.getId().toString(), checkObj.formula, versionInfo.getVersionId()});
                if (rst.next()) {
                    mbgDataId = rst.getString("FID");
                }
                SQLUtils.cleanup((ResultSet)rst);
                if (!StringUtils.isEmpty((String)mbgDataId)) {
                    rst = BgDBUtils.executeQuery((Connection)conn, (String)("select FFormID from " + cubeEntry + " where FDataId = ?"), (Object[])new Object[]{mbgDataId});
                    while (rst.next()) {
                        bgFormIds.add(rst.getString("FFormID"));
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
                if (!bgFormIds.isEmpty() && (tmpList = MbgDataHelper.getBillValue(ctx, conn, bgFormIds)) != null && !tmpList.isEmpty()) {
                    refBills.addAll(tmpList);
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst, null, (Connection)conn);
        }
        return refBills;
    }

    @Override
    protected Map _queryRefBills(Context ctx, List calcObjs, int dataType, List billIds) throws BOSException, EASBizException {
        HashMap<String, String[]> mbgDataRefMap = new HashMap<String, String[]>();
        if (ctx == null || calcObjs == null || calcObjs.isEmpty()) {
            return mbgDataRefMap;
        }
        HashMap<String, Set<String>> mbgQueryMap = new HashMap<String, Set<String>>();
        HashMap<String, String> adjustIdRefIds = new HashMap<String, String>();
        Set<String> formulas = null;
        HashMap orgUnitMap = new HashMap();
        HashMap versionMap = new HashMap();
        Set<String> orgUnitNums = null;
        Set<String> versionNums = null;
        HashMap<String, Set<Integer>> bgProcessTypeMap = new HashMap<String, Set<Integer>>();
        Set<Integer> bgProcessTypes = null;
        boolean hasProcessType = false;
        BizCalcObj calcObj = null;
        String unionId = null;
        int in = calcObjs.size();
        for (int i = 0; i < in; ++i) {
            calcObj = (BizCalcObj)calcObjs.get(i);
            if (unionId == null && calcObj.unionId != null) {
                unionId = calcObj.unionId;
            }
            if (orgUnitMap.containsKey(calcObj.schemeNum)) {
                orgUnitNums = (Set)orgUnitMap.get(calcObj.schemeNum);
            } else {
                orgUnitNums = new HashSet();
                orgUnitMap.put(calcObj.schemeNum, orgUnitNums);
            }
            orgUnitNums.add(calcObj.orgUnitNum);
            if (mbgQueryMap.containsKey(calcObj.schemeNum)) {
                formulas = (Set)mbgQueryMap.get(calcObj.schemeNum);
            } else {
                formulas = new HashSet();
                mbgQueryMap.put(calcObj.schemeNum, formulas);
            }
            formulas.add(calcObj.formula);
            if (versionMap.containsKey(calcObj.schemeNum)) {
                versionNums = (Set)versionMap.get(calcObj.schemeNum);
            } else {
                versionNums = new HashSet();
                versionMap.put(calcObj.schemeNum, versionNums);
            }
            versionNums.add(calcObj.versionNum);
            if (bgProcessTypeMap.containsKey(calcObj.schemeNum)) {
                bgProcessTypes = (Set)bgProcessTypeMap.get(calcObj.schemeNum);
            } else {
                bgProcessTypes = new HashSet();
                bgProcessTypeMap.put(calcObj.schemeNum, bgProcessTypes);
            }
            bgProcessTypes.add(BgProcessEnum.getEnum(calcObj.getBgProceeType()).getValue());
        }
        Map.Entry entry2 = null;
        String schemeNum = null;
        String tmpOrgTable = null;
        String tmpFormula = null;
        String tmpVersion = null;
        String key = null;
        String cubeName = null;
        String cubeEntry = null;
        String tmpFormTable = null;
        String[] bgForm = null;
        StringBuffer sql = null;
        String tmpProcessType = null;
        String cmpCubeName02 = null;
        String cmpCubeEntry02 = null;
        String cmpCubeName03 = null;
        String cmpCubeEntry03 = null;
        String cmpCubeName04 = null;
        String cmpCubeEntry04 = null;
        BgSchemeInfo schemeInfo = null;
        Connection conn = null;
        ResultSet rst = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            conn = this.getConnection(ctx);
            for (Map.Entry entry2 : mbgQueryMap.entrySet()) {
                schemeNum = (String)entry2.getKey();
                formulas = (Set)entry2.getValue();
                orgUnitNums = (Set)orgUnitMap.get(schemeNum);
                versionNums = (Set)versionMap.get(schemeNum);
                bgProcessTypes = (Set)bgProcessTypeMap.get(schemeNum);
                if (dataType != 256 && dataType != 1 && dataType != 512 && dataType != 1024 && unionId == null || orgUnitNums == null || orgUnitNums.isEmpty() || formulas == null || formulas.isEmpty() || versionNums == null || versionNums.isEmpty()) continue;
                schemeInfo = MbgDataHelper.getBgSchemeByNumber(conn, ctx.getLocale(), schemeNum);
                if (tmpOrgTable == null) {
                    tmpOrgTable = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(80))", conn);
                }
                BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate table " + tmpOrgTable));
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpOrgTable + " (FNumber) values (?)"), orgUnitNums);
                if (tmpFormula == null) {
                    tmpFormula = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FFormula NVARCHAR(300))", conn);
                }
                BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate table " + tmpFormula));
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpFormula + " (FFormula) values (?)"), formulas);
                if (tmpVersion == null) {
                    tmpVersion = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(80))", conn);
                }
                BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate table " + tmpVersion));
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpVersion + " (FNumber) values (?)"), versionNums);
                if (dataType == 128) {
                    cubeName = BgCubeUtils.getCFSAdjustCubeName(schemeInfo.getRefCube());
                    cubeEntry = BgCubeUtils.getCFSAdjustEntryCubeName(schemeInfo.getRefCube());
                } else if (dataType == 64) {
                    cubeName = BgCubeUtils.getCFSCubeName(schemeInfo.getRefCube());
                    cubeEntry = BgCubeUtils.getCFSEntryCubeName(schemeInfo.getRefCube());
                } else {
                    if (dataType == 256 || bgProcessTypes.contains(2)) {
                        cmpCubeName02 = BgCubeUtils.getDecomposeCubeName(schemeInfo.getRefCube());
                        cmpCubeEntry02 = BgCubeUtils.getDecomposeEntryCubeName(schemeInfo.getRefCube());
                    }
                    if (dataType == 512 || bgProcessTypes.contains(3)) {
                        cmpCubeName03 = BgCubeUtils.getDecomposeSendDownCubeName(schemeInfo.getRefCube());
                        cmpCubeEntry03 = BgCubeUtils.getDecomposeSendDownEntryCubeName(schemeInfo.getRefCube());
                    }
                    if (dataType == 1024 || bgProcessTypes.contains(4)) {
                        cmpCubeName03 = BgCubeUtils.getDecomposeGatherCubeName(schemeInfo.getRefCube());
                        cmpCubeEntry03 = BgCubeUtils.getDecomposeGatherEntryCubeName(schemeInfo.getRefCube());
                    }
                    if (bgProcessTypes.contains(1)) {
                        cubeName = schemeInfo.getRefCube();
                        cubeEntry = BgCubeUtils.getBudgetEntryCubeName(schemeInfo.getRefCube());
                        bgProcessTypes.add(1);
                    }
                }
                if (tmpProcessType == null) {
                    tmpProcessType = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FNumber INT DEFAULT 0)", conn);
                }
                BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate table " + tmpProcessType));
                BgDBUtils.insertKey1((Connection)conn, (String)("Insert Into " + tmpProcessType + " (FNumber) values (?)"), bgProcessTypes);
                if (sql == null) {
                    sql = new StringBuffer();
                    if (dataType == 128) {
                        sql.append("select cc.FNumber AS FCNumber, t.FFormula, v.FNumber AS FVNumber, e.FFormId, f.FName AS FFName, f.FNumber AS FFNumber, f.FState AS FFState, te.FFormType from " + cubeName + " t left join " + cubeEntry + " e on t.FID = e.FDataId left join T_MBG_BgVersion v on t.FVersion = v.FVersionId left join T_ORG_BaseUnit cc on t.FOrgUnitId = cc.FID left join T_MBG_BgCslAdjForm f on e.FFormId = f.FID left join T_MBG_BgCslAdjTemplate te on f.FBgCslTemplateID = te.FID where t.FUnionId = ? and cc.FNumber IN (select FNumber from " + tmpOrgTable + ") and exists (select FFormula from " + tmpFormula + " where FFormula = t.FFormula) and v.FNumber IN (select FNumber from " + tmpVersion + ")");
                        rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId});
                    } else if (dataType == 64) {
                        sql.append("select cc.FNumber AS FCNumber, t.FFormula, v.FNumber AS FVNumber, e.FFormId, f.FName AS FFName, f.FNumber AS FFNumber, f.FState AS FFState, te.FFormType from " + cubeName + " t left join " + cubeEntry + " e on t.FID = e.FDataId left join T_MBG_BgVersion v on t.FVersion = v.FVersionId left join T_ORG_BaseUnit cc on t.FOrgUnitId = cc.FID left join T_MBG_BgCslForm f on e.FFormId = f.FID left join T_MBG_BgCslTemplate te on f.FBgCslTemplateID = te.FID where t.FUnionId = ? and cc.FNumber IN (select FNumber from " + tmpOrgTable + ") and exists (select FFormula from " + tmpFormula + " where FFormula = t.FFormula) and v.FNumber IN (select FNumber from " + tmpVersion + ")");
                        sql.append(" union all ");
                        sql.append("select cc.FNumber AS FCNumber, t.FFormula, v.FNumber AS FVNumber, e.FFormId, f.FName AS FFName, f.FNumber AS FFNumber, f.FState AS FFState, 2 from " + cubeName + " t left join " + cubeEntry + " e on t.FID = e.FDataId left join T_MBG_BgVersion v on t.FVersion = v.FVersionId left join T_ORG_BaseUnit cc on t.FOrgUnitId = cc.FID left join T_MBG_MbgWorkPaper f on e.FFormId = f.FID left join T_MBG_BgNWorkTemplate te on f.FWorkTemplateID = te.FID where t.FUnionId = ? and cc.FNumber IN (select FNumber from " + tmpOrgTable + ") and exists (select FFormula from " + tmpFormula + " where FFormula = t.FFormula) and v.FNumber IN (select FNumber from " + tmpVersion + ")");
                        rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId, unionId});
                    } else {
                        if (!StringUtils.isEmpty((String)cubeName) && !StringUtils.isEmpty((String)cubeEntry)) {
                            BgSchemeAccIntHelper accIntHelper = new BgSchemeAccIntHelper(ctx, schemeInfo.getId().toString(), cubeName);
                            if (accIntHelper.isUseAccInt()) {
                                Set<String> cubeNames = accIntHelper.getSplitTablesByFormula(formulas);
                                for (String table : cubeNames) {
                                    if (sql.length() > 0) {
                                        sql.append(" union all ");
                                    }
                                    sql.append("select cc.FNumber AS FCNumber, t.FFormula, v.FNumber AS FVNumber, e.FFormId, f.FName AS FFName, f.FNumber AS FFNumber, f.FState AS FFState, te.FFormType, f.FProcessType from " + table + " t left join " + cubeEntry + " e on t.FID = e.FDataId left join T_MBG_BgVersion v on t.FVersion = v.FVersionId left join T_MBG_BgOrgUnit bgOrg on bgOrg.FIntId = t.FOrgUnitId AND bgOrg.FIsVirtual = 0 and bgOrg.FViewId = '" + accIntHelper.getSchemeHelper().getBgOrgViewId() + "' left join T_ORG_CostCenter cc on bgOrg.FOrgUnitId = cc.FID left join T_MBG_BgForm f on e.FFormId = f.FID left join T_MBG_BgTemplate te on f.FBgTemplateId = te.FID where cc.FNumber IN (select FNumber from " + tmpOrgTable + ") and exists (select FFormula from " + tmpFormula + " where FFormula = t.FFormula) and v.FNumber IN (select FNumber from " + tmpVersion + ")and f.FProcessType IN (select FNumber from " + tmpProcessType + ")");
                                }
                            } else {
                                sql.append("select cc.FNumber AS FCNumber, t.FFormula, v.FNumber AS FVNumber, e.FFormId, f.FName AS FFName, f.FNumber AS FFNumber, f.FState AS FFState, te.FFormType, f.FProcessType from " + cubeName + " t left join " + cubeEntry + " e on t.FID = e.FDataId left join T_MBG_BgVersion v on t.FVersion = v.FVersionId left join T_ORG_CostCenter cc on t.FOrgUnitId = cc.FID left join T_MBG_BgForm f on e.FFormId = f.FID left join T_MBG_BgTemplate te on f.FBgTemplateId = te.FID where cc.FNumber IN (select FNumber from " + tmpOrgTable + ") and exists (select FFormula from " + tmpFormula + " where FFormula = t.FFormula) and v.FNumber IN (select FNumber from " + tmpVersion + ")and f.FProcessType IN (select FNumber from " + tmpProcessType + ")");
                            }
                        }
                        if (!StringUtils.isEmpty((String)cmpCubeName02) && !StringUtils.isEmpty((String)cmpCubeEntry02)) {
                            if (sql.length() > 0) {
                                sql.append(" union all ");
                            }
                            sql.append("select cc.FNumber AS FCNumber, t.FFormula, v.FNumber AS FVNumber, e.FFormId, f.FName AS FFName, f.FNumber AS FFNumber, f.FState AS FFState, te.FFormType, f.FProcessType from " + cmpCubeName02 + " t left join " + cmpCubeEntry02 + " e on t.FID = e.FDataId left join T_MBG_BgVersion v on t.FVersion = v.FVersionId left join T_ORG_CostCenter cc on t.FOrgUnitId = cc.FID left join T_MBG_BgForm f on e.FFormId = f.FID left join T_MBG_BgTemplate te on f.FBgTemplateId = te.FID where cc.FNumber IN (select FNumber from " + tmpOrgTable + ") and exists (select FFormula from " + tmpFormula + " where FFormula = t.FFormula) and v.FNumber IN (select FNumber from " + tmpVersion + ")and f.FProcessType IN (select FNumber from " + tmpProcessType + ")");
                        }
                        if (!StringUtils.isEmpty((String)cmpCubeName03) && !StringUtils.isEmpty((String)cmpCubeEntry03)) {
                            if (sql.length() > 0) {
                                sql.append(" union all ");
                            }
                            sql.append("select cc.FNumber AS FCNumber, t.FFormula, v.FNumber AS FVNumber, e.FFormId, f.FName AS FFName, f.FNumber AS FFNumber, f.FState AS FFState, te.FFormType, f.FProcessType from " + cmpCubeName03 + " t left join " + cmpCubeEntry03 + " e on t.FID = e.FDataId left join T_MBG_BgVersion v on t.FVersion = v.FVersionId left join T_ORG_CostCenter cc on t.FOrgUnitId = cc.FID left join T_MBG_BgForm f on e.FFormId = f.FID left join T_MBG_BgTemplate te on f.FBgTemplateId = te.FID where cc.FNumber IN (select FNumber from " + tmpOrgTable + ") and exists (select FFormula from " + tmpFormula + " where FFormula = t.FFormula) and v.FNumber IN (select FNumber from " + tmpVersion + ")and f.FProcessType IN (select FNumber from " + tmpProcessType + ")");
                        }
                        if (!StringUtils.isEmpty(cmpCubeName04) && !StringUtils.isEmpty(cmpCubeEntry04)) {
                            if (sql.length() > 0) {
                                sql.append(" union all ");
                            }
                            sql.append("select cc.FNumber AS FCNumber, t.FFormula, v.FNumber AS FVNumber, e.FFormId, f.FName AS FFName, f.FNumber AS FFNumber, f.FState AS FFState, te.FFormType, f.FProcessType from " + cmpCubeName04 + " t left join " + cmpCubeEntry04 + " e on t.FID = e.FDataId left join T_MBG_BgVersion v on t.FVersion = v.FVersionId left join T_ORG_CostCenter cc on t.FOrgUnitId = cc.FID left join T_MBG_BgForm f on e.FFormId = f.FID left join T_MBG_BgTemplate te on f.FBgTemplateId = te.FID where cc.FNumber IN (select FNumber from " + tmpOrgTable + ") and exists (select FFormula from " + tmpFormula + " where FFormula = t.FFormula) and v.FNumber IN (select FNumber from " + tmpVersion + ")and f.FProcessType IN (select FNumber from " + tmpProcessType + ")");
                        }
                        rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
                        tmpFormTable = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FID NVARCHAR(44))", conn);
                        BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate table " + tmpFormTable));
                        BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpFormTable + " (FID) values (?)"), (Collection)billIds);
                        sql.setLength(0);
                        sql.append("select FID,FAdjustId from T_MBG_bgForm where FID in (select FID from " + tmpFormTable + ")");
                        IRowSet rs = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
                        while (rs.next()) {
                            String id = rs.getString("FID");
                            String adjustId = rs.getString("FAdjustId");
                            if (adjustId == null) continue;
                            adjustIdRefIds.put(adjustId, id);
                        }
                        hasProcessType = true;
                    }
                    sql = null;
                }
                if (rst == null) continue;
                while (rst.next()) {
                    if (StringUtils.isEmpty((String)rst.getString("FFNumber")) && StringUtils.isEmpty((String)rst.getString("FFName")) || mbgDataRefMap.containsKey(key = dataType == 64 || dataType == 128 ? schemeInfo.getNumber() + "_" + rst.getString("FCNumber") + "_" + 1 + "_" + rst.getString("FFormula") + "_" + rst.getString("FVNumber") : schemeInfo.getNumber() + "_" + rst.getString("FCNumber") + "_" + rst.getString("FProcessType") + "_" + rst.getString("FFormula") + "_" + rst.getString("FVNumber")) && !billIds.contains(rst.getString("FFormId"))) continue;
                    bgForm = new String[7];
                    bgForm[0] = rst.getString("FFormId");
                    if (!adjustIdRefIds.isEmpty() && adjustIdRefIds.containsKey(bgForm[0])) {
                        bgForm[0] = (String)adjustIdRefIds.get(bgForm[0]);
                    }
                    if (StringUtils.isEmpty((String)rst.getString("FFName"))) continue;
                    bgForm[1] = rst.getString("FFName");
                    bgForm[2] = rst.getString("FFNumber");
                    bgForm[3] = String.valueOf(rst.getInt("FFormType"));
                    bgForm[5] = String.valueOf(rst.getInt("FFState"));
                    bgForm[6] = hasProcessType ? BgProcessEnum.getEnum(rst.getInt("FProcessType")).getName() : BgProcessEnum.C01.getName();
                    mbgDataRefMap.put(key, bgForm);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            if (pool != null && tmpOrgTable != null) {
                try {
                    pool.releaseDBSystemTempTable(tmpOrgTable, conn);
                }
                catch (Exception exception) {}
            }
            if (pool != null && tmpFormula != null) {
                try {
                    pool.releaseDBSystemTempTable(tmpFormula, conn);
                }
                catch (Exception exception) {}
            }
            if (pool != null && tmpVersion != null) {
                try {
                    pool.releaseDBSystemTempTable(tmpVersion, conn);
                }
                catch (Exception exception) {}
            }
            if (pool != null && tmpProcessType != null) {
                try {
                    pool.releaseDBSystemTempTable(tmpProcessType, conn);
                }
                catch (Exception exception) {}
            }
            SQLUtils.cleanup(rst, null, (Connection)conn);
        }
        return mbgDataRefMap;
    }

    protected void checkPostil(Context ctx, BgExamineResult result) throws BOSException, EASBizException {
        if (ctx == null || result == null) {
            return;
        }
        Map<String, Map<String, Map<String, List<BgExamineDataCheckResult>>>> subSetCheckResultMap = result.getSubsetCheckResultMap();
        List<BgExamineInfo> examines = result.examines;
        if (subSetCheckResultMap == null || subSetCheckResultMap.isEmpty() || examines == null || examines.isEmpty()) {
            return;
        }
        Map<String, Map<String, List<BgExamineDataCheckResult>>> orgCheckMap2 = null;
        Map.Entry<String, Map<String, List<BgExamineDataCheckResult>>> entry2 = null;
        Map<String, List<BgExamineDataCheckResult>> examCheckMap = null;
        List<BgExamineDataCheckResult> results2 = null;
        BgExamineDataCheckResult checkResult = null;
        BizCalcObj[] calcObjs = null;
        BizCalcObj calcObj2 = null;
        String examineId = null;
        String dimNumber = null;
        String[] tmpStr = null;
        BgExamineInfo examine = null;
        HashSet<String> processSet = new HashSet<String>();
        HashMap<String, BgExamineInfo> postilMap = new HashMap<String, BgExamineInfo>();
        int in = examines.size();
        for (int i = 0; i < in; ++i) {
            examine = examines.get(i);
            if (2 != examine.getNoPass().getValue()) continue;
            for (int j = 0; j < examine.getBgExamineSubset().size(); ++j) {
                postilMap.put(examine.getBgExamineSubset().get(j).getId().toString(), examine);
            }
        }
        HashMap<String, Set<String>> queryData = new HashMap<String, Set<String>>();
        HashSet<String> bgSchemeIds = new HashSet<String>();
        HashSet<String> orgUnitIds = new HashSet<String>();
        HashSet<String> bgIndexNums = new HashSet<String>();
        HashSet<String> bgPeriodNums = new HashSet<String>();
        HashSet<String> elementNums = new HashSet<String>();
        HashSet<String> scenNums = new HashSet<String>();
        HashSet<String> versionNums = new HashSet<String>();
        HashSet<String> currencyNums = new HashSet<String>();
        queryData.put("BGSCHEME_ID", bgSchemeIds);
        queryData.put("ORGUNIT_ID", orgUnitIds);
        queryData.put(DimensionBaseConstants.DEF_BGINDEX_FIELD, bgIndexNums);
        queryData.put(DimensionBaseConstants.DEF_PERIOD_FIELD, bgPeriodNums);
        queryData.put(DimensionBaseConstants.DEF_ELEMENT_FIELD, elementNums);
        queryData.put(DimensionBaseConstants.DEF_SCENARIO_FIELD, scenNums);
        queryData.put(DimensionBaseConstants.DEF_VERSION_FIELD, versionNums);
        queryData.put(DimensionBaseConstants.DEF_CURRENCY_FIELD, currencyNums);
        for (Map<String, Map<String, List<BgExamineDataCheckResult>>> orgCheckMap2 : subSetCheckResultMap.values()) {
            for (Map.Entry<String, Map<String, List<BgExamineDataCheckResult>>> entry2 : orgCheckMap2.entrySet()) {
                examineId = entry2.getKey();
                examCheckMap = entry2.getValue();
                if (!postilMap.containsKey(examineId)) continue;
                examine = (BgExamineInfo)postilMap.get(examineId);
                for (List<BgExamineDataCheckResult> results2 : examCheckMap.values()) {
                    int in2 = results2.size();
                    for (int i = 0; i < in2; ++i) {
                        checkResult = results2.get(i);
                        int jn = checkResult.getResult().size();
                        for (int j = 0; j < jn; ++j) {
                            for (BizCalcObj calcObj2 : checkResult.getResult().get(j)) {
                                processSet.add(calcObj2.getBgProceeType());
                                bgSchemeIds.add(result.bgSchemeMap.get(calcObj2.schemeNum)[2]);
                                orgUnitIds.add(result.orgUnitMap.get(calcObj2.orgUnitNum)[2]);
                                if (calcObj2.express == null || !calcObj2.express.contains("ACCT")) {
                                    dimNumber = calcObj2.getDimNums().get(DimensionBaseConstants.DEF_BGINDEX_FIELD);
                                    tmpStr = dimNumber.split(":");
                                    if (tmpStr != null && tmpStr.length > 1) {
                                        bgIndexNums.add(tmpStr[1]);
                                    } else {
                                        bgIndexNums.add(dimNumber);
                                    }
                                }
                                bgPeriodNums.add(calcObj2.getDimNums().get(DimensionBaseConstants.DEF_PERIOD_FIELD));
                                elementNums.add(calcObj2.getDimNums().get(DimensionBaseConstants.DEF_ELEMENT_FIELD));
                                scenNums.add(calcObj2.getDimNums().get(DimensionBaseConstants.DEF_SCENARIO_FIELD));
                                currencyNums.add(calcObj2.getDimNums().get(DimensionBaseConstants.DEF_CURRENCY_FIELD));
                                versionNums.add(calcObj2.versionNum);
                            }
                        }
                    }
                }
            }
        }
        Map[] postilsMap = this.getPostilsMap(ctx, queryData, processSet);
        if (postilsMap.length == 0) {
            return;
        }
        boolean check = false;
        for (Map<String, Map<String, List<BgExamineDataCheckResult>>> orgCheckMap2 : subSetCheckResultMap.values()) {
            for (Map.Entry<String, Map<String, List<BgExamineDataCheckResult>>> entry2 : orgCheckMap2.entrySet()) {
                examineId = entry2.getKey();
                examCheckMap = entry2.getValue();
                if (!postilMap.containsKey(examineId)) continue;
                examine = (BgExamineInfo)postilMap.get(examineId);
                check = this.checkPostil(postilsMap, examCheckMap, result);
                if (!check || !result.errors.contains(examine)) continue;
                result.errors.remove(examine);
            }
        }
    }

    protected Map[] getPostilsMap(Context ctx, Map<String, Set<String>> queryData, Set<String> processSet) throws EASBizException, BOSException {
        Map[] postilsMap = new Map[4];
        if (processSet.contains(BgProcessEnum.C01.getName())) {
            postilsMap[0] = BgCommentFactory.getLocalInstance(ctx).queryBgComments(queryData, BgProcessEnum.C01);
        }
        if (processSet.contains(BgProcessEnum.C02.getName())) {
            postilsMap[1] = BgCommentFactory.getLocalInstance(ctx).queryBgComments(queryData, BgProcessEnum.C02);
        }
        if (processSet.contains(BgProcessEnum.C03.getName())) {
            postilsMap[2] = BgCommentFactory.getLocalInstance(ctx).queryBgComments(queryData, BgProcessEnum.C03);
        }
        if (processSet.contains(BgProcessEnum.C04.getName())) {
            postilsMap[3] = BgCommentFactory.getLocalInstance(ctx).queryBgComments(queryData, BgProcessEnum.C04);
        }
        return postilsMap;
    }

    protected boolean checkPostil(Map[] postilsMap, Map<String, List<BgExamineDataCheckResult>> examCheckMap, BgExamineResult result) {
        if (postilsMap.length == 0 || examCheckMap == null || result == null) {
            return false;
        }
        List<BgExamineDataCheckResult> results2 = null;
        BgExamineDataCheckResult checkResult = null;
        BizCalcObj[] calcObjs = null;
        boolean hasPostil = false;
        boolean re = false;
        boolean examineResult = true;
        for (List<BgExamineDataCheckResult> results2 : examCheckMap.values()) {
            int in = results2.size();
            for (int i = 0; i < in; ++i) {
                checkResult = results2.get(i);
                hasPostil = false;
                int jn = checkResult.getResult().size();
                for (int j = 0; j < jn; ++j) {
                    calcObjs = checkResult.getResult().get(j);
                    re = this.checkPostil(postilsMap, calcObjs, result.bgSchemeMap, result.orgUnitMap);
                    if (!re) continue;
                    hasPostil = true;
                }
                checkResult.hasPostial = hasPostil;
                if (hasPostil) continue;
                examineResult = false;
            }
        }
        return examineResult;
    }

    protected boolean checkPostil(Map[] postilsMap, BizCalcObj[] calcObjs, Map<String, String[]> schemeMap, Map<String, String[]> orgUnitMap) {
        if (postilsMap.length == 0 || calcObjs == null || schemeMap == null || orgUnitMap == null) {
            return false;
        }
        String bgSchemeId = null;
        String orgUnitId = null;
        BizCalcObj calcObj2 = null;
        Map orgPostil = null;
        Map postilMap = null;
        Map postils = null;
        boolean check = false;
        for (BizCalcObj calcObj2 : calcObjs) {
            postils = postilsMap[BgProcessEnum.getEnum(calcObj2.getBgProceeType()).getValue() - 1];
            if (postils == null || postils.isEmpty()) continue;
            bgSchemeId = schemeMap.get(calcObj2.schemeNum)[2];
            orgUnitId = orgUnitMap.get(calcObj2.orgUnitNum)[2];
            if (!postils.containsKey(bgSchemeId) || !(orgPostil = (Map)postils.get(bgSchemeId)).containsKey(orgUnitId) || !(postilMap = (Map)orgPostil.get(orgUnitId)).containsKey(calcObj2.getDimDataKey())) continue;
            calcObj2.postils = ((List)postilMap.get(calcObj2.getDimDataKey())).toArray();
        }
        for (BizCalcObj calcObj2 : calcObjs) {
            if (calcObj2.postils == null) continue;
            check = true;
            break;
        }
        return check;
    }

    @Override
    protected List<String> _canExamineByAdjustBill(Context ctx, List bgAdjustBillIds) throws BOSException, EASBizException {
        ArrayList<String> examineIds = new ArrayList<String>();
        if (ctx == null || bgAdjustBillIds == null || bgAdjustBillIds.isEmpty()) {
            return examineIds;
        }
        List<String> _examineIds = null;
        List<BgExamineInfo> examines = null;
        List<IExpress> expres = null;
        IExpress expr = null;
        List<BgAdjustBillInfo> bgAdjusts = null;
        Map<String, List<Map<String, String>>> schemaDataMap = null;
        Map.Entry<String, List<Map<String, String>>> entry2 = null;
        List<Map<String, String>> mbgDatas = null;
        Map<String, Set<String>> pMbgDataMap = null;
        MbgDimCollection mbgDims = null;
        Map<String, MbgDimInfo> fieldDimMap = null;
        Map<String, String> srcFieldMap = null;
        Map<String, String> variateMap = null;
        String schemeNum = null;
        BgSchemeInfo schemeInfo = null;
        BgExamineSubsetInfo subsetInfo = null;
        Connection conn = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            conn = this.getConnection(ctx);
            bgAdjusts = MbgDataHelper.getBgAdjustBill(conn, ctx.getLocale(), bgAdjustBillIds);
            schemaDataMap = MBgExamineUtils.queryBgAdjustMemberMap(conn, bgAdjusts);
            mbgDims = DimUtils.getDimensionColls(conn, ctx.getLocale());
            fieldDimMap = DimUtils.getDimInfoByField(mbgDims);
            srcFieldMap = DimUtils.getSrcFieldMap(mbgDims);
            for (Map.Entry<String, List<Map<String, String>>> entry2 : schemaDataMap.entrySet()) {
                schemeNum = entry2.getKey();
                mbgDatas = entry2.getValue();
                schemeInfo = MbgDataHelper.getBgSchemeByNumber(conn, ctx.getLocale(), schemeNum);
                variateMap = BgVariateUtils.queryVariate(conn, schemeInfo.getId());
                pMbgDataMap = MBgExamineUtils.getParentMemberMap(conn, schemeInfo, mbgDatas, fieldDimMap);
                _examineIds = MBgExamineUtils.queryAllExamine(conn, schemeInfo.getId().toString(), null);
                if (_examineIds == null || _examineIds.isEmpty()) continue;
                examines = MBgExamineUtils.queryExamine(ctx, conn, pool, _examineIds, null);
                for (BgExamineInfo examine : examines) {
                    for (int index = 0; index < examine.getBgExamineSubset().size(); ++index) {
                        subsetInfo = examine.getBgExamineSubset().get(index);
                        expres = subsetInfo.getExpres();
                        if (expres == null) continue;
                        int jn = expres.size();
                        for (int j = 0; j < jn; ++j) {
                            expr = expres.get(j);
                            BgVariateUtils.checkVarMember(expr, variateMap);
                            try {
                                if (!MBgExamineUtils.checkExpr(expr, pMbgDataMap, srcFieldMap) || !MBgExamineUtils.checkScope(ctx, subsetInfo, mbgDims, schemeInfo, null, pMbgDataMap, variateMap)) continue;
                                examineIds.add(examine.getId().toString());
                                continue;
                            }
                            catch (Exception ex) {
                                logger.error((Object)"examine Check Error:", (Throwable)ex);
                            }
                        }
                    }
                }
            }
        }
        catch (ParseException ex) {
            logger.error((Object)"examine parse error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return examineIds;
    }

    @Override
    protected Object _examinesByAdjustBill(Context ctx, List bgAdjustBillIds, List examineIds) throws BOSException, EASBizException {
        BgExamineResult result = new BgExamineResult();
        if (ctx == null || bgAdjustBillIds == null || examineIds == null || bgAdjustBillIds.isEmpty() || examineIds.isEmpty()) {
            return result;
        }
        List<BgAdjustBillInfo> bgAdjusts = null;
        List<BgExamineInfo> examines = null;
        List<String> _examineIds = null;
        Map<String, Map<String, Map<String, Set<String>>>> adjustSchemeMap = null;
        Map<String, Map<String, Set<String>>> adjustOrgMap = null;
        Map<String, Set<String>> adjustDataMap = null;
        MbgDimCollection mbgDims = null;
        Map<String, MbgDimInfo> fieldDimMap = null;
        Map<String, String> srcFieldMap = null;
        Map<String, String> variateMap = null;
        HashMap<String, Set> schemeOrgMap = new HashMap<String, Set>();
        Map<String, List<Map<String, String>>> schemaDataMap = null;
        List<Map<String, String>> mbgDatas = null;
        Map<String, Set<String>> pMbgDataMap = null;
        Map<String, Set<String>> scopeMap = null;
        Set orgNumSet = null;
        Map.Entry<String, Map<String, Map<String, Set<String>>>> entry2 = null;
        List<IExpress> expres = null;
        IExpress expr = null;
        HashMap schQueryMap = new HashMap();
        Map orgQueryMap = null;
        ArrayList<ExprDimQuery> querys = null;
        List calcObjs = null;
        ExprDimQuery query = null;
        MbgExamCalcObj calcObj = null;
        HashMap examCalcObjs = new HashMap();
        String schemeNum = null;
        String orgUnitNum2 = null;
        Object periodStandardNumber = null;
        BgSchemeInfo schemeInfo = null;
        OrgUnitInfo orgUnit = null;
        BgExamineInfo examine = null;
        HashMap<String, OrgUnitInfo> orgUnitMap = new HashMap<String, OrgUnitInfo>();
        HashMap<String, OrgUnitInfo> orgUnitNumMap = new HashMap<String, OrgUnitInfo>();
        HashMap<String, BgSchemeInfo> schemeMap = new HashMap<String, BgSchemeInfo>();
        HashMap<String, BgExamineInfo> examineMap = new HashMap<String, BgExamineInfo>();
        Map dimNumberMap = new HashMap();
        HashMap schemeDataMap = new HashMap();
        Object orgDataMap = null;
        Object mbgDataMap = null;
        Object bgData = null;
        Object calcData = null;
        Map[] CMPDataMap = new Map[4];
        Connection conn = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            conn = this.getConnection(ctx);
            mbgDims = DimUtils.getDimensionColls(conn, ctx.getLocale());
            fieldDimMap = DimUtils.getDimInfoByField(mbgDims);
            srcFieldMap = DimUtils.getSrcFieldMap(mbgDims);
            result.examines = MBgExamineUtils.queryExamine(ctx, conn, pool, examineIds, null);
            int in = result.examines.size();
            for (int i = 0; i < in; ++i) {
                examine = result.examines.get(i);
                examineMap.put(examine.getId().toString(), examine);
            }
            dimNumberMap = this.queryAllDimMember(ctx);
            this.schemeInfo = MbgDataHelper.getBgSchemeByForm(conn, ctx.getLocale(), BOSUuid.read((String)((String)bgAdjustBillIds.get(0))));
            if (this.schemeInfo == null) {
                throw new MbgExamineCheckException(MbgExamineCheckException.SCHEMEERROR);
            }
            bgAdjusts = MbgDataHelper.getBgAdjustBill(conn, ctx.getLocale(), bgAdjustBillIds);
            schemaDataMap = MBgExamineUtils.queryBgAdjustMemberMap(conn, bgAdjusts);
            adjustSchemeMap = MBgExamineUtils.parseAdjustBillDimData(bgAdjusts);
            if (!bgAdjusts.isEmpty() && bgAdjusts.get(0) instanceof BgAdjustBillInfo && DimensionCommonHelper.isDecompose(bgAdjusts.get(0).getProcessType())) {
                result.dataType = bgAdjusts.get(0).getDataType();
            }
            Set<String> bgPeriodNums = this.getBgPeriodNumsByAdjust(bgAdjusts);
            MBgPeriodVariable variable = new MBgPeriodVariable(ctx.getLocale());
            Map allPeriodMap = BizPtoUtils.queryBgPeriodInfo((Connection)conn);
            for (Map.Entry<String, Map<String, Map<String, Set<String>>>> entry2 : adjustSchemeMap.entrySet()) {
                schemeNum = entry2.getKey();
                adjustOrgMap = entry2.getValue();
                if (schemeMap.containsKey(schemeNum)) {
                    schemeInfo = (BgSchemeInfo)schemeMap.get(schemeNum);
                } else {
                    schemeInfo = MbgDataHelper.getBgSchemeByNumber(conn, ctx.getLocale(), schemeNum);
                    schemeMap.put(schemeNum, schemeInfo);
                }
                variateMap = BgVariateUtils.queryVariate(conn, schemeInfo.getId());
                mbgDatas = schemaDataMap.get(schemeNum);
                pMbgDataMap = MBgExamineUtils.getParentMemberMap(conn, schemeInfo, mbgDatas, fieldDimMap);
                if (schQueryMap.containsKey(schemeNum)) {
                    orgQueryMap = (Map)schQueryMap.get(schemeNum);
                } else {
                    orgQueryMap = new HashMap();
                    schQueryMap.put(schemeNum, orgQueryMap);
                }
                if ((_examineIds = MBgExamineUtils.queryAllExamine(conn, schemeInfo.getId().toString(), null)).isEmpty()) continue;
                _examineIds.retainAll(examineIds);
                examines = MBgExamineUtils.queryExamine(ctx, conn, pool, _examineIds, examineMap);
                Map.Entry<String, Map<String, Set<String>>> oEntry2 = null;
                for (Map.Entry<String, Map<String, Set<String>>> oEntry2 : adjustOrgMap.entrySet()) {
                    orgUnitNum2 = oEntry2.getKey();
                    adjustDataMap = oEntry2.getValue();
                    Set<String> periodNums = adjustDataMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD);
                    MBgPeriodVariable periodVariable = new MBgPeriodVariable(ctx.getLocale());
                    periodVariable.transPeirodVariale(ctx, examines, periodNums, null);
                    if (orgUnitNumMap.containsKey(orgUnitNum2)) {
                        orgUnit = (OrgUnitInfo)orgUnitNumMap.get(orgUnitNum2);
                    } else {
                        orgUnit = MbgDataHelper.getOrgUnitByNumber(conn, ctx.getLocale(), orgUnitNum2);
                        orgUnitNumMap.put(orgUnitNum2, orgUnit);
                        orgUnitMap.put(orgUnit.getId().toString(), orgUnit);
                        result.orgUnitMap.put(orgUnit.getNumber(), new String[]{orgUnit.getNumber(), orgUnit.getName(), orgUnit.getId().toString()});
                    }
                    if (orgQueryMap.containsKey(orgUnitNum2)) {
                        querys = (List)orgQueryMap.get(orgUnitNum2);
                    } else {
                        querys = new ArrayList();
                        orgQueryMap.put(orgUnitNum2, querys);
                    }
                    BgExamineSubsetInfo subsetInfo = null;
                    int in2 = examines.size();
                    for (int i = 0; i < in2; ++i) {
                        examine = examines.get(i);
                        calcObjs = examCalcObjs.containsKey(examine.getId()) ? (List)examCalcObjs.get(examine.getId()) : new ArrayList();
                        examCalcObjs.put(examine.getId(), calcObjs);
                        for (int index = 0; index < examine.getBgExamineSubset().size(); ++index) {
                            subsetInfo = examine.getBgExamineSubset().get(index);
                            scopeMap = subsetInfo.getScopeData(ctx, schemeInfo, schemeInfo.getEditOrgViewId(), null, mbgDims, variateMap);
                            if (scopeMap.containsKey(DimensionBaseConstants.DEF_ORGUNIT_FIELD) && !(orgNumSet = scopeMap.get(DimensionBaseConstants.DEF_ORGUNIT_FIELD)).contains(orgUnit.getNumber())) continue;
                            expres = subsetInfo.getExpres();
                            HashSet<String> scopePeriods = new HashSet<String>();
                            if (scopeMap != null && scopeMap.containsKey(DimensionConstants.DEF_PERIOD_FIELD)) {
                                scopePeriods.addAll((Collection)scopeMap.get(DimensionConstants.DEF_PERIOD_FIELD));
                            }
                            HashMap<String, Map<String, Set<String>>> pFormDataMap = new HashMap<String, Map<String, Set<String>>>();
                            pFormDataMap.put(examine.getId().toString(), pMbgDataMap);
                            expres = this.processPtoExpress(conn, subsetInfo, expres, allPeriodMap, pFormDataMap, scopePeriods, new HashMap<String, String>());
                            if (expres == null) continue;
                            int jn = expres.size();
                            for (int j = 0; j < jn; ++j) {
                                expr = expres.get(j);
                                BgVariateUtils.checkVarMember(expr, variateMap);
                                try {
                                    if (!MBgExamineUtils.checkExpr(expr, pMbgDataMap, srcFieldMap) || !MBgExamineUtils.checkScope(ctx, subsetInfo, mbgDims, schemeInfo, null, pMbgDataMap, variateMap)) continue;
                                    this.mergeOrgParent(MBgExamineUtils.getOrgParentNumbers(conn, expr, schemeInfo.getNumber(), orgUnit.getNumber()));
                                    query = this.getDimQuery(schemeInfo.getNumber(), orgUnit.getNumber(), expr, scopeMap, null, adjustDataMap, srcFieldMap, this.orgParentMap, dimNumberMap);
                                    if (query != null) {
                                        query.examineId = examine.getId().toString();
                                        querys.add(query);
                                        MBgExamineUtils.queryCache(ctx, schemeInfo, fieldDimMap, query, result);
                                        Map.Entry<String, Set<String>> sEntry2 = null;
                                        for (Map.Entry<String, Set<String>> sEntry2 : query.schemeMap.entrySet()) {
                                            if (schemeOrgMap.containsKey(sEntry2.getKey())) {
                                                orgNumSet = (Set)schemeOrgMap.get(sEntry2.getKey());
                                            } else {
                                                orgNumSet = new HashSet<String>();
                                                schemeOrgMap.put(sEntry2.getKey(), orgNumSet);
                                            }
                                            if (orgNumSet == null) continue;
                                            orgNumSet.addAll((Collection)sEntry2.getValue());
                                        }
                                        MBgExamineUtils.checkFunctionMember(expr, schemeInfo.getNumber(), orgUnit.getNumber(), query, null, adjustDataMap);
                                    }
                                    calcObj = new MbgExamCalcObj();
                                    calcObj.subSetInfo = subsetInfo;
                                    calcObj.mbgExamine = examine;
                                    calcObj.expr = expr;
                                    calcObj.query = query;
                                    calcObj.parse();
                                    calcObjs.add(calcObj);
                                    continue;
                                }
                                catch (Exception ex) {
                                    logger.error((Object)"examine Check Error:", (Throwable)ex);
                                }
                            }
                        }
                    }
                }
            }
            if (!schemeOrgMap.isEmpty()) {
                BgVersionCollection _bgVerColls;
                int i;
                int in3;
                BgScenarioCollection _bgScenColls;
                IDimensionParameter parameter = null;
                HashMap<String, IObjectValue> scenaioMap = new HashMap<String, IObjectValue>();
                HashMap<String, IObjectValue> versionMap = new HashMap<String, IObjectValue>();
                BgScenarioInfo _scenario = null;
                BgVersionInfo _version = null;
                HashMap<String, String> scInnNumMap = new HashMap<String, String>();
                HashMap<String, String> scNumInnMap = new HashMap<String, String>();
                HashMap<String, String> verInnNumMap = new HashMap<String, String>();
                HashMap<String, String> verNumInnMap = new HashMap<String, String>();
                IBgDimensionFacade facade = BgDimensionFacadeFactory.getLocalInstance(ctx);
                if ((scInnNumMap.isEmpty() || scNumInnMap.isEmpty() || scenaioMap.isEmpty()) && (_bgScenColls = BgScenarioHelper.getScenarioColls((Connection)conn, (Locale)ctx.getLocale())) != null) {
                    in3 = _bgScenColls.size();
                    for (i = 0; i < in3; ++i) {
                        _scenario = _bgScenColls.get(i);
                        scInnNumMap.put(String.valueOf(_scenario.getScenarioId()), _scenario.getNumber());
                        scNumInnMap.put(_scenario.getNumber(), String.valueOf(_scenario.getScenarioId()));
                        scenaioMap.put(_scenario.getNumber(), (IObjectValue)_scenario);
                    }
                }
                if ((verInnNumMap.isEmpty() || verNumInnMap.isEmpty() || versionMap.isEmpty()) && (_bgVerColls = BgVersionHelper.getVersionColls((Connection)conn, (Locale)ctx.getLocale())) != null) {
                    in3 = _bgVerColls.size();
                    for (i = 0; i < in3; ++i) {
                        _version = _bgVerColls.get(i);
                        verInnNumMap.put(String.valueOf(_version.getVersionId()), _version.getNumber());
                        verNumInnMap.put(_version.getNumber(), String.valueOf(_version.getVersionId()));
                        versionMap.put(_version.getNumber(), (IObjectValue)_version);
                    }
                }
                BOSUuid[] bgTemplateIds = MBgExamineUtils.queryRefBgTemplateIds(conn, examineIds);
                Map.Entry sEntry3 = null;
                for (Map.Entry sEntry3 : schemeOrgMap.entrySet()) {
                    schemeNum = (String)sEntry3.getKey();
                    orgNumSet = (Set)sEntry3.getValue();
                    if (schemeMap.containsKey(schemeNum)) {
                        schemeInfo = (BgSchemeInfo)schemeMap.get(schemeNum);
                    } else {
                        schemeInfo = MbgDataHelper.getBgSchemeByNumber(conn, ctx.getLocale(), schemeNum);
                        schemeMap.put(schemeNum, schemeInfo);
                    }
                    result.bgSchemeMap.put(schemeInfo.getNumber(), new String[]{schemeInfo.getNumber(), schemeInfo.getName(), schemeInfo.getId().toString()});
                    this.queryDefaultExtDimMap(conn, schemeInfo);
                    orgQueryMap = (Map)schQueryMap.get(schemeNum);
                    if (orgQueryMap == null) continue;
                    for (String orgUnitNum2 : orgNumSet) {
                        Map<String, Map<String, Map<String, ICalcData>>> schemaTmpData;
                        BizCalcExpreUtils utils;
                        int index;
                        if (orgUnitNumMap.containsKey(orgUnitNum2)) {
                            orgUnit = (OrgUnitInfo)orgUnitNumMap.get(orgUnitNum2);
                        } else {
                            orgUnit = MbgDataHelper.getOrgUnitByNumber(conn, ctx.getLocale(), orgUnitNum2);
                            orgUnitMap.put(orgUnit.getId().toString(), orgUnit);
                            orgUnitNumMap.put(orgUnit.getNumber(), orgUnit);
                            result.orgUnitMap.put(orgUnit.getNumber(), new String[]{orgUnit.getNumber(), orgUnit.getName(), orgUnit.getId().toString()});
                        }
                        if ((querys = (List)orgQueryMap.get(orgUnitNum2)) == null || (parameter = this.transDimensionParameter(ctx, conn, schemeInfo, orgUnit, querys, null, null, adjustDataMap, fieldDimMap, scenaioMap, versionMap)) == null) continue;
                        if (DimensionCommonHelper.isDecompose(result.dataType)) {
                            parameter.setValueType(result.dataType);
                        }
                        parameter.setBgTemplateId(bgTemplateIds);
                        parameter.getControlManager().setAdjust(true);
                        parameter.getDataManager().setDimensions(mbgDims);
                        parameter.getDataManager().getInnNumMap().put(DimensionConstants.DEF_SCENARIO_FIELD, scInnNumMap);
                        parameter.getDataManager().getNumInnMap().put(DimensionConstants.DEF_SCENARIO_FIELD, scNumInnMap);
                        parameter.getDataManager().getInnNumMap().put(DimensionConstants.DEF_VERSION_FIELD, verInnNumMap);
                        parameter.getDataManager().getNumInnMap().put(DimensionConstants.DEF_VERSION_FIELD, verNumInnMap);
                        parameter.setPeriodStandardNumber(bgPeriodNums);
                        Object cmpObj = null;
                        IDimensionParameter[] parameters = this.getCMPParameter(ctx, parameter, querys, new HashSet<String>());
                        if (parameters == null) {
                            cmpObj = facade.dimensionQuery(parameter);
                            index = 0;
                            if (parameter.getValueType() == 256) {
                                index = 1;
                            } else if (parameter.getValueType() == 512) {
                                index = 2;
                            } else if (parameter.getValueType() == 1024) {
                                index = 3;
                            }
                            CMPDataMap[index] = this.getSchemeDataMap(cmpObj, schemeNum, orgUnitMap, parameter, scenaioMap, scNumInnMap, verNumInnMap, CMPDataMap[index]);
                            int in4 = parameter.getQuerys().size();
                            for (int i2 = 0; i2 < in4; ++i2) {
                                MBgExamineUtils.queryCache(ctx, schemeInfo, fieldDimMap, parameter.getQuerys().get(i2).getMbgDimMap().values(), result);
                            }
                            utils = new BizCalcExpreUtils(ctx, conn, parameter);
                            utils.calcs(querys);
                            utils.setExamCalcObjs(examCalcObjs);
                            schemaTmpData = MBgExamineUtils.queryAdjustBillValue(conn, adjustSchemeMap, index + 1);
                            MBgExamineUtils.mergeSchemeDimData(CMPDataMap[index], schemaTmpData);
                            continue;
                        }
                        for (index = 0; index < parameters.length; ++index) {
                            parameter = parameters[index];
                            if (parameter == null) continue;
                            cmpObj = facade.dimensionQuery(parameter);
                            CMPDataMap[index] = this.getSchemeDataMap(cmpObj, schemeNum, orgUnitMap, parameter, scenaioMap, scNumInnMap, verNumInnMap, CMPDataMap[index]);
                            int in5 = parameter.getQuerys().size();
                            for (int i3 = 0; i3 < in5; ++i3) {
                                MBgExamineUtils.queryCache(ctx, schemeInfo, fieldDimMap, parameter.getQuerys().get(i3).getMbgDimMap().values(), result);
                            }
                            utils = new BizCalcExpreUtils(ctx, conn, parameter);
                            utils.calcs(querys);
                            utils.setExamCalcObjs(examCalcObjs);
                            schemaTmpData = MBgExamineUtils.queryAdjustBillValue(conn, adjustSchemeMap, index + 1);
                            MBgExamineUtils.mergeSchemeDimData(CMPDataMap[index], schemaTmpData);
                        }
                    }
                }
            }
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("js");
            SimpleScriptContext context = new SimpleScriptContext();
            List<BgExamineDataCheckResult> checkResult = null;
            Map.Entry<String, Map<String, Map<String, Set<String>>>> qsEntry2 = null;
            Map.Entry<String, Map<String, Set<String>>> qoEntry2 = null;
            for (Map.Entry<String, Map<String, Map<String, Set<String>>>> qsEntry2 : adjustSchemeMap.entrySet()) {
                schemeNum = qsEntry2.getKey();
                adjustOrgMap = qsEntry2.getValue();
                schemeInfo = (BgSchemeInfo)schemeMap.get(schemeNum);
                for (Map.Entry<String, Map<String, Set<String>>> qoEntry2 : adjustOrgMap.entrySet()) {
                    orgUnitNum2 = qoEntry2.getKey();
                    adjustDataMap = qoEntry2.getValue();
                    orgUnit = (OrgUnitInfo)orgUnitNumMap.get(orgUnitNum2);
                    BgExamineSubsetInfo subsetInfo = null;
                    int xn = result.examines.size();
                    for (int x = 0; x < xn; ++x) {
                        examine = result.examines.get(x);
                        for (int index = 0; index < examine.getBgExamineSubset().size(); ++index) {
                            subsetInfo = examine.getBgExamineSubset().get(index);
                            scopeMap = subsetInfo.getScopeData(ctx, schemeInfo, schemeInfo.getEditOrgViewId(), null, mbgDims, variateMap);
                            if (scopeMap.containsKey(DimensionBaseConstants.DEF_ORGUNIT_FIELD) && !(orgNumSet = scopeMap.get(DimensionBaseConstants.DEF_ORGUNIT_FIELD)).contains(orgUnit.getNumber()) || !examCalcObjs.containsKey(examine.getId())) continue;
                            calcObjs = (ArrayList)examCalcObjs.get(examine.getId());
                            int jn = bgAdjusts.size();
                            for (int j = 0; j < jn; ++j) {
                                String processType = bgAdjusts.get(j).getProcessType().getName();
                                int yn = calcObjs.size();
                                for (int y = 0; y < yn; ++y) {
                                    calcObj = (MbgExamCalcObj)calcObjs.get(y);
                                    if (calcObj == null || (checkResult = calcObj.check(ctx, engine, context, mbgDims, schemeInfo, null, orgUnit, adjustDataMap, CMPDataMap, srcFieldMap, this.orgParentMap, processType, this.defultMap, this.fieldMap)) == null || checkResult.isEmpty()) continue;
                                    MBgExamineUtils.queryCache(ctx, schemeInfo, checkResult, fieldDimMap, srcFieldMap, result);
                                    if (calcObj.subSetInfo != null && subsetInfo.getId().equals((Object)calcObj.subSetInfo.getId())) {
                                        result.addSubsetCheckResult(orgUnit.getNumber(), subsetInfo.getId().toString(), calcObj, checkResult);
                                    }
                                    if (3 == examine.getNoPass().getValue() || result.errors.contains(examine)) continue;
                                    result.errors.add(examine);
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (ParseException ex) {
            logger.error((Object)"examine parse error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        catch (Exception ex) {
            logger.error((Object)"examine parse error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        this.checkPostil(ctx, result);
        this.checkBgExamineResult(result);
        this.saveBgExamineResult(ctx, bgAdjustBillIds, result);
        return result;
    }

    private void mergeOrgParent(Map<String, Map<String, String>> mp) {
        if (!mp.isEmpty()) {
            String schemeNumber2 = null;
            for (String schemeNumber2 : mp.keySet()) {
                if (!this.orgParentMap.containsKey(schemeNumber2)) {
                    this.orgParentMap.put(schemeNumber2, new HashMap());
                }
                this.orgParentMap.get(schemeNumber2).putAll(mp.get(schemeNumber2));
            }
        }
    }

    protected Set<String> getCMPNumber(List<ExprDimQuery> querys, Set<String> processTypes) {
        HashSet<String> numbers = new HashSet<String>();
        if (!processTypes.isEmpty()) {
            Iterator<String> ite = processTypes.iterator();
            while (ite.hasNext()) {
                numbers.add(DimensionConstants.DEF_PROCESS_SRCNUMBER + ":" + ite.next());
            }
        }
        if (querys == null || querys.isEmpty()) {
            return numbers;
        }
        Map<String, Map<String, Map<String, Set<String>>>> dimNumMap = null;
        for (int i = 0; i < querys.size(); ++i) {
            dimNumMap = querys.get((int)i).dimNumMap;
            if (dimNumMap == null || dimNumMap.isEmpty()) continue;
            for (String schemeNumber : dimNumMap.keySet()) {
                Map<String, Map<String, Set<String>>> orgMap = dimNumMap.get(schemeNumber);
                for (String orgNumber : orgMap.keySet()) {
                    Map<String, Set<String>> tmpMap = orgMap.get(orgNumber);
                    if (!tmpMap.containsKey(DimensionConstants.DEF_PROCESS_FIELD)) continue;
                    numbers.addAll((Collection<String>)tmpMap.get(DimensionConstants.DEF_PROCESS_FIELD));
                }
            }
        }
        return numbers;
    }

    protected IDimensionParameter[] getCMPParameter(Context ctx, IDimensionParameter parameter, List<ExprDimQuery> querys, Set<String> processTypes) {
        Set<String> cmps = this.getCMPNumber(querys, processTypes);
        if (cmps.isEmpty()) {
            return null;
        }
        IDimensionParameter[] parameters = new IDimensionParameter[4];
        IDimensionParameter cloneParameter = null;
        if (cmps.contains(DimensionConstants.DEF_PROCESS_SRCNUMBER + ":" + BgProcessEnum.C01.getName())) {
            cloneParameter = parameter.getClone(ctx);
            cloneParameter.setValueType(1);
            cloneParameter.getDimensionMap().putAll(parameter.getDimensionMap());
            parameters[0] = cloneParameter;
        }
        if (cmps.contains(DimensionConstants.DEF_PROCESS_SRCNUMBER + ":" + BgProcessEnum.C02.getName())) {
            cloneParameter = parameter.getClone(ctx);
            cloneParameter.setValueType(256);
            cloneParameter.getDimensionMap().putAll(parameter.getDimensionMap());
            parameters[1] = cloneParameter;
        }
        if (cmps.contains(DimensionConstants.DEF_PROCESS_SRCNUMBER + ":" + BgProcessEnum.C03.getName())) {
            cloneParameter = parameter.getClone(ctx);
            cloneParameter.setValueType(512);
            cloneParameter.getDimensionMap().putAll(parameter.getDimensionMap());
            parameters[2] = cloneParameter;
        }
        if (cmps.contains(DimensionConstants.DEF_PROCESS_SRCNUMBER + ":" + BgProcessEnum.C04.getName())) {
            cloneParameter = parameter.getClone(ctx);
            cloneParameter.setValueType(1024);
            cloneParameter.getDimensionMap().putAll(parameter.getDimensionMap());
            parameters[3] = cloneParameter;
        }
        return parameters;
    }

    protected Map<String, Map<String, Map<String, ICalcData>>> getSchemeDataMap(Object obj, String schemeNumber, Map<String, OrgUnitInfo> orgUnitMap, IDimensionParameter parameter, Map<String, IObjectValue> scenaioMap, Map<String, String> scNumInnMap, Map<String, String> verNumInnMap, Map<String, Map<String, Map<String, ICalcData>>> schemeDataMap) {
        if (schemeDataMap == null) {
            schemeDataMap = new HashMap<String, Map<String, Map<String, ICalcData>>>();
        }
        Map<Object, Object> orgDataMap = null;
        Map mbgDataMap = null;
        if (obj instanceof Map) {
            Map tmpMap = (Map)obj;
            if (schemeDataMap.containsKey(schemeNumber)) {
                orgDataMap = schemeDataMap.get(schemeNumber);
            } else {
                orgDataMap = new HashMap();
                schemeDataMap.put(schemeNumber, orgDataMap);
            }
            ICalcData calcData = null;
            BgNDataInfo bgData = null;
            String orgUnitId = null;
            String orgUnitNumber = null;
            Map.Entry _entry2 = null;
            Map.Entry dEntry2 = null;
            for (Map.Entry _entry2 : tmpMap.entrySet()) {
                orgUnitId = (String)_entry2.getKey();
                if (!orgUnitMap.containsKey(orgUnitId)) continue;
                orgUnitNumber = orgUnitMap.get(orgUnitId).getNumber();
                if (orgDataMap.containsKey(orgUnitNumber)) {
                    mbgDataMap = (Map)orgDataMap.get(orgUnitNumber);
                } else {
                    mbgDataMap = new HashMap();
                    orgDataMap.put(orgUnitNumber, mbgDataMap);
                }
                Map tmpDataMap = (Map)_entry2.getValue();
                for (Map.Entry dEntry2 : tmpDataMap.entrySet()) {
                    bgData = (BgNDataInfo)dEntry2.getValue();
                    calcData = this.transMbgData(bgData, scenaioMap, scNumInnMap, verNumInnMap, parameter.getValueType());
                    mbgDataMap.put(dEntry2.getKey(), calcData);
                }
            }
        }
        return schemeDataMap;
    }

    public List<IExpress> processPtoExpress(Connection conn, BgExamineSubsetInfo subsetInfo, List<IExpress> expres, Map<String, List<String>> allPeriodMap, Map<String, Map<String, Set<String>>> formDataMap, Set<String> scopePeriods, Map<String, String> expresMap) {
        List newExpres = expres;
        if (expres.toString().indexOf("PTO") >= 0) {
            try {
                List<String> refPeriods = new ArrayList();
                for (String formId : formDataMap.keySet()) {
                    Map<String, Set<String>> tmpMap = formDataMap.get(formId);
                    for (String field : tmpMap.keySet()) {
                        Set<String> numbers = tmpMap.get(field);
                        if (!field.equals(DimensionConstants.DEF_PERIOD_FIELD)) continue;
                        for (String s : numbers) {
                            if (refPeriods.contains(s)) continue;
                            refPeriods.add(s);
                        }
                    }
                }
                if (!scopePeriods.isEmpty()) {
                    refPeriods.retainAll(scopePeriods);
                }
                refPeriods = BizPtoUtils.sortRefPeriods((Connection)conn, refPeriods);
                subsetInfo.put(BizPtoUtils.REF_PERIODS, refPeriods);
                newExpres = BizPtoUtils.transPtoExpress(expres, refPeriods, allPeriodMap);
                if (expresMap != null && !expresMap.isEmpty()) {
                    int i;
                    HashMap tmpMap = new HashMap();
                    for (i = 0; i < expres.size(); ++i) {
                        tmpMap.put(((IExpress)expres.get(i)).getOriginalExpr(), expres.get(i));
                    }
                    for (i = 0; i < newExpres.size(); ++i) {
                        if (!tmpMap.containsKey(((IExpress)newExpres.get(i)).getOriginalExpr()) || !expresMap.containsKey(((IExpress)tmpMap.get(((IExpress)newExpres.get(i)).getOriginalExpr())).toPlanString())) continue;
                        expresMap.put(((IExpress)newExpres.get(i)).toPlanString(), expresMap.get(((IExpress)tmpMap.get(((IExpress)newExpres.get(i)).getOriginalExpr())).toPlanString()));
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"BgExamineFacadeControllerBean transPtoExpress error : ", (Throwable)e);
            }
        }
        return newExpres;
    }

    public class ExprDimQuery {
        public String examineId = null;
        public Map<String, Set<String>> scopeNumMap = new HashMap<String, Set<String>>();
        public Map<String, Map<String, Map<String, Set<String>>>> dimNumMap = new HashMap<String, Map<String, Map<String, Set<String>>>>();
        public boolean hasRight = false;
        public Map<String, Map<String, Map<String, Set<String>>>> rdimNumMap = new HashMap<String, Map<String, Map<String, Set<String>>>>();
        public Set<String> offPeriodSet = null;
        public Map<String, Set<String>> schemeMap = new HashMap<String, Set<String>>();
        public MdxMemberExpr expr = null;
        public Map<String, FormulaExpr> formulaMaps = new HashMap<String, FormulaExpr>();
        public Map<String, Set<String>> exprDataMap = new HashMap<String, Set<String>>();
        public Map<String, Map<String, List<Object[]>>> calcObjs = new HashMap<String, Map<String, List<Object[]>>>();
        public Map<String, Set<String>> fieldSet = new HashMap<String, Set<String>>();
    }
}

