/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.mbg.BgFinalizedBgOrgUnitNodeCollection;
import com.kingdee.eas.ma.mbg.BgFinalizedBgOrgUnitNodeInfo;
import com.kingdee.eas.ma.mbg.BgFinalizedInfo;
import com.kingdee.eas.ma.mbg.BgFinalizedSelectOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.AbstractBgFinalizedControllerBean;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgFinalizedControllerBean
extends AbstractBgFinalizedControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgFinalizedControllerBean");

    protected BgFinalizedInfo _getNewInstance(Context ctx, String bgSchemeId, Set orgNumbers, String bgPeriodNumber, String bgVersionNumber) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgSchemeId) || orgNumbers == null || orgNumbers.isEmpty() || StringUtils.isEmpty((String)bgVersionNumber) || StringUtils.isEmpty((String)bgPeriodNumber)) {
            return null;
        }
        BgFinalizedInfo info = new BgFinalizedInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        Locale locale = ctx.getLocale();
        HashSet<String> orgIdSet = new HashSet<String>();
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgSchemeInfo bgSchemeInfo = BgViewServerHelper.getBgSchemeInfo(locale, conn, BOSUuid.read((String)bgSchemeId));
            info.setBgScheme(bgSchemeInfo);
            BOSUuid bgOrgViewId = bgSchemeInfo.getEditOrgViewId();
            BgVersionInfo bgVersionInfo = BgVersionHelper.getVersion((Context)ctx, (String)bgVersionNumber);
            info.setBgVersion(bgVersionInfo);
            BgPeriodInfo bgPeriodInfo = BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodInfo("where number = '" + bgPeriodNumber + "'");
            info.setBgPeriod(bgPeriodInfo);
            BgFinalizedBgOrgUnitNodeCollection colls = new BgFinalizedBgOrgUnitNodeCollection();
            List<BgOrgUnitInfo> bgOrgUnits = MbgDataHelper.getBgOrgUnitsByNumber(ctx, conn, locale, bgOrgViewId, false, orgNumbers);
            if (bgOrgUnits != null && !bgOrgUnits.isEmpty()) {
                Collections.sort(bgOrgUnits, new Comparator<BgOrgUnitInfo>(){

                    @Override
                    public int compare(BgOrgUnitInfo o1, BgOrgUnitInfo o2) {
                        return o1.getLongNumber().compareTo(o2.getLongNumber());
                    }
                });
                BgOrgUnitInfo bgOrgUnitInfo = null;
                for (int i = 0; i < bgOrgUnits.size(); ++i) {
                    bgOrgUnitInfo = bgOrgUnits.get(i);
                    info.getSelectOrgUnits().add(this.getFinalizedSelectOrg(info, bgOrgUnitInfo));
                    if (orgIdSet.contains(bgOrgUnitInfo.getOrgUnitID())) continue;
                    List<BgOrgUnitInfo> bgOrgUnitChildren = MbgDataHelper.getBgOrgUnitChildren(ctx, conn, locale, bgOrgUnitInfo, null, false);
                    orgIdSet.add(bgOrgUnitInfo.getOrgUnitID());
                    colls.add(this.getFinalizedOrgUnit(ctx, info, bgOrgUnitInfo));
                    if (bgOrgUnitChildren == null || bgOrgUnitChildren.isEmpty()) continue;
                    for (BgOrgUnitInfo org : bgOrgUnitChildren) {
                        orgIdSet.add(org.getOrgUnitID());
                        colls.add(this.getFinalizedOrgUnit(ctx, info, org));
                    }
                }
                if (!colls.isEmpty()) {
                    info.getBgOrgUnits().addObjectCollection((IObjectCollection)colls);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)" ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return info;
    }

    protected BgFinalizedBgOrgUnitNodeInfo getFinalizedOrgUnit(Context ctx, BgFinalizedInfo bgFinalizedInfo, BgOrgUnitInfo bgOrgUnitInfo) {
        BgFinalizedBgOrgUnitNodeInfo orgNodeInfo = new BgFinalizedBgOrgUnitNodeInfo();
        orgNodeInfo.setId(BOSUuid.create((BOSObjectType)orgNodeInfo.getBOSType()));
        orgNodeInfo.setBgFinalized(bgFinalizedInfo);
        orgNodeInfo.setBgOrgUnit(bgOrgUnitInfo);
        orgNodeInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        orgNodeInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        orgNodeInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        orgNodeInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        return orgNodeInfo;
    }

    protected BgFinalizedSelectOrgUnitInfo getFinalizedSelectOrg(BgFinalizedInfo bgFinalizedInfo, BgOrgUnitInfo bgOrgUnitInfo) {
        BgFinalizedSelectOrgUnitInfo selectOrg = new BgFinalizedSelectOrgUnitInfo();
        selectOrg.setId(BOSUuid.create((BOSObjectType)selectOrg.getBOSType()));
        selectOrg.setBgFinalized(bgFinalizedInfo);
        selectOrg.setBgOrgUnit(bgOrgUnitInfo);
        return selectOrg;
    }
}

