/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgRefDimMemberEnum;
import com.kingdee.eas.ma.mbg.BgFormFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.IBgFormFacade;
import com.kingdee.eas.ma.mbg.app.AbstractBgFormEntryControllerBean;
import com.kingdee.eas.ma.mbg.app.utils.BgFacadeHelper;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgFormEntryControllerBean
extends AbstractBgFormEntryControllerBean {
    private static final long serialVersionUID = 379554784983996777L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgFormEntryControllerBean");

    @Override
    protected void _saveStyle(Context ctx, String bgViewId, IBgDimensionManager bgDimensionManager) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgViewId) || bgDimensionManager == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BgViewHelper.writeStyle(bos, bgDimensionManager);
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_MBg_BgFormEntry set FDimensionStyle = ? where FBgFormId = ?");
            pstmt.setBytes(1, bos.toByteArray());
            pstmt.setString(2, bgViewId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _saveStyle(Context ctx, String bgViewId, IMbgViewManager mbgViewManager) throws BOSException {
        if (StringUtils.isEmpty((String)bgViewId) || mbgViewManager == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            new MbgXMLParser(ctx);
            byte[] viewdata = MbgXMLParser.unParseStyle(mbgViewManager);
            if (viewdata != null) {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement("update T_MBg_BgFormEntry set FDimensionStyle = ? where FBgFormId = ?");
                pstmt.setBytes(1, viewdata);
                pstmt.setString(2, bgViewId);
                pstmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(pstmt, conn);
        }
    }

    @Override
    protected void _saveDimensionData(Context ctx, String bgViewId, Map mbgViewManagers) throws BOSException, EASBizException {
        Map _mbgViewManagers;
        Map.Entry entry2;
        if (StringUtils.isEmpty((String)bgViewId) || mbgViewManagers == null) {
            return;
        }
        IBgForm ibgForm = BgFormFactory.getLocalInstance(ctx);
        IBgFormFacade ibgFormFacade = BgFormFacadeFactory.getLocalInstance(ctx);
        BgFormInfo formInfo = (BgFormInfo)ibgForm.getValue((IObjectPK)new ObjectUuidPK(bgViewId), this.getSel());
        Map resultMap = ibgFormFacade.queryBgFormByOrgUnitId(formInfo, new ArrayList(mbgViewManagers.keySet()).toArray());
        BgFormInfo bgForm = null;
        byte[] viewData = null;
        HashMap<String, byte[]> dataMap = new HashMap<String, byte[]>();
        if (formInfo.getBgTemplate().getFormType().getValue() == 2) {
            entry2 = null;
            _mbgViewManagers = mbgViewManagers;
            for (Map.Entry entry2 : _mbgViewManagers.entrySet()) {
                if (!resultMap.containsKey(entry2.getKey()) || (viewData = new MbgViewListXMLParser(ctx).unParse((MbgViewListManager)entry2.getValue())) == null) continue;
                bgForm = (BgFormInfo)resultMap.get(entry2.getKey());
                dataMap.put(bgForm.getId().toString(), viewData);
                BgFacadeHelper.saveViewRef(ctx, bgForm.getBgScheme().getId().toString(), bgForm.getId().toString(), bgForm.getOrgUnit().getId().toString(), BgRefDimMemberEnum.BgForm, (IMbgViewBase)entry2.getValue(), true);
            }
        } else if (formInfo.getBgTemplate().getFormType().getValue() == 4) {
            entry2 = null;
            _mbgViewManagers = mbgViewManagers;
            for (Map.Entry entry2 : _mbgViewManagers.entrySet()) {
                if (!resultMap.containsKey(entry2.getKey())) continue;
                new MbgXMLParser(ctx);
                viewData = MbgXMLParser.unParse((IMbgViewManager)entry2.getValue());
                if (viewData == null) continue;
                bgForm = (BgFormInfo)resultMap.get(entry2.getKey());
                dataMap.put(bgForm.getId().toString(), viewData);
                BgFacadeHelper.saveViewRef(ctx, bgForm.getBgScheme().getId().toString(), bgForm.getId().toString(), bgForm.getOrgUnit().getId().toString(), BgRefDimMemberEnum.BgForm, (IMbgViewBase)entry2.getValue(), true);
            }
        }
        if (dataMap.size() > 0) {
            Connection conn = null;
            PreparedStatement pstmt = null;
            String sql = "update T_MBg_BgFormEntry set FDimensionData = ? where FBgFormId = ?";
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                Map.Entry entry12 = null;
                for (Map.Entry entry12 : dataMap.entrySet()) {
                    pstmt.setBytes(1, (byte[])entry12.getValue());
                    pstmt.setString(2, (String)entry12.getKey());
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
    }

    private SelectorItemCollection getSel() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bgTemplate.formType");
        sic.add("bgTemplate.root.id");
        sic.add("bgTemplate.id");
        sic.add("bgScheme.id");
        sic.add("orgUnit.id");
        sic.add("bgPeriod.id");
        sic.add("currency.id");
        sic.add("bgScenario.id");
        sic.add("bgScenario.scenarioId");
        sic.add("bgVersion.id");
        sic.add("bgVersion.versionId");
        sic.add("bgScheme.id");
        sic.add("state");
        sic.add("processType");
        return sic;
    }
}

