/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.IBgPeriod;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgParamNHelper;
import com.kingdee.eas.ma.mbg.BgAdjustException;
import com.kingdee.eas.ma.mbg.BgAdjustFacadaFactory;
import com.kingdee.eas.ma.mbg.BgAuditIdeaEnum;
import com.kingdee.eas.ma.mbg.BgAuditIdeaFactory;
import com.kingdee.eas.ma.mbg.BgAuditIdeaInfo;
import com.kingdee.eas.ma.mbg.BgCommonException;
import com.kingdee.eas.ma.mbg.BgCourseCommentFactory;
import com.kingdee.eas.ma.mbg.BgCourseCommentInfo;
import com.kingdee.eas.ma.mbg.BgCourseOperateEnum;
import com.kingdee.eas.ma.mbg.BgDataStateEnum;
import com.kingdee.eas.ma.mbg.BgFinalizedFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormAuditFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormDataSourceEnum;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgNFormFacadeFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgRollException;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.IBgAuditIdea;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.RollRuleInfo;
import com.kingdee.eas.ma.mbg.RollTemplateCollection;
import com.kingdee.eas.ma.mbg.RollTemplateFactory;
import com.kingdee.eas.ma.mbg.VerifyFormParam;
import com.kingdee.eas.ma.mbg.app.AbstractBgFormFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.utils.BgFacadeHelper;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.utils.BgDataSynStateBizHelper;
import com.kingdee.eas.ma.mbg.utils.BgFormHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNSHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.MBgCheckHelper;
import com.kingdee.eas.ma.mbg.utils.data.BizDataControlUtils;
import com.kingdee.eas.ma.mbg.utils.data.BizDataOtherCheckUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BgFormFacadeControllerBean
extends AbstractBgFormFacadeControllerBean {
    private static final long serialVersionUID = 3846265171853190347L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgFormFacadeControllerBean");

    @Override
    protected boolean _submitForm(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        return this._auditFormApproving(ctx, id, null);
    }

    @Override
    protected boolean _submitFormWork(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        ArrayList<String> billIds = new ArrayList<String>();
        billIds.add(id.toString());
        new BizDataOtherCheckUtils().beforeCheck(ctx, billIds, -1);
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _submitRollWork(Context ctx, IObjectValue editData) throws BOSException, EASBizException {
        IObjectPK beginLog;
        if (editData == null || editData.get(editData.getPKField()) == null) {
            return false;
        }
        boolean re = false;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            String id = editData.getString("id");
            pstmt = conn.prepareStatement("select FID from T_MBg_BgForm where FID=? ");
            pstmt.setString(1, id.toString());
            rst = pstmt.executeQuery();
            if (!rst.next()) {
                throw new BgFormException(BgFormException.NOBGFORMINFO);
            }
            BgFormInfo bgFormInfo = BgViewServerHelper.getBgFormInfo(conn, BOSUuid.read((String)id), false);
            String logName = bgFormInfo.getNumber() + " " + bgFormInfo.getName();
            beginLog = LogUtil.beginLog((Context)ctx, (String)"writerLogin", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"mbg_rollForm_submit");
            if (bgFormInfo.getState().getValue() == 12 && !BgFormHelper.checkInProInst(ctx, id)) {
                re = true;
            } else {
                if (bgFormInfo.getState().getValue() != 6) {
                    throw new BgRollException(BgRollException.SUBMITWORKERROR);
                }
                re = true;
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"Error: ", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        LogUtil.afterLog((Context)ctx, (IObjectPK)beginLog);
        return re;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _submitAdjustWork(Context ctx, IObjectValue editData) throws BOSException, EASBizException {
        IObjectPK beginLog;
        if (editData == null || editData.get(editData.getPKField()) == null) {
            return false;
        }
        boolean re = false;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            String id = editData.getString("id");
            pstmt = conn.prepareStatement("select FID from T_MBg_BgForm where FID=? ");
            pstmt.setString(1, id.toString());
            rst = pstmt.executeQuery();
            if (!rst.next()) {
                throw new BgFormException(BgFormException.NOBGFORMINFO);
            }
            BgFormInfo bgFormInfo = BgViewServerHelper.getBgFormInfo(conn, BOSUuid.read((String)id), false);
            String logName = bgFormInfo.getNumber() + " " + bgFormInfo.getName();
            beginLog = LogUtil.beginLog((Context)ctx, (String)"writerLogin", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"mbg_rollForm_submit");
            if (bgFormInfo.getState().getValue() != 4 && bgFormInfo.getState().getValue() != 35 && bgFormInfo.getState().getValue() != 6 && bgFormInfo.getState().getValue() != 101) {
                throw new BgAdjustException(BgAdjustException.SUBMITWORKERROR);
            }
            re = true;
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"Error: ", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        LogUtil.afterLog((Context)ctx, (IObjectPK)beginLog);
        return re;
    }

    @Override
    protected boolean _auditRollForm(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        BgAdjustFacadaFactory.getLocalInstance(ctx).audit(id.toString());
        return true;
    }

    @Override
    protected boolean _auditFormAdjust(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        List list = BgFormFactory.getLocalInstance(ctx).adjustCheck(id);
        if (null != list && !list.isEmpty()) {
            throw new BgAdjustException(BgAdjustException.CHECKADJUSTNOPASS);
        }
        BgAdjustFacadaFactory.getLocalInstance(ctx).audit(id.toString());
        return true;
    }

    @Override
    protected boolean _auditForm(Context ctx, BOSUuid id, BOSUuid auditorId, String idea) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        boolean re = this.workFlowProcess(ctx, id, auditorId, BgDataStateEnum.Approved, BgFormStateEnum.Approved, 0, true, idea);
        return re;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _auditForm(Context ctx, BOSUuid id, BOSUuid auditorId) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pst = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer update = new StringBuffer();
        sql.append("select FID from T_MBg_BgForm where FID=?");
        update.append("update T_MBg_BgForm set FData=?, FState=?, FAuditorID=?, FAuditedTime=?, FStateBeforeAudit = ? where FID=?");
        BgFormInfo bgFormInfo = null;
        Book book = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, id.toString());
            rst = pstmt.executeQuery();
            if (!rst.next()) throw new BgFormException(BgFormException.NOBGFORMINFO);
            bgFormInfo = BgViewServerHelper.getBgFormInfo(conn, id, true);
            book = bgFormInfo.getBook();
            BgNFSHelper.updateAliasAudit(book);
            bgFormInfo.setBook(book);
            pst = conn.prepareStatement(update.toString());
            pst.setBytes(1, bgFormInfo.getZipData());
            pst.setInt(2, 2);
            if (auditorId != null) {
                pst.setString(3, auditorId.toString());
            } else {
                pst.setString(3, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            }
            Timestamp _timestamp = new Timestamp(System.currentTimeMillis());
            pst.setTimestamp(4, _timestamp);
            pst.setInt(5, bgFormInfo.getState().getValue());
            pst.setString(6, id.toString());
            int sum = -1;
            sum = pst.executeUpdate();
            if (sum > 0) {
                BgDataSynStateBizHelper.updateDataStateByFormID(ctx, id.toString(), true, "OPERATOR_APPROVED");
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"Error: ", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
                catch (Exception ex3) {
                    throw new BOSException((Throwable)ex3);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst);
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pst);
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _unAuditForm(Context ctx, BOSUuid id, BgAuditIdeaEnum type, BOSUuid auditorId, String message) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        if (type != null && 4 == type.getValue()) {
            this._submitAuditIdea(ctx, id, auditorId, type == null ? BgAuditIdeaEnum.UNAUDIT : type, message);
            return true;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pst = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer update = new StringBuffer();
        sql.append("select FID, FStateBeforeAudit,FORGUNITID from T_MBg_BgForm where FID=?");
        update.append("update T_MBg_BgForm set FState=? where FID=?");
        int stateBeforeAudit = -1;
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        boolean isAntiAuditToFormerState = BgNSHelper.isAntiAuditToFormerState(ctx);
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, id.toString());
            rst = pstmt.executeQuery();
            if (!rst.next()) throw new BgFormException(BgFormException.NOBGFORMINFO);
            stateBeforeAudit = rst.getInt(2);
            String orgId = rst.getString("FORGUNITID");
            pst = conn.prepareStatement(update.toString());
            if (isAntiAuditToFormerState) {
                if (stateBeforeAudit == 41) {
                    pst.setInt(1, 41);
                } else {
                    pst.setInt(1, 1);
                }
            } else {
                pst.setInt(1, 1);
            }
            pst.setInt(1, 1);
            pst.setString(2, id.toString());
            int sum = -1;
            sum = pst.executeUpdate();
            BizDataControlUtils utils = new BizDataControlUtils(ctx);
            utils.recoverAudOrgUnit(id, BOSUuid.read((String)orgId), auditorId, 1, 1, false, message, null);
            this._submitAuditIdea(ctx, id, auditorId, type == null ? BgAuditIdeaEnum.UNAUDIT : type, message);
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"Error: ", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
                catch (Exception ex3) {
                    throw new BOSException((Throwable)ex3);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst);
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pst);
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return true;
    }

    @Override
    protected boolean _auditCancelForm(Context ctx, BOSUuid id, BOSUuid auditorId, String idea) throws BOSException, EASBizException {
        this.workFlowProcess(ctx, id, auditorId, BgDataStateEnum.Edited, BgFormStateEnum.Edited, 11, false, idea);
        IMutexServiceControl iMC = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        iMC.releaseObjIDForUpdate(id.toString());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _unAuditRollForm(Context ctx, BOSUuid id, BOSUuid auditorId, String idea) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IBgForm iBgForm = null;
        BgFormInfo info = null;
        iBgForm = BgFormFactory.getLocalInstance(ctx);
        if (iBgForm == null) {
            return false;
        }
        info = (BgFormInfo)iBgForm.getValue("select state,lastUpdateTime,lastUpdateUser.id where id = '" + pk + "'");
        Timestamp lastUpdateTime = info.getLastUpdateTime();
        String lastUpdateUserID = info.getLastUpdateUser().getId().toString();
        if (info == null) {
            return false;
        }
        if (!info.getState().equals((Object)BgFormStateEnum.RollApproving)) {
            return false;
        }
        info.setState(BgFormStateEnum.RollEdited);
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgFormFactory.getLocalInstance(ctx).update((IObjectPK)pk, (CoreBaseInfo)info);
            try {
                BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBg_bgForm set FLastUpdateTime=?,FLastUpdateUserID =? where fid =?", (Object[])new Object[]{lastUpdateTime, lastUpdateUserID, info.getId().toString()});
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return true;
    }

    private void clearCtrlRecord(Context ctx, BOSUuid id) throws BOSException, BgFormException {
    }

    protected boolean submitAntiAudit4StepByStepReport(Context ctx, BOSUuid bgFormId, BOSUuid auditorId, String msg) throws BOSException, EASBizException {
        if (bgFormId == null) {
            return false;
        }
        String _userId = null;
        _userId = auditorId == null ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : auditorId.toString();
        IMutexServiceControl iMC = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        if (!iMC.requestObjIDForUpdate(bgFormId.toString(), _userId)) {
            throw new BgCommonException(BgCommonException.LOCK);
        }
        iMC.releaseObjIDForUpdate(bgFormId.toString());
        BgFormInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)bgFormId, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("state");
        sic.add("bgType.id");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.root.id");
        sic.add("bgScheme.id");
        view.setSelector(sic);
        info = BgFormFactory.getLocalInstance(ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId), sic);
        if (info.getBgTemplate().getId().equals((Object)info.getBgTemplate().getRootId())) {
            return this.gatherCourseAntiAudit(ctx, info, auditorId, msg);
        }
        return this.singleAntiAudit(ctx, bgFormId, auditorId, msg);
    }

    private boolean singleAntiAudit(Context ctx, BOSUuid bgFormId, BOSUuid auditorId, String msg) throws BOSException, EASBizException {
        if (bgFormId == null) {
            return false;
        }
        String _userId = null;
        _userId = auditorId == null ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : auditorId.toString();
        Timestamp _timestamp = new Timestamp(System.currentTimeMillis());
        this.clearCtrlRecord(ctx, bgFormId);
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pst = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer update = new StringBuffer();
        sql.append("select FID from T_MBg_BgForm where FID = ?");
        update.append("update T_MBg_BgForm set FState=?, FAuditorID=?, FAuditedTime=?, FLastUpdateUserId = ?, FLastUpdateTime = ? where FID=?");
        BgFormInfo bgFormInfo = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgFormId.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                bgFormInfo = BgViewServerHelper.getBgFormInfo(conn, bgFormId, false);
                pst = conn.prepareStatement(update.toString());
                if (BgNFSHelper.checkHasAdjust((IObjectValue)bgFormInfo)) {
                    pst.setInt(1, 4);
                } else {
                    pst.setInt(1, 1);
                }
                pst.setString(2, "");
                pst.setTimestamp(3, null);
                pst.setString(4, _userId);
                pst.setTimestamp(5, _timestamp);
                pst.setString(6, bgFormId.toString());
                int sum = -1;
                sum = pst.executeUpdate();
                if (sum > 0) {
                    BgDataSynStateBizHelper.updateDataStateByFormID(ctx, bgFormId.toString(), false, "OPERATOT_UNAPPROVED");
                }
            } else {
                throw new BgFormException(BgFormException.NOBGFORMINFO);
            }
            this._submitAuditIdea(ctx, bgFormId, auditorId, BgAuditIdeaEnum.UNAUDIT, msg);
            pst = conn.prepareStatement("update T_MBg_BgData set FBizActual = 0 where " + BgViewServerHelper.getBgDataFilterByBgFormId());
            pst.setString(1, bgFormId.toString());
            pst.executeUpdate();
            SQLUtils.cleanup((Statement)pst);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"Error: ", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst);
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pst);
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return true;
    }

    private boolean gatherCourseAntiAudit(Context ctx, BgFormInfo info, BOSUuid auditorId, String msg) throws BOSException, EASBizException {
        if (info == null) {
            return false;
        }
        String _userId = null;
        _userId = auditorId == null ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : auditorId.toString();
        Timestamp _timestamp = new Timestamp(System.currentTimeMillis());
        ArrayList<String> bgFormIds = new ArrayList<String>();
        bgFormIds.add(info.getId().toString());
        List gatherCourseFormIds = this.findGatherFormIds(ctx, bgFormIds, 2);
        if (gatherCourseFormIds.isEmpty()) {
            return true;
        }
        String bgFormId = null;
        Object number = null;
        ArrayList notPassBgForms = new ArrayList();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int batchSize = 50;
        int size = gatherCourseFormIds.size();
        int count = (size - 1) / batchSize + 1;
        boolean pos = false;
        StringBuffer sql3 = new StringBuffer();
        sql3.append("update T_MBg_BgForm set FState=?, FAuditorID=?, FAuditedTime=?, FLastUpdateUserId = ?, FLastUpdateTime = ? where FID=?");
        try {
            conn = this.getConnection(ctx);
            if (!notPassBgForms.isEmpty()) {
                StringBuffer sb = new StringBuffer();
                for (int x = 0; x < notPassBgForms.size(); ++x) {
                    sb.append(notPassBgForms.get(x)).append(", ");
                }
                throw new BgFormException(BgFormException.SHOWEXCEPTION, new String[]{ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"27_BgFormFacadeControllerBean", (Locale)ctx.getLocale()) + sb.substring(0, sb.length() - 2)});
            }
            for (int i = 0; i < gatherCourseFormIds.size(); ++i) {
                bgFormId = (String)gatherCourseFormIds.get(i);
                pstmt = conn.prepareStatement(sql3.toString());
                if (bgFormId.equals(info.getId().toString())) {
                    pstmt.setInt(1, 1);
                } else {
                    pstmt.setInt(1, 40);
                }
                pstmt.setString(2, "");
                pstmt.setTimestamp(3, null);
                pstmt.setString(4, _userId);
                pstmt.setTimestamp(5, _timestamp);
                pstmt.setString(6, bgFormId);
                int sum = -1;
                sum = pstmt.executeUpdate();
                if (sum > 0) {
                    BgDataSynStateBizHelper.updateDataStateByFormID(ctx, info.getId().toString(), false, "OPERATOT_UNAPPROVED");
                }
                this._submitAuditIdea(ctx, BOSUuid.read((String)bgFormId), auditorId, BgAuditIdeaEnum.UNAUDIT, msg);
                pstmt = conn.prepareStatement("update T_MBg_BgData set FBizActual = 0 where " + BgViewServerHelper.getBgDataFilterByBgFormId());
                pstmt.setString(1, bgFormId);
                pstmt.executeUpdate();
                SQLUtils.cleanup((Statement)pstmt);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        return true;
    }

    private List findGatherFormIds(Context ctx, List bgFormIds, int state) throws BOSException, EASBizException {
        ArrayList returnList = new ArrayList();
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return returnList;
        }
        for (int i = 0; i < bgFormIds.size(); ++i) {
            if (returnList.contains(bgFormIds.get(i))) continue;
            returnList.add(bgFormIds.get(i));
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int batchSize = 50;
        int size = bgFormIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select f.fid from T_MBg_bgForm f ");
        sql.append("join T_MBg_bgGatherInfo g on f.fid = g.fsubBgFormId ");
        sql.append("where f.fState = " + state);
        sql.append(" and g.fBgFormId in (");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        String bgFormId = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, bgFormIds.get(pos).toString());
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                ArrayList<String> tempList = new ArrayList<String>();
                while (rst.next()) {
                    bgFormId = rst.getString(1);
                    if (!returnList.contains(bgFormId)) {
                        returnList.add(bgFormId);
                    }
                    tempList.add(bgFormId);
                }
                if (!tempList.isEmpty()) {
                    List tempList2 = this.findGatherFormIds(ctx, tempList, state);
                    for (int i = 0; i < tempList2.size(); ++i) {
                        bgFormId = (String)tempList2.get(i);
                        if (returnList.contains(bgFormId)) continue;
                        returnList.add(bgFormId);
                    }
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return returnList;
    }

    @Override
    protected boolean _submitAntiAudit(Context ctx, BOSUuid bgFormId, BOSUuid auditorId, String msg) throws BOSException, EASBizException {
        if (bgFormId == null) {
            return false;
        }
        String _userId = null;
        _userId = auditorId == null ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : auditorId.toString();
        IMutexServiceControl iMC = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        if (!iMC.requestObjIDForUpdate(bgFormId.toString(), _userId)) {
            throw new BgCommonException(BgCommonException.LOCK);
        }
        Timestamp _timestamp = new Timestamp(System.currentTimeMillis());
        Connection conn = null;
        PreparedStatement pst = null;
        StringBuffer update = new StringBuffer();
        update.append("update T_MBg_BgForm set FState=?, FAuditorID=?, FAuditedTime=?, FLastUpdateUserId = ?, FLastUpdateTime = ? where FID=?");
        BgFormInfo bgFormInfo = null;
        boolean isAntiAuditToFormerState = false;
        BizDataControlUtils utils = new BizDataControlUtils(ctx);
        try {
            conn = this.getConnection(ctx);
            bgFormInfo = BgViewServerHelper.getBgFormInfo(conn, bgFormId, false);
            pst = conn.prepareStatement(update.toString());
            if (isAntiAuditToFormerState) {
                pst.setInt(1, 1);
            } else if (BgNFSHelper.checkHasAdjust((IObjectValue)bgFormInfo)) {
                pst.setInt(1, 4);
            } else {
                pst.setInt(1, 1);
            }
            pst.setString(2, "");
            pst.setTimestamp(3, null);
            pst.setString(4, _userId);
            pst.setTimestamp(5, _timestamp);
            pst.setString(6, bgFormId.toString());
            pst.executeUpdate();
            this._submitAuditIdea(ctx, bgFormId, auditorId, BgAuditIdeaEnum.UNAUDIT, msg);
            ArrayList<BgCourseCommentInfo> list = new ArrayList<BgCourseCommentInfo>();
            BgCourseCommentInfo comment = new BgCourseCommentInfo();
            comment.setBgFormId(bgFormId.toString());
            comment.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            comment.setState(BgCourseOperateEnum.UnConfirm);
            list.add(comment);
            BgCourseCommentFactory.getLocalInstance(ctx).batchAddnew(list);
            utils.recoverAudOrgUnit(bgFormId, bgFormInfo.getOrgUnit().getId(), auditorId, 1, 1, false, msg, null);
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"Error: ", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst, (Connection)conn);
                iMC.releaseObjIDForUpdate(bgFormId.toString());
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pst, (Connection)conn);
        iMC.releaseObjIDForUpdate(bgFormId.toString());
        return true;
    }

    @Override
    protected void _submitAuditIdea(Context ctx, BOSUuid id, BOSUuid auditorId, BgAuditIdeaEnum ideaState, String message) throws BOSException, EASBizException {
        if (id == null) {
            return;
        }
        IBgAuditIdea iBgAuditIdea = BgAuditIdeaFactory.getLocalInstance(ctx);
        if (iBgAuditIdea != null) {
            BgFormInfo bgFormInfo = new BgFormInfo();
            bgFormInfo.setId(id);
            BgAuditIdeaInfo bgAuditIdeaInfo = new BgAuditIdeaInfo();
            if (auditorId != null) {
                UserInfo userInfo = new UserInfo();
                userInfo.setId(auditorId);
                bgAuditIdeaInfo.setCreator(userInfo);
            } else {
                bgAuditIdeaInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            }
            bgAuditIdeaInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            bgAuditIdeaInfo.setIdea(message);
            bgAuditIdeaInfo.setFormId(bgFormInfo.getId());
            bgAuditIdeaInfo.setState(ideaState == null ? BgAuditIdeaEnum.AUDITPASS : ideaState);
            iBgAuditIdea.addnew((CoreBaseInfo)bgAuditIdeaInfo);
        }
    }

    @Override
    protected void _submitAuditIdea(Context ctx, BOSUuid id, BOSUuid auditorId, String message) throws BOSException, EASBizException {
        if (id == null) {
            return;
        }
        IBgAuditIdea iBgAuditIdea = BgAuditIdeaFactory.getLocalInstance(ctx);
        if (iBgAuditIdea != null) {
            BgFormInfo bgFormInfo = new BgFormInfo();
            bgFormInfo.setId(id);
            BgAuditIdeaInfo bgAuditIdeaInfo = new BgAuditIdeaInfo();
            if (auditorId != null) {
                UserInfo userInfo = new UserInfo();
                userInfo.setId(auditorId);
                bgAuditIdeaInfo.setCreator(userInfo);
            } else {
                bgAuditIdeaInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            }
            bgAuditIdeaInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            bgAuditIdeaInfo.setIdea(message);
            bgAuditIdeaInfo.setFormId(bgFormInfo.getId());
            IBgForm ibgform = BgFormFactory.getLocalInstance(ctx);
            BgFormInfo bgAdjustInfo = null;
            if (ibgform == null) {
                throw new BgFormException(BgFormException.NOINSTANCE);
            }
            ObjectUuidPK pk = new ObjectUuidPK(id);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("adjust.id");
            sic.add("state");
            if (ibgform.exists((IObjectPK)pk)) {
                bgAdjustInfo = ibgform.getBgFormInfo((IObjectPK)pk, sic);
            }
            if (bgAdjustInfo != null) {
                if (bgAdjustInfo.getId().toString().equals(bgAdjustInfo.getAdjust().getId().toString())) {
                    bgAuditIdeaInfo.setState(BgAuditIdeaEnum.AUDITPASS);
                } else {
                    bgAuditIdeaInfo.setState(BgFormStateEnum.RollEdited.equals((Object)bgAdjustInfo.getState()) ? BgAuditIdeaEnum.ROLLPASS : BgAuditIdeaEnum.ADJUSTPASS);
                    bgFormInfo.setId(bgAdjustInfo.getAdjust().getId());
                }
                iBgAuditIdea.addnew((CoreBaseInfo)bgAuditIdeaInfo);
            }
        }
    }

    private void updateTime(Context ctx, String id) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append("update T_MBg_bgForm set FLastUpdateTime=? where fid=?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            pstmt.setString(2, id.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _submitIdeaNoPass(Context ctx, BOSUuid bgFormId, BOSUuid auditorId, String msg) throws BOSException, EASBizException {
        IBgAuditIdea iBgAuditIdea;
        if (bgFormId == null) {
            return;
        }
        if (!StringUtils.isEmpty((String)msg) && msg.length() > 650) {
            msg = msg.substring(0, 650);
        }
        if ((iBgAuditIdea = BgAuditIdeaFactory.getLocalInstance(ctx)) != null) {
            BgFormInfo bgFormInfo = new BgFormInfo();
            bgFormInfo.setId(bgFormId);
            BgAuditIdeaInfo bgAuditIdeaInfo = new BgAuditIdeaInfo();
            if (auditorId != null) {
                UserInfo userInfo = new UserInfo();
                userInfo.setId(auditorId);
                bgAuditIdeaInfo.setCreator(userInfo);
            } else {
                bgAuditIdeaInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            }
            bgAuditIdeaInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            bgAuditIdeaInfo.setIdea(msg);
            bgAuditIdeaInfo.setFormId(bgFormInfo.getId());
            IBgForm ibgform = BgFormFactory.getLocalInstance(ctx);
            BgFormInfo bgAdjustInfo = null;
            if (ibgform == null) {
                throw new BgFormException(BgFormException.NOINSTANCE);
            }
            ObjectUuidPK pk = new ObjectUuidPK(bgFormId);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("adjust.id");
            if (ibgform.exists((IObjectPK)pk)) {
                bgAdjustInfo = ibgform.getBgFormInfo((IObjectPK)pk, sic);
            }
            if (bgAdjustInfo != null) {
                if (bgAdjustInfo.getId().toString().equals(bgAdjustInfo.getAdjust().getId().toString())) {
                    bgAuditIdeaInfo.setState(BgAuditIdeaEnum.AUDITNOPASS);
                } else {
                    bgAuditIdeaInfo.setState(BgAuditIdeaEnum.ADJUSTNOPASS);
                    bgFormInfo.setId(bgAdjustInfo.getAdjust().getId());
                }
                iBgAuditIdea.addnew((CoreBaseInfo)bgAuditIdeaInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _auditRollApproving(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IBgForm iBgForm = null;
        BgFormInfo info = null;
        iBgForm = BgFormFactory.getLocalInstance(ctx);
        if (iBgForm == null) {
            return false;
        }
        info = (BgFormInfo)iBgForm.getValue("select state,lastUpdateTime,lastUpdateUser.id where id = '" + pk + "'");
        Timestamp lastUpdateTime = info.getLastUpdateTime();
        String lastUpdateUserID = info.getLastUpdateUser().getId().toString();
        if (info == null) {
            return false;
        }
        if (!info.getState().equals((Object)BgFormStateEnum.RollEdited)) {
            return false;
        }
        info.setState(BgFormStateEnum.RollApproving);
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgFormFactory.getLocalInstance(ctx).update((IObjectPK)pk, (CoreBaseInfo)info);
            try {
                BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBg_bgForm set FLastUpdateTime=?,FLastUpdateUserID =? where fid =?", (Object[])new Object[]{lastUpdateTime, lastUpdateUserID, info.getId().toString()});
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _auditFormApproving(Context ctx, BOSUuid id, BOSUuid auditorId) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pst = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer update = new StringBuffer();
        sql.append("select FID from T_MBg_BgForm where FID=?");
        update.append("update T_MBg_BgForm set FState=?, FAuditorID=?, FAuditedTime=? where FID=?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, id.toString());
            rst = pstmt.executeQuery();
            int index = 0;
            if (!rst.next()) throw new BgFormException(BgFormException.NOBGFORMINFO);
            pst = conn.prepareStatement(update.toString());
            pst.setInt(1, 14);
            if (auditorId != null) {
                pst.setString(2, auditorId.toString());
            } else {
                pst.setString(2, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            }
            Timestamp time = new Timestamp(System.currentTimeMillis());
            pst.setTimestamp(3, time);
            pst.setString(4, id.toString());
            index = pst.executeUpdate();
            if (index > 0) {
                BgDataSynStateBizHelper.updateDataStateByFormID(ctx, id.toString(), true, "OPERATOT_APPROVING");
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"Error: ", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
                catch (Exception ex3) {
                    throw new BOSException((Throwable)ex3);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst);
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pst);
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return true;
    }

    @Override
    protected boolean _auditFormBasisApproved(Context ctx, BOSUuid bgFormId, BOSUuid auditorId, String message) throws BOSException, EASBizException {
        return bgFormId != null && auditorId != null;
    }

    @Override
    protected boolean _auditFormReferring(Context ctx, BOSUuid id, BOSUuid auditorId) throws BOSException, EASBizException {
        ctx.put((Object)"isAddAuditor", (Object)false);
        boolean result = this.workFlowProcess(ctx, id, auditorId, BgDataStateEnum.UnEditeable, BgFormStateEnum.REFERRING, 7, false, null);
        String sql = "update t_mbg_bgform set fstate = 25 where fid = '" + id.toString() + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        return result;
    }

    protected boolean workFlowProcess(Context ctx, BOSUuid id, BOSUuid auditorId, BgDataStateEnum dataState, BgFormStateEnum formState, int type, boolean isSynChild, String idea) throws BOSException {
        boolean re = false;
        if (id == null) {
            return re;
        }
        String _userId = null;
        _userId = auditorId == null ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : auditorId.toString();
        Connection conn = null;
        BgFormInfo bgFormInfo = null;
        ArrayList<String> billIds = new ArrayList<String>();
        billIds.add(id.toString());
        try {
            conn = this.getConnection(ctx);
            bgFormInfo = MbgDataHelper.getBgFormInfo(conn, ctx.getLocale(), id, true);
            if (bgFormInfo != null) {
                Map bgFormMap;
                HashMap<String, String> auditParams = new HashMap<String, String>();
                auditParams.put("AUDIT_SCHEME_ID", bgFormInfo.getBgScheme().getId().toString());
                if (ctx.get((Object)"isAddAuditor") == null || ((Boolean)ctx.get((Object)"isAddAuditor")).booleanValue()) {
                    auditParams.put("AUDIT_ORGUNIT_ID", bgFormInfo.getOrgUnit().getId().toString());
                }
                auditParams.put("AUDIT_USER_ID", _userId);
                auditParams.put("AUDIT_DATA_STATE", String.valueOf(dataState.getValue()));
                auditParams.put("AUDIT_BILL_STATE", String.valueOf(formState.getValue()));
                auditParams.put("AUDIT_PARAM", String.valueOf(type));
                auditParams.put("AUDIT_MESSAGE", idea);
                auditParams.put("AUDIT_SYN_CHILD", String.valueOf(isSynChild));
                auditParams.put("CHECK_MUTEX", String.valueOf(false));
                auditParams.put("CHECK_REPORT", String.valueOf(false));
                auditParams.put("CHECK_EXAMINE", String.valueOf(false));
                auditParams.put("CHECK_WORKFLOW", String.valueOf(false));
                if (BgFormStateEnum.Approved.equals((Object)formState)) {
                    auditParams.put("AUDIT_COURSE_COMMENT_STATE", BgCourseOperateEnum.Confirm.getName());
                }
                Map result = null;
                if (7 == type || 0 == type) {
                    result = BgFormAuditFacadeFactory.getLocalInstance(ctx).audit(billIds, auditParams);
                } else if (11 == type) {
                    result = BgFormAuditFacadeFactory.getLocalInstance(ctx).auditCancelForm(billIds, auditParams);
                }
                if (result != null && result.containsKey("CHECK_RESULT_SUCCEED") && (bgFormMap = (Map)result.get("CHECK_RESULT_SUCCEED")).containsKey(id.toString())) {
                    re = true;
                }
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return re;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IObjectPK _checkFormIsAdjust(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        Object pk;
        block17: {
            if (id == null) {
                throw new BgFormException(BgFormException.CHECKBLANK, new String[]{"id"});
            }
            pk = null;
            conn = null;
            pstmt = null;
            PreparedStatement pst = null;
            rst = null;
            ResultSet rs = null;
            StringBuffer search = new StringBuffer();
            search.append("select FID from T_MBg_BgForm where FID = ?");
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(search.toString());
                pstmt.setString(1, id.toString());
                rst = pstmt.executeQuery();
                if (!rst.next()) throw new BgFormException(BgFormException.NOBGFORMINFO);
                BgFormInfo bgFormInfo = BgViewServerHelper.getBgFormInfo(conn, id, false);
                if (bgFormInfo.getState().getValue() != 4 && bgFormInfo.getState().getValue() != 2) {
                    if (bgFormInfo.getState().getValue() != 35) throw new BgFormException(BgFormException.ISNOADJUSTORAUDITED);
                }
                String bgFormAdjustId = bgFormInfo.getAdjust().getId().toString();
                try {
                    pst = conn.prepareStatement("Select FID from T_MBg_BgForm where FState = ? AND FAdjustId = ?");
                    pst.setInt(1, 35);
                    pst.setString(2, bgFormAdjustId);
                    rs = pst.executeQuery();
                    pk = rs.next() ? new ObjectUuidPK(BOSUuid.read((String)rs.getString("FID"))) : null;
                }
                catch (SQLException ex) {
                    try {
                        logger.error((Object)"Error: ", (Throwable)ex);
                        throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, (Statement)pst);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)pst);
                if (pk != null) break block17;
                try {
                    pst = conn.prepareStatement("Select FID from T_MBg_BgForm where FState = ? AND FAdjustId = ?");
                    pst.setInt(1, 4);
                    pst.setString(2, bgFormAdjustId);
                    rs = pst.executeQuery();
                    pk = rs.next() ? new ObjectUuidPK(BOSUuid.read((String)rs.getString("FID"))) : null;
                }
                catch (SQLException ex) {
                    logger.error((Object)"Error: ", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rs, (Statement)pst);
                }
            }
            catch (BOSException ex) {
                try {
                    throw ex;
                    catch (EASBizException ex2) {
                        throw ex2;
                    }
                    catch (SQLException ex3) {
                        logger.error((Object)"Error: ", (Throwable)ex3);
                        throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex3.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return pk;
    }

    @Override
    protected boolean _checkIsSubmit(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        boolean re = false;
        Connection conn = null;
        BgFormInfo bgFormInfo = null;
        IBgForm ibgForm = BgFormFactory.getLocalInstance(ctx);
        if (ibgForm != null) {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            if (ibgForm.exists((IObjectPK)pk)) {
                int _state;
                try {
                    conn = this.getConnection(ctx);
                    bgFormInfo = BgViewServerHelper.getBgFormInfo(conn, id, false);
                }
                catch (BOSException ex) {
                    throw ex;
                }
                finally {
                    SQLUtils.cleanup((Connection)conn);
                }
                if (bgFormInfo != null && ((_state = bgFormInfo.getState().getValue()) == 1 || _state == 41 || _state == 4)) {
                    re = true;
                }
            } else {
                throw new BgFormException(BgFormException.NOBGFORMINFO);
            }
        }
        return re;
    }

    protected void processClearFormulaIsAdjust(Context ctx, BOSUuid id, List formulas) throws EASBizException, BOSException {
        if (id == null || formulas == null || formulas.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        BgFormInfo bgFormInfo = null;
        IBgForm ibgForm = null;
        ObjectUuidPK pk = null;
        try {
            conn = this.getConnection(ctx);
            ibgForm = BgFormFactory.getLocalInstance(ctx);
            if (ibgForm == null) {
                throw new BgFormException(BgFormException.NOINSTANCE);
            }
            pk = new ObjectUuidPK(id);
            if (!ibgForm.exists((IObjectPK)pk)) {
                return;
            }
            bgFormInfo = BgViewServerHelper.getBgFormInfo(conn, id, false);
            int index = 0;
            int batchNum = 50;
            int size = formulas.size();
            int count = (size - 1) / batchNum + 1;
            int pos = 0;
            String noFindStr = "#";
            StringBuffer sql = new StringBuffer(1024);
            sql.append("DELETE FROM T_MBg_BGDATA WHERE FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula IN (");
            for (index = 1; index < batchNum; ++index) {
                sql.append("?, ");
            }
            sql.append("?) AND FID in (Select FBgDataId From T_MBg_BgDataEntry Where FBgFormId = ?)");
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgFormInfo.getOrgUnit().getId().toString());
            pstmt.setString(2, bgFormInfo.getBgScheme().getId().toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k + 2, (String)formulas.get(pos));
                    } else {
                        pstmt.setString(k + 2, noFindStr);
                    }
                    ++k;
                    ++pos;
                }
                pstmt.setString(batchNum + 3, id.toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
        catch (SQLException ex) {
            logger.error((Object)"Error: ", (Throwable)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        catch (BOSException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        finally {
            SQLUtils.cleanup(pstmt, (Connection)conn);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String[] processCheckFormulaIsEctype(Context ctx, BgFormInfo bgFormInfo, List formulas) throws EASBizException, BOSException {
        boolean re;
        if (formulas == null) return null;
        if (formulas.isEmpty()) return null;
        if (bgFormInfo.getOrgUnit().getId() == null) return null;
        if (bgFormInfo.getBgScheme().getId() == null) {
            return null;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BgFormInfo bgInfo = null;
        int index = 0;
        int batchNum = 50;
        int size = formulas.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        String noFindStr = "#";
        String formulaString = null;
        String bgFormId = null;
        String[] formulaInfo = null;
        StringBuffer tmpsql = new StringBuffer(1024);
        tmpsql.append("Select TOP 1 FFormula, FBgFormId from T_MBg_BgTmpData where FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula in (");
        for (index = 1; index < batchNum; ++index) {
            tmpsql.append("?,");
        }
        tmpsql.append("?)");
        boolean bl = re = bgFormInfo.getState().getValue() == 4 && !bgFormInfo.getId().equals((Object)bgFormInfo.getAdjust().getId());
        if (re) {
            tmpsql.append(" and (FBgFormId <> ?)");
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(tmpsql.toString());
            for (index = 0; index < count; ++index) {
                pstmt.setString(1, bgFormInfo.getOrgUnit().getId().toString());
                pstmt.setString(2, bgFormInfo.getBgScheme().getId().toString());
                for (int k = 0; k < batchNum; ++k, ++pos) {
                    if (pos < size) {
                        pstmt.setString(k + 3, (String)formulas.get(pos));
                        continue;
                    }
                    pstmt.setString(k + 3, noFindStr);
                }
                if (re) {
                    pstmt.setString(batchNum + 3, bgFormInfo.getAdjust().getId().toString());
                }
                if ((rst = pstmt.executeQuery()).next()) {
                    formulaString = rst.getString(1);
                    bgFormId = rst.getString(2);
                    break;
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup(rst, (Statement)pstmt);
            if (formulaString != null && bgFormId != null) {
                bgInfo = BgViewServerHelper.getBgFormInfo(conn, BOSUuid.read(bgFormId), false);
                if (bgInfo == null) throw new BgFormException(BgFormException.NOBGFORMINFO);
                formulaInfo = new String[]{formulaString, bgInfo.getName()};
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"Error: ", (Throwable)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return formulaInfo;
    }

    protected Map compareBgItemInfo(Context ctx, List bgItemList, Map bgItemMap) {
        if (bgItemMap == null) {
            bgItemMap = new HashMap();
        }
        if (ctx == null || bgItemList == null || bgItemList.isEmpty()) {
            return bgItemMap;
        }
        return bgItemMap;
    }

    protected void batchProcessUpdateBgFormDataByte(Connection conn, Map dataMap) throws EASBizException {
        if (conn == null || dataMap == null || dataMap.isEmpty()) {
            return;
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("update T_MBg_BgForm set FData = ? where FID = ?");
            for (BOSUuid id : dataMap.keySet()) {
                byte[] data;
                if (id == null || (data = (byte[])dataMap.get(id)) == null || data.length == 0) continue;
                pstmt.setBytes(1, data);
                pstmt.setString(2, id.toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException ex) {
            logger.error((Object)"Error: ", (Throwable)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    protected void processUpdateBgFormDataByte(Connection conn, BOSUuid bgFormId, byte[] data) throws EASBizException {
        if (conn == null || bgFormId == null || data == null || data.length == 0) {
            return;
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("update T_MBg_BgForm set FData = ? where FID = ?");
            pstmt.setBytes(1, data);
            pstmt.setString(2, bgFormId.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            logger.error((Object)"Error: ", (Throwable)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public SelectorItemCollection getBgFormInfo() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("bgScheme.*"));
        sic.add(new SelectorItemInfo("bgTemplate.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.*"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.id"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.number"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.id"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.number"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.coefficient"));
        sic.add(new SelectorItemInfo("measureUnit.*"));
        sic.add(new SelectorItemInfo("state"));
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _auditCancelAdjustForm(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IBgForm iBgForm = null;
        BgFormInfo info = null;
        iBgForm = BgFormFactory.getLocalInstance(ctx);
        if (iBgForm == null) {
            return false;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bgPeriod.number");
        sic.add("bgRollPeriod.number");
        sic.add("state");
        sic.add("lastUpdateTime");
        sic.add("lastUpdateUser.id");
        info = (BgFormInfo)iBgForm.getValue((IObjectPK)pk, sic);
        Timestamp lastUpdateTime = info.getLastUpdateTime();
        String lastUpdateUserID = info.getLastUpdateUser().getId().toString();
        if (info == null) {
            return false;
        }
        if (BgViewHelper.checkHasRoll(info)) {
            info.setState(BgFormStateEnum.RollEdited);
        } else {
            if (!info.getState().equals((Object)BgFormStateEnum.AdjustApproving)) {
                return false;
            }
            info.setState(BgFormStateEnum.Adjusted);
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgFormFactory.getLocalInstance(ctx).update((IObjectPK)pk, (CoreBaseInfo)info);
            BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBg_bgForm set FLastUpdateTime=?,FLastUpdateUserID =? where fid =?", (Object[])new Object[]{lastUpdateTime, lastUpdateUserID, info.getId().toString()});
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _submitAdjustChangeState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IBgForm iBgForm = null;
        BgFormInfo info = null;
        iBgForm = BgFormFactory.getLocalInstance(ctx);
        if (iBgForm == null) {
            return false;
        }
        info = (BgFormInfo)iBgForm.getValue("select state,lastUpdateTime,lastUpdateUser.id where id = '" + pk + "'");
        Timestamp lastUpdateTime = info.getLastUpdateTime();
        String lastUpdateUserID = info.getLastUpdateUser().getId().toString();
        if (info == null) {
            return false;
        }
        if (!info.getState().equals((Object)BgFormStateEnum.Adjusted) && !info.getState().equals((Object)BgFormStateEnum.RollEdited)) {
            return false;
        }
        info.setState(BgFormStateEnum.AdjustApproving);
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgFormFactory.getLocalInstance(ctx).update((IObjectPK)pk, (CoreBaseInfo)info);
            try {
                BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBg_bgForm set FLastUpdateTime=?,FLastUpdateUserID =? where fid =?", (Object[])new Object[]{lastUpdateTime, lastUpdateUserID, info.getId().toString()});
                BgDataSynStateBizHelper.updateDataStateByFormID(ctx, id.toString(), true, "OPERATOT_SUBMIT");
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return true;
    }

    private Map _queryBgFormByOrgUnitId(Context ctx, BgFormInfo bgFormInfo, Object[] orgIds, SelectorItemCollection selector) throws BOSException, EASBizException {
        HashMap<String, BgFormInfo> bgFormMap = new HashMap<String, BgFormInfo>();
        IBgForm ibgForm = BgFormFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.root.id", (Object)bgFormInfo.getBgTemplate().getRootId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.Id", (Object)bgFormInfo.getBgScheme().getId().toString(), CompareType.EQUALS));
        HashSet<Object> orgIdSet = new HashSet<Object>();
        for (int i = 0; i < orgIds.length; ++i) {
            orgIdSet.add(orgIds[i]);
        }
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", orgIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bgPeriod.id", (Object)bgFormInfo.getBgPeriod().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)bgFormInfo.getCurrency().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgVersion.id", (Object)bgFormInfo.getBgVersion().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("processType", (Object)bgFormInfo.getProcessType().getValue(), CompareType.EQUALS));
        HashSet<Integer> stateSet = new HashSet<Integer>();
        stateSet.add(5);
        stateSet.add(15);
        filter.getFilterItems().add(new FilterItemInfo("state", stateSet, CompareType.NOTINCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"select fadjustId from T_MBg_bgform where fstate in ( 4 , 35 , 6 , 101 ) and fid <> fadjustid", CompareType.NOTINNER));
        viewInfo.setFilter(filter);
        viewInfo.setSelector(selector);
        BgFormCollection bgFormCol = ibgForm.getBgFormCollection(viewInfo);
        for (int i = 0; i < bgFormCol.size(); ++i) {
            bgFormMap.put(bgFormCol.get(i).getOrgUnit().getId().toString(), bgFormCol.get(i));
        }
        return bgFormMap;
    }

    @Override
    protected Map _queryBgFormByOrgUnitId(Context ctx, BgFormInfo bgFormInfo, Object[] orgIds) throws BOSException, EASBizException {
        return this._queryBgFormByOrgUnitId(ctx, bgFormInfo, orgIds, this.getSicForView());
    }

    private SelectorItemCollection getSicForView() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("adjustMapData");
        sic.add("dataSource");
        sic.add("bgScheme.id");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.root.Id");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("bgPeriod.id");
        sic.add("state");
        sic.add("adjust.id");
        sic.add("number");
        sic.add("name");
        sic.add("data");
        sic.add("orgUnit.id");
        sic.add("orgUnit.number");
        sic.add("orgUnit.name");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.periodType");
        sic.add("bgRollPeriod.id");
        sic.add("bgRollPeriod.name");
        sic.add("bgRollPeriod.number");
        sic.add("bgRollPeriod.periodType");
        sic.add("measureUnit.coefficient");
        sic.add("bgTemplate.formType");
        sic.add("entries.dimensionData");
        sic.add("entries.dimensionStyle");
        sic.add("entries.rollMethod");
        return sic;
    }

    @Override
    protected BgPeriodCollection _getPeriodColForView(Context ctx, String bgFormId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("entries.dimensionData");
        sic.add("entries.dimensionStyle");
        sic.add("orgUnit.id");
        sic.add("orgUnit.number");
        sic.add("orgUnit.name");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.periodType");
        BgFormInfo formInfo = BgFormFactory.getLocalInstance(ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId), sic);
        Set<String> periodNumSet = this.getPeriodDimension(ctx, formInfo);
        IBgPeriod iPeriod = BgPeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo periodFilter = new FilterInfo();
        periodFilter.getFilterItems().add(new FilterItemInfo("number", periodNumSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(periodFilter);
        entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("name"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("number"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("longNumber"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("beginDate"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("endDate"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("year"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("month"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("halfyear"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("week"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("quarter"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("periodType"));
        SorterItemInfo sort2 = new SorterItemInfo("longNumber");
        sort2.setSortType(SortType.ASCEND);
        entityViewInfo.getSorter().add(sort2);
        return iPeriod.getBgPeriodCollection(entityViewInfo);
    }

    private Set<String> getPeriodDimension(Context ctx, BgFormInfo bgFormInfo) throws EASBizException, BOSException {
        IMbgViewManager iMbgViewManager = this.parseMBGDimensionData(ctx, bgFormInfo);
        if (iMbgViewManager == null) {
            return null;
        }
        HashSet<String> periodNumSet = new HashSet<String>();
        List dimensions = null;
        BgDimensionInfo bgPeriodDimension = null;
        for (int sheetIndex = 0; sheetIndex < iMbgViewManager.getSheetManagers().size(); ++sheetIndex) {
            dimensions = iMbgViewManager.getSheetManagers().get(sheetIndex).getDimensionManager().getDimension();
            for (int dimensionIndex = 0; dimensionIndex < dimensions.size(); ++dimensionIndex) {
                if (!MBGLayoutConstants.BG_PERIOD.equals(((BgDimensionInfo)dimensions.get(dimensionIndex)).getNumber())) continue;
                bgPeriodDimension = (BgDimensionInfo)dimensions.get(dimensionIndex);
                for (int memberIndex = 0; memberIndex < bgPeriodDimension.getMember().size(); ++memberIndex) {
                    periodNumSet.add(((BgDimensionMember)bgPeriodDimension.getMember().get(memberIndex)).getNumber());
                }
            }
        }
        return periodNumSet;
    }

    private IMbgViewManager parseMBGDimensionData(Context ctx, BgFormInfo bgFormInfo) throws EASBizException, BOSException {
        String bgFormOrgUnitNumber = bgFormInfo.getOrgUnit().getNumber();
        HashSet<String> orgNums = new HashSet<String>();
        orgNums.add(bgFormOrgUnitNumber);
        Map res = MBGFormFacadeFactory.getLocalInstance(ctx).getBgViewManagers(bgFormInfo.getId().toString(), null, orgNums, null, null, false);
        if (res == null) {
            return null;
        }
        HashMap<String, IMbgViewManager> newRes = new HashMap<String, IMbgViewManager>();
        for (Map.Entry entry : res.entrySet()) {
            newRes.put(((FullOrgUnitInfo)entry.getKey()).getNumber().toString(), (IMbgViewManager)entry.getValue());
        }
        if (!newRes.containsKey(bgFormOrgUnitNumber)) {
            return null;
        }
        return (IMbgViewManager)newRes.get(bgFormOrgUnitNumber);
    }

    @Override
    protected Map _adjustBgForm(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (id == null) {
            return resultMap;
        }
        IObjectPK pk = this._checkFormIsAdjust(ctx, id);
        if (pk == null) {
            pk = BgFormFactory.getLocalInstance(ctx).cloneAdjust(id, BgFormDataSourceEnum.ADJUST, BgFormStateEnum.Adjusted);
            resultMap.put("pk", pk);
            resultMap.put("isNewAdjustForm", Boolean.TRUE);
        } else {
            if (this.checkInProInst(ctx, pk.toString())) {
                throw new BgAdjustException(BgAdjustException.SUBMITINWORK);
            }
            resultMap.put("pk", pk);
            resultMap.put("isNewAdjustForm", Boolean.FALSE);
        }
        return resultMap;
    }

    private boolean checkInProInst(Context ctx, String id) throws BOSException {
        boolean result = false;
        ProcessInstInfo[] procInsts = EnactmentServiceFactory.createEnactService((Context)ctx).getProcessInstanceByHoldedObjectId(id);
        for (int i = 0; i < procInsts.length; ++i) {
            if (!procInsts[i].getState().startsWith("open")) continue;
            result = true;
            break;
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _auditFormGatherCourse(Context ctx, BOSUuid id, BOSUuid auditorId, String idea, String orgUnitId) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        if (auditorId == null) {
            auditorId = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        }
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pst = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer update = new StringBuffer();
        sql.append("select FID from T_MBg_BgForm where FID=?");
        update.append("update T_MBg_BgForm set FData=?, FState=?, FAuditorID=?, FAuditedTime=?, FLastUpdateUserId = ?, FLastUpdateTime = ? where FID=?");
        BgFormInfo bgFormInfo = null;
        Book book = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, id.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                bgFormInfo = BgViewServerHelper.getBgFormInfo(conn, id, true);
                book = bgFormInfo.getBook();
                BgNFSHelper.disableUndo(book);
                BgNFSHelper.disableCal(book);
                BgNFSHelper.updateAliasAudit(book);
                bgFormInfo.setBook(book);
                pst = conn.prepareStatement(update.toString());
                pst.setBytes(1, bgFormInfo.getZipData());
                pst.setInt(2, 2);
                pst.setString(3, auditorId.toString());
                pst.setTimestamp(4, timestamp);
                pst.setString(5, auditorId.toString());
                pst.setTimestamp(6, timestamp);
                pst.setString(7, id.toString());
                pst.executeUpdate();
                this._submitAuditIdea(ctx, id, auditorId, BgAuditIdeaEnum.AUDITPASS, idea);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"Error: ", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
                catch (Exception ex3) {
                    throw new BOSException((Throwable)ex3);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst);
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(pst);
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return true;
    }

    @Override
    protected boolean _submitFormWorkNextPerson(Context ctx, IObjectValue editData) throws BOSException, EASBizException {
        if (editData != null && editData.get(editData.getPKField()) != null) {
            ArrayList<String> billIds = new ArrayList<String>();
            billIds.add(editData.getPKField());
            new BizDataOtherCheckUtils().beforeCheck(ctx, billIds, -1);
            return true;
        }
        return false;
    }

    @Override
    protected TreeModel _getFullTreeModel(Context ctx, String OrgId, OrgViewType orgViewType) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)OrgId)) {
            OrgId = ContextUtil.getCurrentCostUnit((Context)ctx).getId().toString();
        }
        if (orgViewType == null) {
            orgViewType = OrgViewType.COSTCENTER;
        }
        String treeid = NewOrgViewHelper.convert2TreeId((OrgViewType)orgViewType);
        OrgStructureInfo selectNode = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo("select id, longnumber ,unit.id,unit.number,unit.longnumber,unit.name where unit.id = '" + OrgId + "' and tree.id = '" + NewOrgViewHelper.convert2TreeId((OrgViewType)orgViewType) + "'");
        DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode((Object)selectNode);
        DefaultKingdeeTreeNode node = this.getChildNode(ctx, orgViewType, treeid, rootNode);
        node.setTextColor(Color.BLACK);
        this.buildTreeModel(ctx, node);
        return new DefaultTreeModel((TreeNode)node);
    }

    private void buildTreeModel(Context ctx, DefaultKingdeeTreeNode node) throws EASBizException, BOSException {
        int count = node.getChildCount();
        for (int index = 0; index < count; ++index) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(index);
            childNode.setTextColor(Color.BLACK);
            OrgStructureInfo orginfo = (OrgStructureInfo)childNode.getUserObject();
            if (orginfo.getUnit().isIsLeaf()) continue;
            this.getChildNode(ctx, null, null, childNode);
            this.buildTreeModel(ctx, childNode);
        }
    }

    private DefaultKingdeeTreeNode getChildNode(Context ctx, OrgViewType orgViewType, String treeid, DefaultKingdeeTreeNode node) throws EASBizException, BOSException {
        if (orgViewType == null) {
            orgViewType = OrgViewType.COSTCENTER;
        }
        if (StringUtils.isEmpty((String)treeid)) {
            treeid = NewOrgViewHelper.convert2TreeId((OrgViewType)orgViewType);
        }
        return NewOrgViewFacadeFactory.getLocalInstance((Context)ctx).getViewDirectChildNodesByMultiCondition(orgViewType, treeid, true, true, node, true, true, null, null, null);
    }

    @Override
    protected Map _rollBgForm(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        return null;
    }

    private RollRuleInfo getRollRule(Context ctx, BOSUuid bgTemplateRootId) throws BOSException {
        RollTemplateCollection col = RollTemplateFactory.getLocalInstance(ctx).getRollTemplateCollection("select id, rollRule.id, rollRule.scene where bgTemplate.id = '" + bgTemplateRootId + "'");
        if (col != null && !col.isEmpty()) {
            return col.get(0).getRollRule();
        }
        return null;
    }

    private SelectorItemCollection getRollSic(Context ctx) throws InvalidDAOMetaDataException {
        SelectorItemCollection rollSic = new SelectorItemCollection();
        rollSic.add("bgRollPeriod.number");
        rollSic.add("bgPeriod.number");
        rollSic.add("bgPeriod.periodType");
        rollSic.add("bgPeriod.beginDate");
        rollSic.add("bgPeriod.endDate");
        rollSic.add("bgPeriod.year");
        rollSic.add("bgScheme.dateFrom");
        rollSic.add("bgScheme.dateTo");
        rollSic.add("orgUnit.number");
        rollSic.add("orgUnit.name");
        rollSic.add("currency.name");
        rollSic.add("currency.number");
        rollSic.add("bgTemplate.id");
        rollSic.add("bgTemplate.number");
        rollSic.add("bgTemplate.name");
        rollSic.add("bgTemplate.root");
        rollSic.add("bgVersion.id");
        rollSic.add("bgVersion.number");
        rollSic.add("bgVersion.name");
        rollSic.add("bgVersion.longNumber");
        rollSic.add("bgVersion.versionId");
        return rollSic;
    }

    @Override
    protected boolean _submitAntiAudit(Context ctx, BOSUuid bgFormId, BOSUuid bgAntiAuditOrgId, BOSUuid bgAntiUserId, String msg) throws BOSException, EASBizException {
        if (bgFormId == null) {
            return false;
        }
        String _userId = null;
        _userId = bgAntiAuditOrgId == null ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : bgAntiUserId.toString();
        IMutexServiceControl iMC = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        if (!iMC.requestObjIDForUpdate(bgFormId.toString(), _userId)) {
            throw new BgCommonException(BgCommonException.LOCK);
        }
        Timestamp _timestamp = new Timestamp(System.currentTimeMillis());
        Connection conn = null;
        PreparedStatement pst = null;
        StringBuffer update = new StringBuffer();
        update.append("update T_MBg_BgForm set FState=?, FAuditorID=?, FAuditedTime=?, FLastUpdateUserId = ?, FLastUpdateTime = ? where FID=?");
        BgFormInfo bgFormInfo = null;
        boolean isAntiAuditToFormerState = false;
        BizDataControlUtils utils = new BizDataControlUtils(ctx);
        try {
            conn = this.getConnection(ctx);
            bgFormInfo = BgViewServerHelper.getBgFormInfo(conn, bgFormId, false);
            pst = conn.prepareStatement(update.toString());
            if (isAntiAuditToFormerState) {
                pst.setInt(1, 1);
            } else if (BgNFSHelper.checkHasAdjust((IObjectValue)bgFormInfo)) {
                pst.setInt(1, 4);
            } else {
                pst.setInt(1, 1);
            }
            pst.setString(2, "");
            pst.setTimestamp(3, null);
            pst.setString(4, _userId);
            pst.setTimestamp(5, _timestamp);
            pst.setString(6, bgFormId.toString());
            pst.executeUpdate();
            this._submitAuditIdea(ctx, bgFormId, bgAntiUserId, BgAuditIdeaEnum.UNAUDIT, msg);
            utils.recoverAudOrgUnit(bgFormId, bgAntiAuditOrgId, bgAntiUserId, 1, 1, false, msg, null);
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"Error: ", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst, (Connection)conn);
                iMC.releaseObjIDForUpdate(bgFormId.toString());
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pst, (Connection)conn);
        iMC.releaseObjIDForUpdate(bgFormId.toString());
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _auditForm(Context ctx, BOSUuid bgFormId, BOSUuid bgAuditOrgId, BOSUuid bgUserId, String msg) throws BOSException, EASBizException {
        if (bgFormId == null) {
            return false;
        }
        IMutexServiceControl iMC = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        iMC.releaseObjIDForUpdate(bgFormId.toString());
        String _userId = null;
        _userId = bgUserId == null ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : bgUserId.toString();
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pst = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer update = new StringBuffer();
        sql.append("select FID from T_MBg_BgForm where FID=?");
        update.append("update T_MBg_BgForm set FData=?, FState=?, FAuditorID=?, FAuditedTime=?, FLastUpdateUserId = ?, FLastUpdateTime = ?, FStateBeforeAudit = ? where FID=?");
        BgFormInfo bgFormInfo = null;
        BizDataControlUtils utils = new BizDataControlUtils(ctx);
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgFormId.toString());
            rst = pstmt.executeQuery();
            Book book = null;
            if (rst.next()) {
                bgFormInfo = BgViewServerHelper.getBgFormInfo(conn, bgFormId, true);
                if (bgFormInfo.getZipData() != null && bgFormInfo.getZipData().length > 0) {
                    book = bgFormInfo.getBook();
                    BgNFSHelper.disableUndo(book);
                    BgNFSHelper.disableCal(book);
                    BgNFSHelper.updateAliasAudit(book);
                    bgFormInfo.setBook(book);
                }
                pst = conn.prepareStatement(update.toString());
                pst.setBytes(1, bgFormInfo.getZipData());
                pst.setInt(2, 2);
                pst.setString(3, _userId);
                pst.setTimestamp(4, timestamp);
                pst.setString(5, _userId);
                pst.setTimestamp(6, timestamp);
                pst.setInt(7, bgFormInfo.getState().getValue());
                pst.setString(8, bgFormId.toString());
                utils.updateAudOrgUnit(bgFormInfo.getId(), bgAuditOrgId, BOSUuid.read((String)_userId), 1, 9, msg, null, new BgFormStateEnum[]{BgFormStateEnum.Edited, BgFormStateEnum.Certificate});
                this._submitAuditIdea(ctx, bgFormId, bgUserId, BgAuditIdeaEnum.AUDITPASS, msg);
                pst.executeUpdate();
                SQLUtils.cleanup((Statement)pst);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"Error: ", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
                catch (Exception ex3) {
                    throw new BOSException((Throwable)ex3);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst);
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(pst);
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return true;
    }

    @Override
    protected List _adjustCheck(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        return BgFormFactory.getLocalInstance(ctx).adjustCheck(billID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _isEditForm(Context ctx, VerifyFormParam param) throws BOSException, EASBizException {
        List<String> ids = param.getSelectedIdValues();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        try {
            if (param.getParentBgOrgUnitId() != null && param.getCurrOrgUnitId() != null && BgOrgUnitFactory.getLocalInstance(ctx).checkIsVirtual(param.getParentBgOrgUnitId(), param.getCurrOrgUnitId())) {
                boolean bl = false;
                return bl;
            }
            if (ids != null) {
                boolean canEdit = true;
                Set<String> lockSet = MBgCheckHelper.requestMutex(ctx, ids, true);
                Iterator<String> it = ids.iterator();
                while (it.hasNext()) {
                    if (lockSet == null || !lockSet.contains(it.next())) continue;
                    it.remove();
                    canEdit = false;
                }
                if (!canEdit) {
                    boolean bl = canEdit;
                    return bl;
                }
                if (param.getOrgViewInfo() != null && BgFormFactory.getLocalInstance(ctx).checkFormOrgUnitDisable(ids, param.getOrgViewInfo().getId().toString())) {
                    boolean bl = false;
                    return bl;
                }
            }
            if (param.getSelectedKeyValue() != null) {
                String checkFinalizedbyForm;
                if ("EDIT".equals(param.getOprtState()) && !StringUtils.isEmpty((String)(checkFinalizedbyForm = BgFinalizedFacadeFactory.getLocalInstance(ctx).checkFinalizedbyForm(param.getSelectedKeyValue(), "EDIT")))) {
                    boolean bl = false;
                    return bl;
                }
                if (param.getActionPK() != null && param.getMetaDataPK() != null && param.getOrgPK() != null) {
                    PermissionFactory.getLocalInstance((Context)ctx).checkDataPermission((IObjectPK)new ObjectUuidPK(userId), param.getOrgPK(), param.getMetaDataPK(), param.getActionPK(), (IObjectPK)new ObjectUuidPK(param.getSelectedKeyValue()));
                }
                PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)new ObjectUuidPK(userId), param.getOrgPK(), "mbg_form04_update");
            }
            if (param.getSelectCreatorId() != null && BgParamNHelper.isControlDDLOption((Context)ctx) && !ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString().equals(param.getSelectCreatorId())) {
                boolean checkFinalizedbyForm = false;
                return checkFinalizedbyForm;
            }
            if (param.getBgSchemeInfo() != null && param.getBgSchemeInfo().getId() != null) {
                BgSchemeFactory.getLocalInstance(ctx).checkFilling(param.getBgSchemeInfo().getId().toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)"_isEditForm error : ", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            MBgCheckHelper.releaseMutex(ctx, ids);
        }
        return true;
    }

    @Override
    protected boolean _unionReportWork(Context ctx, String id, String auditorId) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        BgFormInfo bgFormInfo = BgFormFactory.getLocalInstance(ctx).getBgFormInfo("select bgScheme.id,orgUnit.id where id = '" + id + "'");
        String _userId = null;
        _userId = StringUtils.isEmpty((String)auditorId) ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : auditorId;
        HashMap<String, String> auditParams = new HashMap<String, String>();
        auditParams.put("AUDIT_SCHEME_ID", bgFormInfo.getBgScheme().getId().toString());
        auditParams.put("AUDIT_ORGUNIT_ID", bgFormInfo.getOrgUnit().getId().toString());
        auditParams.put("AUDIT_USER_ID", _userId);
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(id);
        Map result = BgNFormFacadeFactory.getLocalInstance(ctx).batchUnionReport(ids, auditParams);
        if (result != null && !result.isEmpty()) {
            Iterator iterator;
            Map checkmap = (Map)result.get("CHECK_RESULT_STATE");
            if (checkmap != null && !checkmap.isEmpty() && (iterator = checkmap.values().iterator()).hasNext()) {
                String[] tmpStrs = (String[])iterator.next();
                throw new BgFormException(BgFormException.REPORTERRORSTATEMSG, new Object[]{tmpStrs[4], tmpStrs[0]});
            }
            checkmap = (Map)result.get("CHECK_RESULT_ADJUST");
            if (checkmap != null && !checkmap.isEmpty() && (iterator = checkmap.values().iterator()).hasNext()) {
                String[] tmpStrs = (String[])iterator.next();
                throw new BgFormException(BgFormException.REPORTERRORADJUSTMSG, new Object[]{tmpStrs[4], tmpStrs[0]});
            }
            checkmap = (Map)result.get("CHECK_RESULT_PROCESSTYPE");
            if (checkmap != null && !checkmap.isEmpty() && (iterator = checkmap.values().iterator()).hasNext()) {
                String[] tmpStrs = (String[])iterator.next();
                throw new BgFormException(BgFormException.CHECKUNIONREPORT, new Object[]{tmpStrs[4], tmpStrs[0]});
            }
            if (result.containsKey("CHECK_RESULT_BGTEMPLATE_SEQUENCESET")) {
                checkmap = (Map)result.get("CHECK_RESULT_BGTEMPLATE_SEQUENCESET");
                if (checkmap != null && !checkmap.isEmpty() && (iterator = checkmap.values().iterator()).hasNext()) {
                    String[] tmpStrs = (String[])iterator.next();
                    String otherMsg = tmpStrs[5];
                    if (otherMsg.indexOf("#") > 0) {
                        String[] otherStr = otherMsg.split("#");
                        Object[] msgArr = new String[2 + otherStr.length];
                        msgArr[0] = tmpStrs[4];
                        msgArr[1] = tmpStrs[0];
                        for (int i = 0; i < otherStr.length; ++i) {
                            msgArr[i + 2] = otherStr[i];
                        }
                        throw new BgFormException(BgFormException.CHECKBGTEMPLATE_SEQUENCE, msgArr);
                    }
                    throw new BgFormException(BgFormException.AUDITBYBGTEMPLATESEQUENCESET, new Object[]{tmpStrs[4], tmpStrs[0], tmpStrs[5]});
                }
            } else if (result.containsKey("CHECK_RESULT_BGTEMPLATE_SEQUENCESET_EX") && (checkmap = (Map)result.get("CHECK_RESULT_BGTEMPLATE_SEQUENCESET_EX")) != null && !checkmap.isEmpty() && (iterator = checkmap.values().iterator()).hasNext()) {
                String[] tmpStrs = (String[])iterator.next();
                String otherMsg = tmpStrs[5];
                if (otherMsg.indexOf("#") > 0) {
                    String[] otherStr = otherMsg.split("#");
                    Object[] msgArr = new String[2 + otherStr.length];
                    msgArr[0] = tmpStrs[4];
                    msgArr[1] = tmpStrs[0];
                    for (int i = 0; i < otherStr.length; ++i) {
                        msgArr[i + 2] = otherStr[i];
                    }
                    throw new BgFormException(BgFormException.CHECKBGTEMPLATE_SEQUENCE_EX, msgArr);
                }
                throw new BgFormException(BgFormException.AUDITBYBGTEMPLATESEQUENCESET, new Object[]{tmpStrs[4], tmpStrs[0], tmpStrs[5]});
            }
        }
        return true;
    }

    @Override
    protected void _saveGatherInfos(Context ctx, List gatherInfos) throws BOSException, EASBizException {
        BgFacadeHelper.saveGatherInfos(ctx, gatherInfos);
    }
}

